/*

Reklez's Player Info Textdraw [FS]
Author: Reklez
(c), 2012

*/

#include <a_samp>

new Float:health,
	Float:armour,
    Text:PHealth[MAX_PLAYERS],
    Text:PArmour[MAX_PLAYERS],
    Text:PPing[MAX_PLAYERS],
    Text:PCash[MAX_PLAYERS],
    Text:PScore[MAX_PLAYERS];

#if defined FILTERSCRIPT

#else

public OnFilterScriptInit()
{
	print("\nReklez's Playerinfo Textdraw [FS], (c) 2012\n");
	return 1;
}

public OnFilterScriptExit()
{
	print("\nReklez's Playerinfo Textdraw [FS] Unloaded, (c) 2012\n");
	return 1;
}

#endif

public OnPlayerConnect(playerid)
{
	PHealth[playerid] = TextDrawCreate(9.000000,276.000000,"Health:");
	PArmour[playerid] = TextDrawCreate(9.000000,291.000000,"Armour:");
	PPing[playerid] = TextDrawCreate(11.000000,309.000000,"Ping:");
	PScore[playerid] = TextDrawCreate(9.000000,258.000000,"Score:");
	PCash[playerid] = TextDrawCreate(8.000000,242.000000,"Cash:");
	TextDrawAlignment(PHealth[playerid],0);
	TextDrawAlignment(PArmour[playerid],0);
	TextDrawAlignment(PPing[playerid],0);
	TextDrawAlignment(PScore[playerid],0);
	TextDrawAlignment(PCash[playerid],0);
	TextDrawBackgroundColor(PCash[playerid],0x000000ff);
	TextDrawFont(PCash[playerid],1);
	TextDrawLetterSize(PCash[playerid],0.599999,1.400000);
	TextDrawColor(PCash[playerid],0x00ff00ff);
	TextDrawSetOutline(PCash[playerid],1);
	TextDrawFont(PHealth[playerid],1);
	TextDrawLetterSize(PHealth[playerid],0.599999,1.500000);
	TextDrawFont(PArmour[playerid],1);
	TextDrawLetterSize(PArmour[playerid],0.599999,1.800000);
	TextDrawFont(PPing[playerid],1);
	TextDrawLetterSize(PPing[playerid],0.599999,1.800000);
	TextDrawFont(PScore[playerid],1);
	TextDrawLetterSize(PScore[playerid],0.599999,1.600000);
	TextDrawColor(PHealth[playerid],0xff0000ff);
	TextDrawColor(PArmour[playerid],0xffffffff);
	TextDrawColor(PPing[playerid],0xffff0099);
	TextDrawColor(PScore[playerid],0x00ffff99);
	TextDrawSetOutline(PHealth[playerid],1);
	TextDrawSetOutline(PArmour[playerid],1);
	TextDrawSetOutline(PPing[playerid],1);
	TextDrawSetOutline(PScore[playerid],1);
	TextDrawSetShadow(PHealth[playerid],1);
	TextDrawSetShadow(PArmour[playerid],1);
	TextDrawSetShadow(PPing[playerid],1);
	TextDrawSetShadow(PScore[playerid],1);
	return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
	TextDrawHideForPlayer(playerid, PHealth[playerid]);
	TextDrawHideForPlayer(playerid, PArmour[playerid]);
	TextDrawHideForPlayer(playerid, PPing[playerid]);
	TextDrawHideForPlayer(playerid, PScore[playerid]);
	TextDrawHideForPlayer(playerid, PCash[playerid]);
	return 1;
}

public OnPlayerSpawn(playerid)
{
	TextDrawShowForPlayer(playerid, PHealth[playerid]);
	TextDrawShowForPlayer(playerid, PArmour[playerid]);
	TextDrawShowForPlayer(playerid, PPing[playerid]);
	TextDrawShowForPlayer(playerid, PScore[playerid]);
	TextDrawShowForPlayer(playerid, PCash[playerid]);
	return 1;
}

public OnPlayerUpdate(playerid)
{
	new InfoString[300];
	if(IsPlayerConnected(playerid))
	{
		if(IsPlayerNPC(playerid)) return 0;
		GetPlayerHealth(playerid, health);
		GetPlayerArmour(playerid, armour);
		new ping = GetPlayerPing(playerid);
		new score = GetPlayerScore(playerid);
		new cash = GetPlayerMoney(playerid);
		format(InfoString, sizeof(InfoString), "Health: ~w~%.1f", health);
		TextDrawSetString(PHealth[playerid], InfoString);
		format(InfoString, sizeof(InfoString), "Armour: ~w~%.1f", armour);
		TextDrawSetString(PArmour[playerid], InfoString);
		format(InfoString, sizeof(InfoString), "Ping: ~w~%d", ping);
		TextDrawSetString(PPing[playerid], InfoString);
		format(InfoString, sizeof(InfoString), "Score: ~w~%d", score);
		TextDrawSetString(PScore[playerid], InfoString);
		format(InfoString, sizeof(InfoString), "Cash: ~w~%d", cash);
		TextDrawSetString(PCash[playerid], InfoString);
	}
	return 1;
}
