
#include "stdafx.h"
#include "stdio.h"





//***********************************************
//GLOBAL VC:TRAFFIC DATA
//***********************************************


//DO ENTER NEW MEMBERS ONLY AT THE BOTTOM TO PRESERVE EXISTING DATA ORDER
struct TEMPDATA
{
	DWORD temp1;
	DWORD temp2;
	DWORD temp3;
	DWORD temp4;
	TEMPDATA()
	{
		temp1 = 0;
		temp2 = 0;
		temp3 = 0;
		temp4 = 0;
	}
};

float pedTrafficTable[24] = {1.0f, 1.0f, 0.9f, 0.8f, 0.5f, 0.2f, 0.4f, 0.7f, 
							 2.0f, 1.5f, 0.8f, 0.7f, 1.5f, 1.25f, 0.8f, 0.8f, 
							 1.25f, 2.0f, 1.0f, 0.8f, 0.8f, 0.8f, 0.8f, 0.9f};


//DO ENTER NEW MEMBERS ONLY AT THE BOTTOM TO PRESERVE EXISTING DATA ORDER
struct PEDS_LIFETIMEDATA
{
	DWORD extPedLimit;
	DWORD intPedLimit;
	DWORD densityAdder;
	float absoluteMaxDespawnRangeOnscreen;
	float normalMaxDespawnRangeOnscreen;
	float maxRangeDespawnOffscreen;	//note also max offscreen spawn range
	float gangerDespawnRangeAdder;
	DWORD pedsDespawnTime;
	DWORD copsDespawnTime;
	float pedsDrawDist;
	float maxSpawnRangeOnscreen;
	float minSpawnRangeOnscreen;
	float minSpawnRangeOffscreen;
	float spawnOffscreenRingSize;
	DWORD trafficTablePtr;
	DWORD padding1;
	DWORD padding2;

	PEDS_LIFETIMEDATA()
	{
		extPedLimit						= 0xF;
		intPedLimit						= 0x18;
		densityAdder					= 0;
		absoluteMaxDespawnRangeOnscreen	= 65.0f;
		normalMaxDespawnRangeOnscreen	= 51.0f;
		maxRangeDespawnOffscreen		= 25.0f;
		gangerDespawnRangeAdder			= 30.0f;
		pedsDespawnTime					= 4000;
		copsDespawnTime					= 10000;
		pedsDrawDist					= 60.0f;
		maxSpawnRangeOnscreen			= 50.0f;
		minSpawnRangeOnscreen			= 40.0f;
		minSpawnRangeOffscreen			= 15.0f;
		spawnOffscreenRingSize			= 10.0f;
		trafficTablePtr = (DWORD) pedTrafficTable;
		padding1  = 0;
		padding2  = 0;
	}
};

//DO ENTER NEW MEMBERS ONLY AT THE BOTTOM TO PRESERVE EXISTING DATA ORDER
struct GANGDATA
{
	float minSpawned;
	float maxSpawned;
	WORD soloProb;
	WORD walkProb;
	WORD chatProb;
	WORD unused1;
	DWORD padding1;
	DWORD padding2;
	DWORD padding3;
	DWORD padding4;
	DWORD padding5;
	DWORD padding6;
	DWORD padding7;
	DWORD padding8;
	DWORD padding9;
	DWORD padding10;
	DWORD padding11;
	DWORD padding12;

	GANGDATA()
	{
		minSpawned = 3.0;
		maxSpawned = 5.0;
		soloProb = 0;
		walkProb = 333;
		chatProb = 667;
	}
};

GANGDATA gangerTable[9];


float vehicleTrafficTable[24] = {1.0f, 1.0f, 0.9f, 0.8f, 0.5f, 0.2f, 0.4f, 0.7f, 
							     2.0f, 1.5f, 0.8f, 0.7f, 1.5f, 1.25f, 0.8f, 0.8f, 
							     1.25f, 2.0f, 1.0f, 0.8f, 0.8f, 0.8f, 0.8f, 0.9f};
float vehicleNodeSpeedTable[4] = {0.5f, 1.0f, 2.0f, 4.0f};

//DO ENTER NEW MEMBERS ONLY AT THE BOTTOM TO PRESERVE EXISTING DATA ORDER
struct VEHICLEDATA
{
	DWORD vehLimit;
	float despawnRangeOnscreen;
	float despawnRangeOffscreen;
	float spawnRangeOnscreen;
	float lodThreshold;
	float forBehaviourCorrection;
	int densityAdder;
	float wheelVisibRangeOverride;
	DWORD trafficTablePtr;
	DWORD nodeSpeedTablePtr;
	DWORD padding1;
	DWORD padding2;

	VEHICLEDATA()
	{
		vehLimit				= 0x7;
		despawnRangeOnscreen	= 120.0f;
		despawnRangeOffscreen	= 40.0f;
		spawnRangeOnscreen		= 110.0f;
		lodThreshold			= 70.0f;
		forBehaviourCorrection	= 40.0f;
		densityAdder			= 0;
		wheelVisibRangeOverride	= 70.0f;
		trafficTablePtr = (DWORD) vehicleTrafficTable;
		nodeSpeedTablePtr = (DWORD) vehicleNodeSpeedTable;
		padding1  = 0;
		padding2  = 0;
	}
};




//DO ENTER NEW MEMBERS ONLY AT THE BOTTOM TO PRESERVE EXISTING DATA ORDER
struct DRIVERSHOTPROBS
{
	WORD ignore;
	WORD freeze;
	WORD escape;
	WORD flee;
	WORD frenzy;

	DRIVERSHOTPROBS()
	{
		ignore = 0;
		freeze = 0;
		escape = 1000;
		flee = 0;
		frenzy = 0;
	}
};

DWORD driverShotReactions[6];

//DO ENTER NEW MEMBERS ONLY AT THE BOTTOM TO PRESERVE EXISTING DATA ORDER
struct DRIVERBEHAVIOURDATA
{
	float minCruiseSpeed;
	float maxCruiseSpeed;
	BYTE rushSpeedProb;
	BYTE rushSpeedAdder;
	WORD emergencyExitProb;
	float fleeSpeedMult;
	float driveThruBase;
	float frenzySpeedMult;
	float minCarHealth;
	float driveThruDeviation;
	float driveThruMax;
	DWORD driverShotProbs;
	DWORD padding2;
	DWORD padding3;
	DWORD padding4;
	DWORD padding5;
	DWORD padding6;
	DWORD padding7;

	DRIVERBEHAVIOURDATA()
	{
		minCruiseSpeed = 9.0f;
		maxCruiseSpeed = 14.0f;
		rushSpeedProb = 6;
		rushSpeedAdder = 10;
		emergencyExitProb = 1000;
		fleeSpeedMult = 1.5f;
		driveThruBase = 100000.0f;
		frenzySpeedMult = 0.8f;
		minCarHealth = -1000.0f;
		driveThruDeviation = 1.0f;
		driveThruMax = 1.0;
		driverShotProbs = (DWORD) new DRIVERSHOTPROBS();
		padding2 = 0;
		padding3 = 0;
		padding4 = 0;
		padding5 = 0;
		padding6 = 0;
		padding7 = 0;
	}
};

DRIVERBEHAVIOURDATA driverBehaviourTable[23];
int lineCountToPedTypeID[17] = {4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21};
float carClassSpeedMult[21] = {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
							   1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};


//DO ENTER NEW MEMBERS ONLY AT THE BOTTOM TO PRESERVE EXISTING DATA ORDER
struct VC_TRAFFICGLOBALDATA
{
	DWORD reserved1;
	DWORD reserved2;
	DWORD reserved3;
	TEMPDATA* temp;
	PEDS_LIFETIMEDATA* pedData;
	VEHICLEDATA* vehData;
	DWORD driverBehaviourTablePtr;
	DWORD carClassSpeeds;
	DWORD driverShotReactionsPtr;
	DWORD gangerTablePtr;
	float maxVehicleSpeedMultiplier;
	DWORD padding1;
	DWORD padding2;

	VC_TRAFFICGLOBALDATA()
	{
		temp = new TEMPDATA();
		pedData = new PEDS_LIFETIMEDATA();
		vehData = new VEHICLEDATA();
		driverBehaviourTablePtr = (DWORD) driverBehaviourTable;
		carClassSpeeds = (DWORD) carClassSpeedMult;
		driverShotReactionsPtr = (DWORD) driverShotReactions;
		gangerTablePtr = (DWORD) gangerTable;
		maxVehicleSpeedMultiplier = 1.2f;
		padding1  = 0;
		padding2  = 0;
	}
};

//GLOBAL DATA STRUCTURE
VC_TRAFFICGLOBALDATA VC_TrafficGlobalData = VC_TRAFFICGLOBALDATA();
DWORD *VC_TrafficPointerAddr = (DWORD *) 0x6DFFD0;

//global variables
DWORD *PtrToPlayer = (DWORD *) 0x97F2AC;
DWORD *VehDensityMult = (DWORD *) 0x686FC8;
DWORD *PedDensityMult = (DWORD *) 0x694DC0;
DWORD *Time_Hours = (DWORD *) 0xA10B6B;
DWORD *IngameTimerInMS = (DWORD *) 0x974B2C;

//Used constants
const float aHalf = 0.5f;
const float thousand = 1000.0f;

//Used across modules
DWORD *RandomNumberCallDest	= (DWORD *) 0x6499F0;
DWORD *GetPlayerCallDest	= (DWORD *) 0x4BC120;




//***********************************************
//GLOBAL DATA HANDLING
//***********************************************
//Peds
DWORD *ExtPedLimitInstall = (DWORD *) 0x694DC8;
DWORD *PrevExtPedLimitBlankInstall = (DWORD *) 0x628138;
DWORD *IntPedLimitInstall = (DWORD *) 0x694DCC;
DWORD *PrevIntPedLimitBlankInstall = (DWORD *) 0x62816E;
//DWORD *DensityAdderInstall = (DWORD *) ;
DWORD *absMaxDespawnOnscrInstall = (DWORD *) 0x694EBC;
DWORD *normMaxDespawnOnscrInstall = (DWORD *) 0x694EB0;
DWORD *maxDespawnOffscrInstall = (DWORD *) 0x694EB4;
DWORD *gangerDespawnRngAdderInstall = (DWORD *) 0x694E88;
DWORD *pedsDespawnTimeInstall = (DWORD *) 0x53DF76;
DWORD *copsDespawnTimeInstall = (DWORD *) 0x53DF63;
DWORD *pedsDrawDistanceInstall = (DWORD *) 0x69A1E4;
DWORD *maxSpawnOnscrInstall = (DWORD *) 0x694E78;
DWORD *minSpawnOnscrInstall = (DWORD *) 0x694DDC;
DWORD *spawnOffscrRingSizeInstall = (DWORD *) 0x694ECC;
//Vehicles
DWORD *VehLimitInstall = (DWORD *) 0x686FCC;
DWORD *PrevVehLimitBlankInstall = (DWORD *) 0x628190;
DWORD *DespawnOnscrInstall = (DWORD *) 0x6871F8;
DWORD *DespawnOffscrInstall = (DWORD *) 0x687138;
//DWORD *SpawnVehRngAdderInstall = (DWORD *) 0x687D18;
DWORD *SpawnOnscrInstall = (DWORD *) 0x68703C;
DWORD *SomeSpawnRangeLimiterInstall = (DWORD *) 0x687D00;
DWORD *vehLODRangeInstall = (DWORD *) 0x69A1D8;
DWORD *DrivBehavCorrInstall1 = (DWORD *) 0x425945;
DWORD *DrivBehavCorrInstall2 = (DWORD *) 0x423CDE;
DWORD *DrivBehavCorrInstall3 = (DWORD *) 0x423D61;

//ADDED:
DWORD *RereadHandlingCfgInstall = (DWORD *) 0x4A4B16;

DWORD *MaxVehSpeedMultiplier = (DWORD *) 0x69BC88;
DWORD *InitLoadBarLengthProc = (DWORD *) 0x4A6D80;
DWORD *HandlingDataBase = (DWORD *) 0x978E58;
DWORD *ReadHandlingDataProc = (DWORD *) 0x5ABA10;



BYTE PrevLimitBlanker[5] =	{0x90, 0x90, 0x90, 0x90, 0x90};


DWORD *WheelVisRngOverrideInstall = (DWORD *) 0x48C5DE;

BYTE WheelVisRngOverride[57] =		{0x66, 0x81, 0x7C, 0x24, 0x24, 0x2C, 0x01, 0x7D, 
									 0x23, 0x89, 0x84, 0x24, 0x50, 0xFF, 0xFF, 0xFF, 
									 0xA1, 0xF0, 0xFF, 0x6D, 0x00, 0x8B, 0x40, 0x14, 
									 0x83, 0x78, 0x1C, 0x00, 0x74, 0x07, 0xD9, 0x40, 
									 0x1C, 0xD9, 0x5C, 0x24, 0x60, 0x8B, 0x84, 0x24, 
									 0x50, 0xFF, 0xFF, 0xFF, 0xD9, 0x44, 0x24, 0x60, 
									 0xD8, 0x5C, 0x24, 0x5C, 0xE9, 0x9D, 0xE8, 0xE0, 
									 0xFF};
BYTE WheelVisRngOverrideInst[8] =	{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90, 0x90};

BYTE RereadHandlingCfg[22] =		{0xE8, 0x6B, 0x90, 0xE2, 0xFF, 0x51, 0xB9, 0x58,
									 0x8E, 0x97, 0x00, 0xE8, 0xF0, 0xDC, 0xF2, 0xFF,
									 0x59, 0xE9, 0xF5, 0x6D, 0xE2, 0xFF};
BYTE RereadHandlingCfgInst[5] =		{0xE9, 0x00, 0x00, 0x00, 0x00};


void InstallWheelVisRngOverride()
{
	DWORD protect1, protect2;

	WheelVisRngOverride[17] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	WheelVisRngOverride[18] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	WheelVisRngOverride[19] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	WheelVisRngOverride[20] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	long relJumpDist1 =  (((DWORD) WheelVisRngOverrideInstall)+8) - (((DWORD) WheelVisRngOverride)+57);
	WheelVisRngOverride[53] = LOBYTE(LOWORD(relJumpDist1));
	WheelVisRngOverride[54] = HIBYTE(LOWORD(relJumpDist1));
	WheelVisRngOverride[55] = LOBYTE(HIWORD(relJumpDist1));
	WheelVisRngOverride[56] = HIBYTE(HIWORD(relJumpDist1));
	long relJumpDist2 =  ((DWORD) WheelVisRngOverride) - (((DWORD) WheelVisRngOverrideInstall)+5);
	WheelVisRngOverrideInst[1] = LOBYTE(LOWORD(relJumpDist2));
	WheelVisRngOverrideInst[2] = HIBYTE(LOWORD(relJumpDist2));
	WheelVisRngOverrideInst[3] = LOBYTE(HIWORD(relJumpDist2));
	WheelVisRngOverrideInst[4] = HIBYTE(HIWORD(relJumpDist2));
	VirtualProtect(WheelVisRngOverrideInstall, sizeof(WheelVisRngOverrideInst), PAGE_READWRITE, &protect1);
	memcpy(WheelVisRngOverrideInstall, &WheelVisRngOverrideInst, sizeof(WheelVisRngOverrideInst));
	VirtualProtect(WheelVisRngOverrideInstall, sizeof(WheelVisRngOverrideInst), protect1, &protect2);
}

void HandleGlobalData()
{
	DWORD protect1, protect2;

	//PEDS STUFF
	VirtualProtect(ExtPedLimitInstall, sizeof(VC_TrafficGlobalData.pedData->extPedLimit), PAGE_READWRITE, &protect1);
	memcpy(ExtPedLimitInstall, &VC_TrafficGlobalData.pedData->extPedLimit, sizeof(VC_TrafficGlobalData.pedData->extPedLimit));
	VirtualProtect(ExtPedLimitInstall, sizeof(VC_TrafficGlobalData.pedData->extPedLimit), protect1, &protect2);
	VirtualProtect(PrevExtPedLimitBlankInstall, sizeof(PrevLimitBlanker), PAGE_READWRITE, &protect1);
	memcpy(PrevExtPedLimitBlankInstall, &PrevLimitBlanker, sizeof(PrevLimitBlanker));
	VirtualProtect(PrevExtPedLimitBlankInstall, sizeof(PrevLimitBlanker), protect1, &protect2);
	
	VirtualProtect(IntPedLimitInstall, sizeof(VC_TrafficGlobalData.pedData->intPedLimit), PAGE_READWRITE, &protect1);
	memcpy(IntPedLimitInstall, &VC_TrafficGlobalData.pedData->intPedLimit, sizeof(VC_TrafficGlobalData.pedData->intPedLimit));
	VirtualProtect(IntPedLimitInstall, sizeof(VC_TrafficGlobalData.pedData->intPedLimit), protect1, &protect2);
	VirtualProtect(PrevIntPedLimitBlankInstall, sizeof(PrevLimitBlanker), PAGE_READWRITE, &protect1);
	memcpy(PrevIntPedLimitBlankInstall, &PrevLimitBlanker, sizeof(PrevLimitBlanker));
	VirtualProtect(PrevIntPedLimitBlankInstall, sizeof(PrevLimitBlanker), protect1, &protect2);

	VirtualProtect(absMaxDespawnOnscrInstall, sizeof(VC_TrafficGlobalData.pedData->absoluteMaxDespawnRangeOnscreen), PAGE_READWRITE, &protect1);
	memcpy(absMaxDespawnOnscrInstall, &VC_TrafficGlobalData.pedData->absoluteMaxDespawnRangeOnscreen, sizeof(VC_TrafficGlobalData.pedData->absoluteMaxDespawnRangeOnscreen));
	VirtualProtect(absMaxDespawnOnscrInstall, sizeof(VC_TrafficGlobalData.pedData->absoluteMaxDespawnRangeOnscreen), protect1, &protect2);
	
	VirtualProtect(normMaxDespawnOnscrInstall, sizeof(VC_TrafficGlobalData.pedData->normalMaxDespawnRangeOnscreen), PAGE_READWRITE, &protect1);
	memcpy(normMaxDespawnOnscrInstall, &VC_TrafficGlobalData.pedData->normalMaxDespawnRangeOnscreen, sizeof(VC_TrafficGlobalData.pedData->normalMaxDespawnRangeOnscreen));
	VirtualProtect(normMaxDespawnOnscrInstall, sizeof(VC_TrafficGlobalData.pedData->normalMaxDespawnRangeOnscreen), protect1, &protect2);
	
	VirtualProtect(maxDespawnOffscrInstall, sizeof(VC_TrafficGlobalData.pedData->maxRangeDespawnOffscreen), PAGE_READWRITE, &protect1);
	memcpy(maxDespawnOffscrInstall, &VC_TrafficGlobalData.pedData->maxRangeDespawnOffscreen, sizeof(VC_TrafficGlobalData.pedData->maxRangeDespawnOffscreen));
	VirtualProtect(maxDespawnOffscrInstall, sizeof(VC_TrafficGlobalData.pedData->maxRangeDespawnOffscreen), protect1, &protect2);
	
	VirtualProtect(gangerDespawnRngAdderInstall, sizeof(VC_TrafficGlobalData.pedData->gangerDespawnRangeAdder), PAGE_READWRITE, &protect1);
	memcpy(gangerDespawnRngAdderInstall, &VC_TrafficGlobalData.pedData->gangerDespawnRangeAdder, sizeof(VC_TrafficGlobalData.pedData->gangerDespawnRangeAdder));
	VirtualProtect(gangerDespawnRngAdderInstall, sizeof(VC_TrafficGlobalData.pedData->gangerDespawnRangeAdder), protect1, &protect2);
	
	VirtualProtect(pedsDespawnTimeInstall, sizeof(VC_TrafficGlobalData.pedData->pedsDespawnTime), PAGE_READWRITE, &protect1);
	memcpy(pedsDespawnTimeInstall, &VC_TrafficGlobalData.pedData->pedsDespawnTime, sizeof(VC_TrafficGlobalData.pedData->pedsDespawnTime));
	VirtualProtect(pedsDespawnTimeInstall, sizeof(VC_TrafficGlobalData.pedData->pedsDespawnTime), protect1, &protect2);
	
	VirtualProtect(copsDespawnTimeInstall, sizeof(VC_TrafficGlobalData.pedData->copsDespawnTime), PAGE_READWRITE, &protect1);
	memcpy(copsDespawnTimeInstall, &VC_TrafficGlobalData.pedData->copsDespawnTime, sizeof(VC_TrafficGlobalData.pedData->copsDespawnTime));
	VirtualProtect(copsDespawnTimeInstall, sizeof(VC_TrafficGlobalData.pedData->copsDespawnTime), protect1, &protect2);
	
	VirtualProtect(pedsDrawDistanceInstall, sizeof(VC_TrafficGlobalData.pedData->pedsDrawDist), PAGE_READWRITE, &protect1);
	memcpy(pedsDrawDistanceInstall, &VC_TrafficGlobalData.pedData->pedsDrawDist, sizeof(VC_TrafficGlobalData.pedData->pedsDrawDist));
	VirtualProtect(pedsDrawDistanceInstall, sizeof(VC_TrafficGlobalData.pedData->pedsDrawDist), protect1, &protect2);
	
	VirtualProtect(maxSpawnOnscrInstall, sizeof(VC_TrafficGlobalData.pedData->maxSpawnRangeOnscreen), PAGE_READWRITE, &protect1);
	memcpy(maxSpawnOnscrInstall, &VC_TrafficGlobalData.pedData->maxSpawnRangeOnscreen, sizeof(VC_TrafficGlobalData.pedData->maxSpawnRangeOnscreen));
	VirtualProtect(maxSpawnOnscrInstall, sizeof(VC_TrafficGlobalData.pedData->maxSpawnRangeOnscreen), protect1, &protect2);
	
	VirtualProtect(minSpawnOnscrInstall, sizeof(VC_TrafficGlobalData.pedData->minSpawnRangeOnscreen), PAGE_READWRITE, &protect1);
	memcpy(minSpawnOnscrInstall, &VC_TrafficGlobalData.pedData->minSpawnRangeOnscreen, sizeof(VC_TrafficGlobalData.pedData->minSpawnRangeOnscreen));
	VirtualProtect(minSpawnOnscrInstall, sizeof(VC_TrafficGlobalData.pedData->minSpawnRangeOnscreen), protect1, &protect2);
	
	VirtualProtect(spawnOffscrRingSizeInstall, sizeof(VC_TrafficGlobalData.pedData->spawnOffscreenRingSize), PAGE_READWRITE, &protect1);
	memcpy(spawnOffscrRingSizeInstall, &VC_TrafficGlobalData.pedData->spawnOffscreenRingSize, sizeof(VC_TrafficGlobalData.pedData->spawnOffscreenRingSize));
	VirtualProtect(spawnOffscrRingSizeInstall, sizeof(VC_TrafficGlobalData.pedData->spawnOffscreenRingSize), protect1, &protect2);

	//VEHICLE STUFF
	VirtualProtect(VehLimitInstall, sizeof(VC_TrafficGlobalData.vehData->vehLimit), PAGE_READWRITE, &protect1);
	memcpy(VehLimitInstall, &VC_TrafficGlobalData.vehData->vehLimit, sizeof(VC_TrafficGlobalData.vehData->vehLimit));
	VirtualProtect(VehLimitInstall, sizeof(VC_TrafficGlobalData.vehData->vehLimit), protect1, &protect2);
	VirtualProtect(PrevVehLimitBlankInstall, sizeof(PrevLimitBlanker), PAGE_READWRITE, &protect1);
	memcpy(PrevVehLimitBlankInstall, &PrevLimitBlanker, sizeof(PrevLimitBlanker));
	VirtualProtect(PrevVehLimitBlankInstall, sizeof(PrevLimitBlanker), protect1, &protect2);

	VirtualProtect(DespawnOnscrInstall, sizeof(VC_TrafficGlobalData.vehData->despawnRangeOnscreen), PAGE_READWRITE, &protect1);
	memcpy(DespawnOnscrInstall, &VC_TrafficGlobalData.vehData->despawnRangeOnscreen, sizeof(VC_TrafficGlobalData.vehData->despawnRangeOnscreen));
	VirtualProtect(DespawnOnscrInstall, sizeof(VC_TrafficGlobalData.vehData->despawnRangeOnscreen), protect1, &protect2);

	VirtualProtect(DespawnOffscrInstall, sizeof(VC_TrafficGlobalData.vehData->despawnRangeOffscreen), PAGE_READWRITE, &protect1);
	memcpy(DespawnOffscrInstall, &VC_TrafficGlobalData.vehData->despawnRangeOffscreen, sizeof(VC_TrafficGlobalData.vehData->despawnRangeOffscreen));
	VirtualProtect(DespawnOffscrInstall, sizeof(VC_TrafficGlobalData.vehData->despawnRangeOffscreen), protect1, &protect2);

	//float calculatedAdder = VC_TrafficGlobalData.vehData->spawnRange - VC_TrafficGlobalData.vehData->despawnRangeOffscreen;
	VirtualProtect(SpawnOnscrInstall, sizeof(VC_TrafficGlobalData.vehData->spawnRangeOnscreen), PAGE_READWRITE, &protect1);
	memcpy(SpawnOnscrInstall, &VC_TrafficGlobalData.vehData->spawnRangeOnscreen, sizeof(VC_TrafficGlobalData.vehData->spawnRangeOnscreen));
	VirtualProtect(SpawnOnscrInstall, sizeof(VC_TrafficGlobalData.vehData->spawnRangeOnscreen), protect1, &protect2);

	float adjustedLimiter = VC_TrafficGlobalData.vehData->spawnRangeOnscreen + 40.0f;
	VirtualProtect(SomeSpawnRangeLimiterInstall, sizeof(adjustedLimiter), PAGE_READWRITE, &protect1);
	memcpy(SomeSpawnRangeLimiterInstall, &adjustedLimiter, sizeof(adjustedLimiter));
	VirtualProtect(SomeSpawnRangeLimiterInstall, sizeof(adjustedLimiter), protect1, &protect2);

	VirtualProtect(vehLODRangeInstall, sizeof(VC_TrafficGlobalData.vehData->lodThreshold), PAGE_READWRITE, &protect1);
	memcpy(vehLODRangeInstall, &VC_TrafficGlobalData.vehData->lodThreshold, sizeof(VC_TrafficGlobalData.vehData->lodThreshold));
	VirtualProtect(vehLODRangeInstall, sizeof(VC_TrafficGlobalData.vehData->lodThreshold), protect1, &protect2);

	void* corrAddress = &(VC_TrafficGlobalData.vehData->forBehaviourCorrection);
	VirtualProtect(DrivBehavCorrInstall1, sizeof(corrAddress), PAGE_READWRITE, &protect1);
	memcpy(DrivBehavCorrInstall1, (void*) &corrAddress, sizeof(corrAddress));
	VirtualProtect(DrivBehavCorrInstall1, sizeof(corrAddress), protect1, &protect2);
	VirtualProtect(DrivBehavCorrInstall2, sizeof(corrAddress), PAGE_READWRITE, &protect1);
	memcpy(DrivBehavCorrInstall2, (void*) &corrAddress, sizeof(corrAddress));
	VirtualProtect(DrivBehavCorrInstall2, sizeof(corrAddress), protect1, &protect2);
	VirtualProtect(DrivBehavCorrInstall3, sizeof(corrAddress), PAGE_READWRITE, &protect1);
	memcpy(DrivBehavCorrInstall3, (void*) &corrAddress, sizeof(corrAddress));
	VirtualProtect(DrivBehavCorrInstall3, sizeof(corrAddress), protect1, &protect2);

	InstallWheelVisRngOverride();

	VirtualProtect(MaxVehSpeedMultiplier, sizeof(VC_TrafficGlobalData.maxVehicleSpeedMultiplier), PAGE_READWRITE, &protect1);
	memcpy(MaxVehSpeedMultiplier, (void*) &VC_TrafficGlobalData.maxVehicleSpeedMultiplier, sizeof(VC_TrafficGlobalData.maxVehicleSpeedMultiplier));
	VirtualProtect(MaxVehSpeedMultiplier, sizeof(VC_TrafficGlobalData.maxVehicleSpeedMultiplier), protect1, &protect2);

	RereadHandlingCfg[7] = LOBYTE(LOWORD((DWORD) HandlingDataBase));
	RereadHandlingCfg[8] = HIBYTE(LOWORD((DWORD) HandlingDataBase));
	RereadHandlingCfg[9] = LOBYTE(HIWORD((DWORD) HandlingDataBase));
	RereadHandlingCfg[10] = HIBYTE(HIWORD((DWORD) HandlingDataBase));
	DWORD relCallDist1 =  ((DWORD) InitLoadBarLengthProc) - (((DWORD) RereadHandlingCfg)+5);
	RereadHandlingCfg[1] = LOBYTE(LOWORD(relCallDist1));
	RereadHandlingCfg[2] = HIBYTE(LOWORD(relCallDist1));
	RereadHandlingCfg[3] = LOBYTE(HIWORD(relCallDist1));
	RereadHandlingCfg[4] = HIBYTE(HIWORD(relCallDist1));
	DWORD relCallDist2 =  ((DWORD) ReadHandlingDataProc) - (((DWORD) RereadHandlingCfg)+16);
	RereadHandlingCfg[12] = LOBYTE(LOWORD(relCallDist2));
	RereadHandlingCfg[13] = HIBYTE(LOWORD(relCallDist2));
	RereadHandlingCfg[14] = LOBYTE(HIWORD(relCallDist2));
	RereadHandlingCfg[15] = HIBYTE(HIWORD(relCallDist2));
	long relJumpDist1 =  (((DWORD) RereadHandlingCfgInstall)+5) - (((DWORD) RereadHandlingCfg)+22);
	RereadHandlingCfg[18] = LOBYTE(LOWORD(relJumpDist1));
	RereadHandlingCfg[19] = HIBYTE(LOWORD(relJumpDist1));
	RereadHandlingCfg[20] = LOBYTE(HIWORD(relJumpDist1));
	RereadHandlingCfg[21] = HIBYTE(HIWORD(relJumpDist1));
	long relJumpDist2 =  ((DWORD) RereadHandlingCfg) - (((DWORD) RereadHandlingCfgInstall)+5);
	RereadHandlingCfgInst[1] = LOBYTE(LOWORD(relJumpDist2));
	RereadHandlingCfgInst[2] = HIBYTE(LOWORD(relJumpDist2));
	RereadHandlingCfgInst[3] = LOBYTE(HIWORD(relJumpDist2));
	RereadHandlingCfgInst[4] = HIBYTE(HIWORD(relJumpDist2));
	VirtualProtect(RereadHandlingCfgInstall, sizeof(RereadHandlingCfgInst), PAGE_READWRITE, &protect1);
	memcpy(RereadHandlingCfgInstall, &RereadHandlingCfgInst, sizeof(RereadHandlingCfgInst));
	VirtualProtect(RereadHandlingCfgInstall, sizeof(RereadHandlingCfgInst), protect1, &protect2);
}

//***********************************************
//TRAFFIC DENSITY TABLES
//***********************************************
DWORD *VehicleTrafficInstall = (DWORD *) 0x426EAE;
DWORD *PedTrafficInstall = (DWORD *) 0x53BEBB;

DWORD *TempSpeedHolder = (DWORD *) 0x77F9CC;

BYTE VehicleTraffic[36] =			{0xD8, 0x0D, 0xC8, 0x6F, 0x68, 0x00, 0x50, 0x51,
									 0xA1, 0xD0, 0xFF, 0x6D, 0x00, 0x8B, 0x40, 0x14,
									 0x8B, 0x40, 0x20, 0x0F, 0xB6, 0x0D, 0x6B, 0x0B,
									 0xA1, 0x00, 0xD8, 0x0C, 0x88, 0x59, 0x58, 0xE9,
									 0x80, 0x91, 0xDA, 0xFF};
BYTE VehicleTrafficInst[6] =		{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90};

BYTE PedTraffic[36] =				{0xD8, 0x0D, 0xC0, 0x4D, 0x69, 0x00, 0x50, 0x51,
									 0xA1, 0xD0, 0xFF, 0x6D, 0x00, 0x8B, 0x40, 0x10,
									 0x8B, 0x40, 0x38, 0x0F, 0xB6, 0x0D, 0x6B, 0x0B,
									 0xA1, 0x00, 0xD8, 0x0C, 0x88, 0x59, 0x58, 0xE9,
									 0x4D, 0xE1, 0xEB, 0xFF};
BYTE PedTrafficInst[6] =			{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90};

void InstallTrafficTables()
{
	DWORD protect1, protect2;

	VehicleTraffic[2] = LOBYTE(LOWORD((DWORD) VehDensityMult));
	VehicleTraffic[3] = HIBYTE(LOWORD((DWORD) VehDensityMult));
	VehicleTraffic[4] = LOBYTE(HIWORD((DWORD) VehDensityMult));
	VehicleTraffic[5] = HIBYTE(HIWORD((DWORD) VehDensityMult));
	VehicleTraffic[9] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	VehicleTraffic[10] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	VehicleTraffic[11] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	VehicleTraffic[12] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	VehicleTraffic[22] = LOBYTE(LOWORD((DWORD) Time_Hours));
	VehicleTraffic[23] = HIBYTE(LOWORD((DWORD) Time_Hours));
	VehicleTraffic[24] = LOBYTE(HIWORD((DWORD) Time_Hours));
	VehicleTraffic[25] = HIBYTE(HIWORD((DWORD) Time_Hours));
	long relJumpDist1 =  (((DWORD) VehicleTrafficInstall)+6) - (((DWORD) VehicleTraffic)+36);
	VehicleTraffic[32] = LOBYTE(LOWORD(relJumpDist1));
	VehicleTraffic[33] = HIBYTE(LOWORD(relJumpDist1));
	VehicleTraffic[34] = LOBYTE(HIWORD(relJumpDist1));
	VehicleTraffic[35] = HIBYTE(HIWORD(relJumpDist1));
	long relJumpDist2 =  ((DWORD) VehicleTraffic) - (((DWORD) VehicleTrafficInstall)+5);
	VehicleTrafficInst[1] = LOBYTE(LOWORD(relJumpDist2));
	VehicleTrafficInst[2] = HIBYTE(LOWORD(relJumpDist2));
	VehicleTrafficInst[3] = LOBYTE(HIWORD(relJumpDist2));
	VehicleTrafficInst[4] = HIBYTE(HIWORD(relJumpDist2));
	VirtualProtect(VehicleTrafficInstall, sizeof(VehicleTrafficInst), PAGE_READWRITE, &protect1);
	memcpy(VehicleTrafficInstall, &VehicleTrafficInst, sizeof(VehicleTrafficInst));
	VirtualProtect(VehicleTrafficInstall, sizeof(VehicleTrafficInst), protect1, &protect2);

	PedTraffic[2] = LOBYTE(LOWORD((DWORD) PedDensityMult));
	PedTraffic[3] = HIBYTE(LOWORD((DWORD) PedDensityMult));
	PedTraffic[4] = LOBYTE(HIWORD((DWORD) PedDensityMult));
	PedTraffic[5] = HIBYTE(HIWORD((DWORD) PedDensityMult));
	PedTraffic[9] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	PedTraffic[10] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	PedTraffic[11] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	PedTraffic[12] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	PedTraffic[22] = LOBYTE(LOWORD((DWORD) Time_Hours));
	PedTraffic[23] = HIBYTE(LOWORD((DWORD) Time_Hours));
	PedTraffic[24] = LOBYTE(HIWORD((DWORD) Time_Hours));
	PedTraffic[25] = HIBYTE(HIWORD((DWORD) Time_Hours));
	long relJumpDist3 =  (((DWORD) PedTrafficInstall)+6) - (((DWORD) PedTraffic)+36);
	PedTraffic[32] = LOBYTE(LOWORD(relJumpDist3));
	PedTraffic[33] = HIBYTE(LOWORD(relJumpDist3));
	PedTraffic[34] = LOBYTE(HIWORD(relJumpDist3));
	PedTraffic[35] = HIBYTE(HIWORD(relJumpDist3));
	long relJumpDist4 =  ((DWORD) PedTraffic) - (((DWORD) PedTrafficInstall)+5);
	PedTrafficInst[1] = LOBYTE(LOWORD(relJumpDist4));
	PedTrafficInst[2] = HIBYTE(LOWORD(relJumpDist4));
	PedTrafficInst[3] = LOBYTE(HIWORD(relJumpDist4));
	PedTrafficInst[4] = HIBYTE(HIWORD(relJumpDist4));
	VirtualProtect(PedTrafficInstall, sizeof(PedTrafficInst), PAGE_READWRITE, &protect1);
	memcpy(PedTrafficInstall, &PedTrafficInst, sizeof(PedTrafficInst));
	VirtualProtect(PedTrafficInstall, sizeof(PedTrafficInst), protect1, &protect2);
}


//***********************************************
//VEHICLE SPEED LIMITS
//***********************************************
DWORD *GearFix1Install = (DWORD *) 0x5B2EF1;
DWORD *GearFix2Install = (DWORD *) 0x5B2ECD;
DWORD *NodeSpeedInstall = (DWORD *) 0x41BFB9;


BYTE GearFix1[27] =					{0x50, 0x8A, 0x41, 0x4A, 0x38, 0x06, 0x58, 0x0F,
									 0x84, 0x06, 0x52, 0xF3, 0xFF, 0x80, 0x3E, 0x00,
									 0x0F, 0x85, 0xDF, 0x51, 0xF3, 0xFF, 0xE9, 0xCB,
									 0x51, 0xF3, 0xFF};
BYTE GearFix1Inst[5] =				{0xE9, 0x00, 0x00, 0x00, 0x00};

BYTE GearFix2[25] =					{0xD9, 0x05, 0xCC, 0xF9, 0x77, 0x00, 0x3A, 0x41,
									 0x4A, 0x0F, 0x8E, 0x74, 0x51, 0xF3, 0xFF, 0x8A,
									 0x41, 0x4A, 0x88, 0x06, 0xE9, 0x6A, 0x51, 0xF3,
									 0xFF};
BYTE GearFix2Inst[6] =				{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90};

BYTE NodeSpeed[22] =				{0x51, 0x8B, 0x0D, 0xD0, 0xFF, 0x6D, 0x00, 0x8B,
									 0x49, 0x14, 0x8B, 0x49, 0x24, 0xD9, 0x04, 0x81,
									 0x59, 0xE9, 0xB6, 0xE2, 0xD9, 0xFF};
BYTE NodeSpeedInst[6] =				{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90};

void InstallVehicleSpeedLimits()
{
	DWORD protect1, protect2;

	long relJumpDist1 =  (((DWORD) GearFix1Install)+50) - (((DWORD) GearFix1)+13);
	GearFix1[9] = LOBYTE(LOWORD(relJumpDist1));
	GearFix1[10] = HIBYTE(LOWORD(relJumpDist1));
	GearFix1[11] = LOBYTE(HIWORD(relJumpDist1));
	GearFix1[12] = HIBYTE(HIWORD(relJumpDist1));
	long relJumpDist2 =  (((DWORD) GearFix1Install)+20) - (((DWORD) GearFix1)+22);
	GearFix1[18] = LOBYTE(LOWORD(relJumpDist2));
	GearFix1[19] = HIBYTE(LOWORD(relJumpDist2));
	GearFix1[20] = LOBYTE(HIWORD(relJumpDist2));
	GearFix1[21] = HIBYTE(HIWORD(relJumpDist2));
	long relJumpDist3 =  (((DWORD) GearFix1Install)+5) - (((DWORD) GearFix1)+27);
	GearFix1[23] = LOBYTE(LOWORD(relJumpDist3));
	GearFix1[24] = HIBYTE(LOWORD(relJumpDist3));
	GearFix1[25] = LOBYTE(HIWORD(relJumpDist3));
	GearFix1[26] = HIBYTE(HIWORD(relJumpDist3));
	long relJumpDist4 =  ((DWORD) GearFix1) - (((DWORD) GearFix1Install)+5);
	GearFix1Inst[1] = LOBYTE(LOWORD(relJumpDist4));
	GearFix1Inst[2] = HIBYTE(LOWORD(relJumpDist4));
	GearFix1Inst[3] = LOBYTE(HIWORD(relJumpDist4));
	GearFix1Inst[4] = HIBYTE(HIWORD(relJumpDist4));
	VirtualProtect(GearFix1Install, sizeof(GearFix1Inst), PAGE_READWRITE, &protect1);
	memcpy(GearFix1Install, &GearFix1Inst, sizeof(GearFix1Inst));
	VirtualProtect(GearFix1Install, sizeof(GearFix1Inst), protect1, &protect2);

	GearFix2[2] = LOBYTE(LOWORD((DWORD) TempSpeedHolder));
	GearFix2[3] = HIBYTE(LOWORD((DWORD) TempSpeedHolder));
	GearFix2[4] = LOBYTE(HIWORD((DWORD) TempSpeedHolder));
	GearFix2[5] = HIBYTE(HIWORD((DWORD) TempSpeedHolder));
	long relJumpDist5 =  (((DWORD) GearFix2Install)+6) - (((DWORD) GearFix2)+15);
	GearFix2[11] = LOBYTE(LOWORD(relJumpDist5));
	GearFix2[12] = HIBYTE(LOWORD(relJumpDist5));
	GearFix2[13] = LOBYTE(HIWORD(relJumpDist5));
	GearFix2[14] = HIBYTE(HIWORD(relJumpDist5));
	long relJumpDist6 =  (((DWORD) GearFix2Install)+6) - (((DWORD) GearFix2)+25);
	GearFix2[21] = LOBYTE(LOWORD(relJumpDist6));
	GearFix2[22] = HIBYTE(LOWORD(relJumpDist6));
	GearFix2[23] = LOBYTE(HIWORD(relJumpDist6));
	GearFix2[24] = HIBYTE(HIWORD(relJumpDist6));
	long relJumpDist7 =  ((DWORD) GearFix2) - (((DWORD) GearFix2Install)+5);
	GearFix2Inst[1] = LOBYTE(LOWORD(relJumpDist7));
	GearFix2Inst[2] = HIBYTE(LOWORD(relJumpDist7));
	GearFix2Inst[3] = LOBYTE(HIWORD(relJumpDist7));
	GearFix2Inst[4] = HIBYTE(HIWORD(relJumpDist7));
	VirtualProtect(GearFix2Install, sizeof(GearFix2Inst), PAGE_READWRITE, &protect1);
	memcpy(GearFix2Install, &GearFix2Inst, sizeof(GearFix2Inst));
	VirtualProtect(GearFix2Install, sizeof(GearFix2Inst), protect1, &protect2);

	NodeSpeed[3] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	NodeSpeed[4] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	NodeSpeed[5] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	NodeSpeed[6] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	long relJumpDist8 =  (((DWORD) NodeSpeedInstall)+35) - (((DWORD) NodeSpeed)+22);
	NodeSpeed[18] = LOBYTE(LOWORD(relJumpDist8));
	NodeSpeed[19] = HIBYTE(LOWORD(relJumpDist8));
	NodeSpeed[20] = LOBYTE(HIWORD(relJumpDist8));
	NodeSpeed[21] = HIBYTE(HIWORD(relJumpDist8));
	long relJumpDist9 =  ((DWORD) NodeSpeed) - (((DWORD) NodeSpeedInstall)+5);
	NodeSpeedInst[1] = LOBYTE(LOWORD(relJumpDist9));
	NodeSpeedInst[2] = HIBYTE(LOWORD(relJumpDist9));
	NodeSpeedInst[3] = LOBYTE(HIWORD(relJumpDist9));
	NodeSpeedInst[4] = HIBYTE(HIWORD(relJumpDist9));
	VirtualProtect(NodeSpeedInstall, sizeof(NodeSpeedInst), PAGE_READWRITE, &protect1);
	memcpy(NodeSpeedInstall, &NodeSpeedInst, sizeof(NodeSpeedInst));
	VirtualProtect(NodeSpeedInstall, sizeof(NodeSpeedInst), protect1, &protect2);
}

//***********************************************
//DRIVER BEHAVIOUR
//***********************************************
DWORD *CreateDrivSpdInstall = (DWORD *) 0x50EF73;
DWORD *TransferDrivSpdInstall = (DWORD *) 0x5B8896;
DWORD *AdjustDrivSpdInstall = (DWORD *) 0x428DA8;
DWORD *RushSpeedSwitchInstall = (DWORD *) 0x428E76;
DWORD *RushSpeedInstall = (DWORD *) 0x428EC1;
DWORD *SkipAccelInstall = (DWORD *) 0x5B934B;
DWORD *ShotReactionInstall = (DWORD *) 0x5B943A;
DWORD *ShotReactionBackJump = (DWORD *) 0x5B95B1;
DWORD *CarfireReactionInstall = (DWORD *) 0x5B9614;
DWORD *CarfireReactionBackJump = (DWORD *) 0x5B9670;

DWORD *Address687214 = (DWORD *) 0x687214;
DWORD *PedTypeCounterProc = (DWORD *) 0x53A720;
DWORD *Address69C68C = (DWORD *) 0x69C68C;
DWORD *LeaveVehicleProc = (DWORD *) 0x521F10;
DWORD *SomeProc = (DWORD *) 0x5226B0;
DWORD *Address69283C = (DWORD *) 0x69283C;
DWORD *SomeProc2 = (DWORD *) 0x4C6AC0;

BYTE CreateDrivSpd[116] =			{0xE8, 0xDB, 0xBC, 0xFC, 0xFF, 0x25, 0xFF, 0x7F,
									 0x00, 0x00, 0x50, 0xDB, 0x04, 0x24, 0xD8, 0x0D,
									 0x14, 0x72, 0x68, 0x00, 0x8B, 0x0D, 0xD0, 0xFF,
									 0x6D, 0x00, 0x8B, 0x49, 0x18, 0x8B, 0x5C, 0x24,
									 0x04, 0x3E, 0x8D, 0x1C, 0xDD, 0x00, 0x00, 0x00,
									 0x00, 0x3E, 0x8D, 0x1C, 0xDD, 0x00, 0x00, 0x00,
									 0x00, 0xD9, 0x44, 0x19, 0x04, 0xD8, 0x24, 0x19,
									 0xDC, 0xC9, 0xDD, 0xD8, 0xD8, 0x04, 0x19, 0xD9,
									 0x3C, 0x24, 0x8B, 0x04, 0x24, 0x80, 0x4C, 0x24,
									 0x01, 0x0C, 0xD9, 0x2C, 0x24, 0x89, 0x04, 0x24,
									 0x50, 0xDF, 0x1C, 0x24, 0xD9, 0x6C, 0x24, 0x04,
									 0x8B, 0x04, 0x24, 0x88, 0x82, 0xE7, 0x00, 0x00,
									 0x00, 0x58, 0x58, 0xC6, 0x82, 0x6B, 0x05, 0x00,
									 0x00, 0xFF, 0xE8, 0xA8, 0xC9, 0xEB, 0xFF, 0xE9,
									 0xFB, 0x11, 0xE9, 0xFF};
BYTE CreateDrivSpdInst[5] =			{0xE9, 0x00, 0x00, 0x00, 0x00};

BYTE TransferDrivSpd[38] =			{0x89, 0x83, 0xA8, 0x01, 0x00, 0x00, 0x50, 0x36,
									 0x0F, 0xB6, 0x80, 0xE7, 0x00, 0x00, 0x00, 0x88,
									 0x83, 0x60, 0x01, 0x00, 0x00, 0x50, 0xDF, 0x04,
									 0x24, 0xD9, 0x9B, 0x5C, 0x01, 0x00, 0x00, 0x58,
									 0x58, 0xE9, 0xD6, 0xAA, 0xF3, 0xFF};
BYTE TransferDrivSpdInst[6] =		{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90};

BYTE AdjustDrivSpd[93] =			{0x0F, 0xB6, 0x9D, 0xD0, 0x01, 0x00, 0x00, 0x50,
									 0x51, 0xA1, 0xD0, 0xFF, 0x6D, 0x00, 0x8B, 0x40,
									 0x1C, 0x8B, 0x8C, 0x24, 0xD0, 0x00, 0x00, 0x00,
									 0x8D, 0x0C, 0x8D, 0x00, 0x00, 0x00, 0x00, 0xD9,
									 0x85, 0x5C, 0x01, 0x00, 0x00, 0xD8, 0x0C, 0x08,
									 0x50, 0xD9, 0x3C, 0x24, 0x8B, 0x04, 0x24, 0x80,
									 0x4C, 0x24, 0x01, 0x0C, 0xD9, 0x2C, 0x24, 0x89,
									 0x04, 0x24, 0x50, 0xDF, 0x1C, 0x24, 0xD9, 0x6C,
									 0x24, 0x04, 0x8B, 0x04, 0x24, 0x88, 0x85, 0x60,
									 0x01, 0x00, 0x00, 0xDF, 0x04, 0x24, 0xD9, 0x9D,
									 0x5C, 0x01, 0x00, 0x00, 0x58, 0x58, 0x59, 0x58,
									 0xE9, 0x72, 0xAF, 0xDA, 0xFF};
BYTE AdjustDrivSpdInst[7] =			{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90};

BYTE RushSpeedSwitchTable[20] =		{0x10, 0xDD, 0x67, 0x00, 0x10, 0xDD, 0x67, 0x00,
									 0x93, 0x8E, 0x42, 0x00, 0x8C, 0x8E, 0x42, 0x00,
									 0x93, 0x8E, 0x42, 0x00};
BYTE RushSpeedSwitch[15] =			{0x83, 0xE8, 0x01, 0x83, 0xF8, 0x04, 0x77, 0x15,
									 0xFF, 0x24, 0x85, 0xA8, 0xFF, 0x6D, 0x00};
BYTE RushSpeedCarsBikes[62] =		{0x83, 0xBD, 0xA8, 0x01, 0x00, 0x00, 0x00, 0x0F,
									 0x84, 0x76, 0xB1, 0xDA, 0xFF, 0x50, 0x51, 0x8B,
									 0x85, 0xA8, 0x01, 0x00, 0x00, 0x0F, 0xB6, 0x88,
									 0xD4, 0x03, 0x00, 0x00, 0x8D, 0x0C, 0xCD, 0x00,
									 0x00, 0x00, 0x00, 0x8D, 0x0C, 0xCD, 0x00, 0x00,
									 0x00, 0x00, 0xA1, 0xD0, 0xFF, 0x6D, 0x00, 0x8B,
									 0x40, 0x18, 0x0F, 0xB6, 0x5C, 0x08, 0x08, 0x59,
									 0x58, 0xE9, 0x4A, 0xB1, 0xDA, 0xFF};

BYTE RushSpeed[76] =				{0x83, 0xBD, 0xA8, 0x01, 0x00, 0x00, 0x00, 0x74,
									 0x37, 0x50, 0x51, 0x8B, 0x85, 0xA8, 0x01, 0x00,
									 0x00, 0x0F, 0xB6, 0x88, 0xD4, 0x03, 0x00, 0x00,
									 0x8D, 0x0C, 0xCD, 0x00, 0x00, 0x00, 0x00, 0x8D,
									 0x0C, 0xCD, 0x00, 0x00, 0x00, 0x00, 0xA1, 0xD0,
									 0xFF, 0x6D, 0x00, 0x8B, 0x40, 0x18, 0x0F, 0xB6,
									 0x4C, 0x08, 0x09, 0x00, 0x8D, 0x60, 0x01, 0x00,
									 0x00, 0x59, 0x58, 0xE9, 0x18, 0xB1, 0xDA, 0xFF,
									 0x80, 0x85, 0x60, 0x01, 0x00, 0x00, 0x0A, 0xE9,
									 0x0C, 0xB1, 0xDA, 0xFF};
BYTE RushSpeedInst[7] =				{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90};

BYTE DriverFleeProc[252] =			{0x50, 0x51, 0x52, 0x53, 0x83, 0xEC, 0x08, 0x8B,
									 0x5C, 0x24, 0x1C, 0x80, 0xBB, 0x56, 0x01, 0x00,
									 0x00, 0x01, 0x0F, 0x85, 0xDC, 0x00, 0x00, 0x00,
									 0x8B, 0x83, 0xA8, 0x01, 0x00, 0x00, 0x85, 0xC0,
									 0x0F, 0x84, 0xCE, 0x00, 0x00, 0x00, 0x83, 0xB8,
									 0x64, 0x01, 0x00, 0x00, 0x10, 0x0F, 0x84, 0xC1,
									 0x00, 0x00, 0x00, 0x80, 0xBB, 0x55, 0x01, 0x00,
									 0x00, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
									 0x8B, 0xD0, 0x0F, 0xBE, 0x83, 0x60, 0x01, 0x00,
									 0x00, 0x89, 0x44, 0x24, 0x04, 0xDB, 0x44, 0x24,
									 0x04, 0xA1, 0xD0, 0xFF, 0x6D, 0x00, 0x8B, 0x40,
									 0x18, 0x8B, 0x8A, 0xD4, 0x03, 0x00, 0x00, 0x8D,
									 0x0C, 0xCD, 0x00, 0x00, 0x00, 0x00, 0x8D, 0x0C,
									 0xCD, 0x00, 0x00, 0x00, 0x00, 0xD8, 0x4C, 0x08,
									 0x0C, 0xD9, 0x3C, 0x24, 0x8B, 0x04, 0x24, 0x80,
									 0x4C, 0x24, 0x01, 0x0C, 0xD9, 0x2C, 0x24, 0x89,
									 0x04, 0x24, 0xDB, 0x5C, 0x24, 0x04, 0xD9, 0x2C,
									 0x24, 0x8B, 0x44, 0x24, 0x04, 0x88, 0x83, 0x60,
									 0x01, 0x00, 0x00, 0x8B, 0x93, 0x20, 0x01, 0x00,
									 0x00, 0xD9, 0x42, 0x04, 0xA1, 0xD0, 0xFF, 0x6D,
									 0x00, 0x8B, 0x40, 0x18, 0xD8, 0x64, 0x08, 0x10,
									 0xD8, 0x4C, 0x08, 0x1C, 0xD8, 0x05, 0xC4, 0xFF,
									 0x6D, 0x00, 0xD9, 0x44, 0x08, 0x20, 0xD8, 0xD1,
									 0xDF, 0xE0, 0xF6, 0xC4, 0x45, 0x74, 0x02, 0xD9,
									 0xC9, 0xDD, 0xD8, 0xE8, 0x18, 0xBC, 0xFC, 0xFF,
									 0x25, 0xFF, 0x7F, 0x00, 0x00, 0x89, 0x44, 0x24,
									 0x04, 0xDB, 0x44, 0x24, 0x04, 0xD8, 0x0D, 0x8C,
									 0xC6, 0x69, 0x00, 0xDE, 0xD9, 0xDF, 0xE0, 0xF6,
									 0xC4, 0x45, 0x74, 0x09, 0xC6, 0x83, 0x55, 0x01,
									 0x00, 0x00, 0x03, 0xEB, 0x07, 0xC6, 0x83, 0x55,
									 0x01, 0x00, 0x00, 0x02, 0x83, 0xC4, 0x08, 0x5B,
									 0x5A, 0x59, 0x58, 0xC3};

BYTE DriverEscapeCarProc[228] =		{0x50, 0x51, 0x52, 0x53, 0x56, 0x55, 0x8B, 0x5C,
									 0x24, 0x1C, 0x80, 0xBB, 0x56, 0x01, 0x00, 0x00,
									 0x01, 0x75, 0x49, 0x80, 0xBB, 0x55, 0x01, 0x00,
									 0x00, 0x01, 0x90, 0x90, 0x8B, 0xB3, 0xA8, 0x01,
									 0x00, 0x00, 0x85, 0xF6, 0x74, 0x36, 0x80, 0xBE,
									 0x60, 0x01, 0x00, 0x00, 0x02, 0x74, 0x2D, 0x8A,
									 0x43, 0x50, 0x53, 0x24, 0x07, 0x89, 0xF1, 0x0C,
									 0x20, 0x88, 0x43, 0x50, 0x8A, 0x86, 0x50, 0x01,
									 0x00, 0x00, 0x24, 0x7F, 0x0C, 0x80, 0x6A, 0x10,
									 0x88, 0x86, 0x50, 0x01, 0x00, 0x00, 0xE8, 0xAD,
									 0x41, 0xEA, 0xFF, 0x89, 0xF1, 0x6A, 0x78, 0xE8,
									 0x44, 0x49, 0xEA, 0xFF, 0x31, 0xF6, 0xBD, 0xC8,
									 0x00, 0x00, 0x00, 0xEB, 0x6D, 0x8D, 0x84, 0x20,
									 0x00, 0x00, 0x00, 0x00, 0x8B, 0x8C, 0xB3, 0xAC,
									 0x01, 0x00, 0x00, 0x85, 0xC9, 0x74, 0x5A, 0x83,
									 0xB9, 0x64, 0x01, 0x00, 0x00, 0x10, 0x74, 0x51,
									 0x80, 0xB9, 0x60, 0x01, 0x00, 0x00, 0x02, 0x74,
									 0x48, 0x8A, 0x81, 0x50, 0x01, 0x00, 0x00, 0x53,
									 0x24, 0x7F, 0x0C, 0x80, 0x88, 0x81, 0x50, 0x01,
									 0x00, 0x00, 0x8B, 0x8C, 0xB3, 0xAC, 0x01, 0x00,
									 0x00, 0x6A, 0x10, 0xE8, 0x58, 0x41, 0xEA, 0xFF,
									 0x89, 0xEA, 0x8B, 0x84, 0xB3, 0xAC, 0x01, 0x00,
									 0x00, 0x03, 0x15, 0x2C, 0x4B, 0x97, 0x00, 0x89,
									 0x90, 0x50, 0x05, 0x00, 0x00, 0x8B, 0x8C, 0xB3,
									 0xAC, 0x01, 0x00, 0x00, 0x6A, 0x78, 0xE8, 0xD5,
									 0x48, 0xEA, 0xFF, 0x81, 0xC5, 0xC8, 0x00, 0x00,
									 0x00, 0x46, 0x0F, 0xB6, 0x83, 0xD0, 0x01, 0x00,
									 0x00, 0x39, 0xC6, 0x7C, 0x8F, 0x5D, 0x5E, 0x5B,
									 0x5A, 0x59, 0x58, 0xC3};

BYTE DriverFreezeProc[205] =		{0x50, 0x51, 0x52, 0x53, 0x56, 0x55, 0x8B, 0x5C,
									 0x24, 0x1C, 0x80, 0xBB, 0x56, 0x01, 0x00, 0x00,
									 0x01, 0x75, 0x41, 0x80, 0xBB, 0x55, 0x01, 0x00,
									 0x00, 0x01, 0x90, 0x90, 0x8B, 0xB3, 0xA8, 0x01,
									 0x00, 0x00, 0x85, 0xF6, 0x74, 0x2E, 0x80, 0xBE,
									 0x60, 0x01, 0x00, 0x00, 0x02, 0x74, 0x25, 0x8A,
									 0x43, 0x50, 0x24, 0x07, 0x89, 0xF1, 0x0C, 0x18,
									 0x88, 0x43, 0x50, 0x8A, 0x86, 0x50, 0x01, 0x00,
									 0x00, 0x24, 0x7F, 0x0C, 0x80, 0x88, 0x86, 0x50,
									 0x01, 0x00, 0x00, 0xC6, 0x83, 0x56, 0x01, 0x00,
									 0x00, 0x00, 0x89, 0xF1, 0x31, 0xF6, 0xBD, 0xC8,
									 0x00, 0x00, 0x00, 0xEB, 0x5E, 0x8D, 0x84, 0x20,
									 0x00, 0x00, 0x00, 0x00, 0x8B, 0x8C, 0xB3, 0xAC,
									 0x01, 0x00, 0x00, 0x85, 0xC9, 0x74, 0x4B, 0x83,
									 0xB9, 0x64, 0x01, 0x00, 0x00, 0x10, 0x74, 0x42,
									 0x80, 0xB9, 0x60, 0x01, 0x00, 0x00, 0x02, 0x74,
									 0x39, 0x8A, 0x81, 0x50, 0x01, 0x00, 0x00, 0x24,
									 0x7F, 0x0C, 0x80, 0x88, 0x81, 0x50, 0x01, 0x00,
									 0x00, 0x8B, 0x8C, 0xB3, 0xAC, 0x01, 0x00, 0x00,
									 0x89, 0xEA, 0x8B, 0x84, 0xB3, 0xAC, 0x01, 0x00,
									 0x00, 0x03, 0x15, 0x2C, 0x4B, 0x97, 0x00, 0x89,
									 0x90, 0x50, 0x05, 0x00, 0x00, 0x8B, 0x8C, 0xB3,
									 0xAC, 0x01, 0x00, 0x00, 0x81, 0xC5, 0xC8, 0x00,
									 0x00, 0x00, 0x46, 0x0F, 0xB6, 0x83, 0xD0, 0x01,
									 0x00, 0x00, 0x39, 0xC6, 0x7C, 0x9E, 0x5D, 0x5E,
									 0x5B, 0x5A, 0x59, 0x58, 0xC3};

BYTE DriverFrenzyProc[159] =		{0x50, 0x51, 0x52, 0x53, 0x83, 0xEC, 0x08, 0x8B,
									 0x5C, 0x24, 0x1C, 0x80, 0xBB, 0x56, 0x01, 0x00,
									 0x00, 0x01, 0x0F, 0x85, 0x7F, 0x00, 0x00, 0x00,
									 0x8B, 0x83, 0xA8, 0x01, 0x00, 0x00, 0x85, 0xC0,
									 0x74, 0x75, 0x8B, 0xD0, 0xA1, 0xD0, 0xFF, 0x6D,
									 0x00, 0x8B, 0x40, 0x18, 0x8B, 0x8A, 0xD4, 0x03,
									 0x00, 0x00, 0x8D, 0x0C, 0xCD, 0x00, 0x00, 0x00,
									 0x00, 0x8D, 0x0C, 0xCD, 0x00, 0x00, 0x00, 0x00,
									 0xD9, 0x44, 0x08, 0x14, 0xD8, 0x0D, 0x3C, 0x28,
									 0x69, 0x00, 0x8B, 0x83, 0x20, 0x01, 0x00, 0x00,
									 0xD8, 0x88, 0x88, 0x00, 0x00, 0x00, 0xD9, 0x3C,
									 0x24, 0x8B, 0x04, 0x24, 0x80, 0x4C, 0x24, 0x01,
									 0x0C, 0xD9, 0x2C, 0x24, 0x89, 0x04, 0x24, 0xDB,
									 0x5C, 0x24, 0x04, 0xD9, 0x2C, 0x24, 0x8B, 0x44,
									 0x24, 0x04, 0x88, 0x83, 0x60, 0x01, 0x00, 0x00,
									 0xC6, 0x83, 0x56, 0x01, 0x00, 0x00, 0x02, 0x8A,
									 0x43, 0x50, 0x24, 0x07, 0x0C, 0x18, 0x88, 0x43,
									 0x50, 0xC6, 0x83, 0x57, 0x01, 0x00, 0x00, 0x00,
									 0xC6, 0x83, 0x55, 0x01, 0x00, 0x00, 0x02, 0x83,
									 0xC4, 0x08, 0x5B, 0x5A, 0x59, 0x58, 0xC3};

BYTE DriverIgnoreProc[1] =			{0xC3};

BYTE SkipAccel[1] =					{0xEB};

BYTE ShotReaction[181] =			{0x50, 0x51, 0x52, 0x8B, 0x83, 0xA8, 0x01, 0x00,
									 0x00, 0x83, 0xF8, 0x00, 0x0F, 0x84, 0x9B, 0x00,
									 0x00, 0x00, 0x80, 0xB8, 0x6B, 0x05, 0x00, 0x00,
									 0xFF, 0x0F, 0x85, 0x8E, 0x00, 0x00, 0x00, 0x8B,
									 0x90, 0xD4, 0x03, 0x00, 0x00, 0xE8, 0xC3, 0xBC,
									 0xFC, 0xFF, 0x25, 0xFF, 0xFF, 0x00, 0x00, 0x50,
									 0x50, 0x89, 0x44, 0x24, 0x04, 0xDB, 0x44, 0x24,
									 0x04, 0xD8, 0x0D, 0x8C, 0xC6, 0x69, 0x00, 0xD8,
									 0x0D, 0xC0, 0xFF, 0x6D, 0x00, 0xD9, 0x3C, 0x24,
									 0x8B, 0x04, 0x24, 0x80, 0x4C, 0x24, 0x01, 0x0C,
									 0xD9, 0x2C, 0x24, 0x89, 0x04, 0x24, 0xDB, 0x5C,
									 0x24, 0x04, 0xD9, 0x2C, 0x24, 0x8B, 0x44, 0x24,
									 0x04, 0x83, 0xC4, 0x08, 0x33, 0xF6, 0x8B, 0x0D,
									 0xD0, 0xFF, 0x6D, 0x00, 0x8B, 0x49, 0x18, 0x8D,
									 0x14, 0xD5, 0x00, 0x00, 0x00, 0x00, 0x8D, 0x14,
									 0xD5, 0x00, 0x00, 0x00, 0x00, 0x8B, 0x4C, 0x11,
									 0x24, 0x33, 0xD2, 0x66, 0x03, 0x14, 0x71, 0x66,
									 0x3B, 0xC2, 0x7C, 0x06, 0x46, 0x83, 0xFE, 0x04,
									 0x7C, 0xF1, 0xA1, 0xD0, 0xFF, 0x6D, 0x00, 0x8B,
									 0x40, 0x20, 0x53, 0xFF, 0x14, 0xB0, 0x5B, 0x8B,
									 0xD6, 0x8B, 0x83, 0xA8, 0x01, 0x00, 0x00, 0x88,
									 0x90, 0x6B, 0x05, 0x00, 0x00, 0x5A, 0x59, 0x58,
									 0xE9, 0x07, 0xB8, 0xF3, 0xFF};

BYTE ShotReactionInst[7] =			{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90};


BYTE DriverEmergencyExitProc[219] =	{0x50, 0x51, 0x52, 0x53, 0x56, 0x55, 0x8B, 0x5C,
									 0x24, 0x1C, 0x80, 0xBB, 0x56, 0x01, 0x00, 0x00,
									 0x01, 0x90, 0x90, 0x8B, 0xB3, 0xA8, 0x01, 0x00,
									 0x00, 0x85, 0xF6, 0x74, 0x36, 0x80, 0xBE, 0x60,
									 0x01, 0x00, 0x00, 0x02, 0x74, 0x2D, 0x8A, 0x43,
									 0x50, 0x24, 0x07, 0x89, 0xF1, 0x0C, 0x18, 0x88,
									 0x43, 0x50, 0x8A, 0x86, 0x50, 0x01, 0x00, 0x00,
									 0x24, 0x7F, 0x0C, 0x80, 0x88, 0x86, 0x50, 0x01,
									 0x00, 0x00, 0x53, 0x6A, 0x10, 0xE8, 0x86, 0x41,
									 0xEA, 0xFF, 0x8B, 0xCE, 0x6A, 0x78, 0xE8, 0x1D,
									 0x49, 0xEA, 0xFF, 0x31, 0xF6, 0xBD, 0xC8, 0x00,
									 0x00, 0x00, 0xEB, 0x6D, 0x8D, 0x84, 0x20, 0x00,
									 0x00, 0x00, 0x00, 0x8B, 0x8C, 0xB3, 0xAC, 0x01,
									 0x00, 0x00, 0x85, 0xC9, 0x74, 0x5A, 0x83, 0xB9,
									 0x64, 0x01, 0x00, 0x00, 0x10, 0x74, 0x51, 0x80,
									 0xB9, 0x60, 0x01, 0x00, 0x00, 0x02, 0x74, 0x48,
									 0x8A, 0x81, 0x50, 0x01, 0x00, 0x00, 0x24, 0x7F,
									 0x0C, 0x80, 0x88, 0x81, 0x50, 0x01, 0x00, 0x00,
									 0x53, 0x6A, 0x10, 0x8B, 0x8C, 0xB3, 0xAC, 0x01,
									 0x00, 0x00, 0xE8, 0x31, 0x41, 0xEA, 0xFF, 0x8B,
									 0xD5, 0x8B, 0x84, 0xB3, 0xAC, 0x01, 0x00, 0x00,
									 0x03, 0x15, 0x2C, 0x4B, 0x97, 0x00, 0x89, 0x90,
									 0x50, 0x05, 0x00, 0x00, 0x8B, 0x8C, 0xB3, 0xAC,
									 0x01, 0x00, 0x00, 0x6A, 0x78, 0xE8, 0xAE, 0x48,
									 0xEA, 0xFF, 0x81, 0xC5, 0xC8, 0x00, 0x00, 0x00,
									 0x46, 0x0F, 0xB6, 0x83, 0xD0, 0x01, 0x00, 0x00,
									 0x39, 0xC6, 0x7C, 0x8F, 0x5D, 0x5E, 0x5B, 0x5A,
									 0x59, 0x58, 0xC3};

BYTE CarfireReaction[147] =			{0xE8, 0xAB, 0x8B, 0xE4, 0xFF, 0x50, 0x51, 0x52,
									 0x83, 0xBB, 0xA8, 0x01, 0x00, 0x00, 0x00, 0x74,
									 0x76, 0x90, 0x90, 0xE8, 0xC8, 0xBA, 0xFC, 0xFF,
									 0x25, 0xFF, 0x7F, 0x00, 0x00, 0x50, 0x50, 0xDB,
									 0x44, 0x24, 0x04, 0xD8, 0x0D, 0x8C, 0xC6, 0x69,
									 0x00, 0xD8, 0x0D, 0xE8, 0xA0, 0x72, 0x03, 0xD9,
									 0x3C, 0x24, 0x8B, 0x04, 0x24, 0x80, 0x4C, 0x24,
									 0x01, 0x0C, 0xD9, 0x2C, 0x24, 0x89, 0x04, 0x24,
									 0xDB, 0x5C, 0x24, 0x04, 0xD9, 0x2C, 0x24, 0x8B,
									 0x44, 0x24, 0x04, 0x83, 0xC4, 0x08, 0x8B, 0x93,
									 0xA8, 0x01, 0x00, 0x00, 0x8B, 0x92, 0xD4, 0x03,
									 0x00, 0x00, 0x8D, 0x14, 0xD5, 0x00, 0x00, 0x00,
									 0x00, 0x8D, 0x14, 0xD5, 0x00, 0x00, 0x00, 0x00,
									 0x8B, 0x0D, 0xD0, 0xFF, 0x6D, 0x00, 0x8B, 0x49,
									 0x18, 0x0F, 0xB7, 0x4C, 0x11, 0x0A, 0x3B, 0xC1,
									 0x7D, 0x0D, 0xA1, 0xD0, 0xFF, 0x6D, 0x00, 0x8B,
									 0x40, 0x20, 0x53, 0xFF, 0x50, 0x14, 0x5B, 0x5A,
									 0x59, 0x58, 0xE9, 0xB5, 0x6C, 0xE7, 0xFC};
BYTE CarfireReactionInst[5] =		{0xE9, 0x00, 0x00, 0x00, 0x00};



void InstallCustomDriverBehaviour()
{
	DWORD protect1, protect2;

	CreateDrivSpd[16] = LOBYTE(LOWORD((DWORD) Address687214));
	CreateDrivSpd[17] = HIBYTE(LOWORD((DWORD) Address687214));
	CreateDrivSpd[18] = LOBYTE(HIWORD((DWORD) Address687214));
	CreateDrivSpd[19] = HIBYTE(HIWORD((DWORD) Address687214));
	CreateDrivSpd[22] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	CreateDrivSpd[23] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	CreateDrivSpd[24] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	CreateDrivSpd[25] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	DWORD relCallDist1 =  ((DWORD) RandomNumberCallDest) - ((DWORD) CreateDrivSpd+5);
	CreateDrivSpd[1] = LOBYTE(LOWORD(relCallDist1));
	CreateDrivSpd[2] = HIBYTE(LOWORD(relCallDist1));
	CreateDrivSpd[3] = LOBYTE(HIWORD(relCallDist1));
	CreateDrivSpd[4] = HIBYTE(HIWORD(relCallDist1));
	DWORD relCallDist2 =  ((DWORD) PedTypeCounterProc) - ((DWORD) CreateDrivSpd+111);
	CreateDrivSpd[107] = LOBYTE(LOWORD(relCallDist2));
	CreateDrivSpd[108] = HIBYTE(LOWORD(relCallDist2));
	CreateDrivSpd[109] = LOBYTE(HIWORD(relCallDist2));
	CreateDrivSpd[110] = HIBYTE(HIWORD(relCallDist2));
	long relJumpDist1 =  (((DWORD) CreateDrivSpdInstall)+5) - (((DWORD) CreateDrivSpd)+116);
	CreateDrivSpd[112] = LOBYTE(LOWORD(relJumpDist1));
	CreateDrivSpd[113] = HIBYTE(LOWORD(relJumpDist1));
	CreateDrivSpd[114] = LOBYTE(HIWORD(relJumpDist1));
	CreateDrivSpd[115] = HIBYTE(HIWORD(relJumpDist1));
	long relJumpDist2 =  ((DWORD) CreateDrivSpd) - (((DWORD) CreateDrivSpdInstall)+5);
	CreateDrivSpdInst[1] = LOBYTE(LOWORD(relJumpDist2));
	CreateDrivSpdInst[2] = HIBYTE(LOWORD(relJumpDist2));
	CreateDrivSpdInst[3] = LOBYTE(HIWORD(relJumpDist2));
	CreateDrivSpdInst[4] = HIBYTE(HIWORD(relJumpDist2));
	VirtualProtect(CreateDrivSpdInstall, sizeof(CreateDrivSpdInst), PAGE_READWRITE, &protect1);
	memcpy(CreateDrivSpdInstall, &CreateDrivSpdInst, sizeof(CreateDrivSpdInst));
	VirtualProtect(CreateDrivSpdInstall, sizeof(CreateDrivSpdInst), protect1, &protect2);

	long relJumpDist3 =  (((DWORD) TransferDrivSpdInstall)+6) - (((DWORD) TransferDrivSpd)+38);
	TransferDrivSpd[34] = LOBYTE(LOWORD(relJumpDist3));
	TransferDrivSpd[35] = HIBYTE(LOWORD(relJumpDist3));
	TransferDrivSpd[36] = LOBYTE(HIWORD(relJumpDist3));
	TransferDrivSpd[37] = HIBYTE(HIWORD(relJumpDist3));
	long relJumpDist4 =  ((DWORD) TransferDrivSpd) - (((DWORD) TransferDrivSpdInstall)+5);
	TransferDrivSpdInst[1] = LOBYTE(LOWORD(relJumpDist4));
	TransferDrivSpdInst[2] = HIBYTE(LOWORD(relJumpDist4));
	TransferDrivSpdInst[3] = LOBYTE(HIWORD(relJumpDist4));
	TransferDrivSpdInst[4] = HIBYTE(HIWORD(relJumpDist4));
	VirtualProtect(TransferDrivSpdInstall, sizeof(TransferDrivSpdInst), PAGE_READWRITE, &protect1);
	memcpy(TransferDrivSpdInstall, &TransferDrivSpdInst, sizeof(TransferDrivSpdInst));
	VirtualProtect(TransferDrivSpdInstall, sizeof(TransferDrivSpdInst), protect1, &protect2);

	AdjustDrivSpd[10] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	AdjustDrivSpd[11] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	AdjustDrivSpd[12] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	AdjustDrivSpd[13] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	long relJumpDist5 =  (((DWORD) AdjustDrivSpdInstall)+7) - (((DWORD) AdjustDrivSpd)+93);
	AdjustDrivSpd[89] = LOBYTE(LOWORD(relJumpDist5));
	AdjustDrivSpd[90] = HIBYTE(LOWORD(relJumpDist5));
	AdjustDrivSpd[91] = LOBYTE(HIWORD(relJumpDist5));
	AdjustDrivSpd[92] = HIBYTE(HIWORD(relJumpDist5));
	long relJumpDist6 =  ((DWORD) AdjustDrivSpd) - (((DWORD) AdjustDrivSpdInstall)+5);
	AdjustDrivSpdInst[1] = LOBYTE(LOWORD(relJumpDist6));
	AdjustDrivSpdInst[2] = HIBYTE(LOWORD(relJumpDist6));
	AdjustDrivSpdInst[3] = LOBYTE(HIWORD(relJumpDist6));
	AdjustDrivSpdInst[4] = HIBYTE(HIWORD(relJumpDist6));
	VirtualProtect(AdjustDrivSpdInstall, sizeof(AdjustDrivSpdInst), PAGE_READWRITE, &protect1);
	memcpy(AdjustDrivSpdInstall, &AdjustDrivSpdInst, sizeof(AdjustDrivSpdInst));
	VirtualProtect(AdjustDrivSpdInstall, sizeof(AdjustDrivSpdInst), protect1, &protect2);

	RushSpeedSwitchTable[0] = LOBYTE(LOWORD((DWORD) RushSpeedCarsBikes));
	RushSpeedSwitchTable[1] = HIBYTE(LOWORD((DWORD) RushSpeedCarsBikes));
	RushSpeedSwitchTable[2] = LOBYTE(HIWORD((DWORD) RushSpeedCarsBikes));
	RushSpeedSwitchTable[3] = HIBYTE(HIWORD((DWORD) RushSpeedCarsBikes));
	RushSpeedSwitchTable[4] = LOBYTE(LOWORD((DWORD) RushSpeedCarsBikes));
	RushSpeedSwitchTable[5] = HIBYTE(LOWORD((DWORD) RushSpeedCarsBikes));
	RushSpeedSwitchTable[6] = LOBYTE(HIWORD((DWORD) RushSpeedCarsBikes));
	RushSpeedSwitchTable[7] = HIBYTE(HIWORD((DWORD) RushSpeedCarsBikes));
	
	RushSpeedSwitch[11] = LOBYTE(LOWORD((DWORD) RushSpeedSwitchTable));
	RushSpeedSwitch[12] = HIBYTE(LOWORD((DWORD) RushSpeedSwitchTable));
	RushSpeedSwitch[13] = LOBYTE(HIWORD((DWORD) RushSpeedSwitchTable));
	RushSpeedSwitch[14] = HIBYTE(HIWORD((DWORD) RushSpeedSwitchTable));
	VirtualProtect(RushSpeedSwitchInstall, sizeof(RushSpeedSwitch), PAGE_READWRITE, &protect1);
	memcpy(RushSpeedSwitchInstall, &RushSpeedSwitch, sizeof(RushSpeedSwitch));
	VirtualProtect(RushSpeedSwitchInstall, sizeof(RushSpeedSwitch), protect1, &protect2);

	RushSpeedCarsBikes[43] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	RushSpeedCarsBikes[44] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	RushSpeedCarsBikes[45] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	RushSpeedCarsBikes[46] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	long relJumpDist7 =  (((DWORD) RushSpeedSwitchInstall)+29) - (((DWORD) RushSpeedCarsBikes)+13);
	RushSpeedCarsBikes[9] = LOBYTE(LOWORD(relJumpDist7));
	RushSpeedCarsBikes[10] = HIBYTE(LOWORD(relJumpDist7));
	RushSpeedCarsBikes[11] = LOBYTE(HIWORD(relJumpDist7));
	RushSpeedCarsBikes[12] = HIBYTE(HIWORD(relJumpDist7));
	long relJumpDist8 =  (((DWORD) RushSpeedSwitchInstall)+34) - (((DWORD) RushSpeedCarsBikes)+62);
	RushSpeedCarsBikes[58] = LOBYTE(LOWORD(relJumpDist8));
	RushSpeedCarsBikes[59] = HIBYTE(LOWORD(relJumpDist8));
	RushSpeedCarsBikes[60] = LOBYTE(HIWORD(relJumpDist8));
	RushSpeedCarsBikes[61] = HIBYTE(HIWORD(relJumpDist8));

	RushSpeed[39] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	RushSpeed[40] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	RushSpeed[41] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	RushSpeed[42] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	long relJumpDist9 =  (((DWORD) RushSpeedInstall)+7) - (((DWORD) RushSpeed)+64);
	RushSpeed[60] = LOBYTE(LOWORD(relJumpDist9));
	RushSpeed[61] = HIBYTE(LOWORD(relJumpDist9));
	RushSpeed[62] = LOBYTE(HIWORD(relJumpDist9));
	RushSpeed[63] = HIBYTE(HIWORD(relJumpDist9));
	long relJumpDist10 =  (((DWORD) RushSpeedInstall)+7) - (((DWORD) RushSpeed)+76);
	RushSpeed[72] = LOBYTE(LOWORD(relJumpDist10));
	RushSpeed[73] = HIBYTE(LOWORD(relJumpDist10));
	RushSpeed[74] = LOBYTE(HIWORD(relJumpDist10));
	RushSpeed[75] = HIBYTE(HIWORD(relJumpDist10));
	long relJumpDist11 =  ((DWORD) RushSpeed) - (((DWORD) RushSpeedInstall)+5);
	RushSpeedInst[1] = LOBYTE(LOWORD(relJumpDist11));
	RushSpeedInst[2] = HIBYTE(LOWORD(relJumpDist11));
	RushSpeedInst[3] = LOBYTE(HIWORD(relJumpDist11));
	RushSpeedInst[4] = HIBYTE(HIWORD(relJumpDist11));
	VirtualProtect(RushSpeedInstall, sizeof(RushSpeedInst), PAGE_READWRITE, &protect1);
	memcpy(RushSpeedInstall, &RushSpeedInst, sizeof(RushSpeedInst));
	VirtualProtect(RushSpeedInstall, sizeof(RushSpeedInst), protect1, &protect2);
}

void InstallCustomDriverBehaviourProcs()
{
	DWORD protect1, protect2;

	DriverFleeProc[82] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	DriverFleeProc[83] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	DriverFleeProc[84] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	DriverFleeProc[85] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	DriverFleeProc[157] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	DriverFleeProc[158] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	DriverFleeProc[159] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	DriverFleeProc[160] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	void* aHalfptr = (void*) &aHalf;
	DriverFleeProc[174] = LOBYTE(LOWORD((DWORD) aHalfptr));
	DriverFleeProc[175] = HIBYTE(LOWORD((DWORD) aHalfptr));
	DriverFleeProc[176] = LOBYTE(HIWORD((DWORD) aHalfptr));
	DriverFleeProc[177] = HIBYTE(HIWORD((DWORD) aHalfptr));
	DriverFleeProc[215] = LOBYTE(LOWORD((DWORD) Address69C68C));
	DriverFleeProc[216] = HIBYTE(LOWORD((DWORD) Address69C68C));
	DriverFleeProc[217] = LOBYTE(HIWORD((DWORD) Address69C68C));
	DriverFleeProc[218] = HIBYTE(HIWORD((DWORD) Address69C68C));
	DWORD relCallDist1 =  ((DWORD) RandomNumberCallDest) - ((DWORD) DriverFleeProc+200);
	DriverFleeProc[196] = LOBYTE(LOWORD(relCallDist1));
	DriverFleeProc[197] = HIBYTE(LOWORD(relCallDist1));
	DriverFleeProc[198] = LOBYTE(HIWORD(relCallDist1));
	DriverFleeProc[199] = HIBYTE(HIWORD(relCallDist1));
	driverShotReactions[3] = (DWORD) DriverFleeProc;

	DriverEscapeCarProc[179] = LOBYTE(LOWORD((DWORD) IngameTimerInMS));
	DriverEscapeCarProc[180] = HIBYTE(LOWORD((DWORD) IngameTimerInMS));
	DriverEscapeCarProc[181] = LOBYTE(HIWORD((DWORD) IngameTimerInMS));
	DriverEscapeCarProc[182] = HIBYTE(HIWORD((DWORD) IngameTimerInMS));
	DWORD relCallDist2 =  ((DWORD) LeaveVehicleProc) - ((DWORD) DriverEscapeCarProc+83);
	DriverEscapeCarProc[79] = LOBYTE(LOWORD(relCallDist2));
	DriverEscapeCarProc[80] = HIBYTE(LOWORD(relCallDist2));
	DriverEscapeCarProc[81] = LOBYTE(HIWORD(relCallDist2));
	DriverEscapeCarProc[82] = HIBYTE(HIWORD(relCallDist2));
	DWORD relCallDist3 =  ((DWORD) SomeProc) - ((DWORD) DriverEscapeCarProc+92);
	DriverEscapeCarProc[88] = LOBYTE(LOWORD(relCallDist3));
	DriverEscapeCarProc[89] = HIBYTE(LOWORD(relCallDist3));
	DriverEscapeCarProc[90] = LOBYTE(HIWORD(relCallDist3));
	DriverEscapeCarProc[91] = HIBYTE(HIWORD(relCallDist3));
	DWORD relCallDist4 =  ((DWORD) LeaveVehicleProc) - ((DWORD) DriverEscapeCarProc+168);
	DriverEscapeCarProc[164] = LOBYTE(LOWORD(relCallDist4));
	DriverEscapeCarProc[165] = HIBYTE(LOWORD(relCallDist4));
	DriverEscapeCarProc[166] = LOBYTE(HIWORD(relCallDist4));
	DriverEscapeCarProc[167] = HIBYTE(HIWORD(relCallDist4));
	DWORD relCallDist5 =  ((DWORD) SomeProc) - ((DWORD) DriverEscapeCarProc+203);
	DriverEscapeCarProc[199] = LOBYTE(LOWORD(relCallDist5));
	DriverEscapeCarProc[200] = HIBYTE(LOWORD(relCallDist5));
	DriverEscapeCarProc[201] = LOBYTE(HIWORD(relCallDist5));
	DriverEscapeCarProc[202] = HIBYTE(HIWORD(relCallDist5));
	driverShotReactions[2] = (DWORD) DriverEscapeCarProc;

	DriverFreezeProc[163] = LOBYTE(LOWORD((DWORD) IngameTimerInMS));
	DriverFreezeProc[164] = HIBYTE(LOWORD((DWORD) IngameTimerInMS));
	DriverFreezeProc[165] = LOBYTE(HIWORD((DWORD) IngameTimerInMS));
	DriverFreezeProc[166] = HIBYTE(HIWORD((DWORD) IngameTimerInMS));
	driverShotReactions[1] = (DWORD) DriverFreezeProc;

	DriverFrenzyProc[37] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	DriverFrenzyProc[38] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	DriverFrenzyProc[39] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	DriverFrenzyProc[40] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	DriverFrenzyProc[70] = LOBYTE(LOWORD((DWORD) Address69283C));
	DriverFrenzyProc[71] = HIBYTE(LOWORD((DWORD) Address69283C));
	DriverFrenzyProc[72] = LOBYTE(HIWORD((DWORD) Address69283C));
	DriverFrenzyProc[73] = HIBYTE(HIWORD((DWORD) Address69283C));
	driverShotReactions[4] = (DWORD) DriverFrenzyProc;
	
	driverShotReactions[0] = (DWORD) DriverIgnoreProc;

	VirtualProtect(SkipAccelInstall, sizeof(SkipAccel), PAGE_READWRITE, &protect1);
	memcpy(SkipAccelInstall, &SkipAccel, sizeof(SkipAccel));
	VirtualProtect(SkipAccelInstall, sizeof(SkipAccel), protect1, &protect2);

	ShotReaction[59] = LOBYTE(LOWORD((DWORD) Address69C68C));
	ShotReaction[60] = HIBYTE(LOWORD((DWORD) Address69C68C));
	ShotReaction[61] = LOBYTE(HIWORD((DWORD) Address69C68C));
	ShotReaction[62] = HIBYTE(HIWORD((DWORD) Address69C68C));
	void* aThousand = (void*) &thousand;
	ShotReaction[65] = LOBYTE(LOWORD((DWORD) aThousand));
	ShotReaction[66] = HIBYTE(LOWORD((DWORD) aThousand));
	ShotReaction[67] = LOBYTE(HIWORD((DWORD) aThousand));
	ShotReaction[68] = HIBYTE(HIWORD((DWORD) aThousand));
	ShotReaction[104] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	ShotReaction[105] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	ShotReaction[106] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	ShotReaction[107] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	ShotReaction[147] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	ShotReaction[148] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	ShotReaction[149] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	ShotReaction[150] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	DWORD relCallDist6 =  ((DWORD) RandomNumberCallDest) - ((DWORD) ShotReaction+42);
	ShotReaction[38] = LOBYTE(LOWORD(relCallDist6));
	ShotReaction[39] = HIBYTE(LOWORD(relCallDist6));
	ShotReaction[40] = LOBYTE(HIWORD(relCallDist6));
	ShotReaction[41] = HIBYTE(HIWORD(relCallDist6));
	long relJumpDist1 =  ((DWORD) ShotReactionBackJump) - (((DWORD) ShotReaction)+181);
	ShotReaction[177] = LOBYTE(LOWORD(relJumpDist1));
	ShotReaction[178] = HIBYTE(LOWORD(relJumpDist1));
	ShotReaction[179] = LOBYTE(HIWORD(relJumpDist1));
	ShotReaction[180] = HIBYTE(HIWORD(relJumpDist1));
	long relJumpDist2 =  ((DWORD) ShotReaction) - (((DWORD) ShotReactionInstall)+5);
	ShotReactionInst[1] = LOBYTE(LOWORD(relJumpDist2));
	ShotReactionInst[2] = HIBYTE(LOWORD(relJumpDist2));
	ShotReactionInst[3] = LOBYTE(HIWORD(relJumpDist2));
	ShotReactionInst[4] = HIBYTE(HIWORD(relJumpDist2));
	VirtualProtect(ShotReactionInstall, sizeof(ShotReactionInst), PAGE_READWRITE, &protect1);
	memcpy(ShotReactionInstall, &ShotReactionInst, sizeof(ShotReactionInst));
	VirtualProtect(ShotReactionInstall, sizeof(ShotReactionInst), protect1, &protect2);

	DriverEmergencyExitProc[170] = LOBYTE(LOWORD((DWORD) IngameTimerInMS));
	DriverEmergencyExitProc[171] = HIBYTE(LOWORD((DWORD) IngameTimerInMS));
	DriverEmergencyExitProc[172] = LOBYTE(HIWORD((DWORD) IngameTimerInMS));
	DriverEmergencyExitProc[173] = HIBYTE(HIWORD((DWORD) IngameTimerInMS));
	DWORD relCallDist7 =  ((DWORD) LeaveVehicleProc) - ((DWORD) DriverEmergencyExitProc+74);
	DriverEmergencyExitProc[70] = LOBYTE(LOWORD(relCallDist7));
	DriverEmergencyExitProc[71] = HIBYTE(LOWORD(relCallDist7));
	DriverEmergencyExitProc[72] = LOBYTE(HIWORD(relCallDist7));
	DriverEmergencyExitProc[73] = HIBYTE(HIWORD(relCallDist7));
	DWORD relCallDist8 =  ((DWORD) SomeProc) - ((DWORD) DriverEmergencyExitProc+83);
	DriverEmergencyExitProc[79] = LOBYTE(LOWORD(relCallDist8));
	DriverEmergencyExitProc[80] = HIBYTE(LOWORD(relCallDist8));
	DriverEmergencyExitProc[81] = LOBYTE(HIWORD(relCallDist8));
	DriverEmergencyExitProc[82] = HIBYTE(HIWORD(relCallDist8));
	DWORD relCallDist9 =  ((DWORD) LeaveVehicleProc) - ((DWORD) DriverEmergencyExitProc+159);
	DriverEmergencyExitProc[155] = LOBYTE(LOWORD(relCallDist9));
	DriverEmergencyExitProc[156] = HIBYTE(LOWORD(relCallDist9));
	DriverEmergencyExitProc[157] = LOBYTE(HIWORD(relCallDist9));
	DriverEmergencyExitProc[158] = HIBYTE(HIWORD(relCallDist9));
	DWORD relCallDist10 =  ((DWORD) SomeProc) - ((DWORD) DriverEmergencyExitProc+194);
	DriverEmergencyExitProc[190] = LOBYTE(LOWORD(relCallDist10));
	DriverEmergencyExitProc[191] = HIBYTE(LOWORD(relCallDist10));
	DriverEmergencyExitProc[192] = LOBYTE(HIWORD(relCallDist10));
	DriverEmergencyExitProc[193] = HIBYTE(HIWORD(relCallDist10));
	driverShotReactions[5] = (DWORD) DriverEmergencyExitProc;

	CarfireReaction[37] = LOBYTE(LOWORD((DWORD) Address69C68C));
	CarfireReaction[38] = HIBYTE(LOWORD((DWORD) Address69C68C));
	CarfireReaction[39] = LOBYTE(HIWORD((DWORD) Address69C68C));
	CarfireReaction[40] = HIBYTE(HIWORD((DWORD) Address69C68C));
	CarfireReaction[43] = LOBYTE(LOWORD((DWORD) aThousand));
	CarfireReaction[44] = HIBYTE(LOWORD((DWORD) aThousand));
	CarfireReaction[45] = LOBYTE(HIWORD((DWORD) aThousand));
	CarfireReaction[46] = HIBYTE(HIWORD((DWORD) aThousand));
	CarfireReaction[106] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	CarfireReaction[107] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	CarfireReaction[108] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	CarfireReaction[109] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	CarfireReaction[123] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	CarfireReaction[124] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	CarfireReaction[125] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	CarfireReaction[126] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	DWORD relCallDist11 =  ((DWORD) SomeProc2) - ((DWORD) CarfireReaction+5);
	CarfireReaction[1] = LOBYTE(LOWORD(relCallDist11));
	CarfireReaction[2] = HIBYTE(LOWORD(relCallDist11));
	CarfireReaction[3] = LOBYTE(HIWORD(relCallDist11));
	CarfireReaction[4] = HIBYTE(HIWORD(relCallDist11));
	DWORD relCallDist12 =  ((DWORD) RandomNumberCallDest) - ((DWORD) CarfireReaction+24);
	CarfireReaction[20] = LOBYTE(LOWORD(relCallDist12));
	CarfireReaction[21] = HIBYTE(LOWORD(relCallDist12));
	CarfireReaction[22] = LOBYTE(HIWORD(relCallDist12));
	CarfireReaction[23] = HIBYTE(HIWORD(relCallDist12));
	long relJumpDist4 =  ((DWORD) CarfireReactionBackJump) - (((DWORD) CarfireReaction)+143);
	CarfireReaction[139] = LOBYTE(LOWORD(relJumpDist4));
	CarfireReaction[140] = HIBYTE(LOWORD(relJumpDist4));
	CarfireReaction[141] = LOBYTE(HIWORD(relJumpDist4));
	CarfireReaction[142] = HIBYTE(HIWORD(relJumpDist4));
	long relJumpDist5 =  ((DWORD) CarfireReaction) - (((DWORD) CarfireReactionInstall)+5);
	CarfireReactionInst[1] = LOBYTE(LOWORD(relJumpDist5));
	CarfireReactionInst[2] = HIBYTE(LOWORD(relJumpDist5));
	CarfireReactionInst[3] = LOBYTE(HIWORD(relJumpDist5));
	CarfireReactionInst[4] = HIBYTE(HIWORD(relJumpDist5));
	VirtualProtect(CarfireReactionInstall, sizeof(CarfireReactionInst), PAGE_READWRITE, &protect1);
	memcpy(CarfireReactionInstall, &CarfireReactionInst, sizeof(CarfireReactionInst));
	VirtualProtect(CarfireReactionInstall, sizeof(CarfireReactionInst), protect1, &protect2);
}

//***********************************************
//GANG SET-UP
//***********************************************
DWORD *GangGroupSizeInstall = (DWORD *) 0x53C213;
DWORD *SizeAdderBlankInstall = (DWORD *) 0x53C244;
DWORD *GangSpawnAsSwitchInstall = (DWORD *) 0x53C44B;
DWORD *MinWalkingInstall = (DWORD *) 0x53A5F8;
DWORD *MinChatingInstall = (DWORD *) 0x539E6E;
DWORD *PIGFix1Install = (DWORD *) 0x53C1F3;
DWORD *PIGFix2Install = (DWORD *) 0x53C42B;


DWORD *ToWalkJump = (DWORD *) 0x53C467;
DWORD *ToChatJump = (DWORD *) 0x53C484;



BYTE GangGroupSize[54] =			{0x50, 0x51, 0xA1, 0xD0, 0xFF, 0x6D, 0x00, 0x8B,
									 0x40, 0x24, 0x8B, 0x4C, 0x24, 0x28, 0x83, 0xE9,
									 0x07, 0x8D, 0x0C, 0xCD, 0x00, 0x00, 0x00, 0x00,
									 0x8D, 0x0C, 0xCD, 0x00, 0x00, 0x00, 0x00, 0xD9,
									 0xE8, 0xD8, 0x44, 0x08, 0x04, 0xD8, 0x24, 0x08,
									 0xDC, 0xC9, 0xDD, 0xD8, 0xD8, 0x04, 0x08, 0x59,
									 0x58, 0xE9, 0xD3, 0xE4, 0xEB, 0xFF};
BYTE GangGroupSizeInst[6] =			{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90};

BYTE SizeAdderBlank[5] =			{0x90, 0x90, 0x90, 0x90, 0x90};

BYTE GangSpawnAsSwitch[125] =		{0x50, 0x51, 0x52, 0xD8, 0x0D, 0xC0, 0xFF, 0x6D,
									 0x00, 0xD9, 0x7C, 0x24, 0x3C, 0x8B, 0x44, 0x24,
									 0x3C, 0x80, 0x4C, 0x24, 0x3D, 0x0C, 0xD9, 0x6C,
									 0x24, 0x3C, 0x89, 0x44, 0x24, 0x3C, 0xDB, 0x5C,
									 0x24, 0x0C, 0xD9, 0x6C, 0x24, 0x3C, 0x8B, 0x54,
									 0x24, 0x0C, 0xA1, 0xD0, 0xFF, 0x6D, 0x00, 0x8B,
									 0x40, 0x24, 0x8B, 0x4C, 0x24, 0x2C, 0x83, 0xE9,
									 0x07, 0x3E, 0x8D, 0x0C, 0xCD, 0x00, 0x00, 0x00,
									 0x00, 0x3E, 0x8D, 0x0C, 0xCD, 0x00, 0x00, 0x00,
									 0x00, 0x03, 0xC8, 0x0F, 0xB7, 0x41, 0x08, 0x66,
									 0x3B, 0xD0, 0x7D, 0x10, 0xC7, 0x44, 0x24, 0x20,
									 0x01, 0x00, 0x00, 0x00, 0x5A, 0x59, 0x58, 0xE9,
									 0x93, 0xE6, 0xEB, 0xFF, 0x66, 0x03, 0x41, 0x0A,
									 0x66, 0x3B, 0xD0, 0x7D, 0x08, 0x5A, 0x59, 0x58,
									 0xE9, 0x82, 0xE6, 0xEB, 0xFF, 0x5A, 0x59, 0x58,
									 0xE9, 0x97, 0xE6, 0xEB, 0xFF};
BYTE GangSpawnAsSwitchInst[6] =		{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90};

BYTE MinWalking[1] =				{0x01};

BYTE MinChating[1] =				{0x02};

BYTE PIGFix[2] =					{0x90, 0x90};


void InstallCustomGangs()
{
	DWORD protect1, protect2;

	GangGroupSize[3] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	GangGroupSize[4] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	GangGroupSize[5] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	GangGroupSize[6] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	long relJumpDist1 =  (((DWORD) GangGroupSizeInstall)+6) - (((DWORD) GangGroupSize)+54);
	GangGroupSize[50] = LOBYTE(LOWORD(relJumpDist1));
	GangGroupSize[51] = HIBYTE(LOWORD(relJumpDist1));
	GangGroupSize[52] = LOBYTE(HIWORD(relJumpDist1));
	GangGroupSize[53] = HIBYTE(HIWORD(relJumpDist1));
	long relJumpDist2 =  ((DWORD) GangGroupSize) - (((DWORD) GangGroupSizeInstall)+5);
	GangGroupSizeInst[1] = LOBYTE(LOWORD(relJumpDist2));
	GangGroupSizeInst[2] = HIBYTE(LOWORD(relJumpDist2));
	GangGroupSizeInst[3] = LOBYTE(HIWORD(relJumpDist2));
	GangGroupSizeInst[4] = HIBYTE(HIWORD(relJumpDist2));
	VirtualProtect(GangGroupSizeInstall, sizeof(GangGroupSizeInst), PAGE_READWRITE, &protect1);
	memcpy(GangGroupSizeInstall, &GangGroupSizeInst, sizeof(GangGroupSizeInst));
	VirtualProtect(GangGroupSizeInstall, sizeof(GangGroupSizeInst), protect1, &protect2);

	VirtualProtect(SizeAdderBlankInstall, sizeof(SizeAdderBlank), PAGE_READWRITE, &protect1);
	memcpy(SizeAdderBlankInstall, &SizeAdderBlank, sizeof(SizeAdderBlank));
	VirtualProtect(SizeAdderBlankInstall, sizeof(SizeAdderBlank), protect1, &protect2);

	void* aThousand = (void*) &thousand;
	GangSpawnAsSwitch[5] = LOBYTE(LOWORD((DWORD) aThousand));
	GangSpawnAsSwitch[6] = HIBYTE(LOWORD((DWORD) aThousand));
	GangSpawnAsSwitch[7] = LOBYTE(HIWORD((DWORD) aThousand));
	GangSpawnAsSwitch[8] = HIBYTE(HIWORD((DWORD) aThousand));
	GangSpawnAsSwitch[43] = LOBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	GangSpawnAsSwitch[44] = HIBYTE(LOWORD((DWORD) VC_TrafficPointerAddr));
	GangSpawnAsSwitch[45] = LOBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	GangSpawnAsSwitch[46] = HIBYTE(HIWORD((DWORD) VC_TrafficPointerAddr));
	long relJumpDist3 =  ((DWORD) ToWalkJump) - (((DWORD) GangSpawnAsSwitch)+100);
	GangSpawnAsSwitch[96] = LOBYTE(LOWORD(relJumpDist3));
	GangSpawnAsSwitch[97] = HIBYTE(LOWORD(relJumpDist3));
	GangSpawnAsSwitch[98] = LOBYTE(HIWORD(relJumpDist3));
	GangSpawnAsSwitch[99] = HIBYTE(HIWORD(relJumpDist3));
	long relJumpDist4 =  ((DWORD) ToWalkJump) - (((DWORD) GangSpawnAsSwitch)+117);
	GangSpawnAsSwitch[113] = LOBYTE(LOWORD(relJumpDist4));
	GangSpawnAsSwitch[114] = HIBYTE(LOWORD(relJumpDist4));
	GangSpawnAsSwitch[115] = LOBYTE(HIWORD(relJumpDist4));
	GangSpawnAsSwitch[116] = HIBYTE(HIWORD(relJumpDist4));
	long relJumpDist5 =  ((DWORD) ToChatJump) - (((DWORD) GangSpawnAsSwitch)+125);
	GangSpawnAsSwitch[121] = LOBYTE(LOWORD(relJumpDist5));
	GangSpawnAsSwitch[122] = HIBYTE(LOWORD(relJumpDist5));
	GangSpawnAsSwitch[123] = LOBYTE(HIWORD(relJumpDist5));
	GangSpawnAsSwitch[124] = HIBYTE(HIWORD(relJumpDist5));
	long relJumpDist6 =  ((DWORD) GangSpawnAsSwitch) - (((DWORD) GangSpawnAsSwitchInstall)+5);
	GangSpawnAsSwitchInst[1] = LOBYTE(LOWORD(relJumpDist6));
	GangSpawnAsSwitchInst[2] = HIBYTE(LOWORD(relJumpDist6));
	GangSpawnAsSwitchInst[3] = LOBYTE(HIWORD(relJumpDist6));
	GangSpawnAsSwitchInst[4] = HIBYTE(HIWORD(relJumpDist6));
	VirtualProtect(GangSpawnAsSwitchInstall, sizeof(GangSpawnAsSwitchInst), PAGE_READWRITE, &protect1);
	memcpy(GangSpawnAsSwitchInstall, &GangSpawnAsSwitchInst, sizeof(GangSpawnAsSwitchInst));
	VirtualProtect(GangSpawnAsSwitchInstall, sizeof(GangSpawnAsSwitchInst), protect1, &protect2);

	VirtualProtect(MinWalkingInstall, sizeof(MinWalking), PAGE_READWRITE, &protect1);
	memcpy(MinWalkingInstall, &MinWalking, sizeof(MinWalking));
	VirtualProtect(MinWalkingInstall, sizeof(MinWalking), protect1, &protect2);

	VirtualProtect(MinChatingInstall, sizeof(MinChating), PAGE_READWRITE, &protect1);
	memcpy(MinChatingInstall, &MinChating, sizeof(MinChating));
	VirtualProtect(MinChatingInstall, sizeof(MinChating), protect1, &protect2);

	VirtualProtect(PIGFix1Install, sizeof(PIGFix), PAGE_READWRITE, &protect1);
	memcpy(PIGFix1Install, &PIGFix, sizeof(PIGFix));
	VirtualProtect(PIGFix1Install, sizeof(PIGFix), protect1, &protect2);
	VirtualProtect(PIGFix2Install, sizeof(PIGFix), PAGE_READWRITE, &protect1);
	memcpy(PIGFix2Install, &PIGFix, sizeof(PIGFix));
	VirtualProtect(PIGFix2Install, sizeof(PIGFix), protect1, &protect2);
}

//***********************************************
//TAXI FIX
//***********************************************
DWORD *TaxiFixInstall = (DWORD *) 0x455E46;
DWORD *TaxiFixSkipJump = (DWORD *) 0x455FD6;

float zero = 0.0f;
float zoneX = 90.0f;
float zoneY = 90.0f;
float zoneZ = 20.0f;

BYTE TaxiFix[172] =					{0x50, 0x51, 0x52, 0xA1, 0xAC, 0xF2, 0x97, 0x00,
									 0x8B, 0x00, 0x80, 0xB8, 0xAC, 0x03, 0x00, 0x00,
									 0x00, 0x74, 0x06, 0x8B, 0x80, 0xA8, 0x03, 0x00,
									 0x00, 0xD9, 0x40, 0x34, 0xD8, 0x63, 0x34, 0xD8,
									 0x15, 0xB0, 0xFF, 0x6D, 0x00, 0x8B, 0xD0, 0xDF,
									 0xE0, 0x80, 0xE4, 0x05, 0x74, 0x02, 0xD9, 0xE0,
									 0xD8, 0x1D, 0xB4, 0xFF, 0x6D, 0x00, 0xDF, 0xE0,
									 0x80, 0xE4, 0x45, 0x75, 0x08, 0x5A, 0x59, 0x58,
									 0xE9, 0x31, 0x82, 0xDD, 0xFF, 0xD9, 0x42, 0x38,
									 0xD8, 0x63, 0x38, 0xD8, 0x15, 0xB0, 0xFF, 0x6D,
									 0x00, 0x8B, 0xC2, 0xDF, 0xE0, 0x80, 0xE4, 0x05,
									 0x74, 0x02, 0xD9, 0xE0, 0xD8, 0x1D, 0xB8, 0xFF,
									 0x6D, 0x00, 0xDF, 0xE0, 0x80, 0xE4, 0x45, 0x75,
									 0x08, 0x5A, 0x59, 0x58, 0xE9, 0x05, 0x82, 0xDD,
									 0xFF, 0xD9, 0x42, 0x3C, 0xD8, 0x63, 0x3C, 0xD8,
									 0x15, 0xB0, 0xFF, 0x6D, 0x00, 0x8B, 0xC2, 0xDF,
									 0xE0, 0x80, 0xE4, 0x05, 0x74, 0x02, 0xD9, 0xE0,
									 0xD8, 0x1D, 0xBC, 0xFF, 0x6D, 0x00, 0xDF, 0xE0,
									 0x80, 0xE4, 0x45, 0x75, 0x08, 0x5A, 0x59, 0x58,
									 0xE9, 0xD9, 0x81, 0xDD, 0xFF, 0x5A, 0x59, 0x58,
									 0x80, 0xBB, 0x60, 0x01, 0x00, 0x00, 0x01, 0xE9,
									 0x41, 0x80, 0xDD, 0xFF};
BYTE TaxiFixInst[7] =				{0xE9, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90};

void InstallTaxiFix()
{
	DWORD protect1, protect2;
	signed long relDist = 0;

	TaxiFix[4] = LOBYTE(LOWORD((DWORD) PtrToPlayer));
	TaxiFix[5] = HIBYTE(LOWORD((DWORD) PtrToPlayer));
	TaxiFix[6] = LOBYTE(HIWORD((DWORD) PtrToPlayer));
	TaxiFix[7] = HIBYTE(HIWORD((DWORD) PtrToPlayer));
	TaxiFix[33] = LOBYTE(LOWORD((DWORD) &zero));
	TaxiFix[34] = HIBYTE(LOWORD((DWORD) &zero));
	TaxiFix[35] = LOBYTE(HIWORD((DWORD) &zero));
	TaxiFix[36] = HIBYTE(HIWORD((DWORD) &zero));
	TaxiFix[50] = LOBYTE(LOWORD((DWORD) &zoneX));
	TaxiFix[51] = HIBYTE(LOWORD((DWORD) &zoneX));
	TaxiFix[52] = LOBYTE(HIWORD((DWORD) &zoneX));
	TaxiFix[53] = HIBYTE(HIWORD((DWORD) &zoneX));
	TaxiFix[77] = LOBYTE(LOWORD((DWORD) &zero));
	TaxiFix[78] = HIBYTE(LOWORD((DWORD) &zero));
	TaxiFix[79] = LOBYTE(HIWORD((DWORD) &zero));
	TaxiFix[80] = HIBYTE(HIWORD((DWORD) &zero));
	TaxiFix[94] = LOBYTE(LOWORD((DWORD) &zoneY));
	TaxiFix[95] = HIBYTE(LOWORD((DWORD) &zoneY));
	TaxiFix[96] = LOBYTE(HIWORD((DWORD) &zoneY));
	TaxiFix[97] = HIBYTE(HIWORD((DWORD) &zoneY));
	TaxiFix[121] = LOBYTE(LOWORD((DWORD) &zero));
	TaxiFix[122] = HIBYTE(LOWORD((DWORD) &zero));
	TaxiFix[123] = LOBYTE(HIWORD((DWORD) &zero));
	TaxiFix[124] = HIBYTE(HIWORD((DWORD) &zero));
	TaxiFix[138] = LOBYTE(LOWORD((DWORD) &zoneZ));
	TaxiFix[139] = HIBYTE(LOWORD((DWORD) &zoneZ));
	TaxiFix[140] = LOBYTE(HIWORD((DWORD) &zoneZ));
	TaxiFix[141] = HIBYTE(HIWORD((DWORD) &zoneZ));

	relDist =  ((DWORD) TaxiFixSkipJump) - (((DWORD) TaxiFix)+69);
	TaxiFix[65] = LOBYTE(LOWORD(relDist));
	TaxiFix[66] = HIBYTE(LOWORD(relDist));
	TaxiFix[67] = LOBYTE(HIWORD(relDist));
	TaxiFix[68] = HIBYTE(HIWORD(relDist));
	relDist =  ((DWORD) TaxiFixSkipJump) - (((DWORD) TaxiFix)+113);
	TaxiFix[109] = LOBYTE(LOWORD(relDist));
	TaxiFix[110] = HIBYTE(LOWORD(relDist));
	TaxiFix[111] = LOBYTE(HIWORD(relDist));
	TaxiFix[112] = HIBYTE(HIWORD(relDist));
	relDist =  ((DWORD) TaxiFixSkipJump) - (((DWORD) TaxiFix)+157);
	TaxiFix[153] = LOBYTE(LOWORD(relDist));
	TaxiFix[154] = HIBYTE(LOWORD(relDist));
	TaxiFix[155] = LOBYTE(HIWORD(relDist));
	TaxiFix[156] = HIBYTE(HIWORD(relDist));
	relDist =  (((DWORD) TaxiFixInstall)+7) - (((DWORD) TaxiFix)+172);
	TaxiFix[168] = LOBYTE(LOWORD(relDist));
	TaxiFix[169] = HIBYTE(LOWORD(relDist));
	TaxiFix[170] = LOBYTE(HIWORD(relDist));
	TaxiFix[171] = HIBYTE(HIWORD(relDist));
	relDist =  ((DWORD) TaxiFix) - (((DWORD) TaxiFixInstall)+5);
	TaxiFixInst[1] = LOBYTE(LOWORD(relDist));
	TaxiFixInst[2] = HIBYTE(LOWORD(relDist));
	TaxiFixInst[3] = LOBYTE(HIWORD(relDist));
	TaxiFixInst[4] = HIBYTE(HIWORD(relDist));
	VirtualProtect(TaxiFixInstall, sizeof(TaxiFixInst), PAGE_READWRITE, &protect1);
	memcpy(TaxiFixInstall, &TaxiFixInst, sizeof(TaxiFixInst));
	VirtualProtect(TaxiFixInstall, sizeof(TaxiFixInst), protect1, &protect2);
}


//***********************************************
//THE DLL STUFF
//***********************************************
void AdjustAdresses();
void ReadConfigFile();


void Initialization()
{
	DWORD *Pointer = (DWORD *) 0x6DFFF1;

	ReadConfigFile();

	//AdjustAdresses();

	HandleGlobalData();
	InstallTrafficTables();
	InstallVehicleSpeedLimits();
	InstallCustomDriverBehaviour();
	InstallCustomDriverBehaviourProcs();
	InstallCustomGangs();
	InstallTaxiFix();
}

BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
	DWORD *Pointer = (DWORD *) 0x6DFFF2;
    switch( ul_reason_for_call ) 
    { 
        case DLL_PROCESS_ATTACH:
			DisableThreadLibraryCalls((HMODULE) hModule);
			Initialization();
            break;

        case DLL_THREAD_ATTACH:
            break;

        case DLL_THREAD_DETACH:
            break;

        case DLL_PROCESS_DETACH:
            break;
    }

    return TRUE;
}


void ReadConfigFile()
{
	int counter = 0;
	void* gtaDirAddr = (DWORD *) 0x68BD50;
	const char *gtaDir = (const char*) gtaDirAddr;
	const char *cfgFile = "vc_traffic.cfg";
	char cfgFileFullPath[256];
	strcpy (cfgFileFullPath, gtaDir);
	strcat(cfgFileFullPath, cfgFile);

	int valuesAssigned = 0;
	int lineType = 1;
	float tempDensity[6];
	int densityIndex = 0;
	int lineCount = 0;

	FILE* config = fopen(cfgFileFullPath, "r");
	if (config)	// If it opened alright...
	{
		char line[255];	
		while (fgets(line, 255, config))	// While we're still reading lines...
		{
			if ((line[0] != '#') && (line[0] != 0))		// If this line isn't a comment...
			{
				PEDS_LIFETIMEDATA pedData;
				VEHICLEDATA vehData;
				DRIVERBEHAVIOURDATA driverData;
				DRIVERSHOTPROBS driverShotProbs;
				GANGDATA gangData;

				switch (lineType)
				{
					case 1:						
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%f", &tempDensity[0]);
						if (valuesAssigned == 1)
						{
							VC_TrafficGlobalData.maxVehicleSpeedMultiplier = tempDensity[0];
							lineType = 2;
						}						
						break;
					case 2:						
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%i %i %i %f %f %f %f %i %i", &pedData.extPedLimit, &pedData.intPedLimit, 
											&pedData.densityAdder, &pedData.absoluteMaxDespawnRangeOnscreen, 
											&pedData.normalMaxDespawnRangeOnscreen, &pedData.maxRangeDespawnOffscreen, 
											&pedData.gangerDespawnRangeAdder, &pedData.pedsDespawnTime, &pedData.copsDespawnTime);
						if (valuesAssigned == 9)
						{
							VC_TrafficGlobalData.pedData->extPedLimit = pedData.extPedLimit;
							VC_TrafficGlobalData.pedData->intPedLimit = pedData.intPedLimit;
							VC_TrafficGlobalData.pedData->densityAdder = pedData.densityAdder;
							VC_TrafficGlobalData.pedData->absoluteMaxDespawnRangeOnscreen = pedData.absoluteMaxDespawnRangeOnscreen;
							VC_TrafficGlobalData.pedData->normalMaxDespawnRangeOnscreen = pedData.normalMaxDespawnRangeOnscreen;
							VC_TrafficGlobalData.pedData->maxRangeDespawnOffscreen = pedData.maxRangeDespawnOffscreen;
							VC_TrafficGlobalData.pedData->gangerDespawnRangeAdder = pedData.gangerDespawnRangeAdder;
							VC_TrafficGlobalData.pedData->pedsDespawnTime = pedData.pedsDespawnTime;
							VC_TrafficGlobalData.pedData->copsDespawnTime = pedData.copsDespawnTime;							
							lineType = 3;
						}						
						break;
					case 3:
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%f %f %f %f", &pedData.pedsDrawDist, &pedData.maxSpawnRangeOnscreen, 
											&pedData.minSpawnRangeOnscreen, &pedData.minSpawnRangeOffscreen);
						if (valuesAssigned == 4) 
						{
							VC_TrafficGlobalData.pedData->pedsDrawDist = pedData.pedsDrawDist;
							VC_TrafficGlobalData.pedData->maxSpawnRangeOnscreen = pedData.maxSpawnRangeOnscreen;
							VC_TrafficGlobalData.pedData->minSpawnRangeOnscreen = pedData.minSpawnRangeOnscreen;
							VC_TrafficGlobalData.pedData->minSpawnRangeOffscreen = pedData.minSpawnRangeOffscreen;
							VC_TrafficGlobalData.pedData->spawnOffscreenRingSize = VC_TrafficGlobalData.pedData->maxRangeDespawnOffscreen - VC_TrafficGlobalData.pedData->minSpawnRangeOffscreen;
							lineType = 4;
						}	
						break;
					case 4:
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%f %f %f %f %f %f", &tempDensity[0], &tempDensity[1], 
											&tempDensity[2], &tempDensity[3], &tempDensity[4], &tempDensity[5]);
						if (valuesAssigned == 6) 
						{
							for (int i = 0; i < 6; i++)
							{
								pedTrafficTable[densityIndex+i] = tempDensity[i];
							}
							densityIndex += 6;
							lineCount++;
							if (lineCount == 4) 
							{
								densityIndex = 0;
								lineCount = 0;
								lineType = 5;
							}
						}						
						break;
					case 5:
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%f %f %i %i %i", &gangData.minSpawned,
													&gangData.maxSpawned, &gangData.soloProb,
													&gangData.walkProb, &gangData.chatProb);
						if (valuesAssigned == 5) 
						{
							GANGDATA* curGangTable = (GANGDATA*) VC_TrafficGlobalData.gangerTablePtr;
							curGangTable[lineCount].minSpawned = gangData.minSpawned;
							curGangTable[lineCount].maxSpawned = gangData.maxSpawned;
							curGangTable[lineCount].soloProb = gangData.soloProb;
							curGangTable[lineCount].walkProb = gangData.walkProb;
							curGangTable[lineCount].chatProb = gangData.chatProb;
							
							lineCount++;
							if (lineCount == 9) 
							{
								lineCount = 0;
								lineType = 6;
							}
						}
					case 6:
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%i %i %f %f %f %f %f", &vehData.vehLimit, &vehData.densityAdder, 
											&vehData.despawnRangeOnscreen, &vehData.despawnRangeOffscreen, 
											&vehData.spawnRangeOnscreen, &vehData.lodThreshold, &vehData.wheelVisibRangeOverride);
						if (valuesAssigned == 7) 
						{
							VC_TrafficGlobalData.vehData->vehLimit = vehData.vehLimit;
							VC_TrafficGlobalData.vehData->densityAdder = vehData.densityAdder;
							VC_TrafficGlobalData.vehData->despawnRangeOnscreen = vehData.despawnRangeOnscreen;
							VC_TrafficGlobalData.vehData->despawnRangeOffscreen = vehData.despawnRangeOffscreen;
							VC_TrafficGlobalData.vehData->spawnRangeOnscreen = vehData.spawnRangeOnscreen;
							VC_TrafficGlobalData.vehData->lodThreshold = vehData.lodThreshold;
							VC_TrafficGlobalData.vehData->wheelVisibRangeOverride = vehData.wheelVisibRangeOverride;
							lineType = 7;
						}						
						break;
					case 7:
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%f %f %f %f %f %f", &tempDensity[0], &tempDensity[1], 
											&tempDensity[2], &tempDensity[3], &tempDensity[4], &tempDensity[5]);
						if (valuesAssigned == 6) 
						{
							for (int i = 0; i < 6; i++)
							{
								vehicleTrafficTable[densityIndex+i] = tempDensity[i];
							}
							densityIndex += 6;
							lineCount++;
							if (lineCount == 4) 
							{
								densityIndex = 0;
								lineCount = 0;
								lineType = 8;
							}
						}						
						break;
					case 8:
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%f %f %f %f", &tempDensity[0], &tempDensity[1], 
											&tempDensity[2], &tempDensity[3]);	//actually node speed and not density but fits the data type
						if (valuesAssigned == 4) 
						{
							for (int i = 0; i < 3; i++)
							{
								vehicleNodeSpeedTable[i] = tempDensity[i];
							}
							lineType = 9;
						}						
						break;
					case 9:
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%f %f %i %i %f %f %f %f %f %f %i", &driverData.minCruiseSpeed, 
											&driverData.maxCruiseSpeed, &driverData.rushSpeedProb, 
											&driverData.rushSpeedAdder, &driverData.fleeSpeedMult,
											&driverData.driveThruBase, &driverData.driveThruDeviation,
											&driverData.driveThruMax, &driverData.frenzySpeedMult,
											&driverData.minCarHealth, &driverData.emergencyExitProb);
						if (valuesAssigned == 11) 
						{
							DRIVERBEHAVIOURDATA* curDriverBehSet = (DRIVERBEHAVIOURDATA*) VC_TrafficGlobalData.driverBehaviourTablePtr;
							int curPedTypeID = lineCountToPedTypeID[lineCount];
							curDriverBehSet[curPedTypeID].minCruiseSpeed = driverData.minCruiseSpeed;
							curDriverBehSet[curPedTypeID].maxCruiseSpeed = driverData.maxCruiseSpeed;
							curDriverBehSet[curPedTypeID].rushSpeedProb = driverData.rushSpeedProb;
							curDriverBehSet[curPedTypeID].rushSpeedAdder = driverData.rushSpeedAdder;
							curDriverBehSet[curPedTypeID].fleeSpeedMult = driverData.fleeSpeedMult;
							curDriverBehSet[curPedTypeID].driveThruBase = driverData.driveThruBase;
							curDriverBehSet[curPedTypeID].driveThruDeviation = driverData.driveThruDeviation;
							curDriverBehSet[curPedTypeID].driveThruMax = driverData.driveThruMax;
							curDriverBehSet[curPedTypeID].frenzySpeedMult = driverData.frenzySpeedMult;
							curDriverBehSet[curPedTypeID].minCarHealth = driverData.minCarHealth;
							curDriverBehSet[curPedTypeID].emergencyExitProb = driverData.emergencyExitProb;
							lineCount++;
							if (lineCount == 17) 
							{
								lineCount = 0;
								lineType = 10;
							}
						}
						break;
					case 10:
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%i %i %i %i %i", &driverShotProbs.ignore, 
											&driverShotProbs.freeze, &driverShotProbs.escape, 
											&driverShotProbs.flee, &driverShotProbs.frenzy);
						if (valuesAssigned == 5) 
						{
							DRIVERBEHAVIOURDATA* curDriverBehSet = (DRIVERBEHAVIOURDATA*) VC_TrafficGlobalData.driverBehaviourTablePtr;
							int curPedTypeID = lineCountToPedTypeID[lineCount];
							DRIVERSHOTPROBS* currentProbs = (DRIVERSHOTPROBS*) curDriverBehSet[curPedTypeID].driverShotProbs;							
							currentProbs->ignore = driverShotProbs.ignore;
							currentProbs->freeze = driverShotProbs.freeze;
							currentProbs->escape = driverShotProbs.escape;
							currentProbs->flee = driverShotProbs.flee;
							currentProbs->frenzy = driverShotProbs.frenzy;
							lineCount++;
							if (lineCount == 17) 
							{
								lineCount = 0;
								lineType = 11;
							}
						}
						break;
					case 11:
						//DO NOT FORGET TO ADJUST valuesAssigned CHECK BELOW
						valuesAssigned = sscanf(line, "%f", &tempDensity[0]);	//actually car class multiplier and not density but fits the data type
						if (valuesAssigned == 1) 
						{
							carClassSpeedMult[lineCount] = tempDensity[0];
							lineCount++;
							if (lineCount == 21) 
							{
								lineCount = 0;
								lineType = 12;
							}
						}						
						break;
				}
			}
		}
		fclose(config);	
	}

	DWORD protect1, protect2;

	
	
	BYTE GlobalData[4] =	{0x00, 0x00, 0x00, 0x00};
	GlobalData[0] = LOBYTE(LOWORD((DWORD) &VC_TrafficGlobalData));
	GlobalData[1] = HIBYTE(LOWORD((DWORD) &VC_TrafficGlobalData));
	GlobalData[2] = LOBYTE(HIWORD((DWORD) &VC_TrafficGlobalData));
	GlobalData[3] = HIBYTE(HIWORD((DWORD) &VC_TrafficGlobalData));
	VirtualProtect(VC_TrafficPointerAddr, sizeof(GlobalData), PAGE_READWRITE, &protect1);
	memcpy(VC_TrafficPointerAddr, &GlobalData, sizeof(GlobalData));
	VirtualProtect(VC_TrafficPointerAddr, sizeof(GlobalData), protect1, &protect2);
}



void AdjustAdresses()
{
	enum VersionID {
		verUnknown, 
		verGTAVC_US_10,
		verGTAVC_US_11,
		verGTAVC_AUS_10,
		verGTAVC_GER_10,
		verGTAVC_GER_11} versionID;

	HINSTANCE hVCVersion;
	HANDLE currentProcess = GetCurrentProcess();

	typedef VersionID (WINAPI *DETECTVERSIONPROC) (HANDLE);
	DETECTVERSIONPROC DetectVersion;
	typedef DWORD (WINAPI *ADJUSTOFFSETPROC) (DWORD,VersionID);
	ADJUSTOFFSETPROC AdjustOffset;

	//OutputDebugString("Loading VCVersion...");
	hVCVersion = LoadLibrary("vcversion.dll");
	if (hVCVersion != NULL)
	{
		//OutputDebugString("VCVersion loaded");
		DetectVersion = (DETECTVERSIONPROC) GetProcAddress(hVCVersion, "DetectVersion");
		if (DetectVersion != NULL)
		{
			versionID = DetectVersion(currentProcess);
			//char message[64];
			//sprintf(message, "VersionID is: %d", versionID);
			//OutputDebugString(message);

			AdjustOffset = (ADJUSTOFFSETPROC) GetProcAddress(hVCVersion, "AdjustOffset");
			if (AdjustOffset != NULL)
			{
				//GLOBALS
				//VC_TrafficPointerAddr			= (DWORD*) AdjustOffset((DWORD) VC_TrafficPointerAddr, versionID);
				PtrToPlayer						= (DWORD*) AdjustOffset((DWORD) PtrToPlayer, versionID);
				VehDensityMult					= (DWORD*) AdjustOffset((DWORD) VehDensityMult, versionID);
				PedDensityMult					= (DWORD*) AdjustOffset((DWORD) PedDensityMult, versionID);
				Time_Hours						= (DWORD*) AdjustOffset((DWORD) Time_Hours, versionID);
				IngameTimerInMS					= (DWORD*) AdjustOffset((DWORD) IngameTimerInMS, versionID);
				RandomNumberCallDest			= (DWORD*) AdjustOffset((DWORD) RandomNumberCallDest, versionID);
				GetPlayerCallDest				= (DWORD*) AdjustOffset((DWORD) GetPlayerCallDest, versionID);
				
				//GLOBAL DATA HANDLING
				ExtPedLimitInstall				= (DWORD*) AdjustOffset((DWORD) ExtPedLimitInstall, versionID);
				PrevExtPedLimitBlankInstall		= (DWORD*) AdjustOffset((DWORD) PrevExtPedLimitBlankInstall, versionID);
				IntPedLimitInstall				= (DWORD*) AdjustOffset((DWORD) IntPedLimitInstall, versionID);
				PrevIntPedLimitBlankInstall		= (DWORD*) AdjustOffset((DWORD) PrevIntPedLimitBlankInstall, versionID);
				absMaxDespawnOnscrInstall		= (DWORD*) AdjustOffset((DWORD) absMaxDespawnOnscrInstall, versionID);
				normMaxDespawnOnscrInstall		= (DWORD*) AdjustOffset((DWORD) normMaxDespawnOnscrInstall, versionID);
				maxDespawnOffscrInstall			= (DWORD*) AdjustOffset((DWORD) maxDespawnOffscrInstall, versionID);
				gangerDespawnRngAdderInstall	= (DWORD*) AdjustOffset((DWORD) gangerDespawnRngAdderInstall, versionID);
				pedsDespawnTimeInstall			= (DWORD*) AdjustOffset((DWORD) pedsDespawnTimeInstall, versionID);
				copsDespawnTimeInstall			= (DWORD*) AdjustOffset((DWORD) copsDespawnTimeInstall, versionID);
				pedsDrawDistanceInstall			= (DWORD*) AdjustOffset((DWORD) pedsDrawDistanceInstall, versionID);
				maxSpawnOnscrInstall			= (DWORD*) AdjustOffset((DWORD) maxSpawnOnscrInstall, versionID);
				minSpawnOnscrInstall			= (DWORD*) AdjustOffset((DWORD) minSpawnOnscrInstall, versionID);
				spawnOffscrRingSizeInstall		= (DWORD*) AdjustOffset((DWORD) spawnOffscrRingSizeInstall, versionID);
				VehLimitInstall					= (DWORD*) AdjustOffset((DWORD) VehLimitInstall, versionID);
				PrevVehLimitBlankInstall		= (DWORD*) AdjustOffset((DWORD) PrevVehLimitBlankInstall, versionID);
				DespawnOnscrInstall				= (DWORD*) AdjustOffset((DWORD) DespawnOnscrInstall, versionID);
				DespawnOffscrInstall			= (DWORD*) AdjustOffset((DWORD) DespawnOffscrInstall, versionID);
				SpawnOnscrInstall				= (DWORD*) AdjustOffset((DWORD) SpawnOnscrInstall, versionID);
				SomeSpawnRangeLimiterInstall	= (DWORD*) AdjustOffset((DWORD) SomeSpawnRangeLimiterInstall, versionID);
				vehLODRangeInstall				= (DWORD*) AdjustOffset((DWORD) vehLODRangeInstall, versionID);
				DrivBehavCorrInstall1			= (DWORD*) AdjustOffset((DWORD) DrivBehavCorrInstall1, versionID);
				DrivBehavCorrInstall2			= (DWORD*) AdjustOffset((DWORD) DrivBehavCorrInstall2, versionID);
				DrivBehavCorrInstall3			= (DWORD*) AdjustOffset((DWORD) DrivBehavCorrInstall3, versionID);
				RereadHandlingCfgInstall		= (DWORD*) AdjustOffset((DWORD) RereadHandlingCfgInstall, versionID);
				MaxVehSpeedMultiplier			= (DWORD*) AdjustOffset((DWORD) MaxVehSpeedMultiplier, versionID);
				InitLoadBarLengthProc			= (DWORD*) AdjustOffset((DWORD) InitLoadBarLengthProc, versionID);
				HandlingDataBase				= (DWORD*) AdjustOffset((DWORD) HandlingDataBase, versionID);
				ReadHandlingDataProc			= (DWORD*) AdjustOffset((DWORD) ReadHandlingDataProc, versionID);
				WheelVisRngOverrideInstall		= (DWORD*) AdjustOffset((DWORD) WheelVisRngOverrideInstall, versionID);

				//TRAFFIC DENSITY TABLES
				VehicleTrafficInstall			= (DWORD*) AdjustOffset((DWORD) VehicleTrafficInstall, versionID);
				PedTrafficInstall				= (DWORD*) AdjustOffset((DWORD) PedTrafficInstall, versionID);
				TempSpeedHolder					= (DWORD*) AdjustOffset((DWORD) TempSpeedHolder, versionID);
				
				//VEHICLE SPEED LIMITS
				GearFix1Install					= (DWORD*) AdjustOffset((DWORD) GearFix1Install, versionID);
				GearFix2Install					= (DWORD*) AdjustOffset((DWORD) GearFix2Install, versionID);
				NodeSpeedInstall				= (DWORD*) AdjustOffset((DWORD) NodeSpeedInstall, versionID);

				//DRIVER BEHAVIOUR
				CreateDrivSpdInstall			= (DWORD*) AdjustOffset((DWORD) CreateDrivSpdInstall, versionID);
				TransferDrivSpdInstall			= (DWORD*) AdjustOffset((DWORD) TransferDrivSpdInstall, versionID);
				AdjustDrivSpdInstall			= (DWORD*) AdjustOffset((DWORD) AdjustDrivSpdInstall, versionID);
				RushSpeedSwitchInstall			= (DWORD*) AdjustOffset((DWORD) RushSpeedSwitchInstall, versionID);
				RushSpeedInstall				= (DWORD*) AdjustOffset((DWORD) RushSpeedInstall, versionID);
				SkipAccelInstall				= (DWORD*) AdjustOffset((DWORD) SkipAccelInstall, versionID);
				ShotReactionInstall				= (DWORD*) AdjustOffset((DWORD) ShotReactionInstall, versionID);
				ShotReactionBackJump			= (DWORD*) AdjustOffset((DWORD) ShotReactionBackJump, versionID);
				CarfireReactionInstall			= (DWORD*) AdjustOffset((DWORD) CarfireReactionInstall, versionID);
				CarfireReactionBackJump			= (DWORD*) AdjustOffset((DWORD) CarfireReactionBackJump, versionID);
				Address687214					= (DWORD*) AdjustOffset((DWORD) Address687214, versionID);
				PedTypeCounterProc				= (DWORD*) AdjustOffset((DWORD) PedTypeCounterProc, versionID);
				Address69C68C					= (DWORD*) AdjustOffset((DWORD) Address69C68C, versionID);
				LeaveVehicleProc				= (DWORD*) AdjustOffset((DWORD) LeaveVehicleProc, versionID);
				SomeProc						= (DWORD*) AdjustOffset((DWORD) SomeProc, versionID);
				Address69283C					= (DWORD*) AdjustOffset((DWORD) Address69283C, versionID);
				SomeProc2						= (DWORD*) AdjustOffset((DWORD) SomeProc2, versionID);

				//GANG SET-UP
				GangGroupSizeInstall			= (DWORD*) AdjustOffset((DWORD) GangGroupSizeInstall, versionID);
				SizeAdderBlankInstall			= (DWORD*) AdjustOffset((DWORD) SizeAdderBlankInstall, versionID);
				GangSpawnAsSwitchInstall		= (DWORD*) AdjustOffset((DWORD) GangSpawnAsSwitchInstall, versionID);
				MinWalkingInstall				= (DWORD*) AdjustOffset((DWORD) MinWalkingInstall, versionID);
				MinChatingInstall				= (DWORD*) AdjustOffset((DWORD) MinChatingInstall, versionID);
				PIGFix1Install					= (DWORD*) AdjustOffset((DWORD) PIGFix1Install, versionID);
				PIGFix2Install					= (DWORD*) AdjustOffset((DWORD) PIGFix2Install, versionID);
				ToWalkJump						= (DWORD*) AdjustOffset((DWORD) ToWalkJump, versionID);
				ToChatJump						= (DWORD*) AdjustOffset((DWORD) ToChatJump, versionID);

				//TAXI FIX
				TaxiFixInstall					= (DWORD*) AdjustOffset((DWORD) TaxiFixInstall, versionID);
				TaxiFixSkipJump					= (DWORD*) AdjustOffset((DWORD) TaxiFixSkipJump, versionID);

			}
			else OutputDebugString("VCVersion::AdjustOffset() not correctly loaded");

		}
		else OutputDebugString("VCVersion::DetectVersion() not correctly loaded");

		FreeLibrary(hVCVersion);
	}
	else OutputDebugString("VCVersion not correctly loaded");
}