/**
--------------------------------------------------------------------------
|           |==============================================|             |
|           |               Custom Map Icons               |             |
|           |============================ v1.0 RC 4 =======|             |
|                                                                        |
|		    |=== Authors: =================================|             |
|		    |=> Aleks10           (Aleksey.al09@gmail.com) |             |
|           |=> Romanius               (romanius@namba.kg) |             |
|		    |==============================================|             |
|                                                                        |
|  This script is free software: you can redistribute it and/or modify   |
|  it under the terms of the GNU General Public License as published by  |
|  the Free Software Foundation, either version 3 of the License, or     |
|  (at your option) any later version.                                   |
|                                                                        |
|  This script is distributed in the hope that it will be useful,        |
|  but WITHOUT ANY WARRANTY; without even the implied warranty of        |
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
|  GNU General Public License for more details.                          |
|                                                                        |
|  You should have received a copy of the GNU General Public License     |
|  along with this script.  If not, see <http://www.gnu.org/licenses/>.  |
|																		 |
--------------------------------------------------------------------------
**/

#if defined _cust_ico_included
	#endinput
#endif
#define _cust_ico_included

#include <a_samp>
#include <r_io>

#define MAX_CUSTOM_MAP_ICONS 3 //  .
#define ICON_SIZE 24.0

enum cMapIconInfo
{
	gangzid[256],
	pixel[256],
//	Float:px,
//	Float:py,
	bool:isUsed,
}

static stock customMapIcon[MAX_CUSTOM_MAP_ICONS][cMapIconInfo];

stock DestroyCustomMapIcon(iconid)
{
	for(new i; i < 256; i++)
	{
		if((customMapIcon[iconid][pixel][i] & 0x000000FF) > 0x10)
		{
			GangZoneDestroy(customMapIcon[iconid][gangzid][i]);
		}
		
		customMapIcon[iconid][pixel][i] = 0x00000000;
	}
	
	customMapIcon[iconid][isUsed] = false;
}

stock CreateCustomMapIcon(filename[], Float:X, Float:Y)
{
	new curentIconId;
	
	while(customMapIcon[curentIconId][isUsed]) curentIconId++;

	if(curentIconId >= MAX_CUSTOM_MAP_ICONS) return -1;

	new File:f = fopen(filename, io_read);
	
	new reserved 		= readInt16(f);
	new type	 		= readInt16(f);
	new count	 		= readInt16(f);
	
	if((reserved != 0 && type != 1) || count <= 0)
	{
		print("Invalid ICO file!");
		return -1;
	}
	
	new width;
	new heigth;
	new image_offset;
	
	for(new i; i < count; i++)
	{
		width = readByte(f);
		heigth = readByte(f);
		
		new color_count 	= readByte(f); // 8
		
		fseek(f, 9, seek_current);
		
		image_offset = readInt32(f);
		
		if(color_count != 0 || (width != 16 && heigth != 16))
		{
			continue;
		}
		
		fseek(f, image_offset + 40);
		
		new Float:x = X-ICON_SIZE, Float:y = Y-ICON_SIZE;
	
		for(new j; j < 256; j++)
		{
			new B = readByte(f);
			new G = readByte(f);
			new R = readByte(f);
			new A = readByte(f);
			
			customMapIcon[curentIconId][pixel][j] = (R << 24 | G << 16 | B << 8 | A);
			
			if(A > 0x10)
				customMapIcon[curentIconId][gangzid][j] = GangZoneCreate(x, y, x + ICON_SIZE / 8, y + ICON_SIZE / 8);
			
			x += ICON_SIZE / 8;
			
			if (x >= X + ICON_SIZE && y < Y + ICON_SIZE)
			{
				x = X - ICON_SIZE;
				y += ICON_SIZE / 8;
			}
		}
		
		fclose(f);
		
		customMapIcon[curentIconId][isUsed] = true;
		
		return curentIconId;
	}
	
	fclose(f);
	
	return -1;
}

public OnPlayerSpawn(playerid)
{
	for(new j; j < MAX_CUSTOM_MAP_ICONS; j++)
	{
		if(!customMapIcon[j][isUsed]) continue;
		
		for(new i; i < 256; i++)
		{
			if((customMapIcon[j][pixel][i] & 0x000000FF) > 0x10)
			{
				GangZoneShowForPlayer(playerid, customMapIcon[j][gangzid][i], customMapIcon[j][pixel][i]);
			}
		}
	}
}


#undef ICON_SIZE
#undef MAX_CUSTOM_MAP_ICONS



#if defined _ALS_OnPlayerSpawn
	#undef OnPlayerSpawn
#else
	#define _ALS_OnPlayerConnect
#endif
#define OnPlayerSpawn CustmIcons_OnPlayerSpawn

forward CustmIcons_OnPlayerSpawn(playerid);