/*
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
	There are two arrays in this include:
	
	- MODELS_gColRadius
		
		This array lists all the radii of the collision spheres for all the GTA
		objects used in SA (including the SA:MP objects); except skins,
		vehicles, and weapons.  The collision sphere entirely encompases the
		object, so is a good estimator of the size of the object (for example to
		set the view distance accordingly).
	
	- MODELS_gColOffset
		
		This array lists all the offsets of the collision sphere for all
		objects.  This information is kept in a separate array as it is
		generally less useful than the sphere radius.  It indicates where the
		centre of the collision sphere is relative to the centre of the object,
		a position set to minimise the size of the sphere relative to the
		object.  Note that you can't accurately calculate the exact center of
		the collision sphere without the quaternion rotation of the object, that
		is why this is a separate "stock" array - so it isn't included in the
		compiled code if not used.
	
	Usage is VERY simple.  For model IDs up to 19901, simply use that number as
	an index in to the array, any other IDs don't exist.
	
	Big thanks to Kalcor for dumping the raw data for this out of the game.
	
	Note that due to the sheer volume of data here, we need to set:
	
		#pragma compress 0
	
	To avoid the warning that it gets set anyway.
*/

#pragma compress 0

stock const
	/*
		This array lists all the radii of the collision spheres for all the GTA
		objects used in SA (including the SA:MP objects); except skins,
		vehicles, and weapons.  The collision sphere entirely encompases the
		object, so is a good estimator of the size of the object (for example to
		set the view distance accordingly).
		
		Big thanks to Kalcor for dumping the raw data for this out of the game.
	*/
	Float:MODELS_gColRadius[19902] =
		{
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 14.614464, 18.888387,  9.874637,  7.732522, 14.555084, 20.657041, 17.197839, 26.648796, 17.083259,
			 14.770172,  3.837572,  2.466110,  2.160274,  2.535959,  3.467430,  1.233055,  1.070268,  1.888844,  1.263654,  5.269414,  1.627850,  2.240679,  1.403413,  1.924368,  3.922038,
			  3.241111,  5.192090,  1.877818,  1.632452,  2.519371, 12.408297,  1.844781,  3.157948, 24.859861,  2.975739,  2.722848,  2.028280, 10.086935,  4.886072, 11.136516,  6.660789,
			 12.667684,  4.878989, 13.744526,  7.345661,  6.798764,  9.549941,  0.000000,  0.000000, 29.310182,  0.000000,  0.000000,  0.000000,  0.000000, 10.053597, 29.474054,  5.233971,
			  9.469558,  6.848555,  3.413700,  0.707107,  1.893043,  0.714585,  0.812193,  1.011139,  3.512526,  1.933351,  1.194291, 15.185432,  4.520644, 11.944060, 10.985778, 14.259016,
			 14.076678, 26.076837, 28.850557, 13.724506,  1.054541, 42.503612, 47.355888, 36.250511, 29.481929, 34.555473, 29.324815,  0.000000,  9.084518,  0.655757,  0.657285, 12.085081,
			 40.772678, 25.506568, 31.163795, 24.736206, 23.636083, 39.192710, 18.014787,  7.525639, 12.100514, 25.496490, 37.680019, 13.203269, 10.400197,  7.871115,  7.710988, 49.374359,
			 44.976089, 93.249923, 52.148967, 56.709247, 54.781650, 42.788398, 18.921575, 13.482414,  4.072123, 10.792648, 13.491784, 25.039709, 10.532059, 19.661508, 22.267061, 31.517108,
			 11.483315,  6.804268,  5.584899, 38.473133, 42.124584,  0.442301,  1.147140,  0.510363,  4.830805,  4.093634,  3.079438,  2.864749,  2.574040,  4.199094,  3.314465,  3.292675,
			  4.114810,  1.535946,  1.365167,  0.694953,  0.780342,  1.224063,  3.622684,  2.559232,  1.893726,  1.707002, 10.358072,  8.688429, 13.496685,  3.791086, 10.831414, 19.311744,
			 21.053596, 16.055278,  9.612328, 16.790679, 21.642234, 16.251205, 24.725738, 11.741647, 11.603637, 16.695411, 10.140229,  4.489356, 11.584970,  5.501419,  9.048741, 44.825225,
			 47.355888, 61.015308, 43.161834, 52.196044, 54.174976, 34.058845, 36.562614, 61.015308,  4.231204,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  5.610025,  3.470088,  1.168032,  4.685346,  2.272159,  3.845280,  4.242756,  1.288439,  3.470088,  3.398657,  1.307700,  2.272159,  3.398657,  3.398657,  3.398657,  3.422719,
			  1.550851,  1.746487,  4.999889,  4.596972,  4.652088,  4.570519,  4.596972,  4.840950,  4.717782,  4.717782,  4.717782,  4.999889,  1.033401,  1.370511,  2.813601,  2.524539,
			  2.813383,  2.218719,  3.565223,  4.829043,  3.259084,  2.780133,  4.028151,  3.589557,  3.406080,  1.250957,  1.931764,  3.590163,  4.195870,  7.152104,  5.413107,  2.611113,
			  2.157099,  1.687898,  2.247842,  1.585587,  1.316401,  1.849153,  1.451951,  4.999889,  7.483522,  1.175722,  2.189294,  0.714585,  0.812193,  1.011139,  1.194291,  0.694953,
			  2.867567,  2.838594,  2.821477,  2.869565,  2.017002,  2.405265,  1.551030,  1.440392,  5.647047,  9.049338, 12.024537,  9.049339,  7.781567,  6.984641,  6.984641,  6.799339,
			  4.072743,  3.312946,  3.914820,  3.747446,  3.791090,  5.371675,  6.270424,  6.527740,  5.120832,  5.517996,  7.591889,  5.615609,  4.060623,  6.338236,  6.673755,  4.085775,
			 12.288867,  7.656761, 10.312679, 17.357370, 21.558887, 11.279873,  1.490105, 15.441126,  1.933351,  0.764980,  3.609152,  0.000000,  0.000000,  0.000000,  1.782742,  1.038604,
			  0.986992,  1.167497,  0.976873,  0.589110,  0.434944,  0.338708,  0.501305,  0.846113,  0.839640,  0.138593,  2.854077,  1.416463,  0.536662,  1.807245,  0.504732,  1.309559,
			  0.456533,  2.266709,  0.797596,  1.807245,  0.756410,  1.103119,  3.303756,  0.694248,  1.203642,  1.217342,  1.026855,  3.958162,  1.028419,  1.409621,  3.419954,  1.931934,
			  1.815044,  4.641053,  2.619822,  2.619816,  0.935715,  0.834721,  0.903861,  1.190649,  3.200906,  0.517336,  0.400909,  1.335291,  1.317396,  0.663938,  1.696442,  1.830983,
			  0.924717,  1.009776,  0.972410,  0.972410,  1.050027,  0.000000,  4.011127,  2.121232,  3.576333,  4.791418,  2.165992,  7.104218, 12.997877,  4.755159,  4.344840,  4.736846,
			  4.736847,  1.895084,  4.755159,  4.755159,  6.402085, 14.784140, 12.846461,  3.295547,  6.460881,  5.380258,  5.428072,  8.498275,  3.785747,  3.297947,  5.294592,  3.540935,
			  2.353033,  5.288062,  3.198191,  2.767268,  4.139727,  1.723458,  5.208182,  0.000000,  0.862860,  1.007370,  0.868414,  1.009127,  0.477972,  0.480955,  0.270594,  0.228467,
			  0.440744,  0.339666,  0.353137,  0.478543,  0.481968,  0.807673,  0.932296,  0.932989,  0.868256,  0.228467,  0.197445,  0.165078,  0.124329,  0.116236,  0.095610,  1.007279,
			  0.800893,  0.515478,  1.115160,  1.115160,  0.906328,  0.876769,  1.114266,  1.114266,  1.742877,  1.742879,  0.957907,  1.752282,  1.060598,  0.895231,  1.748898,  1.082996,
			  1.060598,  1.082996,  0.798497,  0.917985,  0.767576,  0.896236,  0.872457,  1.055673,  1.023622,  0.789080,  0.737258,  1.055673,  1.023622,  1.465455,  1.465487,  1.852218,
			  1.172831,  1.171561,  0.752300,  0.832084,  0.792074,  1.851505,  1.172831,  1.171561,  0.829293,  0.948696,  0.966180,  1.305495,  1.305482,  1.085477,  1.074715,  1.085477,
			  1.074715,  0.509656,  0.508426,  0.508257,  0.502290,  0.502430,  0.502430,  0.513054,  0.508426,  0.514333,  0.507761,  0.500307,  0.500981,  0.507761,  0.043503,  0.043503,
			  1.294085,  0.853586,  1.062219,  1.293759,  0.826928,  1.058845,  1.062219,  1.058845,  0.507914,  0.507430,  0.507251,  0.798497,  0.575100,  2.410203,  0.675809,  1.007833,
			  0.189579,  0.189637,  2.620621,  1.077358,  1.077358,  1.230656,  0.997237,  0.190035,  0.186838,  0.657006,  0.665161,  0.745021,  0.619915,  1.110147,  1.190992,  2.483154,
			  1.190819,  0.514427,  2.410203,  0.307327,  2.620621,  3.007312,  0.953324,  0.984016,  1.517815,  1.105872,  1.449128,  1.451743,  1.105831,  0.675809,  1.077358,  0.645739,
			  0.644999,  1.077358,  0.965991,  0.963766,  1.160276,  1.163386,  0.274414,  0.274414,  0.296097,  0.296097,  0.969853,  0.941148,  1.181223,  1.186993,  1.002789,  1.009356,
			  1.019577,  1.049939,  1.242720,  1.220643,  1.232885,  1.168184,  0.965855,  1.164471,  1.248615,  1.159368,  1.072921,  0.952008,  0.975248,  1.152623,  1.178187,  1.203739,
			  1.192641,  1.231402,  1.191504,  1.186112,  1.134886,  1.216694,  1.163764,  1.163764,  1.128541,  1.136821,  0.982671,  1.101274,  0.968186,  1.006039,  1.003023,  1.140745,
			  1.134778,  1.099524,  1.215543,  1.215423,  1.267701,  1.265593,  1.220350,  1.220350,  1.208379,  1.210654,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.524995,  0.648509,  1.269819,  0.324290,  0.636399,  0.113191,  0.171434,  0.709299,  0.635471,
			  0.976827,  0.797378,  0.800091,  1.876338,  0.626483,  0.871016,  0.797205,  2.867217,  1.186926,  0.739062,  4.614926,  1.594081,  0.919381,  1.581370,  0.647930,  2.951889,
			  2.900697,  1.545220,  1.432090,  0.674829,  1.540369,  0.805748,  0.532561,  0.166583,  0.154924,  0.201548,  0.227774,  6.737312,  1.027328,  3.374850,  0.252986,  0.216811,
			  0.322079,  1.453711,  1.272266,  3.485743,  0.286729,  0.249605,  0.184248,  1.405869,  1.843173,  3.942070,  0.807898, 19.016012, 16.336557, 14.847869,  0.851199,  0.983195,
			  0.597681,  0.581803, 16.336557, 14.847869, 19.016012,  0.812456,  0.728200,  0.628250,  0.168241,  0.166346,  0.168872,  0.175623,  0.395624,  0.322209, 14.251438,  0.535576,
			  1.626258,  2.466315,  0.939871,  9.085760, 12.464365,  0.659484,  0.659484,  0.659484,  0.659484,  0.659484,  6.885303,  0.868238,  0.832912,  0.742926,  5.969655,  6.130565,
			  5.458202,  4.011631,  3.489176,  1.958745,  0.914008,  2.044790,  1.269819,  1.237699,  0.934529,  1.832015, 10.421587,  9.724485,  6.530842, 26.857742,  0.508861, 11.571714,
			 17.102283,  0.186660,  0.158261,  5.384118,  1.160585,  0.710564,  0.569285,  0.574600,  1.538414,  1.538414,  1.538414,  1.538414,  1.538414, 26.857742,  0.000000,  1.021780,
			  0.616169,  0.597384,  0.597896,  1.438109,  1.380803,  1.432144,  1.689851,  1.653831,  1.556280,  0.795956,  1.163460,  0.798698,  2.136054,  1.997408,  2.103760,  1.023254,
			  1.398154,  1.510629,  1.642132,  0.755468,  1.171280,  1.006870,  5.067327,  3.685641,  2.579099,  1.235995,  0.732939,  0.494783,  0.635365,  0.783954,  2.760446,  0.787964,
			  1.711367,  1.028234,  0.795014,  1.082564,  2.706492,  3.320162,  0.636457,  0.770907,  1.786699,  0.890691,  0.659821,  0.979299,  1.142135,  4.562493,  3.897038,  1.904039,
			  5.871869, 10.947352, 38.426063, 16.212869, 19.868597,  2.058984, 23.685834, 36.892719, 32.480720,  1.700499,  2.669255,  1.030349, 27.489376,  1.700499,  1.016000, 26.892719,
			  1.700499,  1.051655, 37.478374, 46.892719, 38.426063,  5.871869, 15.331791, 11.990096, 22.088155, 23.211259, 27.155521, 32.139316, 32.983203, 42.860481, 37.127468,  2.473653,
			  2.793185,  0.813785,  2.462929,  3.389072,  2.950898,  2.976221,  2.053512,  1.925923,  0.986986,  0.900286,  1.923506,  2.116516,  0.785561,  1.420171,  1.440515,  1.471946,
			  1.156986,  0.908785,  3.742111,  0.761723,  1.614526,  0.507193,  0.813784,  1.414598,  1.502676,  0.889907,  0.826717,  0.828625,  2.852459,  3.156980,  1.829599,  1.295011,
			  1.636487,  1.697103,  0.795015,  0.789768,  0.870683,  0.768257,  2.473653,  2.954128,  0.805128,  1.307641,  1.288349,  1.545354,  1.746170,  0.662972,  1.334877,  0.108753,
			  2.473752,  3.636874,  2.141834,  1.667263,  2.475600,  0.892867,  2.049532,  1.463258,  2.613415,  2.633733,  2.631809,  2.529869,  2.801034,  2.536015,  1.223888,  1.223891,
			  1.583785,  1.579584,  2.108724,  2.332483,  1.223889,  2.335475,  0.858208,  4.961415,  1.476014,  0.938274,  5.123634,  4.809872,  0.165821,  0.060472,  0.160763,  0.216757,
			  0.369612,  0.039999,  1.414396,  1.453930,  1.457116,  1.456696,  1.459136,  1.459136,  1.459043,  1.458809,  1.458279,  1.460016,  1.464627,  1.460371,  1.460500,  2.965559,
			  1.460371,  1.460371,  1.460371,  1.460371,  3.577297,  0.209566,  0.125523,  0.368649,  0.216427,  0.408057,  0.523640,  1.041144,  0.850049,  0.216874,  0.468344,  2.773829,
			  0.217024,  2.778721,  1.456696,  1.458801,  1.414389,  1.414389,  1.414389,  1.414389,  1.414389,  1.414389,  1.414389,  1.414389,  1.459166,  1.498379,  2.509597,  1.458307,
			  1.458307,  1.459521,  1.459179, 18.915733, 25.196763,  0.543596,  0.374790,  0.192086,  0.192037,  0.593650,  0.106026,  0.324809,  0.634078,  0.451272,  0.534537,  0.268730,
			  4.730954,  1.858559,  0.771044,  1.460015,  1.460015,  1.460016,  0.876579,  0.791778,  1.498379,  1.459521,  0.868785,  0.256478,  1.860105,  0.403140,  1.710168,  1.453930,
			  2.130995,  1.459586,  2.270795,  3.073888,  0.996815,  0.000000,  0.653544,  0.292005,  0.292005,  0.292005,  0.292005,  0.292005,  0.292005,  0.392509,  0.466630,  1.114477,
			  1.035977,  1.103595,  1.167706,  2.194614,  0.377048,  0.552000,  0.554791,  0.575848,  0.582020,  0.922791,  1.349300,  8.931191,  4.293841,  6.232707,  0.304877,  0.404574,
			  0.421245,  1.231544,  0.686778,  0.798559,  0.311008,  2.786031,  3.487773,  4.835672,  6.821990,  1.676519,  0.251617,  0.385381, 49.188896,  1.362120,  0.743663,  0.756801,
			  1.080927,  1.919193,  2.136890,  0.461811,  0.698751,  0.266050,  1.136381,  1.355319,  1.087954,  0.732703,  0.805314,  0.309558,  0.691628,  0.626303,  0.755367,  9.990446,
			  6.412786,  5.712606,  5.877524,  2.953771,  0.363281,  3.747215,  2.980381,  3.292052,  1.095203,  1.255478,  1.282189,  1.308902,  0.142140,  1.202916,  1.236865,  1.239529,
			147.835586,  2.777777,  0.244413,  1.801668, 12.846391,  6.481173,  0.229322,  7.970961,  0.720857,  1.243499,  0.529231,  0.529231,  8.200824,  1.243499, 23.182277,  0.623619,
			  0.185852,  0.170752,  0.100488,  0.105719,  0.181878,  0.185850,  0.425651,  0.624090,  0.113136, 11.571256, 10.818684, 13.407854,  1.887177, 25.175687, 21.697395,  1.758020,
			 25.620908, 12.368454, 10.501247, 29.332092,  5.720585,  1.451933,  1.550773,  2.124452,  2.247035,  4.172376,  2.669316,  2.955363,  5.067902,  5.991550, 12.568358,  2.360099,
			  4.698000,  3.792948,  1.792696,  0.000000,  2.212615,  1.913295,  1.599933,  1.838870,  1.140756,  1.128242,  1.686100,  1.397791,  1.215119,  3.299030,  2.662899,  0.780727,
			  1.548061,  1.799121,  0.872974,  0.771224,  0.411592,  0.806291,  0.353004,  0.357551,  0.634844,  0.706514,  0.709164,  1.902060,  1.141177,  1.827491,  1.758231,  1.169306,
			  1.548292,  0.722750,  1.073601,  0.244206,  1.025081,  0.947080,  0.519482,  0.903509,  0.594096,  1.162225,  0.885089,  1.005969,  0.705497,  1.194005,  1.258803,  1.214295,
			  0.997768,  1.880638,  0.752255,  0.420625,  0.435461,  0.516308,  0.484106,  0.502999,  0.629123,  1.911900,  0.972214,  1.108468,  1.877401,  1.782210,  1.041568,  0.921984,
			  1.871703,  1.857473,  1.204653,  1.507866,  1.498296,  1.030477,  1.777300,  1.218040,  1.728253,  1.119135,  1.167029,  1.589457,  1.616704,  0.968262,  0.960049,  1.335291,
			  1.317396,  0.954919,  0.743713,  1.198199,  1.388916,  0.456497,  0.413376,  0.403441,  0.409940,  0.409186,  0.742421,  0.405575,  0.410964,  0.942668,  0.403438,  0.464320,
			  0.770228,  1.740960,  2.189985,  1.654754,  1.541425,  1.674754,  1.850412,  1.668974,  1.603782,  1.727216,  1.786298,  1.845445,  1.221413,  0.410245,  0.743256,  0.715063,
			  0.943349,  0.466841,  0.582965,  0.814339,  1.415734,  0.959940,  1.002933,  0.854490,  0.574575,  1.003486,  1.103221,  0.868124,  0.796670,  0.704483,  0.815038,  0.794086,
			  2.200788,  1.343219,  1.282446,  0.901566,  2.048672,  1.122053,  0.726692,  0.726692,  0.726692,  0.687686,  0.685245,  0.687686,  1.699548,  1.692968,  0.726692,  0.499536,
			  0.331586,  0.331586,  1.862238,  1.875931,  1.875931,  1.718819,  1.677786,  2.742105,  2.742103,  2.713449,  1.833798,  0.282108,  0.282108,  0.179496,  0.179496,  0.179496,
			  0.179496,  0.179496,  0.179496,  0.180870,  0.180870,  0.180870,  0.180870,  0.180870,  0.180870,  0.180870,  0.180870,  0.180870,  0.180870,  0.180870,  0.180870,  0.177276,
			  0.177276,  0.177276,  0.177276,  0.177276,  0.177276,  0.400106,  0.400106,  0.400106,  0.400106,  0.400106,  0.400106,  1.862238,  1.957090,  0.517310,  0.468620,  1.875931,
			  1.875931,  1.957090,  1.957090,  1.957090,  1.638502,  0.825718, 16.788272,  0.956987,  1.224001,  1.127527,  0.091615,  0.031909,  0.032556,  0.072019,  0.072019,  0.072019,
			  0.072019,  0.032556,  0.032556,  0.032556,  0.032556,  0.031909,  0.031909,  0.072019,  0.031909,  0.031909,  0.031909,  0.032556,  0.032556,  0.032556,  0.032556,  0.032556,
			  0.032556,  0.072019,  0.032556,  0.032308,  0.032308,  0.032308,  0.032308,  0.032308,  0.032308,  0.916715,  0.072019,  0.072019,  0.072019,  0.072019,  0.032308,  0.032308,
			  0.032308,  0.032308,  0.032308,  0.032308,  0.072019,  0.072019,  0.340236,  0.238165,  0.170663,  0.121708,  0.210255,  0.400106,  0.725939,  1.748960,  0.215563,  0.215563,
			  0.178809,  0.252220,  0.444409,  0.178809,  0.252220,  0.444409,  0.321482,  0.475793,  0.302482,  0.303088,  0.303005,  1.502323,  1.077970,  1.696892,  4.420949,  1.696982,
			  1.410696,  1.318984,  1.702483,  0.565975,  0.776785,  1.089758,  0.082502,  1.120128,  1.121994,  1.300740,  2.676568,  0.436531,  4.036890,  2.131746,  2.132879,  2.120341,
			  1.916568,  1.243108,  2.130219,  2.126039,  2.125607,  1.738618,  1.842463,  2.124855,  2.136718,  2.121294,  2.121289,  2.121289,  2.131489,  1.380666,  1.528975,  1.155552,
			  0.784219,  1.013931,  0.935926,  0.716509,  0.583594,  0.452628,  0.086023,  0.895825,  1.223963,  1.438853,  1.444666,  1.582211,  1.875924,  1.543599,  1.277601,  1.340929,
			  1.341326,  1.341354,  1.341361,  1.341338,  1.213318,  0.700851,  1.278293,  1.091086,  1.261685,  1.667196,  0.503861,  1.558969,  0.377088,  1.175199,  1.267251,  1.159366,
			  1.179728,  0.207537,  0.185806,  0.495669,  0.625315,  0.119699,  0.146452,  0.136479,  0.240281,  0.295803,  0.394244,  0.383828,  0.189994,  0.389683,  0.699976,  1.075230,
			  1.075230,  0.522837,  0.522837,  0.522837,  0.195408,  0.178433,  0.167448,  0.587879,  0.275851,  0.435083,  0.577479,  0.507749,  0.659021,  0.330366,  0.694248,  1.615003,
			  1.448698,  0.874441,  0.874444,  0.836151,  5.646557,  1.212679,  0.380167,  1.524101,  1.520081,  0.823426,  0.243661,  0.844954,  0.786002,  0.395693,  1.493610,  0.740251,
			  1.150565,  0.834380,  0.730545,  0.644869,  0.920288,  1.180199,  1.269425,  1.221348,  1.288545,  1.148336,  2.270840,  1.615475,  0.767332,  0.950968,  1.152439,  0.715210,
			  0.649004,  1.074692,  3.413952,  1.005437,  1.188416,  0.458936,  0.398375,  0.633206,  0.763325,  0.551957,  0.421570,  0.466518,  1.244536,  1.267371,  1.160287,  1.276070,
			  1.078917,  0.705429,  0.152039,  1.169522,  1.174131,  1.181337,  1.177634,  1.176874,  0.797797,  0.661926,  0.665414,  0.756599,  0.912068,  0.474445,  1.041319,  1.533452,
			  1.265100,  1.514536,  1.260983,  2.275083,  1.239030,  0.830962,  0.830973,  1.525802,  1.290483,  1.525444,  1.525444,  0.806155,  2.089509,  2.100886,  0.938193,  0.994584,
			  0.886252,  1.488656,  1.419994,  2.100619,  0.938193,  0.360141,  0.641167,  1.619338,  0.937170,  1.309388,  1.020560,  0.761142,  0.964838,  0.964838,  2.091835,  0.966130,
			  0.998229,  0.980210,  1.203708,  1.030809,  1.302939,  1.390913,  1.863855,  0.921612,  0.887817,  1.140218,  2.066724,  1.188197,  1.413717,  1.217198,  1.474138,  1.196640,
			  3.722170,  3.567806,  1.472987,  2.215091,  1.146538,  1.488530,  2.116488,  2.392766,  1.780684,  1.456604,  1.190222,  0.887817,  1.769076,  0.971976,  0.443581,  1.198580,
			  0.404327,  2.058285,  0.434956,  0.967347,  0.270473,  1.062219,  1.285011,  1.389623,  1.497755,  0.432177,  1.164145,  0.426501,  1.746440,  1.351372,  1.579550,  1.634421,
			  1.916730,  1.287201,  0.917198,  0.675836,  0.377602,  0.377602,  0.377602,  0.378158,  0.377341,  0.378158,  0.377941,  0.386812,  0.377941,  0.385479,  0.384470,  0.384470,
			  0.739528,  0.591977,  0.468100,  0.592562,  0.572652,  0.767199,  0.712509,  0.565751,  0.779294,  0.628201,  1.047978,  0.881017,  0.832629,  0.644851,  0.457762,  1.178226,
			  0.851572,  0.755622,  0.481947,  0.520354,  0.415749,  0.545342,  0.489192,  0.561636,  0.716934,  0.773020,  0.576718,  0.932745,  0.514222,  0.390022,  1.027842,  0.679220,
			  1.197880,  1.461460,  0.861810,  0.881523,  0.608635,  0.567438,  0.642418,  0.431688,  0.583284,  0.417479,  0.520780,  0.874149,  0.420717,  0.520780,  0.569159,  0.693333,
			  0.642114,  0.699563,  0.341201,  0.520955,  0.690452,  0.420931,  0.554668,  0.401026,  0.788973,  0.758399,  0.650288,  0.839183,  0.691766,  0.692876,  0.807215,  0.685635,
			  0.855100,  0.798828,  1.915168,  0.947884,  0.954837,  0.737978,  1.513172,  0.711925,  1.977627,  1.416651,  2.967793,  1.834215,  3.363614,  2.487685,  1.847694,  0.806155,
			  1.304996,  1.563845,  0.769327,  1.549013,  2.059173,  0.730867,  0.691375,  1.325917,  0.669879,  1.277209,  1.302932,  1.324486,  0.608105,  0.474561,  0.457370,  1.397883,
			  0.435993,  1.319576,  0.501047,  1.168164,  0.197634,  0.823966,  0.197637,  0.197634,  0.732837,  1.571795,  1.560755,  0.549687,  0.763433,  1.142600,  0.871029,  0.863579,
			  1.276983,  0.875984,  0.914909,  0.830974,  0.830977,  0.881353,  0.321265,  0.923237,  0.094644,  1.173475,  0.836067,  0.200076,  0.200076,  0.200076,  0.495377,  0.785973,
			  1.013051,  0.376962,  0.377602,  0.377941,  0.715484,  2.267549,  0.422632,  0.606227,  1.019922,  1.105808,  0.408064,  0.642418,  0.728964,  0.515084,  1.301682,  1.265933,
			  1.597555,  0.453460,  1.252760,  1.326223,  1.444110,  1.720901,  0.600528,  2.059565,  2.322702,  0.645457,  0.639277,  2.286562,  1.626870,  1.011855,  0.671235,  0.600528,
			  0.352263,  1.310035,  0.352263,  1.079372,  1.127573,  0.593002,  0.637937,  0.639277,  0.643176,  1.514036,  1.029873,  2.316098,  0.593002,  0.639276,  0.636381,  0.600525,
			  2.335290,  0.639271,  1.669669,  4.992428,  1.282853,  1.282853,  1.282858,  0.406446,  0.636914,  1.035696,  1.282852,  0.472162,  0.725619,  1.044113,  1.216315,  0.939351,
			  1.551712,  0.862950,  1.259111,  1.256257,  0.771880,  0.470800,  0.410488,  0.900686,  0.813660,  0.536080,  0.622995,  0.694828,  0.947387,  0.610634,  2.130475,  1.535284,
			  1.564532,  1.176064,  0.960278,  0.838962,  1.086261,  0.564163,  1.062325,  0.833863,  0.884832,  0.833425,  1.127810,  1.335868,  0.834279,  0.834271,  0.809412,  1.015802,
			  1.492372,  1.623873,  0.730241,  1.251796,  1.518370,  0.511192,  0.932861,  0.826206,  0.643701,  1.297023,  1.185554,  1.588886,  1.383677,  0.865830,  1.218526,  1.382853,
			  0.711049,  0.787068,  0.740499,  1.289222,  0.431993,  0.615548,  0.572555,  0.444777,  0.650439,  0.645413,  0.660930,  1.382853,  0.450765,  0.911972,  0.785867,  0.650049,
			  0.929105,  0.400227,  1.260987,  0.707143,  1.156288,  0.339787,  0.650439,  1.855597,  0.353552,  0.353552,  0.353552,  1.004755,  0.653344,  0.651166,  0.653275,  0.353552,
			  0.651166,  0.874673,  0.874693,  1.163619,  0.536082,  0.528766,  1.260983,  0.528766,  0.528766,  0.697986,  0.697986,  0.710030,  0.697986,  1.152955,  1.606966,  1.605059,
			  2.377221,  0.432440,  0.592675,  0.431968,  1.253471,  1.331076,  0.580420,  1.253999,  1.364261,  0.652200,  1.600098,  0.658472,  0.620490,  0.675743,  1.255818,  1.215072,
			  0.706632,  1.335636,  1.335636,  1.342679,  1.342206,  1.342206,  1.342679,  2.119941,  2.121231,  2.125112,  2.118205,  2.119942,  2.118205,  2.099709,  2.090574,  2.109163,
			  2.085927,  2.085927,  1.027899,  1.160899,  1.164070,  1.160907,  1.026532,  1.026532,  1.022218,  1.022218,  1.057749,  0.853528,  0.847127,  0.847126,  1.207180,  1.211498,
			  2.589234,  2.589771,  2.148650,  3.222140,  4.069777,  3.791943,  2.350990,  3.504827,  2.213299,  1.854503,  1.939350,  1.868643,  2.028908,  2.123976,  1.888872,  2.681427,
			  2.093760,  1.365950,  1.133293,  1.133293,  0.975115,  1.602084,  1.171682,  1.171682,  1.021306,  1.136008,  1.338773,  0.585227,  0.698468,  2.646883,  1.151118,  3.212485,
			  2.446782,  0.946739,  0.772028,  0.556285,  0.623492,  0.965418,  0.778903,  0.642416,  1.196823,  0.123574,  0.825353,  1.347314,  2.307563,  1.397371,  1.056669,  1.149230,
			  1.251026,  0.841229,  0.934642,  1.008681,  1.031254,  0.242285,  1.192957,  0.733488,  1.163223,  1.982632,  1.041149,  0.662558,  0.880943,  0.871528,  0.890581,  3.690561,
			  3.854640,  2.824884,  1.402657,  1.693966,  1.681136,  1.407358,  1.041031,  2.236627,  2.236627,  4.616834,  1.819699,  0.839397,  0.798945,  1.293938,  1.777590,  1.558269,
			  1.041149,  0.704369,  1.000076,  1.000151,  0.835083,  0.759652,  0.704581,  0.201041,  0.468055,  1.886350,  1.061329,  1.061329,  0.858290,  4.033983,  0.733887,  0.777159,
			  0.777159,  0.777159,  0.777159,  0.987697,  0.666692,  0.589263,  1.007012,  0.310945,  1.442517,  1.449146,  0.846826,  0.846825,  0.846825,  4.742284,  1.348731,  2.035367,
			  1.209133,  0.970780,  1.031867,  1.709185,  2.339674,  1.599869,  1.281782,  1.281780,  0.205494,  1.214519,  0.226633,  0.187195,  0.240626,  0.240626,  0.261234,  0.326110,
			  0.318924,  0.572073,  0.424445,  1.433349,  0.987987,  1.047741,  0.377669,  0.777159,  0.777159,  0.777159,  1.144629,  1.292822,  0.625409,  0.633565,  0.138506,  0.077278,
			  0.572072,  0.472588,  0.472588,  0.358615,  1.777546,  0.155395,  0.169172,  0.125678,  0.643656,  0.294665,  0.575073,  0.846823,  0.846823,  0.846823,  0.654307,  0.672935,
			  0.672082,  0.672082,  0.949464,  0.496811,  0.824298,  0.643687,  0.374343,  1.780171,  2.133243,  0.892086,  0.892086,  0.892086,  0.894640,  0.894640,  0.894640,  0.894640,
			  1.784487,  1.163223,  0.790585,  0.589929,  0.290564,  0.317232,  0.388453,  1.468415,  2.039866,  1.590196,  1.653938,  1.303163,  1.396849,  0.166344,  0.249860,  0.103255,
			  0.158114,  0.410488,  1.089849,  2.411370,  1.065708,  0.815311,  0.805680,  0.704774,  0.773109,  0.533051,  1.244400,  0.856558,  0.871963,  1.564532,  0.704581,  0.356896,
			  0.108511,  0.145559,  0.734373,  0.410488,  8.095453,  1.278143, 13.127747,  1.623574,  0.694072,  0.694072,  1.213404,  1.213404,  0.674202,  0.972410,  0.476334,  3.796439,
			  4.456603,  2.309391,  2.309391,  3.785428,  0.718626,  3.010124,  3.010124,  9.232945,  1.486436,  1.486436,  1.486436,  1.486436,  0.777161,  1.538637,  0.361194,  1.149569,
			  0.441772,  0.627538,  1.357360,  0.763477,  0.323237,  0.734081,  0.535682,  0.727026,  1.567584,  0.573804,  0.892396,  0.893925,  0.478224,  0.386294,  0.365857,  1.101071,
			  0.498201,  1.101071,  1.134212,  0.637664,  0.336697,  0.406989,  0.315843,  0.253349,  0.450053,132.940704,  0.497889,  0.461133,  0.424171,  0.307696,  0.268577,  0.319970,
			  0.586203,  1.130964,  1.130964,  0.999895,  1.130964,  0.410908,  0.658993,  0.493645,  0.512407,  0.932654,  1.024402,  0.522378,  0.625558,  0.733286,  0.653250,  1.093616,
			  0.366106,  0.393593,  0.567381,  0.298752,  0.487011,  0.498528,  0.430236,  0.329167,  0.221849,  0.832681,  0.481642,  0.451162,  0.612357,  0.485875,  0.507412,  0.364950,
			  0.255041,  0.474922,  0.489832,  0.598447,  0.373138,  1.055915,  0.396636,  1.896304,  1.215638,  1.420910,  0.310725,  1.421880,  1.422780,  1.421475,  1.421718,  1.422453,
			  0.077515,  0.137281,  0.504217,  0.000000,  0.000000,  6.430579,  0.262869,  1.658308,  2.307897,  3.275801,  5.107081,  0.270552,  5.041477,  2.938496,  0.395940,  0.453303,
			  8.518948,  2.298959,  3.390782,  2.526972,  1.006965,  0.967326,  0.328193,  6.322517,  1.800673,  0.456523,  0.330895,  0.555768,  0.171444,  4.416817, 86.079307,  1.186157,
			  0.613098,  0.828167,  0.682312,  0.473434,  0.249973,  2.957323,  1.292009,  1.692625,  3.585421,  0.732303,  0.208776,  1.392478,  1.410231,  0.769266,  1.018576,  2.739526,
			  1.807796,  2.739526,  1.576318,  2.401988,  4.164210,  4.707600,  4.164210,  4.164210,  1.067639,  1.305006,  6.556553,  4.306343,  4.308828,  0.705663,  1.189563,  0.837688,
			  1.449494,  2.487154,  1.433441,  1.253026,  1.364824,  1.457543,  5.175620,  3.383616,  1.720460,  0.058398,  1.161216,  1.410231,  7.780178,  2.779045,  0.102127,  1.458621,
			  2.330595,  0.113770,  0.112963,  3.194360,  1.473337,  0.363332,  0.184053,  0.166984,  0.476359,  0.428840,  1.252989,  2.012979,  1.076642,  2.123804,  2.101270,  1.270676,
			  0.489457,  1.014492,  1.136590,  0.197634,  0.823966,  0.197637,  0.197634,  0.780622,  1.618777,  1.105924,  0.707423,  1.499673,  2.878372,  3.102401,  6.411385,  2.326608,
			  0.130781,  0.682312,  0.900075,  0.038233,  0.038233,  0.038233,  0.038233,  0.038233,  0.038233,  0.038233,  0.037999,  0.038199,  0.771386,  1.366340,  1.839265,  0.472990,
			  0.337693,  0.285542,  0.468347,  0.435535,  0.160705,  0.277913,  0.458481,  0.472997,  0.277913,  0.612489,  0.461246,  0.456925,  0.408475,  0.392679,  0.333552,  0.360994,
			  0.376951,  1.815848,  0.302567,  0.059684,  0.634154,  1.671177,  4.382432,  1.550680,  2.018198,  3.061911,  2.018198,  1.510629,  3.002028,  5.566802,  4.338140,  2.525034,
			  5.106966,  1.974992,  1.085271,  4.166143,  0.057211,  0.015145,  1.003864,  0.940729,  5.647490,  2.983566,  3.051646,  1.490345,  0.456721,  0.857667,  1.330245,  4.809926,
			  0.439759,  0.695441,  4.241330,  6.101414,  0.533927,  1.327216,  1.649142,  3.316983,  3.215450,  0.132201,  6.465782,  0.744428, 18.882497,  6.788412,  0.094112,  0.190363,
			  0.190362,  4.532440, 17.527975,  8.309681, 38.941505,  2.444242,  4.201559, 52.445079,  5.338490,  4.453812,  0.400000,  3.477672,  6.429508,  1.976950,  0.608905,  1.976950,
			  1.976950,  1.544649,  1.811511,  2.521162,  0.957744,  1.575768,  1.400001,  6.369944,  1.926077,  5.875579,  4.038138,  4.161016,  0.037999,  0.037999,  0.037999,  0.037999,
			  0.037999,  0.037999,  0.037999,  3.933981,  6.108032,  1.412338, 13.290303,  1.015419,  0.231630, 12.739751, 12.099946, 14.160424,  2.696930,  2.079559,  0.000000,  1.266312,
			  0.132201,  1.099663,  0.770950,  0.634154,  0.547424,  2.535089,  0.283372,  3.748817,  0.378574,  0.843738,  0.897348,  2.694688,  2.311543,  0.634625,  1.066061,  0.716511,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  8.400908,
			  5.905694,  7.895244,  8.085197,  4.115653,  6.450072,  7.886816,  3.853687,  4.367136,  0.000000,  0.000000, 10.885889,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000, 12.822070,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  8.470140,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 10.476472,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.716211,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  7.896544,  7.251562,  4.818415, 21.485364,  0.000000,  6.295914,  0.000000,
			  0.000000, 11.915535,  7.921716,  0.000000,  6.242066,  6.044666,  0.000000, 18.596294, 18.259141, 16.395137, 15.784274, 16.867313,  1.798545,  3.213361,  1.762442,  1.480842,
			  1.830731,  1.463068,  0.000000,  1.875412, 25.481317, 19.306108, 19.630561, 20.746503,  6.427846,  3.342508,  6.110422,  7.997696,  6.289926,  3.482814,  1.952561, 11.529054,
			  1.131373,  2.028666,  5.648581,  7.726811,  9.010965,  7.337606,  5.711699,  4.808299, 16.395137, 15.784274, 18.259141, 18.596294, 15.446888, 10.904518,  4.645609,  5.711699,
			  4.808299,  7.251562,  7.896544,  7.726811,  7.337606,  9.010965,  1.857298, 24.978864, 25.036682, 25.037885, 27.507530, 27.514125, 27.474575, 27.470357, 25.037368, 25.088199,
			 25.037305, 25.037521, 31.289121, 31.289121, 31.254655, 31.289121, 27.470357, 27.474575, 27.507530, 27.514125, 25.088199, 25.037521, 25.037305, 25.037368, 31.289121, 31.254655,
			 31.281370, 31.289121, 42.928298, 51.312446, 51.312446, 42.928298,  4.790938,  2.354186,  7.418520,  3.001899, 21.485364,  7.895244,  8.400908,  8.085197,  7.886816,  5.905694,
			  4.115653,  6.450072,  3.853687,  4.367136,  0.000000,  0.000000,  2.273395, 31.254655,  3.630208, 31.281370,  2.740492, 14.419460, 11.912281, 14.419460, 11.912281,  8.321462,
			  8.321462,  7.497739,  5.234267,  6.531876,  7.299404, 15.446888, 25.481317, 20.746503, 19.630561, 19.306108,  9.837521, 25.037885, 25.036682, 24.978864,  3.201565, 25.760225,
			 25.760225, 11.683760, 11.683760,  1.497236,  1.497236, 50.795982, 50.795982,  2.349478,  1.832885,  0.425233,  1.658311,  1.658311,  1.658311,  1.658311,  1.867383,  1.870761,
			  1.871436,  1.955490,  2.291443,  2.282804,  2.650815,  2.270605, 12.463183,  6.626863,  9.625503,  9.173625, 21.560035,  8.991529, 21.560035,  8.991529,  6.538467,  0.800736,
			  0.823758,  3.002207,  2.228364, 80.300621, 49.862232, 49.862232, 11.664044,  7.629834,  0.000000,  6.477346, 10.184639, 11.662155, 11.662155, 11.664044, 10.184639,  7.629834,
			 16.867313, 12.748411, 18.752439, 18.889406, 18.752439,  0.000000,  2.413186,  1.201591,  9.245639,  2.908446, 15.701465,  5.829898, 34.149688,  6.037439,  6.224473,  4.337407,
			  2.422519,  2.267342, 33.673545, 29.884054, 28.581436, 23.683868, 24.170619, 10.421657, 48.055458, 26.614070, 20.426256, 14.678315, 18.283555, 21.951501, 20.852844, 38.680679,
			 29.417253, 47.944107, 21.711126,  7.560328,  5.437942,  1.633458,  2.354804, 10.174111, 28.388292,  1.971853, 28.375881,  1.114691,  1.114671, 25.705755,  3.655848,  2.258224,
			  6.502800, 22.522638, 14.442954,  5.809267, 18.283555, 21.951501, 20.852844, 47.944107, 38.680679, 29.417253, 15.701465, 33.137489, 32.817516, 33.254558, 33.519222, 28.732698,
			 28.506456, 34.150348, 34.150348, 62.825317, 45.001953, 49.054351,  4.926659,  4.926659,  2.831005,  1.081452,  4.535903,  5.566486, 30.077899, 30.077899,  4.997630,  1.385079,
			  1.652892, 10.726689,  7.971006, 10.506149,  7.019477, 14.399078,  8.650229, 12.161812,  7.071331, 13.970439, 13.970396,  4.045423, 11.645357, 11.483315,  1.925380,  1.925624,
			  2.555986,  4.569366,  2.909236, 25.705755,  2.917459,  0.766933,  0.463665, 47.295425,  3.217397,  3.337050,  5.886857,  4.520339,  2.669512,  4.733716,  0.690375, 26.614070,
			 28.388292, 28.581436, 20.426256, 28.375881, 33.137489, 32.817516, 33.254558, 33.519222, 28.732698, 28.506456, 23.683868, 24.170619, 29.884054, 29.932899,  4.724580,  3.133255,
			  5.959991,  0.000000, 16.948219, 10.906545,  8.404380, 10.908623,  9.983736,  9.983736, 10.908623,  8.404380,  8.395932, 10.906545,  4.562832,  4.455186, 10.558980,  9.069401,
			  9.431450,  9.431450,  4.455186,  4.455186,  4.455186, 11.072610, 11.891983, 12.563268,  3.197058,  2.420150,  5.250713, 14.146268, 10.660916, 10.228023,  8.395932, 10.228023,
			 33.089885,  5.840976,  9.197355, 10.789411, 22.394508, 10.906491, 10.905950, 10.905950, 10.906491,  3.748013,  3.798530, 22.243673, 19.995439, 22.316911, 17.531585, 16.294664,
			 20.101209, 17.826141, 18.217584, 29.396310,  9.981899, 29.681875, 13.195835, 29.635971, 25.535501, 26.212739,  0.000000,  0.000000, 16.621660, 19.663864, 16.701076,  8.041733,
			 11.152142, 12.523098, 13.625176, 18.490728, 21.278070, 67.996963, 15.214099, 17.939153, 26.236381, 11.033258,  6.808884, 22.419296, 16.702850, 47.409595,  5.836871,  3.987323,
			  0.653160,  1.014351, 10.346331, 15.144088, 16.883653, 15.171847, 13.777656, 12.091684, 11.667741, 15.017664, 10.402745,  9.595365, 17.787235, 17.787235, 11.246561, 10.156318,
			 10.156318, 11.196286, 10.018744, 10.018744, 15.198732, 15.198732, 11.196286, 11.241856, 11.241856,  2.268316,  3.586795,  1.708690, 11.214670, 23.073612, 23.073612,  4.188293,
			 15.001590, 20.416824,  0.546855, 22.394508, 10.789411, 10.346331, 15.144088, 22.974449, 47.409595, 34.860912, 22.350446,  5.169726, 19.008934, 17.711082, 18.672235, 19.008934,
			 18.672235, 17.711082, 34.860912, 16.883653, 19.201141, 19.201141, 22.419296, 15.214099, 67.996963, 88.404747, 88.404747, 18.904027, 16.864042, 16.847312, 10.412982, 33.089885,
			 25.524061, 25.524061, 11.730890, 11.730890, 11.063935, 11.030605, 27.784505, 27.784505, 28.373458, 28.373458, 11.246561, 54.626903, 54.626903, 17.939153, 26.236381, 33.295768,
			 33.295768, 29.737951, 29.737951, 20.360635, 20.360635, 29.801671, 12.091684, 11.667741, 10.402745, 15.017664, 14.977306, 14.977306, 40.945503, 20.101209, 18.217584, 17.826141,
			 19.663864, 16.701076, 25.535501, 17.531585, 13.625176, 29.635971, 29.681875, 29.396310, 13.195835,  9.981899, 18.490728, 16.294664, 26.212739, 38.160602, 38.160602,  8.373454,
			 11.891983,  9.595365, 21.278070,  9.431450, 16.702850, 12.403761, 12.403761,  2.477407,  2.477407, 38.584861, 18.793804, 52.663742, 52.663742, 12.200527, 38.584861, 12.762627,
			 12.762627,  6.426527, 15.586329, 33.489006, 17.872070, 12.890026, 17.872070, 12.890026, 15.586329, 11.033258,  6.808884, 33.422561, 10.660916, 11.152142, 12.523098, 16.621660,
			 26.681524, 26.681524,  8.041733, 15.171847, 20.416824, 43.343330, 43.343330, 14.612485,  0.000000,  0.320145,  1.525315,  1.779374,  1.723423,  1.713121,  1.469998,  1.748312,
			  1.699484,  1.712470,  1.767743,  1.734684,  4.086437,  1.811823,  1.732051,  2.352435,  0.935536,  0.423577,  1.046712,  0.421362,  1.166638,  1.564599,  1.739537,  1.538946,
			  0.461519,  0.625815,  1.087622,  1.642091,  0.975295,  1.423228, 34.150348, 34.150348, 62.825294, 62.825294, 18.007019,  4.973666, 12.790003, 11.506089, 10.935259, 12.479024,
			 10.665526, 10.237988, 11.506063, 10.742444, 11.068281,  9.996208, 10.662814, 12.790003, 11.506089, 10.935259, 12.479024, 10.665526, 10.662814, 11.068281, 10.742444,  9.996208,
			 11.506063, 10.237988, 10.237978, 12.108787,  9.725163, 10.808471, 10.808471, 10.237978,  9.725163, 12.108787,  1.818187,  6.006149,  7.211412,  4.396234,  6.530846,  4.854097,
			 12.200527,  4.732118,  7.857415,  3.916301,  3.329617,  3.329602,  3.322731,  3.329617,  8.232070,  4.977199, 24.104995, 23.514358, 23.514358, 24.104995,  0.000000,  0.000000,
			  9.740780, 25.769062, 25.769062,  7.986660, 28.737014,  1.783725, 10.247182, 20.201528, 20.201528,  6.505136,  3.879139,  0.000000,  1.873893,  3.233859, 15.597586, 35.800193,
			 35.800193,  0.000000,103.703247, 44.743614,121.833786, 43.621814, 60.980705, 37.769611,245.193222,174.265151,100.480148, 81.130874, 30.447898, 30.373996, 36.433082, 90.729354,
			127.462547, 80.055519, 87.920341,109.381408, 67.739196, 88.914276,130.299346, 58.549739, 96.354354,236.935272, 30.957479, 39.991146,174.908950, 34.300724, 54.450576, 13.992629,
			  6.444643,  4.142128,  7.607350,208.003677,242.170059,  4.078981,  2.371741,  2.468210,  5.410252,  0.693256,  0.693246,  0.821282,  4.424273, 95.361030,  5.410252,  3.573327,
			 41.350326, 41.355430, 41.765392,  4.424281, 13.667098, 13.667098, 14.465104, 10.204536, 10.289823,  7.504170,  8.268250, 30.320236, 14.062297, 52.595149, 45.061084, 65.536384,
			 34.066280, 25.119647, 33.233478, 28.820571, 50.076812, 42.740211,146.837951, 93.655944, 41.765392, 46.031757,  1.811066,  1.113808,  1.322849,  0.991089,  2.134561,155.105255,
			184.297988, 20.577693,  8.113075, 36.674682,  8.927226, 20.542707,  0.000000, 94.306724, 66.567405, 89.962142, 63.418716, 39.966640, 75.638008, 52.856590, 66.465278, 40.427894,
			 44.748905, 54.608226, 43.491420, 38.132789, 51.546703, 69.310119, 61.768138, 76.236778, 82.115539, 72.323242, 60.827835, 47.996040, 52.561077,100.224014, 35.082603, 41.147197,
			 51.562313, 69.316558, 94.110511, 12.478493, 55.576343, 33.446079, 44.284732, 65.767021, 44.935325, 65.767021, 67.227752, 80.462287, 52.645912, 38.053432, 48.903324, 38.795608,
			 76.233345, 44.368015, 25.849700, 74.971939,123.236564, 16.105125, 16.540868, 38.714962, 94.110511, 74.971939, 76.233345, 46.207302, 39.843029, 60.514266, 47.557220, 52.856590,
			 52.703727, 48.804027, 21.746292, 88.763992, 76.188011, 82.115539, 72.323242, 60.827835, 47.996040, 61.304882, 61.768138, 76.236778, 75.638008,100.224014, 55.576343, 37.037326,
			 37.037326, 55.605762, 67.227752, 16.105125, 58.810592, 63.418716, 33.446079, 44.284732, 89.962142, 55.535930, 76.664817, 41.661239, 43.859970,123.236564, 76.664817, 94.306724,
			 66.567405, 38.053432, 70.671989, 41.661239, 43.859970, 69.316558, 43.491420, 40.427894, 52.645912, 48.804027, 38.132789, 25.849700, 46.207302, 39.843029, 44.748905, 41.147197,
			 51.562313, 35.082603, 44.368015, 80.462287,  3.466928, 47.093536, 62.649757, 43.371242, 41.542778, 51.405620, 53.159515, 26.453914, 51.405620, 43.371242, 62.649757, 41.542778,
			 53.159515, 26.453914, 47.093536, 16.253765,  7.062679, 88.970924, 60.450263, 86.024833, 86.024833, 88.970924, 30.168819, 88.763992, 61.304882, 58.810592, 33.296257, 33.296257,
			 55.605762, 45.097888, 30.342864, 30.342864, 45.097888, 41.039821, 44.935325, 41.039821, 39.312397, 20.125812, 70.671989, 47.949840, 47.949840, 69.420639, 69.420639, 69.659599,
			 60.150753, 61.282341, 61.282341, 64.794830, 64.794830, 49.552967, 49.552967, 66.465278, 60.514266, 69.310119, 47.557220, 50.704250, 50.704250, 37.628517, 64.125183, 64.125183,
			 69.486251, 69.486251, 52.531387, 52.531387, 60.467987, 60.467987, 60.467296, 60.467296, 66.602783, 66.602783, 61.125209, 61.125209, 74.607521, 74.607521, 80.627525, 80.627525,
			 65.430541, 65.430541, 60.898612, 70.925048, 70.925048, 71.115852, 71.115852, 72.172378, 70.709617, 70.709617, 36.717815, 25.551355, 24.594835, 25.855968, 34.116165, 33.921955,
			 23.317625, 23.317625, 22.551925, 22.551925, 48.388702, 37.628517, 72.172378,  7.366425, 34.436058, 14.070554, 55.535930, 48.903324, 38.620609, 32.038837, 54.847293, 16.540868,
			 56.829673, 28.512996, 28.512996, 41.734348, 22.540279, 34.241111, 59.700771, 16.967144, 16.967144, 34.760654, 35.557067, 41.578514, 41.578514, 24.423269, 12.764382, 76.188011,
			 52.561077, 60.898612, 54.608226, 59.700771, 40.443958, 31.966392, 46.133224, 47.170886, 35.570499, 51.323192, 59.655761, 51.211753, 78.219932,102.999076,127.880035, 51.546703,
			 69.659599, 60.150753, 38.714962, 14.950845, 52.703727,117.066261,117.066261, 39.047832, 45.280517, 65.162673, 65.162673, 36.166343, 36.166343, 11.070536, 11.070644,  8.952790,
			141.426696,140.760650,160.547958,140.840682,156.294845,159.516738,158.920104,158.920104,160.403427,190.938964,247.987380,246.715545,255.302917,165.223510,179.994155,161.186401,
			147.744934,260.866943,265.525390,285.896820,231.108886,312.098663,328.258819,262.132995,313.918579,319.010467,131.031417,179.494094,228.836181,179.377517,212.414718,230.444671,
			118.756278,167.498535,219.881835,212.471984,167.498535,167.772277,167.498535,158.423522,167.498535,167.772277,167.498535,212.185150,167.498535,195.738769,255.013626,222.745285,
			269.908599,212.152679,165.171752,166.467910,164.864639,165.309097,136.840408,163.916397,136.999725,138.236007,164.864639,157.428054,104.049263, 90.372467,166.044189,121.136955,
			125.965476,125.112815,173.092285,152.825073,177.933013,138.068542,149.260330,130.543411,159.143402,166.611572,256.551849,330.721282,247.279388,221.298950,196.499954,207.875747,
			236.018295,278.772979,313.068420,226.237686,201.381546,144.967071,261.900878,155.288116,189.302597,182.032394,245.371078,233.863967,136.845397,140.410598,226.041183,249.365371,
			279.657562,213.462005,281.775451,171.185455,273.607208,256.766326,180.905639,101.793441,252.940124,252.080032,243.279754,293.696105,276.493835,264.843353,262.166625,253.256134,
			232.970748,190.502014,238.618011,170.805023,166.696273,160.907394,261.743194,235.522933,188.278671,205.091384,203.180328,139.194198,151.448699,124.250762,142.871597,138.090972,
			170.652389,157.032592, 76.005821,134.311721,131.794372,208.059677,121.214103,247.279388,140.760650,160.547958,140.840682,156.294845,159.516738,158.920104,158.920104,160.403427,
			190.938964,247.987380,246.715545,255.302917,179.994155,161.186401,147.744934,260.866943,265.525390,285.896820,231.108886,312.098663,328.258819,262.132995,313.918579,319.010467,
			131.031417,179.494094,228.836181,179.377517,212.414718,230.444671,118.756278,167.498535,219.881835,212.471984,167.498535,167.772277,167.498535,158.423522,167.498535,167.772277,
			167.498535,212.185150,167.498535,195.738769,255.013626,222.745285,269.908599,212.152679,165.171752,166.467910,164.864639,165.309097,136.840408,163.916397,136.999725,138.236007,
			164.864639,157.428054,104.049263, 90.372467,166.044189,121.136955,125.965476,125.112815,173.092285,152.825073,177.933013,138.068542,149.260330,130.543411,159.143402,166.611572,
			256.551849,330.721282,141.426696,221.298950,196.499954,207.875747,236.018295,278.772979,313.068420,226.237686,201.381546,144.967071,261.900878,155.288116,189.302597,182.032394,
			245.371078,233.863967,136.845397,140.410598,249.365371,279.657562,213.462005,281.775451,171.185455,273.607208,256.766326,180.905639,101.793441,252.940124,252.080032,293.696105,
			276.493835,264.843353,262.166625,253.256134,232.970748,190.502014,238.618011,166.696273,160.907394,261.743194,235.522933,188.278671,205.091384,203.180328,139.194198,151.448699,
			142.871597,138.090972,170.652389,157.032592, 76.005821,134.311721,131.794372,121.214103, 17.297796, 15.821649, 15.875753, 15.875749, 18.086914, 16.938776,138.643692,109.406600,
			 25.922864, 20.991394, 12.778238, 12.778232, 12.778233, 12.778228, 20.566125, 14.212968, 14.348272, 28.703405, 24.984434, 81.047729,106.745925, 26.438310, 14.587099, 39.133117,
			226.041183,124.250762,165.223510,243.279754,186.868713,186.868713,170.805023,298.013854,298.013854,208.059677,167.470748,167.470748,275.175689,275.175689,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,150.224395, 59.017223, 73.657226, 66.063667, 44.514404, 92.577590, 52.721599, 62.063739, 38.820682, 81.512466,
			 29.847757,150.224395, 61.680839,137.033935,138.402084, 36.324020,137.033935, 59.695098, 66.438331, 66.798652, 69.070930, 91.183990, 51.465141, 49.487754, 28.736324, 47.703304,
			 89.348289, 91.183990, 69.070930,138.402084, 86.402641, 63.868530, 89.348289, 49.487754, 74.929458,102.622764,124.260139, 72.135513, 28.592561, 63.616577,106.114906, 67.568237,
			 49.893489, 72.990592, 32.463008, 64.973152, 69.325103, 17.962202, 60.197471, 80.715599, 83.356903,114.829551, 86.402641, 63.868530, 81.334831, 65.129089, 32.463008,106.114906,
			 81.512466, 29.847757, 38.820682, 63.616577, 67.568237, 61.052654, 62.063739, 52.721599, 72.990592, 81.334831, 58.784294, 60.399829, 44.514404, 56.011737, 86.867477, 36.324020,
			 74.929458, 83.356903,102.622764, 66.798652, 51.465141,124.260139, 60.828201, 92.577590, 73.657226,114.829551, 59.017223, 64.973152, 58.609943, 84.342796,  2.717215,  2.717129,
			  2.717130,  2.717180,  2.717120, 58.853790, 63.125587, 60.399829, 56.607444, 60.828201, 56.011737, 48.205490, 74.309768, 79.543495, 49.059513,123.329750, 61.052654,123.329750,
			 85.630607, 85.630607, 76.307228, 76.307228, 77.113700, 77.113700, 62.831470, 62.831470, 82.935020, 82.935020, 97.770881, 97.770881, 48.205490, 74.309768, 79.543495, 49.059513,
			 66.438331, 63.125587, 59.695098, 60.740592, 66.063667, 56.607444, 52.531543, 52.531543, 73.205024, 73.205024, 42.257755, 58.784294, 43.330295, 44.695247, 42.257755, 36.825321,
			 43.330295, 44.695247, 86.867477, 45.468067, 89.943534, 39.878158, 39.878158, 41.655616, 89.943534, 23.273258, 61.680839, 58.853790, 62.717281, 68.155479, 63.285430, 65.334831,
			 63.285430, 68.155479, 62.717281, 65.334831, 36.825321, 49.893489, 60.740592, 41.825942, 64.449607, 64.449607, 48.112602,126.808593,102.304466,109.058013, 81.264610, 81.264610,
			 95.351959, 83.975250, 81.969688, 52.335674,  8.462686, 90.645584, 21.815507, 21.742614, 21.815507, 11.071075,  8.953063, 11.070733, 11.070733, 33.166553, 58.444263, 11.070595,
			 61.095748, 71.451011, 82.647430, 57.691253, 39.947574, 60.403152, 80.073348, 88.765899, 54.272563, 46.126434, 83.930198, 63.868736, 59.002517, 57.333152, 38.676559, 73.169975,
			 97.548896, 58.444263, 11.071075, 33.166553, 11.070733, 61.095748,  8.953063, 11.070733, 41.655616, 72.135513, 65.129089,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 82.063446, 61.218120, 64.307815, 94.238403,149.491088, 55.950729, 69.730140, 71.324447,115.423423,137.719314,
			 92.582595, 62.258842, 45.682266, 29.327451, 99.594131,100.564132, 59.051265,141.255706, 39.272403, 78.337440, 40.345275, 90.856246, 42.627777, 99.466491,133.371109,140.471786,
			 61.197578,132.272521,116.688613,145.818908,136.067520, 75.027656,134.159805, 87.468864, 85.162742,135.170516,176.361358, 89.820968,208.841644,200.698364,145.608200,184.206344,
			 16.959058, 76.103096, 47.453796,164.613174,178.961517, 46.053882, 72.799354,122.265563, 90.002655, 11.089139, 79.668525, 69.739791, 84.197761, 61.431835, 92.775222, 94.205467,
			 83.566467,184.038864,168.955032,140.757568, 91.912918,137.010055, 86.078704, 86.125251,147.348602, 98.190750, 45.850891,199.986206,100.189064, 62.126506,168.430999,175.606842,
			 31.306381, 27.957714, 24.099943,116.052093,147.613143, 73.463577, 30.275121, 65.091583, 79.264122, 36.844554,120.713211, 56.595378, 26.983488, 62.126506, 54.062152, 93.572494,
			117.615386,129.471984, 86.153396, 79.264122, 36.844554, 31.306381,164.613174, 71.324447, 94.238403,129.471984,117.615386, 86.153396, 69.730140,137.719314,115.423423, 85.162742,
			 92.582595, 55.950729,200.698364,149.491088,199.986206, 78.337440,178.961517,141.255706, 39.272403,175.606842,116.688613,136.067520,147.348602,100.189064,168.430999, 54.062152,
			 65.091583,116.052093, 87.468864, 89.820968,176.361358,184.206344, 94.205467, 92.775222,184.038864,168.955032,140.757568,130.158203,134.159805,145.818908, 42.627777,132.272521,
			 86.078704, 86.125251,120.713211,133.371109, 61.197578, 45.850891,140.471786, 99.466491, 99.594131,145.608200,137.010055,166.447799,171.864837,208.841644, 83.566467,135.170516,
			 90.856246,100.564132, 45.682266, 62.258842, 84.197761, 98.190750, 69.739791, 64.307815, 75.027656, 24.629283, 82.063446, 29.327451, 61.431835, 30.275121, 93.572494, 79.668525,
			 16.959058, 51.262950, 47.453796, 11.089139, 59.051265, 69.191673, 91.533485, 88.299407, 95.925903,120.383544, 62.261596, 38.960796,  8.914332, 26.983488,140.601287,119.758026,
			 72.228218, 69.312698, 59.409069, 70.494155, 70.494155, 65.091285, 58.123428, 61.036830, 51.345294, 69.690551,130.158203,171.864837,170.658111, 84.593742, 63.356506, 91.559257,
			170.658111,166.447799,140.601287, 63.356506,119.758026, 41.716571, 41.716571, 61.218120, 23.295612, 24.629283, 76.103096, 23.295612,  3.577593, 98.800552, 98.800552, 81.608230,
			 73.808998, 84.293807, 50.992778, 50.992778,114.644996,114.644996,102.293724,104.938804, 73.141899, 66.970611, 86.055000, 86.055000,121.044120,121.044120,129.140884,129.140884,
			 30.382528, 30.382528,  7.980741,  2.502070,109.784942, 91.912918, 91.578125, 91.578125, 90.002655,122.265563, 72.799354,116.279075, 51.262950, 73.463577,147.613143, 66.970611,
			  3.930463,108.901184,101.723083, 19.831787, 19.744098,  3.930624, 77.497077, 24.099943, 40.382221, 40.382221,  3.445705, 27.957714, 67.539840, 11.233785, 51.673038,134.314620,
			 67.530860, 46.449481, 58.156391, 62.297737, 83.412506, 11.939729, 17.620147, 37.803226,114.601638, 78.475379, 89.364868, 70.480110, 78.668357,  0.000000, 89.649749, 78.028068,
			 75.918579, 87.607147,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,208.274902,136.004333,111.977233,190.481445,216.582305, 34.057479, 68.765304, 77.546661, 71.016937,145.141464,106.428588, 62.691490,109.456550, 39.028625, 58.011608,
			 91.913940, 65.626205, 41.628646, 95.751968,116.477966, 62.591064, 22.372737,116.753692, 52.748977, 36.252571,  7.284087, 57.756126, 15.136318, 99.329635, 39.286201, 58.098522,
			 29.210777, 53.920055, 57.164154, 65.168869, 14.967950, 66.957405, 40.603935, 78.095626, 67.200164,159.524246,170.783523, 96.759437, 95.362426, 75.429222, 71.357070, 91.291442,
			  2.520838,  2.522299, 15.019650, 36.890460, 97.097137, 52.901306, 39.991943, 47.881504, 99.425209, 36.890460, 97.097137, 52.901306, 40.945503,  7.091947, 43.448162, 47.881504,
			 31.202550, 46.436901, 27.699733,  4.499946,104.820976, 57.250228, 38.600620, 54.553089,197.489654, 29.461790, 79.931686, 25.782684, 39.624782, 37.947376, 40.833602, 30.979000,
			 76.891921, 42.366260, 72.962493, 25.992193,123.375175, 25.465919, 31.675493, 77.572525, 73.042236,216.582305,109.456550, 53.920055, 58.098522, 42.366260, 25.465919, 14.967950,
			 72.962493, 29.210777, 57.164154, 65.626205, 65.168869, 30.979000, 39.624782, 37.947376, 40.833602, 39.028625, 41.628646,190.481445,116.477966, 95.751968,116.753692, 57.756126,
			 91.913940, 66.957405, 68.765304, 54.553089, 62.591064, 73.042236, 62.691490, 38.600620, 31.202550, 29.461790, 34.057479, 79.931686, 33.140605, 52.748977, 40.603935,106.071144,
			 59.259231, 61.535514, 91.690551,159.524246,170.783523,197.489654,104.820976, 71.016937,123.375175, 91.291442, 78.095626, 40.442573, 25.968847, 58.011608,208.274902, 75.429222,
			 25.782684, 25.992193,121.198081,121.198081,106.428588, 76.891921,145.141464, 77.546661, 57.250228, 99.329635, 67.200164,  6.706373,  6.513462,  7.413219,  7.974123, 96.759437,
			136.004333, 64.149757, 81.710609, 33.140605, 15.821150,  4.808541,161.754669, 84.028549, 74.269966,123.787719,132.290954, 67.989974, 91.778366, 70.023254, 80.724037,113.863182,
			113.863182,161.754669,123.787719, 74.269966, 91.778366, 80.724037,132.290954, 70.023254, 84.028549, 67.989974, 65.014450, 56.484233, 68.343772, 64.421379, 64.983291, 93.242660,
			 52.507427, 56.239822, 56.269199, 18.885034, 18.885034, 37.846599,  3.107570, 77.572525, 22.372737, 25.968847, 57.069438, 52.507427, 37.846706, 47.497711, 44.772937, 75.344474,
			 65.340202, 57.010551,118.135566,118.135566, 57.010551, 47.497711, 44.772937, 75.344474, 56.239822, 39.286201, 80.006172,130.707839,113.464668,180.478591,122.796295, 86.377311,
			108.886047, 51.443969, 82.569641, 82.569641, 51.443969, 96.791671, 96.791671, 99.425209, 43.448162, 55.055381,107.100349, 45.153549,  3.843683, 11.530257, 68.090270, 74.230514,
			 68.090270, 74.230514, 46.436901, 44.574863, 44.574863, 52.979064, 52.979064, 23.556957, 40.945503, 99.051879, 99.051879, 70.912178, 70.912178, 56.484233, 23.337512, 95.362426,
			 27.699733, 37.846599, 37.846706,122.998970, 42.957817,111.977233, 53.005439, 59.336688, 19.080499, 51.583358, 64.643623, 28.770254, 74.908027, 19.065372, 36.016448, 13.923852,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 94.968559, 42.733081,
			 22.536741, 22.308301, 33.668586, 64.795326, 51.517959, 51.538238, 17.468084, 15.417259, 54.506008, 17.031824, 88.630279, 75.029144, 91.363662, 82.293518, 39.277942, 74.580703,
			 88.515151, 29.043003, 38.036636, 59.878997, 77.898872, 54.353748, 62.102539, 76.721862, 11.069492, 77.216499, 41.882980, 90.698478, 65.502265, 15.545929,  2.915631, 55.832653,
			 86.098678, 55.090282, 63.093784, 85.354286, 49.590538, 33.359672, 72.766716, 81.669120, 73.091911, 75.441711,110.606918, 51.435852, 51.265441, 73.090400, 78.193069,100.677642,
			 54.146465, 60.828338, 31.638738, 48.670372, 45.502773, 36.948154, 88.741363, 26.201265, 51.659038, 97.250221, 35.696380, 41.910095, 46.921588, 43.745647, 57.404651, 80.212715,
			 80.212715, 59.313880, 81.506523, 68.660415, 81.506523, 72.760070, 68.800880, 40.392730, 89.840255, 21.227605, 40.392730, 45.649890, 62.102539, 63.039245, 69.070213, 57.607971,
			 76.169425,103.144775,105.511337, 53.955146, 57.771938, 96.562599, 62.992027, 49.779186, 65.385726, 57.404651, 42.526828, 58.934020, 62.513275,100.527351, 62.859573, 54.296775,
			 61.599708, 48.259784, 90.138626, 90.079895, 90.073516, 33.202224, 51.130062, 59.815841, 44.765571, 44.867637,103.262397, 78.322776, 78.587585, 70.795219,100.499023, 80.622978,
			 61.412101, 71.354431, 70.726768, 31.626832, 52.435062, 49.342620, 49.312522, 72.388916,118.342552, 51.300064, 57.607971,105.511337, 53.955146, 57.771938, 75.815002, 47.878067,
			 14.450812, 64.953559, 28.036382, 59.878997, 30.085224, 77.216499, 64.953559, 25.470939, 76.970085, 52.435062, 41.882980, 72.766716, 25.470939, 48.259784, 80.622978, 29.043003,
			 51.538238, 71.354431, 31.948020, 70.726768, 76.970085,100.499023, 70.795219, 60.828338, 88.515151, 77.898872, 31.626832, 74.580703, 61.412101, 75.815002, 49.342620, 38.036636,
			 49.312522, 42.733081, 47.878067, 90.698478, 91.363662, 72.388916, 51.300064,118.342552,100.677642, 65.385726, 49.779186, 54.146465, 76.169425, 79.874122, 62.992027, 33.668586,
			 64.795326, 78.193069, 33.359672,103.262397, 78.587585, 44.867637, 44.765571, 94.968559, 51.265441, 59.815841, 88.630279, 75.029144, 73.090400, 85.354286, 17.031824, 51.130062,
			 63.093784, 55.090282, 90.073516, 90.138626, 96.562599, 51.435852, 33.202224, 90.079895, 55.832653, 86.098678, 58.934020, 42.526828, 78.322776, 72.760070, 68.800880,110.606918,
			 61.599708,100.527351, 54.296775, 81.669120, 62.859573, 59.313880, 48.670372, 22.536741, 22.308301, 73.091911, 68.660415, 39.277942, 54.353748, 27.984310, 38.675636, 43.745647,
			 46.921588, 36.948154, 45.502773, 88.741363, 41.910095, 35.696380, 51.659038, 26.201265, 29.463073, 29.463073,  8.697273, 16.804347, 30.085224,130.533523, 89.260879, 47.737171,
			119.238693,130.102462,109.757766, 91.199653,125.252471,109.531166,130.970596, 88.271278, 74.415596,117.067100, 27.984310, 38.675636, 22.462337, 65.502265, 15.417259, 17.468084,
			 31.638738, 49.590538, 56.203975, 56.203975, 77.714508, 51.517959, 73.164024, 31.585306, 44.945617, 31.585306, 44.945617, 16.804347, 15.407127, 64.501167, 38.660800, 76.324851,
			  8.697273, 56.042671, 74.415596, 75.441711, 51.701053, 51.701053, 15.545929, 14.450812, 11.069492, 57.581550, 57.581550, 62.513275, 19.662151, 65.755279,  7.281569,110.922019,
			110.922019,101.252212, 63.957031,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 47.146709, 70.235755, 86.982994, 23.002397, 72.487571, 52.455139, 34.507762, 25.798166, 19.012464,
			 11.591868, 30.657527, 29.390163, 34.958316, 35.233486, 58.468425, 38.490745, 30.090322, 21.942096, 13.495484, 49.513622, 48.540042, 31.386152, 40.974143, 16.272113, 24.445316,
			 43.060230, 29.048032, 24.261571, 29.219890, 42.861324, 48.459419, 23.084608, 21.078758, 20.789802, 25.495706, 28.383796, 79.558921, 58.108776, 43.664035, 42.045612, 69.197296,
			 89.821708, 94.221519, 85.823226, 83.347908, 62.214797, 81.757652, 43.806869, 51.054546, 80.799880, 82.696655, 75.721412, 55.991786, 76.674064, 90.435905, 61.844638, 77.211448,
			 54.624774, 24.333385, 21.706340, 62.176334,124.758216, 51.664443, 31.807176, 83.915916, 44.570152, 36.060165, 16.173833, 58.382717, 53.714828, 42.162246, 29.438434, 62.467205,
			 59.318489,  1.097854,  2.127075,  3.057568, 20.193826, 32.069087, 25.350534,117.758392, 41.420486, 25.294296, 38.761566, 26.864671,  8.806961, 27.054752, 38.977310, 17.587566,
			 29.368320, 53.221138, 49.576560, 59.917877, 73.577018, 25.929637, 29.229770, 43.867172, 49.022022, 78.331779, 60.126358, 47.247749, 50.862430, 64.275924, 40.934139, 70.146224,
			 49.916904, 48.433555, 58.588115,  9.402087, 49.441638, 47.268390, 23.393167, 38.210769, 13.970922, 12.040469,119.270248, 24.479019, 11.218392, 13.154680, 13.337517, 75.060859,
			 47.247749, 53.221138, 89.821708, 94.221519, 78.331779, 49.022022, 85.823226, 40.934139, 60.126358, 80.799880, 82.696655, 42.508457, 14.339458,  4.988491, 20.796052, 24.445316,
			 29.368320, 36.060165, 28.383796, 43.664035, 35.521965, 39.379020, 11.208229, 64.269981, 25.975206, 25.975206, 69.197296, 39.379020, 21.706340, 57.083747,162.879959, 35.836917,
			  2.915647, 41.257854, 23.002666, 64.934951, 55.298889, 82.621261, 62.232940, 63.353008, 80.878715, 82.113227, 80.959709, 51.664443, 50.603519, 38.490745, 48.014472, 87.538169,
			 77.649177, 53.780048, 38.594879, 58.926170, 49.384632, 51.669307, 43.379692, 43.379692, 80.959709, 58.280799, 85.511146, 58.280799, 85.511146, 54.189884, 43.177642, 57.539352,
			 91.709030, 57.539352, 37.677154, 37.677154, 39.473838, 34.680458, 39.473838, 58.468425, 65.182426, 65.182426, 57.083747, 82.621261, 51.054546, 43.867172, 43.806869, 64.934951,
			 49.916904, 72.487571, 50.862430, 62.214797, 83.347908, 75.721412, 70.146224, 55.991786, 64.275924, 76.674064, 90.435905, 61.844638, 47.146709, 77.211448, 81.757652, 49.576560,
			 55.298889, 59.917877, 73.577018, 62.232940, 29.229770, 25.929637, 14.339458, 42.508457, 70.235755, 49.441638, 52.455139, 58.588115, 62.176334, 48.433555, 29.219890, 25.495706,
			 26.864671, 44.570152, 48.540042, 13.495484, 31.386152, 21.942096, 24.479019, 24.261571, 24.333385, 38.761566, 29.048032, 54.624774, 25.350534, 38.210769, 42.162246, 47.268390,
			 40.974143, 16.272113, 43.060230, 34.507762, 79.558921, 58.108776, 23.084608, 58.382717, 48.459419, 75.060859, 29.438434, 49.513622, 83.915916, 32.069087, 35.233486, 41.257854,
			 30.090322, 48.014472, 87.538169, 38.594879, 58.926170, 62.467205, 43.177642, 42.861324, 82.113227, 86.982994, 23.002397, 21.078758, 20.789802, 63.353008, 80.878715, 25.798166,
			 19.012464, 53.714828, 49.193767, 70.242782, 70.242782, 49.193767, 11.051923, 54.795833, 12.174645, 18.751989, 75.062698, 59.423599, 75.062698, 59.423599, 64.262863, 68.356399,
			 68.356399, 50.154212, 23.393167,119.270248, 11.208229, 20.796052, 37.649871, 55.529525, 55.529525, 37.649871, 23.002666,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000, 74.062026, 30.055078, 42.784599, 70.364379, 39.791065, 34.278579, 49.707611, 58.552616, 22.949333, 48.544456, 62.989978, 65.509353, 40.827613,
			134.094299, 39.574863, 29.140090, 85.666007, 13.653640, 42.082153,107.485671, 76.644882,  5.901002, 24.588027, 39.012855, 63.459056, 70.746986, 47.873737,  8.384083, 51.506847,
			103.136230,166.850082,  7.637133, 42.082153, 13.653640, 70.746986, 47.873737, 51.506847, 40.827613, 30.055078, 70.364379, 42.784599, 26.733095, 39.791065, 34.278579, 49.707611,
			 76.644882, 91.269767,166.850082,103.136230, 58.552616, 42.136409, 78.964836, 34.845153, 25.294914, 34.845153, 25.294914, 39.012855, 24.588027, 63.459056, 87.970710, 42.830020,
			 42.136409, 42.830020, 26.733095, 41.578208, 56.017887, 81.003211, 84.006805, 72.586517, 41.711128, 72.586517, 84.006805, 56.017887, 81.003211, 41.578208, 29.976631, 83.611968,
			 73.891036, 59.072124, 79.526054, 41.231159, 49.062629, 39.452617, 69.237434, 57.203456, 60.148883, 42.368522,160.153320, 91.269767, 96.843475, 73.992767, 60.842365, 93.870780,
			 80.630760, 83.858345, 96.205734,134.094299, 90.555984, 46.554092, 31.881385, 71.442962, 44.891063, 16.095043, 51.338493, 90.555984, 51.338493, 44.891063, 71.442962, 16.095043,
			 87.970710, 30.776756, 30.776756, 31.881385, 35.274875, 40.649860, 40.649860, 47.782573, 71.315521, 47.782573, 41.711128, 35.274875, 71.315521, 33.912178, 39.604820, 39.622409,
			 63.627830, 39.622409, 33.912178, 39.604820, 63.627830, 41.674766, 96.843475, 83.611968, 73.891036, 59.072124, 73.992767, 74.062026, 93.870780, 80.630760, 60.842365, 83.858345,
			 79.526054,107.485671, 41.231159, 69.237434, 39.452617, 49.062629,160.153320, 57.203456, 60.148883, 42.368522, 57.026493, 44.104049, 80.703308, 86.152732, 80.703308, 86.152732,
			 92.684089, 95.021278,137.458190, 91.006446, 87.910850, 44.104049, 57.026493, 35.848564, 35.848564, 20.092491, 41.674766, 98.611465, 16.504091, 38.474140, 71.743453, 98.611465,
			 38.474140, 90.827461, 42.257785, 34.806118, 26.793838, 71.743453, 83.062484, 34.806118, 26.793838, 78.964836, 61.993038, 63.564613, 64.743721, 65.398490, 43.965698, 70.705474,
			 70.705474, 76.369766, 76.369766, 89.894996, 57.800731, 98.057914, 51.491523, 80.687545, 24.075189, 47.410320, 42.971801, 44.905944, 42.931980,111.397438, 80.687545, 44.905944,
			 42.931980, 42.971801, 47.410320, 57.800731, 89.894996, 24.075189, 98.057914, 51.491523, 61.993038, 63.564613, 64.743721, 65.398490, 43.965698, 65.509353,  0.000000, 96.205734,
			 46.554092, 20.092491,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,132.081954,117.285911, 67.033592, 30.703073, 22.340343, 26.039115, 32.117195, 15.812891,
			 44.015594, 20.305143,115.344604, 76.506492, 89.264862, 81.837654, 27.230674, 24.957973, 11.910928,111.598182, 19.144134, 12.085442, 54.429706, 87.729385, 46.525856, 81.389678,
			 53.997699, 44.932022, 86.849388, 68.221122, 55.115776, 70.549491, 77.233207, 72.082382, 57.231647, 63.010963, 88.912338,110.713333, 57.905010, 56.001365, 56.078155, 59.370513,
			105.374557, 46.045402, 72.291053, 49.396404,134.646057, 68.418807, 95.755775,105.342376, 43.074844, 64.603096,114.098533, 54.376094, 53.542224, 82.310066, 67.826339, 67.826339,
			 60.325698, 47.958766, 34.089939, 60.325698, 57.033287,101.068237, 64.318634, 62.036949, 54.178367, 59.868789, 34.089939, 48.794387,  0.000000, 76.419326, 63.840431, 61.603569,
			 60.116268, 30.485593, 31.408227, 32.850151, 31.062835, 73.863006, 31.408227, 32.850151,105.342376, 95.755775, 71.714065, 70.026245, 52.313850, 52.313850, 54.990966, 54.990966,
			 43.649120, 41.946212, 46.086624, 62.027912, 41.465667, 48.420478, 43.649120, 48.420478, 72.291053,114.098533, 64.603096, 46.525856,134.646057, 53.997699, 54.376094, 81.389678,
			 49.396404, 35.637119, 78.756668, 36.968654, 47.909065, 49.249237, 52.474460, 57.854160, 52.474460, 28.266267, 57.854160, 47.909065, 49.249237, 33.177082, 66.578765, 58.056076,
			  3.242480, 66.578765, 63.010963, 59.767757, 41.528083, 68.355529, 41.985279, 35.947650, 67.033592, 41.985279, 41.528083, 27.733070, 30.668689, 48.414596, 68.418807, 24.957973,
			100.431137, 73.587699,100.431137, 81.837654, 73.587699, 81.263175, 22.337799, 88.912338,110.713333, 72.082382, 79.967903, 79.967903, 94.808448, 57.905010, 67.667358, 73.070732,
			 27.230674, 26.039115, 22.340343, 32.117195, 15.077307,132.081954, 94.808448, 77.233207, 70.549491,111.598182,117.285911, 83.547348, 79.583694, 83.547348, 57.231647, 48.794387,
			 73.493980, 62.968238, 70.500526, 24.249895, 73.493980, 62.968238, 70.500526, 54.429706, 44.015594, 61.605461, 69.298599, 20.305143, 12.085442, 19.309917, 15.998438, 19.144134,
			 30.703073, 15.998438, 50.358299, 56.001365, 46.045402, 44.932022, 82.310066, 86.849388, 68.221122, 55.115776, 76.506492, 64.318634,101.068237, 62.036949, 53.542224, 62.027912,
			 57.033287, 61.603569, 47.958766, 59.868789,105.374557, 59.370513, 56.078155,104.710083,101.792236,103.361572, 79.167839, 79.167839,101.792236,104.710083, 31.062835, 41.946212,
			 43.074844, 52.349357, 52.349357, 73.531433, 87.729385,114.559577, 88.793075, 89.264862,114.559577,115.344604, 88.793075,121.676193, 61.928756, 95.949684, 95.949684, 61.928756,
			121.676193, 22.456792, 28.292299, 28.292299, 75.409820,  3.563416, 93.211578, 37.831157, 43.241455, 55.425121, 42.547908, 42.547908, 22.248615, 11.910928,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 82.758354,
			121.780639,  4.654120, 71.851493,104.335174, 74.052970, 87.704124,121.780639, 73.600830, 76.222343,153.571350, 36.314147, 43.296272, 72.797943, 60.833255, 60.778606, 82.245513,
			141.343124, 56.575885,181.051116,182.037887,120.005218,134.636123,204.621261, 90.555465, 50.994461, 60.833255, 60.778606, 82.245513, 56.575885, 90.555465,181.051116,173.515182,
			120.005218, 99.718902,104.539237, 88.493186, 88.468757, 88.468757, 99.718902,104.539237, 88.493186,112.508865,149.340774, 40.067295, 59.226947, 47.007465, 66.034820,204.621261,
			 74.085060, 96.161582, 96.811233,108.235298, 92.803649, 66.934608,153.571350, 59.900852, 26.275320, 20.817749, 13.877944, 25.379123, 42.294261, 30.585664, 54.960025, 82.758354,
			 29.839399, 34.228191, 33.447235, 38.535354, 36.174030, 36.173599, 54.372123, 38.535354, 29.839399, 34.228191, 33.447235,104.335174, 36.174030, 36.173599, 54.372123, 54.081180,
			133.697143,105.589805, 34.383823, 78.522880, 82.523139, 83.946853, 74.090820, 68.672531, 92.379676, 82.586540, 88.704833, 61.038124,106.299377,184.244094, 15.969509, 28.768104,
			 28.811685, 30.763595, 14.598749,  5.637718,  8.864510, 10.765577, 67.083854, 71.407089, 52.686576, 48.889282, 26.696866, 73.771308, 19.947406, 37.313869, 63.158390, 22.333927,
			 13.072918, 37.345283, 59.503864, 71.285705, 10.038041, 52.633827, 65.389869, 52.628864, 59.297554,110.704544, 11.891397,112.508865,137.258422,149.340774, 76.037483, 61.027481,
			137.258422,101.431365, 63.586338, 87.704124,108.184974, 95.592475, 95.592475, 80.466911, 83.946853, 74.090820, 68.672531, 92.379676, 82.586540, 82.523139, 71.285705,134.636123,
			 76.037483, 54.470214, 34.948505,134.408203, 89.816940, 70.038558, 87.715316, 54.171028, 47.420074, 36.951122, 55.637943, 27.638111, 33.500278, 27.638111, 74.800071, 23.680471,
			 55.583259, 11.771276, 66.335289, 58.443359, 58.308731, 68.904571, 58.053459, 60.760562, 85.172744, 16.444837,110.001571, 52.499465,121.711105, 17.888736, 33.931987,102.437927,
			 10.713463,131.635757, 85.609062,102.953674,192.449264,177.651702,208.512908,191.774093,220.357131,194.978912,139.034118,179.197555, 41.888710, 87.325675,141.236083, 80.626945,
			140.357208, 50.988990,131.635757,102.953674,179.197555,191.774093,208.512908,177.651702, 92.144004,139.034118, 85.609062, 87.325675, 92.144004, 85.592170, 85.592170, 98.623184,
			 17.953926, 15.764268,101.431365,115.395179, 84.543380, 99.524795, 84.519493, 84.828552, 84.473388, 89.981986, 80.476943, 61.108959,156.263412,123.754989, 80.206695, 56.101238,
			 54.276054, 55.024940,  5.463561,  6.152684, 18.226427,  6.223878, 57.653480, 80.376121, 10.992885, 52.727298,114.057067,160.073211,140.952941,151.184127, 43.303153, 42.654178,
			 56.812503, 43.293258,141.343124,220.357131,194.978912,105.589805,106.299377,133.697143,160.073211, 63.158390,182.037887, 76.222343, 80.626945, 59.226947, 34.383823, 80.626098,
			 80.466911,134.408203, 73.600830, 54.470214, 72.525543,140.357208, 50.988990, 34.948505, 67.083854, 41.888710,195.865737, 14.598749, 30.763595, 43.296272, 52.499465, 72.797943,
			 89.455734,121.711105, 50.994461, 71.851493, 98.120857, 89.816940,151.184127,140.952941, 27.638111, 27.638111, 33.500278, 74.052970, 55.583259, 36.314147, 78.522880, 57.653480,
			114.057067, 59.204597, 47.007465, 66.034820, 30.585664, 26.275320, 25.379123, 20.817749, 43.998298, 40.067295, 62.649291, 13.877944, 59.900852, 54.960025, 16.444837, 58.443359,
			192.449264, 43.303153, 56.812503, 11.771276, 39.411399, 37.345283, 73.771308, 54.171028, 61.027481, 74.085060, 96.161582, 96.811233, 66.934608,108.235298, 98.623184, 98.623184,
			 72.525543, 56.385845, 56.385845, 23.442962, 23.442962, 23.442962, 23.442962, 24.371702, 81.429908, 74.800071, 81.429908, 24.371702, 69.048782, 76.411758, 70.284973, 45.757625,
			 45.757625,140.135406,140.235626,173.515182, 57.231887, 24.485076,101.768455, 88.824241,122.666213, 62.699405, 56.644519, 42.294261, 23.355562, 45.521526,110.704544, 17.888736,
			 54.276054,195.865737, 89.455734, 55.024940, 98.623184,130.378402, 60.939563, 42.044506, 43.539768, 92.803649,108.208320, 32.146728,  6.577101,131.417388, 12.716139, 14.291623,
			  5.348771, 74.051185, 54.262390, 54.262390, 29.839399, 29.839399, 40.356403, 40.356403, 56.098930, 56.098930, 98.120857,108.184974, 66.194831, 47.480342,  6.798082,127.992439,
			149.335189,135.491256,141.292770,192.424163,134.663650,150.414489,103.109901,127.992439,149.335189,135.491256,141.292770,192.424163,134.663650,150.414489,103.109901,101.372833,
			101.372833, 83.351493, 83.351493, 14.291623, 97.763725, 56.790538, 56.790538, 82.987792,105.262825, 21.708436, 83.351493, 83.351493, 74.058761, 25.781475,101.372833,101.372833,
			142.953872, 52.633827, 59.297554, 52.628864, 65.389869, 16.409337, 20.852514, 20.852514, 14.840601, 11.152612, 11.152612, 54.081180,140.625854,184.244094,  6.371963, 43.418521,
			 55.699317, 70.312026, 64.131851, 71.444961, 90.338127,  8.928997,  8.741058,  8.772462, 61.554779, 22.694437, 23.233196, 22.685501, 34.557170,  8.734198,  8.719891,  5.931972,
			  5.935850,  3.627347, 97.763725, 45.080139, 45.080139, 23.694993, 23.694993, 14.614936, 91.894729, 75.761589, 91.894729, 75.761589,110.822395,110.822395, 39.457607, 44.425220,
			 44.425220, 39.457607, 10.765577, 20.892408, 23.767835, 61.483089, 28.757102, 55.934680, 80.626098, 41.230297, 41.230297,141.236083, 28.757102, 55.934680, 13.224430, 28.768104,
			 72.333396, 72.333396, 72.333343, 72.333343, 70.038558, 48.889282, 52.686576, 71.407089,110.001571, 85.745765, 85.745765, 86.984252, 86.984252,130.814682,130.814682,171.883621,
			171.883621, 59.279720, 69.387077, 69.387077, 83.476966, 83.476966, 73.771308, 89.159950, 98.298324,114.040565, 82.026428, 68.605415, 89.159950, 68.605415, 82.026428,114.040565,
			 98.298324, 81.817382, 76.008827, 66.140304, 82.354270, 71.407470, 21.708436, 70.710845, 70.710845, 37.313869, 59.204597, 43.998298, 16.409337, 62.649291,  7.702395,  7.581212,
			 13.224430,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 10.660081, 70.710723,151.737777, 93.328903, 78.602897, 67.082366, 56.569042, 92.261314, 66.369918,
			130.424835, 39.018520, 90.012443,102.980377, 83.230155, 98.997039, 85.464576, 63.249309, 99.999534,126.980484, 70.710685,114.013687, 79.982086,111.588027,106.011985,106.000823,
			168.716400,176.828201,134.130142,204.069839, 78.103744, 60.828449,108.787757,114.829261,187.550689,199.505477,187.447067,161.104629,121.218475,162.403778,163.986694,198.274734,
			177.644912,149.249969,154.520568,195.020141,167.421463, 95.355354,152.542907,197.359573,129.460784,134.574874,174.110839,200.000122, 72.111061,183.926239,156.237686,159.453689,
			170.736602,162.604568,114.017539,199.203765,145.287414,158.952514, 94.561515, 82.462295,136.017517, 82.795814, 85.204780,111.804496, 72.808242, 53.852050,121.920578, 78.602897,
			 63.323593, 65.067390, 46.106529, 92.121055, 66.562309, 60.196331, 33.500228, 33.500286, 24.063673,102.291915,131.280105,120.477439, 50.289825, 80.193367, 74.195175,118.210884,
			 47.234767, 79.450462, 76.255233, 53.413227, 22.664829, 50.702762, 40.234100, 91.801239, 59.479885, 70.169563,135.036834, 31.533878, 21.586950,109.988754,114.363868,116.621154,
			 29.914178, 52.716136, 16.438203, 84.995346,109.810089, 64.546440, 65.517204, 31.533878, 79.908363, 47.119640,149.416412, 77.920570, 72.801277, 27.285150, 27.284984, 44.940891,
			122.595413,105.734367, 43.404510, 44.806545, 44.549415, 64.872451, 43.258956, 32.526790, 92.923690, 53.380168, 92.195770, 82.939376, 70.781105, 70.796791, 84.087280, 82.471076,
			 53.875720,128.580001, 50.565189,101.734214, 71.783195,146.708831,102.955818, 78.102966, 62.381477, 32.447280, 53.763874, 57.177352, 95.158004, 89.317375, 71.965705, 71.228134,
			 87.793548, 65.581398, 21.742416, 99.001113, 90.865394, 80.831962, 65.758064, 63.928398, 95.478004, 28.586986,113.255783, 81.545944,110.039276, 75.475334, 72.208747, 64.602767,
			105.726745,149.966949, 20.676095, 81.559394, 51.277614, 78.969673, 70.844100,131.997604, 46.472930, 91.969657,149.966949, 28.638801, 49.988407,  9.688000, 32.738109, 37.765518,
			 44.722209, 54.331680, 49.999343, 63.431625, 49.999675, 42.114490,  9.713959, 43.620498, 32.738109, 53.330978, 27.705997, 71.707717, 82.628929, 60.193805, 64.987091, 60.018692,
			 96.862480, 19.017017, 85.300735, 37.298233, 23.694997, 31.533935, 31.533880, 69.340736, 77.497726,111.785820,114.887733,109.997726, 81.049682,122.314643, 72.368515, 62.202671,
			 67.095695, 99.996925, 78.102325, 73.870429, 50.220321, 40.181461, 85.477706, 98.493995, 84.473388, 86.195899, 81.374198,115.705513,116.754035, 60.166732,114.092369, 79.481521,
			 51.497650, 56.377075, 52.501575,159.487884, 27.288494, 38.629947, 38.731498, 19.300756, 38.731540, 10.184518, 39.666561, 19.301967, 64.056022, 66.293113, 24.148370, 55.718955,
			 59.574180, 50.972282,  3.168497, 31.533935,101.734214, 33.500228, 66.562309,102.291915,109.997726, 60.196331, 23.694997, 31.533880, 31.533878, 21.586950, 31.533878, 32.447280,
			135.036834, 48.721633, 33.500286, 24.063673, 38.259048, 46.106529, 50.702762, 52.716136, 72.801277, 51.047271, 29.914178, 16.438203, 60.523509, 70.169563, 50.565189, 64.546440,
			 87.503417, 87.503417,149.416412,159.487884, 52.501575, 44.157268,130.424835, 92.121055, 79.908363, 63.323593, 39.666561,  2.500175,  8.126962,  2.500175, 22.664829, 47.119640,
			 90.012443, 76.255233, 53.413227, 65.067390,105.726745, 49.988407, 37.765518, 65.517204, 77.920570, 64.056022, 72.368515, 66.293113, 50.220321, 73.870429,151.737777, 70.710723,
			 96.862480, 61.178432, 72.808288, 88.414115, 92.195770,102.980377, 83.230155, 98.997039, 85.464576, 63.249309, 99.999534, 42.114490,126.980484, 70.710685,102.955818, 78.102966,
			 62.202671, 67.095695,114.013687, 53.380168, 82.939376, 53.875720, 82.471076, 84.087280, 92.923690, 70.796791,111.588027, 92.237983,106.011985,106.000823,168.716400,176.828201,
			134.130142, 60.828449,108.787757,114.829261, 99.996925,145.287414,158.952514, 94.561515, 82.462295,136.017517, 82.795814, 85.204780,111.804496, 72.808242, 70.781105, 78.102325,
			 53.852050,122.314643,110.039276, 61.178432, 72.808288, 88.414115,129.460784,162.403778,163.986694,198.274734,177.644912,149.249969,154.520568,195.020141,167.421463, 95.355354,
			152.542907,197.359573,121.218475,134.574874,174.110839,200.000122,183.926239,156.237686,159.453689,170.736602,162.604568,114.017539,199.203765, 92.261314, 44.722209, 63.431625,
			 49.999675, 56.569042, 49.999343, 54.331680, 67.082366,199.505477,187.447067,161.104629,146.708831,187.550689, 27.285150, 27.284984, 44.940891,122.595413,105.734367, 81.559394,
			128.580001, 81.545944, 75.475334, 51.277614, 46.472930, 78.969673,131.997604, 91.969657, 44.727645, 23.694997, 23.694997, 31.533878, 31.533878, 60.617862, 54.399349, 45.619579,
			 42.697257, 38.366359, 61.272396,139.582702, 80.193367, 50.289825, 74.195175,120.477439,118.210884, 65.788200, 65.788200, 60.830722, 60.830722, 60.838443, 60.838443, 60.828025,
			 92.237983, 91.801239, 79.982086,204.069839, 24.063703, 24.063703, 32.412883,111.845542, 78.219436, 67.081344, 89.443969, 78.104316,111.810478,121.920578,111.810478, 78.104316,
			 89.443969, 78.103744, 67.081344, 78.219436,111.845542, 40.234100,142.658706,142.693679,182.986618, 60.828025,210.286407,210.286407, 72.891990, 48.308486, 48.308486,182.986618,
			 72.111061,132.399993,132.399993,  4.277705,148.650238,  5.722126,  5.722126, 71.707717, 60.018692, 64.987091, 60.193805, 82.628929,  9.084973,  9.084973,  9.095958,  9.095899,
			  9.015380,  9.015374,  9.084991,  9.084977,  9.084980,  9.085025,  9.085025,  9.085025,  9.085009,  9.085021,  9.085041,  9.087951, 27.229925, 35.129352, 67.512710, 44.282493,
			 33.693828,  2.990452,  2.515981, 14.904350, 22.304887, 23.246831, 29.794586,  2.935831, 28.732772, 28.732772,  4.826958,  2.935949, 26.956993,  5.722168, 11.489015, 48.721633,
			 26.956993, 45.475833, 45.475833, 51.046791, 29.884080, 29.884080, 98.263374, 23.799655, 23.600078, 53.204334, 53.204334, 72.333396, 72.333396, 72.333396, 72.333396, 72.193443,
			 40.500930, 58.633480, 49.806442,  6.894646, 33.767559,103.029518, 64.602767, 44.806545,109.810089, 60.523509,114.363868, 70.508293, 70.508293, 57.829414, 57.829414, 81.385070,
			 81.385070, 54.828975, 54.828975, 51.047271, 44.157268, 38.259048,  0.000000,  0.000000,  0.000000,  0.000000, 71.770248, 14.088780, 20.417087, 15.053573, 32.562263,107.261848,
			 69.139373, 46.378471, 48.049285, 98.488883, 60.978767,108.142982, 80.627716, 92.694763, 60.855739, 88.424240, 98.570175,106.572097,157.880218,149.666931,127.268028,157.554199,
			188.177749,147.693527,187.338394,156.174392,158.567749,143.481979,178.858322,181.965133,133.030349, 72.131278,100.491714, 36.056106, 92.196929, 82.462966,108.142982, 80.627716,
			 82.463905, 82.463378,111.804115,101.981163, 63.246833, 60.867713, 60.855739, 88.424240, 83.421760, 83.421607,102.005317, 82.528816,117.760276,106.572097, 72.131278, 36.452117,
			 44.721832,128.744140, 35.778476, 76.169853, 86.027305, 78.090133, 51.934532, 89.962814, 58.424823, 14.355449, 12.298159, 52.456562, 72.280715, 36.056106,101.981163, 82.462966,
			 63.246833,102.005317, 92.196929, 44.721832, 82.463378, 82.463905,111.804115, 82.528816,117.760276, 33.500247, 36.407485, 25.988115, 36.424987, 36.251739, 36.870849, 27.638050,
			 25.988119, 52.258941, 45.137496, 46.876113, 27.202653, 27.638051, 70.715400,150.209808,167.867004, 22.183170, 67.098114, 18.995828, 14.658996, 13.357821, 14.659001, 57.236309,
			 83.349945,121.914787,114.441764, 31.048389,107.524597, 44.108963, 69.352149,110.102790, 92.694763, 60.978767,100.491714,171.323852,156.174392,147.693527, 83.200103,127.268028,
			 83.349945,143.481979,157.554199,157.880218, 89.962814,171.323852, 86.027305, 78.090133, 58.424823, 95.836013,150.209808,107.261848, 71.770248, 98.488883, 57.236309, 52.456562,
			 76.169853, 84.314620, 14.659001, 13.357821, 45.137496, 46.876113, 52.258941, 22.183170, 27.638050, 18.995828, 25.988119, 14.658996, 69.139373, 51.934532, 35.778476, 26.224245,
			122.307838,122.307838, 43.786380, 11.500273,  5.680426, 70.327560,132.526763,106.694671, 59.918960, 70.712371, 59.918960,132.526763,106.694671, 70.715400,187.338394,167.867004,
			 70.327560, 43.786380, 11.500273, 73.274253, 81.284202, 75.442832, 63.240535, 71.755867,109.999717, 56.086662, 69.521194, 48.276084, 36.424987, 36.407485, 36.251739, 84.314506,
			 27.638051,158.567749, 33.500247, 67.098114,188.177749, 45.875930, 25.988115,  3.932852,  4.805656,  4.126420,  4.805656, 71.996231, 83.200103, 95.121887, 60.045734, 80.219398,
			 47.320659, 56.401771, 54.542739, 95.121887, 80.219398, 54.542739, 47.320659, 56.401771, 60.045734, 90.949516, 92.212799, 58.526077, 90.249420,120.415382, 90.949516, 92.212799,
			 58.526077,120.415382, 59.582443, 59.582443, 90.249420, 70.712371,152.718078,143.614334,120.433753,104.295631,149.543106,149.543106,143.614334,120.433753, 41.868614, 81.468971,
			 81.455451, 50.065673, 28.279441,178.858322, 94.520462,166.879959, 93.946670,134.130096,124.559127, 66.289939,102.475723, 84.255470, 94.520462,102.475723, 84.255470, 66.289939,
			166.879959, 93.946670,134.130096,124.559127,150.043685, 13.246662, 18.370111, 10.334648,113.220077,113.220077,150.043685, 18.370111,134.552902,  8.849154,134.552902,104.295631,
			 76.575927, 76.575927, 42.565887, 42.565887, 83.421760, 83.421607, 36.452117, 25.640348, 25.640226, 25.640226, 25.640348, 26.224245, 26.224399, 26.224399, 84.314620, 84.314506,
			 90.563102, 90.563102, 46.378471, 36.870849, 28.404449, 28.404449, 80.034172, 60.210163,143.232192,143.232192, 45.875930, 60.210163, 71.755867, 50.065673, 80.034172, 73.274253,
			 28.279441, 81.284202, 75.442832, 63.240535, 48.276084, 56.086662,109.999717, 69.521194, 94.740379,128.512557,128.512557,103.049827,103.049827, 75.066658, 67.953041, 60.737339,
			144.943893,144.943893, 79.139923, 79.139923,  9.222474,  9.319673, 25.350404,181.965133,133.030349, 98.570175,152.718078, 20.416803, 31.691120, 31.691120,  6.520801, 27.202653,
			 93.305847, 93.305847,119.807807,119.807807, 63.151618, 63.151618,  9.218264, 25.033710, 25.033710, 14.237727, 14.634025, 29.764816, 14.237727, 14.634025, 29.764816, 18.875150,
			 28.354045, 23.068700, 18.492353, 18.513631,  8.976623,  7.577644,  7.577642,  9.169657,  8.952379,  9.289907,  8.828380, 18.490449,  8.944534, 94.740379, 14.658996, 14.658996,
			 21.874553, 21.874553, 21.874553, 21.874553, 21.874553, 21.874553, 60.434097, 65.387023, 78.492424, 32.537414,128.744140,166.389129, 86.041007, 71.995803,166.499038,166.389129,
			153.111953,130.407699, 86.041007, 71.995803, 95.836013,108.280181,166.499038,153.111953,108.280181, 71.996231,149.666931, 65.387023, 78.492424,130.407699, 60.434097,103.545402,
			103.545402, 55.468158, 72.271934, 72.271934, 88.629776, 56.266937, 56.266937, 20.416803, 20.417087, 60.867713, 35.132148, 35.132148,104.996208,104.996208, 63.178512, 52.151973,
			 63.178512, 52.151973, 61.519287, 61.416950, 87.530082, 87.946563,112.965072, 66.594551, 75.603523, 79.324066, 16.734317,103.886924, 54.959259, 35.564334, 68.965270, 20.279850,
			 16.471891, 41.766239, 35.921337, 29.206230, 40.927078, 59.029567, 14.571269,  2.060286,  9.012395, 46.281986, 17.469539, 75.935714,  5.356341, 75.935714, 35.564334, 46.281986,
			 28.831476, 28.777193, 30.327171, 56.966651, 56.571350, 56.205093, 81.513473,  8.171345, 23.960817, 23.283655, 20.191045, 23.283653, 23.283655, 20.191045, 20.191045, 40.761386,
			 51.420715,122.791625, 44.801456, 30.351400, 30.351396, 21.144142,107.709259,107.705390, 51.678474, 88.071807,136.013854, 72.804161,113.137527, 43.662910,111.028366,114.024131,
			 78.100341,100.511566, 85.767562,106.269676,110.148117, 84.848655,102.959686, 85.672866, 93.862854, 88.423767, 94.872001,121.198417,159.161987,131.039520,194.203094,131.674575,
			120.440757,193.051727,181.708541, 90.534843,103.085708,167.149368,194.439041,121.755783,130.006088, 72.130378, 78.111091, 70.713150, 51.021331, 94.871467, 43.662910, 85.767562,
			 97.708259,219.854583,104.072090, 16.486230, 30.159933,127.559890,160.262405, 28.669054,128.269638,108.375106,101.220291, 16.477087,  9.266006, 46.954524, 35.679943, 46.823093,
			 45.276702,144.632644,100.659538, 89.192153, 99.005424, 33.395526, 51.143512, 29.000864, 44.565647, 46.683597, 46.699489, 12.740953, 13.644301, 34.646858,120.419395,145.607894,
			 98.266250, 82.565841,120.834869,168.240432, 51.417213,117.038131, 63.296718, 90.618263, 82.465339, 97.526855,119.207565, 92.245498, 82.546890, 82.494506,  5.426208, 27.711389,
			 31.772394, 84.176399,  5.425916, 69.796470,100.014320, 50.003639, 57.736419, 27.330520,  7.880681,  7.880036, 99.766456, 82.848999, 50.359169, 70.220329, 70.220108,113.142143,
			 46.104167, 37.818977, 25.988136,111.830482,  1.296748,111.836257, 13.460650,  5.482485, 89.480209, 36.070457, 51.172313, 65.291435, 16.439399, 22.298761, 22.298826,109.812019,
			 50.962387,135.927673,107.708824,  5.480930, 50.727794, 38.924007, 34.715469, 34.221286, 35.142360, 15.573170, 36.155525, 28.114395,  3.956676, 16.671379, 17.813005, 56.895412,
			  7.758985, 95.347816, 34.043895,  9.956564, 19.016643, 27.592140,143.049514,184.117706,178.156112,186.138977, 87.759338, 31.669795, 11.428487, 25.755979, 44.986042, 25.616710,
			 16.391098,250.964797,223.143081, 39.459381,219.150131, 17.434371, 94.872001,102.959686,121.755783,114.024131, 94.871467, 84.848655,113.142143,111.028366,110.148117, 26.393903,
			119.621406,100.781158,101.121131,101.135940,121.562263,  8.270616,  5.482540,  5.414083, 58.020401, 26.850322, 14.585335, 28.227325, 24.677751, 13.530499, 85.458343,  6.103785,
			 30.508405, 36.845012, 31.414077, 25.529520, 28.040800, 44.047805, 45.616607, 38.438323, 51.198890, 35.730075, 34.061218, 30.873821,139.844085, 79.485466,110.453659, 93.253402,
			 18.204055, 16.030712, 21.388212, 31.497798,  7.948763, 15.548073, 15.554515, 15.559704, 15.713742, 15.553795, 15.296525, 14.955725, 15.587740, 15.836399, 75.581054,102.715599,
			 15.327866, 15.559312, 15.067804, 15.067470, 10.019214, 22.373607, 50.017318,122.560729,102.598068, 21.388212, 21.388214, 21.388214, 85.167663, 16.030712, 18.204055, 70.170158,
			109.969749, 10.336711,  5.391838, 18.622259,  4.507337,202.967559, 60.000045, 43.427986, 77.967277, 40.125812, 45.002330, 45.002330, 49.325744, 36.098789, 49.946029, 27.823110,
			 22.449594, 31.980535, 97.708259,104.072090, 56.205093, 81.513473, 34.706779,112.965072, 66.594551, 79.324066, 75.603523,127.559890,108.375106,103.886924,128.269638,101.220291,
			122.560729,100.659538, 66.354034, 24.677751, 54.959259, 65.291435, 73.889213, 73.889213, 56.966651, 40.761386, 27.592140, 35.142360, 34.221286, 15.573170, 27.823110, 22.449594,
			 21.144142, 25.616710, 36.155525, 38.924007, 34.715469, 28.114395, 31.497798, 30.351400, 18.622259, 51.420715,143.049514,184.117706,178.156112,186.138977, 93.253402, 85.167663,
			122.791625, 25.988136, 37.818977, 46.104167, 34.043895, 56.895412,111.830482, 95.347816,193.051727,181.708541,194.439041,167.149368,144.632644,160.262405,161.131256, 75.581054,
			202.967559, 90.534843,168.240432,102.598068,159.161987,194.203094, 93.862854, 98.266250,120.419395,145.607894,102.715599, 89.480209, 36.070457,131.674575,131.039520,121.198417,
			109.969749, 70.170158,107.709259,100.014320, 79.485466, 58.379825, 84.176399, 69.796470,120.834869, 60.000045, 68.965270,121.562263, 85.458343, 30.159933, 16.486230,135.927673,
			107.708824, 70.220108, 11.428487, 70.220329, 31.669795, 87.759338, 82.848999, 50.359169, 99.766456, 30.508405, 36.845012, 30.873821, 44.047805, 31.414077, 45.616607, 28.040800,
			 38.438323, 51.198890, 35.730075, 50.727794, 51.172313, 40.927078, 35.921337, 28.979103, 23.283655, 20.279850, 16.471891, 30.327171, 28.777193, 59.029567, 46.823093, 45.276702,
			 35.679943, 50.003639, 44.801456, 29.000864, 82.565841, 13.644301, 12.740953, 16.734317, 82.570014, 96.909027, 77.577674, 67.211769,111.559677, 82.465339, 97.526855,159.527023,
			 42.060367, 40.182876, 85.759071, 57.643787, 15.231102, 23.823690, 18.799011, 95.233345, 76.734863, 25.889122, 62.179893,  8.829751,132.021591, 92.748756, 78.478317,132.021591,
			 92.748756, 21.328281, 32.998111, 11.222216, 78.664978, 11.222308, 11.222308, 11.222216, 11.222290,179.508132, 65.736801,185.289505, 42.145023,185.289505,179.508132, 42.145023,
			 65.736801, 11.222308, 11.222308, 96.848472, 42.572509, 86.693740, 54.024600, 90.725479, 33.318740,  6.509981,  8.028307,  6.509988,  7.891541,  6.509984,  8.290461,  6.509990,
			  7.891541, 66.354034, 63.994258, 23.542554, 14.764088,  7.731547,  7.731603, 13.798501, 13.878550, 78.393028, 23.960817, 27.711389, 31.772394, 16.439399, 85.672866, 88.071807,
			 63.296718, 90.618263,117.038131,119.207565, 92.245498, 82.546890, 82.494506, 82.570014, 88.423767, 51.021331, 78.100341,100.511566,113.137527,136.013854,107.705390,110.453659,
			130.006088, 72.130378, 72.804161, 70.713150, 78.111091,101.135940,101.121131,100.781158, 51.678474, 51.417213, 30.351396, 99.005424, 63.994258, 34.646858, 44.565647, 46.683597,
			 46.699489, 89.192153, 62.179893, 95.233345, 90.557022, 90.557022, 31.980535, 29.206230, 28.979103, 23.283653, 23.283655, 41.766239, 30.873821, 30.873821, 21.288312, 21.288312,
			 21.288312, 18.204055, 18.204055, 20.069862,  4.093640, 75.045410, 96.848472, 54.024600, 86.693740, 90.725479, 40.121868,  8.780856, 40.121868,  4.635282, 20.069862, 28.560440,
			 14.764088,  7.731547,  7.731603, 23.542554, 21.328281, 32.998111, 13.460650, 34.061218, 25.529520,229.887008, 27.330520, 14.585335,103.085708,106.269676, 58.020401, 57.736419,
			 12.288454, 46.954524,  8.171345, 27.721000, 27.721017, 32.410900, 67.882034,124.668144, 15.548073, 15.713742, 15.553795, 15.554515, 15.559704, 21.537601,  7.240951,  7.240951,
			 15.587740, 15.296525, 15.836399, 14.955725, 15.327866, 15.559312, 15.067470, 15.067804, 60.834877, 60.828445, 60.845722, 60.839332, 60.880531, 60.832656, 60.834247, 61.058757,
			 60.851879, 60.834877, 60.828445, 60.845722, 60.839332, 60.880531, 60.832656, 60.834247, 61.058757, 60.851879,124.668144, 12.521980, 44.022766, 99.590332, 99.609863, 88.430824,
			 88.425521, 99.769081, 99.669151, 88.401695, 88.344619, 60.008174, 80.419395, 50.507831, 72.351913, 35.199222, 52.787025, 26.829225, 76.277938,121.259757,121.259757, 49.177455,
			 49.177455, 62.752586,115.269615,169.757598, 29.669719, 36.708675, 44.272495, 26.907272, 29.669719, 36.708675, 44.272495, 26.907272, 27.410324, 27.410324, 51.938652, 67.084030,
			 79.791145, 79.979347, 51.938652, 67.084030, 79.791145, 79.979347, 58.379825, 56.571350, 79.840003, 71.498558, 69.787887, 69.787887, 71.498558, 79.840003, 36.382923, 31.740743,
			 34.706779, 31.740743, 36.382923, 33.395526, 33.188514, 33.188514, 39.123947, 39.123947, 48.096740, 48.096740, 75.045410, 52.330352, 52.330352, 42.572509, 45.871978, 21.476341,
			 70.394866,142.132141, 97.267799, 97.267799, 50.017318,  4.092648, 89.824996, 89.824996, 89.824996, 89.824996, 28.560440,  2.935827,  5.318994,  5.318994,  5.318994,  5.318994,
			103.886924,103.886924, 48.813663, 42.060367, 35.035217, 72.247772, 50.405128, 80.216255, 59.879611, 58.538917, 12.288454,121.572685,101.122535,101.121459,101.121528, 51.539421,
			 90.544876,108.774765, 96.723983, 26.892293,136.904403, 30.716190, 10.075638, 23.233713,120.704414,  9.388563, 48.813663,  1.256415, 22.438732, 22.438732,169.757598,221.353836,
			231.166290,132.734573,124.431358,131.507537,121.370132,221.353836,231.166290,132.734573,124.431358,131.507537,121.370132, 76.277938,101.121459,101.121528,107.476165,107.476165,
			  7.330237, 19.208621, 87.498489, 51.539421,101.122535,120.440757,115.269615, 28.805612, 90.544876,121.572685, 28.979103, 28.979103, 30.873821, 30.873821, 21.288312, 21.288312,
			 21.288312, 60.112098, 60.112098, 60.112205, 60.112205,161.131256,159.527023, 82.037216, 88.401695, 99.769081, 99.669151, 88.344619, 88.430824, 99.590332, 99.609863, 88.425521,
			  9.095888,  9.095888,  9.095888,  9.095888,  9.084980,  9.095889,  9.084994,  9.084984,  7.963483,  7.963333,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 87.583618,161.482604,162.733581,128.223739, 82.803115,125.659530,133.931884,172.183593,163.035614,154.393295,100.328216,
			111.474555,130.038757,167.381866,140.661102, 19.514297, 13.875609, 61.102272, 78.411216, 60.202838,100.156974, 80.607330,  7.783969,  8.600369, 83.598258, 77.943519, 90.155258,
			 73.290092, 92.615486, 48.503326,141.686752, 38.235095,  8.843807,  6.903793, 87.668586, 68.299545, 22.823209, 61.934059, 26.945016, 15.144636, 21.573648, 30.006204, 11.813076,
			 42.865165,105.676948, 88.565200,103.593421,105.961585, 88.692626, 33.319961, 27.314697, 43.732501, 83.051948, 11.647516, 16.799758, 29.055311, 67.862434, 87.635978, 85.682258,
			121.388183,146.555557, 99.723381, 73.140182,  0.000000, 27.957866, 16.573232, 13.194086, 13.145692, 13.194567, 13.194554, 13.100714, 96.939735, 27.781473, 55.753345, 59.835788,
			 67.360900, 59.016899, 61.225135, 59.419471,236.227508,265.446380,248.032684,234.965362,266.422851,243.833724,203.954162,234.859649, 47.312744, 40.973964, 69.055870,118.970947,
			 56.171905,110.417800,121.720321, 42.271820, 44.070224, 23.263286, 22.624168, 14.509886, 35.419979,  4.743371, 42.293060, 14.116379,  5.493673, 13.599729, 14.712162, 21.301265,
			 23.462512, 25.295146,  3.789455, 36.741100, 17.897314, 27.863422, 50.911376, 13.194298, 16.252172,  4.897778, 13.193917,  8.064448, 16.422359, 12.510295, 11.859847,  7.762279,
			  8.611403,115.209861, 60.216236, 39.088745, 46.069976, 17.532793, 36.659801, 35.179302, 30.241447, 43.597728, 41.727931, 13.082416, 17.920673, 28.709474, 57.309867, 15.755623,
			 21.735357,  9.443845, 21.182836, 31.365592, 65.468490, 19.028024, 38.993400,  6.958255,188.728805, 23.841579, 88.565200,103.593421, 92.615486,105.961585, 87.583618, 73.290092,
			 61.102272,  5.990349,  4.441109, 90.155258, 33.319961, 83.051948, 77.943519,115.209861, 88.692626, 83.598258, 44.070224, 22.624168, 14.509886, 23.263286, 42.271820, 36.741100,
			 35.419979,  9.443845, 26.945016, 15.144636, 29.055311, 21.573648, 11.813076, 22.823209,  5.990349, 12.510295, 16.252172, 13.875609, 19.514297, 28.709474, 12.093035, 11.647516,
			 27.314697, 43.732501, 60.202838, 23.462512, 25.295146, 48.503326, 42.293060, 41.727931, 67.862434, 61.934059, 38.235095, 30.006204, 68.839996, 87.867179, 78.411216, 23.841579,
			 42.865165,100.156974, 13.193917, 13.194298, 16.422359, 11.859847,  6.903793,  7.783969,  7.762279,  8.611403,  8.600369,  8.064448, 16.573232,  6.958255, 16.799758, 13.194554,
			 13.194086, 13.145692, 13.194567, 13.100714, 17.897314, 65.468490, 17.532793, 30.241447, 60.216236, 43.597728, 39.088745, 36.659801,  8.843807,218.715393,206.564743,234.099105,
			206.300613,206.564743,234.099105,206.300613,218.715393,167.381866,128.223739,234.859649,203.954162,130.038757,141.686752,105.676948,140.661102, 96.939735,243.833724,163.035614,
			172.183593,111.474555,266.422851, 82.803115,100.328216,234.965362,265.446380,154.393295,248.032684,125.659530,133.931884,161.482604,162.733581,236.227508, 80.607330, 57.309867,
			 87.635978,146.555557,121.388183, 99.723381, 85.682258, 73.140182, 27.957866,  0.000000,  0.000000,  0.000000, 14.205302, 43.584815, 71.587966, 56.439563,127.689453, 72.015884,
			 71.052246, 65.413345, 99.491271, 96.270881, 74.960975, 58.241561, 37.430839, 64.688385, 30.380624, 38.480987, 34.293575, 30.907669, 39.846359, 48.586711, 55.969264, 66.041618,
			 63.820621, 59.733638, 34.895511, 31.644948, 68.725257, 39.130687, 34.630661, 66.467903, 29.160463, 28.761528, 77.323936, 28.574546, 40.108127, 42.159332, 36.562961, 80.674255,
			 76.809921, 47.473739, 46.623069, 54.054862, 51.522804,  6.381508, 39.325153,  3.870143,  5.826269,108.260070,148.555221,108.260070, 51.522804, 55.617473, 47.139263, 54.054862,
			 61.610057, 53.947971, 37.430839, 77.323936, 64.688385, 30.907669, 34.293575, 30.380624, 38.480987, 46.623069, 47.473739, 61.770702, 69.768753, 36.733802, 50.420032,124.059776,
			138.041610,114.382080, 81.587608,113.281173, 76.506942, 73.677627, 45.903072, 57.228073, 62.031677, 52.884231, 55.093296, 67.746803, 39.140235, 48.143253, 23.997356, 92.299156,
			 88.673164, 86.013351,117.924652, 84.791893, 33.684528, 45.438556, 76.809921, 64.645668, 59.940853, 60.399433, 82.745140, 82.488349, 66.040054, 56.082874, 42.946598, 11.758563,
			 31.418870,115.179832,111.014533, 66.484657, 39.696746, 20.140859, 41.118438, 75.825897, 32.975631,121.125625, 64.065078, 53.947971, 84.641784,123.549346, 48.816997, 61.610057,
			 74.513870, 92.583320,124.737228, 45.987880, 68.017829, 97.816238, 54.043727, 55.898841, 82.544471,125.624214,121.748428, 90.229087, 89.323150,128.042999,113.970733,106.686515,
			107.675170,115.587333, 21.990547,115.179832, 31.418870, 66.484657, 89.323150, 21.834798,  9.089423,  4.726603, 82.488349, 82.745140, 66.040054, 56.082874, 60.399433, 66.041618,
			 55.969264, 48.586711, 63.820621, 97.857215, 58.241561,131.376739, 89.322151, 79.161857, 72.015884,127.689453, 56.439563, 74.513870, 66.555152, 96.270881, 76.508445, 45.987880,
			124.737228, 49.208240, 84.791893, 83.589118, 73.889640, 88.082038, 88.082038, 90.229087,121.748428, 82.544471,106.686515, 84.641784, 55.898841, 54.043727,113.970733, 33.684528,
			 36.562961, 42.159332, 40.108127, 28.574546, 32.148231, 66.467903, 39.130687, 34.630661, 31.644948, 29.160463, 28.761528, 34.895511, 68.725257, 80.674255, 59.940853, 39.846359,
			 76.246139, 76.246139, 51.295825,101.690406, 98.343017, 98.343017,139.718139,125.750000,208.292053,125.750000,139.718139,122.869888,139.382781,122.869888,139.382781,168.765045,
			168.765045, 52.595127, 14.006791, 49.239749, 49.512153, 49.208240, 49.712749, 82.940032, 55.735042, 38.150558,121.831863,101.132133,109.834815, 99.778823, 92.893608,109.783416,
			115.110000, 39.238670,124.360664, 93.998115, 63.660320, 49.641532,123.290451, 91.392265, 79.161857, 89.322151, 73.770393, 73.730468, 94.803924, 76.508445,133.555435, 54.652801,
			 45.694446, 73.326492, 53.748970,126.656578,103.323707, 66.555152, 62.643844, 63.269191,131.376739, 47.864677, 55.617473, 47.139263, 48.636280, 64.630989, 30.040578,113.769477,
			111.694839,145.861145, 96.654937, 83.589118, 89.871788, 42.621265, 50.044643, 48.401107, 43.446262, 39.907009, 47.020778, 42.946598, 30.040578, 64.630989, 88.504302, 45.438556,
			 48.636280,112.196090, 42.102191, 50.403038, 53.640384, 69.768753, 37.520690, 47.152431, 47.864677, 53.640384, 50.403038, 61.770702, 38.150558, 63.660320,109.783416,124.360664,
			 93.998115, 49.641532,123.290451, 91.392265, 71.052246, 73.730468, 65.413345, 73.770393, 75.825897, 82.940032, 45.694446, 73.326492, 94.803924, 54.652801,126.656578,103.323707,
			 53.748970, 55.735042, 74.960975, 49.712749,117.924652, 49.512153, 49.239749, 73.889640,115.110000, 39.238670, 63.269191,121.831863,101.132133, 99.778823, 92.893608, 92.583320,
			 62.643844, 99.491271,109.834815,162.762405, 31.758066,121.125625, 42.549053, 49.976093, 50.566528, 15.487513, 11.377382,  5.773255, 11.612336,  6.047967,  4.174633,  3.354898,
			  9.956135, 31.900640,  9.956135, 29.059295, 29.059295,141.408111, 53.989906, 18.457561, 16.507490,  3.961973, 58.301288, 90.547210, 87.749549,134.756454,134.756454, 90.547210,
			 58.301288, 87.749549,141.408111,148.555221,123.549346,114.382080, 32.975631, 47.020778, 36.733802, 39.907009, 43.446262, 42.102191, 48.401107, 50.044643, 50.420032, 42.621265,
			 48.816997, 89.871788,162.762405, 32.311584, 34.798122,113.319252,101.290077,101.290077,113.319252, 64.645668,101.690406,133.555435, 21.834798, 71.587966, 21.990547,111.694839,
			113.769477,145.861145, 96.654937,128.042999, 43.584815,125.624214, 81.587608, 76.506942, 53.989906,113.281173, 97.816238,124.059776,138.041610,149.844787,185.921905,107.675170,
			115.587333, 76.247688, 75.827400, 74.364265, 74.364265, 59.546974, 88.504302, 32.148231, 71.645759, 13.353309, 22.850484, 97.857215,166.876571,109.416961,106.268493, 51.632572,
			 44.227630, 57.481418, 43.092922, 79.758689, 85.639030, 21.279020, 24.253118, 72.440483, 26.888021, 27.043094, 27.110090, 51.266567, 79.705734, 41.854320, 52.032955, 96.554046,
			 75.329444, 59.089031, 62.160209, 49.548099, 55.338314, 72.986740, 59.400608, 37.906959, 68.779853, 48.037403, 48.417564, 34.765350, 60.651401,127.777992, 95.159065, 79.758689,
			166.876571, 96.554046, 72.593193,108.002136, 55.338314, 62.160209, 59.089031, 72.986740, 59.400608, 52.032955, 33.138267, 30.568191, 24.802640, 50.068622, 56.856376, 56.855678,
			 61.036701, 39.142848,129.849075, 83.182159,140.371002, 77.159202, 49.214378, 57.021041, 56.285953, 78.153068, 43.092922,109.416961, 50.068622, 56.855678, 85.258872,100.359443,
			 67.776031, 90.939155, 85.639030, 75.329444, 77.159202, 24.253118, 26.888021, 27.043094, 27.110090, 59.206718, 53.952114, 79.116043, 69.380859, 64.311264, 63.549316, 39.934123,
			 60.798824, 54.898990, 73.382507, 52.165126, 41.078674, 91.031654, 20.895355, 37.697319, 57.860378, 55.685024, 42.749816, 49.440479, 57.321716, 50.426601, 49.548099, 72.440483,
			 79.705734, 37.906959, 68.779853, 61.036701, 30.568191, 24.802640, 44.473186, 51.266567, 12.463465,  7.016538, 59.124530, 43.765346,287.766723, 69.380859, 64.311264, 63.549316,
			 54.517471, 91.031654,118.449264, 57.860378, 41.078674, 37.697319, 20.895355, 61.624938, 49.427680, 49.440479, 36.611175,108.002136,100.359443, 63.512565, 50.426601, 44.473186,
			 35.623287, 52.752136, 81.541038, 57.321716, 56.487426, 34.312282, 54.898990, 73.382507,255.190612, 78.153068, 44.568496, 60.798824, 85.258872, 56.285953, 57.021041, 61.631065,
			 55.685024, 67.776031, 42.749816, 75.015670, 90.939155, 53.952114, 79.116043, 48.276470, 72.593193,141.161849,175.287841, 42.296993, 59.206718, 31.046167, 30.172433, 42.296993,
			 29.691991, 70.085762,140.353652, 68.259536, 69.885017,118.507858, 96.656227, 74.004150, 94.973731,107.597282, 69.244262, 65.747489, 84.955474,106.201972, 46.594135,  3.608587,
			 45.838832, 52.840373, 72.789642,127.358955, 72.789642, 45.838832, 52.840373, 61.308418, 96.886955, 65.747489,140.353652, 67.648277,107.597282, 96.656227,118.507858, 74.568565,
			 70.085762, 44.671863, 46.594135, 84.955474, 55.583568, 55.583568, 64.667350,106.268493, 83.182159,140.371002,129.849075, 39.142848, 51.632572, 44.227630, 46.454483, 45.302295,
			 44.671863, 70.149513, 44.904239, 96.886955,103.950843,113.178512, 46.026809, 44.266407,101.365150,116.961235,116.484817, 39.848064, 69.388923, 67.648277, 42.924167, 37.044178,
			 26.856410, 26.986299, 49.267711,113.590751, 87.955085, 42.846782, 82.111038, 42.980091, 74.568565,122.190612, 59.594490, 59.572486, 39.946392, 60.640338, 64.667350, 60.186599,
			 60.186599, 33.066459,147.061355,110.627685,  9.384512,  2.500732,  2.915226,109.766036, 23.212549, 36.735660,  3.980452, 61.624938, 77.152809, 80.915184, 56.856376, 41.854320,
			 21.279020,109.766036, 48.276470, 34.312282, 48.417564, 37.618179,100.462928, 81.541038, 61.308418,127.358955,118.449264, 42.846782, 37.044178, 54.118457, 63.708091, 20.162902,
			 37.767227, 32.084960, 60.715843, 31.662649, 46.574256, 48.408378,  3.677798, 20.484828,  8.836970, 69.430503, 65.098648, 34.368797, 39.934123, 59.479148, 34.368797, 59.479148,
			 54.517471, 54.450778, 49.713016, 34.647254, 40.706157, 39.701293, 68.259536,113.590751, 87.955085, 82.111038, 69.388923, 94.973731,116.484817, 74.004150,116.961235, 39.848064,
			103.950843, 69.244262,101.365150, 46.026809, 44.266407,113.178512, 26.856410, 26.986299,121.050621, 42.980091, 59.572486, 59.594490,122.190612, 46.454483,106.201972, 45.302295,
			 70.149513, 44.904239, 13.643222,  6.419634, 23.118028, 54.821266, 60.640338, 34.726261, 42.924167, 43.770519, 39.172687, 31.628837, 11.881690, 54.450778, 49.713016, 40.706157,
			 34.647254, 39.701293, 30.841714, 30.841714, 10.209860,  9.982748,  3.812494, 58.839176, 10.788743, 23.861417, 43.707668, 48.037403,  5.393745, 49.267711, 58.839176, 86.376602,
			 61.631065, 33.138267,  9.384512, 59.124530, 31.782341, 62.188056, 15.633976, 62.100311, 29.820272, 66.745475, 35.278350, 79.597251, 65.116050, 64.410835, 49.823638, 26.722497,
			 56.487426, 49.362548, 52.165126,121.050621, 42.727184, 42.727184, 51.832462, 51.832462, 47.497917,  3.996053,  6.566555,  3.996053, 34.765350, 49.214378,100.462928, 65.116050,
			 64.410835, 79.221069, 91.062362, 69.885017, 91.062362, 45.551723,176.779113,137.887649,103.221076,103.221076,137.887649,176.779113,167.078445,106.151176,106.151176,167.078445,
			158.708801,158.708801, 62.141086, 62.141086, 80.915184, 53.094577, 13.342591,  0.000000,  0.000000,  0.000000,  0.000000, 66.451591, 62.879486, 89.866683, 27.757404,105.615203,
			136.125427,108.102447, 91.778854, 78.727935, 77.799278,114.123283,169.972854,126.129051,157.481628,122.613494,119.995140,155.372680,133.295913,102.882080, 60.819000, 44.211997,
			102.860992, 60.767196, 45.938926, 93.292022, 50.041896, 70.802947, 65.739250, 83.817893, 77.113693, 68.150154,103.398559, 81.171203, 55.481426, 49.416976, 63.032463,159.385375,
			173.269287,155.372680,133.295913, 69.264312, 57.084808, 90.520713, 33.315963, 61.153610, 78.727935, 77.799278,114.123283,169.972854,126.129051,157.481628, 36.840129,103.101394,
			 89.866683, 14.445355, 60.162849, 60.162513, 45.977092, 49.503822, 55.515731, 27.757404, 49.416976, 76.175872, 49.923206, 45.325897, 45.113815, 43.242309, 39.844905, 85.834197,
			 91.148933, 87.581825,114.600097,122.613494, 39.017059, 36.050216, 39.893131, 26.227069, 27.495435, 40.277732, 32.132038, 68.243469, 44.842426, 44.441608,105.615203,106.511802,
			 64.977394, 13.263478, 32.845535, 80.330497,151.349655, 90.525634, 88.077224, 92.153068, 69.511993, 90.921150, 80.039802, 70.561302, 84.415168,119.995140, 36.885746, 37.841690,
			 37.926418, 31.336088,193.184371, 36.191665, 34.631607, 29.772134, 35.149269, 20.709840, 71.590400, 50.213867, 92.615478, 66.451591, 41.310375, 45.876899, 42.759609, 61.079627,
			 62.879486, 42.739311, 52.034805, 64.967170, 43.044090, 32.199451, 67.361213, 17.552333, 60.828422, 32.698371, 58.018489, 56.765136, 16.813318, 38.014610, 68.177246, 50.824398,
			 37.002109, 46.966308, 46.156135,143.382171, 52.124637,178.594512,152.569763, 71.021316, 82.033714, 83.413383,119.863044, 88.294708,102.882080, 60.819000, 44.211997, 69.853790,
			 84.279510,102.860992, 60.767196, 45.938926, 93.292022,103.348182, 47.422290, 61.558002, 50.038768, 80.579513, 50.041896, 70.802947, 65.739250, 52.174076, 83.817893, 77.113693,
			 88.178680, 81.171203, 68.150154, 63.738113,103.398559, 88.172241, 55.481426, 86.493682,108.102447,109.628608, 91.778854,155.997924,186.647964,136.125427,106.511802, 90.921150,
			 90.520713, 88.077224, 60.162849, 60.162513, 45.977092, 49.503822, 64.977394, 55.515731, 39.844905, 39.017059, 40.277732, 27.495435, 26.227069, 39.893131, 45.302383, 14.445355,
			 20.709840, 41.310375, 61.079627, 52.034805, 45.876899, 42.759609, 17.552333, 42.739311, 50.213867, 84.415168, 43.242309, 45.113815, 45.325897, 76.175872, 32.698371, 71.590400,
			 82.033714,119.863044, 88.294708, 60.828422, 84.279510,103.348182, 46.156135, 46.966308, 50.038768, 71.021316, 88.178680, 61.558002, 80.579513, 52.174076, 92.615478,103.101394,
			 88.172241, 63.738113, 47.422290, 49.923206, 91.148933, 52.124637, 68.177246, 83.413383, 68.243469, 32.132038, 70.561302, 67.361213, 43.044090, 56.765136,  4.858934,100.736579,
			109.443405,116.799148, 74.139251, 33.851554, 33.337917, 36.617950, 35.972873, 23.869590, 27.500221, 26.068016, 24.685228, 31.697668, 36.378898, 36.443435, 35.769733,  3.989109,
			  5.863391,151.349655, 35.149269, 29.772134, 31.697668, 36.191665, 26.068016, 24.685228, 34.631607, 23.869590, 31.336088, 33.315963, 27.500221, 35.972873, 36.885746, 63.032463,
			 36.617950, 33.337917, 37.841690, 37.926418, 33.851554, 69.853790, 74.139251, 69.264312, 36.050216,162.846694,109.628608, 35.769733, 64.967170, 50.824398, 40.672706, 40.672706,
			 31.931062, 36.207233, 40.515110, 76.599182, 74.454216, 67.174972, 59.170543, 62.442787, 63.574607, 58.151599, 41.662525, 87.394470, 87.394470, 81.074142, 36.738399, 51.320350,
			 30.748361, 16.354518, 41.212203, 31.305377, 26.046213, 32.332691, 30.413888, 16.068061,  8.679520, 41.693103, 42.467376, 47.130275, 35.026721, 29.322837,105.395851, 66.884544,
			105.395851, 59.170543, 66.884544, 36.738399, 51.320350, 37.002109, 35.026721, 58.151599, 56.150413, 56.150413, 61.219074, 61.219074, 67.174972, 29.322837, 47.130275, 36.207233,
			 41.662525, 31.931062, 26.046213, 16.068061, 16.354518, 30.748361, 76.599182, 74.454216, 81.074142, 40.515110, 41.212203, 31.305377, 41.693103, 42.467376, 30.413888,  6.340751,
			 29.522684, 32.332691, 62.442787, 13.777656, 50.715091, 86.493682, 63.574607, 57.084808,109.443405,117.528427, 19.619861, 19.351982, 36.378898, 36.443435, 36.840129, 90.525634,
			 92.153068, 69.511993, 80.330497, 80.039802, 61.153610, 50.715091,131.734100, 85.090278,135.566146, 65.838592, 62.189334, 93.440559, 94.390975, 44.913303, 89.236244, 93.137229,
			 60.906894, 79.720916,110.566009, 96.165763, 47.867771,102.108619, 63.229469, 92.822273, 80.146400, 47.797901, 47.797901,173.269287, 61.198520, 63.560932, 63.560932,159.385375,
			 85.834197, 87.581825, 45.302383, 36.182945,100.736579,155.997924,143.382171,193.184371,131.734100,186.647964,162.846694,114.600097,152.569763,178.594512, 51.130882, 53.608451,
			 40.543148, 60.579936, 87.291770, 62.540439, 84.180587, 68.376197, 42.562297, 71.303573, 36.182945,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,113.899177,146.093307,
			105.278396, 47.260955, 59.715728,142.965606,111.425003, 11.088865, 85.473991,122.320213, 87.757621, 87.740425, 58.200744, 47.454730, 40.130725, 41.089130, 83.743453, 91.219718,
			241.858627,137.735443, 34.662662,120.509933,111.667648, 16.701074, 29.042749, 86.689468, 53.040657, 89.992866, 86.204940, 57.092170, 61.084346, 61.089057, 61.084320, 61.089054,
			 57.147483, 70.505714, 74.851509, 54.944713, 69.756942, 21.300512, 97.104621, 56.165027,115.058868, 31.782047,114.242500,111.020141, 86.689468, 53.040657,146.093307,113.899177,
			 61.446758, 56.165027, 77.450347, 87.090995,122.320213,122.330177, 99.191146,122.695785, 95.966529, 99.911102, 14.344054, 38.680717, 38.680717, 14.344054, 21.649976,119.409477,
			250.803115,224.439819,214.082565,220.259796, 91.781631,114.900306,173.730545,118.580024,120.170166, 73.771629,138.161621,140.913894, 24.745607,  9.063944, 35.333343, 28.153728,
			  7.757609,135.065750,155.215728, 74.744697, 69.645210,  5.577619, 24.181322, 19.412473, 56.594154, 12.673563, 82.296440, 34.227787, 17.400430, 20.227508, 19.337574, 18.806573,
			 81.123405, 64.765663, 78.223609,110.439453,118.552841, 64.765663, 71.135147, 75.826591, 92.959327, 95.518997, 87.338722, 87.090995,122.330177,159.021057, 58.872901, 69.814468,
			173.431472, 67.297271, 67.832969,114.902267,110.879570, 80.535987,104.024284,177.663421, 64.283035, 31.074447, 57.430465, 69.787628,214.082565,224.439819,250.803115, 91.219718,
			 83.743453,220.259796,241.858627,142.965606, 47.454730, 85.206535, 74.744697, 85.206535, 35.333343, 51.707721, 58.327793, 43.553768, 34.227787, 24.745607,137.735443,101.885581,
			135.065750,140.913894,138.161621,155.215728,120.170166,120.509933,177.663421,113.620193,113.477706,111.927604,113.477706,113.620193,111.927604,110.439453, 17.400430, 20.227508,
			 56.594154, 18.806573, 28.153728, 19.337574, 43.553768, 34.826519, 34.826519, 78.223609, 59.715728, 84.285644, 69.814468, 85.473991,111.425003, 88.173683,130.434432,121.062805,
			130.855224, 93.064102, 60.819412,105.968955, 40.001163, 27.412879, 34.740993, 96.558670,174.315872,138.947204,126.738159,104.858093, 73.456512,136.304000,122.009033,115.140792,
			157.226242,172.940383, 64.644767, 74.827377,104.064720, 80.757232, 61.338005, 57.697074, 54.635528, 82.521949,119.504570, 84.558959, 85.740516,144.892074, 96.076919,135.163238,
			157.662780,162.295623,143.166610,135.163238,162.295623, 65.859100, 81.810775, 78.228355, 70.108734, 56.811950, 96.265602,150.447082, 72.534576, 81.448532, 57.239948, 50.904830,
			 40.901344, 31.124702, 47.225406, 31.223628, 36.617347, 40.556579, 24.075250, 82.219505, 13.907979, 13.642300,  9.998064, 47.954761, 52.602741, 41.484153, 42.903465, 39.511596,
			 19.745910, 41.543483, 33.079299, 32.794147, 22.674299, 24.071903, 38.266250, 22.920692, 43.400112, 51.403968, 39.781627, 79.869567, 44.428493, 72.466720,129.657913, 34.401435,
			 29.195316, 67.713104, 25.201141, 30.972034, 56.588832, 93.161705, 29.869302, 17.986207,172.940383, 88.173683, 61.338005, 74.827377, 57.697074,104.064720, 82.521949, 54.635528,
			 80.757232, 63.333553, 50.904830, 47.225406, 31.124702, 36.617347, 41.484153, 31.223628, 43.400112, 51.403968, 52.602741, 42.903465, 39.511596, 22.674299, 19.745910, 24.075250,
			 44.428493, 40.556579, 22.920692, 38.266250, 24.071903, 32.794147, 41.543483, 33.079299, 25.201141,119.504570, 81.810775, 65.859100, 71.514274, 72.357231, 60.819412, 93.064102,
			 57.826515, 79.869567,102.821403, 81.646087, 73.405456, 47.196968, 70.230484, 70.043319,150.447082,130.855224, 78.228355,138.947204, 75.553909, 69.633430,140.795455, 55.536148,
			 47.196968, 62.074913, 57.826515, 70.230484, 69.041732,102.821403,140.795455, 81.646087, 73.152938, 13.967328, 84.867767,142.751678, 73.463165, 58.493816, 38.901672, 40.180538,
			 56.484542, 28.291269,  5.532180, 45.244934, 24.985698, 28.239109, 67.924598, 39.175632, 38.896884,105.482872, 72.595367, 82.112876, 78.146720, 47.056533,  3.650553,  3.049666,
			157.635803, 88.448959,176.813598,176.681762,176.681762,159.857055, 73.405456, 31.629827, 70.043319, 56.475364, 71.514274, 62.528942, 72.357231, 69.633430, 94.178756, 79.843612,
			 76.370475, 75.553909, 75.556167, 77.879943, 82.219299, 77.450347,132.050292, 90.867111, 50.420314, 68.467185, 77.143936, 61.446758, 66.460273, 57.976837,102.148056, 74.722946,
			 77.115005, 66.607627, 52.505119, 50.931465, 72.534576,107.487998,115.140792, 82.219505,126.738159, 56.634735, 82.589370, 44.818492, 80.520278, 25.867076,  6.776409,129.657913,
			 67.924598,142.751678, 93.161705, 84.867767, 40.901344,105.482872,174.315872, 58.872901, 50.931465, 72.466720, 28.239109, 24.985698, 39.781627,130.434432, 56.811950,136.304000,
			122.009033,159.021057, 73.463165, 62.528942, 62.074913, 55.536148, 96.265602, 31.629827, 69.041732, 72.595367, 73.152938, 87.338722, 90.867111, 80.535987,110.879570, 78.146720,
			 67.832969,114.902267,118.552841, 75.826591, 71.135147, 82.219299, 81.123405, 73.456512, 77.879943, 75.556167, 94.178756, 79.843612, 76.370475, 56.475364, 52.505119, 70.108734,
			 74.722946, 96.076919, 77.115005, 66.607627,104.024284, 95.518997, 47.260955, 77.143936, 66.460273, 97.104621, 57.976837, 38.896884,132.050292, 88.448959, 87.757621, 87.740425,
			 48.539714, 40.001163,115.058868, 34.740993, 96.558670,105.968955,103.836616, 12.529824, 12.648129,  7.241010, 12.648138, 86.204940, 30.114326, 48.539714, 22.838329, 28.489797,
			 27.645439, 16.760841, 10.570332, 11.703329, 21.480249, 32.984169, 40.252292, 28.115558, 36.096160, 31.230272, 45.393981, 48.198688, 23.791501,  3.224992, 17.492321, 17.916305,
			118.580024, 91.781631,114.900306,173.730545,101.502479,139.807952,134.629272, 93.283523, 90.216285,160.099044,100.623023,167.730056,100.763000, 80.425430, 93.283523,139.807952,
			 90.216285,100.623023,100.763000,101.502479,134.629272, 23.791501, 56.588832, 13.967328, 29.195316, 28.539474, 27.677295, 27.443523, 22.838329, 30.136871,102.148056, 44.838493,
			 10.006260, 21.300512, 56.484542,160.996978, 92.426353, 92.426353, 99.165191, 99.165191,101.885581,  1.793141, 14.644728, 14.644728,  6.818463, 10.517707, 10.517707, 10.517707,
			 10.517707, 93.926795, 61.395896, 61.395896, 93.926795, 51.363220,121.911544,158.292800,158.292800, 68.430015, 70.873657, 82.070770, 82.070770,121.911544, 70.873657, 68.430015,
			 11.228807,  3.989067,  5.863348, 12.370322, 67.736557, 51.234466, 46.863754,  4.643784, 51.363220, 51.234466, 46.863754, 67.736557, 16.894939, 67.297271, 17.556320,  5.504214,
			 17.556320,111.020141, 31.782047,114.242500,101.610984,101.610984,  4.710694,159.857055,176.813598, 85.687187,143.166610, 74.556533, 74.556533,157.635803, 88.637374,102.689636,
			 88.637374, 97.755645, 97.755645, 86.699928, 68.467185, 50.420314, 39.175632,103.836616, 27.523889, 27.521333, 27.521333,105.278396,121.062805,102.689636, 85.687187,  3.479161,
			  3.320199,160.996978, 73.257667, 74.284370,107.487998, 86.580871, 86.580871,214.527465,214.527465, 69.756942,104.858093, 17.986207, 29.869302,119.409477, 16.900798, 89.992866,
			 30.972034, 85.740516,144.892074, 72.843688,100.530982,122.182350, 97.697257, 32.642341, 31.663295, 36.302230, 18.209218, 44.838493, 18.319211, 18.583517, 16.136173, 17.010387,
			 14.188765,  6.767057, 16.601526, 11.638850, 79.190826, 84.558959, 74.284370, 73.257667,  1.820060,  2.461860, 57.239948, 64.644767, 34.662662, 92.959327,  1.627607,173.431472,
			 84.285644, 86.691238, 97.653572, 90.912162, 80.773262, 23.302036, 23.302036,157.662780,  3.320213,  7.881138,  0.000000,  0.000000, 12.686868, 15.311710, 44.390541, 39.291137,
			 28.531518, 23.814670,  6.641651, 10.075402, 14.454659, 87.919868,108.687118,  4.861522,  3.578481,  8.889515, 20.235107,  4.892883, 16.564920,  2.529257, 37.496994, 34.853157,
			 10.740976,  4.664103,  8.151631,  6.653482,  5.111806,  6.653482,  4.655965,  5.110997, 92.669952, 19.004766, 28.028276, 15.525699, 14.495118,  3.202542, 16.300527,  3.277179,
			 22.228139, 10.740932,  6.653482,  5.111587,107.714576, 11.230205, 85.645004, 83.646293,112.566032, 81.262451, 50.968055, 90.203681,112.578147, 16.761302,  8.474589, 41.059146,
			  6.866600,  6.818276,  1.730167, 32.881397, 99.941558, 26.636850, 79.015487, 12.368652,  6.981699, 80.589416,109.587783, 24.699029, 68.019447, 67.710548, 68.018646, 67.732246,
			 10.364499, 11.126738, 23.546285, 14.464355, 13.810002, 24.178737,  6.245536, 11.168722, 11.306364,  9.072219,101.789772,  8.507234,  5.385830,  8.790200,  8.474469,  6.044486,
			 12.335678, 10.162343,229.183990,217.289184,213.265060,176.173477,174.858184,174.190628,176.042678, 72.913970,178.860198,159.632812,170.254913,172.826416,168.923233,160.457077,
			171.142700,173.538787,170.591567,168.714523,175.912048,174.194335,180.806503,175.500335,133.673004,137.476776,154.276458,153.772659,148.149642,125.941482,133.064315,154.813934,
			171.832901,163.016510,169.046508,153.473159,149.990081,116.514823,138.243957, 30.983743,  4.320850, 18.588312,  9.028882, 10.683402, 20.822385, 36.829620, 37.250259, 64.342697,
			154.451995,170.693618,140.155975,135.705108, 32.708568,171.455047,  8.751113,139.948669,132.567672, 81.429092, 88.850425, 56.453052, 62.244232, 71.459419,  4.861547, 37.579101,
			 27.835363, 41.059146, 32.881397, 33.658794, 46.001567,133.673004,137.476776,154.276458, 87.919868,163.016510,169.046508,116.514823,153.473159,149.990081,175.500335,153.772659,
			180.806503, 72.913970,172.826416,168.923233,170.591567,176.173477,170.254913,160.457077,171.142700,173.538787,175.912048,174.194335,154.451995,170.693618,139.948669, 16.300527,
			 19.004766, 15.525699, 46.001567, 44.390541, 36.829620, 83.646293, 92.669952, 44.227863,213.314819,202.213500,135.863662,  2.739206, 18.588312,  9.028882, 10.683402,  9.072219,
			 24.178737,  6.245536, 23.546285, 11.168722, 81.262451, 50.968055,112.566032, 28.165403, 85.645004,255.413589,127.865547,203.961242,190.921234,239.500839, 12.686868,  2.229867,
			239.500839,229.183990,217.289184,213.265060,176.042678,174.190628,148.149642,125.941482,101.789772, 32.708568,159.632812,174.858184,178.860198,168.714523,190.921234,145.864791,
			145.864791, 68.019447, 67.710548, 68.018646, 67.732246,171.455047, 13.810002,135.705108,138.243957,132.567672,140.155975,154.813934,133.064315,171.832901,108.687118,  7.526260,
			  4.842006,  2.647628,  5.744907, 39.291137, 23.814670, 16.564920, 10.075402, 28.028276, 22.228139, 30.983743, 12.775083, 12.775083,  6.110422,  7.881180, 81.663490, 82.482681,
			 33.534610, 47.347206,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			 86.802711, 57.008834,113.755142, 83.829559,174.582183, 72.508644,131.925094, 36.468139, 18.923719,129.212768, 98.256546,100.087921,145.952468,141.060165, 29.154760,140.139877,
			119.176254, 83.111801,104.692314, 57.018543, 65.000061,  9.446587, 20.851451,168.935882,156.178649,220.660568,125.269165, 81.030975,147.849761,139.558303, 86.094093, 60.874618,
			129.975906,122.535331,124.774765,115.448974,139.617370,121.802734,115.204803,  5.802535,  7.577417,  9.004846,  5.455570, 11.995406,  8.435725,  9.981213,  7.086030, 31.554279,
			 31.037300, 24.404737, 35.595912,127.898056,170.824279, 30.596410,  6.884792, 49.721321, 63.204418, 26.173433, 90.046180, 17.748016, 40.047756, 26.987371, 38.186534, 30.853212,
			262.607940,171.636871,179.426345,149.058319,193.770721,133.345642, 88.829116,170.631195,155.573516,160.222686,134.773651,168.865646,100.622833,127.626693,142.414154,152.112091,
			136.050537,117.495033, 87.032821,123.592369,120.254707,135.609863, 81.260017,146.792663,107.365997,109.642807,109.768737, 97.857719,164.985229,106.801170,112.611709,110.717491,
			125.173263,105.372596,156.359085,134.822479,134.847030,112.418785, 87.546531, 91.719039,139.812622, 51.005237, 52.628269, 67.784797,181.461059, 37.995754, 62.672080, 22.796651,
			 17.453893,  6.111052,  8.595881, 16.622735,166.652374,  9.380015,  9.380013, 18.200609, 17.577175, 10.349053, 10.349053, 37.908767, 35.883857, 12.785017, 40.711620, 14.586212,
			  9.195550, 12.785013,  5.542786,228.475616, 33.635082,104.941062, 27.028417, 51.632465,156.330261,  9.674791, 26.402355, 57.459533, 26.402355, 29.884128,  9.195211, 12.807077,
			 11.878493, 15.327611, 18.443349, 13.184758, 26.912942, 13.493544,  4.890150, 11.401606, 43.523849, 12.037976,  8.292608, 29.451265, 33.643341,  3.646136,  5.359056, 25.121524,
			 40.813964, 11.831977, 41.523887, 25.879024, 33.233474,111.793716,147.908859,125.530616,128.408203,175.048217,103.276405,131.591308, 41.823493,157.797744,177.922515,124.727027,
			 57.051269, 15.658347, 13.352259, 22.837097, 28.949134, 76.354187, 21.116159, 47.232917, 39.798740,  5.746616,  7.467586,  5.738862, 42.394248,198.610916, 17.049116,  5.718754,
			 31.055368, 57.008750, 61.035617, 49.498561, 57.008842, 61.032787, 38.580974, 60.944541, 95.536697, 44.717895, 53.042335,  9.224465, 50.657146, 49.902496, 48.217571, 13.901940,
			 37.778987,  7.725017, 27.783390,  4.588868, 38.818767, 42.310802, 45.057228, 42.183326, 22.041643,168.129425,166.726028,242.377426,162.662460,142.839324, 20.581981, 84.135719,
			 49.801139,  7.770092, 25.121524,  9.230526,  2.971904, 14.586212,159.952362,170.631195,181.461059, 65.144485, 54.503437,116.413772,236.923080,262.607940,161.281692,157.971923,
			185.358795,183.586776,175.320968,161.071945,169.073074, 40.305564,161.071945,183.586776,228.475616,197.983749,176.772293,150.222808, 16.622735, 17.453893, 22.796651, 17.577175,
			 18.200609, 12.885199,118.975051, 21.158443, 39.213638, 29.446603, 21.158443, 29.446603, 39.213638, 38.347812, 67.478370, 67.478370, 38.347812, 29.884128,177.160293,156.048614,
			152.597640,155.573516,171.636871,177.160293,156.048614, 36.354911, 36.327434, 36.354911, 36.327434,168.914794,196.212081,169.470260,152.885757,196.212081,168.914794,169.470260,
			 70.571784, 67.784797, 70.571784, 51.005237, 51.722351, 52.628269, 51.722351,145.651321,120.448013,142.917800,143.599548,148.542709,172.714584,180.425140,172.161193,153.115020,
			 90.894081,157.764953,151.400039,171.927047, 12.885289, 12.885289,148.542709,172.714584,180.425140,153.115020, 90.894081,171.927047, 87.032821,117.495033,182.509246,103.131263,
			189.338043,199.251434,187.221359,187.824478,175.823532,161.280258,133.042984, 51.534503, 71.600791, 58.301742,133.042984, 44.522617, 16.456851, 16.456851,188.407608,137.521713,
			177.815246,184.416091, 37.688430, 99.290580, 94.114463, 67.554183, 76.660095,170.711959,183.258560,178.902252,164.238739,185.914794,185.740768,187.393249,180.156265,180.156265,
			193.770721, 74.919250, 99.290580,105.372596,185.348052,189.567565,157.758499,185.348052,156.359085,145.651321,136.050537,103.550682,103.550682,119.542289,119.542289,144.605453,
			 57.044353, 84.100593, 67.272224, 81.402847,106.358116, 57.017360,126.039245,137.911239,164.815200,107.445343,143.611083,161.354858, 95.588714,136.991485,164.815200,107.445343,
			161.354858,136.991485, 95.588714,  3.630208,  2.740493, 12.807077, 19.730197, 72.508644, 40.047756, 17.748016, 29.361913, 26.987371, 12.785017, 12.785013, 29.361913, 40.711620,
			 37.908767, 35.883857, 44.522617, 19.730197, 11.995406,168.851531,  9.144988,132.495697,170.201995,103.735176,100.419105,190.951583,171.596710,196.443359,199.782394, 48.217571,
			 37.778987, 42.394248, 38.818767, 24.404737, 42.310802, 47.232917, 39.798740, 20.581981, 31.554279, 45.057228, 42.183326, 35.595912,170.201995,103.735176,132.495697,199.782394,
			164.985229,170.824279,127.898056,162.235733,144.372406,155.463333,162.235733,144.372406,155.463333, 57.051269, 30.853212, 22.837097, 38.186534, 30.596410, 25.879024, 21.116159,
			 28.949134, 76.354187, 49.721321, 33.233474, 40.813964, 41.523887, 43.523849, 12.037976, 20.851451, 11.878493, 15.327611, 18.443349, 13.184758, 26.912942, 13.493544, 11.401606,
			 57.044353, 57.018543, 67.272224, 65.000061,104.692314, 57.008834,119.176254, 83.111801, 84.100593,147.849761,146.792663, 95.536697, 51.534503, 44.717895, 60.944541, 71.600791,
			 58.301742, 38.580974,158.668975,145.952468, 57.008750, 57.008842, 61.032787, 83.829559, 49.498561, 57.017360, 61.035617,139.812622, 26.402355, 26.402355, 57.459533, 34.249202,
			 19.142061,179.821594, 34.249202, 19.142061,162.662460,157.797744,140.139877,100.087921,152.112091,142.414154,177.922515,127.626693,100.622833,103.131263,129.975906,122.535331,
			124.774765,115.448974,139.617370,121.802734,115.204803, 60.874618,124.727027,113.755142, 97.857719,160.169067,160.169067,175.500686,158.668975,168.596908,175.500686,168.596908,
			109.768737,147.908859,107.365997,135.609863,130.567779,130.567779,120.254707, 81.030975,111.829017,123.592369,111.829017, 62.672080,125.173263, 67.554183, 98.828163, 98.828163,
			103.276405, 26.723047,109.642807,114.810165,112.172996, 86.793899,139.558303, 81.260017,125.269165, 86.094093,112.172996, 26.723047,114.810165, 86.793899, 76.660095,149.058319,
			  1.217401, 35.932479, 35.932479, 19.595176, 37.593906, 37.593906, 19.595176, 12.885199,125.373825, 18.923744,138.974273,129.996963,142.839324,129.996963,168.544433,176.460052,
			168.865646,161.281692,134.773651, 98.256546,160.222686,110.717491,128.408203,125.530616, 81.402847,116.413772,106.358116, 26.173433,131.591308, 13.352259,118.975051,141.060165,
			131.925094, 87.546531, 37.688430, 31.055368,112.611709,106.801170, 29.154760,134.847030,112.418785,111.793716, 86.802711,134.822479,137.521713,177.815246,133.345642,144.605453,
			175.823532, 88.829116,187.221359,161.280258,172.161193,197.983749,176.772293,150.222808,166.652374,129.212768,185.358795,157.971923,192.552215, 91.719039,132.098709,132.098709,
			188.407608,187.824478,199.251434,189.338043,151.400039,189.567565,242.377426,178.902252,183.258560,168.935882,164.238739, 10.942661,183.813781,186.322006, 13.648851,188.956192,
			156.481964,144.037399, 83.463790,155.209991,182.557968, 60.739311,168.129425,160.383636,141.051895,146.571060, 21.819671,116.473396,167.055435, 63.204418, 41.823493,174.582183,
			220.660568,175.320968,175.048217,157.758499,179.821594,221.759414,152.597640,156.178649,169.073074,159.952362,185.740768,185.914794,196.443359,171.596710,119.176254,138.974273,
			100.419105,190.951583,179.426345,152.885757,236.923080,  6.111052,198.610916,143.611083,137.911239,157.764953,187.393249, 17.049116,143.711166,185.021240,139.728836,139.728836,
			  6.111051,  6.111051,192.552215,140.872741,140.872741,102.861793, 68.040046,161.487777,135.103836,137.284851, 49.268375,105.749885, 77.614311,189.483276,135.248260,168.953460,
			155.372024,188.723937,169.539352, 77.272575,151.657775,128.494781,119.899520, 69.297615, 49.785327,147.685058,174.802337,141.191909,172.163497,115.718162,121.238235, 82.452911,
			137.687759,168.487823,120.959556,121.872077,137.476852, 74.789939,105.911422, 62.945075,149.161895,102.364395,100.012886,116.446884,121.428184, 90.048004, 24.542095,149.009979,
			167.794036, 86.520996,113.985122,133.230590,132.441833,174.948486,152.032608,122.080192,127.141838, 93.489166,104.156288,184.682571,161.448135,124.433609,149.893508,220.665481,
			189.818252,139.414047, 52.346836,181.080215,122.531684,162.191818,157.633178,160.148406, 67.742797,120.106742,  6.078335,102.245025,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 23.274868,  5.740705, 16.252786,  2.494359,  4.255323,194.166061,147.042373,147.042373,194.312713,234.267700,
			147.042373,147.042373,155.443786, 37.247932, 11.616476,187.330474,249.451507, 41.712528,152.872268, 41.241336,194.166061, 61.523101, 75.783050, 52.072132, 59.491863, 60.068599,
			 53.903701, 52.624553, 65.848037, 52.737026, 17.025651, 52.590320,123.290512, 41.566337,185.517913,182.784255, 96.749717,126.589042,188.554809, 23.005025, 23.005666,224.685043,
			201.079895,176.178802,130.506835, 17.845069, 14.171054,  8.402323, 11.416256,  7.385638,  8.605827, 13.206135, 26.184604, 10.373218,  6.903674,  2.493993,  2.521312, 20.729537,
			 20.732511,  2.525173,102.001976, 29.796421, 51.347995,129.346160,  6.270576, 83.655921,244.788818, 93.947212, 90.046043,103.970489,103.764602, 96.879272,175.286621,110.602531,
			144.794113,104.417564,  8.129119, 13.230030,  0.000000,  0.000000,  0.000000,  0.000000,138.130920,144.790573,206.495834,140.369552,130.262786,127.846694, 92.590675, 31.532348,
			123.291427, 21.185447,125.743293,116.814224,125.736465, 80.552070, 58.158355, 20.632936,124.512535,119.048492, 83.676383, 80.912307,196.038162, 67.015792, 20.682563, 18.870412,
			 18.453752, 36.645076,172.077987, 75.929908,178.026031, 34.182830,155.615509,100.984619,153.446731,115.039047,129.102569, 69.632972,183.388626,130.227783,178.646896,169.125579,
			110.949432,130.282791, 27.115755,171.546157,152.643707, 79.476577, 96.616485,136.463088,111.789482, 36.145633, 41.415748,242.723342, 56.377502, 28.308160, 84.743453, 31.832828,
			 23.268901, 20.022001,135.824234, 71.614631, 75.107635, 59.981899, 85.960845, 69.819007, 51.101051, 54.413909, 77.115951, 54.134849,109.247138,116.440872,102.397277, 72.737503,
			 54.222705, 80.912307, 30.110689, 21.997573, 94.230613, 16.538391,109.247138,152.434112, 76.918342, 31.794759, 16.091400, 29.541843,167.127838,109.471206, 27.527795, 41.415748,
			 31.832828, 17.910989, 17.910989,172.077987,102.397277,116.440872,196.038162, 54.413909, 85.960845, 58.158355, 75.107635, 77.115951, 54.134849, 83.676383, 67.015792,178.026031,
			125.736465, 31.532348, 51.101051, 69.819007, 59.981899,152.434112,171.546157, 56.377502, 82.479972, 79.476577, 84.743453, 41.812473,104.802879,204.665298, 30.110689, 21.997573,
			 36.645076, 18.453752, 29.541843,139.243774,139.243774, 18.870412, 20.682563, 31.794759, 20.632936, 53.536476, 14.306832, 21.185447, 54.331752, 46.385910,136.993728, 46.385910,
			 54.331752,159.176391,152.158981,159.176391,152.158981, 49.214229, 41.812473, 49.214229, 38.520709,  2.719011,166.406951,242.723342,180.539413,220.731262,180.539413,186.715133,
			174.182434,166.226623,132.487380,186.715133,174.182434,166.226623,132.487380, 43.724674,138.130920,152.643707,183.388626,130.227783, 82.479972,111.789482,129.102569, 69.632972,
			178.646896,136.463088,162.009063,130.282791,135.824234,121.979553,153.446731,121.979553,206.495834,220.731262,144.790573,204.665298,140.369552, 92.590675,124.512535, 28.308160,
			119.048492,100.984619, 80.552070,116.814224, 16.538391,159.217987,173.421691,177.858810,160.417724, 46.354400, 46.354400,127.846694,125.743293,123.291427,130.262786,159.801223,
			 96.505882,159.801223, 36.145633, 34.182830, 76.918342, 38.520709, 94.230613,167.127838, 53.536476,109.471206,162.009063,169.125579, 96.505882,155.615509,166.406951,104.802879,
			 96.616485, 20.022001, 77.324157,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 15.281860,
			  4.299362,  8.642659,  5.667794,  2.934071, 37.769409, 34.666511, 40.689956,  7.453808, 54.802852,  9.973649,  4.231824,  4.920001, 14.157062,  8.536690, 15.355630,  6.734055,
			  4.195161, 11.381585,  3.588892,  8.030610,  7.877952,  1.533489, 20.909223,  6.328018, 39.506271,  6.522205,  8.043173,  8.030594, 42.204238, 16.609481,  8.030624, 38.902347,
			  6.216483, 13.480875,  5.653756,  8.333639,  9.223002,  9.864708, 10.390876,  8.971528,  9.846320, 20.562971,  8.875343,  8.329351,  7.511371,  7.529655,  7.761381,  7.329330,
			 10.633043, 22.780780,  7.246758, 16.074068, 18.457069, 10.267726,  9.841880, 10.676213, 34.251758, 11.637088, 22.650882, 16.435434, 30.334674, 18.560697,  2.778163, 13.043871,
			  9.750156,  6.302392,  8.941900,  9.929257,  8.735132,  2.546487, 21.179519,  3.329432, 17.683412,  6.936384,  4.305453, 28.630039, 16.877208,  5.867900, 22.081110, 19.255165,
			 29.429325, 26.295125, 52.913707,  3.325020,  3.348468,  3.755830, 13.823863,  6.385255,  7.619594, 19.979484, 18.574348, 24.356147, 13.233531,  9.863370,  7.681121, 14.706019,
			  2.737000,  1.895207,  8.915166, 22.077989,  6.028900, 32.138080, 10.341743, 11.981188, 15.500383,  6.527288,  0.718704,  2.625473,  3.899570,  3.025672,  2.008712,  9.063330,
			  4.282915,  7.960146, 27.482252, 43.622940, 31.390396,  2.497517, 42.060302,  8.138665, 10.135147, 16.837022, 44.866783,  8.154256,  8.130868,  8.117865,  8.110475, 24.785301,
			 23.129180, 37.962219, 42.124149, 32.057479,  9.502229,  9.049036,  9.388654,  6.753312,  8.890325,  3.194468, 20.527286, 30.335372, 11.583724, 35.413646, 11.528414,  2.430718,
			  9.211371,  0.000000, 13.841379, 14.296714,  1.130002, 37.479804, 10.652791,  7.017055, 40.163223,  9.456638,  2.587691, 25.199764, 25.927452,  7.005399,  2.587620,  7.843269,
			 10.737083,  6.355907, 38.156589, 34.250598, 38.222969,  4.613722, 32.326133,  7.809515, 18.440008, 65.194137,  8.014126,  0.000000,  2.079427,  0.000000,  2.407974, 15.485947,
			 16.069766, 69.483840, 17.575328, 80.057418, 40.649383,  8.892336,  1.838678,  1.821413,  1.833443, 16.425220, 15.350017,  6.457539,  9.316280,  7.125936,  4.600150,  4.971447,
			 30.849725, 34.878944,  7.162825, 35.493927, 11.300380, 10.152824,  6.433669, 10.446963, 27.336223, 35.826095, 39.915649, 39.860061, 56.354785, 37.556873, 31.313661, 11.178778,
			 42.145637, 23.375267, 46.608501, 37.082927, 13.872260, 21.945421, 32.527336, 22.329324,  4.657169, 33.677547, 35.417541, 11.676733,  1.103824, 47.805690, 95.861526, 29.928792,
			  4.545646,  7.973297, 22.691814,  3.770900, 13.854598, 40.703422, 49.254886, 32.204311, 32.150077, 24.454751, 27.039594,  8.168477,  8.171466, 72.909782, 19.519435, 40.449039,
			 65.172943, 51.526237, 19.921018, 41.478549,  7.012481, 10.668768,  3.962043, 22.673902,  5.217382, 21.098674,  7.005399, 10.082901, 32.410644,  6.880533,  1.679154, 16.703193,
			  5.535560,  4.780028,  4.164851,  7.471285,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  5.172478,  3.452904,  9.471388,  5.962378, 10.312879, 15.096480,
			  4.289657,  8.212879,  0.000000,  0.000000,  2.113291,  4.114675,  1.581138,  5.692715,  6.990336, 18.034484,  1.179680, 25.243217, 24.632665, 28.935981, 23.591802, 29.362985,
			 14.341477,  6.853878, 22.451951, 30.519439,  4.114675,  1.581138,  2.113290,  0.561348,  1.607354,  5.692715,  6.990336,  4.114675,  1.581138,  2.113291,  0.561348,  1.607354,
			  5.692715,  6.990336, 11.627467, 15.404569, 15.860503,  0.561348,  2.312994, 18.393188,  0.000000,  0.000000,  0.000000,  1.607354, 12.572376, 20.484472, 18.620847, 18.313180,
			  7.229183,  0.368548, 17.221652, 22.527578, 15.382427, 11.907554, 15.807238, 14.250402, 12.476519, 12.248798, 14.624515,  5.514585,  5.514588, 11.728556, 10.643094,  5.891830,
			  3.954865, 10.501902,  3.190820,  2.265794,  1.897528,  1.897528,  3.190820,  2.265794, 18.899400,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 15.854106,
			 10.715330, 15.311973, 11.584074, 14.918084,  4.989336,  7.041598,  7.697885, 11.185001,  4.368583, 13.463015, 12.368824, 11.813734, 14.202019,  4.601686, 12.670378, 10.406938,
			  1.240931, 15.386138, 18.286140, 14.173559, 12.671657, 14.785366, 16.583007, 14.065190, 14.445327,  6.797235,  4.881485,  5.027309,  7.274193,  0.054193,  0.000000,  0.000000,
			  0.000000,  0.000000,  8.602721, 26.680170,  0.401742,  0.565975,  0.565975,  0.565975, 35.816356, 20.805801, 12.255591, 12.442863,  5.775647,  5.810986,  3.274070, 14.600872,
			 53.952934, 12.927674, 20.371101, 16.524276, 15.601529, 30.568326, 19.955444,  5.819477, 15.114985, 11.981188, 21.288755, 44.652732, 11.360151,  9.565775, 14.427075,  4.546679,
			  2.694247, 12.830755,  5.514201,  8.330654,  1.214437,  4.726785,  2.458431,  5.316172, 14.973606,  6.580931, 10.727207,  9.966395,  5.430532,  7.018592, 11.184856, 19.072738,
			 18.554330, 12.220831,  9.618924,  1.477843,  1.030617, 10.463655,  2.871207,  3.093679,  3.120923, 20.138978,  4.164343, 11.865678,  2.974908,  9.970158, 16.467632,  5.312998,
			  7.874841, 11.776711,  1.514929, 10.475516, 10.733925, 11.478505, 24.001560,  5.275575,  3.070521, 14.654134,  1.863419,  6.174008, 18.495792, 13.480997, 35.210746, 36.230148,
			 29.749261, 11.599135, 15.999859, 34.350563, 31.979511, 48.004096, 19.083192,  8.033397, 17.223455,  0.000000, 35.103710,  5.119180,  4.492090,  2.074629,  1.287292,  3.874696,
			  3.249241,  5.762286,  1.810220,  4.270325,  4.672675,  1.207283,  2.640805,  9.429796,  1.295397,  5.478641,  5.220956,  2.616319, 11.269638,  5.590139,  4.861660,  7.733037,
			  1.968438, 10.187068,  6.766048,  4.204813,  0.000000, 39.947719, 35.661941, 25.502603,  5.273736,  6.711506,  0.740656,  4.847578, 28.473752,  3.056993,  3.056993, 16.113271,
			 11.658272, 12.872426, 12.654981,  0.000000,  3.067836,  3.059845, 11.130428, 11.295446,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  8.129487,  8.110497,  3.492749,  3.194468,  7.936457,  7.946800,  7.716363,  6.438294, 11.523586, 11.203198,  6.740506,  3.954875,  1.959615,  0.753720,  4.874314,
			 15.635778, 17.072214, 14.131295, 12.408978,  9.321505, 13.960728, 14.088441,  8.985197, 12.670934,  6.224668, 16.671075,  7.625376,  9.218743, 13.752242, 17.491523, 17.056013,
			  9.055923, 10.591513, 18.800914, 15.606558,  7.061592,  9.187353,  8.954184, 14.131677,  4.513158,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			 13.379985,  6.135705,  8.136526,  3.429255,  7.039470, 40.181648, 28.631277, 50.281860, 36.331375, 52.399448, 42.209087, 24.566211, 25.246706, 69.557022, 52.603839, 17.027044,
			 43.158851, 28.971965, 23.608100, 38.531707, 18.000244, 22.215986, 32.146175,  1.226207, 72.331352,100.353797,104.225151,112.219886,122.243949,120.280921,114.134582,109.461799,
			 62.207862, 44.792560,115.498832,134.277038,132.609313, 77.141998,100.766960, 95.754379, 94.394950, 92.174880, 84.052947, 98.508575,100.382530, 94.782165, 98.233299,104.985771,
			 94.476379, 91.446777, 57.313331, 13.542363,  2.295257, 22.893754, 27.656856,130.744964,122.196754,121.919494,125.628784, 95.549606, 63.823989, 36.537357, 31.221754, 30.882555,
			 35.308399, 36.388645, 19.844329, 16.690149, 29.248685, 32.963867, 27.030132, 20.979785, 21.519409, 21.023752, 21.262792, 21.581581, 13.362417, 62.286899, 21.014484, 21.568851,
			 62.215305, 24.430698, 12.266635,  6.443836, 22.700563, 33.442787, 61.573120, 72.704719,  8.825349,  8.825349,  8.825349,  8.825349,  8.825349,  9.408255,118.602890,  5.820567,
			  5.820593,133.585815, 30.729564, 27.049612, 40.712448,  5.465031,111.833641,137.888336,117.811698,  7.125143, 30.257656,  8.081675, 28.675558,137.068222, 31.143239, 31.445611,
			 28.055528, 33.293415, 33.958797, 71.824325, 33.845005, 31.309188, 33.724746, 66.367500, 33.332859, 34.316184, 57.088882, 46.786567, 30.629028, 82.318191, 68.643081, 30.627395,
			 65.876808, 69.986259, 54.312381, 87.799087, 18.353187, 33.006683, 17.626056, 35.712055, 50.046115, 24.449254, 32.988697, 30.700820, 79.128654, 66.614059, 73.408988, 35.491752,
			 20.670211, 79.403450, 12.845546,139.520065,117.902542,153.228012, 12.588499,  4.477739,  5.540005,  9.985177,  4.968570,  2.420278, 36.336505,213.040328,199.713989,168.052581,
			203.890487,158.760391,134.421966,165.744201,119.375976,154.407104,107.559242,163.871261,128.801269,109.870132, 88.136940,197.291061,190.398971,158.432266,187.800384,155.933532,
			158.442199,187.332870,166.474700,169.912994,151.947814,130.242401,163.577560,149.014129,161.501724,156.426696,142.160125,155.981201,131.240829, 88.291069,121.652328,138.771896,
			168.694931, 87.543762, 87.256309,173.541931,174.213790,166.399505,140.888870,151.886322,187.903198,174.093978,136.635711,169.040863,138.239074,121.703399,150.733886,146.337646,
			146.678146,157.471008,122.142570, 87.002182,160.541870,128.213958, 89.507598,143.278884, 69.752166,156.454879,127.222175,181.816482,172.167572,172.510177,139.758712,131.228759,
			156.573593,169.879440,138.661056,163.581848,137.205581,112.809173,168.246520,159.116500,155.501266,111.760482,154.559478,169.183135,165.069137,159.124420,100.017700,174.950103,
			134.872039,170.695083,149.982391,163.738220,128.486373,176.835601,145.112625,150.002090,108.869674, 92.140975,120.695243,141.780090,118.148712,147.483078,133.015289,123.942771,
			136.928695,112.984458,137.572448,139.326690, 74.851280,135.339126, 74.477752,124.252822, 76.445114,129.406982, 41.994304, 70.297027, 93.779563,106.303985, 72.277702, 31.483182,
			 50.628826, 18.889406, 18.889406, 18.889406, 18.889406, 18.889406, 18.889406, 18.889406, 23.593776,  5.311795, 59.911453, 79.475837,118.865158,  6.295304, 45.618495,  8.851163,
			 42.641498, 60.310317, 36.210437, 59.594112, 44.418483, 21.916032, 17.995372, 83.366386, 99.963546, 92.824668, 80.773834, 80.230621, 89.098670, 21.106891, 19.297863, 20.646158,
			 15.529696, 16.114126, 71.382995, 15.993920, 25.603780, 14.833462,  8.818386, 21.540107,  6.059095, 25.599224, 21.334878, 25.622690, 25.213653, 11.237965, 17.466447, 18.316850,
			 89.852714, 39.893135,  6.629386, 89.715629,  8.515752, 11.647183, 10.367165,  9.634183, 38.329769, 29.604900, 38.034408, 15.967421,  0.660978,  5.519408, 99.135185, 67.801162,
			 67.801162,  4.160768, 19.952978, 16.673236,  5.362833, 16.916803,  5.362833, 16.447677, 19.851644,  5.362833,  5.362833, 16.446294, 19.851585,  5.362833, 16.652622, 16.917503,
			 19.926290, 16.916885, 19.926002, 11.462434, 11.462434, 80.417144,127.823852, 10.553314,  6.389792, 24.218965, 25.887399, 26.450672, 41.688690,  8.768285,  8.768286,  4.923486,
			  1.891260, 10.023884, 16.580368, 58.183780, 80.883354, 83.304862, 97.701217,  8.064739,129.406982,  1.164945,  3.232225,130.744964,125.628784, 95.549606,121.919494,122.196754,
			 89.936264, 25.064142, 35.467487, 17.895103, 26.782138, 50.572055, 33.494312, 87.780502, 76.149879, 68.861305, 90.872085,103.307037, 16.005596,139.581512, 12.155197, 18.750850,
			 11.655535,  7.945775,  3.991746, 78.055000,  4.328901,  4.330345, 12.289894,  8.496661,  5.615075, 12.635014,  8.197458, 30.420446, 28.631277, 27.030132,141.780090,139.581512,
			181.816482,156.573593,169.879440,172.167572, 64.458892, 95.690155, 90.529579, 92.231819, 72.316581, 69.752166, 72.316581, 95.690155, 90.529579, 92.231819, 80.417144, 80.417144,
			 80.417144, 50.281860, 35.757545, 40.181648, 19.070152, 19.070152, 19.070154, 19.070152, 32.963867, 29.248685,  3.011647, 35.308399,  2.305387, 20.191101,  5.985732, 36.388645,
			 27.212024,118.148712,163.871261,154.407104,128.801269,168.694931,158.442199,163.577560, 87.543762,137.572448,187.332870,149.014129,136.928695,166.399505,140.888870,123.942771,
			166.474700,161.501724, 87.256309, 74.851280,169.912994,151.947814,156.426696,142.160125,155.981201,131.240829, 88.291069, 21.615932, 21.615932, 18.109533, 18.109533, 18.392290,
			 11.406786, 21.513582, 11.406786,127.222175,170.695083,139.758712,172.510177,156.454879,176.835601,137.205581,163.581848,138.661056,112.809173,145.112625,150.002090,108.869674,
			 92.140975,130.242401, 19.250389,134.421966,  3.203116,  4.181365,  9.381808, 27.444658,160.541870,143.278884, 22.740304,155.933532,187.800384,158.432266,190.398971,197.291061,
			158.760391,203.890487,168.052581,199.713989,213.040328, 72.331352,134.277038,115.498832, 44.792560, 62.207862,109.461799,114.134582,120.280921,122.243949,112.219886,104.225151,
			100.353797, 36.336505, 61.645317, 43.602138, 34.103378, 67.740501, 58.800601,110.870216,168.246520,159.116500,165.069137,169.183135,155.501266,159.124420,100.017700,120.695243,
			149.982391,124.252822,134.872039,163.738220,158.842956,128.486373,174.950103,121.652328,112.984458,137.888336,138.771896,111.760482,154.559478,138.239074,121.703399,122.142570,
			111.833641,151.886322, 22.536176, 16.598737, 27.834249, 27.834249, 16.598737, 37.958854, 37.958854, 89.507598,128.213958, 37.739280,153.228012,117.811698, 88.136940,173.541931,
			174.213790,139.326690,133.585815,187.903198,150.733886,117.902542,139.520065, 74.477752,137.068222,174.093978,136.635711,135.339126,146.337646,146.678146,169.040863,157.471008,
			132.609313,158.842956, 28.675558, 10.367165,  9.634183, 12.635014,  5.947363,  5.947363,  5.947356,  5.947356, 30.729564, 16.690149, 16.690216, 16.690216, 30.257656,  8.081675,
			 41.688690, 77.479080, 77.479080, 77.141998, 42.209087, 56.108314, 56.108314, 24.449254, 32.988697, 25.064142, 35.467487, 89.715629, 31.483182, 50.628826, 50.931209, 30.165752,
			 50.572055, 76.445114, 26.782138,  2.547487,  3.222146,  2.221142,  2.811044,  2.841885,  4.074756,  2.885190,  2.201137,  1.966889,  2.647538,  2.437886,  9.167186, 39.532428,
			 11.888804, 12.876858, 31.011631, 19.312496,  8.900134, 12.004409, 22.707017, 47.650638, 27.588254,  6.754788, 18.712505, 21.838823, 11.800823, 17.416484, 18.910743, 24.764593,
			 21.238254, 33.755908, 28.260883, 23.440856, 30.312139, 15.306654,  7.502265,  8.846459,  9.159472, 10.571330, 19.656616, 20.137554, 82.015480, 56.520912, 58.778125, 86.900527,
			 30.257663, 30.257663, 24.218965, 82.253669, 32.276332, 33.437828, 78.551719,119.375976, 12.274090,  9.310843, 12.274090, 46.925075,126.357917,137.642517,137.642517,126.357917,
			127.823852, 21.994232, 15.829504,109.870132, 21.432657,129.291198,140.202987,129.291198,107.559242,140.202987, 20.137554, 68.643081, 69.986259, 21.432657, 87.799087, 54.312381,
			 46.786567, 65.876808, 82.318191, 82.253669, 57.088882, 33.332859, 30.627395, 30.629028, 66.367500, 34.316184, 31.445611, 33.006683, 71.824325, 33.724746, 33.293415, 31.309188,
			 33.845005, 79.128654, 30.700820, 31.143239, 33.958797, 66.614059, 73.408988, 79.403450, 27.444658,131.228759, 87.002182,  9.228363,  1.516091, 27.417577, 16.513729,112.510513,
			 83.733741, 85.155448, 95.349830, 97.518074,108.168205,104.166748, 84.706207, 94.267486, 77.401657, 72.577445, 88.925346,102.298202,165.744201,147.483078,133.015289, 35.491752,
			 22.536176, 36.975959, 40.535892, 12.289894, 75.749107, 68.924629, 17.313259, 23.523431, 14.438954, 18.750850, 11.655535, 12.155197, 16.005596, 24.566211, 76.465347, 17.636852,
			 17.636852, 17.895101, 10.025771, 48.680240, 48.680240,  8.346821, 24.983171,  8.346821, 17.627531,  5.616105,  4.411440,  4.681550,  4.679376, 22.740304,  1.919371,  8.799400,
			 15.165932, 83.919937, 72.967964, 92.987144,114.549224, 82.063468, 75.104202,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 14.577842, 49.134967, 34.946220, 92.706169, 85.369155, 23.976137, 22.815015, 14.577842,
			 18.754964,  9.144953,  9.144706,  9.144772, 45.142307, 33.439796, 78.916610, 36.983463, 54.339149, 54.339221, 93.959800, 31.533878, 23.477262, 33.439796, 36.983463, 54.339225,
			 54.173854, 32.444831, 33.377140, 32.510417, 63.455253, 36.426242, 32.834335, 32.289760, 32.369472, 10.652800, 34.007038, 84.427574,  4.915963,  5.357503, 12.162302,  8.785467,
			 15.999679, 13.378613,  4.977268, 20.370016, 13.378620, 13.378619,198.071746,171.889312,124.349380, 12.038611, 12.038611, 12.038611, 14.217196, 14.215435, 14.216942,  5.093908,
			 34.171432,  8.675122, 17.442907,  8.517373,  8.517304, 17.586009,112.427604,  8.474584, 18.047801, 11.521411, 11.708847, 30.289012, 11.107521, 75.421836, 21.600011, 14.153618,
			 33.870567, 17.584865,  8.160222,137.661468,168.102096, 89.738990,172.436477,159.101562,184.299362,206.949050,235.052978,235.711029,234.187652,178.483703,219.575515,174.920257,
			231.794860,212.710006,212.204025,214.825866,280.450561,198.036071,145.865341,214.018676,254.884262,202.598663,202.552627,208.213928,206.015869,144.895080,214.152206,195.402679,
			227.384246,229.422561,187.883102,180.070144,190.003753,161.515808, 80.932052, 68.019927, 68.943550,150.553970,194.950805,209.034286,169.019378,102.813896,170.054443,150.490127,
			 57.139144,149.320846,178.385955,230.142395,163.241287,166.834030,133.684402,183.859878,217.622421,212.361343,215.280548,185.441528,214.697784,157.925354,145.581497,266.518981,
			188.589202,189.767593,226.176681,200.160919,188.181076,141.792541,178.964309,107.839485,166.304733,190.176071,104.599006,104.599006,114.625144,114.625144,183.151382,183.151382,
			182.104583,182.104583,154.329940,154.329940,178.383850,178.383850,175.313781,175.313781,177.320312,177.320312,136.883316,136.883316,126.839050,126.839050, 97.913024, 97.913024,
			 90.821914, 90.821914,114.772018,114.772018,115.365379,115.365379,115.086990,115.086990,169.248046,169.248046,108.752716,108.752716,103.322113,103.322113,111.694229,111.694229,
			 77.359657, 77.359657, 54.658378, 54.658378, 91.252708, 91.252708,103.888565,103.888565, 95.848503, 95.848503, 95.759468, 95.759468, 93.754570, 93.754570,100.154296,100.154296,
			112.483245,112.483245,101.934150,101.934150,111.094657,111.094657, 89.738990,117.784339, 81.704177, 81.704177, 77.276077, 77.276077, 77.653739, 77.653739, 83.685607, 83.685607,
			 81.561119, 81.561119, 75.026817, 75.026817, 81.470573, 81.470573, 82.935562, 82.935562, 85.591789, 85.591789, 82.179473, 82.179473, 69.605667, 69.605667, 93.456726, 93.456726,
			 87.684783, 87.684783, 76.455085, 76.455085, 69.027244, 69.027244, 89.439720, 89.439720, 86.396499, 86.396499, 88.783050, 88.783050, 84.019882, 84.019882, 82.903861, 82.903861,
			117.274833,117.274833, 95.121231, 95.121231,117.166999,117.166999, 63.460704, 63.460704, 84.211128, 84.211128, 80.884536, 80.884536, 95.253555, 95.253555, 95.812141, 95.812141,
			144.805709,118.508880,102.756256,112.092750,112.092750,101.743812,101.743812, 85.675804, 85.675804, 69.012901, 69.012901,116.808731,116.808731,105.678031,105.678031,122.762802,
			122.762802,151.040222,151.040222, 97.675933, 82.116706, 68.212020, 70.692092, 71.673004, 63.842933, 62.786075, 64.829391, 72.746223, 95.094848, 46.111366,125.969482, 95.266090,
			 79.163085, 78.575660, 12.466051, 35.352542,125.763458,172.950057,130.237411,130.814880,130.814880,147.269241,147.269241, 69.990783,117.784339, 37.073741, 23.830291, 97.675933,
			 78.575660, 79.163085, 95.094848, 72.746223, 64.829391, 62.786075, 63.842933, 71.673004, 70.692092, 68.212020, 82.116706, 24.545831, 20.403257, 20.403257,144.805709,109.055953,
			109.055953,123.823303,123.823303,127.409919,127.409919,118.508880,102.756256, 24.561523,125.763458, 92.706169,112.427604, 78.916610, 33.439796, 49.134967, 33.439796, 54.339149,
			 54.339221, 54.173854, 54.339225, 36.983463, 36.983463, 45.142307, 33.870567, 24.561523, 14.217196, 17.586009, 14.215435, 14.216942, 17.442907, 85.369155,172.436477,159.101562,
			184.299362,235.711029,235.052978,212.204025,214.825866,280.450561,254.884262,214.018676,198.036071,202.598663,145.865341,206.015869,208.213928,144.895080,209.034286,214.152206,
			202.552627,227.384246,229.422561,187.883102,190.003753,212.710006,180.070144,161.515808,150.553970,219.575515,174.920257,234.187652,178.483703,206.949050,230.142395,215.274612,
			163.241287,183.859878,188.589202,189.767593,231.794860,194.950805,200.160919,226.176681,166.304733,188.181076,157.925354,214.697784,141.792541,178.964309,107.839485,137.661468,
			217.622421,145.581497,190.176071,185.441528,215.280548,166.834030,266.518981,133.684402, 68.943550,212.361343,149.320846,178.385955,170.054443,172.950057,102.813896,130.237411,
			150.490127,169.019378,263.198516,159.938232,165.426681,214.469512,191.252822,170.504531,140.259979,199.000030,144.369750, 80.932052,119.508636,146.257858,139.265777,158.661361,
			126.760948,124.126747, 98.009826,136.692764,145.220275, 13.378620, 13.378613, 13.378619,241.692611, 35.352542,274.887359,223.595001,195.339248,202.231018, 34.490341,249.314422,
			217.069976, 12.422706,231.413452,181.429153,297.701110,238.982162,207.320327,231.704605,221.621047,230.201751,174.877578,254.713867,100.276168,125.585899,201.999786,215.274612,
			 33.852622,195.402679,108.486747,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,126.896598, 29.129274, 53.226833, 69.473327,
			102.687713, 59.242168,112.514442,112.133132, 44.860435, 85.565551, 38.849819, 78.736206, 78.736206, 53.287178, 19.283987, 37.125652, 60.995079, 26.010402, 94.560592, 30.813968,
			 41.206649, 20.735240, 13.699237, 21.778699, 92.262001, 56.329711, 25.119321,132.206283, 83.713912, 23.934980,125.085311, 35.050949, 72.338111, 56.984985, 24.191024, 83.728660,
			 28.101686, 27.252323,102.722068, 13.793144, 17.101926, 94.976661, 14.668754, 27.465492, 36.188472, 39.698085, 39.291934, 48.261280, 71.377517, 36.630844, 51.024227, 38.757232,
			 21.391138, 46.612945, 40.248500, 55.206645, 43.621913, 42.462009, 43.541519, 38.333751, 51.986877, 65.096748, 40.271778, 48.973480,  2.041156, 24.141920,  2.610596,121.682456,
			 79.119941, 79.119941,112.514442,126.896598,121.682456, 17.824827, 20.146862, 28.927463, 39.605060, 16.292875, 10.191559,  9.855088, 51.986877, 20.735240,146.560913,145.748016,
			 46.612945, 69.579978, 63.394134, 48.261280, 84.767189, 29.833251, 29.833251, 82.547569, 47.749847, 21.391138,107.629043, 52.711090, 62.308174,110.711029, 49.507804, 53.047504,
			 48.630245, 79.506622, 68.515350, 66.573410, 58.267620, 51.957004, 88.653083,128.913360, 60.659626, 77.020263, 43.870304, 49.550800, 56.391033, 32.407798, 43.697319, 39.781860,
			 34.830257, 44.300552, 43.625011, 88.192787, 58.043357, 40.838539, 36.685161, 41.244274, 35.930492, 62.213989, 57.043663, 35.046684, 54.827739, 27.984497, 53.339565, 46.284934,
			 66.438255, 67.002922, 46.292881, 37.301620, 44.526256, 41.302341, 60.928916, 50.887477, 61.532615, 84.931900, 43.701057, 38.282024, 84.597778, 86.462333, 52.196796, 43.092922,
			 52.597663, 85.206047, 38.547889, 76.600524, 67.106994, 85.325019, 83.554138, 54.717060, 46.893199, 32.273841, 55.475330, 66.415748, 40.719078, 55.458438, 32.282695, 50.475811,
			 39.603179, 36.483253, 33.828033, 31.940584, 71.013633, 72.947196, 84.165679, 87.729866, 73.918609, 89.933593,114.287628,149.418136,197.066925, 63.761718,127.658836, 97.880416,
			107.444641, 68.857681, 45.276515,124.233566, 91.048179,120.273284, 66.694892, 57.063144, 43.082775, 49.903419, 44.632297, 65.974441, 35.574928, 59.095108, 64.461357, 51.863819,
			 72.214370, 19.837028, 14.476573, 13.690284, 45.967266, 38.547889, 50.887477, 59.095108, 66.415748, 60.928916, 54.717060,127.658836, 36.685161, 43.082775, 72.214370, 83.554138,
			 79.506622, 49.550800, 43.870304, 52.711090, 56.391033, 49.507804, 88.653083, 51.957004,124.233566, 91.048179, 44.526256, 67.002922, 39.698085, 45.967266, 58.553264,197.066925,
			 86.462333, 97.880416, 92.262001, 39.603179, 39.291934, 48.973480, 53.287178, 69.473327, 13.699237, 44.860435, 27.252323,112.133132, 55.206645, 65.974441,120.273284, 40.719078,
			 88.192787,146.560913, 32.831962, 40.248500, 65.096748, 38.333751, 94.976661, 38.757232, 36.630844, 39.781860, 24.191024, 71.377517, 41.206649, 30.813968, 37.125652,107.629043,
			 26.010402, 16.292875, 39.605060, 28.101686, 29.129274, 21.778699, 23.934980, 35.050949, 19.837028, 20.146862, 13.690284, 14.476573, 51.024227, 59.242168, 66.438255, 57.043663,
			 35.046684, 27.984497, 53.339565, 54.827739, 43.092922, 43.701057, 46.292881, 37.301620, 35.574928, 46.284934, 84.165679, 89.933593, 87.729866, 73.918609, 38.282024, 52.597663,
			 76.600524, 50.475811, 52.196796, 67.106994, 31.940584, 33.828033, 32.282695, 55.458438,114.287628, 55.475330, 60.659626, 59.973522, 59.973522, 52.628814, 25.378164, 25.378164,
			 15.120206, 15.120206,128.913360,149.418136, 47.835227, 68.515350, 66.573410, 58.267620, 77.020263, 85.206047, 84.597778, 84.931900, 41.302341, 61.532615, 57.063144, 45.276515,
			 44.833042, 62.213989, 41.244274, 35.930492, 40.393257, 65.706253, 65.706253, 70.366867, 48.630245, 53.047504, 62.308174, 32.273841, 46.893199,110.711029, 40.838539, 36.430824,
			 51.863819, 36.430824, 58.043357, 44.882911, 34.830257, 44.300552, 43.625011, 49.903419, 28.855745, 49.605388, 49.605388, 21.880502, 55.015705, 24.726673, 25.588844, 55.015705,
			 24.726673, 53.226833, 32.407798, 25.992286, 38.497337, 25.992286, 52.796516, 93.603897, 25.572765, 84.962905, 58.640769, 70.366867, 52.796516, 84.962905, 25.572765, 85.565551,
			 58.605777, 58.640769, 55.049858, 48.579490, 57.482330, 23.281372, 24.009704, 69.804969, 17.382673, 18.959112, 23.281372, 24.009704, 36.483253, 17.824827, 59.948303, 76.717025,
			 32.831962, 64.461357, 56.984985, 59.899246, 58.553264, 20.636236, 32.327091, 20.636236, 32.327091, 31.979892, 29.916454, 36.810813, 44.632297, 38.870204, 52.263332, 38.870204,
			 35.551082, 77.729728,110.496391, 96.822402, 63.761718, 40.271778, 57.500339, 92.855819, 73.234115, 43.532375, 66.694892, 21.154495, 88.476242, 42.714565, 75.822814, 95.482215,
			 40.393257, 44.833042, 32.174324, 32.174324, 56.329711,  6.666226,  6.464732, 47.835227, 19.418882, 85.325019, 68.857681,107.444641,102.722068, 19.788173, 13.495443, 13.495443,
			 52.364578, 80.456634, 98.762962, 77.736885, 42.621135, 38.550178, 38.591758, 85.964866,127.133354,127.133354, 28.725166, 34.890254, 28.927463, 24.141920,  8.309609,  3.563760,
			  8.309609, 57.500339, 98.773002,102.149551, 64.586463, 71.457092, 30.063377, 72.947196, 71.013633,110.496391, 17.382673, 18.959112, 36.188472, 27.465492, 14.668754, 25.119321,
			  9.585953,  3.152043, 83.728660, 41.808506, 35.857303, 31.195047, 26.795024,  0.000000,107.674011,  0.000000,  4.645613,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  5.333518,  4.141792,  3.983963,  2.833113,  3.789978,  4.081808,  5.488915,  9.249908, 16.655912, 15.812590,  7.397649,  9.395386, 11.596589, 11.534557,  2.521410, 10.045225,
			 14.395891,  8.874782, 22.265007,  9.355244, 16.362371, 10.416424, 11.666609, 14.713353, 15.144112, 13.298737, 13.276427,  6.556750, 17.747043, 12.340793, 24.741006, 15.219662,
			  7.488971, 11.919944, 11.646964, 12.581476, 18.142642,  0.000000, 31.674421,  5.333586, 16.964900, 19.761075, 10.549438, 17.820613,  9.439053,  9.959156,  7.576661,  8.463287,
			  8.404899, 26.900506,  5.333524,  6.587541, 12.077909, 11.824198, 11.187350, 10.298939, 21.093002, 15.507349, 10.522728,  7.108996,  9.179306,  6.537098,  8.050301, 11.980915,
			 13.450371, 25.804845,  0.728129, 12.268757, 12.553763, 11.067089,  5.534605, 21.864042, 16.418153, 12.262438,  5.018544,  5.763449, 12.667849,  4.328796,  5.312366,  3.592598,
			  8.008116,  5.770245,  8.265747,  6.542146,  1.775730,  6.407424,  3.902074,  8.036763,  6.944458, 16.156345,  5.756515, 10.611865, 10.254579,  2.193398,  7.100512, 11.290806,
			 11.325768,  7.611441,  7.562125,  5.598052,  4.783796,  4.658819,  9.348693,  0.000000, 17.790143,  8.985911,  0.000000,  0.000000,  0.000000, 11.241256,  0.000000,  0.000000,
			 11.791826,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 48.885593, 12.970596, 50.019950, 34.793300, 78.862564, 77.801750, 56.355567, 67.705841,
			 27.599140, 34.498153, 39.812030, 36.058090, 31.052627, 57.116069, 73.831092, 36.702072, 10.734358, 43.998188, 14.180707, 13.968375, 13.944031, 14.051020, 60.070743, 50.118480,
			 14.675219, 49.810539, 51.085929, 54.009777, 33.677799, 29.765993, 10.244999, 87.044044,  8.826537,  8.197981, 11.658685, 11.647004,  9.935799, 37.172054, 11.836656,  9.523818,
			 15.047416,  9.492733, 16.690210,  4.938965,  3.138884, 41.925445, 25.544597, 38.784202, 10.708654, 18.579118, 21.967941, 32.725070, 14.186058,  9.165643, 33.469062, 34.323696,
			 34.163978,  6.030190, 10.276920, 14.389384,  6.358369, 18.382705,  5.676217, 16.907911, 16.647499, 23.895708, 25.972654, 18.657958, 58.019615, 41.831138, 60.765792, 41.667617,
			 54.850833, 68.177192,  9.937892,  5.320725, 43.086452, 32.998531, 35.180107, 23.838876, 33.634109, 30.230651, 18.626115,  9.028882, 10.683328, 17.886650, 28.749219, 26.744855,
			 22.711771, 28.850460, 28.482885, 28.182489, 34.280754,110.407882,140.192214,148.107391,139.344711,198.959823,150.171646,183.883987,179.546524,161.056640,184.489990,179.702865,
			174.054718,148.303634,178.849456,143.884002,144.002685,190.565353,131.942840,157.120223,181.820449,137.964721,140.760574,173.935546,211.805175,196.254898,187.039413,169.822860,
			184.305923,170.014999,167.403884,117.034103,162.994476,193.707397,190.044845,144.022964,165.619064,182.849594,177.376907,172.559997,177.164398,175.864242, 96.907379,183.313720,
			175.764160,139.697082,162.974945,169.156173,177.146438,163.201431,171.518310,156.647537,141.912536,144.144943,172.934936,168.998336,142.035980,132.758407,173.533020,166.412261,
			172.319274, 88.741188,150.904983,178.678283,150.410659,141.611282,102.145019,130.769424,132.695678,143.483642,133.399566,110.438499,184.825149, 76.239936,118.326339, 15.639310,
			 22.102399, 68.797866, 93.861701,104.135307,118.120254,123.609741,115.106124, 93.631973,116.141746,146.021530,131.237136,108.221466,118.613357, 70.874176,127.264541,131.867034,
			143.529403,133.666854,160.190383, 78.920425,140.957061, 84.328712,115.098731, 81.443664, 39.072658, 34.621360, 62.231075,118.120254,104.135307, 93.861701, 68.797866,190.565353,
			184.825149,137.964721,123.609741,115.106124,177.376907, 93.631973,116.141746,146.021530,171.518310,131.867034,127.264541,173.533020,178.678283,150.410659,141.611282,102.145019,
			130.769424,143.483642,133.399566, 87.044044,143.529403,133.666854,160.190383, 78.920425,140.957061, 84.328712,115.098731, 81.443664, 39.072658,108.221466,118.613357, 70.874176,
			 51.066894, 38.517009, 35.844230, 43.260147, 29.294588, 20.524194, 17.213739, 21.735954, 36.836170, 23.227769, 13.094282, 49.659248, 12.354524, 57.609642, 12.214465, 22.669300,
			 48.038700, 49.246479, 47.878582,  4.323037,  9.068072, 27.891319, 84.795341, 56.769599, 58.420253, 56.203784, 49.141273, 61.419075, 28.486476, 62.936618, 54.757427, 49.440834,
			 49.552051, 51.984317, 28.328523, 55.747245, 49.009113,175.651824,149.911834,153.801528,101.700592,152.664062, 37.182621, 86.588050, 69.649307, 60.918621, 70.711402, 57.318935,
			 70.737892, 68.625617, 78.103019, 36.484733, 48.045459,126.923538,172.319274,152.664062,150.904983,144.144943, 88.741188,126.923538,141.912536, 86.588050,139.697082, 34.621360,
			 28.244926, 34.793300, 25.972654, 41.925445,177.146438,172.559997,169.156173,117.034103,175.864242, 96.907379,170.014999,167.403884,177.164398,162.974945,163.201431,172.934936,
			168.998336,142.035980,132.758407,140.760574,131.237136, 62.231075, 72.638458, 72.638458, 11.658685, 11.647004,  9.935799, 23.895708, 18.382705, 37.182621, 28.244926, 48.885593,
			 15.047416, 11.836656, 37.172054, 16.647499,  9.523818,  9.492733, 16.690210, 76.239936,  8.197981, 49.246479, 47.878582, 60.918621, 70.711402, 57.318935, 68.625617, 70.737892,
			 36.484733, 78.103019, 69.649307, 48.045459, 18.626115,  9.028882, 10.683328,115.600753, 17.826736,  2.342986, 17.826736, 33.469062, 32.725070, 21.967941, 34.163978, 29.765993,
			 38.784202,132.639602,132.639602, 83.166000, 83.166000,  7.082897,  3.884401, 10.429392,  2.241518,  7.082981,131.942840,196.254898,144.022964,165.619064,187.039413,157.120223,
			179.702865,174.054718,184.489990,161.056640,143.884002,211.805175,144.002685,175.651824,150.171646,169.822860,148.303634,183.883987,148.107391,140.192214,198.959823,110.407882,
			139.344711,179.546524,178.849456,173.935546,190.044845,193.707397,181.820449,184.305923,182.849594,183.313720,162.994476,175.764160,166.412261,132.695678,110.438499,156.647537,
			  8.927382,  3.108602,127.404167,132.877044, 54.968761, 28.966918,168.262039,163.951477,106.573822, 80.261505,114.202835, 59.225780, 32.940181,109.831359, 80.145248,112.779228,
			114.071815, 68.724769,117.826126, 90.160522,111.412254, 54.210861, 72.393562,  0.209959,  0.704405,  0.337523,  0.367707,  0.229640,  0.163803,  0.563681,  0.181293,  0.221281,
			  0.242110,  0.130844,  0.119999, 10.075008,  0.183295,  0.223885,  0.157997,  1.000746,  1.000746,  1.000746,  1.000746,  1.000746,  1.000746,  1.903036,  1.903036,  1.903036,
			 31.891086, 31.891086, 31.891086,  1.414214,  1.414214,  1.414214,  1.414214,  1.414214,  1.414214,  1.414214,  1.414214,  1.414214,  0.086603,  0.086603,  0.086603,  0.086603,
			  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,
			  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,
			  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,
			  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,
			  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.086603,  0.259472, 53.871826, 80.140068,
			158.295883, 88.389762,175.893524,  6.641160,  1.778970,  1.768388,  4.738520, 35.704406, 39.435169, 10.523646,  2.598076,  3.278718,  4.330126,  7.500000,  5.612485,  8.018825,
			 23.088319, 14.129464,100.010002, 25.209333,125.136184,  6.441984,  6.168419,  6.359864,  6.726966, 38.982456, 11.742248, 23.345726, 40.492336, 29.065578, 10.973188, 14.360727,
			 14.361406, 14.361406, 14.464988, 11.456441, 21.633668, 75.452072, 54.984127, 43.649295, 40.977939, 40.977577, 22.204486, 23.374402, 21.890665, 23.633268, 43.815719, 43.817111,
			 45.166603, 40.644073, 14.834145, 75.496971, 75.561683, 75.848533, 76.290061, 40.014137, 26.164136, 26.164136, 28.329833, 28.329833, 62.093254, 62.093254, 33.138648, 43.654674,
			 43.654674, 31.784547, 31.784547, 36.604091, 36.604091, 28.028324, 28.028324, 28.460027, 28.460027, 24.446163, 24.446163, 50.592113,220.762649, 26.164630, 17.526819, 17.494674,
			 15.929808, 28.029373, 24.450389, 64.993309, 26.164136, 17.497661, 15.933247, 28.032007, 28.463520, 24.446163, 26.164630, 86.321548, 86.321548, 69.282035,  0.000000,172.630966,
			  2.191642,  9.039306, 26.112140, 27.639123, 50.592113, 52.073692, 51.092403, 42.003173,  3.840573, 14.360726, 11.700732, 38.067672,  0.000000,  0.000000, 20.027244, 36.073619,
			172.332244,  0.086379,  0.086379,  0.086379,  0.086379,  0.086379,  0.086379,  0.086379,  0.086379,  0.086379,  0.086379,  0.087434,  5.870351, 17.055942, 16.180559,  3.426851,
			  3.295969,100.908073,108.972473,167.537307,189.258422,  1.317394,  2.706393,  1.457738,  1.457738,  4.444225,  0.562368,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,
			  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.154372,  0.177551,
			  0.177551,  0.177551,  0.177551,  0.177551,  0.177551,  0.177551,  0.177551,  0.177551,  0.177551,  0.158853,  0.158853,  0.158853,  0.158853,  0.158853,  0.164711,  0.164711,
			  0.164711,  0.164711,  0.164711,  0.164711,  0.164711,  0.164711,  0.164711,  0.164711,  0.198412,  0.198412,  0.198412,  0.160346,  0.160346,  0.160346,  0.160346,  0.160346,
			  0.202711,  0.202711,  0.202711,  0.193821,  0.193821,  0.193821,  0.193821,  0.193821,  0.164711,  0.137830,  0.137830,  0.175868,  0.175868,  0.175868,  0.175868,  0.175868,
			  0.148076,  0.167787,  0.249803,  0.194566,  0.172451,  0.172451,  0.172451,  0.183594,  0.183594,  0.183594,  0.232381,  0.232381,  0.232381,  0.232381,  0.150833,  0.213379,
			  0.218854,  0.223885,  0.223885,  0.223885, 12.519984, 17.684740, 50.592113, 50.592113, 50.592113, 50.592113, 14.690543, 14.690543, 16.868967, 16.550382, 17.494674, 15.929808,
			 10.514703, 11.422005, 13.312958,  8.112463,  8.949542,  7.733827,100.297370,101.087196,102.649032, 28.571205, 11.700732, 14.177447, 58.254928, 17.693462,  0.113424,  0.113424,
			  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,
			  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.113424,  0.175391,  0.175391,  0.175391,  0.057626,
			  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  0.057626,  1.068873,  1.070070,
			  1.070070,  1.070070,  1.070070,  0.818207,  0.818207,  0.818207,  0.818207,  0.818207,  0.198027,  0.198027,  0.198027,  0.154185,  0.154185,  0.154185, 36.768802, 36.626602,
			 36.278285, 36.676158, 14.361406,  3.840573,  8.080115,  0.164902,  0.388356,  0.388356, 10.075008, 10.075008, 10.075008, 10.075008, 10.075008,  0.130860,  0.547279,  1.231266,
			  1.553846,  3.692986,  0.624157,  0.624157,  0.624157,  0.163691,  0.280086,  0.249803,  0.249803,  0.249803,  0.249803,  0.249803,  0.249803,  0.187555,  0.187555,  0.187555,
			  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,  0.187555,
			  0.187555,  0.735063,  0.735063,  0.735063,  0.735063,  0.735063,  0.735063,  0.735063,  2.829205, 14.142291,  0.571403,  0.354422,  0.357881,  0.479313,  0.357071,  0.369542,
			  0.251767,  0.348343,  0.103316,  0.103316,  0.103316,  0.172517,  0.399740,  0.250910,  0.250910,  0.250910,  0.250910,  0.250910,  0.250910,  0.250910,  0.250910,  0.250910,
			  0.250910,  0.250910,  0.250910,  0.250910,  0.250910,  3.785592, 14.718406,  0.283616,  0.163691,  0.167106,  0.167106,  0.177281,  2.216993,  1.060825,  1.193243,  0.298310,
			  1.060825,  1.060825,  1.060825,  1.060825,  1.542340,  1.141481,  1.542340,  1.542340,  2.337632,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,
			  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.889648,  0.889648,  0.000000,
			  0.197359,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,
			  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,
			  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,
			  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,
			  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.038288,  0.036538, 35.880413,  0.262869,  0.272040,  0.000000,  0.000000,  3.015458, 50.241050,  0.465360,
			  0.120434,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,  0.043301,
			  0.043301,  0.043301,  0.043301,  8.660253,  0.086603, 35.751708,  1.526167,  1.526157,  1.860803,  0.000000,  0.000000,  0.000000,  0.530330,  0.530330,  0.530330,  0.530330,
			118.464736,  7.732339,  0.914187,  0.689185,  3.426851,  0.811348,  0.752785,  0.750789,  1.897426,  4.187153, 94.604118, 78.999458,  0.000000,  3.910346,  0.911871,  1.327056,
			  1.236394,  1.150076,  0.273573,  0.273573, 22.195867, 22.195867, 22.195867, 22.195867, 22.195867, 22.195867, 22.195867,  1.409072, 97.766143,  1.086305,  0.752641,  0.752641,
			  0.266555,  0.266555,  0.066598,  0.207090,  0.520842,  0.335909,  0.317609,  0.313252,  0.493151,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,
			  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  7.127346,
			  7.127346,  7.127346,  7.127346,  7.127346,  7.127346,  7.127346,  7.127346,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,
			  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,
			  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  2.378156,  0.980102,  0.825039,  0.825039,  0.410703,  0.410703,  0.410703,
			  0.410703,  1.674340,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,
			  1.928058,  1.928058,  1.928058,  1.928058,  1.928058,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,
			  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  5.127597,  3.917690,  3.917690,  1.481273,  2.307955,  0.261243,  0.114283,  0.609324,  0.847051,
			  0.390363,  1.678303,  1.897670,  0.306264,  0.529978,  1.555394,  0.141421,  8.096106, 11.070481, 19.581954,  3.108689,  1.436596, 78.354202,142.694854, 18.650285,  0.243265,
			  0.197922,  9.245473,  8.694704, 10.070695,  8.336407,  9.170338,  7.389743,  9.521306,  8.163342, 20.320884, 12.951693, 17.456720, 10.501256, 17.442787, 10.898831, 21.482599,
			 15.537749, 11.652488,  9.180400, 10.493132,  8.544728,  8.897234,  6.925481,  9.456333,  8.002818,  0.089533,  0.172517,  0.399740,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,
			  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000,  0.000000, 31.528610
		},
	/*
		This array lists all the offsets of the collision sphere for all
		objects.  This information is kept in a separate array as it is
		generally less useful than the sphere radius.  It indicates where the
		centre of the collision sphere is relative to the centre of the object,
		a position set to minimise the size of the sphere relative to the
		object.  Note that you can't accurately calculate the exact center of
		the collision sphere without the quaternion rotation of the object, that
		is why this is a separate "stock" array - so it isn't included in the
		compiled code if not used.
	*/
	Float:MODELS_gColOffset[19902][3] =
		{
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.158829,    0.764748,   12.944106},
			{  -0.232118,    0.738188,   17.653514}, {   0.345061,    0.516901,    8.748017}, {  -0.074455,    0.793309,    6.517646}, {  -7.159062,   -4.916714,   11.670828}, {  -0.006663,    0.579263,   18.676588}, {  -0.523054,    0.911939,   15.426088}, {   2.091166,   18.181409,   18.417232}, {   1.325175,   11.382722,   11.572793},
			{  -0.218787,    0.119663,   14.241607}, {  -1.946172,    0.038472,    1.776697}, {   0.004335,    0.001074,    0.006235}, {   0.001777,    0.006852,   -0.016382}, {   0.011551,    0.020614,    0.006386}, {  -1.950261,    0.031197,    2.297243}, {   0.002472,    0.003021,    0.002256}, {   0.004124,    0.004199,    0.002625},
			{  -0.971728,    0.025690,    0.928327}, {   0.004889,    0.006163,    0.006238}, {  -1.947448,    0.033498,    4.573216}, {   0.007170,    0.003277,   -0.008170}, {   0.006138,    0.004887,   -0.009161}, {   0.008728,    0.006461,    0.003496}, {   0.016800,    0.043085,    0.023770}, {   0.005652,    0.002709,    0.000069},
			{  -0.006635,    0.018205,    0.023770}, {   0.076883,    0.201382,    6.560653}, {  -0.000044,    0.004176,   -0.017589}, {   0.126747,   -0.376078,    0.026471}, {   0.241633,   -0.001881,    1.609418}, {   0.020294,    0.043147,    9.073236}, {   0.007302,    0.000668,   -0.010150}, {   0.012664,    0.010627,    0.006738},
			{ -12.149656,   -7.321660,   19.999521}, {   0.009398,    0.012818,    2.594803}, {  -0.082897,   -0.105778,    2.415149}, {  -0.003412,    0.014093,    1.728834}, {   0.010315,    0.008361,    8.954498}, {  -0.217341,   -0.269452,    3.968547}, {   0.011199,    0.008437,   10.889255}, {   0.008728,    0.001311,    6.381939},
			{   0.005857,    0.003996,   12.286366}, {   0.012481,    0.012725,    4.616199}, {   0.012923,    0.008299,   13.563719}, {   0.010238,    0.008407,    7.130677}, {   0.009612,    0.012206,    6.668138}, {   0.684283,    0.232391,    9.280516}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.003023,    0.006899,   24.903144}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  -0.524667,   -0.390574,    8.232645}, {   0.271400,    0.254265,   23.927829}, {   0.146681,   -0.838127,    3.709105},
			{  -0.234530,   -1.305938,    5.754034}, {   0.313214,    0.031922,    6.763473}, {   0.228477,    0.127354,    3.028826}, {   0.004943,    0.005719,    0.002289}, {  -0.267663,    0.183972,    1.724145}, {   0.008759,    0.004807,    0.424800}, {   0.006194,    0.004788,    0.337567}, {   0.002471,    0.004790,    0.756923},
			{   0.156939,   -0.076342,    2.914715}, {   0.031915,    0.063598,    1.709630}, {   0.017785,    0.003295,    0.920140}, {  -1.358258,   -2.383440,   13.310283}, {  -0.131637,   -0.172399,   -0.068998}, {   0.210619,    0.285239,   11.834240}, {   0.111946,    0.105703,   10.881944}, {   0.209856,    0.285239,   13.436294},
			{  -0.695228,   -1.996369,   11.655085}, {   0.356741,    0.159265,   22.877998}, {   0.915690,    0.798286,   23.619640}, {  -0.699401,   -0.518615,   10.874113}, {   0.008515,    0.004782,    0.458427}, {   0.049596,    0.982581,   34.594844}, {   2.701350,    0.099941,   36.487751}, {  -0.648847,   -4.148507,   23.767883},
			{   0.473807,    0.638500,   23.872081}, {   0.477378,    0.638500,   27.466821}, {   0.246129,    3.235028,   18.817625}, {   0.000000,    0.000000,    0.000000}, {  -0.104967,   -0.054111,    8.153743}, {   0.006492,    0.001369,    0.005274}, {   0.010390,    0.003047,    0.004939}, {  -1.748461,   -0.518615,    8.559812},
			{   0.407727,    0.377418,   40.043285}, {  -3.709948,   -1.090033,   18.454154}, {  -0.112539,   -5.040275,   21.487834}, {   0.678910,   -4.004501,   18.194475}, {  -1.253021,   -0.930226,   19.742275}, {   8.382987,    1.130401,   28.705739}, {  -0.684123,    0.670651,    0.471035}, {  -0.340229,    0.345856,    0.300386},
			{  -0.556899,    0.552623,    0.490105}, {  -3.708117,   -1.097218,   18.386735}, {   3.012047,   -1.858330,   19.257596}, {   0.004211,    0.008689,   -1.494060}, {   0.005005,    0.004029,    8.901801}, {   0.317425,    0.030742,    6.665237}, {  -0.342243,    0.343735,    6.380500}, {   0.014545,    0.002488,   48.401763},
			{   0.010695,    0.004697,   40.882495}, {   0.009855,    0.009352,   76.362533}, {   0.007650,    0.012074,   47.728302}, {   0.234751,    0.008228,   41.282989}, {   0.532119,    4.341591,   52.876083}, {   0.011532,    0.013759,   40.881381}, {  -0.989598,    1.603919,   16.639894}, {  -0.152862,   -0.158563,   11.795292},
			{  -0.516878,    0.084486,    1.736821}, {   0.093786,    0.302814,   10.651711}, {  -0.316729,    0.095821,   13.255284}, {   0.754593,   -0.682648,   24.918828}, {  -0.018562,    0.243926,   10.328463}, {  -0.428961,   -0.647014,   15.315883}, {   1.102614,   -0.524704,   16.877344}, {   0.612869,    0.036864,   24.872976},
			{   0.165013,    0.060911,    0.001112}, {   0.273449,   -0.045949,    5.648375}, {   0.274857,    0.092289,    4.426301}, {   0.009552,    0.017720,   36.719669}, {  -0.911929,    1.206851,   39.233505}, {   0.009093,   -1.623512,   -0.038038}, {   0.001958,    0.004497,    0.221631}, {   0.004242,    0.007751,    0.005036},
			{  -0.017669,    0.094155,    2.246886}, {  -0.318841,    0.132002,    1.215983}, {   0.144069,   -0.091526,    0.634181}, {  -0.425049,    0.072862,    0.559289}, {   0.005756,    0.013643,    0.272646}, {  -0.409233,   -0.137004,    3.313374}, {   0.195143,    0.095150,    2.157413}, {   0.016191,    0.092486,    2.368264},
			{  -0.313508,    0.125185,    1.271635}, {  -0.063931,    0.056030,    0.333306}, {   0.025738,   -0.085579,    0.587857}, {   0.061753,    0.061190,    0.333308}, {   0.072162,    0.011238,    0.390608}, {   0.060456,    0.006285,    0.856585}, {  -0.640439,    0.135633,    1.067695}, {  -0.024174,   -0.042176,    1.113242},
			{   0.074380,   -0.142930,    0.822736}, {  -0.053185,   -0.196379,    0.550087}, {   0.011842,    0.007654,    0.006738}, {  -0.034867,   -0.226077,    8.594738}, {  -0.422125,    0.561971,   12.843948}, {  -0.065963,   -0.228230,    3.733016}, {  -0.068751,    0.384599,   10.819830}, {   1.279587,    1.940361,   12.094094},
			{   1.764893,    0.512727,   10.793298}, {   0.916441,    0.358267,    9.597204}, {   0.045196,   -0.129871,    8.399830}, {   0.119120,   -0.101815,   16.699531}, {   1.537474,    1.354025,   13.117712}, {  -2.126161,   -0.169529,   11.183879}, {  -4.696114,   -3.272228,   11.241467}, {   0.861527,   -2.508086,    7.960834},
			{   0.630909,    0.258626,    9.340770}, {   0.338582,   -0.223316,   16.527351}, {   0.724032,    0.633798,    6.146158}, {   0.025555,   -0.060926,    3.915504}, {  -2.200840,   -1.531977,    5.267065}, {   0.407718,   -1.176072,    3.729959}, {   0.605286,    0.909852,    5.662734}, {   8.229469,    1.107072,   28.799161},
			{   2.701350,    0.099941,   36.487751}, {   1.059713,    2.510015,   57.069690}, {   0.003707,    0.185636,   40.912628}, {  -0.117173,    0.117187,   48.645961}, {   1.058738,    4.087181,   53.080162}, {   0.000461,    0.000176,    0.018927}, {  -3.054969,   -5.357461,   27.092279}, {   1.059713,    2.510015,   57.069690},
			{   0.234687,    0.070274,    3.072782}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.007724,    0.012622,    0.004563}, {   0.012532,    0.010107,    1.805585}, {   0.008907,    0.005876,    0.004778}, {   0.008392,    0.005150,    0.000972}, {   0.009200,    0.011947,    0.004695}, {   0.007170,    0.005452,    0.000180}, {   0.010987,    0.003469,    0.006823}, {   0.000257,    0.005340,    0.012937},
			{   0.001118,    0.005125,    0.000898}, {   0.007538,    0.007021,    2.171977}, {   0.005783,    0.009577,    0.447174}, {   0.006788,    0.012570,    0.004695}, {   0.007751,    0.004205,    0.000101}, {   0.008422,    0.011133,    0.000101}, {   0.003386,    0.010363,    0.000101}, {   0.825073,    0.712197,    2.238430},
			{   0.002842,    0.002630,    0.012924}, {   0.008481,    0.005303,    0.007776}, {   0.006827,    0.006781,    0.006823}, {   0.007856,    0.004430,    0.371618}, {   0.000043,    0.006378,    1.663769}, {   0.008404,    0.006047,    0.007596}, {   0.013531,    0.000913,    0.004430}, {   0.009852,    0.015511,    0.010634},
			{   0.003760,    0.011907,    0.007596}, {   0.012152,    0.013574,    0.007596}, {   0.003944,    0.007637,    0.007596}, {   0.007042,    0.012786,    0.006823}, {   0.006878,    0.007708,    0.009379}, {   0.006403,    0.004255,   -0.445479}, {   0.005597,    0.007338,   -0.747545}, {   0.002314,    0.001555,   -0.508561},
			{   0.007706,    0.004844,   -0.449353}, {   0.005433,    0.007211,    0.014800}, {   0.000667,    0.002578,   -0.710155}, {   0.001732,    0.004745,   -0.145089}, {   0.002315,    0.000591,   -0.051392}, {   0.005361,    0.007195,   -0.262441}, {   0.004780,   -0.072034,   -1.044024}, {   0.107552,    0.026799,   -0.477162},
			{   0.000157,    0.002828,   -0.231296}, {   0.003026,    0.004623,    0.003406}, {   0.001521,    0.000882,    0.000990}, {   0.006060,    0.004997,   -0.305298}, {   0.000548,    0.157116,   -0.511094}, {   0.001703,    0.000045,    0.005398}, {   0.007710,   -0.004585,   -0.227641}, {   0.000155,   -0.131099,    0.018389},
			{   0.001980,    0.005044,   -0.284202}, {   0.006459,    0.002236,    0.002741}, {   0.003533,    0.005754,    0.003222}, {   0.001902,    0.003969,    0.003996}, {   0.141865,   -0.070564,    0.323044}, {   0.000847,    0.004902,    0.005125}, {   0.035023,   -0.017550,    0.007577}, {   0.006554,    0.004095,    1.967761},
			{   0.081371,   -0.079359,    1.395499}, {   0.111316,    0.277350,    0.218750}, {  -0.262811,    0.179139,    2.039010}, {   0.012908,    0.011096,    0.424800}, {   0.010346,    0.011078,    0.337567}, {   0.006622,    0.011079,    0.756923}, {   0.021935,    0.009585,    0.920140}, {   0.065903,    0.067479,    0.333308},
			{  -0.091182,   -0.338865,    0.970534}, {  -0.094433,   -0.345896,    0.719211}, {  -0.088054,   -0.339248,    0.766575}, {   0.385948,    0.824240,   -0.091530}, {   0.001786,    0.077522,    0.018544}, {   0.007344,    0.003073,    0.007141}, {   0.004060,    0.007029,    0.000364}, {   0.003657,    0.001753,    0.003601},
			{  -0.252492,   -0.286224,    3.428023}, {   0.007199,    0.008247,    0.007414}, {   0.000743,    0.004594,    0.007414}, {   0.006740,    0.007108,    0.007414}, {   0.003510,    0.006800,    0.007414}, {   0.009287,    0.003285,    0.007414}, {   0.003127,    0.014259,    0.007414}, {  -1.234467,    1.374544,   -0.548618},
			{   1.395066,    1.173014,   -0.299385}, {   0.019757,    0.076228,    3.217957}, {  -0.011505,   -0.099854,    3.812103}, {  -0.115999,    0.159496,    3.571047}, {  -0.060196,   -0.224028,    3.733300}, {  -0.032839,    0.195497,    5.317728}, {   0.417340,    0.630526,    3.921582}, {   0.552718,    0.159003,    3.353699},
			{   0.298186,    0.118588,    3.056879}, {   0.030148,   -0.073243,    4.821919}, {   0.541319,    0.475847,    4.607178}, {  -0.732990,   -0.058159,    3.858268}, {   0.223866,    0.094876,    3.275609}, {   0.459174,    0.396465,    3.849369}, {  -1.267529,   -0.878863,    3.041018}, {   0.307817,   -0.867425,    2.757827},
			{   0.064622,   -0.719048,   -1.297145}, {   0.077889,    0.735049,    0.223322}, {  -0.256859,   -1.322515,   -1.634613}, {   1.354467,   -0.261774,   -1.568055}, {   0.133903,    1.115782,    0.513853}, {   0.068972,    0.663358,    0.499399}, {   0.106536,    0.007366,    0.366461}, {   8.413302,    4.941617,    1.270156},
			{   0.030603,    0.060922,    1.708628}, {  -0.055215,    0.204812,   -0.062164}, {   1.302477,    0.270244,   -0.299385}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.018388,    0.017029,    0.007222}, {   0.017343,    0.018458,    0.006566},
			{   0.018473,    0.018386,    0.006566}, {   0.019609,    0.015884,    0.006318}, {   0.023411,    0.017295,    0.007507}, {   0.023757,    0.016455,    0.002809}, {   0.019347,    0.013841,    0.006051}, {   0.023307,    0.009788,    0.003863}, {   0.022753,    0.012443,    0.003865}, {   0.025281,    0.016456,    0.002809},
			{  -0.166016,    0.022655,    0.061080}, {   0.018893,    0.021090,    0.001286}, {   0.013915,    0.017866,    0.005495}, {   0.018157,    0.016225,    0.006376}, {   0.019316,    0.018349,    0.006455}, {   0.006539,    0.011950,    0.004445}, {   0.016233,    0.017053,    0.004823}, {   0.016102,    0.020369,    0.002693},
			{   0.020569,    0.013752,    0.000533}, {   0.017669,    0.017962,    0.001190}, {   0.010525,    0.017691,    0.007772}, {   0.010293,    0.011950,    0.004445}, {  -0.157746,   -0.057780,    0.523746}, {   0.025304,    0.014755,    0.508984}, {   0.017180,   -0.019160,    0.000211}, {   0.023840,    0.018610,    0.012412},
			{   0.011464,    0.020192,    0.000413}, {   0.010057,    0.017566,    0.000411}, {   0.022568,    0.016906,    0.016240}, {   0.003821,    0.009871,    0.029752}, {   0.021546,    0.013470,    0.003161}, {   0.254503,    0.017566,    0.000411}, {   0.006064,   -0.035677,   -0.509617}, {   0.014712,    0.006705,    0.004656},
			{   0.018249,    0.010110,   -0.161844}, {   0.009139,    0.009740,   -4.222157}, {   0.011195,    0.009766,    0.007478}, {   0.008559,    0.011107,    0.007478}, {   0.006967,    0.017681,    0.772903}, {   0.015550,    0.020601,    0.007885}, {   0.032584,    0.044038,    0.007338}, {   0.014957,    0.029183,    0.009421},
			{   0.002481,    0.025892,   -0.229558}, {   0.002791,    0.026410,    0.037234}, {   0.000745,    0.002973,    0.005981}, {   0.004803,    0.001235,    0.696810}, {   0.006004,    0.001235,    0.696810}, {  -0.000945,    0.000591,   -0.525138}, {   0.005717,   -0.011637,    0.005237}, {   0.011660,    0.022523,    0.009039},
			{   0.012311,    0.002453,    0.009429}, {   0.012311,    0.002453,    0.098107}, {  -0.068750,   -0.233550,    0.209830}, {  -0.066835,   -0.233550,    0.209830}, {  -0.000380,    0.003832,    0.482868}, {   0.000000,    0.000000,    0.000000}, {  -3.379065,    0.004478,    0.500000}, {   0.004838,    0.004966,    1.342664},
			{   0.028269,    0.004478,    3.503861}, {   4.305995,    0.005278,    1.509529}, {   0.000132,   -0.004435,    0.001568}, {   0.001307,   -0.006628,    0.007081}, {   2.755431,    2.115156,    3.668066}, {   0.003655,   -0.093253,   -0.186538}, {   0.007755,    0.004364,    0.001411}, {   0.001308,    0.006436,    0.001718},
			{   4.302595,    0.006972,    1.514497}, {   0.977851,   -0.194618,    0.001717}, {   0.003655,   -0.075517,   -0.186538}, {   0.003655,   -0.088959,   -0.186538}, {   0.006862,    0.002146,    0.003647}, {   0.004025,    0.003052,    1.293766}, {   0.001762,    0.003796,    0.000096}, {   0.001637,    0.007108,    0.000096},
			{   0.006653,    0.005836,    0.046971}, {   0.005402,    0.000243,    1.899795}, {   0.008717,    0.000243,    1.899795}, {   5.946809,    0.165885,    3.101296}, {  -0.053525,    0.009162,    1.547729}, {   0.007023,    0.005071,    0.004823}, {  -0.048702,   -0.013216,    0.074684}, {   0.003222,    0.004298,    0.000518},
			{   0.006198,   -0.026776,    0.048615}, {   0.009135,    0.183569,   -0.128571}, {   3.145832,    0.003284,    0.473728}, {   1.766911,   -0.218121,    0.008871}, {   3.425424,    0.003281,   -0.174710}, {   1.620849,    0.003674,    0.473726}, {   4.299259,   -0.221453,    0.002490}, {   0.000000,    0.000000,    0.000000},
			{  -0.000022,   -0.081740,    0.066993}, {   0.000000,    0.015724,    0.157734}, {   0.000000,   -0.075654,    0.087365}, {   0.000000,    0.015625,    0.140753}, {   0.000000,    0.000000,    0.034067}, {   0.000000,    0.000000,    0.060143}, {   0.000000,   -0.086809,    0.030051}, {   0.000000,    0.000000,    0.000000},
			{   0.045646,    0.001764,    0.081670}, {   0.000000,    0.000000,    0.051766}, {   0.000000,    0.000000,    0.051734}, {   0.000000,    0.000000,    0.026737}, {   0.000000,    0.000000,    0.052462}, {   0.003415,    0.000000,    0.007813}, {   0.000000,   -0.075653,    0.087365}, {   0.000799,   -0.075690,    0.087557},
			{  -0.000096,   -0.075690,    0.087557}, {   0.005125,    0.000000,    0.000000}, {   0.006998,   -0.945879,    0.019921}, {   0.006998,   -0.896969,    0.001771}, {   0.003940,   -0.908456,    0.002220}, {   0.003654,   -0.896969,    0.002220}, {   0.003654,   -0.888738,    0.002220}, {   0.000000,    0.015724,    0.157734},
			{   0.005375,    0.004745,    0.000000}, {   0.000000,    0.004311,    0.007625}, {  -0.024420,    0.935525,   -0.008008}, {   0.031083,    0.935525,   -0.008008}, {   0.007098,   -1.760957,   -0.371430}, {   0.011606,   -1.749714,   -0.368272}, {  -0.003362,    0.935526,    0.007242}, {   0.009661,    0.935526,    0.007242},
			{   0.000000,   -0.389129,   -0.525909}, {   0.000000,   -0.389129,   -0.525909}, {   0.001166,   -1.686761,   -0.416447}, {  -0.004124,   -0.094888,   -0.488166}, {   0.025840,    0.014042,   -0.078458}, {  -0.002901,   -1.747678,   -0.405550}, {  -0.003219,   -0.094888,   -0.488166}, {   0.006560,    0.009161,    0.007063},
			{  -0.021882,    0.014042,   -0.078458}, {   0.002972,    0.009161,    0.007063}, {   0.004894,    0.005568,    0.000891}, {  -0.443071,   -0.255221,    0.031090}, {   0.004751,   -0.255221,    0.031090}, {   0.002694,   -1.520771,   -0.359627}, {   0.002664,   -1.493244,   -0.365262}, {  -0.032483,    0.056710,    0.088688},
			{   0.042729,    0.077289,   -0.039117}, {   0.004191,   -0.054643,    0.046369}, {   0.002791,   -0.035691,    0.027681}, {   0.038095,    0.056710,    0.088688}, {  -0.037340,    0.077289,   -0.039117}, {   0.000075,   -0.098774,   -0.443621}, {  -0.000445,   -0.098774,   -0.443643}, {  -0.000491,   -1.004474,   -0.415223},
			{  -0.000445,    0.005925,   -0.009507}, {   0.007156,    0.005925,    0.006870}, {   0.007317,    0.000479,    0.003849}, {   0.001294,   -2.080616,   -0.528423}, {   0.001295,   -0.102023,    0.062994}, {  -0.000486,   -1.004474,   -0.415574}, {   0.005104,    0.005925,   -0.009507}, {   0.003113,    0.005925,    0.006870},
			{   0.002087,   -2.079138,   -0.551123}, {   0.004459,   -1.725013,   -0.371380}, {   0.008582,   -1.738214,   -0.386162}, {   0.000699,    0.473302,   -0.468124}, {   0.001374,    0.473302,   -0.468124}, {   0.022672,    0.904861,    0.051440}, {  -0.006211,    0.904604,   -0.010001}, {  -0.015343,    0.904861,    0.051440},
			{   0.020407,    0.904604,   -0.010001}, {   0.000452,    0.000000,    0.000000}, {   0.002675,    0.000000,    0.000000}, {   0.002002,    0.000000,    0.000000}, {   0.011958,    0.002848,    0.000000}, {   0.012659,    0.002848,    0.000000}, {   0.013222,    0.005555,    0.000000}, {   0.020571,    0.000000,    0.000000},
			{   0.010238,    0.005187,    0.000000}, {   0.032033,    0.002255,    0.000000}, {  -0.007034,    0.002644,    0.000000}, {   0.002094,    0.002848,    0.000000}, {   0.005204,    0.001634,    0.000000}, {  -0.000775,    0.002644,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{  -0.001416,   -0.290996,   -0.506455}, {   0.001601,   -1.966881,   -0.358155}, {   0.007240,    0.012962,    0.004798}, {   0.008454,   -0.290996,   -0.506455}, {   0.011101,   -1.955358,   -0.349155}, {   0.050229,    0.013426,    0.022980}, {   0.006479,    0.012962,    0.004798}, {  -0.038302,    0.013426,    0.022980},
			{  -0.000972,    0.007046,    0.000000}, {  -0.002578,    0.000000,    0.000000}, {   0.005950,    0.000000,    0.000000}, {   0.002730,    0.005568,    0.000891}, {   0.013860,    2.941505,   -0.065154}, {   0.001841,    0.007238,    0.004867}, {   0.005936,   -0.399295,    0.012574}, {   0.006804,   -1.649991,    0.287191},
			{   0.000000,   -0.830735,    0.003682}, {   0.000000,   -0.830735,    0.000980}, {   0.007185,   -0.207753,    0.004025}, {   0.006943,    0.005375,    0.002409}, {   0.000867,    0.005375,    0.002410}, {   0.000360,    0.009638,   -0.019032}, {   0.000000,   -0.277256,    0.311219}, {   0.006393,   -0.113052,    0.053038},
			{  -0.061804,   -0.116172,    0.052999}, {   0.060704,   -0.551010,    0.078846}, {  -0.009507,   -0.551010,    0.038327}, {   0.006393,    0.065571,    0.289057}, {   0.006393,    0.045749,    0.286451}, {   0.006393,    0.006889,    0.012302}, {   0.013015,    0.406275,   -0.103630}, {   0.873427,    0.746035,    0.030848},
			{  -0.004937,    0.406450,   -0.103630}, {   0.007484,   -1.172369,    0.004176}, {   0.001464,    0.007238,    0.003182}, {   0.008034,    2.934098,   -0.148282}, {  -0.004585,   -0.207753,    0.004025}, {   0.001236,    0.027953,   -0.132001}, {   0.003347,   -2.212981,   -0.470357}, {   0.002368,   -2.217355,   -0.480179},
			{   0.006804,   -0.805050,    0.396362}, {  -0.617187,   -0.161706,    0.035893}, {   0.007811,   -0.709590,    0.621901}, {   0.007757,   -0.709590,    0.637709}, {  -0.617187,   -0.161706,    0.038405}, {   0.009688,   -0.399295,    0.012574}, {   0.013829,    0.002146,    0.004604}, {  -0.009170,   -0.356049,    0.039852},
			{   0.036967,   -0.357219,    0.047442}, {   0.001750,    0.002146,    0.004604}, {   0.007726,    0.160337,    0.146320}, {   0.011606,    0.019775,    0.159747}, {   1.053408,   -0.401486,   -0.244499}, {   1.052968,   -0.416848,   -0.270112}, {   0.011433,    0.022440,    0.016839}, {   0.005925,    0.021538,    0.016839},
			{   0.005716,    0.000000,    0.016839}, {   0.000000,    0.000000,    0.016839}, {   0.003454,    0.007911,    0.009331}, {   0.002247,    0.058207,    0.025088}, {  -1.056265,   -0.432034,   -0.285308}, {  -1.050073,   -0.457751,   -0.286909}, {   0.947975,   -0.238105,   -0.190889}, {   0.948005,   -0.220732,   -0.205831},
			{  -0.942619,    0.328411,   -0.195252}, {  -0.937811,    0.351002,   -0.209248}, {  -1.086508,   -0.540329,   -0.266355}, {   1.056774,    0.509516,   -0.279787}, {  -1.086508,   -0.524224,   -0.241943}, {   1.054229,    0.436614,   -0.254739}, {   0.007300,    0.106532,    0.132779}, {  -1.076563,   -0.394986,   -0.190744},
			{   1.095311,    0.544961,   -0.160853}, {  -1.073600,   -0.373809,   -0.200561}, {   0.001562,    0.201046,    0.084701}, {   0.007880,    0.004848,    0.013860}, {   0.003715,    0.102366,    0.002022}, {  -1.035925,    0.439236,   -0.280146}, {  -1.029075,    0.487812,   -0.287061}, {   1.071913,   -0.436425,   -0.262847},
			{   1.065444,   -0.451498,   -0.270974}, {  -1.069278,    0.507745,   -0.274538}, {  -1.066447,    0.457013,   -0.242860}, {   1.032994,    0.471653,   -0.257957}, {   1.029140,    0.406379,   -0.260538}, {   1.098274,    0.525161,   -0.132514}, {   0.913854,    0.003457,    0.031626}, {   0.913854,    0.003457,    0.031626},
			{   0.913854,   -0.032427,   -0.014882}, {   0.913854,   -0.073637,   -0.009810}, {   0.937251,   -0.026209,    0.095444}, {  -1.015848,    0.034667,   -0.021018}, {   0.922785,   -0.026209,    0.018535}, {   0.913055,    0.017571,    0.001618}, {   0.913055,    0.015697,    0.043363}, {   0.913055,   -0.026995,    0.001857},
			{   0.913055,   -0.012033,    0.027788}, {  -1.015432,    0.034667,    0.047097}, {   0.906250,   -0.041834,    0.031709}, {   0.906250,   -0.033580,    0.017178}, {  -0.898437,    0.065440,    0.096735}, {  -0.898437,    0.061122,    0.067942}, {   0.914062,    0.076451,   -0.068147}, {   0.914062,    0.076451,   -0.068147},
			{  -0.898437,   -0.058256,    0.055431}, {  -0.898437,   -0.068640,    0.055431}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.194168,   -0.124485,   -0.021180},
			{   0.000069,    0.007280,    0.455720}, {   0.000655,    0.003957,    1.100000}, {   0.004689,   -0.062811,    0.036851}, {   0.008384,    0.012626,    0.009460}, {   0.005671,    0.006537,    0.037500}, {   0.034260,    0.004193,   -0.028103}, {   0.012622,    0.012145,    0.682578}, {   0.016814,    0.013106,    0.055723},
			{   0.021490,    0.072563,    0.224379}, {  -0.002818,    0.023680,    0.259972}, {  -0.000468,    0.027087,    0.189613}, {   0.007842,    0.005934,   -0.006914}, {   0.005154,    0.001931,   -0.001789}, {  -0.025010,   -0.008007,   -0.000399}, {   0.003498,    0.023342,    0.205238}, {   0.383415,    0.024731,    2.596402},
			{   0.013569,    0.026290,   -0.000192}, {  -0.004786,    0.038090,    0.196061}, {  -0.021358,    0.156234,    0.193184}, {  -0.006787,   -0.006041,    0.010238}, {   0.009112,    0.027512,    0.008933}, {   0.021237,    0.004668,    0.000000}, {   0.007284,    0.009963,   -0.007151}, {   0.083939,    0.000888,    0.202887},
			{   0.008183,    0.000888,    0.249932}, {  -0.003916,    0.005836,   -0.113854}, {  -0.009045,   -0.084954,   -0.209950}, {   0.000373,    0.022401,   -0.020966}, {   0.018743,   -0.000612,    0.014169}, {  -0.012289,    0.023685,    0.681786}, {   0.005475,    0.014875,    0.095090}, {   0.014476,    0.005965,    0.005530},
			{   0.005859,    0.001730,    0.003934}, {   0.007710,    0.003074,    0.003107}, {   0.008097,   -0.071097,   -0.016982}, {   0.001763,    0.001122,    5.971961}, {   0.036499,    0.023327,    0.053103}, {   0.073196,   -1.010043,    0.062453}, {   0.006967,    0.004736,    0.013083}, {   0.001396,    0.007799,    0.001484},
			{   0.006529,    0.002846,    0.000335}, {   0.003094,    0.005692,   -1.351331}, {   0.001501,    0.002193,    0.006091}, {   0.003893,    0.058120,    0.002522}, {   0.005036,    0.021120,    0.004354}, {   0.003146,   -0.003864,    0.001676}, {   0.003055,    0.060594,   -0.027315}, {   0.012478,    0.016966,    0.004902},
			{   0.007321,    0.010025,    0.000759}, {  -0.076158,    0.010127,    0.056717}, {   0.004325,    0.010537,    0.028814}, {   0.009277,   -0.020248,   -2.997322}, {   0.003756,   -0.011040,   -1.939349}, {   0.006643,    0.008206,   -3.364835}, {  -0.063933,   -0.058192,    0.003996}, {   0.003709,    0.011531,    0.002543},
			{   0.009207,   -0.049802,   -0.028665}, {   0.017488,    0.023468,   -0.113025}, {   0.003756,   -0.011040,   -1.939349}, {   0.006643,    0.008206,   -3.364835}, {   0.009277,   -0.020248,   -2.997322}, {   0.009476,    0.010803,   -0.005710}, {   0.003891,    0.005437,   -0.087774}, {   0.002855,   -0.006056,    0.000000},
			{   0.006728,    0.001862,    0.005530}, {   0.004627,    0.001862,    0.005530}, {   0.001305,    0.005483,    0.005530}, {   0.003657,    0.004931,    0.005530}, {   0.059177,    0.004583,   -0.058554}, {  -0.012407,    0.006831,   -0.005330}, {   0.007050,    0.096775,    0.000941}, {   0.000701,    0.002398,    0.103596},
			{  -0.039312,    0.022491,    0.007490}, {   0.007431,    0.004625,    0.289061}, {   0.005863,    0.033624,    0.034883}, {  -1.033826,    0.015030,    0.135138}, {  -1.742398,    0.225066,    0.025136}, {   0.024689,    0.035130,   -0.000192}, {   0.018844,    0.035130,   -0.000192}, {   0.020134,    0.035130,   -0.000192},
			{   0.023636,    0.035130,   -0.000192}, {   0.020943,    0.035130,   -0.000192}, {   0.010940,    0.005958,    0.173743}, {   0.010701,    0.031265,    0.205195}, {   0.031459,    0.000011,    0.149335}, {   0.000881,   -0.039505,    0.010116}, {   0.176560,    0.012176,    0.207038}, {   1.332566,    0.475428,    0.012570},
			{   1.236515,    0.431046,   -0.141361}, {   0.045533,    0.003534,    0.183948}, {   0.058614,    0.004794,    0.000000}, {   0.557578,    0.564778,    0.455722}, {   0.009983,    0.006808,    0.284393}, {   0.004854,    0.002475,    0.626911}, {   0.008464,    0.007275,    1.100000}, {   0.198781,    0.133792,    0.170940},
			{  -0.251284,    0.033509,   -0.100838}, {  -0.143840,   -0.043138,    0.263222}, {   0.018310,    0.013794,    0.004211}, {   0.042934,   -0.038911,    9.391565}, {  -0.080076,    0.066899,    6.102565}, {  -0.004401,    0.012237,    2.161444}, {   0.000715,    0.003745,    0.006781}, {   0.001654,   -0.006943,    0.006874},
			{   5.546472,   -0.031247,    0.014685}, {   0.001648,    0.002217,    0.007333}, {   0.004048,    0.004960,    0.001084}, {  -0.095138,    0.352008,    0.341457}, {   0.001518,    0.013206,    0.042500}, {   0.000430,    0.003677,    0.500000}, {   0.002101,    0.000460,    0.005894}, {   0.002949,    0.005909,    0.021029},
			{   0.002166,    0.004581,    0.052570}, {   0.002166,    0.005996,    0.052570}, {   0.002166,    0.007410,    0.052570}, {   0.002166,    0.001011,    0.052570}, {   0.002166,    0.002426,    0.052570}, {  -0.004401,    0.012237,    2.161444}, {   0.000000,    0.000000,    0.000000}, {  -0.315034,    0.004155,    0.002481},
			{  -0.000006,   -0.006556,    0.002424}, {   0.006482,   -0.007594,    0.040274}, {   0.006238,   -0.007596,    0.040895}, {   0.020146,    0.003111,   -0.007507}, {   0.003907,   -0.001049,   -0.015587}, {   0.010808,    0.006843,   -0.007507}, {   0.008138,   -0.002583,    0.007060}, {   0.003484,   -0.003701,    0.003289},
			{   0.002997,   -0.003711,    0.000594}, {   0.007089,   -0.004129,    0.005022}, {   0.005623,   -0.004373,   -0.017782}, {   0.001107,   -0.004129,    0.001213}, {   0.018776,    0.009802,    0.107464}, {   0.005377,   -0.000033,    0.224620}, {   0.011117,    0.010568,    0.224390}, {   0.018223,    0.009217,    0.001407},
			{   0.012714,    0.004141,    0.014934}, {   0.018848,    0.006777,    0.000960}, {   0.007652,    0.013693,    0.000134}, {   0.005683,    0.012238,   -0.002647}, {   0.007772,    0.019104,    0.006082}, {   0.000403,    0.012504,    0.001117}, {  -1.694892,    0.018555,    3.942513}, {  -0.868481,   -0.078409,    3.122000},
			{  -0.123650,    0.069193,    2.397475}, {   0.002378,    0.013535,    0.002247}, {   0.007003,    0.010986,    0.005156}, {   0.010173,    0.008275,    0.002546}, {   0.014217,    0.010002,    0.000579}, {   0.010188,    0.008674,    0.006430}, {   0.015518,    0.012060,    0.001394}, {   0.014430,    0.004238,   -0.006428},
			{   0.008983,    0.002316,    0.003052}, {   0.006854,    0.003594,    0.003159}, {   0.016495,    0.013798,    0.003451}, {   0.003887,    0.008573,    0.004927}, {   0.005708,    0.003018,    0.001575}, {   0.017927,    0.017009,    0.004972}, {   0.013675,    0.011115,    0.006775}, {   0.009968,    0.002876,    0.003117},
			{   0.005878,    0.010649,    0.006140}, {   0.008724,    0.012671,    0.005737}, {   0.006713,    0.005061,    0.028123}, {   0.009773,    0.006713,    0.003743}, {   0.013480,    0.009030,    0.530080}, {   0.419945,    0.403497,    0.009589}, {   0.003733,    2.646009,    0.147686}, {  -0.450412,   -0.006974,    0.004443},
			{  -0.013445,    0.021250,    7.505348}, {   0.373185,   10.564631,   -2.345026}, {   0.002321,    0.008205,    0.011603}, {  -0.003270,   -0.033190,    9.667093}, {  -0.003854,   -0.104523,  -12.108757}, {  -0.030433,   -0.008793,   -0.657189}, {   0.013202,   15.582690,   -2.210959}, {   0.008201,    0.014787,    0.010947},
			{   0.008332,   17.616420,    3.185980}, {   0.008329,    0.014152,    0.012223}, {  -0.013416,    1.305987,   -6.773530}, {   0.002707,    0.014899,    0.024635}, {   0.010042,   12.616420,    3.185980}, {   0.002227,    0.007491,    0.012223}, {   0.004418,    0.011078,    0.011176}, {   0.009912,    0.014787,   -9.989050},
			{   0.008329,    0.014152,    0.012223}, {   0.002707,    0.014899,   -0.024127}, {   0.008332,   22.616418,    3.185978}, {   0.008201,    0.014787,   10.010948}, {   0.002321,    0.008205,    0.011603}, {  -0.013445,    0.021250,    7.505348}, {  -0.003875,    0.010133,  -12.215133}, {   0.099840,   -0.024725,    9.305728},
			{   0.004036,   15.523030,   -2.189419}, {   0.009909,    0.014790,  -10.027152}, {   0.009990,   12.659109,    3.175165}, {   0.008279,   17.659109,    3.175165}, {   0.008197,    0.014790,   -0.027153}, {   0.008197,    0.014790,    9.972846}, {   0.008287,   22.659107,    3.175165}, {   0.017310,    0.008554,    0.002854},
			{   0.022694,    0.013207,    0.010130}, {   0.013949,    0.008274,    0.496219}, {   0.017586,    0.010781,    0.007646}, {   0.012595,    0.016153,    0.110210}, {   0.006972,    0.005716,    0.005270}, {   0.006972,   -0.010731,   -0.000322}, {   0.075462,    0.015402,    0.005917}, {   0.020517,   -0.013597,    1.077888},
			{   0.013244,    0.009003,    0.006566}, {   0.019762,    0.010924,    0.395049}, {   0.015649,    0.004900,    0.002724}, {   0.015705,    0.003226,    0.001423}, {   0.019027,    0.006012,    0.458153}, {   0.018874,    0.007872,    0.024858}, {   0.013946,    0.000933,    0.001279}, {   0.007621,    0.006912,    0.007652},
			{   0.013759,    0.001621,    0.002891}, {   0.007950,    0.006899,    0.001831}, {   0.026847,    0.009316,    1.616415}, {   0.017818,    0.007292,    0.007354}, {   0.021563,    0.001717,    0.009440}, {   0.013988,    0.014526,    0.005727}, {   0.010582,    0.008963,    0.285282}, {   0.011076,    0.010149,    0.004970},
			{   0.022754,    0.217639,    0.326651}, {   0.015389,    0.002627,    0.164152}, {   0.010243,    0.001261,    0.313780}, {   0.016302,    0.001261,    0.314502}, {   0.022383,    0.007350,    0.006171}, {   0.008070,    0.327399,    1.840383}, {   0.020185,    0.021484,    0.543655}, {   0.103607,   -0.216683,    0.552345},
			{   0.012202,    0.010700,    0.001209}, {   0.019012,   -0.367305,   -0.021764}, {   0.019532,    0.024357,    0.003451}, {   0.009968,    0.002760,    0.006765}, {   0.015933,    0.002760,    0.006142}, {   0.014592,    0.001307,    0.007439}, {   0.016612,    0.014500,    0.002854}, {   0.006972,    0.008360,    0.002493},
			{   0.008750,    0.004765,    0.002281}, {  -0.023612,   -0.079778,    0.007379}, {   0.011452,    0.003947,   -0.006235}, {   0.006043,    0.016814,    0.015393}, {   0.004631,   -0.009513,    0.000503}, {   0.002811,    0.011727,    0.039186}, {   0.006118,    0.006972,    0.002461}, {   0.009917,    0.014663,    0.007672},
			{   0.014387,    0.004422,    0.000331}, {   0.031093,    0.016899,    0.005024}, {   0.005106,    0.284947,    0.622882}, {   0.014144,    0.009603,    0.002058}, {   0.014236,    0.003178,   -0.005816}, {   0.012652,    0.034076,    0.005090}, {   0.484829,    0.056609,    1.870440}, {   0.011373,    0.020331,    0.001230},
			{   0.014312,    0.009033,    0.006310}, {   0.019766,    0.005553,    0.006310}, {   0.020697,    0.005553,    0.006310}, {   0.017534,    0.013778,    0.006310}, {   0.013477,    0.006142,   -0.455749}, {  -0.017462,    0.101704,    0.006808}, {   0.009688,    0.011409,    0.000606}, {   0.012775,    0.011409,    0.000606},
			{   0.013629,   -0.078537,    0.000606}, {   0.009734,    0.011191,    0.003371}, {   0.011049,    0.011191,    0.000986}, {   0.014967,    0.011191,    0.000986}, {   0.013164,    0.011409,    0.000606}, {   0.013116,    0.011191,    0.000986}, {   0.021771,   -0.017751,    0.043288}, {   0.008713,    0.006579,    0.033422},
			{   0.008376,    0.006062,    0.000575}, {   0.004166,    0.004007,    0.003448}, {   0.011266,    0.005685,    0.002173}, {   0.010023,    0.005687,   -0.333692}, {   0.074717,    0.042043,   -0.013805}, {   0.145593,   -0.005104,    0.024147}, {   0.005080,    0.003814,    0.004757}, {   0.007445,    0.003814,    0.004395},
			{   0.001604,   -0.005721,   -0.028821}, {   0.023662,    0.091733,   -1.832080}, {  -0.014537,   -0.012047,    0.013984}, {   0.762539,    0.010259,    1.255313}, {   0.762443,    0.002862,    1.255278}, {   0.759625,    0.000874,    1.255128}, {   0.760460,    0.001745,    1.255574}, {   0.753184,    0.012342,    1.255574},
			{   0.756889,    0.004790,    1.257318}, {   0.755173,    0.011873,    1.259969}, {   0.759164,    0.014188,    1.255574}, {   0.756443,    0.009434,    1.256412}, {   0.774851,    0.083880,    1.256412}, {   0.757304,    0.020797,    1.256412}, {   0.766350,    0.032342,    1.259592}, {   0.016921,   -0.060557,    0.552713},
			{   0.764711,    0.020797,    1.256412}, {   0.764322,    0.020798,    1.256412}, {   0.758630,    0.020798,    1.256412}, {   0.760226,    0.020798,    1.256412}, {  -0.072903,    0.011084,    0.028009}, {   0.013833,    0.003814,    0.004395}, {   0.012571,    0.012570,    0.013892}, {   0.007552,   -0.001408,   -0.028821},
			{   0.014639,    0.005592,    0.004397}, {   0.006146,    0.006775,    0.010715}, {   0.004825,    0.006595,   -0.000931}, {   0.003128,    0.046078,    0.860104}, {   0.022545,    0.004978,    0.175945}, {   0.011385,    0.008639,    0.007151}, {   0.003127,    0.001857,    0.004563}, {   0.017579,    0.183612,    0.076788},
			{   0.013619,    0.008639,    0.147777}, {  -0.004515,   -0.167207,    0.009135}, {   0.765151,    0.008685,    1.259999}, {   0.770519,    0.032012,    1.261926}, {  -0.019664,   -0.005516,    0.014820}, {  -0.019907,   -0.007470,    0.021657}, {  -0.019907,   -0.007348,    0.019855}, {  -0.019664,   -0.005150,    0.019453},
			{  -0.019907,   -0.007470,    0.019453}, {  -0.019907,   -0.007958,    0.021657}, {  -0.019907,   -0.007348,    0.015937}, {  -0.019664,   -0.000757,    0.019855}, {   0.757282,    0.011772,    1.255574}, {   0.756518,   -0.068310,    1.256412}, {   0.003417,    0.003878,    0.007619}, {   0.763134,    0.017628,    1.256412},
			{   0.759791,    0.017627,    1.256412}, {  -0.756519,    0.010630,    1.256412}, {   0.751143,   -0.032563,    1.250000}, {   0.006269,   -0.006473,    0.010901}, {   0.001264,   -6.509046,    0.039983}, {   0.003135,    0.001975,    0.000745}, {   0.007011,    0.003259,    0.001593}, {   0.006713,    0.007557,    0.186397},
			{   0.011345,    0.007557,    0.186230}, {   0.015405,    0.005009,    0.000125}, {   0.016662,    0.010894,    0.001593}, {   0.016135,    0.009789,    0.001593}, {   0.008507,    0.002414,    0.001593}, {   0.005317,    0.004720,    0.399069}, {   0.009140,    0.004317,    0.001593}, {   0.024639,    0.007023,    0.010215},
			{   0.005900,    0.000887,    0.048041}, {   0.007209,    0.006546,    0.006916}, {   0.001298,    0.007726,    0.529325}, {   0.760514,   -0.001451,    1.243824}, {   0.757072,   -0.001444,    1.243824}, {   0.764825,    0.001158,    1.243824}, {  -0.000361,    0.008697,   -0.059046}, {   0.002306,    0.004124,   -0.366246},
			{   0.758889,   -0.065517,    1.256412}, {  -0.754527,    0.011335,    1.256412}, {   0.000699,   -0.001521,    0.000146}, {   0.001888,    0.004451,    0.000561}, {   0.006072,    0.001399,   -1.523347}, {   0.006072,    0.002345,    0.016715}, {   0.797176,    0.004290,    0.000000}, {   0.767736,    0.015628,    1.255313},
			{   0.002069,    0.010390,    2.029738}, {   0.750873,    0.002290,    1.254256}, {   0.008724,    0.005886,   -0.015033}, {   0.002868,    0.002420,    0.002073}, {  -0.010143,   -0.013931,    0.001293}, {   0.000000,    0.000000,    0.000000}, {  -0.004916,    0.004741,    0.519068}, {   0.004464,    0.000456,    0.089583},
			{   0.001369,    0.000456,    0.089583}, {   0.006087,    0.000456,    0.089583}, {   0.002992,    0.000456,    0.089583}, {   0.007710,    0.000456,    0.089583}, {   0.004616,    0.000456,    0.089583}, {   0.005659,   -0.007178,    0.003398}, {   0.006529,    0.003305,    0.035238}, {   0.068129,   -0.038986,    0.927573},
			{  -0.071961,   -0.049977,    0.938224}, {   0.068373,   -0.046725,    0.933277}, {   0.037861,   -0.042962,    0.931824}, {   0.010610,   -0.005423,    0.638006}, {   0.011343,   -0.006138,    0.816856}, {  -0.390900,   -0.014077,    0.284442}, {   0.419016,   -0.014077,    0.282730}, {   0.415592,   -0.026252,   -0.313084},
			{  -0.395316,   -0.026252,   -0.313084}, {   0.002216,    0.005109,    0.001121}, {   0.000303,    0.004840,    0.000311}, {   0.003976,    0.007794,    0.004087}, {   0.002315,    0.003600,    0.001364}, {   0.004062,    0.005336,    0.005747}, {   0.001920,    0.000884,    0.000000}, {   0.001123,    0.003446,    0.006130},
			{   0.029920,    0.007371,    0.106792}, {   0.002701,    0.023762,   -0.014467}, {   0.004418,   -0.016555,   -0.551510}, {   0.001667,    0.008015,   -0.598385}, {  -0.003316,    0.006955,    0.002012}, {   0.033780,   -0.232139,   -0.003884}, {   0.002380,    0.008210,   -0.028065}, {  -0.001381,    0.008911,    0.002407},
			{  -0.001481,    0.003720,    0.004333}, {   0.104542,    0.004964,    0.134184}, {  -0.001150,   -0.002911,    0.157309}, {   0.198425,    0.021118,    0.089837}, {   0.004157,   -0.147901,    0.000000}, {  -0.252034,    0.032967,   -0.451227}, {  -0.064631,   -0.003796,   -0.322059}, {  -0.067685,   -0.001810,   -0.287373},
			{  -0.200415,    0.152898,   -0.695686}, {  -0.553165,    0.003018,   -0.786235}, {  -0.425976,    0.014705,   -0.786235}, {  -0.037638,    0.003627,    0.003755}, {  -0.006167,    0.006047,    0.003755}, {  -0.055406,   -0.000456,    0.002758}, {  -0.171137,    0.073446,   -0.808818}, {  -0.219958,    0.011084,   -0.628511},
			{  -0.317685,    0.006184,    0.005013}, {  -0.229911,    0.001221,    0.005013}, {  -0.182466,    0.001203,    0.005013}, {  -0.092229,    0.002465,    0.001920}, {  -0.145340,    0.007635,    0.006167}, {  -0.157425,    0.007313,    0.006167}, {  -0.157425,    0.005078,    0.006167}, {  -0.183373,    0.159848,   -2.707420},
			{   0.005965,    0.005936,    0.419973}, {  -0.023210,   -0.333956,   -0.041420}, {  -0.016442,   -0.333779,    0.667035}, {   0.002031,    0.005700,    0.002827}, {   0.007430,   -0.110933,    0.000000}, {   0.138503,    2.136293,    0.639189}, {   0.018364,    0.006130,    0.000671}, {  -3.049346,    0.002768,    1.153381},
			{   0.006225,    0.006926,    0.005104}, {   0.007323,    0.006926,    0.005104}, {   0.000609,    0.006926,    0.005104}, {   0.001708,    0.006926,    0.005104}, {   0.002471,    0.000080,    0.002730}, {   0.004532,   -0.016948,   -0.012428}, {  -0.006835,   -0.018803,   -0.013939}, {   0.004608,    0.004707,   -0.041072},
			{   0.005051,    0.032976,    0.004974}, {   0.003417,    0.000602,    0.000923}, {   0.011583,    0.005379,   -0.117476}, {   0.003763,    0.034097,    0.000000}, {   0.007511,    0.004701,    0.007633}, {   0.007199,    0.000991,    0.007633}, {   0.004699,    0.007065,    0.001891}, {   0.082117,    0.005936,    0.419973},
			{   0.006225,    0.005661,    0.003521}, {   0.001310,    0.007331,    0.169368}, {   0.001310,    0.007331,    0.169548}, {   0.001310,    0.007331,    0.169548}, {   0.467144,    7.111098,    2.202821}, {   0.001310,    0.007331,    0.169368}, {   0.221229,    0.402752,    2.447693}, {   0.009794,    0.015698,   -0.000067},
			{   0.007265,    0.001692,    0.006459}, {   0.002923,    0.001692,    0.007445}, {   0.001185,    0.001692,    0.005845}, {   0.001776,    0.001692,    0.004089}, {   0.007505,    0.001692,    0.006459}, {   0.000793,    0.001692,    0.006459}, {   0.026533,   -0.008008,    0.162709}, {   0.010575,    0.015698,   -0.000067},
			{   0.011454,    0.001751,    0.007416}, {   2.517935,   -0.446386,   -0.332347}, {   0.057557,    0.006512,   -0.055755}, {   0.005510,    0.000746,    0.004523}, {   0.035094,    0.011536,    0.012641}, {   0.002855,    0.001430,    0.005592}, {   0.002856,    0.001430,   -0.054028}, {  -0.002859,    0.089727,   -0.453435},
			{   1.915814,   -1.548681,    0.861141}, {   0.006713,    0.006725,   -0.389284}, {   0.002703,    0.003840,    0.002731}, {  -0.012063,   -0.021242,    0.006258}, {   0.011138,    0.014553,    0.000123}, {   0.004660,    0.007635,    0.000000}, {  -0.000128,   -0.000822,    1.370951}, {   0.013032,    0.013698,    0.012604},
			{   0.008789,    0.008657,    0.005007}, {   0.011195,    0.003585,    0.012625}, {   0.014073,    0.007875,    0.012230}, {   0.008279,    0.010052,    0.007029}, {   0.000999,    0.006415,    0.007486}, {   0.006858,    0.005053,    0.002868}, {   0.011528,    0.011336,    0.006041}, {   0.003684,    0.001945,    0.005508},
			{   0.005398,    0.007621,    0.002137}, {   0.002707,    0.319494,    0.003169}, {   0.006225,    0.049322,    0.003521}, {   0.000000,    0.000000,    0.000000}, {   0.510719,    2.241494,    0.586959}, {   0.504325,    2.247504,    0.701336}, {   1.000010,    0.023376,    0.491311}, {   1.013702,    0.019695,    0.514921},
			{   0.458568,    0.009964,    0.516062}, {   0.502501,    0.012641,    0.491311}, {   0.510429,    0.007412,    0.477798}, {   0.791716,    0.058269,    0.498308}, {   0.494278,    0.009959,    0.495779}, {   2.771564,    0.522773,    0.503243}, {   1.832777,    0.020109,    0.513311}, {   0.179294,    0.017000,    0.512533},
			{   0.728561,    0.019546,    0.513319}, {   0.820625,    0.012145,    0.495783}, {  -0.007071,   -0.126858,    0.603389}, {  -0.003489,   -0.151133,    0.450046}, {  -0.302433,   -0.304419,    0.316947}, {   0.224802,    0.795531,    0.611949}, {   0.008963,    0.011518,    0.003103}, {   0.009087,    0.014144,    0.029720},
			{   0.010491,    0.176880,    0.501670}, {   0.017116,    0.155013,    0.473580}, {   0.023266,    0.227560,    0.478345}, {   1.009013,    0.009507,    0.483763}, {   0.516080,    0.003229,    0.493124}, {   0.508791,    2.209851,    0.698244}, {   1.004724,    0.019147,    0.469356}, {   0.502479,    0.020856,    0.469343},
			{   1.010434,    0.005359,    0.515358}, {   0.016341,    0.005251,    0.515359}, {   0.207822,   -0.046424,    0.680733}, {   0.008577,    0.004974,    0.002634}, {   0.003684,    0.001739,    0.007656}, {   0.000502,    0.004368,    0.001298}, {   0.008820,    0.009476,   -0.503508}, {   0.015956,   -0.009202,    0.641009},
			{   0.012633,    0.005156,    0.003540}, {   0.508131,    0.010894,    0.400575}, {   0.022095,    0.011199,    0.007075}, {   0.010622,    0.008093,    0.000190}, {  -0.011783,    1.165545,    0.538438}, {   0.512421,    1.107426,    0.576740}, {   0.231078,   -0.303382,    1.021780}, {   0.516819,    1.081547,    0.621034},
			{   0.477293,   -0.323890,    0.172158}, {   0.507080,    2.155405,    0.595022}, {   0.001342,   -0.001204,    0.261752}, {  -0.194580,   -0.254936,    0.219574}, {  -0.171935,   -0.314276,    0.233501}, {  -0.195113,   -0.178310,    0.287472}, {  -0.141937,   -0.281020,    0.266083}, {  -0.133664,   -0.276939,    0.278553},
			{  -0.061308,   -0.208648,    0.365157}, {   1.020874,    0.003914,    0.471157}, {  -0.001833,   -0.002074,    0.481709}, {   0.512547,    0.008243,    0.550939}, {   0.883911,    0.047557,    0.557802}, {   1.010162,   -0.004263,    0.537572}, {   0.504260,    0.013549,    0.535579}, {   0.493377,    0.098677,    0.523254},
			{   1.009894,    0.010657,    0.550939}, {   1.009467,    0.014054,    0.522539}, {   0.490249,    0.001096,    0.517467}, {   0.623383,    0.102151,    0.523254}, {   1.013267,    0.021113,    0.506525}, {   0.517733,    0.020279,    0.497958}, {   1.024567,    0.009216,    0.567803}, {   0.523254,    0.009704,    0.567646},
			{   1.011536,    0.010940,    0.504903}, {   0.486205,    0.023621,    0.506873}, {   0.511458,    0.004226,    0.400155}, {   0.016948,    0.004954,    0.012919}, {   0.003543,    0.004726,    0.003688}, {   0.000624,    0.002696,    0.005487}, {   0.003875,    0.001066,    0.005047}, {   0.014205,    0.025696,    0.002821},
			{   0.008040,    0.010784,    0.001430}, {   0.002057,    0.005828,    0.002142}, {  -0.065085,   -0.237103,    0.585294}, {   0.005076,    0.002742,    0.002353}, {   0.004348,    0.003585,    0.000396}, {  -0.147521,   -0.304962,    0.240008}, {   0.003051,    0.011845,    0.007137}, {   0.007050,    0.017527,    0.001803},
			{   0.009277,    0.013612,    0.005954}, {   0.009277,    0.012276,    0.005855}, {   0.095151,   -0.206756,    0.365157}, {   0.003234,    0.012923,    0.001803}, {   0.009643,    0.014942,    0.004474}, {   0.007751,    0.012302,    0.001178}, {   0.007050,    0.012175,    0.002707}, {  -0.092863,   -0.191438,    0.285813},
			{   0.091918,   -0.262053,    0.448296}, {   0.472665,    2.112515,    0.350261}, {   0.465649,    2.316556,    0.477355}, {   0.484007,    2.172194,    0.238823}, {   0.113433,    2.309036,    0.513082}, {   0.519385,    2.200316,    0.500322}, {   0.503253,    2.113723,    0.387897}, {   0.483341,    2.180018,    0.445037},
			{   0.146980,    2.287019,    0.595090}, {   0.499175,    2.271652,    0.530694}, {   0.529258,    2.219652,    0.604820}, {   0.504706,    2.237962,    0.988856}, {   0.470144,    1.845834,    0.395693}, {   0.005049,    0.009108,    0.006787}, {   0.005193,    0.140139,    0.511313}, {   0.005253,    0.000803,    0.002658},
			{   0.012973,   -0.009674,    0.897491}, {   0.012725,    0.004265,    0.281675}, {  -0.235030,    0.200988,    0.458503}, {   0.009089,    0.005251,    0.007567}, {  -0.013214,    1.313156,    0.386824}, {   0.501380,    0.515383,    0.254227}, {   0.486054,    0.510562,    0.258765}, {   0.519482,    0.501236,    0.248638},
			{   0.504459,    0.512712,    0.256568}, {   0.481085,    0.522810,    0.254925}, {   0.492673,    0.522018,    0.261072}, {   0.513257,    0.517883,    0.257934}, {   0.499022,    0.507628,    0.256094}, {   0.496046,    0.507779,    0.361864}, {   0.508010,    0.522508,    0.249568}, {   0.509840,    0.506227,    0.256411},
			{   0.022575,    0.008320,    0.001927}, {   0.001479,    0.001708,    0.522086}, {   0.608901,    0.002440,    0.412649}, {   0.007751,    0.009201,    0.214667}, {   0.007011,    0.001952,    0.027280}, {   0.002135,    0.008225,    0.007449}, {   0.000392,    0.003173,    0.574158}, {   0.000148,    0.003173,    0.574158},
			{   0.005276,    0.003173,    0.574158}, {   0.007228,    0.006103,    0.554062}, {   0.005592,    0.005313,    0.552102}, {   0.001368,    0.006103,    0.554062}, {   0.003322,    0.000976,    0.554062}, {   0.003322,    0.004395,    0.554062}, {   0.000392,    0.001220,    0.574159}, {   0.006190,    0.005706,    0.272576},
			{   0.004891,    0.000610,    0.237207}, {   0.004891,    0.006806,    0.237207}, {   0.006033,    0.007484,    0.005708}, {   0.001521,    0.005129,    0.999628}, {   0.001551,    0.005123,    0.999628}, {   0.000786,    0.005135,    0.658384}, {   0.004191,    0.004929,    0.969735}, {   0.006957,    0.006049,    0.999628},
			{   0.001449,    0.006049,    0.999628}, {   0.006165,    0.003237,    0.993665}, {  -0.246794,    0.003246,    0.993632}, {   0.001512,    0.001193,    0.005144}, {   0.001798,    0.001188,    0.005144}, {   0.000027,    0.003909,    0.001955}, {   0.000054,    0.003909,    0.001955}, {   0.000037,    0.003909,    0.001955},
			{   0.004730,    0.003909,    0.001955}, {   0.003749,    0.003909,    0.001955}, {   0.002097,    0.003909,    0.001955}, {   0.000121,    0.004517,    0.001955}, {   0.001430,    0.004517,    0.001955}, {   0.001087,    0.004517,    0.001955}, {   0.003600,    0.004517,    0.001955}, {   0.002253,    0.004517,    0.001955},
			{   0.004695,    0.004517,    0.001955}, {   0.001430,    0.003417,    0.001955}, {   0.001087,    0.003417,    0.001955}, {   0.000121,    0.003417,    0.001955}, {   0.003600,    0.003417,    0.001955}, {   0.002253,    0.003417,    0.001955}, {   0.004695,    0.003417,    0.001955}, {   0.000121,    0.002279,    0.007625},
			{   0.001033,    0.002279,    0.007625}, {   0.003108,    0.002279,    0.007625}, {   0.004772,    0.002279,    0.007625}, {   0.001747,    0.002279,    0.007625}, {   0.001632,    0.002279,    0.007625}, {   0.001746,    0.007178,    0.002840}, {   0.000120,    0.007178,    0.002840}, {   0.001032,    0.007178,    0.002840},
			{   0.003107,    0.007178,    0.002840}, {   0.004770,    0.007178,    0.002840}, {   0.001631,    0.007178,    0.002840}, {   0.004147,    0.001094,    0.474458}, {   0.006721,    0.004772,    0.999628}, {   0.009123,    0.010003,    0.321209}, {   0.020341,    0.000249,   -0.324533}, {   0.005824,    0.005123,    0.999628},
			{   0.005795,    0.005129,    0.999628}, {   0.007503,    0.004772,    0.999628}, {   0.006333,    0.004772,    0.999628}, {   0.007114,    0.004772,    0.999628}, {   0.507121,    0.008957,    0.789018}, {   0.523518,    0.010183,   -0.305294}, { -12.621377,    0.815253,    1.111196}, {   0.011992,    0.039287,    0.006622},
			{   0.074086,    0.080303,   -0.449685}, {   0.012085,    0.007205,    0.000571}, {   0.006041,    0.001030,   -0.072988}, {   0.012461,    0.002224,    0.008790}, {   0.011184,    0.003464,    0.009934}, {   0.009890,    0.004211,    0.071211}, {   0.012485,    0.004211,    0.071211}, {   0.013883,    0.004211,    0.071211},
			{   0.011520,    0.004211,    0.071211}, {   0.013069,    0.003464,    0.009934}, {   0.012070,    0.003464,    0.009934}, {   0.014549,    0.003464,    0.009934}, {   0.012206,    0.003464,    0.009934}, {   0.010095,    0.002224,    0.008790}, {   0.009607,    0.002224,    0.008790}, {   0.011029,    0.004211,    0.071211},
			{   0.011064,    0.002224,    0.008790}, {   0.008471,    0.002224,    0.008790}, {   0.012986,    0.002224,    0.008790}, {   0.008034,    0.003653,    0.009934}, {   0.011184,    0.003653,    0.009934}, {   0.012206,    0.003653,    0.009934}, {   0.012070,    0.003653,    0.009934}, {   0.008034,    0.003464,    0.009934},
			{   0.013069,    0.003653,    0.009934}, {   0.014407,   -0.027039,    0.071211}, {   0.014549,    0.003653,    0.009934}, {   0.008662,    0.005369,    0.009314}, {   0.010843,    0.005369,    0.009314}, {   0.011850,    0.005369,    0.009314}, {   0.010424,    0.005369,    0.009314}, {   0.014658,    0.005369,    0.009314},
			{   0.010064,    0.005369,    0.009314}, {   0.007522,   -0.100992,    0.002613}, {  -0.009263,    0.012608,    0.065352}, {  -0.006668,    0.015174,    0.065352}, {  -0.005270,    0.013070,    0.065352}, {  -0.007633,    0.013295,    0.065352}, {   0.013291,    0.005809,    0.004354}, {   0.008698,    0.005809,    0.004354},
			{   0.012505,   -0.001999,    0.004354}, {   0.014688,    0.005809,    0.004354}, {   0.011506,    0.005809,    0.004354}, {   0.012934,    0.005809,    0.004354}, {  -0.008124,    0.016068,    0.065352}, {  -0.004745,   -0.022493,    0.065352}, {   0.001018,    0.005832,    0.007205}, {   0.000287,    0.005832,    0.007205},
			{   0.001385,    0.005832,    0.007205}, {   0.005779,    0.005832,    0.007205}, {   0.002542,    0.007590,    0.003055}, {   0.004770,    0.003281,    0.002840}, {   0.031168,   -0.098407,   -0.147244}, {   0.001315,    0.004898,    0.557753}, {   0.003674,    0.001869,    0.001503}, {   0.000327,    0.001869,    0.001503},
			{  -0.033206,   -0.089217,    0.007023}, {   0.002882,    0.007156,    0.001774}, {   0.006819,    0.004226,    0.004490}, {  -0.034508,   -0.089245,    0.007023}, {   0.001584,    0.007156,    0.001774}, {   0.005522,    0.004226,    0.004490}, {   0.001034,    0.004226,    0.014706}, {   0.001319,    0.005090,    0.214006},
			{   0.002438,    0.002471,    0.000192}, {   0.003056,    0.002471,    0.000192}, {   0.002972,    0.002471,    0.000192}, {   0.006163,    0.006816,    0.001674}, {  -0.368241,   -0.192533,    0.005716}, {   0.004435,    0.732147,    0.007251}, {   0.006852,   -0.002466,    0.004414}, {  -0.002818,   -0.728173,    0.007065},
			{   0.006771,    0.006957,   -0.037730}, {   0.006771,    0.000426,   -0.037730}, {   0.016767,   -0.000487,   -0.042132}, {   0.006883,    0.005460,    0.001413}, {   0.135506,   -0.137353,    0.124701}, {  -0.251641,    0.003604,    0.059383}, {   0.004687,    0.000006,    0.004581}, {   0.001586,    0.004193,    0.006790},
			{   0.000896,    0.004193,    0.007424}, {   0.000292,    0.000518,    1.101145}, {   0.020561,    0.018253,   -0.434917}, {  -0.000000,    0.000000,    0.000000}, {   0.004029,    0.006653,    0.000929}, {   0.006078,    0.017839,    2.015547}, {   0.002697,    0.005005,    2.012906}, {   0.004536,    0.015472,    2.007929},
			{   1.003777,    0.001449,    0.757934}, {   0.001682,    0.003110,   -1.211894}, {   0.002642,    0.005005,    2.010257}, {   0.017936,    0.015472,    2.007742}, {  -0.008670,    0.015472,    2.006848}, {   0.006269,    0.003176,    1.586568}, {   0.000803,    0.002711,    1.702676}, {   0.014332,    0.017837,    2.010016},
			{   0.002957,    0.005005,    2.016755}, {   0.007098,    0.004929,    1.978271}, {   0.004769,    0.004929,    1.993926}, {   0.000806,    0.004929,    1.971366}, {  -0.005973,    0.017837,    2.017812}, {   0.000289,    0.001937,    0.588370}, {   0.514788,    0.503859,    0.632862}, {   0.503021,    0.050237,    0.633306},
			{   0.006918,    0.253674,    0.704391}, {   0.000598,    0.005259,    0.893418}, {   0.006918,    0.259620,    0.870968}, {   0.003631,    0.007493,    0.004364}, {   0.411774,   -0.032164,    0.004174}, {   0.005187,    0.005905,    0.005847}, {   0.008636,    0.009254,    0.000211}, {   0.006918,    0.252593,    0.704391},
			{   0.501914,    0.078656,    0.632862}, {   0.502184,    0.507054,    0.633306}, {   0.000326,    0.004168,    0.453586}, {   0.003046,    0.006215,    0.502269}, {   0.005824,    0.006818,    0.999628}, {   0.500540,    0.003389,    1.225716}, {   0.000502,    0.003432,    1.225718}, {   0.000475,    0.003350,    1.150717},
			{   0.000483,    0.003440,    1.150717}, {   0.000449,    0.003428,    1.150717}, {   0.000468,    0.003437,    1.150717}, {   0.000446,    0.003440,    1.150715}, {   0.501163,    0.742568,    0.678862}, {   0.002881,    1.246188,    0.450044}, {   0.002122,    0.003323,    1.225718}, {   0.008933,    0.009263,    1.047399},
			{   0.508689,    0.505607,    0.267708}, {   0.493548,    0.005179,    1.262812}, {   0.010197,    0.006628,   -0.305687}, {   0.007604,    0.007325,    0.004743}, {   0.002685,    0.015577,    0.012113}, {   0.513761,    0.004860,    0.398184}, {   0.004867,    0.002719,    0.008121}, {   0.510056,    0.006546,    0.400038},
			{   0.507552,    0.006897,    0.399372}, {   0.002988,    0.008252,    0.001841}, {   0.009560,    0.004488,    0.001842}, {   0.010375,    0.003370,    0.005274}, {   0.005340,    0.007213,    0.001859}, {   0.002693,    0.007172,    0.000307}, {   0.017730,    0.006233,    0.006709}, {   0.003653,    0.004089,    0.000755},
			{   0.017456,    0.005576,    0.001925}, {   0.013244,    0.009018,    0.002858}, {  -0.021871,    0.016228,    0.002592}, {   0.014464,    0.004846,    0.007005}, {   0.003325,    0.008917,    0.000289}, {   0.012211,    0.022622,    0.001409}, {   0.011719,    0.008368,    0.004160}, {   0.017638,   -0.032795,   -0.025848},
			{   0.010711,   -0.032795,   -0.025848}, {   0.018005,    0.004836,    0.003720}, {   0.011841,    0.004836,    0.002416}, {   0.013855,    0.004836,    0.002416}, {   0.017699,    0.015099,    0.052921}, {   0.015685,    0.013472,    0.022174}, {   0.011199,   -0.000492,    0.033959}, {   0.010924,    0.004836,    0.002416},
			{   0.015683,    0.004836,    0.006471}, {   0.008179,    0.012361,    0.000203}, {   0.016238,    0.006306,    0.003034}, {   0.081462,   -0.115745,    0.003401}, {   0.010590,    0.009472,    0.001069}, {   0.006736,    0.010270,    0.006905}, {   0.007125,    0.009847,    0.006972}, {   0.010452,    0.006752,    0.000039},
			{   0.012083,    0.008036,    0.004877}, {   0.005125,    0.068722,    0.712086}, {   0.003605,    0.076534,    0.712086}, {   0.010955,    0.144987,    0.712086}, {   0.016140,    0.010444,    0.005313}, {   0.024932,    0.008511,    1.022596}, {   0.009522,    0.009360,    0.005872}, {   0.012691,    0.007042,    0.001303},
			{   0.024028,    0.008872,    0.001303}, {   0.011215,    0.008559,    0.004106}, {   0.003142,    0.002022,    0.004240}, {   0.012086,    0.008864,    0.007265}, {   0.013336,    0.002731,    0.005441}, {   0.008422,    0.009360,    0.002264}, {   0.496885,   -0.119225,    1.053653}, {   0.006676,    0.006907,    0.005634},
			{   0.513671,    0.005913,    0.398663}, {   0.509187,    0.505281,    0.259137}, {   0.498088,    0.514024,    0.255531}, {   0.501290,    0.502180,    0.249755}, {   0.219482,   -0.140174,    0.462841}, {   0.506254,    0.003189,    0.403584}, {   0.004761,    0.005826,    0.007656}, {   0.531982,   -0.151124,    0.584074},
			{   0.503753,    1.074100,    0.964488}, {   0.418760,   -0.123365,    0.596524}, {   0.525834,    2.239273,    0.671468}, {   0.737550,   -0.145007,    0.994038}, {  -0.237488,   -0.237953,    0.679991}, {   0.189320,    0.888924,    0.619629}, {   0.508907,    1.177585,    0.500590}, {   0.010071,    1.107071,    0.470667},
			{   0.001710,    0.094383,    0.480556}, {   0.505811,    0.003754,    0.007257}, {   0.013465,    0.016214,    0.004207}, {   0.127929,   -0.245422,    0.665162}, {   0.232880,   -0.192642,    0.777924}, {  -0.000457,    0.011369,    0.274473}, {   0.006895,    0.006477,    0.156718}, {   0.023223,    0.019952,    0.233765},
			{  -0.198487,   -0.281051,    0.677017}, {   0.011138,    0.005020,    0.003603}, {   0.009552,    0.008132,    0.327838}, {   0.009309,    0.008895,    0.002363}, {   0.018890,    0.023258,    1.022735}, {   0.000869,    0.005929,    0.015935}, {   0.512359,    0.008834,    0.399540}, {   0.005592,    0.000432,    0.043737},
			{   0.002663,    0.004581,    0.042263}, {   0.047485,   -0.047320,    0.001579}, {   0.006872,    0.008264,    0.004982}, {   0.510437,    0.005969,    0.400222}, {   0.513822,    0.005623,    0.400458}, {   0.506179,    0.004668,    0.405074}, {   0.513428,    0.006401,    0.399798}, {   0.506944,    0.010436,    0.400705},
			{   0.016419,    0.008183,    0.003947}, {   0.009006,    0.007633,    0.006124}, {   0.009224,    0.001499,    0.006589}, {   0.005460,    0.000272,    0.011227}, {   0.005386,    0.001248,    0.000497}, {   0.014937,    0.008398,    0.001133}, {   0.495889,    0.503310,    0.256258}, {   0.503077,    0.122800,    1.098476},
			{   0.007261,    0.124725,    1.098476}, {   0.002901,    0.124518,    1.100672}, {   0.507203,    0.124724,    0.601715}, {   0.514312,    0.098875,    2.003752}, {   0.506531,    0.106688,    0.610539}, {   0.014341,    0.106688,    0.527146}, {   0.006531,    0.098890,    0.527146}, {   0.012083,    0.140694,    1.398978},
			{   0.515649,    0.141680,    0.637144}, {   0.016238,    0.149864,    1.398978}, {   0.006862,    0.149864,    1.398978}, {   0.014174,    0.156600,    0.534959}, {   0.020655,    0.155073,    1.990082}, {   0.006529,    0.098874,    1.986894}, {   0.193967,   -0.124264,    0.527146}, {   0.267075,   -0.124264,    0.527146},
			{  -0.181811,   -0.111757,    0.744647}, {  -0.138521,   -0.124264,    1.400786}, {   0.011680,    0.010014,    0.007340}, {   0.007811,    0.089928,    2.005722}, {   0.193746,   -0.124264,    0.527146}, {   0.017105,    0.017211,    0.012148}, {   0.072241,   -0.204843,    0.154247}, {   0.196592,   -0.129188,    1.209316},
			{   0.193509,   -0.129188,    0.527146}, {  -0.137320,   -0.129188,    1.207996}, {   0.193930,   -0.129188,    0.610539}, {  -0.081753,   -0.129188,    0.527146}, {   0.193967,   -0.134334,    0.577147}, {   0.194245,   -0.134334,    0.577147}, {   0.008665,    0.154724,    2.002063}, {   0.192278,   -0.134334,    0.577147},
			{   0.192307,   -0.134334,    0.610539}, {   0.183833,   -0.223919,    0.681626}, {   0.401693,   -0.178823,    0.688814}, {   0.402590,   -0.224971,    0.465452}, {   0.399111,   -0.219593,    0.926801}, {   0.500473,    0.036166,    0.660835}, {   0.502776,    0.501873,    0.611437}, {  -0.027220,   -0.224971,    0.763706},
			{  -0.457260,    0.116031,    0.655960}, {   0.512232,    0.080452,    0.396108}, {   0.019012,    0.083603,    2.015819}, {   0.279051,    0.073429,    0.856204}, {   0.504127,    0.062820,    0.856643}, {   0.509065,    0.071788,    0.400826}, {   0.506017,    0.060237,    0.856204}, {   0.267821,    0.052910,    0.856204},
			{   0.007813,    0.009277,    0.007813}, {   0.012206,    0.009216,    0.007813}, {   0.008985,    0.009166,    0.000000}, {   0.011230,    0.009154,    0.455217}, {   0.488279,   -0.049787,    0.401930}, {   0.499870,    0.050409,    0.943333}, {   0.502164,    0.493809,    0.943333}, {   1.490890,    0.650173,    0.734465},
			{   1.043491,    0.341071,    0.390056}, {   0.853182,   -0.016819,    0.673097}, {   0.443313,    0.015174,    0.638298}, {  -0.463607,    0.116031,    0.655960}, {   0.022671,   -0.627583,   -0.430343}, {   0.003463,    0.003623,    0.003257}, {  -0.219448,   -0.260623,    0.274789}, {   0.245143,    0.206297,    0.911684},
			{  -0.272275,   -0.326873,    0.300532}, {   0.501272,    0.509500,    0.850060}, {   0.004180,    0.006831,   -0.022492}, {   0.010433,    0.003859,    0.000130}, {  -0.316320,   -0.410403,    0.193152}, {   0.022338,    0.930759,    0.843864}, {   0.510963,    0.031895,    0.668648}, {   0.207916,   -0.201057,    1.127747},
			{   0.630645,   -0.162330,    0.949932}, {  -0.258417,   -0.194106,    0.222037}, {   0.489964,    0.016193,    0.638298}, {   0.006165,    0.008465,    0.006893}, {   0.986607,   -0.205047,    0.898838}, {   0.679962,    0.015828,    0.472092}, {   0.935427,    0.015472,    0.472092}, {   0.925746,    0.240584,    0.391923},
			{   1.312036,    0.028613,    0.432646}, {   0.624083,    0.024582,    0.407573}, {   0.004914,    0.003451,    0.001107}, {   0.001539,    0.005816,    0.004544}, {  -0.090755,    0.200005,    0.154908}, {  -0.086260,    0.203488,    0.158636}, {  -0.090664,    0.200028,    0.154972}, {  -0.093321,    0.200305,    0.158824},
			{  -0.092583,    0.202063,    0.154221}, {  -0.090586,    0.201192,    0.160450}, {  -0.085680,    0.200795,    0.161572}, {  -0.090479,    0.209841,    0.164176}, {  -0.087416,    0.200248,    0.160537}, {   0.012765,    0.014419,    0.002417}, {   0.009964,    0.014418,    0.002912}, {   0.011832,    0.014418,    0.002912},
			{   0.177429,    0.885361,    0.642929}, {  -0.148040,   -0.275878,    0.431019}, {   0.010422,    0.007180,    0.167636}, {  -0.270081,   -0.357208,    0.531983}, {   0.006568,    0.003914,    0.002124}, {  -0.307861,   -0.241600,    0.699999}, {  -0.304259,   -0.264420,    0.648293}, {  -0.247071,   -0.263915,    0.452594},
			{   0.008817,    0.004515,    0.001898}, {  -0.372498,   -0.373721,    0.605503}, {   0.508203,    0.516088,    0.260742}, {   0.513992,    0.505034,    0.259647}, {   0.495029,    0.530474,    0.256590}, {   0.010428,    0.060561,   -0.456672}, {   0.003164,    0.007003,    0.004302}, {   0.013287,    0.003510,    1.155017},
			{   0.009277,    0.005226,   -0.011291}, {   0.005245,    0.003582,    0.007125}, {   0.003417,    0.005226,    0.000599}, {   0.004455,    0.005226,    0.001111}, {   0.005795,    0.004143,    0.004275}, {   0.005328,    0.003237,   -0.002760}, {   0.003356,    0.006645,    0.002379}, {   0.005919,    0.000956,    0.007257},
			{   0.008426,    0.008090,    0.010909}, {   0.003874,    0.007203,    0.002862}, {   0.009429,    0.006841,    0.006095}, {   0.008240,    0.007203,    0.006719}, {   0.026353,   -0.005545,   -0.148585}, {   0.009990,    0.000373,   -0.006610}, {   0.018084,    0.017822,    0.009538}, {   0.014508,    0.486609,    0.347279},
			{   0.008755,    0.017288,    0.009802}, {   0.022207,    0.025181,    0.019462}, {   0.022381,    0.015181,    0.011340}, {   0.010467,    0.473670,    0.459100}, {   0.014282,    0.466751,    0.341933}, {   0.005648,    0.490509,    0.385811}, {   0.012145,    0.477553,    0.309902}, {   0.018463,    0.490547,    0.309165},
			{   0.017075,    0.493010,    0.330899}, {   0.018023,    0.483245,    0.359759}, {   0.010332,    0.479339,    0.332248}, {   0.016278,    0.010819,    0.002601}, {   0.015749,    0.480491,    0.332248}, {   0.010439,    0.470207,    0.332248}, {   0.006868,    0.479835,    0.354012}, {   0.011928,    0.473922,    0.341578},
			{   0.009550,    0.473625,    0.421835}, {   0.005404,    0.467254,    0.342700}, {   0.007747,    0.473228,    0.239314}, {   0.003389,    0.473625,    0.334607}, {   0.009127,    0.478401,    0.394398}, {   0.004534,    0.471877,    0.318982}, {   0.009092,    0.473441,    0.249937}, {   0.010863,    0.473746,    0.139888},
			{   0.014270,    0.480453,    0.391891}, {   0.014193,    0.470115,    0.354431}, {   0.013317,    0.459991,    0.353087}, {   0.013457,    0.008049,    0.002600}, {   0.010848,    0.463135,    0.355715}, {   0.013700,    0.468499,    0.328316}, {   0.006773,    0.005255,    0.004120}, {   0.015499,    0.454764,    0.342790},
			{   0.012559,    0.453171,    0.428490}, {   0.009707,    0.007468,    0.007029}, {   0.998115,    0.011152,    0.465761}, {   0.498834,    0.013073,    0.469042}, {   0.003212,    0.005154,    0.469042}, {   0.001797,   -0.002074,    0.253259}, {   0.003725,    0.120067,    1.098476}, {   0.003406,    0.005150,    0.267756},
			{   0.995516,   -0.096386,    1.244313}, {   0.508306,    0.516070,    0.852968}, {   1.327214,    2.563473,    0.406287}, {   0.501662,    2.234500,    0.603129}, {   1.333379,    2.863400,    1.135385}, {   0.490238,    2.047888,    0.776839}, {   0.493178,    2.083256,    0.738874}, {   0.020780,    0.141433,    0.527146},
			{  -0.000025,    0.000319,    1.098098}, {   0.013921,    0.012982,    1.398978}, {  -0.000581,    1.172523,    0.500590}, {   0.508822,    1.194854,    1.150437}, {   0.500351,    0.513450,    0.856204}, {   0.000303,    0.187854,    0.512685}, {   0.003366,    0.002254,    0.007255}, {   0.759096,    0.006754,    0.256590},
			{   0.013162,    0.010019,    0.000735}, {   0.691590,    0.006209,    0.251581}, {   0.766695,    0.018547,    0.253434}, {   0.748475,    0.011138,    0.248807}, {   0.003624,    0.011448,    0.007734}, {   0.011939,    0.017955,    0.004085}, {   0.003671,    0.015354,    0.003164}, {   0.776183,    0.009979,    0.354052},
			{   0.011261,    0.011810,    0.005636}, {   0.768432,    0.013609,    0.248651}, {   0.001668,    0.008205,    0.000362}, {   0.497355,    1.111696,    0.508386}, {   0.005785,    0.003928,    0.005851}, {   0.020493,   -0.055068,   -0.120769}, {   0.007027,    0.003857,    0.005832}, {   0.004127,    0.003924,    0.005834},
			{   0.014159,    1.113237,    0.403562}, {   0.511629,    1.090685,    1.150437}, {   0.497355,    1.117956,    1.158278}, {   0.005464,    0.004157,    0.091632}, {   0.008666,    0.009844,    0.004364}, {   0.514555,    1.054996,    0.487563}, {   0.008469,    0.159614,    0.584061}, {   0.008504,    0.159614,    0.591489},
			{   0.508473,    0.151802,    0.623301}, {   0.014127,    0.134894,    0.591489}, {   0.000391,   -0.000029,    0.591489}, {   0.006527,    0.098890,    0.527146}, {  -0.001276,    0.098890,    0.527146}, {   0.010254,    0.003599,    0.527146}, {   0.004021,    0.006570,   -0.015193}, {   0.007275,    0.002016,    0.004931},
			{   0.003447,    0.008987,    0.008384}, {   0.000998,    0.003104,    0.006118}, {   0.504419,    0.046691,    0.248651}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.009401,    0.004877,    0.005408}, {   0.259815,    0.013844,    0.584034},
			{   0.007978,    0.010758,    0.393155}, {  -0.088453,    0.203013,    0.157902}, {  -0.082700,    0.204624,    0.160757}, {  -0.082121,    0.201947,    0.163690}, {   0.008290,    0.142174,    0.523811}, {   0.002065,    0.000381,    0.007559}, {   0.002823,    0.009081,    0.005621}, {   0.010188,    0.003469,    0.001144},
			{   0.261357,   -0.016434,    0.495707}, {   0.356994,    0.007718,    0.516224}, {  -0.221042,   -0.365058,    0.288392}, {  -0.187804,   -0.176852,    0.474460}, {  -0.110418,   -0.157413,    0.523042}, {  -0.247078,   -0.168586,    0.317389}, {   0.318145,    0.308494,    0.632889}, {   0.588257,   -0.082575,    0.523519},
			{   0.969428,   -0.082575,    0.523519}, {  -0.206148,   -0.238979,    0.259618}, {   0.322331,    0.359780,    0.425967}, {   0.041717,    0.607065,    0.547948}, {  -0.208068,    0.608532,    0.546123}, {   0.893601,   -0.307815,    1.022158}, {   0.007265,    0.003831,    0.007065}, {   1.123265,   -0.229689,    1.254693},
			{   1.147953,    0.322706,    0.623673}, {   0.005133,    0.010688,    0.004720}, {   0.001227,    0.002432,    0.004678}, {   1.256077,    0.483536,    1.105000}, {   0.013039,    0.007867,    0.003459}, {   0.002351,    0.004172,    0.004801}, {   0.004573,    0.004488,    0.000597}, {  -0.003835,    0.004525,    0.007065},
			{   0.000319,    0.006264,    0.001831}, {   0.598604,   -0.249707,    0.695527}, {   0.004867,    0.006264,    0.001831}, {   0.141724,    0.117473,    0.609297}, {  -0.243895,   -0.242180,    0.746752}, {   0.005584,    0.003829,    0.000867}, {   0.007720,    0.002275,    0.006364}, {   0.007193,    0.006225,    0.004678},
			{   0.004867,    0.003828,    0.002076}, {  -0.244202,   -0.240676,    0.746752}, {   0.004945,    0.006535,    0.001612}, {   1.376289,    0.076545,    1.370859}, {   0.003967,    0.003829,    0.000867}, {   0.000616,    0.003829,    0.004678}, {   0.004157,    0.003829,    0.000522}, {   0.000701,    0.003829,    0.007065},
			{   1.375206,   -0.191591,    1.370859}, {   0.007720,    0.003829,    0.004678}, {   0.010058,    0.001448,    0.230125}, {   2.618732,    2.579277,    2.412138}, {   0.011393,    0.004095,    0.000174}, {   0.006326,    0.004095,    0.000174}, {   0.006426,    0.004095,    0.000174}, {   0.012764,    0.002956,    0.003903},
			{   0.010826,    0.000962,   -0.027681}, {  -0.001398,    0.006887,    0.003301}, {   0.006326,    0.004569,    0.001811}, {   0.007304,    0.011367,    0.003903}, {  -0.352416,   -0.215330,    0.654892}, {   0.318046,   -0.082751,    0.523734}, {   0.513482,   -0.045894,    0.529950}, {  -0.066256,    0.219944,    0.576794},
			{   0.468786,    0.097525,    1.090340}, {   0.003428,   -0.026589,    0.556053}, {   0.459383,    0.091137,    0.603820}, {   0.465887,    0.096023,    0.534220}, {  -0.143409,   -0.221557,    0.655628}, {  -0.147712,   -0.209362,    0.222662}, {  -0.259855,   -0.196819,    0.228440}, {   0.034538,    0.040373,    0.531208},
			{  -0.017061,   -0.067070,    0.531208}, {  -0.213834,   -0.194564,    0.369387}, {   0.017424,   -0.128075,    0.190007}, {  -0.047414,   -0.194564,    0.463432}, {  -0.008391,   -0.199432,    0.842978}, {  -0.228178,   -0.347027,    0.590237}, {   1.576500,   -0.249954,    0.508203}, {   0.959407,   -0.249954,    0.506600},
			{   0.990410,   -0.450852,    0.565802}, {   0.494803,   -0.076323,    0.523734}, {   0.087226,    0.082859,    0.531208}, {  -0.017819,   -0.023821,    0.531208}, {   0.331265,   -0.074697,    0.593043}, {  -0.212046,   -0.316776,    0.492332}, {   0.034295,   -0.016253,   -0.489091}, {   0.011212,   -0.071888,    0.520557},
			{   0.015472,    0.017402,    0.525883}, {   0.011905,   -0.069275,    0.531208}, {   0.217866,    0.223719,    0.531208}, {  -0.015366,   -0.062392,    1.174649}, {   0.010327,   -0.067566,    0.531208}, {   0.013089,   -0.067566,    0.531208}, {   0.021366,   -0.121491,    0.519813}, {   0.024654,   -0.106756,    0.807139},
			{   0.726682,   -0.106756,    0.807139}, {   0.722652,   -0.106756,    1.031666}, {  -0.117927,   -0.121491,    0.531208}, {   0.469568,    0.087913,    0.588360}, {   0.301317,   -0.058814,    1.228162}, {   0.027892,    0.015623,    0.000456}, {   0.075003,    0.074473,    0.522261}, {  -0.008266,   -0.032496,    0.509479},
			{  -0.094116,   -0.196955,    0.516811}, {   0.488734,   -0.032496,    0.745158}, {   0.240007,   -0.058409,    0.833772}, {   0.720543,    0.120834,    0.833772}, {   0.703607,   -0.051332,    0.553806}, {   0.013868,   -0.051332,    0.553806}, {  -0.117279,   -0.191626,    1.124662}, {   0.256556,   -0.191626,    1.124662},
			{   0.018346,    0.027049,    0.015397}, {   0.019562,    0.021270,    0.007466}, {   0.028637,    0.017333,    0.000148}, {   0.244433,   -0.137676,    1.006973}, {  -0.187784,   -0.201280,    0.177698}, {   0.051647,   -0.093419,    0.125668}, {   0.003225,   -0.066340,    0.125668}, {   0.004385,    0.010083,    0.006579},
			{   0.155368,   -0.359230,    0.039388}, {   0.161627,   -0.248760,    0.060063}, {   0.157703,   -0.349236,    0.028727}, {   0.258363,   -0.191626,    1.124662}, {   0.014852,    0.019617,    0.008739}, {   0.025452,    0.019225,    0.004708}, {   0.020810,    0.016937,    0.003051}, {   0.015314,    0.020447,    0.003206},
			{   0.025056,    0.021545,    0.002272}, {   0.018791,    0.016480,    0.003838}, {   0.187102,   -0.182668,    1.021183}, {   0.017005,    0.020354,    0.002157}, {   0.005187,    0.010619,    0.004776}, {  -0.052763,   -0.009650,    0.067638}, {   0.467868,   -0.046730,    0.030129}, {   0.004209,    0.015410,    0.002139},
			{   0.005677,    0.009390,    0.002743}, {   0.005677,    0.009390,    0.001184}, {   0.005677,    0.009390,    0.001438}, {  -0.244445,   -0.237549,    0.946888}, {   0.010315,   -0.000058,    0.001693}, {   0.006461,    0.021953,    0.005332}, {  -0.010327,    0.019687,    0.001693}, {   0.005677,    0.009390,    0.004253},
			{  -0.006465,   -0.003874,    0.007321}, {   0.006349,    0.011962,    0.003132}, {   0.006320,    0.014527,    0.003132}, {   0.005371,    0.013152,    0.001921}, {  -0.213559,   -0.188082,    0.369387}, {   0.013427,    0.101198,    0.104511}, {   0.196897,   -0.182661,    1.021183}, {   0.014953,    0.101198,    0.104511},
			{   0.015869,    0.101198,    0.104511}, {  -0.087039,    0.101198,   -0.095490}, {  -0.084995,    0.101198,   -0.095490}, {  -0.011811,    0.101198,   -0.095490}, {  -0.091067,    0.101198,   -0.095490}, {   0.003328,    0.016753,    0.004042}, {   0.061744,    0.402509,    0.005078}, {   0.050829,    0.474072,   -0.000265},
			{   0.005979,    0.010650,    0.069888}, {   0.004499,    0.012210,    0.006881}, {   0.004867,    0.218467,    0.470504}, {   0.009370,    0.013701,    0.004375}, {   0.645433,    0.008206,    0.294030}, {   0.085040,    0.944351,    1.084509}, {   0.514358,    0.277978,    0.837059}, {   0.645433,    0.007720,    0.294030},
			{   0.084655,    0.954787,    1.135346}, {   0.011489,    0.177742,    0.530472}, {   0.661252,    0.007888,    0.999135}, {   0.507660,    0.229190,    0.513110}, {   0.493818,    0.305373,    0.513110}, {   0.011509,    0.186279,    0.542304}, {   0.628922,    0.017018,    0.362590}, {   0.070647,    0.946671,    0.944082},
			{   0.006409,    0.069505,    0.472187}, {   0.002562,    0.070891,    1.182165}, {   0.006271,    0.078704,    1.182165}, {   0.003575,    0.084784,    1.174649}, {   0.006271,    0.084784,    1.174649}, {   0.002562,    0.084784,    1.174649}, {   0.011386,    0.072342,    1.174649}, {   0.008910,    0.012900,    1.998255},
			{   0.001097,    0.012900,    2.009875}, {   0.001099,    0.012900,    2.013756}, {   0.001492,    0.004881,    1.987746}, {   0.001099,    0.012694,    2.006771}, {   0.008516,    0.004881,    1.999858}, {   0.001099,    0.160969,    1.995736}, {   0.003904,    0.166396,    2.005013}, {   0.001099,    0.096909,    2.008080},
			{   0.133212,    0.049353,    1.999441}, {  -0.115391,    0.049353,    1.992179}, {   0.001101,    0.168996,    0.835460}, {   0.001490,    0.007482,    0.936434}, {   0.001101,    0.015294,    0.936434}, {   0.008519,    0.007482,    0.936444}, {   0.006107,    0.168998,    0.835460}, {   0.003902,    0.168998,    0.835460},
			{  -0.115395,    0.051954,    0.835460}, {   0.133217,    0.051954,    0.835460}, {   0.001101,    0.099509,    0.835460}, {   1.354781,   -0.123469,    0.537593}, {  -0.138496,   -0.123469,    0.537593}, {   0.132891,   -0.123469,    0.537593}, {   0.501098,    0.364996,    0.681111}, {   0.501092,    0.364244,    0.689285},
			{   2.000000,    0.342142,    0.683138}, {   2.007812,    0.348237,    0.681111}, {   1.516096,    0.061108,    0.826057}, {   1.505771,    1.266865,    0.660849}, {   2.517716,    1.249513,    0.660849}, {   2.500519,    1.276852,    0.005991}, {   1.514052,    1.276852,    0.005991}, {   0.079258,    0.017102,    0.006006},
			{   1.547346,    0.058217,    0.898514}, {   1.516101,    0.065072,    0.974339}, {   1.516283,    0.108999,    0.723163}, {   1.531059,    0.727083,    0.468189}, {   1.510934,    0.667430,    0.577399}, {   1.622014,    0.097190,    0.972122}, {   1.486642,    0.099321,    0.790764}, {   1.501451,    1.289214,    0.193474},
			{   1.629513,    0.088977,    1.081962}, {   0.017777,    0.018982,    0.007389}, {   0.014217,    0.025009,    0.002431}, {   0.018857,    0.025009,    0.002431}, {   0.016784,    0.035964,    0.015639}, {   0.017091,    0.019774,    0.006552}, {   0.018066,    0.019012,    0.002078}, {   0.012450,    0.019012,    0.002078},
			{   0.014921,    0.020554,    0.005646}, {   0.018001,    0.024109,    0.002431}, {   0.014285,    0.018982,    0.000297}, {   0.020689,    0.038621,    0.011070}, {   0.017757,    0.032226,    0.011238}, {  -0.082355,    0.045795,   -2.638075}, {  -0.042043,    0.064640,   -1.143241}, {  -0.014173,   -0.010718,    0.002431},
			{   0.014921,    0.017634,    0.412081}, {   0.011610,    0.019872,    0.006223}, {   0.014829,    0.015564,    0.000190}, {   0.018308,    0.024654,    0.000144}, {   0.024077,    0.016524,    0.012318}, {   0.018385,    0.019872,    0.006223}, {   0.014313,    0.016326,    0.006353}, {   0.019135,    0.021254,    0.005710},
			{   0.012268,    0.007232,    0.005588}, {   0.008286,    0.010665,    0.009255}, {   0.007934,    0.015426,    0.006686}, {   0.014405,    0.011589,    0.001135}, {   0.008836,    0.007921,    0.044899}, {   0.007672,    0.013008,    0.272772}, {   0.009827,    0.010026,    0.004162}, {   0.012025,    0.012839,    0.012299},
			{   0.012420,   -0.015866,    0.040635}, {   0.007005,    0.015065,    0.000813}, {   0.009216,    0.014395,    0.007062}, {   0.010196,   -0.007071,    0.010095}, {  -0.068375,    0.017418,   -0.038013}, {  -0.305236,   -0.888409,    0.196187}, {   0.014467,    0.012852,    0.005177}, {   0.010646,    0.014078,    0.002727},
			{  -0.213882,   -0.011653,    0.154989}, {   1.516270,    0.791131,    0.002500}, {   0.001986,    0.044776,    0.856769}, {   0.006413,    0.004499,    0.000022}, {   0.013671,    0.006072,    0.003655}, {   0.015930,    0.006072,    0.000829}, {   0.017579,    0.012558,    0.006703}, {   0.014343,    0.027860,    0.000537},
			{   0.016536,    0.010277,    0.003969}, {   0.021240,    0.002799,    0.000730}, {   0.015500,    0.010452,    0.256889}, {   0.009151,    0.000216,    0.652154}, {   0.009641,    0.005743,    1.199177}, {   0.012143,    0.012799,    0.557765}, {   0.008483,    0.012811,    0.637821}, {   0.008530,    0.011322,    0.003672},
			{   0.008957,    0.016143,    0.003672}, {   0.005295,    0.008507,    0.002039}, {   0.003184,    0.003324,    0.003550}, {   0.021072,    0.017517,    0.010831}, {   0.018028,    0.027245,    0.005634}, {   0.013212,    0.020767,    0.010742}, {   0.013260,    0.022430,   -0.055176}, {   0.015580,    0.025350,   -0.003722},
			{   0.029575,    0.017681,    0.005206}, {   0.019683,    0.017888,    0.011070}, {   0.014983,    0.015472,    0.012707}, {   0.015869,    0.024520,    0.015995}, {   0.023552,    0.017609,    0.010831}, {   0.014526,    0.015472,    0.018981}, {   0.021423,    0.018112,    0.009785}, {   0.015045,    0.011734,   -0.003067},
			{   0.008243,    0.004509,    0.013213}, {   0.014525,    0.007644,    0.000670}, {   0.017857,    0.010079,    0.006165}, {   0.015568,    0.010080,    0.006165}, {   0.016246,    0.013140,    0.007761}, {   0.022034,    0.008217,    0.006165}, {   0.019796,    0.022058,    0.008527}, {   0.011177,    0.019531,    0.016845},
			{   0.009727,    0.019531,    0.016845}, {   0.009483,    0.019531,    0.016845}, {   0.013664,    0.019531,    0.016845}, {   0.014523,    0.019455,    0.006504}, {   0.013367,    0.019516,    0.008178}, {   0.016112,    0.019516,    0.008178}, {   0.020310,    0.021941,    0.009828}, {   0.007652,    0.017139,   -0.002901},
			{   0.755101,   -0.051672,    0.006173}, {   0.013480,    0.017898,    0.014878}, {   0.021967,    0.026606,    0.022298}, {   0.021849,    0.026606,    0.022298}, {   0.019865,    0.026606,    0.022298}, {   0.005535,    0.000140,    0.047678}, {   0.011171,    0.008194,    0.002292}, {   0.619036,    0.043467,    0.008411},
			{   0.011071,    0.008674,    0.004827}, {   0.016852,    0.005900,    0.001680}, {   0.287086,   -0.022749,    0.004488}, {   0.009161,    0.013554,    0.005750}, {   0.012020,    0.006761,    0.007511}, {   0.014737,    0.010941,    0.004643}, {   0.382288,   -0.061687,    0.136648}, {  -0.373293,   -0.061687,    0.136648},
			{   0.000564,    0.016278,   -0.005948}, {   0.022577,    0.013834,    1.048110}, {   0.002758,    0.008317,    0.013175}, {   0.009921,    0.013092,    0.009952}, {   0.010192,    0.020944,    0.016042}, {   0.011168,    0.020944,    0.016042}, {   0.015345,    0.020944,    0.016042}, {   0.015345,    0.020944,    0.016744},
			{   0.011168,    0.019027,    0.016253}, {   0.005855,    0.008066,    0.005931}, {   0.019268,    0.027573,    0.013689}, {   0.018301,    0.021422,    0.013969}, {   0.018921,    0.013907,    0.001667}, {   0.017069,   -0.111125,    0.040093}, {   0.011657,    0.001082,    0.005028}, {   0.013664,    0.019531,    0.021018},
			{   0.009483,    0.019531,    0.021018}, {   0.022780,    0.013167,    0.011016}, {   0.001817,    0.010054,    0.002260}, {   0.002013,    0.007615,    0.002946}, {   0.018402,    0.025336,    0.006657}, {   0.003663,    0.000030,    0.002902}, {   0.012161,    0.017857,    0.006554}, {   0.018556,    0.016595,    0.007288},
			{   0.005886,    0.009180,    0.005931}, {   0.009487,    0.005365,    0.005931}, {   0.005489,    0.005365,    0.005931}, {   0.012312,    0.024374,   -0.278665}, {   0.715328,   -0.091658,    1.251606}, {   0.013000,    0.011113,    0.001688}, {   0.013770,    0.012222,    0.004248}, {   0.013844,    0.015212,    0.001736},
			{   0.005748,    0.016280,    0.006277}, {   0.005059,    0.016273,    0.007124}, {   0.014953,    0.004908,    0.000203}, {   0.024288,    0.026606,    0.020005}, {   0.022305,    0.026606,    0.020005}, {   0.024404,    0.026606,    0.020005}, {   0.006988,    0.007871,    0.003623}, {   0.013125,    0.021941,    0.005270},
			{   0.012362,    0.021941,    0.005270}, {   0.015993,    0.021941,    0.005270}, {   0.369906,    0.021941,    0.008131}, {   0.008650,    0.009581,    0.001366}, {   0.001798,    0.009583,    0.002231}, {   0.006866,    0.009581,    0.001366}, {   0.001021,    0.009583,    0.001366}, {   0.018061,    0.009171,    0.000633},
			{   0.037124,    0.008941,    0.413545}, {   0.008565,    0.018798,    0.007888}, {   0.007751,    0.018798,    0.007888}, {   0.014243,    0.018798,    0.007888}, {   0.007751,    0.090747,    0.012969}, {   0.014243,    0.090747,    0.012969}, {   0.008565,    0.090747,    0.012969}, {   0.014546,    0.090747,    0.012969},
			{   0.007490,    0.012618,    0.006996}, {  -0.217971,   -0.011969,    0.154989}, {   0.007385,    0.051290,    0.007739}, {   0.503288,    0.286657,    0.469193}, {   0.009552,    0.013213,    0.079999}, {   0.001551,    0.006744,    0.005344}, {   0.004095,    0.004333,    0.001557}, {   0.000243,    0.001739,   -0.258150},
			{  -0.179566,    0.001894,   -0.326339}, {   0.003936,    0.001534,    0.004445}, {   0.005100,    0.013886,    0.006000}, {   0.004606,    0.010321,    0.004679}, {   0.005100,    0.014724,    0.006000}, {   0.015746,    0.013840,    0.158651}, {   0.116880,    0.000000,    0.181098}, {   0.013794,    0.013840,    0.002591},
			{   0.017241,    0.015533,    0.150000}, {   0.012849,    0.014117,    0.001877}, {   0.001859,    0.001952,    0.003969}, {   0.003544,    0.006165,    0.006465}, {   0.009398,    0.001534,   -0.516031}, {   0.171470,    3.041604,    0.629841}, {  -0.195820,    2.994982,    0.616804}, {  -0.018193,    3.141702,    0.617175},
			{  -0.011219,    3.236097,    0.370900}, {  -0.011219,    3.835648,    0.104515}, {   0.018247,    0.020881,    0.006374}, {   0.020131,    0.024886,    0.006374}, {   0.024328,    0.019516,    0.006982}, {   0.988579,   -0.450852,    0.561132}, {   0.024871,    0.018112,    0.010955}, {   0.004174,    0.008240,    0.011855},
			{   0.001274,    0.007737,    0.013411}, {   0.002375,    0.007919,    0.005377}, {   0.002680,    0.007859,    0.002437}, {   0.016450,    0.014117,    0.001877}, {   0.005011,    0.008713,    0.006134}, {   0.013617,    0.009964,    0.007044}, {   0.012059,    0.014538,    0.004459}, {   0.012190,    0.009436,    0.000579},
			{   0.007490,   -0.002819,    0.030410}, {   0.000410,   -0.002819,    0.030410}, {   0.024271,    0.020182,    1.048110}, {   0.023081,    0.020183,    1.048110}, {   0.019562,   -0.065681,    0.382476}, {  -0.083810,   -0.233550,    0.214682}, {   0.000207,   -0.000365,   -0.098768}, {   0.003059,    0.006053,    0.005245},
			{   0.003525,   -0.000035,    0.001236}, {  -0.001424,    0.000255,    0.005187}, {  -0.001424,    0.000255,    0.005187}, {   0.003197,    0.021696,   -0.010370}, {   0.001949,    0.003520,    0.007664}, {   0.000030,    0.002892,    0.000353}, {   0.005597,    0.002892,    0.000353}, {   0.000030,    0.002891,    0.006517},
			{   0.001952,    0.003482,    0.004623}, {   0.001952,    0.001713,    0.004623}, {   0.001952,    0.003207,    0.004623}, {   0.001952,    0.002951,    0.004623}, {   0.005768,    0.001713,    0.001963}, {   0.005313,    0.001713,    0.005057}, {   0.006335,    0.002044,    0.003273}, {  -0.001752,    0.017411,    0.033066},
			{   0.029162,   -0.008809,    0.375371}, {   0.000667,   -0.012972,    0.539641}, {   0.088564,    0.010622,    0.209892}, {   0.001708,    0.002478,   -0.078491}, {  -0.003397,    0.010963,    0.006173}, {   0.001372,    0.006893,    0.006173}, {   0.005646,    0.002480,    0.006173}, {   0.001949,    0.004943,    0.007569},
			{   0.013263,    0.019316,   -0.013120}, {  -0.030867,    0.053991,    0.833163}, {   0.068823,   -0.081897,    1.309645}, {   0.009793,    0.005317,    0.750711}, {   0.006897,    0.014329,    0.067025}, {   0.011920,    0.007567,    0.043287}, {   0.006411,    0.004151,    0.054643}, {   0.510188,    0.506389,    0.005425},
			{   0.006184,    0.007981,    0.013323}, {   0.505123,    0.499913,    0.005425}, {   0.499568,    0.497714,    0.012613}, {   0.506734,    0.529924,    0.057133}, {   0.000487,    0.000098,    0.108659}, {   0.003656,    0.006134,    0.254094}, {   0.006287,    0.005410,    0.061101}, {   0.008299,    0.008170,    0.120136},
			{   0.009991,    0.004288,    0.075470}, { 102.875068,   83.337142,   -0.543583}, {   0.009806,    0.003697,    0.014977}, {   0.006531,    0.007094,    0.062513}, {   0.010894,    0.005034,    0.132469}, {   0.006843,    0.010382,    0.057953}, {   0.004149,    0.002659,    0.076898}, {   0.013670,    0.005799,    0.071454},
			{   0.006285,    0.007011,    0.113996}, {   0.502376,    0.509001,    0.005425}, {   0.502376,    0.509783,    0.005425}, {   0.508408,    0.492188,    0.009003}, {   0.510188,    0.506287,    0.005425}, {   0.008604,    0.007675,    0.120128}, {   0.009362,    0.004377,    0.095927}, {   0.006256,    0.008599,    0.139910},
			{   0.012767,    0.006763,    0.062045}, {   0.503220,    0.489549,    0.004335}, {   0.518254,    0.513426,    0.021248}, {   0.513611,    0.507309,    0.038320}, {   0.508975,    0.510941,    0.075069}, {   0.515106,    0.520862,    0.046383}, {   0.490837,    0.487717,    0.075332}, {   0.510953,    0.518697,    0.007058},
			{   0.006765,    0.006976,    0.057953}, {   0.005346,    0.007687,    0.114210}, {   0.010619,    0.006405,    0.067025}, {   0.000417,    0.002873,    0.087747}, {   0.004672,    0.010900,    0.018186}, {   0.006560,    0.002745,    0.134005}, {   0.009774,    0.007755,    0.035300}, {   0.008941,    0.008201,    0.072121},
			{   0.003112,    0.004385,    0.090020}, {   0.007815,    0.007730,    0.126987}, {   0.006194,    0.012126,    0.138083}, {   0.006539,    0.011553,    0.059509}, {   0.013020,    0.084686,    0.054643}, {   0.007860,    0.011222,    0.174364}, {   0.003844,    0.007950,    0.055667}, {   0.011206,    0.011459,    0.100197},
			{   0.002105,    0.006699,    0.115488}, {   0.009642,    0.003286,    0.115399}, {   0.013834,    0.005456,    0.173570}, {   0.028497,    0.055500,    0.256731}, {   0.007354,    0.006401,    0.261004}, {  -0.025420,    0.030394,    0.672851}, {   0.011234,    0.008042,    0.240566}, {   0.008608,    0.160239,    1.798732},
			{   0.028610,    0.013836,    1.048110}, {   0.733982,   -0.074973,    0.006173}, {  29.469989,   26.345432,    1.686059}, {   0.733982,   -0.074973,    0.006173}, {   0.733982,   -0.074973,    0.006173}, {   0.733982,   -0.074973,    0.006173}, {   0.733982,   -0.074973,    0.006173}, {   0.733982,   -0.074973,    0.006173},
			{   0.084928,    0.084345,    0.009320}, {   0.102796,    0.085212,    0.019417}, {  -4.304039,    0.239250,    0.153419}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.013058,    0.234520,   -3.356360}, {   0.006264,   -0.046833,    0.002155}, {  -0.005537,    1.194468,    0.763279},
			{  -0.718759,   -0.141725,    0.649496}, {   0.049646,   -0.034814,   -2.050823}, {  -0.013000,   -1.263098,    1.071199}, {   0.014348,    0.014344,    0.116999}, {   0.010607,    0.003692,    0.126219}, {   0.006825,   -2.781178,   -0.887773}, {   0.014789,    0.004569,    0.027938}, {   0.008678,    0.007567,    0.003823},
			{  -6.663750,    0.011574,   -0.163561}, {   0.004437,    0.007546,    0.000598}, {   0.007304,    0.014426,    0.003992}, {   0.008828,    0.007201,    0.001218}, {   0.005634,    0.013248,    0.679702}, {  -0.050214,   -0.001579,    0.019154}, {   0.331959,    0.008062,    0.004951}, {   0.001778,    0.012509,   -2.040102},
			{   0.005210,    0.012839,    0.006750}, {   0.017094,    0.029342,    0.012652}, {   0.014223,    0.016101,    0.005987}, {   0.004129,    0.009925,   -0.002679}, {   0.009395,    0.008205,    0.004279}, {   0.000629,    0.007170,    0.015359}, {   0.001759,    0.001983,    0.000000}, {   0.511394,    0.004954,    1.065345},
			{   0.003289,    0.000860,    0.344597}, {   0.061432,    0.002283,    0.464567}, {   0.460761,   -0.009362,    0.504947}, {  -0.215617,    0.005489,    0.003039}, {   0.013984,    0.003017,    0.007662}, {  -0.005975,    0.007104,   -1.179687}, {  -0.141341,   -0.115828,   -0.618959}, {   0.006221,    0.019021,    0.007387},
			{   0.004749,   -0.015188,    3.514736}, {  -0.588649,    0.045724,    0.310200}, {   0.012883,    0.008475,    0.007131}, {   0.008589,    0.008809,    1.055212}, {  -0.652817,    0.009945,    0.000000}, {   0.021091,   -0.016154,    0.404633}, {   0.021091,   -0.016154,    0.234703}, {   0.004373,    0.007780,    0.007966},
			{   0.004960,   -0.119846,    0.001124}, {   0.003092,    0.007976,    0.007966}, {  -0.034970,   -0.854893,   -1.317275}, {   0.115561,   -1.599472,    0.982273}, {   0.004894,    0.013078,    0.000747}, {   0.006322,    0.008585,    0.002565}, {   0.005522,    0.013077,    0.000747}, {   0.011423,    0.013077,    0.000747},
			{   0.021363,    0.046344,    0.024438}, {   0.008511,    0.014545,    0.001090}, {   0.006790,    0.005419,    0.003172}, {   0.017704,    2.849639,    1.237684}, {   0.017704,   -2.876611,   -1.074983}, {   0.006372,    0.016550,    0.004292}, {   0.012617,    0.018146,    0.335027}, {   0.016193,    0.014717,   -0.023367},
			{  -0.065150,   -0.713174,   -0.074179}, {  -0.228790,    0.010173,    0.298676}, {   0.006876,    0.803932,    1.193819}, {  -0.079613,   -0.676759,    1.049999}, {   0.004234,   -0.473203,    1.268959}, {   0.008063,   -0.735773,    1.248167}, {  -2.096623,   -4.718986,    0.002817}, {   0.016659,    0.012241,    1.867982},
			{   0.003762,   -1.071962,    1.355155}, {   0.014498,    0.003462,    0.001515}, {   0.007242,   -0.478471,    1.050078}, {  -0.009409,   -0.642284,    0.001945}, {   4.559874,    0.011598,    3.457834}, {   0.019797,    0.008658,    0.007373}, {  -0.000897,    0.002684,   -0.002007}, {  -0.042357,    0.760069,    1.258190},
			{   0.003336,    0.011638,   -0.141643}, {   0.012028,    0.006223,    0.004242}, {   0.011010,    0.043317,    0.021014}, {  -0.159168,    0.009685,    0.129418}, {   0.007201,    0.011168,    0.487259}, {   0.006835,    0.006897,    0.002467}, {   0.018672,    0.164545,   -0.010160}, {   0.021071,    0.039117,    0.024938},
			{   0.006831,    0.026328,   -0.012342}, {   0.006560,    0.011091,    0.015854}, {  -0.075006,   -0.670060,    1.049999}, {   0.011501,    0.005952,    0.916658}, {   0.008582,    0.011777,    0.603464}, {   0.007668,    0.014523,    1.233711}, {   0.006988,    0.009163,    1.503252}, {   0.001714,    0.003998,    0.803883},
			{   0.006238,    0.006409,    0.388592}, {   0.010746,    0.007172,    0.662428}, {   0.009120,    0.006004,    0.182519}, {   0.020774,    0.012063,    0.009695}, {   0.012450,   -0.056945,   -0.127644}, {   0.139206,    0.011992,    0.009677}, {  -0.098070,    0.012059,    0.009680}, {   0.004337,    0.005845,    0.000999},
			{   0.005367,    0.001718,    0.005590}, {   0.306030,   -0.003522,    0.660847}, {  -0.492778,    0.006862,    0.005969}, {   0.003439,    0.009181,    0.001438}, {   0.007102,   -2.088304,    1.963523}, {   0.014066,    0.003189,    0.003238}, {   0.003159,    0.017619,    0.000753}, {   0.003986,    0.002072,    0.001162},
			{   0.004137,    0.004664,    0.000339}, {   0.468134,   -0.015317,    0.504947}, {   0.004112,    0.003718,    0.001492}, {   0.000000,    0.000000,    0.000232}, {   0.000000,    0.000000,    0.000232}, {   0.000000,    0.000000,    0.000232}, {   0.000000,    0.000000,    0.000232}, {   0.000000,    0.000000,    0.000232},
			{   0.000000,    0.000000,    0.000232}, {   0.000000,    0.000000,    0.000232}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,   -0.000197}, {  -0.000232,    0.782023,    0.054632}, {   0.307379,   -0.448217,    0.273294}, {   0.382281,   -0.430402,    0.670337}, {  -0.132405,   -0.123447,    0.215103},
			{   0.288670,   -0.202112,    0.196759}, {  -0.117312,   -0.078401,    0.548825}, {  -0.148352,    0.310057,   -0.334309}, {  -0.398510,    0.012517,   -0.364719}, {  -0.105224,   -0.399809,    0.607252}, {   0.012202,   -0.007834,   -0.013972}, {   0.085029,    0.001027,    0.016092}, {   0.069008,    0.005264,    0.243761},
			{   0.015029,   -0.007834,   -0.013972}, {   0.007348,   -0.101990,   -0.002564}, {  -0.222176,   -0.085064,   -3.257889}, {   0.221332,   -0.085064,   -3.261164}, {   0.188991,   -0.085064,   -2.680238}, {  -0.183247,   -0.085064,   -2.603250}, {  -0.536450,   -0.085064,   -2.277982}, {   0.038476,   -0.085064,   -2.164633},
			{  -0.366798,   -0.085064,   -1.892199}, {  -0.082967,    0.036864,   -1.780832}, {   0.236044,    0.034878,    0.001130}, {   0.000174,    0.005375,    0.056060}, {   0.075631,   -0.019129,   -0.367906}, {  -0.038858,    0.878103,    1.431084}, {   0.007428,    0.008524,    4.165480}, {  -0.191843,    0.305290,   -0.488047},
			{  -0.001996,   -0.012252,    0.003402}, {   0.000789,    0.000283,   -1.022704}, {  -0.001997,   -0.010897,    0.003402}, {   0.001647,    0.001535,    0.000960}, {   2.358782,    0.000929,   -0.000001}, {   0.024986,    0.016147,    0.006639}, {   0.005138,    0.010138,   -0.864023}, {   0.008696,    0.028061,    1.322345},
			{   0.007267,   -0.001444,   -1.069257}, {   0.004466,    0.011749,    0.270942}, {   0.023189,    0.510190,    0.692225}, {   0.015627,    0.017867,    0.000747}, {   0.065715,   -0.127451,   -0.026249}, {   0.068279,   -0.185473,   -0.026249}, {   0.005408,    0.055989,    0.001215}, {   0.137133,    0.006194,    0.300287},
			{   0.006469,    0.004989,    0.001867}, {  -2.235095,   -0.147892,   -0.311814}, {  -2.335901,    0.157747,   -0.311814}, {   0.005162,    0.004749,    0.000000}, {   0.007259,    0.018062,    0.015854}, {   0.007360,    0.001190,    0.002909}, {   0.006515,    0.001055,   -1.137174}, {   0.023036,   -0.045600,    0.324272},
			{   0.007596,   -0.000089,   -0.396378}, {   0.008898,    0.064733,    0.000342}, {  -0.103384,    0.055539,    0.019695}, {   0.073242,    0.002685,    0.003783}, {   0.002513,    0.000000,    0.320311}, {   0.044739,    0.474521,    0.003434}, {   0.786184,   -0.019615,    0.055435}, {   1.382477,    2.150512,    1.794319},
			{   0.818054,   -0.016449,   -0.424822}, {   0.016442,    0.014498,    0.004982}, {   0.004304,    0.301752,    0.247257}, {   0.011734,    0.046565,   -0.031544}, {   0.011931,   -0.067938,    0.557402}, {   0.028645,    6.028553,    0.275869}, {   0.001573,    0.060777,    0.093562}, {   0.076842,    0.024114,    0.012931},
			{   0.073944,    0.029354,   -0.011931}, {  -0.007664,    0.032173,    0.106055}, {   0.015556,    0.009065,    3.971606}, {   1.580582,   -1.605682,    0.649182}, {   0.005348,    0.002876,    0.000356}, {   0.040486,    0.003191,    1.564681}, {   0.005080,    0.000174,    0.000049}, {   0.005472,    0.002026,    0.000356},
			{  -0.040192,   -0.334322,    0.419973}, {  -0.000155,   -0.269055,    0.451674}, {   0.000144,   -0.007813,    0.114182}, {   2.910399,   -0.795044,    5.655402}, {   0.005497,   -0.049206,    0.009285}, {   0.006926,    0.053674,    2.002757}, {   0.911827,    0.053819,    2.266729}, {   0.011451,    0.053674,    2.002757},
			{   0.008979,    0.053674,    2.002757}, {   0.743323,   -0.002511,    0.020997}, {   0.006016,   -0.746394,    1.000000}, {   0.236414,    0.011520,    0.471657}, {   0.024819,   -0.020522,   -0.008617}, {   0.006250,    0.688682,    0.002752}, {   0.007201,    0.015855,    0.486108}, {   0.007385,    0.005615,    0.279365},
			{   0.023295,    0.015785,    0.024801}, {  -1.614735,   -4.844212,   -1.641010}, {   0.020570,    0.145595,    0.002971}, {  -2.327291,    1.689170,    1.908383}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.887098,    0.008524,    3.288449}, {   0.003657,    0.003046,    0.027798}, {  -0.042488,    0.747343,    0.005878}, {   0.269270,    0.666513,    6.888117}, {   0.004021,    0.007220,    0.000049},
			{   0.001562,    0.005774,    0.006306}, {  -0.414775,    0.008890,    1.630399}, {  -0.009804,    0.002296,    0.604278}, {   0.007294,    0.001218,    0.338196}, {   0.196667,    0.007761,   -1.258556}, {  -0.003973,   -0.004248,    0.005301}, {   0.000000,    0.000000,    0.000000}, {   0.015406,    0.138536,    0.000155},
			{  -0.000081,    0.001185,    0.004982}, {   0.117016,    0.019677,    0.975798}, {   0.032251,    0.079832,   -0.400018}, {  -0.851556,    1.641764,    1.013043}, {   0.121812,    0.287743,    0.316998}, {   0.003215,   -0.002498,    0.243391}, {   0.237857,    0.115438,   -0.392677}, {   0.567731,   -0.344817,    2.426048},
			{   0.067712,    0.438605,    0.707592}, {   0.089486,   -0.572785,    0.173274}, {  -0.026388,   -0.425857,    0.619183}, {   0.003920,   -0.172482,    2.391019}, {  -0.379215,    1.893785,    0.316320}, {   0.025295,    0.060860,   -0.340865}, {   0.006878,    0.055989,    0.003689}, {   0.075310,   -0.074219,    0.468804},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   1.519659,    0.056653,    1.754881},
			{  -0.255432,   -0.449324,    1.594751}, {   1.249030,    0.190238,    1.637408}, {   1.372357,    0.282406,    1.645764}, {  -0.213927,   -0.771553,    1.342484}, {  -0.249930,    0.063240,    1.648228}, {   1.375429,    0.281904,    1.705471}, {   0.004920,    0.526049,    1.543532}, {   0.004922,    1.063689,    1.732244},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   1.007990,    0.947274,   -0.012199}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.011559,    0.004753,    0.001662}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.005493,    0.000243,    3.811906}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.391719,    0.409514,   -1.204588}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  -0.005636,   -0.003385,    0.604331}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {  -0.914063,   -0.047851,    1.393367}, {  -0.011238,   -0.734769,    0.003071}, {   0.000518,    0.000365,    3.914627}, {   0.013638,    0.008721,   19.928516}, {   0.000000,    0.000000,    0.000000}, {  -0.403618,    0.995887,    2.882108}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.003738,   -0.861322,    4.727493}, {   0.174103,    0.032125,    2.808727}, {   0.000000,    0.000000,    0.000000}, {   0.003562,    0.000362,    5.724009}, {  -0.069196,   -0.063271,    1.819911}, {   0.000000,    0.000000,    0.000000}, {   1.887809,   -2.125062,    6.512124},
			{   0.006053,    0.010065,   17.790649}, {  -0.156621,    0.008546,    9.462259}, {   0.017055,    0.007108,   15.591405}, {   0.859081,   -0.381745,   14.184894}, {   0.003538,    0.002365,    0.507642}, {   0.007732,    1.508690,    1.270553}, {   0.007530,   -0.007116,    1.750000}, {   0.011207,   -0.007116,    1.468302},
			{   0.006186,   -0.007116,    1.283128}, {   0.007766,   -0.007116,    1.450518}, {   0.000000,    0.000000,    0.000000}, {  -0.000678,    0.014592,    1.765118}, {   0.001924,    0.007009,    4.434889}, {  -2.745124,    0.775885,    4.207209}, {  -4.070024,    0.061301,    3.402324}, {  -3.621303,   -0.616181,    4.262629},
			{   0.005630,    0.002588,    2.682687}, {  -0.007776,    0.011347,    2.682796}, {   2.935283,   -1.544788,    3.335982}, {   0.064883,    0.009932,    0.007042}, {   0.000521,    0.006167,   -0.002240}, {   0.003631,    0.005696,    0.996585}, {   0.004352,    0.010693,    0.000000}, {   0.210445,   -0.248044,    8.451636},
			{   0.014965,    0.022401,    0.000549}, {   0.008674,    0.019055,   -0.193193}, {   0.002100,   -0.004842,    0.625000}, {  -0.782880,   -1.242118,    1.386646}, {  -0.051114,    2.080667,    0.122737}, {  -0.518710,   -0.020588,   -0.032949}, {   0.009631,    0.006455,    0.377784}, {   0.029314,   -1.573748,   -1.837977},
			{  -0.156621,    0.008546,    9.462259}, {   0.017055,    0.007108,   15.591405}, {   0.006053,    0.010065,   17.790649}, {   1.887809,   -2.125062,    6.512124}, {   1.894204,    0.289177,    3.867928}, {   0.006833,   -0.180092,   -0.011041}, {  -0.007222,    0.006839,    0.005150}, {   0.009631,    0.006455,    0.377784},
			{   0.029314,   -1.573748,   -1.837977}, {  -0.011238,   -0.734769,    0.003071}, {  -0.914063,   -0.047851,    1.393367}, {  -0.782880,   -1.242118,    1.386646}, {  -0.518710,   -0.020588,   -0.032949}, {  -0.051114,    2.080667,    0.122737}, {   0.118657,    0.405270,    0.002972}, {   0.012485,   -0.012645,    0.539339},
			{   0.002947,    0.020295,   -0.036777}, {   0.012558,   -0.008078,   -0.028889}, {  -1.570842,   -0.680959,    1.821153}, {  -1.579154,   -0.624840,    1.832568}, {  -1.574241,    0.684621,    1.339254}, {  -1.570806,    0.703574,    1.424162}, {   0.005456,   -0.007040,    0.906768}, {   0.051020,    0.013669,    0.008333},
			{   0.005861,   -0.007110,    0.007633}, {   0.007172,    0.005483,    0.094268}, {   4.048666,   -0.422008,    2.350668}, {  -4.042808,   -0.422017,    2.350666}, {   0.006163,    0.007654,   -0.286875}, {   0.006163,    0.007639,    0.006920}, {  -1.570806,    0.703574,    1.424162}, {  -1.574241,    0.684621,    1.339254},
			{  -1.570842,   -0.680959,    1.821153}, {  -1.579154,   -0.624840,    1.832568}, {   0.051020,    0.013669,    0.008333}, {   0.007172,    0.005483,    0.094268}, {   0.005861,   -0.007110,    0.007633}, {   0.005456,   -0.007040,    0.906768}, {   0.006163,    0.007639,    0.006920}, {   0.006163,    0.007654,   -0.286875},
			{  -4.039632,   -0.422017,    2.287827}, {   4.048666,   -0.422008,    2.350668}, {  -0.043225,   -0.000677,  -27.306217}, {   8.257923,    0.008434,   -2.928637}, {   8.257923,    0.008434,   -2.928637}, {  -0.043225,   -0.000677,  -27.306217}, {  -0.140103,    0.006947,   -0.392913}, {   0.008055,    0.004153,    1.400465},
			{   0.390543,   -3.849617,    3.522092}, {   0.027228,    0.001708,    1.582939}, {   0.013638,    0.008721,   19.928516}, {   1.249030,    0.190238,    1.637408}, {   1.519659,    0.056653,    1.754881}, {   1.372357,    0.282406,    1.645764}, {   1.375429,    0.281904,    1.705471}, {  -0.255432,   -0.449324,    1.594751},
			{  -0.213927,   -0.771553,    1.342484}, {  -0.249930,    0.063240,    1.648228}, {   0.004920,    0.526049,    1.543532}, {   0.004922,    1.063689,    1.732244}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.023389,    0.005843,    1.708556}, {   0.009092,    0.007654,   -0.286875},
			{   0.005348,   -0.001951,    0.003591}, {  -4.039632,   -0.422017,    2.287827}, {   0.003292,    0.000000,    0.003587}, {   3.427323,   -2.221491,    4.363105}, {   0.007730,    0.002821,    0.007199}, {   3.427323,   -2.221491,    4.363105}, {   0.007730,    0.002821,    0.007199}, {  -0.067942,   -0.049267,    3.415575},
			{  -0.067942,   -0.049267,    3.415575}, {  -0.686033,   -0.005894,   -1.420804}, {   0.692453,    0.004271,    2.370043}, {   0.016228,   -1.328855,    1.212154}, {   0.122151,    0.232655,    2.241626}, {   1.894204,    0.289177,    3.867928}, {   0.001924,    0.007009,    4.434889}, {  -3.621303,   -0.616181,    4.262629},
			{  -4.070024,    0.061301,    3.402324}, {  -2.745124,    0.775885,    4.207209}, {  -0.013434,    0.610580,   -1.396857}, {   0.012558,   -0.008078,   -0.028889}, {   0.002947,    0.020295,   -0.036777}, {   0.012485,   -0.012645,    0.539339}, {   0.004935,    0.009855,    0.006022}, {   0.012711,   -0.001527,    0.003831},
			{   0.012711,   -0.001527,    0.003831}, {   0.001679,    0.006624,    0.005483}, {   0.001679,    0.006624,    0.005483}, {   0.010642,   -0.015119,    1.450518}, {   0.004538,   -0.015119,    1.450518}, {   8.259275,    0.010379,   -1.024314}, {   8.259275,    0.010379,   -1.024314}, {   0.005630,    0.005915,    1.077643},
			{   0.285658,    0.070758,    0.251098}, {   0.005249,    0.007420,    0.028690}, {   0.006912,    0.005135,    1.500000}, {   0.006469,    0.005870,    1.500000}, {   0.004044,    0.002261,    1.500000}, {   0.001037,    0.000250,    1.500000}, {  -0.049290,    0.083763,    0.800293}, {  -0.049290,    0.083833,    0.724924},
			{  -0.044973,    0.083763,    0.714914}, {  -0.044973,    0.083833,    0.996909}, {  -0.006109,    0.083833,    0.818749}, {  -0.043811,    0.083763,    0.812490}, {  -0.038940,    0.083833,    1.180487}, {  -0.048128,    0.083763,    0.800293}, {  -0.010153,   -0.008786,   -1.795732}, {   1.094213,   -0.130391,    0.321785},
			{  -0.005733,   -0.655282,    0.001460}, {  -0.007579,   -0.005282,    0.001460}, {   0.006575,    0.018058,    4.290780}, {   0.004149,    0.005797,    0.048661}, {   0.006575,    0.018058,    4.290780}, {   0.004149,    0.005797,    0.048661}, {  -0.527737,   -0.009701,   -1.958946}, {   0.003442,    0.006996,    0.708137},
			{   0.001718,   -0.058216,    0.719116}, {   0.029355,    0.018797,    0.833218}, {   0.004375,    0.002941,    0.688036}, {   0.005615,    0.004852,  -18.719408}, {  -0.061767,    0.004852,   13.401025}, {  -0.061767,    0.004852,   13.401025}, {   0.003597,    0.004902,    0.002692}, {  -0.226081,   -0.253111,    2.048444},
			{   0.000000,    0.000000,    0.000000}, {   0.208496,    0.031674,    2.054024}, {  -0.003037,   -0.005295,    0.006370}, {  -1.216086,   -0.074630,    2.545809}, {  -1.216086,   -0.074630,    2.545809}, {   0.003597,    0.004902,    0.002692}, {  -0.003037,   -0.005295,    0.006370}, {  -0.226081,   -0.253111,    2.048444},
			{   0.859081,   -0.381745,   14.184894}, {   0.010972,   -0.101898,   -0.256487}, {   0.009941,   -0.219288,    6.309060}, {  -0.244781,    2.099097,   13.808335}, {   0.009941,   -0.219288,    6.309060}, {   0.000000,    0.000000,    0.000000}, {   0.006103,    0.002929,    0.003032}, {   0.000380,    0.001162,    0.005262},
			{   0.004013,    0.005661,    0.003686}, {   0.003645,    0.005719,    0.004391}, {   0.003783,   -0.024963,    0.007288}, {   0.000487,    0.005615,    0.003794}, {   0.003994,    0.016602,    0.001491}, {   0.001586,    0.002562,    0.003656}, {   0.000062,    0.000033,    0.000000}, {   0.002746,    0.003600,    0.006585},
			{   0.007689,    0.006957,    0.005659}, {   0.000976,    0.002196,    0.001835}, {   0.819549,   -0.496764,   -0.612182}, {   0.246582,    1.707947,    0.006628}, {  -0.000060,    0.005493,    0.564652}, {   0.002898,   -0.168090,    0.002194}, {  -0.086944,   -0.041503,    0.960999}, {   0.006347,    0.001037,    0.001884},
			{   4.104125,  -14.985228,    1.881520}, {   0.000884,    0.000792,    1.141422}, {  -0.614989,   -1.499755,   -0.288899}, {  -4.078430,   -1.543578,   -0.484842}, {   0.002738,    0.001685,    0.001005}, {   0.002838,    0.003720,    0.001006}, {   0.001250,    0.004679,    0.000326}, {   0.007385,    0.006531,    0.006955},
			{   0.003722,    0.000060,    0.007799}, {   0.007019,    0.003722,    0.004635}, {   0.000030,    0.002715,    0.003470}, {   0.052997,    0.024841,    0.001884}, {   0.016112,   -0.040718,    0.012536}, {   0.003417,    0.005493,    0.002386}, {   0.002658,    0.005361,    0.002333}, {   0.004005,    0.001466,    5.654478},
			{   0.000487,   -0.068033,    0.737343}, {   0.005493,    0.003417,    0.007075}, {   0.002703,    0.168952,    0.639670}, {   0.004395,    0.002956,    0.002989}, {   0.003905,    0.003152,    0.002971}, {   0.005278,    0.006872,    0.542048}, {  -1.077757,    1.229511,   -1.815407}, {   0.005408,    0.014893,    0.029703},
			{   0.795044,   -0.010010,    5.410564}, {  -0.007013,    0.006961,   -1.031759}, {   0.005998,    0.004931,    0.553776}, {   0.005084,    0.113341,    1.309061}, {   0.002738,    0.001685,    0.001005}, {   0.002838,    0.003720,    0.001006}, {   0.001250,    0.004679,    0.000326}, {   0.007019,    0.003722,    0.004635},
			{   0.007385,    0.006531,    0.006955}, {   0.003722,    0.000060,    0.007799}, {   0.003783,   -0.024963,    0.007288}, {   0.007125,    0.003469,    0.325506}, {   0.004699,    0.005127,    0.004722}, {   0.000030,   -0.115552,    0.319860}, {  -0.164123,   -0.169624,    0.325498}, {   0.007794,   -0.266395,    0.004720},
			{  -0.039352,   -0.248575,    0.145355}, {   0.007946,    0.005731,    0.000539}, {   0.007946,    0.005731,    0.000539}, {   0.007480,    0.008225,    0.004364}, {   0.009162,    0.392006,   -0.140045}, {   0.004935,    0.021763,    0.002644}, {   0.001898,    0.006854,    0.001809}, {   0.001898,    0.006854,    0.001809},
			{   0.016278,    0.622632,    1.968693}, {   0.005646,    0.096006,   -0.016122}, {   0.000457,    0.003295,    0.003725}, {   0.000220,    0.002199,    0.001573}, {   0.010266,    0.011394,    0.000794}, {   0.010266,    0.011394,    0.000794}, {   0.005371,    0.005309,    0.005280}, {   0.006124,    0.004300,    0.005938},
			{   0.011370,    0.002584,    0.011130}, {  -0.167792,   -0.098030,    9.216899}, {  -0.896889,    0.651987,    6.927543}, {   0.553885,   -0.229804,    9.061155}, {  -0.279412,    0.855063,    6.022029}, {   0.246163,    0.303162,   12.825333}, {  -1.061807,   -0.355307,    7.363007}, {   0.499801,   -0.260917,   10.376155},
			{   0.052278,    0.806728,    6.133179}, {   8.756804,   -0.050115,    0.018849}, {   8.760465,   -0.063261,    0.018849}, {   0.001464,    0.006835,   -0.532907}, {  -0.936469,   -0.042757,    0.018425}, {   0.168694,    0.062279,    0.001112}, {   0.082856,    0.022196,    0.079685}, {   0.089460,    0.021005,    0.079092},
			{  -0.134508,   -0.255192,    0.594181}, {   0.001981,    0.004782,    0.003955}, {   0.003431,    0.007052,    0.005750}, {   0.005278,    0.006872,    0.542048}, {   0.015381,    0.013861,    0.018587}, {   0.003691,    0.002697,    0.006746}, {   0.003135,    0.005412,    0.004738}, {   3.039062,  -14.985228,   -0.297830},
			{  -0.203706,    0.327026,    0.025895}, {   0.001430,    0.003635,    0.002156}, {   0.001715,    0.005952,    0.006988}, {   0.006287,   -0.018501,   -0.081418}, {   0.005911,    0.000999,    0.006858}, {  -0.008109,    0.004784,    0.379429}, {   0.008057,    0.008545,   -0.555315}, {   0.000884,    0.000792,    1.141422},
			{   0.000487,   -0.068033,    0.737343}, {  -0.000060,    0.005493,    0.564652}, {  -0.614989,   -1.499755,   -0.288899}, {   0.002703,    0.168952,    0.639670}, {   0.007125,    0.003469,    0.325506}, {   0.004699,    0.005127,    0.004722}, {   0.000030,   -0.115552,    0.319860}, {  -0.164123,   -0.169624,    0.325498},
			{   0.007794,   -0.266395,    0.004720}, {  -0.039352,   -0.248575,    0.145355}, {   0.002898,   -0.168090,    0.002194}, {  -0.086944,   -0.041503,    0.960999}, {   0.246582,    1.707947,    0.006628}, {   0.726624,   -0.723021,   -1.043766}, {  -0.323718,    0.110073,    1.284471}, {   0.005061,    1.510756,    0.358440},
			{  -0.004943,   -0.011962,   -0.029170}, {   0.000000,    0.000000,    0.000000}, {  -0.001503,   -0.003472,    0.000123}, {   0.001394,    0.006554,    0.002247}, {  -0.003242,   -0.004805,    0.001843}, {  -0.004038,    0.006517,    0.002258}, {  -0.002401,    0.007131,    0.001379}, {  -0.002401,    0.007131,    0.001379},
			{  -0.004038,    0.006517,    0.002258}, {  -0.003242,   -0.004805,    0.001843}, {   0.000357,    0.004191,    0.002246}, {   0.001394,    0.006554,    0.002247}, {   0.006107,   -0.004604,    0.006732}, {   0.013798,   -0.009220,    0.000722}, {   0.003661,    0.007019,   -0.063372}, {   0.005667,    0.007906,    0.001898},
			{   0.009329,    0.007906,   -0.063372}, {   0.008841,    0.007906,   -0.063372}, {   0.013798,   -0.004093,    0.000722}, {   0.013798,   -0.008000,    0.000722}, {   0.013798,   -0.008732,    0.000722}, {   0.009806,    0.013794,    0.005634}, {   0.003140,    0.013712,    0.005634}, {   0.009328,    0.010363,    0.005634},
			{   0.006858,    0.006326,    0.003703}, {   0.010133,    0.012808,    0.001438}, {   0.005628,    0.008163,    0.003340}, {  -0.375609,   -0.071227,    0.000691}, {   0.005348,    0.004027,    0.003177}, {   0.007613,   -0.000029,    0.000230}, {   0.000357,    0.004191,    0.002246}, {   0.007613,   -0.000029,    0.000230},
			{   0.000976,    0.002074,    0.001000}, {   0.012852,   -0.004643,    0.006732}, {   0.003514,    0.020483,    0.002274}, {   0.008910,    0.003784,    0.007507}, {   0.003661,    0.011841,    0.000713}, {   0.007557,    0.015178,    0.002451}, {   0.001794,    0.005739,    0.002452}, {   0.001794,    0.005739,    0.002452},
			{   0.007557,    0.015178,    0.002451}, {   0.062500,    0.013367,   -0.000224}, {  -0.011919,    0.003624,    0.122313}, {   0.003172,    0.001600,    0.002741}, {   0.002074,   -0.057495,    0.005260}, {   0.003172,    0.002172,    0.002741}, {   0.008305,    0.011981,    0.003095}, {   0.009832,    0.010838,    0.004191},
			{   0.009843,    0.007660,    0.004738}, {   0.006862,    0.008286,    0.003281}, {   0.007579,    0.008286,    0.004559}, {   0.005878,    0.003413,    0.004054}, {   0.003663,    0.003783,    0.002644}, {   0.008496,    0.006767,    0.007354}, {   0.008543,    0.006233,    0.001226}, {  -1.012748,    0.001296,    0.007354},
			{  -0.011521,   -0.006113,    0.007085}, {   1.058882,   -0.704285,   -0.208652}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.012028,    0.012919,    0.006378}, {   0.012937,    0.012567,    0.003963}, {   0.008537,    0.012567,   -0.328433}, {   0.001739,   -0.287620,    0.007342},
			{   0.010130,    0.004635,    0.003501}, {   0.005973,    0.003104,    0.015628}, {   0.001376,    0.006945,    0.003711}, {   0.000246,    0.009243,   -0.042475}, {   0.004912,    0.010100,    0.002279}, {   0.006577,    0.009681,    0.005991}, {   0.007720,    0.013042,    0.007329}, {   0.002562,    0.008057,    0.003013},
			{   0.005905,    0.004116,    0.516003}, {   0.004149,    0.007633,    0.001339}, {   0.003287,    0.009882,    0.005398}, {   0.003478,    0.008422,    0.007612}, {   0.007263,    0.001983,    0.004749}, {   0.008979,    0.018114,    0.001904}, {   0.009577,    0.011748,    0.003752}, {   0.008777,    0.013243,    0.000600},
			{   0.013044,    0.012554,    0.005197}, {   0.014022,    0.008647,    0.005197}, {   0.005853,    0.005470,    0.000778}, {   0.008504,    0.003693,    0.000910}, {   0.008620,    0.008972,    0.006860}, {   0.078961,    0.013461,    0.006725}, {   0.007813,    0.009274,    0.007269}, {   0.003217,    0.000001,    0.002400},
			{   0.029916,    0.000003,    0.004100}, {   0.003905,    0.000487,    0.004399}, {   0.000514,    0.007530,    0.001961}, {   0.003905,    0.004271,    0.005704}, {  -0.000433,    0.003030,    0.007637}, {  -0.000433,    0.003030,    0.007637}, {   0.003417,    0.006409,    0.007652}, {  -0.001579,    0.004271,    0.006430},
			{  -0.001579,    0.004271,    0.006430}, {   0.003590,   -0.000245,    0.004782}, {   0.005859,    0.007141,    0.003131}, {   0.005859,    0.007141,    0.003131}, {   0.007094,   -0.053885,    0.006835}, {   0.007094,   -0.053885,    0.006835}, {   0.003590,   -0.000245,    0.004782}, {   0.007201,    0.007323,   -0.437918},
			{   0.007201,    0.007323,   -0.437918}, {   0.004393,    0.007079,    0.001032}, {   0.003376,    0.003412,    0.001591}, {   0.002656,    0.006318,    0.002268}, {   0.005406,   -0.248523,   -0.697405}, {   0.001883,    0.006469,    0.001077}, {   0.001883,    0.006469,    0.001077}, {   0.002200,    0.000296,    0.007294},
			{   0.002745,    0.000586,    0.005716}, {   0.004195,    0.005739,    0.005371}, {   0.007368,    0.009631,    0.001204}, {   0.003661,    0.011841,    0.000713}, {   0.008910,    0.003784,    0.007507}, {   0.005853,    0.005470,    0.000778}, {   0.008504,    0.003693,    0.000910}, {   0.005293,    0.002734,    0.000380},
			{   0.008979,    0.018114,    0.001904}, {   1.163437,   -0.091890,    0.860502}, {   0.004970,    0.008514,    0.009153}, {   0.001433,    0.124263,   -1.851655}, {   0.006256,    0.009235,    0.013970}, {   0.754123,    0.012296,   -1.190513}, {  -0.025691,   -0.001491,   -0.813630}, {   0.006256,    0.009235,    0.013970},
			{  -0.025691,   -0.001491,   -0.813630}, {   0.754123,    0.012296,   -1.190513}, {   1.163437,   -0.091890,    0.860502}, {   0.008620,    0.008972,    0.006860}, {   0.013403,   -0.000338,    1.004202}, {   0.013403,   -0.000338,    1.004202}, {   0.003478,    0.008422,    0.007612}, {   0.007720,    0.013042,    0.007329},
			{   0.006577,    0.009681,    0.005991}, {   0.008301,    0.008117,    0.004110}, {   0.008301,    0.008117,    0.004110}, {  -0.290376,   -1.321784,    8.513208}, {  -0.080248,    0.216261,    8.402742}, {  -0.080248,    0.241006,    8.402742}, {  -1.250488,   -0.083557,   -0.138968}, {   0.000976,    0.002074,    0.001000},
			{   0.003814,    0.001747,    0.004414}, {   0.003814,    0.001747,    0.004414}, {   0.004883,    0.004943,    0.003112}, {   0.004883,    0.004943,    0.003112}, {   0.003295,    0.002379,    0.000071}, {   0.006591,   -0.032287,   -0.124779}, {   0.001989,    0.007412,    0.006175}, {   0.001989,    0.007412,    0.006175},
			{   0.006382,    0.007412,    0.085872}, {   0.006382,    0.007412,    0.085872}, {   0.003417,    0.006409,    0.007652}, {   0.005218,    0.008178,    0.007513}, {   0.005218,    0.008178,    0.007513}, {   0.002562,    0.008057,    0.003013}, {   0.005905,    0.004116,    0.516003}, {   0.003383,    0.002511,    0.001894},
			{   0.003383,    0.002511,    0.001894}, {   0.003901,    0.007331,    0.004813}, {   0.003901,    0.007331,    0.004813}, {   0.000365,    0.005224,    1.462085}, {   0.000365,    0.005224,    1.462085}, {   0.007784,    0.002389,    0.003326}, {   0.003217,    0.000001,    0.002400}, {   0.029916,    0.000003,    0.004100},
			{   0.000514,    0.007530,    0.001961}, {   0.003905,    0.000487,    0.004399}, {   0.008146,    0.006653,    0.003317}, {   0.008146,    0.006653,    0.003317}, {   3.139525,    2.207159,   -6.310140}, {   0.009843,    0.007660,    0.004738}, {   0.007579,    0.008286,    0.004559}, {   0.006862,    0.008286,    0.003281},
			{   0.012937,    0.012567,    0.003963}, {   0.008537,    0.012567,   -0.328433}, {  -0.011521,   -0.006113,    0.007085}, {   0.008305,    0.011981,    0.003095}, {   0.001376,    0.006945,    0.003711}, {  -1.012748,    0.001296,    0.007354}, {   0.008496,    0.006767,    0.007354}, {   0.005878,    0.003413,    0.004054},
			{   0.008543,    0.006233,    0.001226}, {   0.003663,    0.003783,    0.002644}, {   0.000246,    0.009243,   -0.042475}, {   0.009832,    0.010838,    0.004191}, {   1.058882,   -0.704285,   -0.208652}, {  -0.749324,    1.319905,    0.007635}, {  -0.749324,    1.319905,    0.007635}, {   0.001411,    0.020593,    0.004143},
			{   0.003140,    0.013712,    0.005634}, {   0.003905,    0.004271,    0.005704}, {   0.004912,    0.010100,    0.002279}, {   0.008841,    0.007906,   -0.063372}, {   0.007263,    0.001983,    0.004749}, {   0.007323,    0.000121,    0.005276}, {   0.007323,    0.000121,    0.005276}, {   0.005005,    0.004149,    0.001922},
			{   0.005005,    0.004149,    0.001922}, {   0.006725,    0.303467,   -5.987444}, {   0.000610,    0.000637,    0.004406}, {   0.001342,    0.002318,    0.005342}, {   0.001342,    0.002318,    0.005342}, {   0.007207,    0.007555,    0.004406}, {   0.006725,    0.303467,   -5.987444}, {   0.002246,    0.007544,    0.000270},
			{   0.002246,    0.007544,    0.000270}, {  -0.081688,   -0.380326,    0.001018}, {   0.005824,   -0.005243,    0.001379}, {   0.000222,    0.000647,    0.003963}, {   0.210354,    0.112255,   -1.190675}, {   0.011508,    0.014454,   -0.842131}, {   0.210354,    0.112255,   -1.190675}, {   0.011508,    0.014454,   -0.842131},
			{   0.005824,   -0.005243,    0.001379}, {   0.004149,    0.007633,    0.001339}, {   0.003287,    0.009882,    0.005398}, {  -0.615400,    1.397636,    2.875982}, {   0.005348,    0.004027,    0.003177}, {   0.010130,    0.004635,    0.003501}, {   0.005973,    0.003104,    0.015628}, {   0.012028,    0.012919,    0.006378},
			{  -3.927186,   -0.655233,   -2.430864}, {  -3.927186,   -0.655233,   -2.430864}, {   0.001739,   -0.287620,    0.007342}, {   0.078961,    0.013461,    0.006725}, {   0.004195,    0.005739,    0.005371}, {   0.003905,    0.007813,    0.027343}, {   0.003905,    0.007813,    0.027343}, {   0.007263,    0.001922,    0.006969},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.122483,    0.004769,    0.003821}, {   0.003112,    0.005044,    0.006357}, {   0.003112,    0.006417,   -0.156204}, {   0.006775,    0.006417,   -0.029071}, {   0.019447,    0.003152,    0.002151}, {   0.006775,    0.005044,    0.002543},
			{   0.006775,    0.004158,   -0.006105}, {   0.003112,    0.006783,   -0.000870}, {  -0.007507,   -0.000555,    0.000598}, {  -0.003051,   -0.003058,    0.011528}, {   0.146245,    0.007637,    1.739195}, {   0.023755,    0.005898,    0.785952}, {   0.002257,    0.001810,    1.003455}, {   0.006775,    0.005228,    1.233997},
			{   0.007019,    0.006601,    0.543587}, {   0.002785,    0.002187,    0.001117}, {   0.001067,    0.002257,    0.003631}, {   0.006699,    0.001188,    0.000679}, {   0.005028,    0.003871,    0.000342}, {   0.007340,    0.000617,    0.000571}, {   0.004321,    0.007038,    0.007172}, {   0.006934,    0.003471,    0.006587},
			{   0.002555,    0.001664,    0.002166}, {   0.006072,    0.004633,    0.006597}, {   0.001442,    0.001287,    0.002561}, {   0.003543,    0.000884,    0.000881}, {   0.007575,    0.001851,    0.005024}, {   0.007637,    0.006391,    0.000096}, {   0.001820,    0.001125,    0.000539}, {   0.001820,    0.001125,    0.000539},
			{   0.001362,    0.003613,    0.004364}, {   0.001362,    0.003613,    0.004364}, {   0.001945,    0.130757,    0.089823}, {   0.007042,    0.007796,    0.001092}, {   0.000855,    0.002706,   -0.993839}, {   0.006696,    0.001847,   -0.990405}, {   0.006087,    0.006111,   -0.993018}, {   0.000639,    0.001889,   -0.993961},
			{   0.007708,    0.003245,   -0.999280}, {   0.004586,    0.001200,   -0.991868}, {   0.000513,    0.005758,   -0.990405}, {   0.007730,    0.007602,   -0.992744}, {   0.003049,    0.000653,   -0.992361}, {   0.007683,    0.003659,   -0.995371}, {   0.005915,    0.003627,   -0.991868}, {   0.000855,    0.002706,   -0.993839},
			{   0.006696,    0.001847,   -0.990405}, {   0.006087,    0.006111,   -0.993018}, {   0.000639,    0.001889,   -0.993961}, {   0.007708,    0.003245,   -0.999280}, {   0.005915,    0.003627,   -0.991868}, {   0.003049,    0.000653,   -0.992361}, {   0.007730,    0.007602,   -0.992744}, {   0.007683,    0.003659,   -0.995371},
			{   0.000513,    0.005758,   -0.990405}, {   0.004586,    0.001200,   -0.991868}, {   0.001420,    0.005156,   -0.996802}, {   0.006101,    0.002768,   -0.593677}, {   0.004414,    0.005760,   -0.989863}, {   0.001888,    0.001134,   -0.992115}, {   0.001888,    0.001134,   -0.992115}, {   0.001420,    0.005156,   -0.996802},
			{   0.004414,    0.005760,   -0.989863}, {   0.006101,    0.002768,   -0.593677}, {   0.000072,    0.001954,    0.002581}, {   0.003132,    0.002980,    0.003469}, {   0.033225,   -0.095468,   -0.122662}, {   0.104359,    0.153400,    0.002683}, {  -0.079208,    0.063602,    6.106088}, {  -1.464614,    0.118871,    3.942513},
			{   0.008917,    0.014651,    0.004406}, {   0.000296,    0.002335,    0.000487}, {   0.002858,    0.007441,    0.000487}, {   0.006612,    0.005446,    0.000487}, {   0.001224,    0.001586,    0.005193}, {   0.000492,    0.001606,    0.005193}, {   0.007571,    0.001589,    0.005193}, {   0.002200,    0.001588,    0.005193},
			{   0.003167,    0.005278,    0.004207}, {  -0.127849,    0.001596,    0.002707}, {  -0.108765,    0.001875,    0.024537}, {   0.004416,    0.003944,    0.003471}, {   0.004416,    0.003944,    0.003471}, {  -0.108765,    0.001875,    0.024537}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   2.528388,    0.008958,   -0.713123}, {   0.002685,    0.002685,    0.000972}, {   0.002685,    0.002685,    0.000972}, {   0.052988,    0.024840,    0.001884}, {   0.003146,    0.006014,   28.695556}, {   0.003142,    0.002335,    0.002128}, {   0.000245,    0.005838,    0.001581}, {  -0.128998,    0.007431,   -5.271590},
			{  -0.128998,    0.007431,   -5.271590}, {   0.259346,    0.484631,    0.005938}, {   0.004602,    0.001604,    0.005156}, {   0.000000,    0.000000,    0.000000}, {  -0.008516,    0.014592,    1.765118}, {   0.003631,    0.005696,    0.434816}, {   0.005107,    0.008834,   -9.874727}, {  -0.467554,    0.001145,   -0.111645},
			{  -0.467554,    0.001145,   -0.111645}, {   0.000000,    0.000000,    0.000000}, {   0.006368,    0.006481,    0.020263}, {   0.003206,    0.008728,    0.016967}, {   0.003971,    0.012589,    0.015625}, {   0.007449,    0.012366,    0.015379}, {   0.004358,    0.009207,    0.020628}, {   0.008361,    0.008839,    0.020263},
			{ -10.937622,  -22.173553,    0.018062}, {   0.007484,    0.008957,    0.015258}, {   0.009597,    0.006192,    0.016233}, {   0.003083,    0.005940,    0.020873}, {   0.002800,    0.011277,    0.019897}, {   0.003735,    0.008425,    0.019897}, {  -4.946835,    0.012389,   -1.687052}, {   0.008289,   -0.436724,    0.016721},
			{   0.009101,    0.006606,    0.017580}, {   0.006705,    0.006969,    0.021608}, {   0.009402,    0.007218,    0.018431}, {  -9.982448,    0.005135,    0.011560}, {   0.009390,  -14.255443,  -33.297389}, {   0.002536,    0.013012,    0.018556}, {   0.007873,    0.006287,    0.021119}, {  -7.495066,    0.005967,   -0.968347},
			{   0.008774,    0.010623,    0.017333}, {   0.004143,    0.006209,    0.019897}, {   3.893631,   -5.421566,    0.014405}, {   0.005754,    0.012450,   -0.237065}, {   0.003555,    0.008720,    0.016479}, {   0.007873,    0.007242,    0.018798}, {   0.006787,    0.009174,    0.160811}, {   0.002926,    0.002306,    0.002672},
			{   0.005983,    0.204780,   -0.013751}, {   0.000931,    0.004937,    0.005611}, {  -2.202699,   -4.696722,    2.286151}, {   0.008301,    0.005828,    0.020492}, {   0.005127,    0.004013,    0.002311}, {   0.002931,    0.004798,    0.003680}, {  -0.087627,   -0.210167,    0.007079}, {  -0.382431,    0.002318,   -0.414310},
			{  -0.088696,   -0.079685,    0.017912}, {  -0.017359,    0.064810,   -0.091913}, {  -0.031235,    0.064135,   -0.088310}, {   0.029255,   -0.031525,    0.028201}, {   0.005867,    0.007536,    0.007133}, {  -0.089309,   -3.666306,    3.959850}, {  -0.095104,   -0.080294,    0.024747}, {  -0.014647,    0.001220,   -0.830092},
			{   2.401982,   -0.007428,    0.820524}, {   2.460180,   -0.006463,    0.824033}, {  -0.113128,    0.002062,    0.083833}, {   0.004036,    0.000213,    0.007149}, {   0.389789,   -0.383437,    0.702862}, {   0.394062,   -0.380264,    0.698956}, {   0.000161,    0.007050,    0.002420}, {   0.936568,   -1.648548,   -0.304910},
			{   0.004724,    0.007402,    0.000266}, {   1.623165,    0.754027,   -3.453747}, {   0.002182,    0.000450,    0.006577}, {   2.280251,   -4.599791,   -0.300431}, {   0.001471,    0.006231,    0.008310}, { -26.199579,   -3.524244,   -0.697803}, {   0.002298,    0.004242,    0.004377}, {  17.818826,   -0.009438,   -3.205523},
			{   0.005874,    0.007133,    0.006556}, {   0.000554,    0.002632,    0.005024}, {   0.006705,    0.000245,    0.007335}, {   0.002155,    0.003622,    0.001444}, {   0.006756,    0.007443,    0.004280}, {   0.003065,    0.007501,    0.007790}, {  87.846916,   53.424003,   16.362380}, {   2.626914,    3.576775,    0.006378},
			{  -0.106659,    0.002062,    0.084810}, {   0.171088,   -0.455983,  -42.477691}, {   0.005607,    0.000050,    0.004149}, {   0.001336,    0.003121,    0.007079}, {   0.006295,    0.006659,    0.001586}, {  -1.000843,    1.793123,   -0.005150}, {   0.895392,   11.001646,   -4.310691}, {   2.351562,   31.096229,   -6.169616},
			{   0.002457,   -2.670188,   -2.055227}, {  11.801269,    0.007325,    0.006469}, {   0.000719,    0.002806,    0.000732}, {   4.236022,    0.562012,   -0.134032}, {   0.006690,   -0.005433,    0.006041}, {  13.174971,    1.808418,    0.792023}, {   0.000000,    0.000000,    0.000000}, {  -2.122925,   14.072020,    0.030348},
			{   0.007385,   -0.074757,    0.632314}, {  -5.590209,    6.298278,    0.527767}, {  -9.247009,  -33.965190,   -1.174906}, {  -0.328002,    0.878844,   27.635107}, {   0.010344,    0.249101,    0.001597}, { -15.954711,    2.141113,   -0.300226}, {   7.950417,    0.003661,    0.891333}, {   0.015137,    0.000304,    0.005150},
			{  -0.030944,   -0.576964,  -10.041608}, {  -0.000609,    0.000304,    2.701545}, {   2.746782,   -0.007346,    0.011624}, {   0.004333,    9.879211,    0.000380}, {   0.004912,    0.004333,    0.007799}, {   0.001464,    0.003722,    0.007139}, {   0.002929,    0.002257,    0.001130}, {   0.018005,    0.032898,    0.021817},
			{   0.006165,    0.005919,    0.011169}, {   0.002501,    0.002257,    0.002931}, {   0.004027,    0.002196,    0.004453}, {  -0.004517,    0.005919,    0.012292}, {   0.000609,    0.004271,    0.010920}, {   0.007019,   -0.085205,    0.252974}, {   0.000182,    0.002013,    3.256963}, {   1.091492,   -1.211194,   -1.543812},
			{   0.112671,   -0.310669,    0.810837}, {  -0.617431,    0.198547,   -2.971208}, {   1.997742,    0.122929,   36.209068}, {   0.004271,    0.004883,    0.004984}, { -31.170715,   -0.265778,   -3.450444}, {   0.000670,    1.725952,    0.001517}, {   1.941527,   -0.719452,    0.839905}, {   0.000548,    0.003417,   25.523298},
			{   8.284362,   -1.113098,    3.912125}, {   0.000548,    0.003417,   25.523298}, {   0.005187,    0.940734,    0.050441}, {  -1.241302,   -7.721474,   12.043821}, {   0.006287,    0.005919,    0.174302}, {   0.006713,    0.007325,   -8.786496}, {   0.002501,    0.002807,    0.003102}, {  -0.327881,    0.882690,   25.875808},
			{   0.003661,    0.326110,   20.115068}, { -25.254272,   -0.619385,   -5.502896}, { -12.718133,    3.043359,   11.227134}, {  -0.488292,   -0.808592,   19.268466}, {  -1.070068,    0.196410,  -21.660938}, {   0.012604,   -0.004085,    0.013145}, {  -0.007507,   -0.008558,    0.004964}, {   0.029268,   -1.679659,    0.010882},
			{   1.997742,    0.122929,   36.209068}, {  -0.488292,   -0.808592,   19.268466}, {   0.003661,    0.326110,   20.115068}, {   0.006287,    0.005797,   -0.066785}, {   0.004087,   -0.002952,    0.006655}, {   0.003356,    0.006775,    0.067547}, {   0.299560,    0.082092,    0.621946}, { -15.954711,    2.141113,   -0.300226},
			{ -15.879922,    0.004815,   -2.376435}, {   0.006835,    0.001708,    0.004451}, {   1.451964,    7.818054,    1.231860}, {   0.003844,    0.005615,    0.005059}, {   9.859558,   -0.001098,    0.004077}, {   0.006165,    0.005919,    0.011169}, {   0.002501,    0.002257,    0.002931}, {   0.004027,    0.002196,    0.004453},
			{  -0.004517,    0.005919,    0.012292}, {   0.006041,    0.001708,    0.000575}, {   0.002929,    0.002257,    0.001130}, {   0.018005,    0.032898,    0.021817}, {   0.010344,    0.249101,    0.001597}, {   0.007019,   -0.085205,    0.252974}, { -31.170715,   -0.265778,   -3.450444}, {  -0.170012,    0.005646,    0.005535},
			{  -0.170012,    0.005646,    0.005535}, {  -0.096436,    0.024444,    0.694637}, {   0.005187,    0.940734,    0.050441}, {   0.012604,   -0.004085,    0.013145}, {   0.007079,    0.000243,    0.005987}, {  -9.247009,  -33.965190,   -1.174906}, {   0.000670,    1.725952,    0.001517}, {   1.941527,   -0.719452,    0.839905},
			{  -5.590209,    6.298278,    0.527767}, {   0.003051,    0.003173,    3.137188}, {   0.350890,    0.462341,    3.227910}, {  -0.353882,    0.358215,   -0.033833}, {   0.221251,    0.087769,   -0.074321}, {  -1.070068,    0.196410,  -21.660938}, {   0.350890,    0.462341,    3.227910}, {  -2.122925,   14.072020,    0.030348},
			{   0.007385,   -0.074757,    0.632314}, {   0.006713,    0.007325,   -8.786496}, {   0.001708,    0.001891,   -0.265085}, {  -0.353882,    0.358215,   -0.033833}, {   0.221251,    0.087769,   -0.074321}, {  -0.617431,    0.198547,   -2.971208}, {   2.746782,   -0.007346,    0.011624}, {   0.015137,    0.000304,    0.005150},
			{   0.006287,    0.005919,    0.174302}, {   0.006835,    0.001708,    0.004451}, {   0.004333,    9.879211,    0.000380}, { -12.718133,    3.043359,   11.227134}, {   0.006287,    0.005797,   -0.066785}, {   0.004087,   -0.002952,    0.006655}, {  -0.030944,   -0.576964,  -10.041608}, {   1.091492,   -1.211194,   -1.543812},
			{   0.112671,   -0.310669,    0.810837}, {   0.000182,    0.002013,    3.256963}, { -25.254272,   -0.619385,   -5.502896}, {  -1.241302,   -7.721474,   12.043821}, {   0.004331,   -0.004947,    0.000529}, {   0.009147,   -0.166460,    0.881884}, {   0.198420,    0.016331,    0.005243}, {  -1.990635,    0.061144,    0.035985},
			{   1.400856,   -0.570652,   -0.073733}, {   0.498068,    0.379877,    0.005704}, {   0.936097,    0.335860,    0.007697}, {   0.004594,   -0.216426,    0.604472}, {   0.498068,    0.379877,    0.005704}, {  -1.990635,    0.061144,    0.035985}, {   0.198420,    0.016331,    0.005243}, {   1.400856,   -0.570652,   -0.073733},
			{   0.936097,    0.335860,    0.007697}, {   0.004594,   -0.216426,    0.604472}, {   0.009147,   -0.166460,    0.881884}, {   0.000426,    0.000365,    0.003243}, {  -0.229598,   -0.177031,   -0.239118}, {   0.012694,   -0.045265,    2.048480}, {  -3.520224,  -27.973115,  -12.604011}, {   0.071533,   -1.299561,   -2.861737},
			{   0.071533,   -1.299561,   -2.861737}, {   0.012694,   -0.045265,    2.048480}, {  -0.008607,   -0.019251,    0.000201}, {   0.003844,    0.005615,    0.005059}, {   0.006041,    0.001708,    0.000575}, {   0.007079,    0.000243,    0.005987}, {  -0.014464,    0.005859,    0.001480}, {  -0.014464,    0.005859,    0.001480},
			{  -0.096436,    0.024444,    0.694637}, {   0.003722,    0.001830,    0.003456}, {  -0.087341,    0.134765,   -0.190437}, {  -0.087341,    0.134765,   -0.190437}, {   0.003722,    0.001830,    0.003456}, {  -0.180298,   -0.197876,   -2.143166}, {   8.284362,   -1.113098,    3.912125}, {  -0.180298,   -0.197876,   -2.143166},
			{  -3.082376,    0.921131,    0.001525}, {  -2.239377,   -2.092200,   -1.534139}, {   0.001708,    0.001891,   -0.265085}, {   0.006897,    0.001067,   -0.116524}, {   0.006897,    0.001067,   -0.116524}, {   0.002013,    0.001037,    0.003114}, {   0.002013,    0.001037,    0.003114}, {   0.006347,    0.005981,    0.002264},
			{   0.005981,    0.000243,    0.007288}, {   0.005309,    0.001708,    0.000690}, {   0.005309,    0.001708,    0.000690}, {   0.000976,    0.003905,    0.002556}, {   0.000976,    0.003905,    0.002556}, {   0.019409,    0.017395,    0.016869}, {   0.019409,    0.017395,    0.016869}, {   7.950417,    0.003661,    0.891333},
			{   0.003356,    0.006775,    0.067547}, {   0.001464,    0.003722,    0.007139}, {   0.299560,    0.082092,    0.621946}, {   0.037475,    0.045226,    0.002056}, {   0.037475,    0.045226,    0.002056}, {   0.109741,   -3.275146,    7.121697}, {   0.001159,   -0.145751,    0.005388}, {   0.001159,   -0.145751,    0.005388},
			{   0.002624,    0.952392,    0.006847}, {   0.002624,    0.952392,    0.006847}, {   0.007507,    0.007689,    0.006845}, {   0.007507,    0.007689,    0.006845}, {   0.003051,    0.001281,   -0.027984}, {   0.003051,    0.001281,   -0.027984}, {   0.004395,    0.001952,    0.004228}, {   0.004395,    0.001952,    0.004228},
			{   0.005553,    0.000426,    0.002165}, {   0.005553,    0.000426,    0.002165}, {   0.001586,    0.002013,    0.004672}, {   0.001586,    0.002013,    0.004672}, {   0.002135,    0.007263,   -0.195637}, {   0.002135,    0.007263,   -0.195637}, {  10.004577,    0.000304,    0.003963}, {  10.004577,    0.000304,    0.003963},
			{   0.002990,    0.002807,    0.000448}, {   0.002990,    0.002807,    0.000448}, {   0.006713,    0.002013,    0.004598}, {   0.007567,    0.002501,    0.004230}, {   0.007567,    0.002501,    0.004230}, {   0.001342,    0.000609,    0.004075}, {   0.001342,    0.000609,    0.004075}, {   0.007201,    0.006957,    0.003653},
			{   0.006653,    0.002196,    0.001108}, {   0.006653,    0.002196,    0.001108}, {   0.001438,   -0.002308,    0.006105}, {   0.001646,   -0.001007,    0.005127}, {   0.004089,    0.003722,    0.000936}, {  -1.316118,   -0.167572,    0.001080}, {   0.004416,    0.004029,    0.002897}, {   0.005878,    0.006953,    0.002896},
			{   0.005797,    0.006409,    0.007315}, {   0.005797,    0.006409,    0.007315}, {   0.004821,    0.002135,    0.003106}, {   0.004821,    0.002135,    0.003106}, {   0.000019,    0.003940,   13.829442}, {   0.109741,   -3.275146,    7.121697}, {   0.007201,    0.006957,    0.003653}, {  -0.851562,   -1.186951,   -1.887599},
			{   6.040100,  -12.660949,    0.303647}, {   0.241576,    0.008652,    1.272454}, {   0.003051,    0.003173,    3.137188}, {   0.002501,    0.002807,    0.003102}, {  -0.327881,    0.882690,   25.820705}, {   0.007418,    0.005495,    0.001398}, {  -0.073425,    0.002501,   -0.190020}, {  -0.007507,   -0.008558,    0.004964},
			{   0.002007,    0.000792,    0.004945}, {   0.006713,    0.005981,   -0.007534}, {   0.006713,    0.005981,   -0.007534}, {   0.001708,    5.366759,   -2.627150}, {  -0.089000,   -6.361098,    0.000807}, {  -8.200714,    8.533639,    1.690804}, {  -9.246643,   38.607360,   -0.340337}, {   0.000722,    0.005222,    0.000483},
			{   0.000722,    0.005222,    0.000483}, {   0.002223,    0.007617,    0.000255}, {   0.001432,    0.007263,    0.001315}, {  -0.510985,   -1.894348,   -0.571479}, {  -0.510985,   -1.894348,   -0.571479}, {   0.672973,    0.706421,   -0.017185}, {   0.005319,    0.007040,   -0.248227}, {   9.859558,   -0.001098,    0.004077},
			{   0.000609,    0.004271,    0.010920}, {   0.006713,    0.002013,    0.004598}, {  -0.000609,    0.000304,    2.701545}, {  -9.246643,   38.607360,   -0.340337}, {   0.001197,    0.005293,   -1.387217}, {   0.006653,    0.007271,    0.004871}, {   0.003185,    0.007530,   -1.385961}, {   0.003264,    0.003714,    0.007255},
			{  -0.900512,    0.006409,    0.002968}, {   0.000433,    0.007071,    0.007521}, {   0.006269,    0.002335,    0.004730}, {   0.000586,    0.000281,    0.002176}, {   0.032163,    0.005973,    0.001575}, { -26.643760,    0.004596,   -0.153934}, {   0.004085,    0.000316,    0.000463}, {   0.004912,    0.004333,    0.007799},
			{   0.006347,    0.005981,    0.002264}, {   0.005981,    0.000243,    0.007288}, {   0.029268,   -1.679659,    0.010882}, {   0.005065,   -0.003967,    0.006459}, { -15.879922,    0.004815,   -2.376435}, {   0.003535,    0.002200,    0.001008}, {   0.003535,    0.002200,    0.001008}, { -11.732281,   21.707441,   -1.731271},
			{  28.042165,   -2.062007,    0.396824}, {   0.007689,    0.004883,    0.003170}, {   0.007689,    0.004883,    0.003170}, {   0.001384,    0.003832,    0.002026}, {   0.001384,    0.003832,    0.002026}, {   0.030855,    0.111983,    0.014159}, {   0.000326,    0.000308,    0.014159}, {   0.007883,   -0.002525,    0.020526},
			{   0.004616,    0.000388,    0.001765}, {   0.004577,    0.006370,    0.003285}, {   0.004639,    0.006492,    0.003285}, {   0.004577,    0.006614,    0.005900}, {   0.004592,  -12.327880,  -31.001741}, {   0.003936,    0.000388,    0.005681}, {   0.003936,    0.006370,    0.003285}, {   0.003936,    0.004662,    0.003285},
			{   0.003936,    0.005516,    0.005901}, {   0.003936,  -14.175415,  -31.001743}, {   0.000731,    0.007141,    0.003879}, {   0.002815,    0.002959,    0.001200}, {   0.007056,    0.004333,    0.005946}, {   0.004395,    0.003570,    6.638639}, {   8.723266,    0.397799,  -23.084634}, {   0.003234,    0.006438,    0.006519},
			{   0.002929,    0.001433,    0.005909}, {   0.002419,    0.000564,    3.625865}, {  -0.858711,  -65.348999,   -1.655663}, { -44.413604,    0.007294,   36.025665}, {   0.003264,    0.000716,    3.951812}, {   0.005737,    0.013671,   27.418334}, {   0.007201,    0.002196,    0.006271}, {   0.000853,    0.004073,   32.160781},
			{   0.000731,    0.006058,   12.674503}, {   0.001006,    0.006980,    0.035620}, {   2.993591,    0.000153,  -19.321205}, {  15.619140,    0.007323,  -38.814758}, {  19.221462,  -21.901977,  -47.357589}, {  15.619140,    0.007323,  -38.272125}, {   0.002685,    0.007323,  -10.841361}, {   0.002685,    0.678345,   -2.154123},
			{  17.454235,  -12.327148,  -50.252357}, {   0.002685,  -12.327148,  -50.252395}, {   0.002685,  -13.759520,   -2.864675}, {   0.002685,    0.007323,   -9.782142}, {   0.002685,  -12.327148,  -50.252395}, {   0.002685,    0.007323,    0.005253}, {   0.002685,  -12.327148,    0.005423}, {   0.002685,    0.006469,    0.005253},
			{   0.002685,  -12.327148,    0.005419}, {   0.002685,    0.007323,    0.005253}, {   0.002685,  -12.327148,    0.005419}, {   0.002685,    0.007323,    0.005253}, {   0.002685,  -12.327148,    0.005419}, {   0.002685,    0.006469,    0.005638}, {   0.000487,    0.007323,    0.005286}, {   0.000487,  -15.291542,    0.005452},
			{   0.000487,    0.000365,    0.001307}, {   0.000487,    0.000365,    0.002620}, {   0.005371,    0.002754,   -8.320121}, {   0.005371,    0.005309,   -8.324501}, {   0.005371,    0.000060,   -8.326919}, {   0.005371,    0.002624,  -16.649429}, {   0.001861,    0.004699,   -8.325386}, {   0.005096,    0.002624,   -4.448218},
			{   3.334594,  -55.549987,  -32.281951}, {  -0.848145,  -61.229675,  -16.084739}, {   0.000487,   -0.177063,  -16.084732}, {  -1.541321,    0.000487,  -57.399139}, {   5.529633,  -39.038787,  -57.610076}, {  21.225830,  -13.570465,  -47.222381}, {  -5.730957,   -7.726311,  -89.805404}, { -90.102294,    6.594620, -102.485092},
			{-101.365478,    1.568755,  -95.500717}, { -99.243164,    0.997681,  -96.758529}, {   0.000518,    2.270111,  -64.453079}, {   1.926635,    1.958099,  -15.305810}, {   0.005874,  -10.867919,  -56.380378}, {   3.298110,   45.576232,  -65.862998}, {   9.570053,    5.359497,  -73.278381}, {  60.868167,    0.655273, -115.223426},
			{   2.721927,    0.006713,  -80.778297}, {  20.009063,   10.653930,  -18.669532}, {   6.039550,  -17.079223,    1.448114}, {   0.002868,    0.003417,   20.540096}, {   0.001891,    0.007079,   21.788917}, {   0.004699,    0.001830,    0.003220}, {   0.005402,    0.007263,    0.003840}, {  -4.787604,    9.829620,   -0.725708},
			{   0.002135,    0.006103,   -2.414673}, {   0.004943,    0.002318,    0.003381}, {   0.000609,    0.006835,    0.007309}, {   0.004089,    0.006531,   25.739658}, {   0.000335,    0.005431,   21.787511}, {   0.006225,    0.001281,   21.274461}, {   0.728760,    0.001372,   46.247871}, {   0.003417,    0.005005,    0.003386},
			{   0.006897,    0.003417,    0.006194}, {  -0.146271,  -19.142143,   -3.393050}, {   0.007507,    0.006591,    9.960090}, {   0.003517,    0.000991,    7.600734}, {  24.497299,    7.652130,    2.523217}, {   8.512458,   -6.742763,   -3.231309}, {   0.005553,    0.005890,    0.001847}, {   0.005981,    0.001403,    0.003490},
			{   0.000579,    0.000243,    0.006111}, {   0.006041,    0.001586,    0.001183}, {   0.005981,    0.002440,    0.004397}, {   0.004153,    0.001869,    0.002277}, {   0.003325,    0.002440,    0.000800}, {   0.005981,    0.001586,    0.007369}, {   0.003548,    0.001830,    0.002006}, {   0.000792,    0.003112,    0.006984},
			{   0.000487,   32.163978,   17.113595}, {   0.000289,    0.000289,    0.007519}, {   0.002288,    0.002182,    8.328575}, {   0.001616,    0.001281,  -11.064199}, {   0.006775,    0.002196,  -14.499998}, {   0.000182,    0.004149,    0.005998}, {   1.805351,    0.002807,  -30.738403}, {   0.005646,    0.000457,   -8.319356},
			{   0.003151,    0.000731,   -6.532889}, {  13.143714,    9.566078,   -8.002960}, {  -8.854293,   14.563247,    1.487578}, {  14.075658,    0.821693,    5.959846}, {  -9.141868,  -26.094566,   -1.935351}, {   4.488547,  -13.536296,    2.914077}, { -32.960998,   -2.692740,    4.523787}, { -41.618583,   18.387977,    1.850474},
			{ -66.281791,  -26.246543,  -60.717018}, {  23.034858,   16.684028,  -52.774040}, { -29.345489,   53.005821,  -29.331970}, {-130.790298,   24.734951,  -69.433914}, { -78.317695,   18.899818,  -43.665519}, {   4.955379,   80.467788,  -38.830108}, { -21.029590,  110.984375,  -44.672485}, {  38.939556,   88.470588,  -54.706031},
			{ -14.377143,   35.991394,  -26.890016}, {  54.677360,   -9.796298,  -30.611825}, {  57.049316,    1.652945,  -37.168190}, {  54.553955,   -6.876335,  -34.889091}, {   0.000300,   -1.579524,   15.901702}, {   8.141113,    0.004455,    7.284833}, {  15.513843,   98.458602,   11.459087}, {   0.001891,    0.007079,   21.788917},
			{   0.004577,    0.006370,    0.003285}, {   0.004639,    0.006492,    0.003285}, {   0.004577,    0.006614,    0.005900}, {   0.004592,  -12.327880,  -31.001741}, {   0.003936,    0.000388,    0.005681}, {   0.003936,    0.006370,    0.003285}, {   0.003936,    0.004662,    0.003285}, {   0.003936,    0.005516,    0.005901},
			{   0.003936,  -14.175415,  -31.001743}, {   0.000731,    0.007141,    0.003879}, {   0.002815,    0.002959,    0.001200}, {   0.007056,    0.004333,    0.005946}, {   8.723266,    0.397799,  -23.084634}, {   0.003234,    0.006438,    0.006519}, {   0.002929,    0.001433,    0.005909}, {   0.002419,    0.000564,    3.625865},
			{  -0.858711,  -65.348999,   -1.655663}, { -44.413604,    0.007294,   36.025665}, {   0.003264,    0.000716,    3.951812}, {   0.005737,    0.013671,   27.418334}, {   0.007201,    0.002196,    0.006271}, {   0.000853,    0.004073,   32.160781}, {   0.000731,    0.006058,   12.674503}, {   0.001006,    0.006980,    0.035620},
			{   2.993591,    0.000153,  -19.321205}, {  15.619140,    0.007323,  -38.814758}, {  19.221462,  -21.901977,  -47.357589}, {  15.619140,    0.007323,  -38.272125}, {   0.002685,    0.007323,  -10.841361}, {   0.002685,    0.678345,   -2.154123}, {  17.454235,  -12.327148,  -50.252357}, {   0.002685,  -12.327148,  -50.252395},
			{   0.002685,  -13.759520,   -2.864675}, {   0.002685,    0.007323,   -9.782142}, {   0.002685,  -12.327148,  -50.252395}, {   0.002685,    0.007323,    0.005253}, {   0.002685,  -12.327148,    0.005423}, {   0.002685,    0.006469,    0.005253}, {   0.002685,  -12.327148,    0.005419}, {   0.002685,    0.007323,    0.005253},
			{   0.002685,  -12.327148,    0.005419}, {   0.002685,    0.007323,    0.005253}, {   0.002685,  -12.327148,    0.005419}, {   0.002685,    0.006469,    0.005638}, {   0.000487,    0.007323,    0.005286}, {   0.000487,  -15.291542,    0.005452}, {   0.000487,    0.000365,    0.001307}, {   0.000487,    0.000365,    0.002620},
			{   0.005371,    0.002754,   -8.320121}, {   0.005371,    0.005309,   -8.324501}, {   0.005371,    0.000060,   -8.326919}, {   0.005371,    0.002624,  -16.649429}, {   0.001861,    0.004699,   -8.325386}, {   0.005096,    0.002624,   -4.448218}, {   3.334594,  -55.549987,  -32.281951}, {  -0.848145,  -61.229675,  -16.084739},
			{   0.000487,   -0.177063,  -16.084732}, {  -1.541321,    0.000487,  -57.399139}, {   5.529633,  -39.038787,  -57.610076}, {  21.225830,  -13.570465,  -47.222381}, {  -5.730957,   -7.726311,  -89.805404}, { -90.102294,    6.594620, -102.485092}, {-101.365478,    1.568755,  -95.500717}, { -99.243164,    0.997681,  -96.758529},
			{   0.000518,    2.270111,  -64.453079}, {   1.926635,    1.958099,  -15.305810}, {   0.005874,  -10.867919,  -56.380378}, {   3.298110,   45.576232,  -65.862998}, {   9.570053,    5.359497,  -73.278381}, {  60.868167,    0.655273, -115.223426}, {   2.721927,    0.006713,  -80.778297}, {  20.009063,   10.653930,  -18.669532},
			{   6.039550,  -17.079223,    1.448114}, {   0.002868,    0.003417,   20.540096}, {   0.004616,    0.000388,    0.001765}, {   0.004699,    0.001830,    0.003220}, {   0.005402,    0.007263,    0.003840}, {  -4.787604,    9.829620,   -0.725708}, {   0.002135,    0.006103,   -2.414673}, {   0.004943,    0.002318,    0.003381},
			{   0.000609,    0.006835,    0.007309}, {   0.004089,    0.006531,   25.739658}, {   0.000335,    0.005431,   21.787511}, {   0.006225,    0.001281,   21.274461}, {   0.728760,    0.001372,   46.247871}, {   0.003417,    0.005005,    0.003386}, {   0.006897,    0.003417,    0.006194}, {  -0.146271,  -19.142143,   -3.393050},
			{   0.007507,    0.006591,    9.960090}, {   0.003517,    0.000991,    7.600734}, {  24.497299,    7.652130,    2.523217}, {   8.512458,   -6.742763,   -3.231309}, {   0.005981,    0.001403,    0.003490}, {   0.000579,    0.000243,    0.006111}, {   0.006041,    0.001586,    0.001183}, {   0.005981,    0.002440,    0.004397},
			{   0.004153,    0.001869,    0.002277}, {   0.003325,    0.002440,    0.000800}, {   0.005981,    0.001586,    0.007369}, {   0.003548,    0.001830,    0.002006}, {   0.000792,    0.003112,    0.006984}, {   0.000487,   32.163978,   17.113595}, {   0.000289,    0.000289,    0.007519}, {   0.001616,    0.001281,  -11.064199},
			{   0.006775,    0.002196,  -14.499998}, {   0.000182,    0.004149,    0.005998}, {   1.805351,    0.002807,  -30.738403}, {   0.005646,    0.000457,   -8.319356}, {   0.003151,    0.000731,   -6.532889}, {  13.143714,    9.566078,   -8.002960}, {  -8.854293,   14.563247,    1.487578}, {  -9.141868,  -26.094566,   -1.935351},
			{   4.488547,  -13.536296,    2.914077}, { -32.960998,   -2.692740,    4.523787}, { -41.618583,   18.387977,    1.850474}, { -66.281791,  -26.246543,  -60.717018}, {  23.034858,   16.684028,  -52.774040}, { -29.345489,   53.005821,  -29.331970}, {-130.790298,   24.734951,  -69.433914}, { -78.317695,   18.899818,  -43.665519},
			{ -21.029590,  110.984375,  -44.672485}, {  38.939556,   88.470588,  -54.706031}, { -14.377143,   35.991394,  -26.890016}, {  54.677360,   -9.796298,  -30.611825}, {  57.049316,    1.652945,  -37.168190}, {  54.553955,   -6.876335,  -34.889091}, {   0.000300,   -1.579524,   15.901702}, {  15.513843,   98.458602,   11.459087},
			{  -2.971834,   -0.937610,    4.803422}, {  -3.428865,   -0.946195,    4.800051}, {  -3.478890,   -0.949340,    4.802031}, {  -3.479847,   -0.945429,    4.807104}, {  -3.687670,   -0.955151,    4.803794}, {  -3.089869,   -0.947866,    4.803794}, {-113.407020,   -5.088868,   43.516448}, { -89.090995,   -5.377206,   27.149091},
			{ -15.013545,   -4.980834,   -4.386743}, {   0.001886,    0.003667,    0.006099}, {   0.002823,   -0.718562,    0.001077}, {  -0.008196,   -0.717004,    0.001078}, {   0.006244,   -0.710650,    0.002728}, {  -0.003663,   -0.718474,    0.002742}, {  -0.003102,    0.001032,    1.958564}, {  -0.000308,   -0.099533,    2.687232},
			{   0.004966,   -0.114049,    2.718317}, {   0.005183,   -0.028601,    2.035815}, {   2.020430,   12.239996,    4.707191}, {  42.942115,   -1.263077,   30.797571}, { -60.580898,  -64.894874,   36.775138}, {   0.007259,    0.002230,    0.003802}, {   0.001088,    0.001354,    0.005696}, {  24.457117,   20.136344,   14.405656},
			{   0.005553,    0.005890,    0.001847}, {   4.955379,   80.467788,  -38.830108}, {   0.004395,    0.003570,    6.638639}, {   0.002288,    0.002182,    8.328575}, { -89.465698, -110.561035,    0.000396}, { -89.465698, -110.561035,    0.000396}, {  14.075658,    0.821693,    5.959846}, {   0.000853,    0.000960,   46.390502},
			{   0.000853,    0.000960,   46.390502}, {   8.141113,    0.004455,    7.284833}, {   7.979003,    0.028319,  -17.824548}, {   7.979003,    0.028319,  -17.824548}, {   0.006103,    0.003173,   -2.515175}, {   0.006103,    0.003173,   -2.515175}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.004089,    0.006103,   64.899810}, {  -0.018494,   21.668518,    0.358655},
			{   0.255553,    0.052611,    0.000486}, {  -1.242431,   -0.005615,   -1.063876}, {  -2.700212,   -0.141187,   -0.088289}, {   0.218445,   -0.035399,    0.670569}, {   1.252990,   -2.361267,   -0.952067}, {   0.001830,    1.254577,    0.004329}, {  -0.150512,    0.636901,    0.000884}, {   6.209473,   -5.405395,    4.764180},
			{ -14.428894,   -3.637268,   -0.755361}, {   0.004089,    0.006103,   64.899810}, {  -0.191405,    0.038391,   -0.021368}, {   0.136760,   -0.010405,   44.032321}, {   1.942878,   -0.595970,   -0.083678}, {   2.375761,    1.439453,   -0.004633}, {   0.136760,   -0.010405,   44.032321}, {  -0.069641,    0.005187,    0.002094},
			{  -0.048523,    0.002318,    0.005014}, {   0.001159,    0.007445,   -1.611626}, {   0.282173,    9.312316,    1.308261}, {  -2.488708,    0.001464,    6.496411}, {   0.580260,    0.262450,    1.376925}, {  -0.645630,   -1.492187,    5.739942}, {  -0.000464,   -0.002400,    0.005882}, {   3.001358,   -8.571548,    0.550940},
			{  -0.891641,    5.118844,    5.197692}, {  -2.488708,    0.001464,    6.496411}, {   0.282173,    9.312316,    1.308261}, {   1.942878,   -0.595970,   -0.083678}, {   0.003782,    0.009398,    0.006461}, {   0.859637,    0.093670,   15.086159}, {  -0.891641,    5.118844,    5.197692}, {  -0.645630,   -1.492187,    5.739942},
			{   0.022980,   -0.537455,    1.514207}, {   0.008545,   -0.056396,    1.932544}, {   0.003370,    0.004147,   21.909477}, {   0.003905,    0.007813,   -0.054687}, {   0.250000,   -0.327010,    0.013763}, {   0.865540,    0.114257,   -0.492967}, {   0.948547,   -0.912231,    0.173893}, {  -1.639238,   -0.527900,    5.274685},
			{  10.943725,   -0.087829,    0.249843}, { -28.656620,   -1.094421,   13.982082}, {  -5.486703,  -14.708500,   11.179444}, {   0.001403,    0.003051,    0.001492}, {   0.001910,    0.004691,    0.000452}, {   0.001358,    0.002241,   -0.024343}, {   0.002744,    0.004865,    0.001031}, {   0.005553,    0.002884,   -0.027543},
			{  -4.730876,   -2.576935,    7.043373}, {  -1.247130,    0.005630,   34.202499}, {   0.003782,    0.009398,    0.006461}, {   0.859637,    0.093670,   15.086159}, {   0.004730,   -0.073036,   -0.002357}, { -20.195312,   -3.351562,   64.927276}, {  -5.486703,  -14.708500,   11.179444}, {   0.948547,   -0.912231,    0.173893},
			{   6.209473,   -5.405395,    4.764180}, { -14.428894,   -3.637268,   -0.755361}, {  -0.150512,    0.636901,    0.000884}, {   0.865540,    0.114257,   -0.492967}, {  -1.639238,   -0.527900,    5.274685}, {  -0.709187,    0.004271,   -0.661085}, {   0.001830,    1.254577,    0.004329}, {   1.252990,   -2.361267,   -0.952067},
			{ -28.656620,   -1.094421,   13.982082}, {   0.004730,   -0.073036,   -0.002357}, {   0.006866,    0.001281,    0.004652}, {   0.004761,   -1.246520,   -1.109534}, {  -2.700212,   -0.141187,   -0.088289}, {   0.010192,   -0.733642,    0.000799}, {   4.255493,    6.755372,   69.740463}, {   2.375761,    1.439453,   -0.004633},
			{   0.022980,   -0.537455,    1.514207}, {  -4.730876,   -2.576935,    7.043373}, {   0.008545,   -0.056396,    1.932544}, {   0.001159,    0.007445,   -1.611626}, {   0.580260,    0.262450,    1.376925}, {   0.003370,    0.004147,   21.909477}, {   0.003905,   -1.745728,    0.009021}, {   0.218445,   -0.035399,    0.670569},
			{   0.255553,    0.052611,    0.000486}, {  -1.247130,    0.005630,   34.202499}, {  -0.018494,   21.668518,    0.358655}, {   0.001403,    0.003051,    0.001492}, {  -1.988281,    4.528992,   -0.102279}, {   0.001041,    0.000538,   -0.060251}, {   0.002600,   -0.117127,    0.002365}, {   0.000224,   -0.123538,    0.002365},
			{   0.003399,   -0.118661,    0.002365}, {   0.005158,   -0.106264,    0.002365}, {   0.002919,   -0.111574,    0.002365}, {   7.308350,   -1.803650,    0.104149}, {   0.008361,    0.004333,    0.008715}, {   0.004761,   -1.246520,   -1.109534}, {  -1.242431,    0.002318,   -1.131567}, {   0.003905,   -1.745728,    0.009021},
			{   0.010192,   -0.733642,    0.000799}, {   0.003478,    0.007416,    0.000627}, {   0.021850,   -0.005950,    0.009778}, {   0.005127,    0.003386,    0.010796}, {   0.001525,    0.007019,    0.000719}, {   5.983788,   -0.067782,   -0.115987}, {  -0.709187,    0.004271,   -0.661085}, {   5.983788,   -0.067782,   -0.115987},
			{ -11.154961,   -0.018558,    1.876041}, { -11.154961,   -0.018558,    1.876041}, {   0.011746,    0.000984,    0.026032}, {   0.011746,    0.000984,    0.026032}, {   0.003381,    0.006634,    0.005539}, {   0.003381,    0.006634,    0.005539}, {   1.235826,   -0.214028,    0.537325}, {   1.235826,   -0.214028,    0.537325},
			{  -0.035728,    0.021813,   -0.038554}, {  -0.035728,    0.021813,   -0.038554}, {   0.007354,    0.002036,    0.007114}, {   0.007354,    0.002036,    0.007114}, {   0.003478,    0.007416,    0.000627}, {   0.021850,   -0.005950,    0.009778}, {   0.005127,    0.003386,    0.010796}, {   0.001525,    0.007019,    0.000719},
			{  -0.048523,    0.002318,    0.005014}, {   0.008361,    0.004333,    0.008715}, {  -0.069641,    0.005187,    0.002094}, {   0.008643,   -0.007972,    0.000146}, {  -1.242431,   -0.005615,   -1.063876}, {  -1.242431,    0.002318,   -1.131567}, {   2.450190,    0.033101,   -3.534435}, {   2.450190,    0.033101,   -3.534435},
			{  -0.125916,    1.090576,   26.436470}, {  -0.125916,    1.090576,   26.436470}, {   0.793182,    0.402648,    2.599689}, {   0.006866,    0.001281,    0.004652}, {   0.430480,   10.460327,    1.491641}, {   3.885802,    9.962947,    2.491451}, {   0.793182,    0.402648,    2.599689}, {   0.004517,    0.589478,    2.680355},
			{   0.430480,   10.460327,    1.491641}, {   3.885802,    9.962947,    2.491451}, {   4.255493,    6.755372,   69.740463}, {   0.001754,    0.003347,   -0.114923}, {  -0.953094,    0.007503,    0.058612}, {   0.002400,    0.002383,    0.007337}, {   0.002400,    0.002383,    0.007337}, {   0.000211,    0.005783,    0.022515},
			{  -0.953094,    0.007503,    0.058612}, { -22.066875,    6.805115,    0.010711}, {  -0.191405,    0.038391,   -0.021368}, {   7.308350,   -1.803650,    0.104149}, {   0.014403,   -0.126250,   -0.950932}, {   0.007488,    0.001274,   -0.020059}, {   0.001586,    0.001311,   -0.078685}, {   0.000426,    0.003722,    0.000232},
			{   0.001586,    0.001311,   -0.078685}, {   0.007488,    0.001274,   -0.020059}, {   0.014403,   -0.126250,   -0.950932}, {   0.000426,    0.003722,    0.000232}, {   0.004517,    0.589478,    2.680355}, {  10.943725,   -0.087829,    0.249843}, {   0.008643,   -0.007972,    0.000146}, {   0.694396,    0.267760,    0.003864},
			{  -0.143041,   -0.148839,    0.003284}, {  -0.143041,   -0.148839,    0.003284}, {   0.088013,    0.000823,    0.006972}, {  -0.005493,    0.073181,   52.900478}, {   0.004027,    0.006165,   15.680763}, {   0.013306,    0.016173,    3.482745}, {  -4.870026,    8.641086,   10.079801}, {  -4.870026,    8.641086,   10.079801},
			{   7.024230,    1.866454,    3.280829}, {  -2.707274,    0.405701,   -6.556549}, {  -0.389342,   -1.545166,  -32.734809}, {  -0.101868,    0.963867,    5.718482}, {   0.004976,    0.002035,    0.002953}, {  -1.023388,    0.033330,   86.531852}, {   0.004027,    0.003173,    0.006560}, {   0.004027,    0.003173,   -0.267089},
			{   0.004027,    0.003173,    0.006560}, {   0.005960,   -0.004526,    0.010033}, {   0.003965,    0.004526,    0.017062}, {  -0.000751,    0.002053,    0.014159}, {   0.007240,    0.010568,    0.006347}, {   0.005853,    0.003911,    0.002440}, {   0.003177,    0.002749,    0.000335}, {   0.002241,    0.011160,    0.012512},
			{   0.005024,    0.007687,    0.001616}, {   0.006690,    0.004585,    0.001271}, {  -0.212155,   -0.100647,    0.007013}, {  -8.343545,    4.645397,    9.414663}, {   0.561339,    0.180756,    8.755392}, {  -0.583434,    0.027343,    9.040019}, {   4.255380,    6.758152,   73.981872}, {  -0.063971,    0.001426,    7.579848},
			{   7.787230,   -0.015874,   17.528181}, {  -0.134460,    1.052489,   32.163269}, { -47.858406,  -10.181797,   38.052680}, {   0.050868,    0.022430,    0.700259}, {  -4.949151,    8.402194,   11.846018}, { -17.571346,   -2.064135,   13.654822}, {  -0.194960,    0.014348,   10.621764}, {  20.421813,   -0.313903,   10.210905},
			{ -24.676391,   -0.143371,    2.537396}, {   0.003177,    0.002749,    0.000335}, {   0.005960,   -0.004526,    0.010033}, {   0.005853,    0.003911,    0.002440}, {   0.007240,    0.010568,    0.006347}, {   0.005024,    0.007687,    0.001616}, {   0.003965,    0.004526,    0.017062}, {  -0.000751,    0.002053,    0.014159},
			{   0.000211,    0.005783,    0.022515}, {   0.003905,    0.007813,   -0.054687}, { -20.195312,   -3.351562,   64.927276}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.005615,    0.006225,    0.005898}, {   9.011657,   10.001617,   -0.014716},
			{   0.001403,    0.001159,    0.004255}, {   0.004490,    0.006957,   -0.019788}, {   0.007689,    0.007079,    0.006041}, {   0.002156,    0.000953,   -0.357654}, {   0.003250,    0.002827,    0.001195}, {   0.003246,   -3.640758,    0.001195}, {   0.000098,    0.001521,    0.003365}, {   0.007232,    0.000121,    0.049883},
			{  21.449989,   -2.388062,    0.233083}, {   5.848255,   -0.002708,    0.362969}, {  -0.001647,    0.001647,   -0.021336}, {   0.003783,    0.006862,    0.001659}, {   0.006752,    0.003293,    0.004511}, {  -2.526916,    0.191071,  -11.152128}, {   0.000668,    0.001997,    0.000000}, {   0.002624,    0.001952,    0.000775},
			{   2.243468,    0.180542,    0.312736}, {   0.057610,   -0.085313,   -0.036568}, {  -0.070726,    0.000121,   -5.075951}, {   0.004089,    0.002807,    0.001593}, {   0.006347,    0.000976,   -0.263494}, {   0.000976,    0.006488,    0.003640}, {   0.011413,    3.777466,    0.618005}, {  -3.870559,   -0.009662,    0.001283},
			{   0.003783,   -0.000060,    0.005452}, {   0.004883,    0.005005,    0.003636}, {   0.002013,    0.001830,   -1.318325}, {   0.005675,    0.000731,    0.001641}, {  -0.005127,    0.017333,    0.002654}, {   0.007141,    0.001586,    0.089069}, {   1.516296,    0.005249,   -0.592914}, {   0.002331,    0.001067,    0.000000},
			{   0.004395,    0.003295,    0.003169}, {   0.002532,   -0.000057,   -0.146078}, {   0.000060,    0.000609,    0.003768}, {  -0.004889,   -0.002701,    0.003726}, {   0.002746,    0.002929,   -2.414274}, {   0.002685,    0.001464,   -0.036812}, {   0.007629,    0.004149,    0.005619}, {   0.002868,    0.001342,    0.003833},
			{  -0.004736,   -0.015224,   -0.051004}, {   0.001494,    0.004027,    7.916164}, {   0.097777,    0.006287,   -0.124907}, {   0.006682,    0.000243,   -0.701066}, {   0.000060,    0.002083,    0.141294}, {   0.000915,    0.000609,    0.476112}, {  -0.001460,    0.000849,    0.000406}, {   0.000304,    0.001006,    0.140517},
			{   0.001240,    0.002959,    0.003566}, {   0.008697,    0.013671,    0.009393}, {  -0.204955,    0.233642,    0.705533}, {   0.000915,   -3.245850,   -1.489056}, {   0.006603,    0.002685,    0.005231}, {   0.003173,    0.000487,   -0.959348}, {   0.006287,    0.005553,    0.004569}, {   0.005005,    0.005857,    0.000326},
			{   0.114136,    0.003417,   -2.507306}, {   0.000060,    0.002318,    6.037100}, {   0.003356,    0.002807,   -0.157084}, {   0.005737,    0.003661,    0.003186}, {   0.003539,    0.005493,    0.006455}, { -10.242858,    0.003783,    0.047005}, {   0.001616,    0.003277,   -0.160479}, {   0.002121,    0.003338,   -0.261216},
			{   0.002257,   -0.397278,   -4.002546}, {   0.002990,    0.504683,    0.000500}, {   0.000999,    0.002235,   -0.051174}, {   0.006347,   10.219360,   -0.797631}, {   0.000548,    0.009575,    0.003130}, {   4.223515,   -1.123389,   -0.934625}, {  70.379669,  -60.327667,   -3.274002}, {   0.002792,    0.002471,    0.003359},
			{   0.000155,    0.007536,    0.003938}, {   0.004174,   -0.116654,    0.001705}, {   0.001305,    0.000581,    0.005330}, {   0.003484,    0.002685,   -2.608112}, {   0.002349,    0.001555,    0.006835}, {   0.007584,    0.000716,    0.002484}, {   0.000976,    0.005859,    0.006362}, {   0.003325,  -15.996391,   -6.273602},
			{   8.789337,   -0.976513,    0.102536}, {   0.073030,    0.432307,    0.000338}, {   0.005828,   -1.672341,    0.004211}, {   0.002501,    0.003356,    0.002840}, {   0.001606,    0.001047,    0.003821}, {   4.223515,   -1.123389,   -0.934625}, {   0.189602,    0.046386,   -0.004052}, {   0.000487,    0.004027,    0.011741},
			{   0.001830,    0.001464,    0.003364}, {   0.004486,    0.000853,    0.004383}, {   0.003722,    0.000792,    0.148875}, {   8.789337,   -0.976513,    0.102536}, {   0.073030,    0.432307,    0.000338}, {   0.000155,    0.007536,    0.003938}, {   0.006682,    0.000243,   -0.701066}, {   0.003246,   -3.640758,    0.001195},
			{   0.004490,    0.006957,   -0.019788}, {   0.004486,    0.000853,    0.004383}, {   0.001830,    0.001464,    0.003364}, {   0.003722,    0.000792,    0.148875}, {   0.003250,    0.002827,    0.001195}, {   0.007232,    0.000121,    0.049883}, {   0.000098,    0.001521,    0.003365}, {   0.004395,    0.003295,    0.003169},
			{  21.449989,   -2.388062,    0.233083}, {   0.002156,    0.000953,   -0.357654}, {   0.002685,    0.001464,   -0.036812}, {   0.007689,    0.007079,    0.006041}, {   0.006347,   10.219360,   -0.797631}, {   0.057610,   -0.085313,   -0.036568}, {   0.000060,    0.002083,    0.141294}, {   0.002624,    0.001952,    0.000775},
			{   2.243468,    0.180542,    0.312736}, {   0.002792,    0.002471,    0.003359}, {   0.002013,    0.001830,   -1.318325}, {  -0.005127,    0.017333,    0.002654}, {   0.002257,   -0.397278,   -4.002546}, {   0.000548,    0.009575,    0.003130}, {  70.379669,  -60.327667,   -3.274002}, {   0.189602,    0.046386,   -0.004052},
			{   0.003325,  -15.996391,   -6.273602}, {   0.003484,    0.002685,   -2.608112}, {   0.002331,    0.001067,    0.000000}, {  -0.004889,   -0.002701,    0.003726}, {   0.000060,    0.000609,    0.003768}, {   0.002868,    0.001342,    0.003833}, {   0.005005,    0.005857,    0.000326}, {   0.006287,    0.005553,    0.004569},
			{   0.000060,    0.002318,    6.037100}, {   0.003356,    0.002807,   -0.157084}, {   0.005737,    0.003661,    0.003186}, {   0.001891,   -0.023925,   -0.593921}, {   1.516296,    0.005249,   -0.592914}, {   0.005675,    0.000731,    0.001641}, {   0.006347,    0.000976,   -0.263494}, {   0.004883,    0.005005,    0.003636},
			{   0.001616,    0.003277,   -0.160479}, {   0.002121,    0.003338,   -0.261216}, {   0.005828,   -1.672341,    0.004211}, {   0.011413,    3.777466,    0.618005}, {   0.003783,   -0.000060,    0.005452}, {   0.000999,    0.002235,   -0.051174}, {  -3.870559,   -0.009662,    0.001283}, {   0.000976,    0.006488,    0.003640},
			{   0.006752,    0.003293,    0.004511}, {   0.007629,    0.004149,    0.005619}, { -10.242858,    0.003783,    0.047005}, {   0.000889,  -44.457946,    0.002313}, {   0.003539,   -0.005127,   -0.583006}, {   0.002746,    0.002929,   -2.414274}, {   0.114136,    0.003417,   -2.507306}, {   0.002532,   -0.000057,   -0.146078},
			{   0.004089,    0.002807,    0.001593}, {  -2.526916,    0.191071,  -11.152128}, {  -0.001647,    0.001647,   -0.021336}, {   5.848255,   -0.002708,    0.362969}, {   0.006603,    0.002685,    0.005231}, {   0.002990,    0.504683,    0.000500}, {   0.000915,   -3.245850,   -1.489056}, {   0.001403,    0.001159,    0.004255},
			{   0.007141,    0.001586,    0.089069}, {   0.005249,    0.004352,    0.001963}, {   0.005615,    0.006225,    0.005898}, {   0.003783,    0.006862,    0.001659}, {   0.003173,    0.000487,   -0.959348}, {   0.000976,    0.005859,    0.006362}, {   0.000487,    0.004027,    0.011741}, {  -0.204955,    0.233642,    0.705533},
			{  -0.004736,   -0.015224,   -0.051004}, {   0.000670,  -14.031005,    1.056926}, {   0.097777,    0.006287,   -0.124907}, {   0.008697,    0.013671,    0.009393}, {   0.000668,    0.001997,    0.000000}, {  -6.651793,    0.001220,   -3.162362}, {   0.001991,  -12.972681,   -0.041329}, { -58.388282,    0.025947,   -2.984258},
			{   0.002945,    2.951904,    0.323437}, {   0.003653,    0.005874,    0.004501}, {   0.003053,    0.005018,    0.001728}, {   0.007182,    0.000125,   -0.918287}, {   0.006591,    0.000976,    0.000193}, {   0.001606,    0.001047,    0.003821}, {   0.002685,   14.008749,    0.004834}, {   0.005797,    0.002911,    0.003825},
			{   0.002414,    0.006049,   -0.762811}, {   0.003715,    0.006659,    0.002402}, {   0.208439,   -0.777647,    0.296936}, {   0.001255,    0.006269,    0.004439}, {  -0.000300,    0.001127,    0.004439}, {  -5.418629,    0.006269,    0.007567}, {  -9.110176,   -0.037675,    0.005956}, {  17.691776,   -0.001060,    0.007567},
			{ -40.714138,   -0.045492,    0.005956}, {   0.006469,    0.002562,    0.687009}, {   0.001891,   -0.023925,   -0.593921}, {   0.003539,   -0.005127,   -0.583006}, {   0.007019,  -37.485717,    0.007660}, {   0.007553,    0.005127,    0.007323}, { -14.117351,    0.005582,    0.004834}, {   0.005882,   -0.019286,    0.690922},
			{   0.007019,  -37.485717,    0.007660}, {   0.000889,  -44.457946,    0.002313}, {   0.002685,   14.008749,    0.004834}, { -14.117351,    0.005582,    0.004834}, {   0.005797,    0.002911,    0.003825}, {   0.002318,    0.000548,    0.003184}, {   0.002318,    0.000548,    0.003184}, {   9.011657,   10.001617,   -0.014716},
			{   0.002685,    0.006957,    0.004232}, {   0.005249,    0.004352,    0.001963}, {   0.001494,    0.004027,    7.916164}, {   0.002685,    0.006957,    0.004232}, {   0.009619,   -0.014539,    0.001763}, {   0.003600,    0.000060,   -3.339870}, {   0.003600,    0.000060,   -3.339870}, {   0.005832,    0.003848,    0.005036},
			{ -29.694709,    7.310040,    2.857322}, {   9.186779,    7.962266,   -2.798578}, {   0.003661,    0.001342,    0.004571}, {   0.003661,    0.001342,    0.004571}, {   0.003348,    0.006682,    0.007247}, {   0.003348,    0.006682,    0.007247}, {   0.004821,    0.001403,    0.007137}, {   0.003214,    0.006477,    3.529582},
			{   0.004451,    0.001298,    0.005239}, {   9.839538,  -19.906829,   -0.052648}, {   0.002449,    0.005859,    0.003132}, {   0.002449,    0.005859,    0.003132}, {   0.003173,    0.004517,   -0.551914}, {   0.003173,    0.004517,   -0.551914}, {   0.003051,    0.005615,    0.005688}, {   0.003051,    0.005615,    0.005688},
			{  -1.430858,    0.001189,   -0.210497}, {  -1.430858,    0.001189,   -0.210497}, {   0.019442,    0.578962,    0.013141}, {   0.000071,   -0.000012,    0.002680}, {   0.000556,    0.005989,    0.005239}, {   0.003539,    0.005493,    0.006455}, {   0.000487,    0.000487,   -5.536952}, {   0.000487,    0.000487,   -5.536952},
			{   0.001240,    0.002959,    0.003566}, {   0.000304,    0.001006,    0.140517}, {  -0.001460,    0.000849,    0.000406}, {   0.001281,    0.001586,    0.000344}, {   0.000670,  -14.031005,    1.056926}, {   0.007584,    0.000716,    0.002484}, {   0.002349,    0.001555,    0.006835}, {   9.839538,  -19.906829,   -0.052648},
			{   0.002231,    0.002624,    0.001767}, {  68.746170,  -21.873453,   -3.504894}, {  38.016296,    0.004443,    0.003539}, {   0.002804,    0.003967,   -0.774120}, {   0.005572,    0.004718,    0.005146}, {   0.002237,   -0.004410,    0.005231}, { -24.434814,   10.669311,   -0.348268}, {   0.001305,    0.000581,    0.005330},
			{  28.191810,    2.588530,    0.000829}, {  28.191810,    2.588530,    0.000829}, {   0.004408,    0.006103,    0.006362}, {   0.004174,   -0.116654,    0.001705}, {   0.003173,    0.001583,    0.007098}, {   0.001208,    0.007211,    0.001851}, {   0.000976,    0.003051,    0.007344}, {   0.000976,    0.005005,    0.003831},
			{   0.007445,   -0.000121,    0.007602}, {  -0.401749,   -7.411732,    0.008596}, {   8.281385,    7.327785,    0.007534}, {   3.424854,   14.523469,    0.007555}, {   0.006775,    0.002685,    0.007486}, {   0.000609,    0.006103,    0.002241}, {   0.001305,    0.002020,    0.005779}, {  -5.370862,   -2.026134,   -1.013458},
			{  -7.282803,   19.196563,   -2.450927}, {   0.005280,    0.003684,    0.005415}, {   0.002994,    0.004898,    0.002177}, {   9.152179,   11.334733,    8.583650}, {  -5.240849,   -3.171623,   -6.826920}, {   0.000000,    0.000000,    0.000000}, {  -2.982219,   -6.781166,   -6.971590}, {   1.901936,   -9.851112,   -8.672307},
			{  12.295841,   13.138450,   -8.636889}, {   4.037483,   -3.829406,   -6.057713}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.004554,   56.619293,    0.004784}, {   0.907850,    0.001647,   -0.364526}, {   0.003661,   -0.000121,   -4.338232}, {   0.009147,   -0.001327,    0.000125}, {   0.000976,    0.000487,  -13.323918}, {   0.567017,    0.488281,   -0.998265}, {  -0.050781,   -0.281798,   -1.713374},
			{   3.801846,    0.004738,    4.465436}, {   0.008453,    0.000915,   -7.113351}, {   0.003417,    0.006835,    0.045322}, {  33.994876,    1.013427,   -8.069634}, {   0.000670,   -0.070647,    0.007705}, {   0.001342,    0.000670,   -0.009684}, {   0.001307,    0.001140,    0.001658}, {   0.002430,    0.003509,    0.000829},
			{  30.106567,    0.001708,    0.001130}, {   0.000976,    0.001342,   -0.596405}, {  -3.959228,   -1.593770,    4.124168}, {   0.000538,    0.002937,   -0.132706}, {   0.004104,    0.000350,   -1.873065}, {   0.002807,    0.001220,    0.002422}, {   5.853151,    0.075225,    0.135270}, {   0.005694,    0.002697,    0.702840},
			{   0.000976,    0.003295,    0.001570}, {  -0.003936,    0.005555,    0.002735}, {   0.003295,    0.002074,    0.637098}, {   0.000468,    0.003138,   -0.028774}, {   0.004860,   -0.002877,    1.225159}, {  -0.005340,    0.000731,   -0.070859}, {   6.538794,   -0.578251,   -1.244078}, { -25.578369,   17.134552,   -0.892504},
			{  -0.443358,    0.001952,    0.276172}, {   0.000609,    0.001037,   -0.955765}, {   0.007201,  -36.380615,   -3.072782}, {   0.000487,    0.040282,   -1.465561}, {   0.402536,    0.140542,    0.001145}, {   0.005615,    2.504822,   -0.106467}, {   0.001342,    0.006225,   -0.925185}, {  -0.000121,    0.021121,  -20.327400},
			{  -0.010398,    0.004887,    0.499285}, {   0.002562,    0.005249,    4.875721}, {   0.010269,   -9.664054,   -3.339993}, { -16.860958,    0.020419,   -4.659482}, { -54.383213,    0.002304,    0.028723}, {  -0.009247,    0.160254,   -1.871086}, {  -1.286643,   -9.112962,   -2.638709}, {  -9.938684,   -7.385426,    0.311841},
			{   0.001995,    0.000300,    0.003504}, {   0.003582,    0.002374,    0.001766}, {  -0.002562,    0.000243,    0.000186}, {   0.853627,    0.006362,    8.563757}, {  -0.157123,   -0.087220,    0.044066}, { -38.966033,    0.000742,   -0.502451}, {   0.279558,  -19.584861,   11.979206}, {  -0.006765,    0.007331,    0.002358},
			{ -55.901420,    7.942483,   -4.343411}, {   0.853627,    0.006362,    8.563757}, {  -0.157123,   -0.087220,    0.044066}, { -38.966033,    0.000742,   -0.502451}, {   3.139525,    2.207159,   -6.310140}, {  -0.009909,    0.067487,   -0.014786}, {  29.429698,    8.085762,   -3.218139}, {  -0.006765,    0.007331,    0.002358},
			{   0.005948,   -0.000019,   -0.733695}, {   0.002257,    0.002776,    0.002786}, {   0.006713,    0.005127,    0.001686}, {   0.350932,   -0.215770,    0.030208}, {   0.000121,    2.474426,   -1.903545}, {   0.001220,   -0.061889,    0.007089}, {  -0.151978,    2.142272,    0.001215}, {  15.322387,   -8.690549,   -0.777547},
			{   0.004761,   14.586471,   -9.754250}, {   8.614868,   -0.077019,   -0.663945}, {   0.002074,   -0.000060,    0.001122}, {   0.002501,    0.007416,    0.001335}, {   0.001632,   -0.443388,   -0.628089}, {   0.006531,   -1.545287,    0.118148}, {   0.058717,   -1.901610,    0.131003}, {   0.030525,   -0.660426,   -0.038586},
			{   0.000365,   11.179565,  -28.292747}, {   0.065307,   -0.059569,   -0.042119}, {   0.002074,    0.002746,    0.002755}, {   0.005249,   -0.144527,   -0.727542}, {   0.001586,   -2.499634,   -0.023862}, {   0.002589,   -0.002307,    0.006283}, {   0.001839,    0.001410,    0.000895}, {   0.006916,   -0.003909,    0.007062},
			{   0.005330,    0.003783,   -1.961536}, {   0.000976,    0.000487,  -13.323918}, {   0.001342,    0.000670,   -0.009684}, {   0.000609,    0.001037,   -0.955765}, { -25.578369,   17.134552,   -0.892504}, {   0.065307,   -0.059569,   -0.042119}, {   0.002589,   -0.002307,    0.006283}, {   0.402536,    0.140542,    0.001145},
			{   0.002074,    0.002746,    0.002755}, {  -0.443358,    0.001952,    0.276172}, {   0.007201,  -36.380615,   -3.072782}, {   0.000976,    0.001342,   -0.596405}, {   0.000487,    0.040282,   -1.465561}, {   0.030525,   -0.660426,   -0.038586}, {   0.001632,   -0.443388,   -0.628089}, {   0.006531,   -1.545287,    0.118148},
			{   0.058717,   -1.901610,    0.131003}, {   0.001307,    0.001140,    0.001658}, {  -3.959228,   -1.593770,    4.124168}, {   0.009147,   -0.001327,    0.000125}, {   0.004104,    0.000350,   -1.873065}, {   0.000538,    0.002937,   -0.132706}, {   0.005694,    0.002697,    0.702840}, {   0.000468,    0.003138,   -0.028774},
			{  30.106567,    0.001708,    0.001130}, {   0.005615,    2.504822,   -0.106467}, {  -0.050781,   -0.281798,   -1.713374}, {  15.322387,   -8.690549,   -0.777547}, {   0.002807,    0.001220,    0.002422}, {   0.005330,    0.003783,   -1.961536}, {   0.000670,   -0.070647,    0.007705}, {  -0.151978,    2.142272,    0.001215},
			{   0.005948,   -0.000019,   -0.733695}, {   8.614868,   -0.077019,   -0.663945}, {   0.567017,    0.488281,   -0.998265}, {   0.002074,   -0.000060,    0.001122}, {   0.006103,    0.401488,    0.002411}, {   0.000976,    0.003295,    0.001570}, {   0.001342,    0.006225,   -0.925185}, {   5.599602,   -1.343780,    0.603783},
			{  -0.137450,    8.280883,   -3.356189}, {  -0.574012,   -8.454236,    0.004031}, {   0.000205,    0.007441,   -0.003431}, {   0.002562,    0.005249,    4.875721}, {   0.010269,   -9.664054,   -3.339993}, {   0.004761,   14.586471,   -9.754250}, {   0.000121,    2.474426,   -1.903545}, {   0.008453,    0.000915,   -7.113351},
			{   0.001586,   -2.499634,   -0.023862}, {  -9.938684,   -7.385426,    0.311841}, {  -0.000121,    0.021121,  -20.327400}, {  -0.323603,    0.000075,    0.002180}, {   0.021575,   -0.001575,    0.006672}, {   0.002430,    0.003509,    0.000829}, {   0.004554,   56.619293,    0.004784}, {  -0.009247,    0.160254,   -1.871086},
			{   0.002501,    0.007416,    0.001335}, {   0.005249,   -0.144527,   -0.727542}, {   0.000609,    0.002074,   -1.405990}, {   0.000609,    0.002074,   -1.405990}, {  33.994876,    1.013427,   -8.069634}, {   0.000365,   11.179565,  -28.292747}, {   0.003417,    0.006835,    0.045322}, {   3.801846,    0.004738,    4.465436},
			{   0.001220,   -0.061889,    0.007089}, {  -0.005340,    0.000731,   -0.070859}, {  -0.010398,    0.004887,    0.499285}, {   0.003904,   -0.002104,    1.747856}, {   0.004507,   -0.004416,    0.001174}, {   0.007027,    0.003623,    1.498656}, {   0.004538,   -0.001248,    0.007833}, { -16.860958,    0.020419,   -4.659482},
			{   0.907850,    0.001647,   -0.364526}, { -13.758124,    4.335739,   -5.548626}, {   0.005282,    0.005824,    0.002054}, {   0.006103,    0.401488,    0.002411}, {   0.001037,    0.001952,    0.006723}, {   0.005603,    0.003796,    0.006537}, {   0.006996,    0.002189,    0.002872}, {   0.004027,    0.003417,   -2.407740},
			{   0.007079,    0.000792,    0.001628}, {   0.001957,    0.003787,    0.001583}, {  -2.260138,    0.228644,   -0.079976}, {   0.007201,    0.000487,   -0.291608}, {   0.002562,    0.006957,    0.007238}, {   0.012172,    0.011105,   -0.072694}, {   0.039528,    0.029147,    2.921714}, {   0.000000,    0.000609,   -1.782114},
			{   0.000000,    0.000609,   -1.782114}, {   0.006996,    0.002189,    0.002872}, {   0.001957,    0.003787,    0.001583}, {   0.007079,    0.000792,    0.001628}, {   0.002562,    0.006957,    0.007238}, {   0.039528,    0.029147,    2.921714}, {  -2.260138,    0.228644,   -0.079976}, {   0.012172,    0.011105,   -0.072694},
			{   0.004027,    0.003417,   -2.407740}, {   0.007201,    0.000487,   -0.291608}, {   6.653168,   -2.301552,   -4.967789}, { -16.733209,   19.642717,    0.004102}, {   0.007197,    0.007160,    0.000205}, {   0.452506,   -0.339792,    0.213299}, {   0.006622,    0.007629,    0.001637}, {  57.927047,  -18.957771,   10.327834},
			{   0.004149,    0.007907,   -0.292252}, {   0.000731,    0.006386,   -0.174886}, {   0.007255,    0.002300,    0.005286}, {   0.000976,    0.000243,   13.007488}, {   0.000976,    0.000243,   13.007488}, {  -0.908102,    0.234373,    0.088913}, {  -0.006982,    0.007118,    0.007480}, {   0.006916,   -0.003909,    0.007062},
			{   5.853151,    0.075225,    0.135270}, {   0.021575,   -0.001575,    0.006672}, {   0.056777,    0.005706,    0.006355}, {   0.004149,    0.007907,   -0.292252}, {  -0.915054,    0.229188,    0.088913}, {   0.002636,    0.006703,    0.006829}, {  -1.805444,    1.079987,    5.290853}, {   0.001098,    2.677377,    9.123331},
			{   0.006632,    0.002036,    0.003436}, {   0.001731,    0.003771,    0.070431}, {   0.004699,    0.007201,    0.001144}, {   0.004699,    0.007201,    0.001144}, {   0.001731,    0.003771,    0.070431}, {   0.002636,    0.006703,    0.006829}, {  -1.805444,    1.079987,    5.290853}, {   0.001098,    2.677377,    9.123331},
			{   0.000731,    0.006386,   -0.174886}, {   6.538794,   -0.578251,   -1.244078}, {  11.423217,    4.354125,    0.933624}, {   0.005107,    0.004883,    0.006914}, {   0.003742,    0.006988,    0.004379}, {   0.001845,    0.003990,    0.000750}, {   0.004265,    0.001854,    0.004513}, {  20.509349,  -21.368831,    0.051706},
			{   0.004523,    0.002300,    0.007677}, {   0.004639,    0.000243,    0.002953}, {   0.004517,    0.007567,    0.001520}, {   0.004517,    0.007567,    0.001520}, {   0.004639,    0.000243,    0.002953}, { -17.179138,   -0.037193,   -3.644361}, { -17.179138,   -0.037193,   -3.644361}, { -55.901420,    7.942483,   -4.343411},
			{  29.429698,    8.085762,   -3.218139}, {   0.007271,    0.000464,    0.005164}, {   0.005996,    0.006233,    0.007765}, {   0.003844,    0.005661,    0.001785}, {  -0.005291,    0.002059,    0.004902}, {  -4.987834,   -4.291564,    0.005146}, {   0.002624,    0.002624,    0.001648}, {   0.003783,    0.001769,    0.001582},
			{   0.002624,    0.002624,    0.001648}, {   0.003783,    0.001769,    0.001582}, {   0.002257,    0.002776,    0.002786}, {   0.005228,    0.007127,   -0.498340}, {   0.005228,    0.007127,   -0.498340}, {   0.001830,    0.002814,    0.002166}, {   0.001830,    0.002814,    0.002166}, {  -4.137701,    0.142245,    0.004007},
			{   3.139525,    2.207159,   -6.310140}, {   0.000106,   -0.000084,    0.000873}, {   0.000106,   -0.000084,    0.000873}, {   0.118041,    0.000915,   -2.171624}, {   0.118041,    0.000915,   -2.171624}, { -16.733209,   19.642717,    0.004102}, {  -0.000121,    0.000365,    0.007573}, { -54.383213,    0.002304,    0.028723},
			{   0.006713,    0.005127,    0.001686}, {  -0.908102,    0.234373,    0.088913}, {  -0.915054,    0.229188,    0.088913}, {   0.002894,    0.005615,    0.003833}, {   0.006635,    0.002833,    0.001509}, {   0.003661,   -0.000121,   -4.338232}, { -22.290216,   -4.677814,   -6.530357}, {  67.794143,    0.369423,  -10.463670},
			{  -5.061768,  -34.975830,   -2.707056}, { -11.491584,   21.751518,   -8.795531}, { -12.221267,    0.392780,   -7.320167}, {  -6.205262,   23.765611,   -5.675613}, {  -0.737545,    0.690909,   -5.957221}, { -18.708145,   33.993156,  -10.995319}, { -23.641199,    5.566979,   -8.303870}, { -13.885327,   63.003540,   -4.799728},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  -7.455205,  -18.262165,    8.697372}, {   0.000635,    0.007160,    0.000399},
			{   0.006606,    0.005733,   -0.311522}, {   0.002379,    0.059997,    0.000000}, {   0.091553,    0.256042,    2.941246}, {   0.002685,    0.001220,    0.003144}, {   0.759765,    1.786010,   -0.962224}, {   0.000065,    0.004372,    0.003573}, {   0.004027,    0.005615,    0.007567}, {  -3.813182,    6.956726,    0.021142},
			{   1.662230,    1.650635,    0.020635}, {   0.002679,    0.003634,    0.001949}, {  -8.355569,  -17.249877,    8.210785}, {   0.002929,    0.004668,    7.981019}, {  30.847534,    0.004517,    0.010191}, {   7.536865,   -0.023621,    0.053091}, {  -0.126708,    0.622192,    0.203013}, {   0.007017,   -0.021893,    1.353096},
			{   7.913756,    0.165077,   -0.381868}, {  11.664024,    2.311188,    1.685021}, {   0.007069,    0.000931,    0.003746}, {   0.000530,    0.195618,    0.156148}, {   0.000574,   -1.503393,    1.147580}, {   0.005737,   -7.684143,    0.730446}, { -13.098287,    0.000015,   -0.004703}, {   2.502059,    0.000976,    0.018017},
			{   0.002564,    0.002418,    0.000245}, {   0.003844,    0.001501,    0.007612}, {   0.003783,    0.004149,   -0.158757}, {   0.065052,    0.003967,    0.007042}, {   0.007689,    0.006957,    0.943715}, {   0.001252,    0.000731,    0.002106}, {  -0.000031,    0.000410,    0.005789}, {   2.498939,    0.004954,   -0.767485},
			{ -38.618408,    0.080687,    0.500890}, {   3.064445,    0.251545,   -0.587345}, {   0.002094,    0.004765,   13.644263}, {  -8.115608,   -0.138794,    0.000553}, {   0.004149,    0.005493,    0.001558}, {   0.002379,    0.000433,    0.000623}, {  -5.236679,    2.914124,   -0.289148}, {   0.001128,    0.000368,    0.000176},
			{  -0.003722,   17.485607,    3.702207}, {  -0.011413,    0.001159,   -0.033757}, {   0.004581,   -0.014526,    0.001842}, {   0.006403,   -0.001439,    0.000022}, {   0.029479,    7.104953,    0.686619}, {   7.558327,   29.392057,   -0.091996}, {   1.424728,   14.723438,   -0.655543}, {  -0.006713,   -0.001891,   -0.039850},
			{  -0.994385,    6.638793,   -0.711930}, {  -0.258511,   -0.000793,   -0.011397}, {  -0.059386,   -0.007853,   -0.008372}, {   0.019845,   11.123107,    0.848294}, {   0.007385,    0.006591,    0.005950}, {   0.005754,    0.003625,    0.007646}, { -15.065696,   13.913549,    6.448303}, {   0.609616,    0.484243,    0.000821},
			{   0.357084,    0.005123,    7.855855}, {  53.274177,   -0.574944,    1.182862}, {  -2.848182,    2.307940,    2.618287}, {  -4.709675,    1.865048,    0.107073}, {  -0.108800,    0.006777,   -0.081625}, {   0.002472,    0.002950,    0.007548}, {   0.003783,    0.000745,    0.007544}, {  -1.885941,   -4.674491,   -2.600451},
			{  -1.885941,   -4.674491,   -2.600451}, {   0.007567,    0.003173,    0.421510}, {  -0.191990,    0.001823,    0.007199}, {   0.146402,   -0.502309,    5.026753}, {  -0.191990,    0.001823,    0.007199}, {   0.007555,    0.003195,    0.003778}, {  -0.446218,    1.124328,    1.489961}, {   0.002644,    0.006829,    0.003640},
			{   0.226528,   -0.491721,    0.002577}, {   0.003646,    0.003425,    0.001846}, {   0.002644,    0.006829,    0.003640}, {   1.996361,   14.098182,    4.556857}, { -13.098287,    0.000015,   -0.004703}, {   0.000731,    0.000991,    0.002155}, {   4.579394,   40.618736,    3.827476}, {   0.000609,    0.002426,    0.002618},
			{   1.499104,    7.661542,    0.327172}, {   0.002749,    0.002868,    0.004230}, {   0.006972,    7.713710,    9.102253}, {   0.001939,  -10.609027,    0.004211}, {   0.006444,    0.002933,    0.001089}, {  -0.009521,    0.007689,   -0.000125}, {   0.004395,    0.002379,    0.001945}, {   0.004027,    0.001952,   -0.007895},
			{   0.002074,    0.072936,   -0.003877}, {   0.003783,    0.000745,    0.007544}, {   2.953928,    1.552762,    0.145098}, {   0.373358,   -4.370173,    0.368983}, {   1.150856,    3.832241,   -1.439584}, {  -6.274300,   -0.260780,   -0.163617}, {  -0.012633,   -0.003967,   -0.000134}, {   0.003957,    0.004896,    0.007575},
			{  -5.403263,   -3.185729,   -2.778666}, {   3.659117,  -13.004561,   -0.034770}, {   1.183925,    0.004569,   -0.002051}, {   0.001910,    0.006103,    0.009277}, {   3.183571,   -0.015869,    0.009035}, {   1.128314,   -0.304347,   -0.010679}, { -16.160846,  -11.211977,    0.038431}, {  -6.293046,    5.389445,   -0.102844},
			{   0.979750,    4.871056,    0.511795}, {  -0.405579,   -0.002213,   -1.251276}, {   0.006115,    0.002990,    0.001612}, {  -4.643187,    0.108459,   -0.315851}, {  -9.510131,   -2.192322,    0.004048}, {  -2.962376,    1.110070,   -0.010935}, {  -2.946907,   -1.234632,    0.011575}, { -16.046298,    2.001178,    0.004226},
			{   6.147766,    0.092834,    0.465131}, {  -1.260303,    8.085327,    0.004230}, {  -7.405096,    2.552442,    0.008522}, {  -0.003982,   -0.001190,   -0.011266}, {   0.000800,    0.006225,    0.011086}, {   0.000976,    0.002379,    0.000203}, {  -0.162354,  -11.657897,   -0.357443}, {   4.721902,  -13.109741,    2.857667},
			{ -17.602600,  -10.052185,    2.777091}, {   0.006591,   -0.000646,    0.005934}, {   0.000609,    0.002426,    0.002618}, {   0.006972,    7.713710,    9.102253}, {   0.001939,  -10.609027,    0.004211}, {   0.006444,    0.002933,    0.001089}, {   0.004395,   -9.761352,    0.618409}, {   0.000012,    0.009576,    0.203162},
			{   0.008747,    0.014709,    0.008748}, {  24.486736,  -13.695438,    6.904746}, {   0.004774,    0.000270,    0.004389}, {   0.000530,    0.195618,    0.156148}, { -29.392486,   -0.371886,    0.016263}, {   0.003844,    0.001501,    0.007612}, {  24.486736,  -13.695438,    6.904746}, {   0.031488,    0.003002,    0.003961},
			{   0.001384,    0.006835,    0.002804}, {   0.000800,    0.006225,    0.011086}, {   0.003783,    0.004149,   -0.158757}, {  -5.236679,    2.914124,   -0.289148}, {   0.031488,    0.003002,    0.003961}, {   3.659117,  -13.004561,   -0.034770}, { -16.046298,    2.001178,    0.004226}, {  11.664024,    2.311188,    1.685021},
			{   0.000065,    0.004372,    0.003573}, {  -1.260303,    8.085327,    0.004230}, {  -0.272962,   -0.008623,   -0.121336}, {  -7.405096,    2.552442,    0.008522}, {   0.001384,    0.006835,    0.002804}, {  -2.946907,   -1.234632,    0.011575}, {  -2.962376,    1.110070,   -0.010935}, {  -0.258511,   -0.000793,   -0.011397},
			{   7.913756,    0.165077,   -0.381868}, {   0.000574,   -1.503393,    1.147580}, {  -0.003982,   -0.001190,   -0.011266}, {   0.007017,   -0.021893,    1.353096}, {   6.147766,    0.092834,    0.465131}, {   0.004395,   -9.761352,    0.618409}, {   0.000976,    0.002379,    0.000203}, {   0.007069,    0.000931,    0.003746},
			{  -0.162354,  -11.657897,   -0.357443}, {   0.000635,    0.007160,    0.000399}, {   0.000012,    0.009576,    0.203162}, {   0.065052,    0.003967,    0.007042}, {  30.847534,    0.004517,    0.010191}, {   4.721902,  -13.109741,    2.857667}, {   0.006591,   -0.000646,    0.005934}, { -17.602600,  -10.052185,    2.777091},
			{  -0.006713,   -0.001891,   -0.039850}, {   0.002074,    0.072936,   -0.003877}, {   0.004027,    0.001952,   -0.007895}, {  -0.994385,    6.638793,   -0.711930}, {   1.499104,    7.661542,    0.327172}, {   0.002934,   -0.244784,    0.032223}, {   0.004395,    0.002379,    0.001945}, {   0.091553,    0.256042,    2.941246},
			{   0.002685,    0.001220,    0.003144}, {   1.424728,   14.723438,   -0.655543}, {   0.002379,    0.000433,    0.000623}, {   0.006115,    0.002990,    0.001612}, {  -9.510131,   -2.192322,    0.004048}, {  -0.405579,   -0.002213,   -1.251276}, {   0.979750,    4.871056,    0.511795}, {  -7.455205,  -18.262165,    8.697372},
			{   0.029479,    7.104953,    0.686619}, {  -6.293046,    5.389445,   -0.102844}, {  -8.355569,  -17.249877,    8.210785}, {   0.002929,    0.004668,    7.981019}, {   7.558327,   29.392057,   -0.091996}, {  -8.115608,   -0.138794,    0.000553}, {   0.002679,    0.003634,    0.001949}, { -16.160846,  -11.211977,    0.038431},
			{   0.002094,    0.004765,   13.644263}, {   3.064445,    0.251545,   -0.587345}, {   3.183571,   -0.015869,    0.009035}, {   1.183925,    0.004569,   -0.002051}, {  -0.009521,    0.007689,   -0.000125}, {   0.006403,   -0.001439,    0.000022}, {   1.128314,   -0.304347,   -0.010679}, {   0.001910,    0.006103,    0.009277},
			{   2.498939,    0.004954,   -0.767485}, { -38.618408,    0.080687,    0.500890}, {   0.373358,   -4.370173,    0.368983}, {   2.953928,    1.552762,    0.145098}, {  -4.643187,    0.108459,   -0.315851}, {   0.007555,    0.003195,    0.003778}, {  -0.446218,    1.124328,    1.489961}, {   0.004581,   -0.014526,    0.001842},
			{  -5.403263,   -3.185729,   -2.778666}, {  -6.274300,   -0.260780,   -0.163617}, {   0.003957,    0.004896,    0.007575}, {   0.001128,    0.000368,    0.000176}, {  -0.012633,   -0.003967,   -0.000134}, {   0.007567,    0.003173,    0.421510}, {   0.019845,   11.123107,    0.848294}, {   0.006606,    0.005733,   -0.311522},
			{   0.002379,    0.059997,    0.000000}, {  -0.003722,   17.485607,    3.702207}, {   0.146402,   -0.502309,    5.026753}, {  -0.126708,    0.622192,    0.203013}, {   0.005737,   -7.684143,    0.730446}, {  -0.096923,   -0.001282,    0.004408}, {   0.005638,    0.006134,    0.003148}, {   0.002472,    0.002950,    0.007548},
			{  -0.108800,    0.006777,   -0.081625}, {   0.005754,    0.003625,    0.007646}, {   0.007385,    0.006591,    0.005950}, { -15.065696,   13.913549,    6.448303}, {  -4.709675,    1.865048,    0.107073}, {  -2.848182,    2.307940,    2.618287}, {   0.357084,    0.005123,    7.855855}, {   0.609616,    0.484243,    0.000821},
			{   0.003092,    0.004174,   11.388498}, {   0.003092,    0.004174,   11.388498}, {   0.000146,   -0.000174,   -0.000001}, {   0.000243,    0.004127,    0.002557}, { -29.392486,   -0.371886,    0.016263}, { -11.421707,    0.551303,    0.006302}, {   0.006759,  -11.196823,    0.000699}, {   0.004279,    0.002113,    0.007770},
			{   0.002888,    0.007278,    0.002798}, { -12.002265,   -2.416167,    0.007209}, {  -0.335476,    0.043427,    0.001004}, { -10.816402,    0.440528,    0.007664}, {  -0.012794,    0.000167,    0.004863}, {   0.004691,    0.559780,    0.002562}, {   0.004081,    0.002876,   -0.582709}, { -30.731212,    9.860309,    0.002794},
			{   0.007699,    0.001294,    0.005938}, {  -0.018264,   -0.000487,    0.087940}, {  -0.096923,   -0.001282,    0.004408}, {   0.005638,    0.006134,    0.003148}, {   0.002376,    0.006579,    0.005065}, {   0.007689,    0.006957,    0.943715}, {  -3.813182,    6.956726,    0.021142}, {   0.004027,    0.005615,    0.007567},
			{  -0.059386,   -0.007853,   -0.008372}, {   0.004149,    0.005493,    0.001558}, {  -0.031128,    0.049561,    0.000578}, {  -0.031128,    0.049561,    0.000578}, {   0.002605,    0.003836,   -0.197026}, {   0.759765,    1.786010,   -0.962224}, {  -8.470329,    0.200558,   -5.469645}, {   0.004517,   -0.212855,    0.004443},
			{   0.824774,    0.003990,    0.001226}, {   0.004517,   -0.212855,    0.004443}, {   0.824774,    0.003990,    0.001226}, {   0.000243,    0.004127,    0.002557}, {   0.007428,    0.002187,    0.000698}, {  -0.018921,    0.034423,    9.075490}, {   5.347736,    2.577786,    3.828099}, {   0.004009,    0.005737,    0.000843},
			{   0.000146,   -0.000174,   -0.000001}, {   0.006628,    0.006893,    0.003679}, {   0.007699,    0.001294,    0.005938}, {  -0.011413,    0.001159,   -0.033757}, {   4.989685,    0.005018,    0.002596}, {   4.989685,    0.005018,    0.002596}, {   0.001252,    0.000731,    0.002106}, {   0.008747,    0.014709,    0.008748},
			{   0.002564,    0.002418,    0.000245}, {   0.002135,    0.003478,    0.004544}, {   0.002135,    0.003478,    0.004544}, {   1.150856,    3.832241,   -1.439584}, {   0.002522,    0.007197,    0.005822}, {   3.348388,   -0.682617,   -0.875994}, {  -0.441992,   -0.625953,   -0.633912}, {  -2.525023,    0.002715,    0.001955},
			{  -2.525023,    0.002715,    0.001955}, {   0.007689,    0.006134,    0.009692}, {   0.810244,    9.360755,    0.005367}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000453,    1.877014,    0.007579},
			{   0.003417,   -7.720032,   -0.283957}, {  18.520786,   34.554016,   -0.999477}, {   0.003234,    0.018616,   -0.936127}, {   0.001891,   -1.187011,    2.289082}, {  31.357442,    0.147698,    0.001914}, {   6.897766,   -0.029906,   -0.001056}, {   0.000701,    0.003844,    0.003799}, {  -0.021976,    0.022252,    0.009511},
			{   1.610239,    0.111216,    0.766013}, {   0.005721,    0.005859,    0.000050}, {   8.131942,    0.003905,   -0.214000}, {   0.018813,    0.031569,    0.035813}, {  -4.832396,   -4.097229,   -1.551817}, {   0.005344,    0.202358,   -0.993173}, { -28.839357,   -0.000308,   -9.531677}, {  -3.060883,    2.814728,   -0.860188},
			{  -0.076224,    0.638427,   -1.196599}, {   0.003295,    0.000000,    0.001637}, {   0.509154,   -4.228209,   -1.917683}, {   0.002013,    0.006453,    0.000311}, {   0.106795,    0.004333,    0.002425}, {   0.000365,    0.000884,   -0.035923}, {   0.005493,    0.001311,   -0.576452}, {  -8.542175,    3.737365,   -0.000544},
			{   0.001525,    0.001342,   -0.201063}, {   0.003202,    0.056363,    1.949973}, {   0.006957,    0.009033,   -0.441969}, {   0.011382,    0.243224,   -0.097185}, {   0.006113,    0.007178,    0.006405}, {  -3.072678,    0.000000,    5.384090}, {   0.001704,    0.007459,    0.003063}, {  -0.022857,    1.234612,    0.005822},
			{   0.915802,    0.263000,   -0.111931}, {   0.006934,   -0.004449,    0.004155}, {   0.201684,    0.090738,   -0.087021}, {  -8.444519,   -4.230590,    1.217458}, {  17.800365,  -18.434297,   40.065727}, {   3.235759,   15.466808,    0.075638}, {   1.755187,   -1.605097,    2.983673}, {  -0.269652,    4.103577,    0.376464},
			{   0.002257,   -4.193806,    0.007352}, {   0.002074,    0.001800,    0.007664}, {  -0.098693,    0.001769,    0.002419}, {   0.003539,    0.000030,    0.000484}, {   0.003661,    0.006225,   -0.062024}, {   0.004577,   -0.246460,   -0.053068}, {  -0.195006,    0.005431,    0.536296}, {   0.001952,   -0.173279,    0.002420},
			{   0.005309,    1.091909,   -0.999493}, {   0.004517,    0.003325,    0.007344}, {   0.974669,    0.002349,    0.001510}, {   0.004242,   -7.205565,   -0.555932}, {   0.007232,    0.000548,    0.000614}, {  -0.553252,    0.004577,    0.038437}, {   0.044342,   -0.011292,    0.121706}, {   1.062682,    0.003112,    0.040247},
			{  -0.402271,  -18.592086,   -2.165183}, {   0.034758,    0.004468,    0.001226}, {   0.004600,    0.002444,    0.255428}, {  -0.527114,  -16.648530,   19.658170}, {   0.004902,    0.000079,    0.004046}, {  -0.001018,   -0.004945,    0.002105}, {   0.007232,    0.004695,    0.002503}, {   3.575995,    0.003812,   -2.460824},
			{   1.075917,   -0.125719,   -1.356140}, {   0.003790,    0.007282,    0.005900}, {   9.982116,    0.007629,    1.528555}, {   0.001311,    0.005382,    3.771228}, {  -0.194041,   -0.372678,   -0.305929}, {   0.328022,   -0.449254,    3.821027}, {   0.005005,   -0.000153,    0.000623}, {   0.005400,    0.006353,    0.003875},
			{   0.007590,    0.004879,    0.004848}, {   0.002288,    0.003722,    0.001078}, {   0.118010,    0.045837,    0.000765}, {   0.003372,   -0.004472,    0.003471}, {  -0.586696,    6.615800,    1.446248}, {  -0.006308,    2.878443,    0.005020}, {   4.331510,   -0.082092,    0.628585}, {   0.136002,    4.598862,    0.330083},
			{  -0.098674,   -0.181703,    0.005599}, {   0.014844,    0.001533,    0.068970}, { -18.073444,    2.200122,   -0.976056}, {  -0.093872,    0.002296,   -0.002222}, {  -7.030271,    4.308404,    1.512977}, {   1.025745,   -1.419469,    3.537300}, {   0.001368,    0.001311,    0.003867}, {   0.004166,    0.007542,    0.005115},
			{  -0.868731,    0.006246,    0.175828}, {   0.003661,    0.000731,    0.003716}, {   0.004699,    0.007385,   -1.655158}, {   0.004364,   -0.630859,    0.002682}, {   0.004242,    0.657166,    0.169246}, {   0.001189,   -0.000060,    0.004244}, {   0.001098,    0.000609,    0.014936}, {  -0.233642,   -0.127562,    0.926998},
			{   0.007567,    0.003783,    0.000014}, {   0.032471,   -0.840820,    0.004385}, {   0.006713,    0.000792,   -0.768463}, {   0.002242,    0.005733,    0.007522}, {   0.005553,    0.222472,    0.004265}, {   0.007079,    0.003051,    0.100965}, {   0.105713,   -0.783690,   -0.090281}, {   0.006134,    0.007201,    0.001112},
			{   3.114409,    0.160095,   -0.810481}, {   0.005005,    0.002990,   -0.464489}, {   1.604889,    9.906810,    0.093492}, {  -0.032104,    0.004639,    4.115781}, {   0.005382,    0.000805,    0.186968}, {   0.007468,   -0.002949,   -0.076339}, {  -3.942601,   -0.000418,    0.009207}, {   0.446007,    0.005504,    0.352133},
			{   4.870468,   -0.039733,   -2.243830}, {  -0.033663,   -2.562026,   -2.225204}, {   0.001564,    0.001469,    0.000502}, {   0.001098,   -1.896234,    3.955924}, {  -2.017035,   -0.097190,   -2.111073}, {   0.122883,    2.778165,   -2.379674}, {  -0.485009,   -4.172308,   -2.653732}, {   0.001403,    0.003844,    0.004385},
			{   0.002242,    0.005733,    0.007522}, {   0.003661,    0.000731,    0.003716}, {   0.002257,   -4.193806,    0.007352}, {   0.002074,    0.001800,    0.007664}, {   0.032471,   -0.840820,    0.004385}, {   0.007567,    0.003783,    0.000014}, {  -0.098693,    0.001769,    0.002419}, {   0.105713,   -0.783690,   -0.090281},
			{   0.006713,    0.000792,   -0.768463}, {   0.005309,    1.091909,   -0.999493}, {   0.004517,    0.003325,    0.007344}, {   0.010071,    0.002923,   -0.058747}, {   0.011901,    0.012412,    0.009696}, {   0.000976,    0.001342,    0.009537}, {   0.005555,    0.004949,   -0.379848}, {  -8.542175,    3.737365,   -0.000544},
			{  -0.868731,    0.006246,    0.175828}, {   0.003790,    0.007282,    0.005900}, {   0.201684,    0.090738,   -0.087021}, {   3.235759,   15.466808,    0.075638}, {   0.007813,    0.002440,    0.000821}, {   0.005371,    0.001189,    0.004563}, {   0.151848,    0.214221,    6.049935}, {   0.004639,    0.005797,    0.005156},
			{   0.000944,    0.005400,    0.000529}, {   0.000944,    0.005400,    0.000529}, {  -0.269652,    4.103577,    0.376464}, {   0.005371,    0.001189,    0.004563}, {   0.004600,    0.002444,    0.255428}, {   0.005228,    0.003045,    0.003452}, {   0.005890,    0.002369,    0.005131}, {   0.006597,    0.007462,    0.002530},
			{   0.002280,   -0.006653,    0.011985}, {   0.003112,    0.002562,    0.003712}, {  11.420982,  -10.221619,    6.130386}, {   0.003112,    0.000304,    1.089172}, {  -1.032943,    0.003173,   -0.006525}, {   0.004271,   23.837707,   -0.114657}, {   0.006744,    0.462523,   -1.121925}, {   0.004215,  -10.014648,    0.007416},
			{   0.031186,    0.322815,    7.264965}, {  -3.944580,    0.001464,   -0.613704}, {   0.000683,    0.002456,    0.002286}, {  -0.001018,   -0.004945,    0.002105}, {   0.000944,    0.002325,    0.005470}, { -28.839357,   -0.000308,   -9.531677}, {   0.003718,    0.005752,    0.003717}, {   0.004395,    0.001708,   -0.265204},
			{  -5.366057,   -0.482482,   -1.683357}, {   0.007311,    0.002116,    0.002231}, {   0.006374,    0.001348,    0.004021}, {   0.002593,    0.000266,   -0.996249}, {   0.000518,    0.007385,    0.013615}, {   0.061096,    0.000425,    0.972804}, {   0.002993,    0.002929,    0.006180}, {   0.002993,    0.002929,    0.006180},
			{   0.000683,    0.002456,    0.002286}, {  -1.558841,    0.004726,   -1.460154}, {   0.002379,    0.002031,    0.003114}, {  -1.558841,    0.004726,   -1.460154}, {   0.002379,    0.002031,    0.003114}, {   0.045405,    0.006072,    0.004313}, {  -0.000118,    0.080895,    0.003875}, {   0.004670,    0.004602,    0.004087},
			{  54.500244,   15.303791,    1.225487}, {   0.004670,    0.004602,    0.004087}, {   0.001585,    0.001164,    0.000478}, {   0.001585,    0.001164,    0.000478}, {   0.001159,    0.000493,    0.000921}, {   0.003661,    0.000731,    0.001087}, {   0.001159,    0.000493,    0.000921}, {   0.005344,    0.202358,   -0.993173},
			{   0.007025,    0.005989,    0.006440}, {   0.007025,    0.005989,    0.006440}, {   0.005228,    0.003045,    0.003452}, {   0.004271,   23.837707,   -0.114657}, {   0.001952,   -0.173279,    0.002420}, {  -0.233642,   -0.127562,    0.926998}, {  -0.195006,    0.005431,    0.536296}, {   0.003112,    0.000304,    1.089172},
			{   3.114409,    0.160095,   -0.810481}, {   0.001891,   -1.187011,    2.289082}, {   0.005553,    0.222472,    0.004265}, {   0.003661,    0.006225,   -0.062024}, {   0.003539,    0.000030,    0.000484}, {   0.974669,    0.002349,    0.001510}, {   0.006134,    0.007201,    0.001112}, {   0.004242,   -7.205565,   -0.555932},
			{   0.007079,    0.003051,    0.100965}, {   0.007232,    0.000548,    0.000614}, {  -0.553252,    0.004577,    0.038437}, {   0.044342,   -0.011292,    0.121706}, {   0.000453,    1.877014,    0.007579}, {   1.062682,    0.003112,    0.040247}, {   0.004577,   -0.246460,   -0.053068}, {   0.004699,    0.007385,   -1.655158},
			{  -1.032943,    0.003173,   -0.006525}, {   0.004364,   -0.630859,    0.002682}, {   0.004242,    0.657166,    0.169246}, {   0.006744,    0.462523,   -1.121925}, {   0.001098,    0.000609,    0.014936}, {   0.001189,   -0.000060,    0.004244}, {   0.011901,    0.012412,    0.009696}, {   0.010071,    0.002923,   -0.058747},
			{   0.003417,   -7.720032,   -0.283957}, {   0.005382,    0.000805,    0.186968}, {  31.357442,    0.147698,    0.001914}, {   1.604889,    9.906810,    0.093492}, {  -0.527114,  -16.648530,   19.658170}, {   0.005005,    0.002990,   -0.464489}, {   0.011382,    0.243224,   -0.097185}, {   0.006934,   -0.004449,    0.004155},
			{  -0.093872,    0.002296,   -0.002222}, {   1.075917,   -0.125719,   -1.356140}, {   0.002013,    0.006453,    0.000311}, {   0.003295,    0.000000,    0.001637}, {   0.106795,    0.004333,    0.002425}, {  -0.076224,    0.638427,   -1.196599}, {   0.001098,   -1.896234,    3.955924}, {   0.006957,    0.009033,   -0.441969},
			{   0.034758,    0.004468,    0.001226}, { -18.073444,    2.200122,   -0.976056}, {   0.003202,    0.056363,    1.949973}, {  -0.402271,  -18.592086,   -2.165183}, {   4.331510,   -0.082092,    0.628585}, {   0.446007,    0.005504,    0.352133}, {   0.328022,   -0.449254,    3.821027}, {   0.007468,   -0.002949,   -0.076339},
			{   0.000365,    0.000884,   -0.035923}, {   0.005493,    0.001311,   -0.576452}, {   0.001525,    0.001342,   -0.201063}, {   6.897766,   -0.029906,   -0.001056}, {  -8.444519,   -4.230590,    1.217458}, {  17.800365,  -18.434297,   40.065727}, {   0.001704,    0.007459,    0.003063}, {   0.001311,    0.005382,    3.771228},
			{  -3.072678,    0.000000,    5.384090}, {   0.001403,    0.003844,    0.004385}, {   0.005005,   -0.000153,    0.000623}, {   0.509154,   -4.228209,   -1.917683}, {   3.575995,    0.003812,   -2.460824}, {  -0.006308,    2.878443,    0.005020}, {  -4.832396,   -4.097229,   -1.551817}, {   0.003112,    0.002562,    0.003712},
			{  -3.060883,    2.814728,   -0.860188}, {   0.003718,    0.005752,    0.003717}, {   0.004395,    0.001708,   -0.265204}, {   0.006374,    0.001348,    0.004021}, {   0.002593,    0.000266,   -0.996249}, {   0.005400,    0.006353,    0.003875}, {  -0.000118,    0.080895,    0.003875}, {   0.006113,    0.007178,    0.006405},
			{  -3.944580,    0.001464,   -0.613704}, {  18.520786,   34.554016,   -0.999477}, {   0.003234,    0.018616,   -0.936127}, {  -0.022857,    1.234612,    0.005822}, {   0.915802,    0.263000,   -0.111931}, {   0.004215,  -10.014648,    0.007416}, {   0.031186,    0.322815,    7.264965}, {   0.000701,    0.003844,    0.003799},
			{  -0.021976,    0.022252,    0.009511}, {  -0.194041,   -0.372678,   -0.305929}, {   0.004466,    0.007400,    0.001067}, {   0.002357,    0.000457,   -0.518060}, {   0.002357,    0.000457,   -0.518060}, {   0.004466,    0.007400,    0.001067}, {   0.005890,    0.004089,    0.002644}, {   0.007499,    0.007244,    0.005286},
			{   0.006225,   -0.000060,    0.007431}, {   0.002087,    0.003467,    0.003123}, {   0.007567,    0.002094,    0.001628}, {   0.000487,    0.002440,    0.007280}, {   0.007567,    0.002094,    0.001628}, {   0.000487,    0.002440,    0.007280}, { -14.184667,   -9.259662,   -5.422257}, {   0.003649,   -0.124273,    0.753511},
			{   0.003649,   -0.124273,    0.753511}, {   6.650231,    8.336090,    0.092955}, {  -3.942601,   -0.000418,    0.009207}, {   0.001564,    0.001469,    0.000502}, {   0.151848,    0.214221,    6.049935}, {   0.005555,    0.004949,   -0.379848}, {   0.004943,    0.001464,   -2.495908}, {   0.001647,    0.000853,   -2.415949},
			{   0.001647,    0.000853,   -2.415949}, {   0.004943,    0.001464,   -2.495908}, {  11.420982,  -10.221619,    6.130386}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000716,    0.003051,    0.009074}, {  -0.491057,   -0.476134,    0.001383}, {  -0.075989,  -15.385803,   -0.004929}, {  -0.262816,    0.007629,   -0.645507}, {   0.279062,    0.007141,   -1.102939},
			{  -0.186707,    0.002562,    0.002780}, {   0.001861,   -0.617523,   -0.351601}, {   0.005675,    0.000304,    0.000938}, {   0.005218,    0.005737,    0.006461}, {  -0.083374,    0.002501,   -0.001352}, {   0.007416,    0.001098,    0.003971}, {   0.006897,    0.007019,    0.003631}, {   2.298737,   -3.928649,   -0.165039},
			{   2.412978,   -2.014209,    0.264266}, { -10.299123,   -4.738285,    0.000203}, {   9.315041,   15.465162,   -0.005743}, {   0.325426,    0.210998,    0.196551}, {  -0.338844,   -0.043979,    0.005971}, {  -0.578796,   -4.327403,   -0.098289}, {   0.002318,    0.000571,    0.001647}, {   0.004517,    0.004707,    0.003251},
			{  -0.186807,    0.016194,   -0.011935}, {  -0.000224,    0.003103,    0.025500}, {   0.003790,    0.001079,    0.006180}, {  -1.254546,    0.636901,   -0.370714}, {  -0.333804,    8.291164,    0.002511}, {  -0.009033,    0.002440,   -0.018076}, {   1.102131,    6.180117,    0.610742}, {   5.737360,    0.079851,    3.711370},
			{   0.007567,   -2.361145,   -0.018206}, {   0.010650,   -5.614929,   -3.584511}, {   0.002229,    0.001976,    0.001920}, {  -0.578796,   -4.327403,   -0.098289}, {  -0.338844,   -0.043979,    0.005971}, {  -0.333804,    8.291164,    0.002511}, {  -0.009033,    0.002440,   -0.018076}, {   5.737360,    0.079851,    3.711370},
			{   2.298737,   -3.928649,   -0.165039}, {  -0.491057,   -0.476134,    0.001383}, {  -0.262816,    0.007629,   -0.645507}, {  -0.075989,  -15.385803,   -0.004929}, {  -0.078969,   -0.009606,   -0.179741}, {   0.279062,    0.007141,   -1.102939}, {  -0.186707,    0.002562,    0.002780}, {   0.001861,   -0.617523,   -0.351601},
			{   0.004517,    0.004707,    0.003251}, {   0.075615,   -0.075011,    0.053444}, {   0.010650,   -5.614929,   -3.584511}, {   0.007567,   -2.361145,   -0.018206}, {   0.005675,    0.000304,    0.000938}, {  -0.251385,   -0.076390,    0.924336}, {   0.000426,    0.386536,   -1.064579}, {   0.047864,    0.033202,   -1.097385},
			{   5.065465,    0.836766,    0.002433}, {   0.047864,    0.033202,   -1.097385}, {   5.065465,    0.836766,    0.002433}, {   0.003790,    0.001079,    0.006180}, {  -0.000224,    0.003103,    0.025500}, {  -1.254546,    0.636901,   -0.370714}, { -21.497957,   10.521850,   -2.607789}, {   1.114933,    6.592232,    1.515967},
			{  -0.251385,   -0.076390,    0.924336}, {   1.114933,    6.592232,    1.515967}, {  -0.078969,   -0.009606,   -0.179741}, {   0.001051,    0.001861,   -0.008867}, {   0.003126,    0.001052,    0.000693}, {   0.002557,    0.005102,   -0.958949}, {  -0.708275,    0.004945,    0.001259}, {   0.004906,    0.004073,   -0.409788},
			{   0.002652,    0.001568,   -0.082021}, {   0.004906,    0.004073,   -0.409788}, {  -0.708275,    0.004945,    0.001259}, {   0.003126,    0.001052,    0.000693}, {   0.002557,    0.005102,   -0.958949}, {   0.001051,    0.001861,   -0.008867}, {   8.042247,   10.861282,   -0.143478}, {   0.047088,    0.017150,    0.072911},
			{   0.050994,    0.037902,    0.064180}, {   0.060851,   -0.058472,   -0.009356}, {   0.000487,   -1.204650,    0.000915}, {   0.000121,    0.003112,    0.004230}, {   0.007133,    0.003722,    0.002044}, {   0.005675,    0.002196,   -0.074758}, {   0.001159,   -0.000060,    0.000146}, {   0.004639,    0.000243,    0.004230},
			{   0.004300,    0.004395,    0.005557}, {  -0.000701,    0.007323,    0.000184}, {   0.054168,   -0.067138,   -0.491317}, {   0.075615,   -0.075011,    0.053444}, {   0.052643,    0.002562,   -0.474566}, {   0.907898,    0.005797,    0.001696}, {   0.007876,    0.000304,    0.007536}, {   0.027527,    0.005675,   -0.009700},
			{   0.000976,   -0.011047,    0.110096}, {   0.005797,   -0.669188,   -0.274637}, {   4.911441,   -2.797030,  -11.682718}, {   2.412978,   -2.014209,    0.264266}, {  -0.002309,   -0.636810,    0.004292}, {   0.007050,   -0.189848,    0.000061}, {   0.002562,    0.179449,   -0.199294}, {   0.289819,    0.252602,    0.001811},
			{  -0.272908,   -0.839776,    0.571946}, {   0.006703,    0.204080,   -0.202083}, {   0.002662,    0.002376,    0.001624}, {  -0.002309,   -0.636810,    0.004292}, {   0.002662,    0.002376,    0.001624}, {  -0.272908,   -0.839776,    0.571946}, {   0.289819,    0.252602,    0.001811}, {   0.006703,    0.204080,   -0.202083},
			{ -21.497957,   10.521850,   -2.607789}, {  -0.002103,    0.004466,    0.005741}, {  -0.002103,    0.004466,    0.005741}, {   0.002562,    0.179449,   -0.199294}, {   0.002824,    0.188087,   -0.313403}, {  -0.000499,    0.004753,    0.006066}, {  -0.000499,    0.004753,    0.006066}, {   0.002937,    0.005171,   -0.344325},
			{   0.006233,    0.005938,   -0.523393}, {   0.002937,    0.005171,   -0.344325}, {   0.002652,    0.001568,   -0.082021}, {   0.002824,    0.188087,   -0.313403}, {   0.006233,    0.005938,   -0.523393}, {   0.006262,    0.007003,    0.000453}, {   0.001485,    0.001126,    0.004226}, {   0.003555,    0.005874,   -0.190117},
			{   0.001469,   -0.150776,   -0.472602}, {   0.003555,    0.005874,   -0.190117}, {   0.006262,    0.007003,    0.000453}, {   0.001485,    0.001126,    0.004226}, {   0.001469,   -0.150776,   -0.472602}, {  10.354007,    0.005030,   -0.111529}, {   0.052643,    0.002562,   -0.474566}, {   0.047088,    0.017150,    0.072911},
			{   0.050994,    0.037902,    0.064180}, {   0.060851,   -0.058472,   -0.009356}, {   0.907898,    0.005797,    0.001696}, {   0.000716,    0.003051,    0.009074}, {   0.027527,    0.005675,   -0.009700}, {   0.000976,   -0.011047,    0.110096}, {   0.007876,    0.000304,    0.007536}, {   0.005797,   -0.669188,   -0.274637},
			{   0.000487,   -1.204650,    0.000915}, {   0.002318,    0.000571,    0.001647}, {   0.000121,    0.003112,    0.004230}, {   0.001159,   -0.000060,    0.000146}, {   0.005675,    0.002196,   -0.074758}, {   0.007133,    0.003722,    0.002044}, {   0.054168,   -0.067138,   -0.491317}, {   0.004639,    0.000243,    0.004230},
			{   0.004300,    0.004395,    0.005557}, {  -0.000701,    0.007323,    0.000184}, {   4.079964,   -7.668611,   -1.034435}, {   2.964313,    0.004852,   -0.018439}, {   0.002460,   -4.829582,    1.796283}, {   0.004556,    0.318062,    2.268731}, {   0.002460,   -4.829582,    1.796283}, {   0.004556,    0.318062,    2.268731},
			{   0.007550,    0.003539,    0.001067}, {   0.004600,   -0.905017,    0.001429}, {   0.007617,    0.005973,    2.423046}, {  23.135822,    0.005249,   -1.087793}, {   0.003779,    0.002717,    0.005160}, {   2.964313,    0.004852,   -0.018439}, {   4.079964,   -7.668611,   -1.034435}, {   0.007207,    0.010147,    0.003360},
			{   0.007207,    0.010147,    0.003360}, {   0.000624,    0.007031,    0.002971}, {  10.354007,    0.005030,   -0.111529}, {   0.065277,   11.353473,   -1.547772}, {   0.071166,   -9.812147,    0.177048}, {   0.002328,    0.006670,   -0.037122}, {  -0.934733,    0.001800,    0.004251}, {   0.065277,   11.353473,   -1.547772},
			{   0.002328,    0.006670,   -0.037122}, { -56.568462,    7.806015,    0.302837}, { -10.279145,   -0.398144,    1.242653}, {   0.001990,    0.005107,    0.000765}, {   5.061872,    0.842348,    0.002433}, {  -0.934733,    0.001800,    0.004251}, {   0.000762,    0.003142,    0.000410}, {   0.001990,    0.005107,    0.000765},
			{   5.061872,    0.842348,    0.002433}, {   0.000426,    0.386536,   -1.064579}, {   0.003905,    0.003844,    0.007805}, {  -0.245396,   -0.042309,    1.750097}, {  -0.067001,    0.175327,    1.702332}, {  -0.330821,    0.132641,    1.654672}, {   1.212273,   -0.070292,    1.647886}, {   0.002130,    0.006281,    0.006649},
			{   0.002130,    0.006281,    0.006649}, {   0.000853,   -0.000566,   -0.656275}, {   0.000853,   -0.000566,   -0.656275}, {   0.000986,    0.004786,   -0.333245}, {   0.009300,    0.004432,   -0.392863}, {   1.260697,    0.002419,    0.004403}, {  -0.006684,   -1.685261,    0.006787}, {   0.000792,    0.001769,    0.007162},
			{  -2.303352,    9.884792,   -5.983094}, {   0.677609,    0.005080,    0.003682}, {   1.830230,    0.003722,    0.003682}, {   1.952322,   38.910999,   -5.983094}, {   0.002105,    0.005706,    0.000647}, {  -3.924339,  -19.380466,    0.731409}, {   0.000792,    0.001769,    0.007162}, {   1.952322,   38.910999,   -5.983094},
			{   0.002105,    0.005706,    0.000647}, {   1.830230,    0.003722,    0.003682}, {   0.677609,    0.005080,    0.003682}, {   0.009300,    0.004432,   -0.392863}, {   0.000986,    0.004786,   -0.333245}, {  -2.303352,    9.884792,   -5.983094}, {   1.260697,    0.002419,    0.004403}, {  -0.006684,   -1.685261,    0.006787},
			{   0.003905,    0.003844,    0.007805}, {  -0.245396,   -0.042309,    1.750097}, {  -0.067001,    0.175327,    1.702332}, {  -0.330821,    0.132641,    1.654672}, {   1.212273,   -0.070292,    1.647886}, {   0.006897,    0.007019,    0.003631}, {   0.000000,    0.000000,    0.000000}, {   4.911441,   -2.797030,  -11.682718},
			{   0.007050,   -0.189848,    0.000061}, {   0.000624,    0.007031,    0.002971}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000762,    0.000130,    0.134948}, {   0.003043,    0.001106,    0.001033}, {   0.047207,    0.007934,    0.005803}, {   0.006852,    0.002379,    0.068494}, {   0.003460,    0.004914,   -0.033211}, {   0.003352,    0.004877,    0.004798}, {   0.006622,    0.002204,    0.004457}, {  -0.405725,   -0.706309,    0.265495},
			{   0.006577,    0.007701,    0.003453}, {   0.004929,    0.007681,    0.004958}, {  10.393779,   -1.734814,    1.374680}, {   0.006775,    0.001281,    0.005148}, {   0.003704,    0.007120,    0.007691}, {   0.002274,    0.002853,    0.001807}, {  -3.149497,    0.000739,   -0.086158}, {   0.006860,    0.006142,    0.001790},
			{   0.001555,    0.006111,    0.000335}, {   0.003616,    0.002868,    0.001277}, {  -0.001888,    0.000638,    0.001307}, {  -0.002470,   -0.006810,    0.000936}, {   0.005783,    0.002044,  -11.280084}, {   0.007385,    0.005797,   -0.687824}, {   0.002440,    0.004517,   -0.000125}, {  12.659275,   -0.545653,   -0.609951},
			{   1.258972,    0.639796,    0.024598}, {   0.003539,    0.000365,   -0.014685}, {   0.002746,    0.003967,    0.004189}, {   0.005202,    0.004333,    0.003270}, {   0.007079,    0.002318,    0.000874}, {   0.001494,    0.000182,    0.005195}, {   0.000747,   -0.009704,    0.020328}, {   0.033585,    0.034363,    0.049183},
			{  -0.000930,    0.149474,   -0.326739}, {   0.003470,    0.003112,   -0.519776}, {   0.002349,    0.006347,    0.006719}, {   0.005379,    0.007567,    0.002702}, {  -0.340878,    0.294108,   -0.539025}, {   0.047515,   -0.015736,   -0.058979}, {  -7.519849,    0.825565,    0.695447}, {   3.078197,   -0.399848,   -0.585292},
			{  13.627239,   -3.264275,   -0.372765}, {   0.005925,   -0.057537,    0.066894}, {   0.002562,    0.006835,    0.003576}, {   2.001786,    5.256877,    0.236186}, {  -1.798766,    0.003356,    0.006976}, {  -3.529090,   -6.426783,   -0.612551}, { -13.389186,   -6.852413,   -0.056880}, {  -3.420394,    1.545367,   -0.013821},
			{   0.006370,    0.004900,   -0.894279}, {   0.007476,    0.000609,    0.007174}, {   0.253769,    0.000960,    0.000478}, {   0.001098,   -3.236288,    0.017815}, {  -0.153861,    0.003417,    0.007255}, {   0.091628,   -0.050110,    0.028506}, {   0.007216,    0.001811,   -0.750815}, {   0.007216,    0.001811,   -0.750815},
			{   0.006965,   -0.139232,    0.003190}, {   0.000065,    0.005553,    0.001677}, {   0.000422,    0.260625,    0.003894}, {   0.006965,   -0.139232,    0.003190}, {   0.006804,    0.001708,    0.021750}, {   0.003631,    0.004089,   -0.575905}, {   0.005446,    0.002248,    0.000380}, {   0.002471,    0.002746,    1.783722},
			{   0.005028,    0.007011,    0.003319}, {   4.724343,   -1.629799,    0.094787}, {   0.000422,    0.260625,    0.003894}, {   0.003220,   -0.036559,    0.004546}, {   0.000000,    0.000000,    0.000000}, {   0.003181,    0.003325,    0.006953}, {   0.000701,    0.000430,    0.002440}, {   0.004641,    0.005903,    0.000299},
			{   0.000811,    0.007220,    0.003258}, {   0.007065,   -0.000027,    2.571069}, {   0.003681,    0.006949,    0.001765}, {   0.006943,    0.004616,    0.005392}, {   0.004211,    0.003478,  -10.772583}, {  -0.975174,    0.201038,    0.433492}, {   0.003681,    0.006949,    0.001765}, {   0.006943,    0.004616,    0.005392},
			{  -3.420394,    1.545367,   -0.013821}, { -13.389186,   -6.852413,   -0.056880}, {   0.001845,    2.791930,   -0.136970}, {  -8.692077,    0.003487,   -0.207556}, {   0.007143,    0.003844,    0.003025}, {   0.007143,    0.003844,    0.003025}, {   0.004776,    0.004883,   -0.010758}, {   0.004776,    0.004883,   -0.010758},
			{   0.000468,    0.002419,   -0.002698}, {   0.002670,    0.002459,    0.003272}, {   0.004968,    0.005336,    0.006891}, {   0.003926,    0.001886,   -0.038444}, { -12.816102,  -18.043592,    0.473057}, {   0.004073,    0.006653,    0.005055}, {   0.000468,    0.002419,   -0.002698}, {   0.004073,    0.006653,    0.005055},
			{   0.002562,    0.006835,    0.003576}, {   0.253769,    0.000960,    0.000478}, {   0.007476,    0.000609,    0.007174}, {   0.002440,    0.004517,   -0.000125}, {  -1.798766,    0.003356,    0.006976}, {   1.258972,    0.639796,    0.024598}, {   0.001098,   -3.236288,    0.017815}, {  12.659275,   -0.545653,   -0.609951},
			{   2.001786,    5.256877,    0.236186}, {  -5.594881,   -1.479050,    8.438484}, {   0.006366,    0.005317,   -0.362843}, {  -0.001025,    0.007623,    0.006345}, {   5.295832,   -0.747475,    0.001950}, {   0.004676,    0.003112,    0.004567}, {   0.000341,    0.003222,    0.007679}, {   0.068190,   -0.032850,    0.048328},
			{   0.000341,    0.003222,    0.007679}, { -15.897332,   -7.469439,    5.362198}, {   0.068190,   -0.032850,    0.048328}, {   5.295832,   -0.747475,    0.001950}, {   0.004676,    0.003112,    0.004567}, {   0.873435,    3.161989,    0.839423}, {   0.002379,    0.004360,   -0.598873}, {   0.735055,   -0.902127,    0.464926},
			{  -0.001250,    0.001899,    0.004201}, {   0.002379,    0.004360,   -0.598873}, {   0.003470,    0.003112,   -0.519776}, {  22.989187,   -7.726579,    1.385357}, {  -0.421909,    0.002582,    0.001523}, {   0.005038,    0.000713,    0.006401}, {   0.455053,    0.005514,    0.002745}, {  -0.884374,    5.133880,    5.638566},
			{   0.047207,    0.007934,    0.005803}, {   0.455053,    0.005514,    0.002745}, {  -0.421909,    0.002582,    0.001523}, {  -0.935100,    2.439241,   -2.865294}, {   0.000690,    0.001673,    0.003779}, {   0.007462,    0.006736,    0.006366}, {  -3.529090,   -6.426783,   -0.612551}, {   0.006860,    0.006142,    0.001790},
			{  -0.533119,  -14.920967,   -0.297369}, {   0.000342,    0.000251,   -5.873919}, {  -0.533119,  -14.920967,   -0.297369}, {   0.002274,    0.002853,    0.001807}, {   0.000342,    0.000251,   -5.873919}, {   0.005295,    0.003875,    0.003818}, {   0.003017,    0.004840,    0.002373}, {   0.002349,    0.006347,    0.006719},
			{   0.005379,    0.007567,    0.002702}, {   0.033585,    0.034363,    0.049183}, {   0.000121,    0.001159,   -0.382885}, {   0.000121,    0.001159,   -0.382885}, {   0.005760,    0.006469,    0.007538}, {  -0.340878,    0.294108,   -0.539025}, {   0.001281,  -15.293441,    0.052839}, {   0.004898,    0.004889,    0.003868},
			{  -3.149497,    0.000739,   -0.086158}, {   0.003352,    0.004877,    0.004798}, {   0.003460,    0.004914,   -0.033211}, {   0.006622,    0.002204,    0.004457}, {   0.002339,    0.001088,    0.003279}, {   0.000762,    0.000130,    0.134948}, {   0.005760,    0.006469,    0.007538}, {   0.000747,   -0.009704,    0.020328},
			{   0.001494,    0.000182,    0.005195}, {   0.003616,    0.002868,    0.001277}, {   0.003043,    0.001106,    0.001033}, {   0.005630,    0.003903,   -0.521250}, {   0.000731,    0.003214,    0.002814}, {   0.005630,    0.003903,   -0.521250}, {  -0.000930,    0.149474,   -0.326739}, {   0.003220,   -0.036559,    0.004546},
			{   0.004898,    0.006469,    0.003578}, {   0.004683,    0.002243,   -0.389081}, {   0.006256,    0.002762,   -5.572463}, { -12.327093,   13.504195,    4.743031}, {   0.004898,    0.006469,    0.003578}, {   0.004683,    0.002243,   -0.389081}, {   0.006256,    0.002762,   -5.572463}, {   0.005783,    0.002044,  -11.280084},
			{   0.006577,    0.007701,    0.003453}, {   0.001966,    0.011551,   -0.499648}, {   0.003319,    0.001403,    0.002223}, {   0.004929,    0.007681,    0.004958}, {  -0.002470,   -0.006810,    0.000936}, {   0.002138,    0.005557,    0.007147}, {  -0.005381,    0.010956,    0.004267}, {  -0.001888,    0.000638,    0.001307},
			{   0.006852,    0.002379,    0.068494}, {  -0.005381,    0.010956,    0.004267}, {   0.006854,    0.003677,    0.354759}, {   0.047515,   -0.015736,   -0.058979}, {   0.005925,   -0.057537,    0.066894}, {   0.003539,    0.000365,   -0.014685}, {   0.091628,   -0.050110,    0.028506}, {   0.002746,    0.003967,    0.004189},
			{   0.005202,    0.004333,    0.003270}, {   0.007079,    0.002318,    0.000874}, {   0.006775,    0.001281,    0.005148}, {   0.005446,    0.002248,    0.000380}, {   0.003631,    0.004089,   -0.575905}, {   0.002471,    0.002746,    1.783722}, {  -0.153861,    0.003417,    0.007255}, {   0.003926,    0.001886,   -0.038444},
			{   0.006804,    0.001708,    0.021750}, {   0.004641,    0.005903,    0.000299}, {   0.000065,    0.005553,    0.001677}, {   4.724343,   -1.629799,    0.094787}, {  13.627239,   -3.264275,   -0.372765}, {   3.078197,   -0.399848,   -0.585292}, {  -7.519849,    0.825565,    0.695447}, {   0.002270,    0.005675,    0.000377},
			{  -0.024486,   -0.037597,    0.213751}, {   0.002097,    0.074409,    0.000561}, {  -0.243003,   -0.311089,   -1.852033}, {  -0.243003,   -0.311089,   -1.852033}, {  -0.024486,   -0.037597,    0.213751}, {   0.002270,    0.005675,    0.000377}, {   0.004211,    0.003478,  -10.772583}, {   0.002670,    0.002459,    0.003272},
			{   0.006370,    0.004900,   -0.894279}, {   0.006790,    0.001484,   -4.255997}, {   0.006790,    0.001484,   -4.255997}, {   2.105206,    8.971637,    0.006800}, {   0.007385,    0.005797,   -0.687824}, {  -9.490440,    4.372420,    0.939194}, {  -0.320197,    0.654021,    1.952594}, {   0.003704,    0.007120,    0.007691},
			{  -9.490440,    4.372420,    0.939194}, {  10.393779,   -1.734814,    1.374680}, {  -0.320197,    0.654021,    1.952594}, { -11.376075,  -10.416782,    0.932219}, {   0.003631,    0.005431,    0.002172}, {   0.716705,   -4.359970,    0.238996}, {   0.716705,   -4.359970,    0.238996}, {   0.003631,    0.005431,    0.002172},
			{ -11.376075,  -10.416782,    0.932219}, {  -0.479418,   -0.555886,    1.263988}, {   2.257558,   -0.841727,   -0.544273}, {   2.257558,   -0.841727,   -0.544273}, {  -0.016579,    0.003600,    0.000708}, {   0.006790,    0.001364,    0.007650}, {   0.006432,    0.006771,    0.003806}, {   0.016783,    0.029284,    0.001966},
			{   0.005830,    0.000312,    0.000226}, {   0.001338,    0.002361,    0.002567}, {   0.009499,   -2.312928,    0.003891}, {   0.009499,   -2.312928,    0.003891}, {  -0.006709,    0.014496,    0.013474}, {   0.001555,    0.006111,    0.000335}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  14.703125,    4.354309,   -4.886692},
			{  -8.425704,   29.229614,   10.703418}, {   0.193860,    0.204416,    1.784494}, {   0.003124,    0.005836,    0.005553}, {   0.004089,    0.000915,   -1.700718}, {   3.513416,   10.651550,    4.779428}, {   8.246028,    9.108764,   29.674242}, {  -8.425704,   29.229614,   10.703418}, {  -5.165038,   -9.428771,   -0.171393},
			{   2.213012,    3.105834,    9.459098}, {  74.372314,  -22.292358,   77.254676}, {  -0.701075,    0.768028,    8.855022}, { -11.653404,    6.238180,   15.842456}, {  -0.006248,    0.007280,   -0.084544}, {   0.008910,    0.004883,    0.007457}, {   0.106201,    0.006469,    0.007433}, {  -0.003464,  -18.359703,    0.007503},
			{  -0.500000,   72.508850,    0.034203}, {  -0.004271,   -0.002501,    0.005020}, {   0.505492,    0.000609,   -0.976894}, {  -4.117797,   -9.992919,   -1.114474}, {  -0.568481,  -22.891967,    0.003562}, { -19.999389,    0.008178,    0.000928}, {   0.000000,   10.550415,    0.040766}, {  -0.003234,    0.015746,    0.020731},
			{   0.001952,    0.006477,   -0.508472}, {   0.008910,    0.004883,    0.007457}, {   0.106201,    0.006469,    0.007433}, {  -0.003464,  -18.359703,    0.007503}, {  -0.004271,   -0.002501,    0.005020}, {  -0.003234,    0.015746,    0.020731}, {   0.505492,    0.000609,   -0.976894}, {   6.041573,   12.106704,   -0.386458},
			{  -0.568481,  -22.891967,    0.003562}, {  -4.787476,  -10.084838,    0.141672}, {  15.160522,   -9.897094,    0.051049}, {   0.004761,   -0.146851,    0.005462}, {   0.214232,   -0.019652,   -0.034905}, {   0.214232,   -0.019652,   -0.034905}, {  -4.787476,  -10.084838,    0.141672}, {  15.160522,   -9.897094,    0.051049},
			{   0.004761,   -0.146851,    0.005462}, {  -4.531737,   -8.224182,   34.629146}, {   2.630744,   32.128173,   46.080097}, {   8.602661,   18.433105,    8.625577}, {   0.000121,    0.006347,    0.000515}, { -19.052612,   13.067138,   -0.654967}, { -12.555223,  -12.468994,   -1.732921}, {   0.000000,   10.550415,    0.040766},
			{   0.004271,    0.004577,    0.000345}, {   0.000205,   -0.042847,   -0.074666}, {   0.006591,    0.004149,    0.000442}, {   0.535521,    0.003295,   -3.666851}, {   6.084595,  -24.920349,   -2.809911}, {   0.002929,   -2.531615,    0.000445}, {  74.372314,  -22.292358,   77.254676}, {   0.686648,    9.280760,   -0.492056},
			{  -3.302272,   -7.923901,    0.001163}, {  -1.063043,   -1.198843,    0.016355}, {  -0.390626,    0.003700,   -0.008454}, {  -0.643297,    9.310074,    0.004571}, {   0.928946,  -10.657507,    0.000528}, { -11.239501,    0.009704,    0.004898}, {  -2.129760,   -3.886229,   -0.120099}, {  14.703125,    4.354309,   -4.886692},
			{   0.007567,    0.008910,    0.003225}, {   3.638916,    0.006103,   -0.441565}, {   0.000243,    0.006103,    0.014030}, { -16.414550,   -5.935729,    0.005038}, {   0.001464,    0.007323,   -0.003218}, {   0.003112,    0.006835,   -0.004567}, {  -0.117895,    0.001220,    0.033229}, { -16.414550,   -5.935729,    0.005038},
			{   0.007567,    0.008910,    0.003225}, {   3.638916,    0.006103,   -0.441565}, {   0.000243,    0.006103,    0.014030}, {   0.004089,    0.000915,   -1.700718}, {   0.001464,    0.007323,   -0.003218}, {   0.003112,    0.006835,   -0.004567}, {  -0.117895,    0.001220,    0.033229}, {   0.003417,    0.122533,   -0.257703},
			{  -5.976242,   -0.287815,    0.884674}, {   0.004027,    0.005737,   -0.025327}, {  -7.988115,   -3.083789,    4.319452}, {  -4.669720,    5.632823,   -2.903388}, {  -0.131957,    0.008301,   -1.053737}, {   0.006469,    0.007323,    0.000702}, {  -0.000121,    0.005127,    0.006393}, {   0.006957,    0.005859,    0.005888},
			{  -0.041747,   -0.062622,   -0.315037}, {  -0.105469,   -0.122437,   -1.083628}, {  -0.122192,   15.517578,   -3.424736}, {   0.090332,    0.857604,   -1.002665}, {   0.005309,    0.000731,    0.025147}, {  13.121315,   14.719848,    0.798456}, {   0.007323,    0.003478,    0.004238}, {   0.002440,    0.005615,   -0.029322},
			{   0.004395,    0.005309,   -0.736495}, {   0.372599,   -0.012799,    0.399273}, {  -0.298873,   -0.020385,    0.050232}, {   0.009216,    0.007782,    0.006504}, {   0.004639,    0.003173,    0.862145}, {   0.004761,    0.003661,   -0.572785}, {  19.096374,  -12.773191,   26.755443}, {   0.005859,   -0.198364,    0.003225},
			{   0.002685,    0.185424,    0.003225}, {   0.008240,    0.010619,    0.003225}, {   0.005005,    0.006225,    0.007338}, { -13.681982,    1.642456,   28.791358}, {   0.003417,    0.000365,    0.007286}, {  -1.147400,    0.780059,   -0.048813}, {   8.404174,   25.958173,    0.005022}, {   8.471802,   -8.767944,   -2.826878},
			{   7.787618,   -0.722652,    3.543431}, { -15.014102,    0.776838,   10.346282}, {   0.005917,    0.004205,    0.000668}, {   0.039615,    0.006713,    0.272437}, {   0.002803,   -0.004319,    0.007730}, {   0.002148,    0.001769,    0.000933}, {  -0.005005,    2.006824,    0.005400}, {   0.000904,    0.000192,    0.000539},
			{   0.002539,    0.006469,    0.003642}, {  -1.821105,    2.479897,   25.655696}, {  -0.154782,   -0.995454,   -2.711740}, {  -4.531737,   -8.224182,   34.629146}, {  -2.082763,    0.003507,   -0.888634}, {   2.630744,   32.128173,   46.080097}, {   0.001342,    0.007019,    0.001678}, {   0.269897,   -0.016602,    0.007505},
			{  -2.082763,    0.003507,   -0.888634}, { -18.909912,    0.002266,    2.547599}, {  37.507442,   -5.538417,    4.218996}, {   8.246028,    9.108764,   29.674242}, {  14.860565,    0.008747,   -6.903037}, { -16.192897,   17.928806,    6.972252}, { -16.192897,   17.928806,    6.972252}, {   0.000243,    0.005737,   -0.084317},
			{   0.006469,    0.007323,    0.000702}, {  -0.000121,    0.005127,    0.006393}, {   0.006957,    0.005859,    0.005888}, {  -0.041747,   -0.062622,   -0.315037}, {  -0.105469,   -0.122437,   -1.083628}, {  -0.131957,    0.008301,   -1.053737}, {   0.039615,    0.006713,    0.272437}, { -19.999389,    0.008178,    0.000928},
			{   0.001342,    0.007019,    0.001678}, {  -2.256768,    9.675985,   -0.037790}, { -11.097848,    8.486222,   -2.500720}, {   0.006316,   -0.390446,   -0.335469}, {  14.534404,    1.080054,    2.820950}, { -12.084215,   43.197101,   -0.142813}, {  10.491003,   -0.041095,   -0.210902}, {  -5.873167,  -29.378490,    0.284130},
			{   1.144232,    0.991577,    1.488255}, {   0.001703,    0.002074,    1.488255}, {   0.127186,    0.127461,   -0.210902}, {  12.044982,   18.077148,    0.158871}, {  10.702601,   17.374074,   -0.305175}, {  12.045959,   18.077148,    0.158871}, {   0.002006,    0.006649,   -0.095611}, {  -0.267892,  -15.181403,    6.354867},
			{  -4.646734,   -3.900350,    4.140264}, {   0.006713,    0.002364,    0.005934}, {   0.007158,    0.005615,    0.004860}, {  26.669006,  -15.054624,    2.848953}, {  11.991105,   -1.421167,    0.002366}, {   0.002001,   -9.167961,    0.003322}, {   0.007650,    0.004151,    0.002330}, {   0.002308,    0.006037,   -0.020385},
			{   0.008541,   -0.184109,    0.000148}, {   0.011610,   -0.008098,    0.002284}, {  -0.024352,   -0.186707,   -0.575679}, {  -9.289427,   14.708979,   -0.035611}, {  -2.089092,    0.006041,    0.003244}, {  -0.048147,    0.002135,   -0.175868}, {   1.642333,    0.590722,    3.075182}, {  -0.006895,    0.003419,    1.717633},
			{  -0.002449,    0.003011,    0.005934}, {   6.933272,   -0.048583,   -0.524753}, { -35.002330,  -19.989074,   -0.576888}, {   2.592066,   -7.359263,    0.017087}, {   0.243530,   -2.260138,  -21.161943}, {   0.004639,    7.695922,  -24.435358}, {   6.083618,  -16.720458,  -22.433008}, {  10.486572,    6.411986,  -26.991493},
			{   6.982613,   32.649581,  -24.620450}, {   9.174552,    8.387939,  -26.178815}, {  -5.006439,   40.008735,   -2.173577}, {   7.955078,   -0.209351,  -22.572233}, {   0.003783,    0.004883,    0.001203}, {   0.001952,    0.001342,   -0.760667}, {  11.025634,   -2.974121,   -0.324104}, {   1.954833,   -2.895385,    0.025125},
			{   9.816894,    1.330566,    0.025125}, {  -1.365844,    9.387207,    0.032937}, {   6.933272,   -0.048583,   -0.524753}, {   2.592066,   -7.359263,    0.017087}, {   7.955078,   -0.209351,  -22.572233}, {  10.486572,    6.411986,  -26.991493}, {   6.083618,  -16.720458,  -22.433008}, {   0.004639,    7.695922,  -24.435358},
			{   0.003539,    0.002396,    0.001043}, {  -5.006439,   40.008735,   -2.173577}, { -35.002330,  -19.989074,   -0.576888}, {   0.001952,    0.001342,   -0.760667}, {   0.003539,    0.002396,    0.001043}, {   0.001514,    0.056152,    0.000862}, {   0.001514,    0.056152,    0.000862}, {   0.005127,    0.000853,    0.003286},
			{  -0.092228,    0.006440,    0.011270}, {  -0.740395,   -1.415871,   -2.812623}, { -18.909912,    0.002266,    2.547599}, {  -1.502678,   -1.543140,   -0.377245}, {   0.004523,    0.006940,    0.005346}, { -48.376991,    0.006087,    0.002910}, {   0.003059,    0.003709,    0.005346}, {  -0.302608,   -0.047580,    0.005346},
			{   0.007369,    0.003488,    0.005346}, {   0.376958,    0.182343,   -0.685756}, {   0.380988,   -0.658891,    0.005346}, {  54.943832,   -0.000018,    0.005346}, { -27.992778,  -10.136539,    0.005053}, {   5.797400,  -25.552883,  -17.311639}, {   0.005898,    0.007309,    0.005346}, {   0.000900,    0.000350,    0.005346},
			{  -0.190246,   -3.468470,    1.354938}, {   0.000853,    0.001220,    0.284372}, {   4.049530,    0.013194,    0.358420}, {   3.314853,    0.015018,    0.356822}, {  -4.044044,   16.288496,    0.372797}, {   0.000609,   -3.319335,   -3.861849}, {   0.110082,    0.007544,    0.006682}, {   0.007507,    0.006713,    0.001747},
			{  -1.618134,   -0.069899,   -1.257135}, {  -5.661277,   22.467679,   15.100218}, {  27.504283,    5.011229,   -0.136677}, {  20.004455,   -2.690429,    0.323253}, {  30.362060,   -0.000487,   -2.617129}, {  50.005004,    7.777222,  -40.380355}, {  -0.713348,   -0.205961,    0.572234}, {   0.002381,    0.264548,   -1.223150},
			{   0.004792,    0.004993,    0.005934}, {  -8.858364,    6.379346,    3.872000}, {  -0.500000,   72.508850,    0.034203}, {   6.982613,   32.649581,  -24.620450}, {   9.174552,    8.387939,  -26.178815}, {   0.004027,    0.005737,   -0.025327}, {   0.005309,    0.000731,    0.025147}, {  -5.976242,   -0.287815,    0.884674},
			{  20.004455,   -2.690429,    0.323253}, {   8.404174,   25.958173,    0.005022}, {  -4.117797,   -9.992919,   -1.114474}, {   2.213012,    3.105834,    9.459098}, {   1.954833,   -2.895385,    0.025125}, {   0.000121,    0.006347,    0.000515}, {  -7.988115,   -3.083789,    4.319452}, {   1.486572,   -2.850585,   -0.018440},
			{   0.000243,    0.005737,   -0.084317}, {   0.006316,   -0.390446,   -0.335469}, {  -5.165038,   -9.428771,   -0.171393}, {  -2.256768,    9.675985,   -0.037790}, { -28.071533,  -27.082433,   12.226870}, {   9.816894,    1.330566,    0.025125}, {  -1.365844,    9.387207,    0.032937}, { -11.097848,    8.486222,   -2.500720},
			{  19.096374,  -12.773191,   26.755443}, {   0.003783,    0.004883,    0.001203}, { -64.666801,    4.822875,    0.797621}, {  -0.298873,   -0.020385,    0.050232}, {   0.372599,   -0.012799,    0.399273}, { -11.653404,    6.238180,   15.842456}, {  -9.289427,   14.708979,   -0.035611}, {  -0.006248,    0.007280,   -0.084544},
			{   0.002196,    8.778736,    0.180616}, {  -2.089092,    0.006041,    0.003244}, {   0.001952,    0.006477,   -0.508472}, {   0.003124,    0.005836,    0.005553}, {  25.062427,    0.127059,    1.418566}, {  14.534404,    1.080054,    2.820950}, {  50.005004,    7.777222,  -40.380355}, {  30.362060,   -0.000487,   -2.617129},
			{  12.044982,   18.077148,    0.158871}, {  12.045959,   18.077148,    0.158871}, {  10.702601,   17.374074,   -0.305175}, {   3.513416,   10.651550,    4.779428}, {  -4.646734,   -3.900350,    4.140264}, {  -0.701075,    0.768028,    8.855022}, {  -4.669720,    5.632823,   -2.903388}, {   0.110082,    0.007544,    0.006682},
			{  27.504283,    5.011229,   -0.136677}, {   2.770020,   36.310913,   -4.504685}, { -19.052612,   13.067138,   -0.654967}, { -12.555223,  -12.468994,   -1.732921}, { -11.239501,    0.009704,    0.004898}, {  -3.302272,   -7.923901,    0.001163}, {  -0.643297,    9.310074,    0.004571}, {  -1.063043,   -1.198843,    0.016355},
			{ -15.721313,    4.536743,    6.250618}, {   8.602661,   18.433105,    8.625577}, {   0.755797,  -17.728271,    6.008500}, {  -0.390626,    0.003700,   -0.008454}, {   0.686648,    9.280760,   -0.492056}, {  -2.129760,   -3.886229,   -0.120099}, {   0.011610,   -0.008098,    0.002284}, {  26.669006,  -15.054624,    2.848953},
			{   0.243530,   -2.260138,  -21.161943}, {  -0.713348,   -0.205961,    0.572234}, {   0.004792,    0.004993,    0.005934}, {   0.006713,    0.002364,    0.005934}, {  26.699235,   -1.644580,    0.000014}, { -15.014102,    0.776838,   10.346282}, { -13.681982,    1.642456,   28.791358}, {  -5.873167,  -29.378490,    0.284130},
			{   0.269897,   -0.016602,    0.007505}, {   0.004271,    0.004577,    0.000345}, {   0.000205,   -0.042847,   -0.074666}, {   0.006591,    0.004149,    0.000442}, {   0.002929,   -2.531615,    0.000445}, {   0.535521,    0.003295,   -3.666851}, {   0.005127,    0.000853,    0.003286}, {   0.005127,    0.000853,    0.003286},
			{ -28.071533,  -27.082433,   12.226870}, {  -0.000138,   -0.001252,    0.000943}, {  -0.000138,   -0.001252,    0.000943}, {   0.004639,    0.002929,    0.002625}, {   0.000976,    0.002929,    0.002625}, {   0.001952,    0.002929,    0.002625}, {   0.005859,    0.002929,    0.002625}, {  -0.026830,   -0.352815,    0.219790},
			{   0.787666,   21.010009,   -0.096593}, {   0.002006,    0.006649,   -0.095611}, {   0.787666,   21.010009,   -0.096593}, {  -0.026830,   -0.352815,    0.219790}, {   5.671387,   -2.634017,    0.004869}, {   5.671997,   -9.824264,    0.004869}, {  29.368164,   -3.085205,    0.004869}, { -12.192983,    4.069622,    0.465773},
			{ -12.192983,    4.069622,    0.465773}, {   4.103759,   -1.254639,  -17.517936}, {   0.004116,    0.000069,    0.004869}, {   6.041573,   12.106704,   -0.386458}, {  -4.668949,    5.687106,   -4.213823}, {   0.897635,   14.582803,   -4.993565}, {   0.535594,   -2.658039,   -2.119092}, {  -0.014189,   -0.083095,    2.615318},
			{   0.001159,    0.517323,    0.048082}, {   1.382568,  -16.423477,   -0.075200}, {   0.206787,    7.694702,   -0.037404}, {   0.928946,  -10.657507,    0.000528}, {   0.469603,    0.003905,    0.001599}, {   0.117022,    0.015387,    0.006333}, {  -1.821105,    2.479897,   25.655696}, {  -0.048147,    0.002135,   -0.175868},
			{  -0.190246,   -3.468470,    1.354938}, { -64.666801,    4.822875,    0.797621}, {   0.002196,    8.778736,    0.180616}, {   0.000853,    0.001220,    0.284372}, {   0.005127,    0.000853,    0.003286}, {   0.018458,  -31.614051,    0.522539}, {   0.002644,   -0.007180,    0.003614}, {   0.207338,  -13.220184,    0.007728},
			{ -23.108076,  -12.391115,   -0.434163}, {   6.084595,  -24.920349,   -2.809911}, {  -1.610008,    0.010754,    0.564415}, {   0.029942,   -0.139752,   -0.156194}, {   4.262329,   -1.657714,    2.870213}, {   4.514770,  -28.306884,    8.744758}, {  -0.770263,   -1.943135,   -4.162200}, {  -0.528687,   -1.930353,   -8.115397},
			{   0.006835,    0.007689,    0.002617}, {  10.441205,  -60.846992,   10.543689}, {   0.004089,    0.001220,    0.001244}, {   0.004089,    0.001220,    0.001244}, {   0.003661,    0.007445,    0.003225}, {   0.003661,    0.007445,    0.003225}, {   0.004027,    0.568114,    0.003324}, {   0.004027,    0.568114,    0.003324},
			{ -13.483833,    0.463744,   19.414169}, { -13.483833,    0.463744,   19.414169}, {  25.062427,    0.127059,    1.418566}, {  14.860565,    0.008747,   -6.903037}, {   0.003295,   -0.197955,    0.507350}, {   1.270812,    3.080693,    2.382050}, {   1.590126,   -0.128296,    0.018849}, {   0.006957,    0.004821,   -2.650342},
			{   0.010863,    0.001220,   -6.233496}, {   0.002807,    0.010375,    0.004552}, {   0.003417,    0.003539,    0.000693}, {   0.000121,    0.005615,    0.004492}, {   0.003905,    0.002685,    0.002130}, {   0.001342,    0.007201,    0.002111}, {   0.002807,   -0.221680,  -11.981916}, {   0.006957,    0.004821,   -2.650342},
			{   0.010863,    0.001220,   -6.233496}, {   0.002807,    0.010375,    0.004552}, {   0.003417,    0.003539,    0.000693}, {   0.000121,    0.005615,    0.004492}, {   0.003905,    0.002685,    0.002130}, {   0.001342,    0.007201,    0.002111}, {   0.002807,   -0.221680,  -11.981916}, {   0.003417,    0.005249,    0.000205},
			{   0.003417,    0.005249,    0.000205}, {  -4.531737,  -15.560180,   10.164213}, {  -4.531737,  -15.560180,   10.164213}, {  -0.528687,   -1.930353,   -8.115397}, {  11.353149,   10.591552,    4.169610}, {   0.007232,  -10.578521,    0.002212}, {   0.007232,  -10.578521,    0.002212}, {  21.791574,  -35.320205,    0.911616},
			{  33.908241,  -57.479278,    1.177443}, {   1.225404,   -0.272448,   -0.270839}, {  -4.531737,  -15.560180,   10.164213}, {  -4.531737,  -15.560180,   10.164213}, { -59.541625,   -5.935303,   -1.007475}, {  -1.130828,    4.051181,   -0.138038}, {   0.003417,    0.005249,    0.000205}, {   0.003417,    0.005249,    0.000205},
			{   3.161015,  -14.065811,  -15.306612}, {   0.002148,    0.001769,    0.000933}, {   0.002539,    0.006469,    0.003642}, {   0.000904,    0.000192,    0.000539}, {  -0.005005,    2.006824,    0.005400}, {  -0.024317,    0.002440,   14.932065}, {   0.006587,    0.003133,    0.000652}, {   0.006587,    0.003133,    0.000652},
			{   0.003081,    0.002588,    0.004941}, {   0.002318,    0.006225,    0.002333}, {   0.002318,    0.006225,    0.002333}, {   0.003417,    0.122533,   -0.257703}, {   0.002257,    0.002471,    0.002682}, {  13.121315,   14.719848,    0.798456}, {   0.007323,    0.001464,    0.006190}, {   0.206664,   -0.020630,    0.492785},
			{   1.382689,  -16.362426,    0.417885}, {  29.296752,   -2.848267,    0.004869}, {   5.671387,   -2.601562,    0.004869}, {   5.671752,   -9.776367,    0.004869}, {  -0.115172,   -0.228820,    0.366899}, {  -0.089111,    0.182982,    0.430319}, {   0.079346,    0.010619,    0.587711}, {   0.089192,    0.042778,    0.587711},
			{   0.007300,    0.001252,    0.003199}, {  -0.062244,   -0.079754,    0.003558}, {  -0.063717,   -0.081803,    0.003558}, {   0.043708,   -0.055932,    0.003553}, {   0.008293,    0.144434,    0.013375}, {  -0.063110,    0.006713,    0.564845}, {   0.008789,    0.029296,    0.587711}, {   0.007586,   -0.002210,   -0.356117},
			{  -0.003055,   -0.006064,   -0.356117}, {   0.005359,    0.005311,    0.681487}, {  11.353149,   10.591552,    4.169610}, {   0.002929,    0.000518,    0.004009}, {   0.002929,    0.000518,    0.004009}, {   7.523160,   -0.079829,   -2.052768}, {   7.523160,   -0.079829,   -2.052768}, {  -1.063675,   -1.246775,    0.030184},
			{   0.004027,   -9.993591,   -0.891821}, {  -0.000121,    0.002257,    0.001696}, {   0.004027,   -9.993591,   -0.891821}, {  -0.000121,    0.002257,    0.001696}, {   0.005127,    0.011353,    0.021750}, {   0.005127,    0.011353,    0.021750}, {   0.002440,    0.006591,    0.004623}, {   0.006835,    0.004639,    0.001698},
			{   0.006835,    0.004639,    0.001698}, {   0.002440,    0.006591,    0.004623}, {   0.004761,    0.003661,   -0.572785}, {   4.083237,    0.000120,    0.225020}, {  -0.017836,    0.023281,    0.225020}, {   0.004298,   -0.000358,    0.001629}, {   0.319334,    0.003052,   -0.010627}, {  -4.157714,    0.005493,   -0.010626},
			{   1.486572,   -2.850585,   -0.018440}, {  -0.005371,    0.007813,   -0.010630}, {  -0.005371,    0.007813,   -0.010630}, {  11.025634,   -2.974121,   -0.324104}, {   0.319334,    0.003052,   -0.010627}, {  -4.157714,    0.005493,   -0.010626}, {   0.246105,    3.429567,    0.372195}, {   0.002440,    0.005615,   -0.029322},
			{   0.004455,    0.001501,    0.002351}, {   0.004455,    0.001501,    0.002351}, {   0.000534,    0.005472,    0.002604}, {   0.000534,    0.005472,    0.002604}, { -12.084215,   43.197101,   -0.142813}, {   0.008240,    0.010619,    0.003225}, {   0.002685,    0.185424,    0.003225}, {   0.005859,   -0.198364,    0.003225},
			{  -0.024352,   -0.186707,   -0.575679}, {   0.007323,    0.003295,    0.005625}, {   0.007323,    0.003295,    0.005625}, {   0.001098,    0.004395,    0.006469}, {   0.001098,    0.004395,    0.006469}, { -52.142456,  -13.860351,    0.003216}, { -52.142456,  -13.860351,    0.003216}, {  -5.747685,  -35.071350,    0.004168},
			{  -5.747685,  -35.071350,    0.004168}, {   0.004639,    0.006103,    0.000673}, {   0.003173,    0.006225,    0.004209}, {   0.003173,    0.006225,    0.004209}, {   0.006835,    0.006225,    0.001936}, {   0.006835,    0.006225,    0.001936}, { -13.681982,    1.642456,   28.791358}, {   0.004509,    1.884093,    0.598237},
			{   2.287549,    0.000186,    0.569275}, {  -0.001662,    0.007294,    0.569275}, {   0.049848,    0.055107,    0.569275}, {  -0.374128,  -54.181095,    3.663024}, {   0.004509,    1.884093,    0.598237}, {  -0.374128,  -54.181095,    3.663024}, {   0.049848,    0.055107,    0.569275}, {  -0.001662,    0.007294,    0.569275},
			{   2.287549,    0.000186,    0.569275}, {   0.315715,    0.312822,    0.557909}, {   0.315827,   -0.003653,    0.557909}, {  -0.070320,  -53.961414,    3.651659}, {   0.310950,    2.228488,    0.557909}, {   2.605492,    0.317463,    0.557909}, {   1.225404,   -0.272448,   -0.270839}, {   0.003783,    0.006347,    0.001653},
			{   0.003783,    0.006347,    0.001653}, {  -1.147400,    0.780059,   -0.048813}, {   2.770020,   36.310913,   -4.504685}, { -15.721313,    4.536743,    6.250618}, {  -0.024317,    0.002440,   14.932065}, {   0.755797,  -17.728271,    6.008500}, {  -0.007275,    0.005127,    1.979799}, {  -0.003905,    0.006103,    2.480684},
			{   0.246105,    3.429567,    0.372195}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  -0.013980,    0.021639,    0.001699},
			{  -0.384339,   -0.374056,    0.006643}, {  30.959865,   15.909122,   -4.573514}, {  -0.784825,   -0.011923,    2.555294}, {  -3.217529,   -7.595153,   15.489615}, {   0.005034,    0.004739,    0.002024}, {   0.004883,    0.005493,    0.007796}, {  10.007324,    0.004883,    0.001786}, {   0.041138,    6.770987,    3.447838},
			{   1.957275,  -25.725952,   10.320861}, {  -0.365294,   15.186767,    2.574199}, {   4.501330,  -21.839813,    0.001069}, {   0.005309,    0.007079,   -0.778621}, {  32.627197,    0.005371,    0.004976}, {   0.008545,   -9.997680,    0.146715}, {   0.000000,   54.480590,    0.040748}, {   0.000731,    0.001708,    0.001687},
			{  20.005310,  -19.994262,    0.040750}, {  -0.421692,    0.006165,    0.040750}, {   0.000000,   10.004882,    0.040762}, {   0.007629,   20.001831,    0.036088}, {   0.002379,    0.000365,    0.001193}, { -23.638793,  -30.655639,    0.498441}, {   4.888245,  -17.060668,    0.129316}, {  -4.845886,  -17.060668,    0.141812},
			{   0.005615,    2.168700,    0.053520}, {  10.064575,    0.079956,   -0.449625}, {   0.080321,    0.441895,    0.041140}, {  -4.806151,    4.337279,    0.004466}, {   0.003905,    0.004517,    0.006111}, {   0.007346,    0.006012,    0.007505}, {  29.169006,   -3.966187,    0.040761}, {   0.005919,   -2.087402,    0.056379},
			{   8.589294,    1.643798,  -63.478015}, {  -3.200623,   -1.888916,  -50.227622}, {  -1.867125,   27.723022,  -50.641475}, {   0.006591,    0.509276,  -57.985225}, {  -0.002685,    0.004883,    0.006754}, {   0.002562,  -19.995849,    0.003178}, {   0.000304,   -9.967735,    1.223438}, { -10.143859,  -19.856933,    1.532130},
			{   1.368530,    0.964721,    2.056956}, {  68.476440,    5.575194,    2.547677}, {  22.556823,   -5.000183,    0.997986}, { -10.040100,    0.002074,    0.000707}, {   0.033447,    0.004027,    0.000272}, {  -8.643432,   -0.201782,    0.003680}, {   5.541687,   -0.214721,   -0.046201}, { -33.696350,   -0.002440,   -0.765470},
			{  -1.359320,    0.002440,   -0.765622}, {  -0.000243,    0.004639,    0.001896}, {   0.002562,   -6.102416,   -1.342111}, {  40.003662,    0.006469,   -0.663170}, {   0.004883,    0.006409,    0.101906}, {  -9.997528,    0.716247,    1.503672}, {  19.911712,   -0.000548,    0.999998}, {  25.002441,    0.006713,    0.998992},
			{  -4.998961,    0.101870,    1.498335}, {   0.001037,   10.283355,    1.001420}, {   0.004883,    0.006469,    0.001945}, {   0.000805,   29.999977,   -1.374243}, {   0.005127,    3.607074,    0.040761}, { -39.997131,    4.241699,    0.040750}, {   0.003043,    0.002196,    0.248402}, { -39.994995,  -29.995239,    0.004999},
			{   0.001403,  -29.995605,    0.040754}, { -25.779418,    0.000976,    0.040750}, {  20.493835,    0.003295,   -0.034217}, {   0.001403,    0.005249,    0.017317}, {   0.006775,   -0.000670,    0.040748}, {   0.006287,   -0.048523,    0.326920}, {   1.517699,    0.003173,    0.006124}, {  -3.217529,   -7.595153,   15.489615},
			{   0.859192,   -0.302489,    9.599811}, {   1.086151,   -6.375973,    4.341909}, {   0.002196,    4.645762,    0.635007}, {   0.002318,    0.004333,   -0.051288}, {  30.798534,    3.538696,   -0.076141}, { -16.782924,   -5.218262,    0.859615}, {  10.709197,   17.368896,   -0.305175}, {  17.366912,  -10.702697,   -0.305175},
			{  16.337768,   -7.012694,   -0.743678}, {  -2.380630,   23.573791,    0.004083}, {   0.006409,   33.856933,    2.714487}, {   0.002257,    0.004271,    0.000441}, {   0.004761,    0.143799,    0.005853}, {   0.004761,    0.001098,    0.003574}, {   2.006531,    0.001220,    0.003458}, {   0.005737,    0.001830,    0.003458},
			{   0.005615,    0.004883,    0.007040}, {  -1.409942,    0.004639,    0.007040}, {   4.335480,    9.511149,   -0.420590}, {  -2.074628,   -0.250117,    1.738579}, {   0.290111,   -5.296770,    0.001255}, {   3.487030,   -9.955200,    7.439242}, {  -2.854425,   -9.225282,   -0.246981}, {   7.835784,  -11.345458,   -0.749146},
			{ -19.156066,  -29.358642,    0.585494}, { -52.974243,    6.365478,    5.000954}, {  19.777130,   -0.447753,    1.145889}, {   0.006957,    0.006347,    0.007869}, {   0.007445,    0.006347,    0.009720}, {   0.007629,    0.003783,   -1.287178}, { -66.476234,   32.754882,   -2.145323}, {   0.002624,    0.006399,   -0.000018},
			{   2.665282,   -0.957642,    4.398952}, { -35.973419,  -29.721740,    1.658154}, {   0.001342,    0.000060,    0.001166}, {   0.001220,    0.002379,    0.000074}, {   0.000000,    0.004517,    0.001884}, {   5.162998,    5.799491,    2.108220}, {  17.996816,   -1.172399,    2.548055}, {   0.002624,    0.003417,    0.007776},
			{   2.335845,   22.560058,    4.890757}, {  27.074401,   17.485046,    1.650089}, {  14.799751,   -0.008063,   -4.107192}, { -41.947254,   19.538635,    7.828862}, {   0.002379,    0.003783,    0.001966}, {  -0.000798,    0.017100,    0.004296}, {  -0.000296,    0.008991,    0.004296}, {   0.000380,    0.012241,    0.000794},
			{  -9.130126,    3.557513,   -0.498896}, {   6.591248,   21.937335,   -0.006271}, {   0.006728,    0.002359,    0.004592}, {   3.237610,    6.447388,    2.537817}, {  -3.146423,   16.697631,    1.446910}, {   0.001647,    0.000426,    0.001387}, {   0.007629,    0.001708,    0.001387}, {   0.007019,   10.863586,    0.001387},
			{   0.001281,    0.000853,    0.003267}, {   0.003234,    0.003783,    0.003305}, {   0.006287,    0.006225,   -0.321525}, {   0.000060,    0.002074,    0.001972}, {   0.002013,    0.002562,    0.000245}, {   0.003234,    0.003051,    0.003573}, {   0.006775,    1.653931,   -0.372258}, {   0.009154,    0.006165,   -0.317281},
			{   0.009216,   30.003295,   -0.546145}, {   0.001662,    0.000487,    0.956596}, {  -7.187148,    8.886695,   -0.010023}, {   0.004401,    0.005115,    0.001809}, {   0.007565,    0.002171,    0.006953}, {   0.003661,    2.137938,  -63.472633}, {   0.000000,    0.005898,    0.040764}, {  -9.998535,    0.005919,    0.040757},
			{   5.121932,    7.037007,   -1.150339}, {   0.004997,    0.004168,    0.009720}, {   0.001499,    0.001119,    0.005346}, {   0.001922,    0.002911,    0.005346}, {   0.004654,    0.001701,    0.005346}, {   0.006049,    0.003318,    0.005346}, {   0.000716,    0.007044,    0.005346}, {   0.002656,    0.007441,    0.005346},
			{   0.004143,    0.001133,    0.856786}, {   0.002933,    0.001420,    0.005346}, {   0.001525,    0.001769,    0.001387}, {   0.000289,    0.003403,    0.005346}, {   0.007598,    0.005493,    0.005346}, {   0.000121,    0.000754,    0.005346}, {   0.004447,    0.002562,    0.005346}, {  -0.000011,    0.004616,    0.005346},
			{   0.003090,    0.004275,    0.005348}, {   0.318599,   -0.304477,    0.005346}, {   0.314204,    0.004557,    0.005346}, {   0.002544,    0.002074,    0.005979}, {  30.000366,   54.475219,    0.004997}, {   0.000182,    0.005737,    0.003764}, {   0.001965,    3.182377,    0.005278}, {   0.126148,   -0.061053,    0.004157},
			{   0.004588,    0.001488,    0.001460}, {   0.007027,    0.003684,    0.003563}, {   0.001342,    0.004639,    0.005450}, {  -0.375396,   -4.233704,    0.965755}, {   1.336951,   -1.358312,   -1.708781}, {   0.002876,   -0.016807,    0.005268}, {   1.442266,  -27.837882,    0.964348}, {   0.003395,   -9.455871,   -1.459398},
			{  -0.032926,    0.007571,    0.005493}, {   0.006409,    0.003647,    0.005977}, {   0.007027,    0.003684,    0.003563}, {   0.003257,    0.001808,   -0.923995}, {   0.002601,    0.004145,    0.005080}, {   0.001194,    0.007610,    0.007319}, { -11.070416,    0.004246,    0.001387}, { -21.891120,    6.313928,    2.826157},
			{   0.004883,    0.003173,    0.007797}, {   0.011718,    0.004271,    0.007797}, {   0.004883,    0.005371,    0.007799}, {   0.004999,    0.002917,    0.001350}, {   0.004943,    0.005632,    0.001434}, {  10.364697,    0.004294,    0.040770}, {   0.003772,    0.001288,    0.007220}, { -21.983694,    0.002689,    0.001387},
			{ -11.067009,    0.007666,    0.001387}, {  -9.411821,    0.007650,    0.001387}, {   0.007674,    0.004641,    0.001010}, {  -0.097569,   -0.110274,    0.562336}, {  -2.401671,    0.001714,    0.647809}, {   0.001036,   -0.000029,    1.624312}, {  -0.903361,    0.003006,    0.582204}, {   0.001704,   -0.099257,   -1.712524},
			{   0.002379,    0.010750,    1.937988}, {   0.004248,    0.003878,   -0.107626}, {  46.477054,   11.190393,    0.481052}, {  18.479904,   -2.041016,   -1.900524}, {   0.010619,    0.007567,    0.007776}, {   0.009979,    0.004639,    0.007776}, {   0.000148,    0.011421,    0.007776}, {  -0.043524,    0.003483,    0.004869},
			{  -0.014708,    0.042458,    0.000539}, { -65.615173,   33.831745,   -2.141514}, {   0.805054,    3.943665,    0.000153}, { -12.229440,   30.957767,    1.077348}, { -39.739517,  -29.787919,    0.484560}, {   0.001464,    0.000976,    0.040759}, {   0.002172,    0.007563,   -7.819064}, {   0.000243,    0.004211,    0.010099},
			{  -0.029053,    0.006347,    0.007668}, {   0.003478,    0.027222,    0.062362}, {   0.006835,    0.002379,    0.007654}, {   0.002139,    0.002402,   -6.737657}, {   0.001159,    0.004871,   -6.591197}, {   0.003775,    0.003421,    0.005346}, {   0.006603,    0.000630,    0.005346}, {   0.001143,   -0.501048,    0.005346},
			{   0.004561,    0.001779,    0.005346}, {   0.000190,    0.002153,    0.005346}, {   0.145897,    0.005375,    0.005346}, {   0.139228,    0.004238,    0.005346}, {   0.001048,    0.002311,    0.005346}, {   0.007065,    0.005144,    0.005346}, {   1.303321,  -58.245460,    0.004404}, {   1.983235,   -0.837418,    0.005346},
			{   0.005135,   -1.583435,    0.004404}, {   0.001449,   -1.581985,    0.004404}, {   0.003413,    0.007025,    0.005348}, { -25.573837,  -39.111907,   -1.608801}, {   0.223002,  -19.035581,   -0.604569}, { -19.326713,   -0.003407,   -0.604569}, { -19.431938,   -0.003399,   -0.604569}, {   0.002915,   -0.004027,   -0.604569},
			{  19.443061,   -0.004009,   -0.604569}, {   0.004761,   -0.030504,    0.005574}, {   6.515930,    5.931212,    5.454811}, {   0.004761,    0.004395,    0.001256}, {   0.152039,   -0.141940,   -7.355943}, {   0.004189,    0.005950,   -7.355943}, {   0.003932,   16.904745,   -0.059082}, {  23.211416,   -5.391706,   -0.238179},
			{   0.004149,    0.005615,    0.007040}, {   0.006347,    0.002478,    0.007040}, {   0.002501,    0.005127,    0.005514}, {   0.009979,    0.004639,    0.007776}, {   0.004401,    0.005115,    0.001809}, {  10.709197,   17.368896,   -0.305175}, {  30.798534,    3.538696,   -0.076141}, {  -2.380630,   23.573791,    0.004083},
			{ -12.229440,   30.957767,    1.077348}, { -16.782924,   -5.218262,    0.859615}, {   0.010619,    0.007567,    0.007776}, {   0.000148,    0.011421,    0.007776}, {   0.006957,    0.006347,    0.007869}, {   0.007445,    0.006347,    0.009720}, {   0.002624,    0.003417,    0.007776}, {   0.004997,    0.004168,    0.009720},
			{  19.777130,   -0.447753,    1.145889}, { -25.412731,    0.019206,    0.216083}, {  17.366912,  -10.702697,   -0.305175}, {  16.337768,   -7.012694,   -0.743678}, {   6.077637,   15.659606,    6.375504}, {   0.002196,    4.645762,    0.635007}, {   3.487030,   -9.955200,    7.439242}, { -35.973419,  -29.721740,    1.658154},
			{   0.002379,    0.003783,    0.001966}, {  -4.905591,   13.434338,    1.997866}, {   2.665282,   -0.957642,    4.398952}, {   0.001342,    0.000060,    0.001166}, {   0.305236,    0.006041,    0.005433}, { -52.974243,    6.365478,    5.000954}, {  -7.187148,    8.886695,   -0.010023}, {   5.162998,    5.799491,    2.108220},
			{   2.414880,   -0.006736,   -1.959805}, {   2.414880,   -0.006736,   -1.959805}, {  14.799751,   -0.008063,   -4.107192}, { -25.573837,  -39.111907,   -1.608801}, {   0.003413,    0.007025,    0.005348}, {   0.019378,    5.740845,    6.247276}, {   1.957275,  -25.725952,   10.320861}, {   0.002318,    0.004333,   -0.051288},
			{   2.335845,   22.560058,    4.890757}, {   0.859192,   -0.302489,    9.599811}, {   6.515930,    5.931212,    5.454811}, {   0.021316,    0.006517,    0.009719}, {   0.013167,    0.422114,    0.012187}, {  -0.023437,   -0.006475,    0.009719}, {   0.290111,   -5.296770,    0.001255}, {  27.074401,   17.485046,    1.650089},
			{   4.501330,  -21.839813,    0.001069}, {   4.335480,    9.511149,   -0.420590}, {  -2.074628,   -0.250117,    1.738579}, {   1.086151,   -6.375973,    4.341909}, {   0.004588,    0.001488,    0.001460}, {   0.002601,    0.004145,    0.005080}, { -21.891120,    6.313928,    2.826157}, {  17.996816,   -1.172399,    2.548055},
			{ -41.947254,   19.538635,    7.828862}, {   0.152039,   -0.141940,   -7.355943}, {   0.002172,    0.007563,   -7.819064}, {   0.004189,    0.005950,   -7.355943}, {   0.001159,    0.004871,   -6.591197}, {   0.002139,    0.002402,   -6.737657}, {  30.959865,   15.909122,   -4.573514}, {  -0.384339,   -0.374056,    0.006643},
			{   0.002379,    0.010750,    1.937988}, {  12.296203,   24.373901,   -0.607190}, {   0.012085,  -19.982299,   -0.543379}, {  -0.090942,    0.023192,    0.013387}, {   0.006287,    0.006225,   -0.321525}, {   0.005309,    0.007079,   -0.778621}, {  32.627197,    0.005371,    0.004976}, {   0.008545,   -9.997680,    0.146715},
			{   0.000000,   54.480590,    0.040748}, {   0.000731,    0.001708,    0.001687}, {  20.005310,  -19.994262,    0.040750}, {  10.364697,    0.004294,    0.040770}, {  -0.421692,    0.006165,    0.040750}, {   0.000000,   10.004882,    0.040762}, {   0.000000,    0.005898,    0.040764}, {  -9.998535,    0.005919,    0.040757},
			{   0.000243,    0.004211,    0.010099}, {  -0.029053,    0.006347,    0.007668}, {   0.007629,   20.001831,    0.036088}, {   0.003234,    0.003783,    0.003305}, {   0.000060,    0.002074,    0.001972}, {   0.009216,   30.003295,   -0.546145}, {   0.009154,    0.006165,   -0.317281}, {   0.006775,    1.653931,   -0.372258},
			{   0.001281,    0.000853,    0.003267}, {   0.003234,    0.003051,    0.003573}, { -23.638793,  -30.655639,    0.498441}, {  -0.000853,   60.002685,   -3.079117}, {   4.888245,  -17.060668,    0.129316}, {  -4.845886,  -17.060668,    0.141812}, {   0.005615,    2.168700,    0.053520}, {  10.064575,    0.079956,   -0.449625},
			{   0.080321,    0.441895,    0.041140}, {   0.007346,    0.006012,    0.007505}, {  29.169006,   -3.966187,    0.040761}, {   0.005919,   -2.087402,    0.056379}, {   0.003478,    0.027222,    0.062362}, {   0.005127,    3.607074,    0.040761}, { -39.997131,    4.241699,    0.040750}, {   0.003043,    0.002196,    0.248402},
			{ -39.994995,  -29.995239,    0.004999}, {   0.001403,  -29.995605,    0.040754}, { -25.779418,    0.000976,    0.040750}, {  20.493835,    0.003295,   -0.034217}, {   0.001403,    0.005249,    0.017317}, {   0.006775,   -0.000670,    0.040748}, {   0.002013,    0.002562,    0.000245}, {   0.006835,    0.002379,    0.007654},
			{   0.006287,   -0.048523,    0.326920}, {   0.001464,    0.000976,    0.040759}, {  30.000366,   54.475219,    0.004997}, {  12.296203,   24.373901,   -0.607190}, {   0.012085,  -19.982299,   -0.543379}, {  -0.090942,    0.023192,    0.013387}, {  -1.359320,    0.002440,   -0.765622}, {   0.002562,  -19.995849,    0.003178},
			{   0.000304,   -9.967735,    1.223438}, { -10.143859,  -19.856933,    1.532130}, {   1.368530,    0.964721,    2.056956}, {  68.476440,    5.575194,    2.547677}, {  22.556823,   -5.000183,    0.997986}, { -10.040100,    0.002074,    0.000707}, {   0.033447,    0.004027,    0.000272}, {  -8.643432,   -0.201782,    0.003680},
			{   5.541687,   -0.214721,   -0.046201}, { -33.696350,   -0.002440,   -0.765470}, {  -0.002685,    0.004883,    0.006754}, {  -0.000243,    0.004639,    0.001896}, {   0.002562,   -6.102416,   -1.342111}, {  40.003662,    0.006469,   -0.663170}, {  -9.997528,    0.716247,    1.503672}, {  19.911712,   -0.000548,    0.999998},
			{  25.002441,    0.006713,    0.998992}, {  -4.998961,    0.101870,    1.498335}, {   0.001037,   10.283355,    1.001420}, {   0.004883,    0.006469,    0.001945}, {   0.000805,   29.999977,   -1.374243}, {  10.007324,    0.004883,    0.001786}, {   0.004883,    0.003173,    0.007797}, {   0.004999,    0.002917,    0.001350},
			{   0.004943,    0.005632,    0.001434}, {   0.004883,    0.005493,    0.007796}, {   0.004883,    0.005371,    0.007799}, {   0.011718,    0.004271,    0.007797}, {   0.005034,    0.004739,    0.002024}, {  -3.200623,   -1.888916,  -50.227622}, {  -1.867125,   27.723022,  -50.641475}, {   0.006591,    0.509276,  -57.985225},
			{   0.003661,    2.137938,  -63.472633}, {   8.589294,    1.643798,  -63.478015}, {  -0.000798,    0.017100,    0.004296}, {  -0.000296,    0.008991,    0.004296}, {   0.000380,    0.012241,    0.000794}, {  -9.130126,    3.557513,   -0.498896}, {   6.591248,   21.937335,   -0.006271}, {  -0.375396,   -4.233704,    0.965755},
			{   0.001662,    0.000487,    0.956596}, {   0.002544,    0.002074,    0.005979}, {   0.000182,    0.005737,    0.003764}, {   1.336951,   -1.358312,   -1.708781}, {  -0.032926,    0.007571,    0.005493}, {   0.002876,   -0.016807,    0.005268}, {   0.003395,   -9.455871,   -1.459398}, {   0.006409,    0.003647,    0.005977},
			{   9.684143,    2.707520,   -0.185724}, {   0.015014,    0.010254,    0.007776}, {   0.015014,    0.010254,    0.007776}, {   0.007350,    0.014534,    0.009720}, {   0.007350,    0.014534,    0.009720}, {  -0.036890,   -0.033023,    0.004869}, {  -0.083593,    0.003938,    0.004869}, {   0.007428,    0.000475,    0.004869},
			{   0.002426,    0.000491,    0.004869}, {   0.000821,    0.003681,    0.004869}, {   0.000576,    0.005526,    0.004869}, {   0.003844,   34.955932,    0.742043}, {   0.004761,    0.001098,    0.003574}, {   0.004761,    0.143799,    0.005853}, {   2.006531,    0.001220,    0.003458}, {   0.002257,    0.004271,    0.000441},
			{   0.005737,    0.001830,    0.003458}, {   0.007832,   -5.009788,    0.015298}, {   0.007832,   -5.009788,    0.015298}, {   0.013633,    0.017247,    0.007505}, {   0.013633,    0.017247,    0.007505}, {   0.013702,    0.000284,   -1.405814}, {   0.013702,    0.000284,   -1.405814}, {   0.013892,    0.002742,    0.007505},
			{  -0.000853,   60.002685,   -3.079117}, {   7.835784,  -11.345458,   -0.749146}, {   0.002379,    0.000365,    0.001193}, {  -4.806151,    4.337279,    0.004466}, {  16.338109,   -7.020610,   -0.743678}, {  16.338109,   -7.020610,   -0.743678}, {   0.007019,   10.754394,    0.001387}, {   0.100372,    0.006713,    0.001699},
			{   0.054443,    0.243164,    0.001729}, {   0.005187,    0.003173,    0.001732}, {   0.004883,    0.001494,    0.001698}, {   0.005249,    0.001220,    0.001698}, {   0.002440,    0.002562,    0.001699}, {   1.517699,    0.003173,    0.006124}, {   0.002440,    0.002562,    0.001699}, {   0.005249,    0.001220,    0.001698},
			{   0.004883,    0.001494,    0.001698}, {   0.003905,    0.004517,    0.006111}, {   0.005187,    0.003173,    0.001732}, {   0.054443,    0.243164,    0.001729}, {   0.100372,    0.006713,    0.001699}, {  -2.854425,   -9.225282,   -0.246981}, {   0.002196,    0.006713,    0.004147}, {   0.005065,    0.100097,   -0.063680},
			{   0.003304,    0.003383,    0.004162}, {   0.013892,    0.002742,    0.007505}, {   0.004943,    0.005371,    0.006926}, {   0.004943,    0.005371,    0.006926}, {   0.300536,    0.003661,   -1.898784}, {  -0.850398,    0.006808,    8.817309}, {  -0.850398,    0.006808,    8.817309}, {   0.003304,    0.003383,    0.004162},
			{   0.004883,    0.006409,    0.101906}, {   0.000853,    9.876525,    0.005535}, {   0.000853,    9.876525,    0.005535}, {  -0.124883,   -0.016892,    0.005828}, {  12.983840,    0.002830,   -1.825338}, {   0.001586,    0.004242,    0.006639}, {   0.003661,    0.004242,    0.006639}, {  -0.097569,   -0.110274,    0.562336},
			{   0.001704,   -0.099257,   -1.712524}, {  -0.903361,    0.003006,    0.582204}, {   0.001036,   -0.000029,    1.624312}, {  -2.401671,    0.001714,    0.647809}, {   0.005688,    0.003159,    0.004279}, {   0.005932,    0.003648,    0.004279}, {   1.505995,    3.925616,   -0.604914}, {   1.500504,    3.934931,   -0.604914},
			{   1.351302,    4.006052,   -0.604914}, {   1.356173,    4.017152,   -0.604914}, {   0.002209,   -0.004943,    0.004279}, {  -0.003343,    0.004648,    0.004279}, {  -0.003333,    0.004406,    0.004279}, {   0.005946,   -0.000022,    0.004279}, {   0.005946,   -0.000022,    0.004279}, {   0.002339,   -0.008777,    0.004279},
			{   0.005861,    0.003794,    0.004279}, {   0.005952,   -0.007914,    0.004279}, {   0.006200,   -0.007911,    0.004279}, {   0.001444,    0.006287,    0.004279}, {   6.011312,    0.590577,    0.701071}, {  -2.986732,    0.006841,    6.512989}, { -10.909118,   20.282653,   21.839708}, {   2.001343,    2.919434,    1.220775},
			{   0.001479,    0.001845,    0.004817}, {   0.004858,    0.001523,    0.004817}, {   0.004726,    0.007402,    0.004817}, {   0.000835,    0.001932,    0.004817}, {   0.000591,    0.004160,    0.004817}, {  -1.724025,    3.421513,   -0.249228}, { -18.573986,  -12.011007,    0.909959}, {   0.004877,   -0.460693,    0.007269},
			{   0.007610,   -0.266425,    0.004720}, {   0.007610,   -0.266425,    0.004720}, {  -0.000384,   -0.003847,    0.004858}, {   0.002253,   -0.459594,    0.007269}, {   0.006881,    0.004191,    0.005144}, {  -0.001873,   -0.002670,    0.006639}, {   4.553710,  -10.423706,    5.152345}, { -25.412731,    0.019206,    0.216083},
			{   0.006881,    0.004191,    0.005144}, {   0.001647,    0.002807,    0.003879}, {   0.001647,    0.002807,    0.003879}, {   0.007201,    0.004883,    0.007040}, {   0.246572,    1.707985,    0.006628}, {   0.246572,    1.707985,    0.006628}, { -40.141990,   20.668701,    6.225993}, { -19.211212,    2.347287,    4.954117},
			{ -24.580535,    1.883169,    4.954117}, {   0.002196,    0.002135,    0.015482}, {   0.002196,    0.002135,    0.015482}, {   0.223998,   33.024452,  -41.382263}, {   0.223998,   33.024452,  -41.382263}, {   0.226684,   33.024452,  -41.382263}, {   0.226684,   33.024452,  -41.382263}, {   0.019952,    3.182377,   -0.193348},
			{   0.004054,    0.541221,   -0.059082}, {   0.004054,    0.003013,    0.003416}, {   0.004956,    0.005088,    0.003416}, {   0.006225,    0.000487,    0.001105}, {   0.001952,    0.007323,    0.005979}, { -65.621238,   33.736831,   -2.190581}, {   0.126148,   -0.061053,    0.004157}, {   3.237610,    6.447388,    2.537817},
			{   0.000000,    0.004517,    0.001884}, {   0.305236,    0.006041,    0.005433}, { -66.476234,   32.754882,   -2.145323}, {   0.001281,    0.003539,    0.001789}, {   0.001281,    0.003539,    0.001789}, {   0.000182,    0.001952,    0.000757}, {   0.000182,    0.001952,    0.000757}, {   0.000731,    0.001708,    0.003268},
			{   0.000731,    0.001708,    0.003268}, {   0.003234,    0.003051,    0.003299}, {   0.003234,    0.003051,    0.003299}, {  -4.905591,   13.434338,    1.997866}, {   0.019378,    5.740845,    6.247276}, {   6.077637,   15.659606,    6.375504}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.005295,    0.004242,    0.153859}, {   0.006967,    0.000696,   -0.304798}, {   0.000853,    0.003479,    0.001611}, {   0.002013,    0.006835,    0.001658}, {   0.178775,    0.006512,    0.004095}, {   0.005096,    0.001106,    0.006668},
			{   0.004492,   -0.057822,    0.153330}, {   0.005764,    0.007244,    0.005322}, {   0.006537,    0.005454,    0.003754}, {   0.002379,    0.004629,   -0.018896}, {  -0.095092,    0.013748,    0.001790}, {  -0.000060,    0.000853,    0.001723}, {   0.005675,    0.003173,    0.001659}, {   0.005431,    0.006682,    0.001689},
			{   0.001952,    0.006775,    0.007505}, {   0.034363,    0.009093,    0.005580}, {   0.002166,    0.006775,    0.007736}, {   0.006713,    0.001342,    0.007426}, {   0.001281,    0.002562,   -0.825757}, {   0.003112,    0.001891,    0.001817}, {   0.012268,    0.004395,    0.000480}, {   0.001159,    0.002807,    0.010975},
			{   0.001403,    0.002135,    0.003272}, {   0.006225,    0.003844,    0.107207}, {   0.001060,    0.003875,   -1.391410}, {   0.000426,   -0.040465,    0.000686}, {   0.014587,   -0.040894,    1.120355}, {   0.010071,    0.016723,    0.499913}, {   0.002196,    0.046813,    0.003753}, {   0.002501,    0.007201,    0.001685},
			{   0.000884,    0.006591,    0.185765}, {   0.000304,    0.004852,    0.001678}, {   0.004546,    0.002274,    0.055002}, {   0.006287,    0.006194,   -0.321514}, {   0.006531,    0.005493,   -0.337141}, {   0.000670,    0.005104,   -0.337141}, {  -0.000060,    0.000853,    0.001723}, {   0.005675,    0.003173,    0.001659},
			{   0.002379,    0.004395,   -0.337141}, {   0.001647,    0.004761,   -0.337141}, {   0.003478,    0.004699,   -0.337141}, {   0.007019,    0.005828,   -0.337141}, {   0.000853,    0.004271,   -0.337141}, {  -0.006775,    0.010071,    0.007505}, {   0.001952,    0.006775,    0.007505}, {   0.034363,    0.009093,    0.005580},
			{   0.640990,   -5.215023,    0.002790}, {  -0.636852,   -5.219607,    0.002790}, {   0.002253,    0.004608,   -0.323745}, {  -0.005919,    0.000060,   -0.343923}, {   0.002379,    0.000487,    0.003776}, {   0.006713,    0.001342,    0.007426}, {   0.000304,    0.004852,    0.001678}, {   0.007137,    0.005516,    0.000735},
			{   0.001525,    0.005919,   -0.321518}, {   0.001342,    0.000731,    0.001021}, {   0.007546,    0.002283,    0.001893}, {  -0.002733,    0.003905,   -0.520627}, {   0.006835,    0.003417,    0.001711}, {   0.003539,    0.004455,    0.003307}, {   0.144907,    0.014701,    0.002817}, {   0.081037,    0.000304,   -0.420964},
			{   0.002532,    0.002981,    2.390192}, {   0.002746,    0.000945,    0.007606}, {   0.215902,    0.002070,    0.004067}, {  10.823499,    4.505133,   -0.809113}, {   0.003112,    0.001647,    0.815050}, {   0.006287,    0.006194,   -0.321514}, {   0.007019,    0.005828,   -0.337141}, {   0.000670,    0.005104,   -0.337141},
			{   0.000853,    0.004271,   -0.337141}, {   0.002253,    0.004608,   -0.323745}, {   0.006531,    0.005493,   -0.337141}, {   0.001525,    0.005919,   -0.321518}, {   0.001647,    0.004761,   -0.337141}, {   0.002379,    0.004395,   -0.337141}, {   0.003478,    0.004699,   -0.337141}, {  -0.005919,    0.000060,   -0.343923},
			{   0.002379,    0.000487,    0.003776}, {   0.006316,    0.004395,    0.007323}, {   0.001586,   -0.005355,    0.000953}, {   0.002074,    0.006835,    0.007420}, {  -0.011152,   -0.015355,    0.000953}, {  -0.010851,    0.017082,   -1.429960}, {   0.151936,    0.824855,    1.719454}, {   0.000731,    0.005127,    0.002621},
			{   0.005005,    0.005369,    0.007420}, {   0.003116,    0.001309,    0.002066}, {   0.006153,    0.004902,    0.002193}, {   0.003051,    0.002900,   -0.311161}, {   0.000048,    0.003677,    0.001017}, {   0.002441,    0.006103,    0.002756}, {   0.003677,    0.000731,    0.040720}, {   0.001204,    0.004887,   -1.529556},
			{   0.000365,   -1.334136,    0.005334}, {   0.005849,    0.331286,    0.001862}, {   0.001464,    0.002325,    0.000913}, {   0.007569,    0.005499,    0.001862}, {   0.000239,    0.003916,    0.001862}, {   0.006589,    0.007699,    0.001862}, {   0.002195,    0.005317,    0.001862}, {  -3.715209,   -0.007689,   -0.694073},
			{   0.000060,  -13.348403,    0.001689}, {   0.356018,    0.000098,    0.004865}, {   0.006178,    0.006153,    0.004865}, {   0.000091,    0.005197,    0.003014}, {   0.002674,    0.007414,    0.001972}, {   0.007455,    0.001717,    0.007460}, {   0.002006,    0.003457,    0.004865}, {  -0.013515,    0.255315,    0.001001},
			{   0.005431,    0.006682,    0.001689}, {  -0.095092,    0.013748,    0.001790}, {   0.004546,    0.002274,    0.055002}, {   0.003051,    0.002929,    0.000574}, {   0.000426,   -0.040465,    0.000686}, {   0.006225,    0.003844,    0.107207}, {   0.000268,    0.000548,    0.025382}, {   0.012268,    0.004395,    0.000480},
			{   0.000060,  -13.348403,    0.001689}, {   0.010071,    0.016723,    0.499913}, {   0.001159,    0.002807,    0.010975}, {   0.001281,    0.002562,   -0.825757}, {   0.081037,    0.000304,   -0.420964}, {   0.003051,    0.002929,    0.000574}, {   0.006835,    0.003417,    0.001711}, {   0.003539,    0.004455,    0.003307},
			{   0.002532,    0.002981,    2.390192}, {   0.000029,    0.000125,    0.000000}, {   0.001204,    0.004887,   -1.529556}, {   0.005096,    0.001106,    0.006668}, {   0.005295,    0.004242,    0.153859}, {   0.002379,    0.004629,   -0.018896}, {  -3.715209,   -0.007689,   -0.694073}, {  10.823499,    4.505133,   -0.809113},
			{  -0.002733,    0.003905,   -0.520627}, {   0.005386,    0.003295,    0.004689}, {   0.002195,    0.005317,    0.001862}, {   0.006589,    0.007699,    0.001862}, {   0.006153,    0.004902,    0.002193}, {   0.003051,    0.002900,   -0.311161}, {   0.003116,    0.001309,    0.002066}, {   0.005849,    0.331286,    0.001862},
			{   0.000731,    0.005127,    0.002621}, {   0.007569,    0.005499,    0.001862}, {   0.005005,    0.005369,    0.007420}, {   0.000239,    0.003916,    0.001862}, {   0.004492,   -0.057822,    0.153330}, {   0.144907,    0.014701,    0.002817}, {   0.007546,    0.002283,    0.001893}, {   0.008057,    0.005768,    0.004753},
			{  -0.011962,    0.099334,  -13.546525}, {  -0.011962,    0.099334,  -13.546525}, {   0.005326,    0.000824,    0.001632}, {   0.000487,    0.000365,    0.000349}, {   0.002625,    0.009116,    0.005669}, {   0.006821,    0.005942,    0.005084}, {   0.007747,    0.006560,    0.006721}, {   0.002440,    0.002365,    0.001732},
			{   0.000514,    0.001918,    0.004991}, {   0.000299,    0.006347,    0.001783}, {   0.000514,    0.001918,    0.004991}, {   0.007747,    0.006560,    0.006721}, {   0.002440,    0.002365,    0.001732}, {   0.003677,    0.000731,    0.040720}, {   0.001060,    0.003875,   -1.391410}, {   0.000365,   -1.334136,    0.005334},
			{   0.006821,    0.005942,    0.005084}, {   0.005326,    0.000824,    0.001632}, {   0.000487,    0.000365,    0.000349}, {   0.006699,    0.050308,    1.341269}, {  -0.016845,   -0.311787,    1.341269}, {   0.006591,    3.587742,    1.341269}, {   0.004120,    0.007679,    1.273218}, {   0.006715,    0.004852,    0.007606},
			{   0.002067,    0.001549,    1.273218}, {   0.005696,    0.006686,    0.454600}, {   0.002148,    0.002247,    1.273218}, {   0.002945,    0.003866,    0.452906}, {  -0.011152,   -0.015355,    0.000953}, {   0.001586,   -0.005355,    0.000953}, {  -0.010851,    0.017082,   -1.429960}, {   0.006717,    0.001616,    0.004689},
			{   0.002441,    0.006103,    0.002756}, {   0.014587,   -0.040894,    1.120355}, {   0.006316,    0.004395,    0.007323}, {   0.001464,    0.002325,    0.000913}, {   0.001403,    0.002135,    0.003272}, {   0.096619,  -13.012658,    1.208943}, {   0.002074,    0.006835,    0.007420}, {   0.085615,    0.996945,    0.075662},
			{   0.000467,    0.004920,   -0.044551}, {   0.004958,    0.007145,    0.001679}, {   0.000467,    0.004920,   -0.044551}, {   0.003231,    0.003634,    0.003899}, {   0.000268,    0.000548,    0.025382}, {   0.003163,    0.002044,    0.000442}, {   0.000731,    0.005814,    0.000532}, {   0.004585,    0.001098,    0.000442},
			{  -0.180544,    0.105764,    0.000532}, {   0.003507,    0.005905,   -0.057450}, {   0.002275,    0.001703,   -0.017183}, {   0.003163,    0.002044,    0.000442}, {   0.004585,    0.001098,    0.000442}, {   0.002275,    0.001703,   -0.017183}, {  -0.180544,    0.105764,    0.000532}, {   0.003507,    0.005905,   -0.057450},
			{   0.000731,    0.005814,    0.000532}, {   0.001841,   -0.255470,    0.000311}, {  -0.102500,   -0.012322,    0.162850}, {   0.005963,    0.005807,    0.000311}, {   0.004395,    0.004333,    0.001770}, {   0.017513,    0.006202,    0.000311}, {   0.001841,   -0.255470,    0.000311}, {  -0.102500,   -0.012322,    0.162850},
			{   0.005963,    0.005807,    0.000311}, {   0.017513,    0.006202,    0.000311}, {   0.290486,   -0.064932,    0.001906}, {   0.290486,   -0.064932,    0.001906}, {   0.004395,    0.004333,    0.001770}, {   0.000299,    0.006347,    0.001783}, {   0.000182,    0.006599,   -2.935544}, { -14.680091,    6.591979,    0.019909},
			{  20.017822,    0.003600,    0.003684}, {   0.006225,   72.469703,    0.000783}, {   0.004765,    0.004066,    0.003973}, {   0.004765,    0.004066,    0.003973}, { -14.680091,    6.591979,    0.019909}, {  20.017822,    0.003600,    0.003684}, {   0.002012,    0.001545,    0.002198}, {  -0.766368,  -44.892322,  -14.986766},
			{  -0.766387,   44.923019,  -15.053667}, {   0.006111,    0.002593,    1.341269}, {   0.007230,    0.006238,    1.341269}, {   0.002196,    0.046813,    0.003753}, {   0.000472,    0.001230,    0.001230}, {  -1.848862,   -2.164549,    0.058146}, {   0.003024,   -0.017193,    0.003555}, {   0.082794,   -0.437781,    0.045779},
			{   0.006271,    0.004401,    0.005907}, {   0.000853,    0.003356,    0.001676}, {   0.010428,   -0.024188,   -0.354339}, {  -1.342833,    0.061096,   -0.354368}, {   0.000472,    0.001230,    0.001230}, {   0.010428,   -0.024188,   -0.354339}, {  -1.342833,    0.061096,   -0.354368}, {   0.000853,    0.003356,    0.001676},
			{  -1.848862,   -2.164549,    0.058146}, {   0.003024,   -0.017193,    0.003555}, {   0.082794,   -0.437781,    0.045779}, {   0.006271,    0.004401,    0.005907}, {   0.004364,   -9.932338,    0.007193}, {   0.003722,    0.069091,   -0.539855}, {   0.005781,    0.005392,    0.007737}, {   3.338804,    0.062167,    0.011746},
			{   0.007251,   -9.885620,    0.713948}, {   0.007251,   -9.885620,    0.713948}, {   0.004364,   -9.932338,    0.007193}, {   0.005781,    0.005392,    0.007737}, {  10.025772,   -0.005218,    0.001703}, {  -1.380511,    5.917942,    1.461990}, {  10.025772,   -0.005218,    0.001703}, {   0.006225,   72.469703,    0.000783},
			{   0.005872,    0.490218,    0.000890}, {   0.005872,    0.490218,    0.000890}, {  -0.372292,   -0.373515,    0.539744}, {  -0.372292,   -0.373515,    0.539744}, {   0.640990,   -5.215023,    0.002790}, {  -0.636852,   -5.219607,    0.002790}, {   0.007137,    0.005516,    0.000735}, {   0.006469,    0.009887,    0.004767},
			{   0.006469,    0.010131,    0.004767}, {   0.006469,    0.010131,    0.004767}, {   0.006469,    0.009887,    0.004767}, {   0.008057,    0.005768,    0.004753}, {   0.005005,    0.000548,    0.004767}, {   0.005005,    0.000548,    0.004767}, {   0.005386,    0.003295,    0.004689}, {   0.006717,    0.001616,    0.004689},
			{   0.004180,    0.019485,   -0.046553}, {   0.004180,    0.019485,   -0.046553}, {   0.005764,    0.007244,    0.005322}, {   0.151936,    0.824855,    1.719454}, {  -0.087104,   -0.978006,    1.965419}, {  -0.087104,   -0.978006,    1.965419}, {  12.052177,    9.829261,    1.341269}, {   0.016857,    0.007079,    1.273231},
			{   0.005005,    0.006713,    0.573230}, {   0.005005,    0.006713,    0.573230}, {   0.096619,  -13.012658,    1.208943}, {   0.016857,    0.007079,    1.273231}, {   0.006715,    0.004852,    0.007606}, {   0.006111,    0.002593,    1.341269}, {  12.052177,    9.829261,    1.341269}, {   0.006699,    0.050308,    1.341269},
			{   0.007230,    0.006238,    1.341269}, {  -0.016845,   -0.311787,    1.341269}, {   0.006591,    3.587742,    1.341269}, {   0.004120,    0.007679,    1.273218}, {   0.002945,    0.003866,    0.452906}, {   0.005696,    0.006686,    0.454600}, {   0.002067,    0.001549,    1.273218}, {   0.002148,    0.002247,    1.273218},
			{   0.006225,  -63.316802,    0.000783}, {  27.182693,   -1.849552,   -4.415337}, {  27.182693,   -1.849552,   -4.415337}, {  -0.000457,   -0.248420,   -0.705072}, {  -0.000457,   -0.248420,   -0.705072}, {  25.287914,  -14.328306,   -0.787241}, { -67.154174,    0.020119,   -0.937345}, {  19.374265,   58.123992,   -0.937358},
			{   0.004958,    0.006713,   -0.533349}, {   0.004958,    0.006713,   -0.533349}, {   0.002593,    0.003189,    0.002640}, {   0.002593,    0.003189,    0.002640}, {   0.000419,    0.001399,    0.000648}, {   0.002311,    0.006297,    0.004015}, {  -0.113119,    0.124228,    0.000731}, {   0.002501,    0.007201,    0.001685},
			{   0.000884,    0.006591,    0.185765}, {   0.002166,    0.006775,    0.007736}, {   0.000182,    0.006599,   -2.935544}, {   0.004577,    0.002196,    0.003222}, {   0.003544,    0.002388,    0.001245}, {   0.003544,    0.002388,    0.001245}, {  -0.046822,   -0.187206,    0.000679}, {   0.000048,    0.003677,    0.001017},
			{   0.007385,    0.002746,    0.004048}, {   0.007385,    0.002746,    0.004048}, {   0.006068,    0.007736,    0.007344}, {   0.006068,    0.007736,    0.007344}, {   0.000979,    0.007565,    0.006475}, {   0.000979,    0.007565,    0.006475}, {  -0.452675,    0.447153,    0.004662}, {   0.265442,    0.003742,    1.395988},
			{   0.265442,    0.003742,    1.395988}, {  -0.201745,    0.000872,    1.151749}, {  -0.256511,   -0.369019,    1.150799}, {   0.557431,    0.133395,    1.100666}, {  -0.201745,    0.000872,    1.151749}, {  -0.256511,   -0.369019,    1.150799}, {   0.557431,    0.133395,    1.100666}, {   0.007340,    0.000243,    0.004178},
			{   0.001510,    0.000075,    0.002198}, {   0.002803,    0.006850,    0.001348}, {   0.000237,    0.000829,    0.003473}, {   0.006409,    0.001890,    0.003314}, {   0.000144,    0.025032,    0.458557}, {   0.001464,    0.001973,    0.005754}, {   0.007203,    0.001934,    0.005754}, {   0.001394,    0.004974,    0.006808},
			{   0.004974,    0.001647,    0.007116}, {   0.004767,    0.000714,    0.003035}, {   0.005375,    0.004470,    0.004404}, {   0.392253,   -0.491382,    1.347059}, {  -0.210082,   -0.749406,    0.814254}, {   0.006225,  -63.316802,    0.000783}, {   0.015132,    0.013926,    0.001862}, {   0.015132,    0.013926,    0.001862},
			{   0.014151,    0.010622,    0.001862}, {   0.014151,    0.010622,    0.001862}, {   0.000722,    0.005495,    0.001862}, {   0.000722,    0.005495,    0.001862}, {   0.005605,    0.008670,    0.001862}, {   0.005605,    0.008670,    0.001862}, {  11.798091,  -29.970966,    1.341269}, {   0.000239,    0.002060,    0.000190},
			{   0.002746,    0.000121,    0.000502}, {   0.237844,    0.001973,    0.004095}, {   0.001342,    0.000731,    0.001021}, {   0.000487,    0.001881,   -2.935554}, {  24.220092,    3.296927,    0.000949}, {   0.001705,    0.003634,    0.003899}, {   0.002685,    0.002318,   -0.175955}, {   0.000487,    0.001881,   -2.935554},
			{   0.002990,   -0.064208,    0.001748}, {   0.004639,    0.000792,    0.001847}, {  24.220092,    3.296927,    0.000949}, {   0.001705,    0.003634,    0.003899}, {   0.000029,    0.000125,    0.000000}, {   0.000426,    0.000846,    0.025382}, {   0.002685,    0.002318,   -0.175955}, {   0.002990,   -0.064208,    0.001748},
			{   0.000426,    0.000846,    0.025382}, {   0.003231,    0.003634,    0.003899}, {   0.003112,    0.001891,    0.001817}, {   0.000239,    0.002060,    0.000190}, {   0.002746,    0.000121,    0.000502}, {   0.004639,    0.000792,    0.001847}, {  11.798091,  -29.970966,    1.341269}, {   0.000548,    0.001464,    0.003841},
			{   0.000548,    0.001464,    0.003841}, {   0.004410,    0.004021,    0.007606}, {   0.006165,    0.003234,    0.003273}, {   0.006165,    0.003234,    0.001201}, {  -1.519513,    0.007706,   14.772102}, {   0.006622,    0.004364,    0.000882}, {   0.006622,    0.004364,    0.000882}, {   0.004577,    0.002196,    0.003222},
			{   0.000853,    0.003479,    0.001611}, {  -0.006775,    0.010071,    0.007505}, {   0.001450,    0.003518,    0.007437}, {   0.001450,    0.003518,    0.007437}, {   0.000548,    0.002715,    0.002408}, {   0.000548,    0.002715,    0.002408}, {   0.001647,    0.000304,    0.001643}, {   0.001037,    0.003722,    0.001684},
			{   0.001647,    0.000304,    0.001643}, {   0.001037,    0.003722,    0.001684}, {   0.003819,    0.000675,    0.000056}, {   0.027196,   -0.005733,   -0.305323}, {   0.002040,    0.001704,    0.001887}, {  -1.473968,    0.004395,   -0.549839}, {   0.003905,   -0.001494,   -0.165588}, {   0.006225,    0.005919,   -0.522867},
			{   0.001128,    0.005371,    0.006626}, {   0.005431,    3.374329,    0.003642}, {  -0.023064,    0.000396,    0.004540}, {  -0.079346,    0.001586,   -3.321108}, {   4.696107,    0.001464,    0.000371}, {   0.001830,    0.000976,   23.542840}, {   0.006347,    0.007263,    0.002078}, {   0.362183,    6.309875,    0.002063},
			{   0.002868,   -0.002654,    0.001168}, {   0.016112,    0.004577,    1.379346}, {  -7.958588,    0.002491,    0.000942}, {   0.004333,    0.004761,    0.002219}, {  14.300140,    0.002685,   -0.470687}, {  20.009277,   -0.009491,   -0.741746}, {   2.453916,    0.157714,   -2.313261}, {   0.005005,    0.007201,    0.007416},
			{  -0.008237,    0.006269,    0.742676}, {   0.009398,    0.004821,    8.326690}, {   0.209472,    0.006531,    0.005667}, {  -0.003905,    0.000304,   31.139963}, {   0.005326,    0.002346,    0.006504}, {  -0.003905,    0.000304,   31.139963}, {   0.001830,    0.000976,   23.542840}, {   0.009398,    0.004821,    8.326690},
			{ -10.668691,   -9.990324,   -0.737167}, {   0.012686,    0.006364,    0.002961}, {   0.001821,    0.007110,    0.000182}, {   0.003417,    0.000853,   -0.957877}, {   0.002060,    0.004354,   -0.344828}, {   0.005737,    0.003417,    0.001903}, {   0.003875,   -1.059630,    3.103966}, {   0.005371,    0.003661,    0.002916},
			{   0.001464,    0.004271,    0.001970}, {  -0.091124,    0.005096,    0.238019}, {   0.002074,    0.005065,    0.005408}, {   0.000670,    0.004852,    0.003668}, {   0.003844,    0.004912,    0.003646}, {   0.000121,    0.004821,    0.005431}, {   0.004271,    0.004943,    0.005408}, {  -0.000182,   -0.003402,    0.000228},
			{   0.002990,    0.000579,   -0.020283}, {   0.003570,    0.001832,   -0.437310}, {   0.005123,    0.004619,    0.007722}, {   0.000919,    0.005493,    0.000373}, {   0.000973,    0.005553,    0.000373}, {   0.002224,    0.005890,    0.000205}, {   0.004761,    0.002746,    0.146752}, {   0.002440,    0.006347,    0.040761},
			{   0.006775,    0.002379,   -0.563171}, {   0.000670,    0.008605,   -0.133460}, {  10.000976,    0.005553,   -0.641849}, {   0.002929,    0.003051,    0.146725}, {  19.997680,   10.001586,   -0.481817}, {   0.000976,   -0.007996,    0.005071}, {   0.009398,    0.011962,   -0.122242}, {   0.003905,    0.003173,   -0.209609},
			{   0.002929,    0.009216,   -0.132833}, {   0.006103,    0.004395,    0.001664}, {   0.003661,   -1.438416,    0.040752}, {   1.474243,    0.004517,    0.444970}, {   0.002685,    0.006622,    0.040750}, {  -0.000853,    0.006653,    0.146724}, {   0.001586,    0.006531,   -0.511162}, {   0.000853,   -0.704833,    0.040766},
			{   0.006591,    0.004699,   -0.478509}, {  -0.078491,    0.003295,   -0.496883}, {  -0.002990,   -0.000731,   -0.194554}, {   0.122680,    0.005371,    0.006213}, {   0.033787,    0.176880,   -0.423047}, {   0.005859,    0.022216,   -0.375090}, {   0.007079,    0.003417,   -0.251792}, {  -0.007201,    0.005553,   -0.250108},
			{   0.007567,    0.011292,   -1.825338}, {   5.074340,    3.387450,    1.770753}, {   0.000121,    0.457489,    0.002683}, {   0.008057,    0.002196,   -0.300613}, {   0.007201,    0.005249,    1.022838}, {  -0.020751,   30.002746,   -0.112455}, {   0.003356,    0.022704,    0.021061}, {   2.498779,    0.002396,   -0.155211},
			{   0.006713,    0.002013,   -0.510095}, {   0.006835,    0.006531,    0.137345}, {   0.014159,    0.001220,    0.146700}, {   0.000243,    0.002135,    0.040755}, {   0.008789,   -0.163651,   -0.081743}, {  -0.014523,    0.003142,   -0.081722}, {   0.000976,   -0.007996,    0.005071}, {   0.003661,   -1.438416,    0.040752},
			{   0.002440,    0.002196,    0.002085}, {   0.007629,    0.004943,   -0.357401}, {   0.004641,    0.030197,   -0.406185}, {   0.260324,    0.000609,    0.002118}, {  -0.040894,   18.999694,   -0.095274}, {   0.005034,    0.000701,   -0.777437}, {   2.501404,    0.018494,    0.712862}, {   0.005553,    0.002868,    0.004102},
			{   2.824889,    0.001830,    0.002664}, {   0.006500,    0.002562,   -0.378194}, {   0.007420,    0.001769,    0.001112}, {   0.280577,    0.587589,   -0.014313}, {   0.135946,   -0.294160,   -0.014945}, {   0.004100,    0.004935,   -0.045382}, {   0.087920,    0.083370,    0.003331}, {   0.001952,    0.006469,   -0.320203},
			{   0.002074,    0.000915,   -0.274423}, {  -0.025382,    0.001488,    4.802177}, {  -0.013306,    0.290343,    0.559724}, {   0.001708,    0.002624,    0.559727}, {  -1.523926,    0.002654,   -0.267735}, {   0.006391,    0.006674,    0.003869}, {   0.007588,    0.000753,    0.004410}, {   0.002196,    0.005797,    0.001595},
			{   0.005615,    1.787994,    0.001595}, {   0.005065,    0.005615,    0.001595}, {   0.004668,    0.017090,    0.001595}, {   0.042479,   -0.004180,    0.002285}, {   0.003875,    0.025268,    0.007426}, {   0.028341,    1.787832,    0.001595}, {   0.003539,   20.006988,   -0.684754}, {  30.006835,   20.015197,   -0.835049},
			{   0.010315,    0.016510,    0.040686}, {   0.006469,    0.005843,    0.003434}, {   0.000243,    0.000000,   -0.491780}, {   0.024048,    0.000335,    0.129693}, {   0.004668,    0.007104,    0.000791}, {  -0.000243,   -0.018982,   -0.246400}, {   0.001281,    0.000243,   -0.322943}, {   0.001952,    0.004333,    0.004327},
			{   0.001342,   -0.074065,   -0.321539}, {   0.000976,   -0.068572,   -1.341750}, {   0.003905,    0.003753,   -0.558363}, {   0.001952,    0.008484,   -0.992179}, {  -0.125976,    0.007751,   -0.322876}, {  -0.123047,   -0.046386,   -0.321538}, {   0.002807,    0.003661,    0.003794}, {   0.004639,    0.004271,    0.001968},
			{   0.006713,    0.001830,    0.001968}, {   0.000243,    0.001647,   -0.611804}, {   0.001952,    0.003112,    0.006457}, {   0.001525,    0.011261,   -0.476597}, {   0.001464,    0.008605,   -1.631212}, {  -9.996826,    0.010254,    0.001919}, {   0.006091,    0.002339,    0.001533}, {   0.001842,    0.001321,   -0.002596},
			{   0.006591,    0.007371,    0.005826}, {   0.011300,    0.009643,    0.005826}, {  12.855590,   12.242675,   -0.413807}, {   0.007079,    0.001830,   -0.145117}, {  -0.051757,   -0.042419,   -0.330219}, {   0.003783,   -0.008759,   -0.216358}, {   0.003905,    0.005096,   -0.496625}, {   0.003539,    0.002277,    0.146706},
			{  -0.003626,   -0.000647,    0.002500}, {  -0.003345,    0.000174,    0.004716}, {  -0.006835,    0.006082,    0.002418}, {  -0.004395,    0.004573,   -1.634191}, {  -0.002072,    0.009726,    0.007147}, {  -0.004149,    0.000507,    0.002254}, {   0.006572,    0.007257,    0.001418}, {   0.004275,   -0.006684,    0.002505},
			{  -0.109779,    0.005431,   -0.128170}, {   0.003905,    0.004093,    0.004978}, {  -0.012361,    0.003747,    0.001875}, {   0.024427,    0.005750,   -0.035794}, {   0.001156,    0.002614,    0.001137}, {   0.007321,    0.007093,    0.003459}, {   0.000241,    0.006965,    0.003459}, {   0.006225,   -0.000365,    0.001841},
			{   0.000853,    0.000624,    0.000151}, {   0.005646,    0.004149,   -0.329813}, {   0.005005,    0.012416,    0.005071}, {   0.006124,    0.000387,    0.002505}, {   0.005615,    0.000090,    0.001215}, {   0.001952,    0.001281,   -0.170398}, {   0.002583,    0.001379,   -0.208379}, {  -0.001688,    0.007170,   -0.242416},
			{  -0.005882,    0.010871,   -0.203390}, {   0.892812,    0.003886,    0.339920}, {   0.009262,    0.005272,    0.223923}, {   0.001429,    0.005055,    0.107088}, {   0.002513,   -0.063603,    0.007058}, {   0.007629,    0.000011,   -0.210243}, {   0.008937,    0.001464,    0.007292}, {   4.137874,    0.002083,   -0.071396},
			{   0.007627,    0.001245,    0.086613}, {   0.112576,    0.046806,   -0.195075}, {   4.121922,   -0.004457,   -1.039499}, {   0.007639,    0.001041,    0.086615}, {   3.357131,    0.053654,    0.000581}, {   0.005448,    0.004889,   -0.192191}, {   0.003216,    7.139076,    0.006302}, {   0.003074,    0.007079,    0.007155},
			{   0.005547,    0.006564,    0.007639}, {   0.001052,   -1.668243,   -0.030525}, {   0.005493,    0.106201,   -0.257661}, {   0.003051,    0.006316,   -0.193895}, {   0.003905,    0.005065,   -0.208371}, {  -0.006171,    0.024639,   -0.094994}, {   0.002807,    0.006287,    0.006804}, {   0.031381,    0.007375,    0.006523},
			{   0.001732,    0.002651,    0.000376}, {   0.000262,    0.005340,    0.253529}, {   0.002968,    0.002457,   -0.319637}, {  12.099573,    1.508456,    0.007029}, {   0.001433,    0.010329,    0.011017}, {   0.001447,    0.002150,    0.003624}, {  -0.002990,   -0.000731,   -0.194554}, {   0.001586,    0.006531,   -0.511162},
			{   2.498779,    0.002396,   -0.155211}, {   0.003905,    0.003173,   -0.209609}, {  -0.014523,    0.003142,   -0.081722}, {  -0.000853,    0.006653,    0.146724}, {   0.003539,    0.002277,    0.146706}, {   0.009398,    0.011962,   -0.122242}, {   0.002685,    0.006622,    0.040750}, {   0.005129,    0.005671,    0.000269},
			{   0.004416,    0.006283,    0.000269}, { -14.994140,    0.005005,   -0.563171}, { -14.993774,    0.004883,   -0.563196}, {   0.004883,    0.005737,   -0.563197}, {   0.006347,    0.002013,   -0.009854}, {  -0.057879,    0.000234,    0.003528}, {  -0.001556,   -0.059317,    0.003599}, {   0.000111,   -0.061200,    0.001021},
			{  -0.696949,    1.329710,   -0.767895}, {   0.003050,    0.006469,    0.007627}, {   0.001193,    0.002196,    0.001010}, {   0.003620,    0.004699,    0.007139}, {   0.008368,    0.011312,    0.010130}, {   0.009766,    0.005435,    0.013234}, {   0.005545,    0.000258,   -0.743125}, {  -0.007705,   -0.010576,    0.006138},
			{   0.000976,    0.000243,    0.000345}, {   0.000004,    0.005615,   -0.349469}, {   0.642455,   -1.977965,   -0.035023}, {  -0.634276,   -0.917968,   -0.208235}, {   2.647460,    2.217102,   -0.097064}, {   0.007079,    0.003051,    0.036669}, {   0.000000,    0.001769,    0.036669}, {   0.000731,    0.005859,    0.036669},
			{   0.002807,   10.005542,    0.000311}, {   0.005859,   10.003662,    0.000311}, {   0.005127,   10.004928,    0.000311}, {   0.000487,    0.007323,    4.148332}, {  -0.010010,    0.003905,   -0.694653}, {  -0.000853,    0.001701,    0.005080}, {   0.002440,    0.006165,    0.040748}, {   0.002444,    0.002182,    0.002785},
			{   0.005528,    0.006502,    0.004038}, {   0.005615,    0.006347,    0.001042}, {   0.006835,    0.005710,    0.005169}, {   0.004050,    0.000719,   -0.279366}, {   0.005783,    0.003680,    0.003643}, {   0.048285,    0.006225,    0.007075}, {   0.000537,    0.046725,    0.002610}, {   0.005493,    0.044222,    0.007075},
			{   0.004404,   -0.035367,    0.007075}, {   0.007352,   -0.040376,    0.007073}, {   0.003920,    0.004333,    0.000656}, {  -0.000261,    0.110096,    0.001750}, {  -0.039861,    0.086415,   -0.039138}, {  -0.091643,   -0.201995,    0.120206}, {   0.000976,    0.001952,    0.003861}, {   0.000731,   -0.002410,   -0.817098},
			{   0.002730,    0.002241,    0.005284}, {   0.004879,    0.060495,    0.000270}, {   0.005731,    0.003459,   -0.000151}, {   0.003682,    0.003841,    0.000973}, {   0.009398,    0.002691,    0.006879}, {   0.019286,    0.006372,    0.001894}, {  -0.003895,    0.005973,    0.000165}, {   0.004813,    0.003512,    0.205208},
			{  -0.001350,    0.010863,   -0.139458}, {   0.001219,    0.007542,    0.005169}, {   0.003025,    0.001341,    0.000660}, {   0.001317,    0.000975,    0.005169}, {   0.002047,    0.004143,    0.002796}, {   0.004149,    0.002440,    0.001042}, {   0.004064,    0.002596,    0.004038}, {   0.004435,    0.005491,    0.002961},
			{  -0.000243,    0.001632,    0.004858}, {  -0.225218,   -0.012915,    0.005634}, {   0.002566,    0.002727,    0.005634}, {   0.006074,    0.006771,    0.002028}, {   0.004395,    0.006895,   -1.213929}, {  -0.009398,    0.011657,   -0.292551}, {  -0.014893,    0.006438,   -0.030419}, {   0.006666,    0.005187,    0.004112},
			{   0.004579,    0.006310,    0.002471}, {   0.001296,    0.002950,    0.002245}, {   0.005547,    0.006498,    0.002362}, {   0.005547,    0.001981,    0.002328}, {   0.001043,    0.006082,    0.002205}, {   0.003611,    0.004891,    0.001903}, {   0.003284,    0.003792,    0.001627}, {   0.007383,   -0.001440,   -0.251448},
			{   0.000012,    0.000870,   -0.782727}, {   0.006932,    0.005251,   -0.257129}, {   0.002440,    0.002196,    0.002085}, {   0.004641,    0.030197,   -0.406185}, {   0.005737,    0.003417,    0.001903}, {   0.003875,   -1.059630,    3.103966}, {   0.000539,    0.006566,    0.003869}, {   0.003905,   -0.001494,   -0.165588},
			{   0.006225,    0.005919,   -0.522867}, {   0.005431,    3.374329,    0.003642}, {   0.001128,    0.005371,    0.006626}, {   0.005034,    0.000701,   -0.777437}, {   0.006500,    0.002562,   -0.378194}, {  -0.079346,    0.001586,   -3.321108}, {   2.824889,    0.001830,    0.002664}, {   0.007420,    0.001769,    0.001112},
			{   0.004813,    0.003512,    0.205208}, {  -0.013306,    0.290343,    0.559724}, {   0.003051,    0.003344,    0.003077}, {   0.008368,    0.011312,    0.010130}, {   4.696107,    0.001464,    0.000371}, {   0.024427,    0.005750,   -0.035794}, { -10.546936,    5.824921,   28.479677}, { -10.546936,    5.824921,   28.479677},
			{   0.003417,    0.000853,   -0.957877}, {  -0.000182,   -0.003402,    0.000228}, {   0.005448,    0.004889,   -0.192191}, {  -0.005882,    0.010871,   -0.203390}, {  -0.001688,    0.007170,   -0.242416}, {   0.892812,    0.003886,    0.339920}, {   0.007383,   -0.001440,   -0.251448}, {   0.000012,    0.000870,   -0.782727},
			{   0.002224,    0.005890,    0.000205}, {   0.031381,    0.007375,    0.006523}, {   0.009262,    0.005272,    0.223923}, {   0.001952,    0.001281,   -0.170398}, {   0.002583,    0.001379,   -0.208379}, {   0.001429,    0.005055,    0.107088}, {   0.004050,    0.000719,   -0.279366}, {   0.000919,    0.005493,    0.000373},
			{   0.006074,    0.006771,    0.002028}, {   0.002990,    0.000579,   -0.020283}, {   0.003216,    7.139076,    0.006302}, {   0.003074,    0.007079,    0.007155}, {   0.005547,    0.006564,    0.007639}, {   0.001052,   -1.668243,   -0.030525}, {   0.002444,    0.002182,    0.002785}, {   0.002047,    0.004143,    0.002796},
			{   0.003570,    0.001832,   -0.437310}, {  -0.006835,    0.006082,    0.002418}, {  -0.003345,    0.000174,    0.004716}, {  -0.003626,   -0.000647,    0.002500}, {   4.121922,   -0.004457,   -1.039499}, {   4.137874,    0.002083,   -0.071396}, {  -0.004395,    0.004573,   -1.634191}, {   0.112576,    0.046806,   -0.195075},
			{   5.074340,    3.387450,    1.770753}, {   0.000121,    0.457489,    0.002683}, {   0.003356,    0.022704,    0.021061}, {  -0.020751,   30.002746,   -0.112455}, {  -0.025382,    0.001488,    4.802177}, {   2.501404,    0.018494,    0.712862}, {   0.002135,    2.305237,    0.000569}, {   0.000976,    0.001952,    0.003861},
			{  -0.009398,    0.011657,   -0.292551}, {   0.008057,    0.002196,   -0.300613}, {   0.024048,    0.000335,    0.129693}, {  -0.001350,    0.010863,   -0.139458}, {   0.033787,    0.176880,   -0.423047}, {   0.007079,    0.003417,   -0.251792}, {   0.006591,    0.004699,   -0.478509}, {   0.010315,    0.016510,    0.040686},
			{   0.003539,   20.006988,   -0.684754}, {  30.006835,   20.015197,   -0.835049}, {   0.000731,   -0.002410,   -0.817098}, {  -0.109779,    0.005431,   -0.128170}, {   0.003905,    0.004093,    0.004978}, {  -0.007201,    0.005553,   -0.250108}, {   0.005859,    0.022216,   -0.375090}, {   0.122680,    0.005371,    0.006213},
			{  -0.000243,    0.001632,    0.004858}, {   0.004435,    0.005491,    0.002961}, {   0.004761,    0.002746,    0.146752}, {   0.001464,    0.008605,   -1.631212}, {  -0.000853,    0.001701,    0.005080}, {   0.002585,    0.021475,   -0.272724}, {   0.000243,    0.001647,   -0.611804}, {   0.001525,    0.011261,   -0.476597},
			{   0.000243,    0.000000,   -0.491780}, {  -0.014893,    0.006438,   -0.030419}, {   0.006347,    0.007263,    0.002078}, {   0.006347,    0.002013,   -0.009854}, {   0.005545,    0.000258,   -0.743125}, {  -0.040894,   18.999694,   -0.095274}, {   0.260324,    0.000609,    0.002118}, {   0.005646,    0.004149,   -0.329813},
			{   0.005005,    0.012416,    0.005071}, {   0.003905,    0.005096,   -0.496625}, {   0.003905,    0.005065,   -0.208371}, {   0.003783,   -0.008759,   -0.216358}, {   0.003051,    0.006316,   -0.193895}, {   0.005493,    0.106201,   -0.257661}, {   0.007079,    0.001830,   -0.145117}, {  -0.051757,   -0.042419,   -0.330219},
			{  12.855590,   12.242675,   -0.413807}, {   0.000976,    0.000243,    0.000345}, {   0.000004,    0.005615,   -0.349469}, {   0.000487,    0.007323,    4.148332}, {   0.007079,    0.003051,    0.036669}, {   0.642455,   -1.977965,   -0.035023}, {   0.000000,    0.001769,    0.036669}, {   2.647460,    2.217102,   -0.097064},
			{   0.000731,    0.005859,    0.036669}, {   0.002807,   10.005542,    0.000311}, {   0.005859,   10.003662,    0.000311}, {   0.005615,    0.000090,    0.001215}, {  -0.012361,    0.003747,    0.001875}, {  14.300140,    0.002685,   -0.470687}, {  -7.958588,    0.002491,    0.000942}, {   0.002379,    0.004639,    0.002211},
			{   0.003844,    0.004912,    0.003646}, {   0.362183,    6.309875,    0.002063}, {   0.002868,   -0.002654,    0.001168}, {   0.001821,    0.007110,    0.000182}, {   0.012686,    0.006364,    0.002961}, {  20.009277,   -0.009491,   -0.741746}, {   0.001952,    0.006469,   -0.320203}, {   0.002074,    0.000915,   -0.274423},
			{   0.087920,    0.083370,    0.003331}, {  -9.996826,    0.010254,    0.001919}, {   0.005123,    0.004619,    0.007722}, {   0.002196,    0.005797,    0.001595}, {   0.006469,    0.005843,    0.003434}, {   0.003875,    0.025268,    0.007426}, {   0.042479,   -0.004180,    0.002285}, {  -0.023064,    0.000396,    0.004540},
			{  -0.115478,   -0.122192,   -0.301243}, {   0.005872,    0.004517,    0.007313}, {   0.005872,    0.002990,    0.007313}, {   0.005872,    0.000853,    0.007313}, {   0.005872,    0.007263,    0.006285}, {   0.001342,   -0.074065,   -0.321539}, {   0.000976,   -0.068572,   -1.341750}, {  -0.170653,    0.033325,    0.184774},
			{  -1.314056,    2.515141,    0.684154}, {   0.002088,    0.005257,    0.006018}, {   0.007042,    0.000828,   -0.109355}, {   0.000364,    0.003625,    0.000723}, {  -0.676322,   -8.213012,    0.006200}, {   0.000361,    0.000430,    0.003568}, {   0.004695,    0.005340,    0.005597}, {   0.001952,    0.005117,    0.001108},
			{   0.003990,    0.001797,    0.005863}, {   0.003855,    0.006484,    0.004546}, {   0.006639,    0.007615,    0.003755}, {   0.016623,   -0.007337,    0.000096}, {   0.002171,   20.023223,    0.712643}, {  -0.264598,    0.089465,    0.073811}, {   0.002345,   -1.367733,    0.002144}, {   0.002171,   20.023223,    0.712643},
			{  -0.264598,    0.089465,    0.073811}, {  -8.792711,   -3.324553,    0.005319}, {   0.000106,    0.007617,   -0.113150}, {   0.031704,   -0.002929,   -0.003354}, {   0.006759,    0.002630,    0.005793}, {   0.023987,   -0.005834,   -0.003343}, {   0.023985,   -0.004858,   -0.003354}, {   0.026576,   -0.002929,   -0.003354},
			{   0.023606,   -0.005830,   -0.003354}, {   0.002318,   -5.773314,    0.007490}, {   0.003905,   -0.027892,   -2.201301}, {   0.001808,   -1.545722,   -0.319036}, {  -0.002098,   -0.006450,   -0.013749}, {   0.001808,   -1.545722,   -0.319036}, {   0.002318,   -5.773314,    0.007490}, {  -0.002098,   -0.006450,   -0.013749},
			{   0.003905,   -0.027892,   -2.201301}, {   0.023982,   -0.008275,   -0.003354}, {   0.023631,   -0.010540,   -0.003354}, {   1.207115,    0.005925,    0.012973}, {   0.144427,   -0.282220,   -0.201280}, {   0.005688,    0.003352,    0.000163}, {   0.001120,    0.006903,   -0.111662}, {   0.006866,    0.001973,    0.003726},
			{ -15.818115,  -12.253417,    2.404141}, {   0.005371,    0.004395,    0.001876}, {   0.002679,    0.007644,    0.002253}, {   0.003417,    0.005127,    0.005727}, {   0.005224,    0.001060,    0.006105}, {   0.005377,    0.002807,    0.006953}, {   0.000396,    0.001388,    0.007329}, {   0.013427,    0.000365,    0.008530},
			{   0.005698,    0.006374,    0.006130}, {   0.003051,    0.003344,    0.003077}, {   0.244994,    0.004089,    0.004339}, {  -0.408767,   -0.318659,    0.005934}, {   4.603085,   -0.243681,    0.005934}, {  -0.135015,   -0.091677,    0.005934}, {  -0.148688,   -0.096193,    0.005934}, {   0.002318,    0.005692,    0.000923},
			{   0.002318,    0.000234,    0.000923}, {   4.884307,   -0.297399,   -0.043650}, {   0.001464,    0.004271,    0.001970}, {   0.004639,    0.004271,    0.001968}, {   0.006713,    0.001830,    0.001968}, {   0.001156,    0.002614,    0.001137}, {   0.000853,   -0.704833,    0.040766}, {   0.000670,    0.008605,   -0.133460},
			{   0.001281,    0.000243,   -0.322943}, {   0.001952,    0.004333,    0.004327}, {  -0.000243,   -0.018982,   -0.246400}, {   0.003905,    0.003753,   -0.558363}, {   0.001952,    0.008484,   -0.992179}, {  -0.125976,    0.007751,   -0.322876}, {  -0.123047,   -0.046386,   -0.321538}, {  -0.115478,   -0.122192,   -0.301243},
			{  -0.078491,    0.003295,   -0.496883}, {   0.008789,   -0.163651,   -0.081743}, {   0.002929,    0.009216,   -0.132833}, {   0.006103,    0.004395,    0.001664}, {  19.997680,   10.001586,   -0.481817}, {  10.000976,    0.005553,   -0.641849}, {   0.002440,    0.006347,    0.040761}, {   0.002440,    0.006165,    0.040748},
			{   0.006713,    0.002013,   -0.510095}, {   0.006835,    0.006531,    0.137345}, {   0.002929,    0.003051,    0.146725}, {   0.000243,    0.002135,    0.040755}, {   0.014159,    0.001220,    0.146700}, {   0.004883,    0.005737,   -0.563197}, { -14.993774,    0.004883,   -0.563196}, { -14.994140,    0.005005,   -0.563171},
			{   0.006775,    0.002379,   -0.563171}, {   0.004668,    0.007104,    0.000791}, {   0.000973,    0.005553,    0.000373}, {  -1.523926,    0.002654,   -0.267735}, {   0.244994,    0.004089,    0.004339}, {   0.028341,    1.787832,    0.001595}, {   0.005615,    1.787994,    0.001595}, {   0.005065,    0.005615,    0.001595},
			{   0.004668,    0.017090,    0.001595}, {   0.001708,    0.002624,    0.559727}, {   0.006639,    0.007615,    0.003755}, {   0.001952,    0.005117,    0.001108}, {   0.006713,    0.001305,    0.001686}, {   0.006713,    0.001305,    0.001686}, {   0.006932,    0.005251,   -0.257129}, {   0.004333,    0.004761,    0.002219},
			{   0.004333,    0.004761,    0.002219}, {   0.000670,    0.004852,    0.003668}, {  -0.091124,    0.005096,    0.238019}, {   0.016112,    0.004577,    1.379346}, {   0.005127,    0.007323,    0.007706}, {   0.007079,    0.007323,    0.007706}, {   0.000731,    0.004896,    0.007706}, {   0.000243,    0.004896,    0.007706},
			{   0.006103,    0.004896,    0.007706}, {   0.005528,    0.006502,    0.004038}, {   0.004064,    0.002596,    0.004038}, {   0.001035,    0.006213,    0.000381}, {   0.006843,   -0.002703,    0.003258}, {   0.003850,   -0.088003,   -0.263235}, {   1.207115,    0.005925,    0.012973}, {   0.001120,    0.006903,   -0.111662},
			{   0.005688,    0.003352,    0.000163}, {   0.006866,    0.001973,    0.003726}, {   0.022907,   -0.039935,   -0.847407}, {   0.006151,    0.395061,    0.004856}, {   0.022907,   -0.039935,   -0.847407}, {  -0.004670,    0.006118,    0.006785}, {   0.001035,    0.006213,    0.000381}, {   0.007507,    0.000123,    0.001225},
			{   4.603085,   -0.243681,    0.005934}, {  -0.135015,   -0.091677,    0.005934}, {  -0.148688,   -0.096193,    0.005934}, {  -0.408767,   -0.318659,    0.005934}, {  -8.792711,   -3.324553,    0.005319}, {   0.000106,    0.007617,   -0.113150}, {   0.006572,    0.007257,    0.001418}, {   0.005127,   10.004928,    0.000311},
			{  -0.634276,   -0.917968,   -0.208235}, {   0.003250,    0.004585,    0.005785}, {   0.001842,    0.001321,   -0.002596}, {   0.001193,    0.002196,    0.001010}, {   0.007201,    0.005249,    1.022838}, {   1.474243,    0.004517,    0.444970}, {  -0.696949,    1.329710,   -0.767895}, {   0.006091,    0.002339,    0.001533},
			{   0.004476,   -0.014934,    0.005233}, {   0.004100,    0.004935,   -0.045382}, {   0.005371,    0.003661,    0.002916}, {   0.006103,   -0.616795,    0.001811}, {   0.006103,    0.690397,    0.001811}, {   0.005979,    0.007459,    0.004461}, {  -0.007449,    0.020719,   -0.000377}, {   0.000243,    0.005737,    0.004364},
			{   0.048285,    0.006225,    0.007075}, {   0.004404,   -0.035367,    0.007075}, {   0.007352,   -0.040376,    0.007073}, {   0.000537,    0.046725,    0.002610}, {   0.005493,    0.044222,    0.007075}, {   0.005493,    0.000030,    0.005189}, {   0.006847,    0.007015,    0.001363}, {   0.001475,    0.002742,    0.003644},
			{  -0.039861,    0.086415,   -0.039138}, {   0.003920,    0.004333,    0.000656}, {  -0.091643,   -0.201995,    0.120206}, {  -0.000261,    0.110096,    0.001750}, {   0.002730,    0.002241,    0.005284}, {   0.004879,    0.060495,    0.000270}, {   0.003682,    0.003841,    0.000973}, {   0.005731,    0.003459,   -0.000151},
			{   0.021099,   -0.004027,    0.023129}, {   0.021630,   -0.002275,    0.023129}, {   0.015506,   -0.019463,    0.015323}, {   0.020702,   -0.003203,    0.023129}, {   0.322894,   -0.003173,   -0.030037}, {   0.008936,   -0.003539,    0.023072}, {  -0.002758,    0.009643,    0.015297}, {   1.322268,    0.000747,    0.023078},
			{  -0.059689,    0.009766,    0.015310}, {   0.021099,   -0.004027,    0.023129}, {   0.021630,   -0.002275,    0.023129}, {   0.015506,   -0.019463,    0.015323}, {   0.020702,   -0.003203,    0.023129}, {   0.322894,   -0.003173,   -0.030037}, {   0.008936,   -0.003539,    0.023072}, {  -0.002758,    0.009643,    0.015297},
			{   1.322268,    0.000747,    0.023078}, {  -0.059689,    0.009766,    0.015310}, {   0.000243,    0.005737,    0.004364}, {   0.002147,    0.136228,    0.005814}, {   0.003959,    0.002947,    0.006860}, {   4.907370,  -10.003349,   -0.057590}, {  -4.822505,   -9.993164,    0.149561}, {   0.104682,    0.009262,   -0.334726},
			{  -0.090810,    0.015838,   -0.266023}, {   0.007734,    0.000602,    0.000998}, {  -5.016173,   -9.840087,   -0.005869}, {   0.233809,   -0.099605,   -0.191660}, {  -0.094062,   -0.104873,   -0.353931}, {   0.007490,    0.004561,    0.007364}, {   0.006043,   -0.081940,    0.001441}, {   0.005936,   -0.005042,    0.001445},
			{   0.001316,   -0.006004,    0.003645}, {   0.000277,    0.000922,    0.004871}, {  -0.523150,   -1.407760,    0.003266}, {   0.003719,    0.005981,    0.000269}, {   0.003305,    6.525107,    0.866946}, {  -0.483704,    0.005843,    4.876582}, {  -0.483704,    0.005843,    4.876582}, {   0.003417,    0.004455,   -0.216003},
			{   0.003417,    0.004455,   -0.216003}, {   0.003417,    0.006103,    0.003662}, {   0.005127,    0.005088,    0.002763}, {   0.001357,    0.006248,    0.001785}, {   0.027774,    0.073223,    0.006126}, {   0.144738,    0.032056,    0.001413}, {   0.006641,    0.041473,    0.001869}, {   0.002396,    0.004552,    0.748893},
			{   0.027774,    0.073223,    0.006126}, {   0.144738,    0.032056,    0.001413}, {   0.006641,    0.041473,    0.001869}, {   0.002396,    0.004552,    0.748893}, {   0.006591,    0.001952,   -0.592431}, {   0.006591,    0.001952,   -0.592431}, {   0.006699,    0.001549,    0.002801}, {   0.004414,    0.004509,    0.003330},
			{   0.004100,    0.027729,    0.337642}, {   0.006591,    0.001159,    0.002961}, {   0.006699,    0.001549,    0.002801}, {   0.004414,    0.004509,    0.003330}, {   0.004100,    0.027729,    0.337642}, {   0.006591,    0.001159,    0.002961}, {   0.002585,    0.021475,   -0.272724}, {   0.002060,    0.004354,   -0.344828},
			{   0.004189,    0.003426,    0.002961}, {   0.005127,    0.006676,   -0.278039}, {   0.002440,    0.001952,   -0.416274}, {   0.002440,    0.001952,   -0.416274}, {   0.005127,    0.006676,   -0.278039}, {   0.004189,    0.003426,    0.002961}, {   0.000055,    0.002292,    0.003869}, {   0.006403,    0.002289,    0.003869},
			{   0.000539,    0.006566,    0.003869}, {   0.006403,    0.002289,    0.003869}, {   0.000055,    0.002292,    0.003869}, {   0.006391,    0.006674,    0.003869}, { -11.583007,    0.001464,    0.001577}, { -11.583007,    0.001464,    0.001577}, {   0.001586,   -0.038594,    0.000548}, {   0.001586,   -0.038594,    0.000548},
			{   0.002685,    0.004333,    0.003671}, {   0.002685,    0.004333,    0.003671}, {   0.003850,   -0.088003,   -0.263235}, {   0.144058,    0.004360,    0.002317}, {   0.144058,    0.004360,    0.002317}, {   0.144427,   -0.282220,   -0.201280}, {   0.005431,    0.000627,    0.000151}, {   0.002322,    0.003439,    0.000136},
			{   0.005712,    0.004656,    0.002584}, {   0.007042,    0.003898,    0.006506}, {   0.000434,    0.004029,    0.000864}, {   0.000434,    0.004029,    0.000864}, {  -0.003895,    0.005973,    0.000165}, {   0.014568,   -0.005247,    0.004007}, { -13.861816,    0.004395,  -19.603691}, { -13.861816,    0.004395,  -19.603691},
			{ -13.861816,    0.004395,  -19.603691}, { -13.861816,    0.004395,  -19.603691}, {   0.007507,    0.000123,    0.001225}, {   0.003409,   -0.460572,    0.003660}, {   0.004395,    0.004455,   41.339550}, {   0.004395,    0.004455,   41.339550}, {   0.004395,    0.004455,   41.339550}, {   0.004395,    0.004455,   41.339550},
			{  -0.079346,    0.001586,   -3.321108}, {  -0.079346,    0.001586,   -3.321108}, {   0.005508,    0.000792,    0.002420}, {  -1.314056,    2.515141,    0.684154}, {   0.000226,   -0.004352,    0.004871}, {   0.001296,   -0.075549,    0.028307}, {   0.005872,   -0.074460,    0.001445}, {   0.005845,   -0.112609,    0.001441},
			{   0.005936,   -0.039131,    0.007364}, {   0.001342,    0.000670,    0.004044}, {   0.004476,   -0.014934,    0.005233}, {   0.002440,    0.002013,   -0.191772}, {   0.005309,    0.004883,   -0.745114}, {  15.005310,    0.004883,   -0.612764}, {  12.517822,    0.004883,   -0.312974}, {  -0.000121,    0.006347,   -0.237974},
			{   0.001220,   -0.000030,    0.001580}, {   0.006790,    0.002819,   18.678472}, {   1.414543,    2.562278,   -1.578397}, {   0.007519,    0.005057,    0.003333}, {   0.054676,    0.001765,    0.006655}, { -19.897933,    0.005421,    0.001859}, {   0.005851,    0.000257,    0.004670}, {   0.122651,   -0.127648,    0.002049},
			{   0.006831,    0.006564,    0.004567}, {   0.001539,    0.000128,    0.000108}, {   0.005508,    0.000792,    0.002420}, {   0.002566,    0.004999,    0.007581}, {   0.007617,    0.013710,    0.005936}, {   0.007617,    0.013710,    0.005936}, {   0.001357,    0.006248,    0.001785}, {   0.007567,    0.004538,    0.007672},
			{   0.002135,    0.001845,    0.002372}, {   0.004149,    0.006659,    0.006099}, {   0.001464,    0.005057,    0.006103}, {   0.004271,    0.003220,    0.006115}, {   0.005355,    0.003776,    0.007732}, {   0.007567,    0.004538,    0.007672}, {   0.002135,    0.001845,    0.002372}, {   0.004149,    0.006659,    0.006099},
			{   0.001464,    0.005057,    0.006103}, {   0.004271,    0.003220,    0.006115}, {   0.005355,    0.003776,    0.007732}, {   0.003305,    6.525107,    0.866946}, {  15.005310,    0.004883,   -0.612764}, {  12.517822,    0.004883,   -0.312974}, {   0.000365,    0.005218,   -0.558366}, {   0.000365,    0.005218,   -0.558366},
			{   0.006926,    0.006597,    0.002619}, {   0.000118,    0.007222,    0.003320}, {   0.002433,    0.002017,   -0.890546}, {  -0.000121,    0.006347,   -0.237974}, {   0.005309,    0.004883,   -0.745114}, {   0.007567,    0.011292,   -1.825338}, {   0.005127,    0.005088,    0.002763}, {  -0.429578,  -11.093683,    2.313369},
			{   0.001220,   -0.000030,    0.001580}, {   0.002440,    0.002013,   -0.191772}, {   0.002379,    0.004639,    0.002211}, {   0.004333,    0.004761,    0.002219}, {   0.005127,    0.007323,    0.007706}, {   0.007079,    0.007323,    0.007706}, {   0.000731,    0.004896,    0.007706}, {   0.000243,    0.004896,    0.007706},
			{   0.006103,    0.004896,    0.007706}, {   0.005783,    0.005013,    0.007257}, {   0.005783,    0.005013,    0.007257}, {   0.003992,    0.003033,    0.007257}, {   0.003992,    0.003033,    0.007257}, {   0.002135,    2.305237,    0.000569}, {  -0.170653,    0.033325,    0.184774}, {   0.004180,    0.004168,    0.000159},
			{   0.233809,   -0.099605,   -0.191660}, {   0.007734,    0.000602,    0.000998}, {  -5.016173,   -9.840087,   -0.005869}, {  -0.094062,   -0.104873,   -0.353931}, {   0.104682,    0.009262,   -0.334726}, {   4.907370,  -10.003349,   -0.057590}, {  -4.822505,   -9.993164,    0.149561}, {  -0.090810,    0.015838,   -0.266023},
			{   1.500738,    3.942497,   -0.604914}, {   1.500484,    3.934885,   -0.604914}, {   1.500576,    3.934885,   -0.604914}, {   1.507912,    3.933029,   -0.604914}, {  -0.000325,   -0.003435,    0.010797}, {   1.497702,    3.931900,   -0.604914}, {   0.007474,    0.005712,    0.010797}, {   0.006085,   -0.003500,    0.010797},
			{  -0.011669,   -0.000060,    2.036130}, {  -0.006732,    0.008147,    2.036130}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.002074,    0.007209,   -1.810711}, {  -0.000083,    0.002318,    0.001540}, {   0.000415,    1.316787,    0.000843},
			{   0.004395,    0.002975,    0.002799}, {   0.007491,    0.007412,    0.003684}, {   0.002369,   -3.375705,   -3.319046}, {   0.000354,   -1.641865,    0.000483}, {   0.001952,    0.000000,    0.001910}, {   0.001449,    0.002807,    0.003887}, {   0.001392,    0.000731,    0.003081}, {   0.002998,    0.000121,    0.000609},
			{   0.004027,    0.000731,    0.002931}, {   0.003051,    0.001876,    0.001244}, {   0.003783,  -17.117065,    0.007416}, {   0.001952,    0.000195,    0.002266}, {  -0.001010,    0.006144,    0.003900}, {   0.000442,    0.004786,    0.002977}, {  -0.002237,    0.000684,    0.005694}, {   0.006682,    0.002151,    0.005160},
			{   3.046020,   -0.000060,   -0.530888}, {  -1.816272,   -3.268903,   -4.251811}, {   0.000000,    0.007060,    0.000948}, {  -0.016282,    0.006593,   -0.004867}, {   0.007462,    0.007236,    0.007116}, {   0.006401,    0.006821,    0.054299}, {  -6.733910,    4.727310,    0.005115}, {   0.003055,    0.006198,    0.006926},
			{   0.005386,    0.004424,   -0.723062}, {   0.005493,    0.004271,    0.002468}, {   0.005981,    0.001063,    0.004741}, {   0.002685,    0.002868,    0.001627}, {   0.006347,    0.000722,    0.007751}, {  -0.122069,    0.000000,    0.003219}, {   0.004637,    0.000118,   -0.355614}, {   0.007195,    1.050209,   -1.162837},
			{  -2.037050,   -0.046351,   -1.904389}, {  -0.005044,    0.003789,   -0.147746}, {   0.002105,    0.000222,    0.000829}, {   0.005524,    0.003012,    0.002214}, {   0.002593,    0.003226,    0.006136}, {  -0.004453,    0.004536,    0.005135}, {   0.000182,    0.004579,   -0.033808}, {   0.004860,    0.000872,   -0.006149},
			{   0.006473,   -0.002562,    0.003500}, {   0.005249,    0.002731,    0.007027}, {   0.003539,    0.006843,   -0.903109}, {   0.940643,    0.001388,   -6.085056}, {   0.007629,    0.005092,   -1.004621}, {   0.002857,    0.000165,    0.001898}, {   0.007418,    0.002153,    0.005855}, {   0.005342,    0.000467,    0.006200},
			{   0.000365,    0.003613,    0.006957}, {   0.000853,    0.003847,    0.003504}, {   0.006566,    0.002440,    0.004664}, {   0.007046,    0.000540,    0.006012}, {   0.004021,    0.005907,    0.006211}, {   0.005493,    0.000785,    0.003530}, {   0.058837,    0.005371,    0.005148}, {   0.000853,    0.007079,    0.003623},
			{   0.000507,    0.001464,    0.000622}, {   0.001830,    0.001464,    0.003783}, {   0.001098,    0.000487,    0.001902}, {   0.002562,    0.001220,    0.002920}, {   0.000000,    0.000000,    0.000000}, {   0.007459,    0.001601,    0.007768}, {   0.003087,    0.001125,    0.000903}, {   0.001594,    0.004939,    0.007242},
			{   0.002767,    0.006713,   -0.083301}, {   0.002750,    0.006583,    0.007242}, {   0.003674,    0.003304,    0.007242}, {   0.001440,    0.002440,    0.000765}, {   0.048705,    0.002396,   -1.412984}, {   0.002430,    0.002622,    0.005369}, {   0.005725,    0.002131,    0.005171}, {   0.003407,    0.003108,    0.005078},
			{   0.004627,    0.006285,    0.006643}, {   0.006579,    0.004453,    0.006300}, {   0.003529,    0.002621,    0.004736}, {   0.005481,    0.005580,    0.000730}, {   0.003464,    0.001098,    0.003586}, {   0.001506,    0.002196,    0.006759}, {   0.001021,    0.001464,    0.001922}, {   0.000889,    0.005859,    0.006508},
			{   0.003112,    0.001869,    0.003173}, {   0.000838,    0.001220,    0.006165}, {   0.002807,    0.001632,    0.003234}, {   0.460922,  -17.575927,    0.228881}, {   0.006446,    0.003087,    0.002191}, {   0.002265,    0.000001,    0.002566}, {   0.007491,    0.000594,    0.002494}, {   0.007538,    0.001735,    0.002498},
			{   0.007393,    0.000006,    0.003805}, {   0.001098,    0.001730,    0.000190}, {   0.024551,    0.006854,   -0.247792}, {  -0.006167,    0.006957,    0.005807}, {   0.004648,    0.003905,    0.005508}, {   0.005863,    0.000499,    0.004728}, {   0.002685,   -0.000017,    0.002624}, {   0.000775,    0.003066,    0.007292},
			{   0.006634,    0.005568,   -0.501893}, {   0.002203,    0.003477,    0.000059}, {   0.004149,    0.007689,    0.007379}, {   0.005805,    0.004761,    0.000041}, {   0.001795,    0.005016,    0.000044}, {   0.001872,    0.005615,    0.005874}, {   0.131506,    0.000169,    0.006481}, {   0.007338,    0.000014,    0.004495},
			{   0.006672,    0.000518,    0.005733}, {   0.001961,    0.004306,    0.007000}, {   0.001019,    0.007517,    0.000058}, {   0.004639,    0.000959,    0.003456}, {   0.065029,    0.000043,   -0.041669}, {   0.004112,    0.002946,   -0.139277}, {   0.005084,    0.006699,   -0.085877}, {   0.002807,    0.002380,    0.000039},
			{   0.006769,   -0.003560,    0.003310}, {   0.001949,    0.007623,    0.001765}, {   0.004226,    0.000364,    0.000039}, {   0.004534,    0.007205,   -0.051679}, {   0.005483,    0.001743,    0.000906}, {  -0.005185,   -0.004929,   -0.096891}, {  -0.477840,   -0.233339,   -0.174614}, {  -0.000132,    0.005065,    0.005911},
			{   0.003996,    0.005057,    0.001442}, {   0.003104,   -0.052875,    0.005202}, {   0.000668,    0.000503,    0.003045}, {   0.005098,    0.007309,   -0.011464}, {   0.003714,    0.004497,    0.000645}, {   0.005371,    0.006006,    0.004079}, {   0.005388,    0.002716,    0.005952}, {   0.003590,    0.002068,    0.002455},
			{  -0.028398,    0.003849,    0.001180}, {   0.002648,    0.000681,    0.001194}, {   0.004608,    0.007263,    0.002731}, {   0.003722,    0.004377,    0.002892}, {  -0.001321,   -0.008073,    0.004279}, {   0.006115,    0.001185,    0.002321}, {   0.004528,    0.006727,    0.001384}, {   0.002587,    0.005382,    0.003004},
			{   0.000888,    0.004470,   -0.086515}, {   0.003784,    0.006746,    0.005179}, {   0.000318,    0.001868,    0.012387}, {   0.003551,    0.002532,   -0.133647}, {   0.003423,    0.002862,    0.005307}, {  -0.000169,   -0.053506,    0.006976}, {   0.004013,    0.006711,    0.004937}, {   0.000237,    0.003905,    0.000044},
			{   0.005553,    0.002562,    0.007325}, {  17.127609,  -13.453018,   -2.978033}, {   0.003539,    0.006843,   -0.903109}, {   0.940643,    0.001388,   -6.085056}, {   0.005493,    0.004271,    0.002468}, {   0.007629,    0.005092,   -1.004621}, {   0.002074,    0.007209,   -1.810711}, {   0.005386,    0.004424,   -0.723062},
			{  -0.002237,    0.000684,    0.005694}, {   0.000602,    0.003403,    0.006943}, {  -1.128579,   -0.623265,    0.235839}, {   0.003055,    0.006198,    0.006926}, {   0.007418,    0.002153,    0.005855}, {   0.000853,    0.003847,    0.003504}, {  -6.733910,    4.727310,    0.005115}, {   0.003104,   -0.052875,    0.005202},
			{   0.002857,    0.000165,    0.001898}, {   0.006401,    0.006821,    0.054299}, {   0.004648,    0.003905,    0.005508}, {   0.002685,   -0.000017,    0.002624}, {   0.000775,    0.003066,    0.007292}, {   0.005863,    0.000499,    0.004728}, {  -0.006167,    0.006957,    0.005807}, {   0.004639,    0.000959,    0.003456},
			{   0.006634,    0.005568,   -0.501893}, {   0.003784,    0.006746,    0.005179}, {   0.005524,    0.003012,    0.002214}, {   0.002593,    0.003226,    0.006136}, {   0.004021,    0.005907,    0.006211}, {  -0.004453,    0.004536,    0.005135}, {   0.004860,    0.000872,   -0.006149}, {  -0.005044,    0.003789,   -0.147746},
			{   0.000602,    0.003403,    0.006943}, {  -0.005185,   -0.004929,   -0.096891}, {   0.006769,   -0.003560,    0.003310}, {   0.000442,    0.004786,    0.002977}, {  -0.001010,    0.006144,    0.003900}, {   0.006115,    0.001185,    0.002321}, {   1.885522,    0.842970,   -0.001607}, {   0.006566,    0.002440,    0.004664},
			{   0.005342,    0.000467,    0.006200}, {   0.000365,    0.003613,    0.006957}, {   3.046020,   -0.000060,   -0.530888}, {   0.006672,    0.000518,    0.005733}, {   0.001961,    0.004306,    0.007000}, {   0.005981,    0.001063,    0.004741}, {   0.004149,    0.007689,    0.007379}, {   0.004608,    0.007263,    0.002731},
			{   0.005493,    0.000785,    0.003530}, {   0.002105,    0.000222,    0.000829}, {   0.006347,    0.000722,    0.007751}, {   0.000182,    0.004579,   -0.033808}, {   0.006225,    0.000731,   -1.039656}, {   0.007201,   -0.136230,   -0.905022}, {   0.006682,    0.002151,    0.005160}, {  17.127609,  -13.453018,   -2.978033},
			{   0.006473,   -0.002562,    0.003500}, {  -1.816272,   -3.268903,   -4.251811}, {   0.004226,    0.000364,    0.000039}, {   0.002807,    0.002380,    0.000039}, {   0.005483,    0.001743,    0.000906}, {  -0.477840,   -0.233339,   -0.174614}, {   0.004637,    0.000118,   -0.355614}, {  -0.016282,    0.006593,   -0.004867},
			{  -0.000132,    0.005065,    0.005911}, {   0.003996,    0.005057,    0.001442}, {   0.007462,    0.007236,    0.007116}, {   0.004534,    0.007205,   -0.051679}, {   0.003087,    0.001125,    0.000903}, {   0.000237,    0.003905,    0.000044}, {   0.007046,    0.000540,    0.006012}, {   0.003674,    0.003304,    0.007242},
			{   0.001594,    0.004939,    0.007242}, {   0.002767,    0.006713,   -0.083301}, {   0.002750,    0.006583,    0.007242}, {   0.001440,    0.002440,    0.000765}, {   0.065029,    0.000043,   -0.041669}, {   0.003423,    0.002862,    0.005307}, {   0.005371,    0.006006,    0.004079}, {  -0.028398,    0.003849,    0.001180},
			{   0.000668,    0.000503,    0.003045}, {   0.002648,    0.000681,    0.001194}, {   0.005098,    0.007309,   -0.011464}, {   0.005388,    0.002716,    0.005952}, {  -0.122069,    0.000000,    0.003219}, {   0.000937,    0.001281,    0.002284}, {  -0.012573,   51.319030,    0.270251}, {   0.002807,    0.000213,    0.000698},
			{   0.003440,    0.001281,    0.002284}, {  -0.012573,   51.319030,    0.270251}, {   0.002807,    0.000213,    0.000698}, {   0.003440,    0.001281,    0.002284}, {   0.000937,    0.001281,    0.002284}, {   0.003783,  -17.117065,    0.007416}, {   0.004395,    0.002975,    0.002799}, {   0.460922,  -17.575927,    0.228881},
			{   0.002807,    0.001632,    0.003234}, {   0.003051,    0.001876,    0.001244}, {   0.002685,    0.002868,    0.001627}, {   0.005249,    0.002731,    0.007027}, {   0.001952,    0.000195,    0.002266}, {   0.048705,    0.002396,   -1.412984}, {   0.000838,    0.001220,    0.006165}, {   0.001449,    0.002807,    0.003887},
			{   0.001952,    0.000000,    0.001910}, {   0.004027,    0.000731,    0.002931}, {   0.003112,    0.001869,    0.003173}, {   0.007491,    0.007412,    0.003684}, {   0.002998,    0.000121,    0.000609}, {   0.000889,    0.005859,    0.006508}, {   0.001506,    0.002196,    0.006759}, {   0.001392,    0.000731,    0.003081},
			{   0.001021,    0.001464,    0.001922}, {   0.002369,   -3.375705,   -3.319046}, {   0.000354,   -1.641865,    0.000483}, {  -0.000083,    0.002318,    0.001540}, {   0.000415,    1.316787,    0.000843}, {   0.003464,    0.001098,    0.003586}, {   0.000000,    0.007060,    0.000948}, {   0.004528,    0.006727,    0.001384},
			{   0.058837,    0.005371,    0.005148}, {   0.001830,    0.001464,    0.003783}, {   0.000507,    0.001464,    0.000622}, {   0.001098,    0.000487,    0.001902}, {   0.000853,    0.007079,    0.003623}, {   0.002562,    0.001220,    0.002920}, {   0.007459,    0.001601,    0.007768}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.004352,    0.001019,    0.006672}, {   3.743896,  -30.638732,    1.002146}, {  -0.024779,   -9.366455,    4.719282}, {  10.008880,   -1.493356,    0.057744}, { -21.921600,    6.132130,   -8.006223}, {   2.922688,   -2.687228,   -1.534891},
			{  -6.359447,   -2.045401,   -1.422556}, {   5.252087,   -0.066714,   -1.314705}, {   5.790137,   -1.776193,   -1.872889}, {  -8.315022,    5.437527,   -4.641061}, {  -9.838504,    4.615388,    1.150194}, {  -3.596954,   -5.949800,   -1.381127}, {   0.000670,   -4.482750,   -1.219874}, {   0.005493,    0.125961,    0.004722},
			{   0.012618,    0.126517,   -0.585367}, { -10.713895,    5.004605,   -0.244830}, {  10.281386,   -0.769719,   -0.549727}, {  -0.009627,    0.185655,   -0.660753}, {  -4.579886,   -0.295082,    1.095121}, {   0.002146,    0.007464,   -0.211759}, {  -0.013248,    0.002009,   -0.111582}, {   0.067939,    0.001201,    0.000900},
			{  -1.412981,   -0.659633,   -0.574377}, {   0.006283,    0.001019,    0.002372}, {   0.236937,    0.004180,   -0.652388}, {   0.003484,    0.005080,   -0.071370}, {   0.000050,    0.000887,   -1.211058}, {   0.006943,    0.002832,   -0.464556}, {   0.000479,    0.002238,   -0.036580}, {   0.001997,    0.003430,   -0.156939},
			{   0.001678,    0.001506,    0.003842}, {   0.007335,    0.012920,   -0.436686}, {   0.002410,    0.065159,    0.002067}, {   0.005886,    0.002611,   -0.574770}, {   0.007644,    0.001588,   -0.315140}, {   0.003014,    0.006928,   -0.946603}, {   0.003058,    0.006419,   -0.919817}, {  25.691314,   -0.049155,   -0.390325},
			{  -0.004017,   -7.400786,    0.003323}, {   3.008694,    1.450459,   -0.390551}, {   0.005472,    0.051059,    0.039335}, {   0.006229,   -4.279199,   -0.453684}, {  25.649568,    0.927564,    5.293145}, {  -0.021110,    0.554033,    0.024606}, {   0.538097,  -15.532005,   -3.358505}, {  -0.007019,    0.000243,    0.007712},
			{   0.075081,    0.384234,    0.001610}, {   0.000906,    0.003444,    0.007792}, {  -0.650707,   -0.024787,  -60.000827}, {   0.000906,    0.003444,    0.007792}, {  25.649568,    0.927564,    5.293145}, {   0.049504,    0.005255,   -0.064216}, {   0.003317,    0.004195,   -0.530102}, {   0.006229,   -4.279199,   -0.453684},
			{   0.004271,    0.132073,   -0.102397}, {   2.649544,    1.562538,   -0.001477}, {   0.000670,   -4.482750,   -1.219874}, {   0.002410,    0.065159,    0.002067}, {   0.005493,    0.125961,    0.004722}, {  -0.009627,    0.185655,   -0.660753}, {  10.281386,   -0.769719,   -0.549727}, {   0.012618,    0.126517,   -0.585367},
			{ -10.713895,    5.004605,   -0.244830}, {   0.005472,    0.051059,    0.039335}, {   3.008694,    1.450459,   -0.390551}, {  -0.081910,    1.569581,   -0.439826}, {  -0.085972,   -0.047883,    0.003024}, {  -0.028872,   10.018063,  -11.130814}, {  -7.287684,  -12.704917,  -14.858777}, {   1.323169,    0.003112,  -58.081550},
			{   1.538696,    0.003951,  -58.081592}, {   0.004271,    0.002868,    0.000395}, {   0.002685,    0.000792,    0.001713}, {  -0.041416,   -0.167572,   -1.144091}, {   0.003539,    0.000153,    0.004918}, {   0.006378,    0.006434,    0.261682}, {   0.003600,    0.006907,    0.005098}, { -13.355651,    0.001830,   10.585346},
			{   0.000948,    0.006240,    0.007486}, {   0.004463,    0.005460,    0.005712}, {   0.006275,    0.007166,    0.004811}, {  -3.795427,    0.289184,    0.002051}, {   0.005863,    0.004941,    0.006438}, {   0.004660,    0.003618,    0.007604}, {   0.003267,    0.007400,    0.001480}, { -55.040237,    2.610352,    0.334852},
			{ -48.442626,  -38.107269,   12.328909}, { -78.536071,   31.627716,   -4.542058}, {  -7.856575,   -1.010931,   -0.140625}, {  14.623077,   -1.147317,   -1.311560}, {   0.356790,    0.057500,   -0.609251}, {  26.149793,    0.004829,    0.000928}, {  -0.004017,   -7.400786,    0.003323}, {   0.001069,    0.003468,   -0.023026},
			{   0.000079,    0.004468,   -0.362298}, {   0.003309,    0.006719,   -0.386907}, {  -0.003011,    0.003700,    0.006167}, {   0.009970,   -0.184402,   -0.857384}, {   0.002378,   10.367500,   -0.035378}, {   0.001526,    0.006947,    0.005617}, {   0.001508,    0.001674,    1.684885}, {   0.005371,    0.015759,   11.757968},
			{  -0.020151,    0.002172,    9.204369}, {  -0.640201,    0.362390,   -1.220847}, {   0.002632,    0.002196,    0.291298}, {   0.004608,    0.033442,   -1.639178}, {  -0.830383,   -0.027434,    0.003876}, {  -4.633183,    0.186333,    0.003238}, {   0.005532,    0.270029,    0.003957}, {  -2.906066,   -7.366421,   -1.632732},
			{   0.560966,   -5.674702,   -2.099689}, {   0.006957,    0.005065,    0.006025}, {   0.000792,    0.003020,    0.005363}, {   2.649544,    1.562538,   -0.001477}, {   0.004821,    0.007197,   -0.430175}, {  -0.808811,   15.659263,  -60.364166}, { -12.688238,   -7.917160,   -9.712289}, {   0.004271,    0.132073,   -0.102397},
			{  -4.628407,   -1.193745,    1.325716}, {  -2.430919,   -0.289698,   -2.651547}, { -41.786281,    2.312649,   -2.813023}, {  16.618251,    2.052131,    0.002157}, {  -7.926694,   -1.294628,   -0.175934}, {  -0.223510,   -0.589600,   -0.353973}, {   0.001952,    0.015807,   -1.522968}, { -14.658081,    0.007445,    0.004577},
			{ -27.117530,    1.603687,    0.460525}, {  10.934204,    0.005065,    2.393920}, {  -2.036864,    0.006347,    0.003992}, {  -1.381225,    3.118712,    0.000007}, {   0.009970,   -0.137015,    0.001411}, {   0.004871,    0.000335,   -2.306164}, {   0.001586,    0.006775,   -2.916965}, { -22.000122,  -27.846069,   -6.419537},
			{   0.001098,   -0.840880,    0.007546}, {   0.450789,    0.005867,    0.002808}, {   0.085869,    0.005057,    0.007635}, {  -0.640201,    0.362390,   -1.220847}, {  -0.020151,    0.002172,    9.204369}, {   0.004608,    0.033442,   -1.639178}, {   0.009970,   -0.137015,    0.001411}, {   0.007395,    0.200650,    0.000801},
			{   0.000684,   -0.007505,   -0.011981}, {  -0.006823,    0.001208,    0.005574}, {   0.009970,   -0.184402,   -0.857384}, {  -0.003011,    0.003700,    0.006167}, {   0.002378,   10.367500,   -0.035378}, {   0.001526,    0.006947,    0.005617}, {   0.003309,    0.006719,   -0.386907}, {   0.067939,    0.001201,    0.000900},
			{  -0.013248,    0.002009,   -0.111582}, {   0.002146,    0.007464,   -0.211759}, {  -1.412981,   -0.659633,   -0.574377}, {  -0.003487,   -5.048069,   -1.684188}, {  -3.596954,   -5.949800,   -1.381127}, { -21.408863,  -13.724884,   -1.517114}, {   0.157635,   -0.023965,   -0.849240}, {  -3.182877,   -0.281805,   -2.029294},
			{   2.922688,   -2.687228,   -1.534891}, { -21.921600,    6.132130,   -8.006223}, {  10.008880,   -1.493356,    0.057744}, {  -4.628407,   -1.193745,    1.325716}, {  -0.592528,   -0.922002,   -3.666816}, {  -8.315022,    5.437527,   -4.641061}, {  -6.743946,    5.748184,   -0.465133}, {  16.618251,    2.052131,    0.002157},
			{ -41.786281,    2.312649,   -2.813023}, {   2.152741,   -0.059248,   -1.651067}, {  14.623077,   -1.147317,   -1.311560}, {  -3.345042,   -2.562715,   -6.381254}, { -11.772532,   -1.608407,   -0.604923}, {   4.001834,   -0.755810,   -1.061768}, {   4.001834,   -0.755810,   -1.061768}, {  -1.381225,    3.118712,    0.000007},
			{  -2.036864,    0.006347,    0.003992}, { -27.117530,    1.603687,    0.460525}, { -22.000122,  -27.846069,   -6.419537}, {   0.004821,    0.007197,   -0.430175}, { -14.658081,    0.007445,    0.004577}, {   0.001952,    0.015807,   -1.522968}, {   0.001586,    0.006775,   -2.916965}, {   0.356790,    0.057500,   -0.609251},
			{   0.003058,    0.006419,   -0.919817}, {   0.003014,    0.006928,   -0.946603}, {   0.007644,    0.001588,   -0.315140}, {   0.005886,    0.002611,   -0.574770}, {  -0.016726,   -0.912023,   -1.917865}, {   0.001997,    0.003430,   -0.156939}, {   0.006943,    0.002832,   -0.464556}, {   0.000479,    0.002238,   -0.036580},
			{   0.003484,    0.005080,   -0.071370}, {   0.001678,    0.001506,    0.003842}, {   0.007335,    0.012920,   -0.436686}, {   0.236937,    0.004180,   -0.652388}, {   0.000050,    0.000887,   -1.211058}, {  25.691314,   -0.049155,   -0.390325}, {   0.000079,    0.004468,   -0.362298}, {  -4.579886,   -0.295082,    1.095121},
			{   0.016060,    0.006645,    0.000688}, {   0.016060,    0.006645,    0.000688}, {  10.057128,   13.070373,    6.766417}, {   0.001220,    0.003905,    2.638477}, {   0.000348,    0.000426,    0.003525}, {   0.000348,    0.000426,    0.003525}, {   0.000731,    0.006835,  -18.461929}, {   0.000348,    0.006287,    0.002670},
			{   0.005127,    0.001037,    0.004592}, {   0.000348,    0.006287,    0.002670}, {   0.000731,    0.006835,  -18.461929}, {   0.000349,    0.002624,    0.002609}, {   0.000731,    0.001708,  -18.461929}, {   0.000349,    0.002624,    0.002609}, {   0.000731,    0.001708,  -18.461929}, {   0.000731,    0.003295,  -20.284606},
			{   0.000731,    0.003295,  -20.284606}, {   0.002941,    0.003330,    0.003505}, {   0.003203,    0.057069,    0.002657}, {   1.522801,    0.140341,   -0.013585}, {  -0.024080,   -0.017369,   -0.843746}, {   2.152741,   -0.059248,   -1.651067}, {  -0.511229,    0.004577,    0.628296}, {  -0.835341,    1.174947,    2.245501},
			{  19.075328,    4.208906,   -0.520264}, {   0.955338,    0.000426,   -0.115552}, {   1.974437,   -0.913046,   -1.173076}, {  12.357494,    1.565901,   -1.123654}, {  22.708778,   -0.031097,   -7.949891}, {   0.091987,    0.029465,   -2.560801}, {  -1.629814,   -0.307848,   -2.506618}, {  33.376327,    0.130362,    2.631607},
			{  -9.778236,    2.323776,   -0.892965}, {   1.060078,    0.000020,   -0.924190}, {  -2.212315,   -0.504541,    2.772562}, {  -2.161945,    6.161427,    1.651711}, {   1.383002,   -1.530794,   -0.628293}, {  -0.103418,   -0.094433,    0.000075}, {   0.184463,    3.141479,   -6.281737}, {   8.444798,    8.830484,    3.487294},
			{  -3.182877,   -0.281805,   -2.029294}, {   0.157635,   -0.023965,   -0.849240}, {   4.556327,   -6.980741,   -1.912600}, {  20.178518,   -0.498576,   -1.085589}, {   1.083389,    1.655341,    0.469166}, {  -6.743946,    5.748184,   -0.465133}, {  23.330688,   -3.428222,   -3.167512}, {  -5.397031,    1.184031,   -1.504802},
			{   0.145713,    0.736212,   -1.587903}, {  15.280817,    2.502795,   -0.296956}, {   1.527133,   -1.032333,   -0.286767}, { -12.386726,   16.097850,   -1.933662}, {   0.973106,   -0.006262,   -3.950572}, {  -0.592528,   -0.922002,   -3.666816}, {  -0.046806,    1.272721,    0.440631}, {   4.840579,   -0.004954,    0.911787},
			{ -21.408863,  -13.724884,   -1.517114}, {   0.006481,    0.039436,   -0.650986}, {   0.049504,    0.005255,   -0.064216}, {   0.003317,    0.004195,   -0.530102}, {   0.003317,    0.003731,    0.001982}, {   0.005508,    0.000609,   -0.175047}, {   0.004945,    0.005441,    0.001323}, {   0.088779,    0.006138,   -2.227504},
			{   0.005576,    0.005836,    0.005030}, {   0.000999,    0.007515,   -2.024535}, {   0.007426,    0.002487,    0.004590}, {  -3.345042,   -2.562715,   -6.381254}, { -33.596343,   13.255146,   -6.946362}, {   3.583154,   12.132129,  -12.839282}, {  27.922912,   -0.451362,  -17.544385}, {  -6.047520,   15.639211,  -16.959642},
			{   2.537133,   -6.328320,  -15.270478}, {   1.962092,   -4.301477,  -13.711943}, {  -6.657573,   -5.933805,   -8.647427}, {   0.001508,    0.001674,    1.684885}, {   0.004945,    0.005441,    0.001323}, {   0.005508,    0.000609,   -0.175047}, {   0.003426,    0.005346,    0.006008}, {  26.149793,    0.004829,    0.000928},
			{   0.003317,    0.003731,    0.001982}, {   0.002789,    0.002126,   -9.058380}, {  -0.095904,    0.010536,    0.002489}, {   0.130949,  -10.117109,   -1.685019}, {   0.004067,    0.006159,    0.005107}, {  -0.085972,   -0.047883,    0.003024}, {   0.006601,    0.000307,    0.002899}, {  -0.053780,    0.007197,    0.429351},
			{   0.006481,    0.039436,   -0.650986}, {   0.004067,    0.006159,    0.005107}, {   0.130949,  -10.117109,   -1.685019}, {  -0.081910,    1.569581,   -0.439826}, {   0.955338,    0.000426,   -0.115552}, {   1.383002,   -1.530794,   -0.628293}, {  33.376327,    0.130362,    2.631607}, {  -2.212315,   -0.504541,    2.772562},
			{  -2.161945,    6.161427,    1.651711}, {  -0.103418,   -0.094433,    0.000075}, {   0.184463,    3.141479,   -6.281737}, {   8.444798,    8.830484,    3.487294}, {  -6.359447,   -2.045401,   -1.422556}, {  20.178518,   -0.498576,   -1.085589}, {   5.252087,   -0.066714,   -1.314705}, {   4.556327,   -6.980741,   -1.912600},
			{  -2.906066,   -7.366421,   -1.632732}, {  -0.835341,    1.174947,    2.245501}, {   0.145713,    0.736212,   -1.587903}, {  15.280817,    2.502795,   -0.296956}, {   1.083389,    1.655341,    0.469166}, {  -5.397031,    1.184031,   -1.504802}, { -12.386726,   16.097850,   -1.933662}, {   0.973106,   -0.006262,   -3.950572},
			{   1.527133,   -1.032333,   -0.286767}, {  19.075328,    4.208906,   -0.520264}, {  -9.838504,    4.615388,    1.150194}, {  -0.511229,    0.004577,    0.628296}, {  -7.856575,   -1.010931,   -0.140625}, {  -0.024080,   -0.017369,   -0.843746}, {   1.522801,    0.140341,   -0.013585}, { -11.772532,   -1.608407,   -0.604923},
			{  -9.778236,    2.323776,   -0.892965}, {   1.060078,    0.000020,   -0.924190}, {   4.840579,   -0.004954,    0.911787}, {   1.974437,   -0.913046,   -1.173076}, {  12.357494,    1.565901,   -1.123654}, {   0.091987,    0.029465,   -2.560801}, {  -1.629814,   -0.307848,   -2.506618}, {  -2.430919,   -0.289698,   -2.651547},
			{  -0.046806,    1.272721,    0.440631}, {   5.790137,   -1.776193,   -1.872889}, {  22.708778,   -0.031097,   -7.949891}, {   0.002968,    0.000655,   -2.657164}, {   0.005284,    0.002903,    0.004085}, {   0.006957,    0.005065,    0.006025}, {   0.004966,    0.003195,    0.003724}, {   0.001645,    0.003399,    0.003236},
			{   0.005979,    0.004273,    0.007697}, {   0.192166,    4.171852,    0.007635}, {   0.006194,    0.002702,    0.004000}, {   0.004209,    0.006275,    0.409624}, {   0.000539,    0.000226,    0.001272}, {   0.005913,    0.003663,    0.005167}, {   0.001202,    0.002772,    0.003760}, {   0.004650,   -0.004662,    0.000153},
			{   0.004517,   -0.001218,   -0.076333}, {   0.007646,    0.001608,    0.006316}, {   0.004517,   -0.001218,   -0.076333}, {   0.001286,    0.004011,   -1.076637}, {   0.001286,    0.004011,   -1.076637}, {  -3.565262,    1.450170,    0.003242}, {   1.549805,    4.786713,    2.547313}, {   0.057654,  -14.625102,    1.233716},
			{   0.007234,    0.005685,   -0.249373}, {   0.140746,    0.140686,    0.000745}, {   0.007021,    0.002171,    0.004708}, {   0.005127,    0.004761,    0.000938}, {   0.005127,    0.003142,   -1.106737}, { -13.541015,    0.001708,  -18.461929}, { -13.541015,    0.006835,  -18.461929}, {   0.005127,    0.004761,    0.000938},
			{   0.007021,    0.002171,    0.004708}, {   0.005127,    0.003142,   -1.106737}, {  -3.565262,    1.450170,    0.003242}, {  -0.650707,   -0.024787,  -60.000827}, {  -0.808811,   15.659263,  -60.364166}, {   0.004271,    0.002868,    0.000395}, {   0.560966,   -5.674702,   -2.099689}, {  -6.657573,   -5.933805,   -8.647427},
			{  -0.028872,   10.018063,  -11.130814}, {   1.962092,   -4.301477,  -13.711943}, {   2.537133,   -6.328320,  -15.270478}, {  -0.095904,    0.010536,    0.002489}, {  -6.047520,   15.639211,  -16.959642}, {  27.922912,   -0.451362,  -17.544385}, {  -7.287684,  -12.704917,  -14.858777}, {   3.583154,   12.132129,  -12.839282},
			{ -12.688238,   -7.917160,   -9.712289}, { -33.596343,   13.255146,   -6.946362}, {   0.002968,    0.000655,   -2.657164}, {   0.005127,    0.004127,    0.001387}, {   0.702862,    4.169892,    0.001682}, {   0.005981,    0.005615,   -1.401208}, {   0.007445,   12.750244,    0.007102}, {   0.007445,   12.750244,    0.007102},
			{   0.005981,    0.005615,   -1.401208}, {   0.001069,    0.003468,   -0.023026}, {   0.001220,    0.003905,    2.638477}, {  23.330688,   -3.428222,   -3.167512}, {   0.007395,    0.200650,    0.000801}, {  -0.024779,   -9.366455,    4.719282}, {   0.085869,    0.005057,    0.007635}, {   0.005576,    0.005836,    0.005030},
			{   0.088779,    0.006138,   -2.227504}, {   0.000999,    0.007515,   -2.024535}, {   0.007426,    0.002487,    0.004590}, {   0.004871,    0.000335,   -2.306164}, {   3.743896,  -30.638732,    1.002146}, {  10.934204,    0.005065,    2.393920}, {   0.002685,    0.000792,    0.001713}, {   0.003539,    0.000153,    0.004918},
			{   1.549805,    4.786713,    2.547313}, {  -0.041416,   -0.167572,   -1.144091}, {  -0.223510,   -0.589600,   -0.353973}, {   1.323169,    0.003112,  -58.081550}, {   1.538696,    0.003951,  -58.081592}, {  -2.457511,    0.001965,    0.006293}, {   0.007462,   55.137729,   11.536796}, {   0.001098,   -0.840880,    0.007546},
			{   0.450789,    0.005867,    0.002808}, {   0.006103,    0.000609,    0.005301}, {   0.006099,    0.000609,    0.003680}, {   0.004004,    0.000915,    0.005911}, {   0.004004,    0.000915,    0.005911}, {   0.000760,    0.001449,    0.006244}, {   0.003426,    0.005346,    0.006008}, {  -0.016726,   -0.912023,   -1.917865},
			{  -3.669790,   19.682275,   22.178241}, {  21.242462,  -28.601745,   13.422371}, { -11.424525,   10.230040,    4.954026}, {  -0.003487,   -5.048069,   -1.684188}, {  -0.038492,   -0.009912,   -0.592957}, {  -9.623626,    0.023987,    2.904467}, {  -8.458274,    7.800048,    0.003270}, {  -0.645420,    0.004027,    0.004288},
			{   0.002685,    0.005127,    0.005514}, {   7.295227,    8.348999,    0.351007}, {  -1.159301,    0.615203,   -1.529042}, {   0.002318,    0.004333,  -18.443986}, {   1.243271,   38.457550,   -0.641808}, {  -0.019531,    0.003783,   -0.700729}, {   2.761718,    3.014374,   -0.529202}, { -11.623832,   -0.729982,   -0.786952},
			{   1.723837,    1.540145,   -0.525265}, {  -0.644774,    2.531799,   -1.138164}, {  -1.664245,    2.000916,   -0.524942}, {   0.022765,   -0.082336,    2.619318}, { -12.783447,    9.654357,    0.406311}, {   0.072587,   -0.035358,   -0.351763}, {   0.206787,    0.165955,   -1.246227}, {   1.833495,    0.389984,   -1.732933},
			{  26.408569,    5.878693,    8.011542}, {   4.845946,   -0.502318,   -0.565294}, {   0.350219,   -0.008391,   -0.566187}, {   0.140991,    0.359192,   -0.564749}, {  -0.589721,    0.680786,   -0.564207}, {  -0.018798,    0.000548,   -0.140885}, {  -0.002101,   -0.532288,   -0.528596}, {  -0.041351,    0.091430,   -0.276973},
			{   0.005981,    0.005828,   -0.106150}, {  -5.459290,   -0.382111,   -0.142120}, {   0.058350,   -0.047667,   -1.296185}, {   0.003844,    0.002746,    0.000818}, {   0.006165,    0.000518,   -1.459475}, {  -0.119941,   -0.068740,   -2.598495}, { -56.287513,   -3.508651,   -2.501055}, {   0.002318,    0.004333,  -18.443986},
			{  -0.038492,   -0.009912,   -0.592957}, {   1.833495,    0.389984,   -1.732933}, {   0.005115,    0.003880,    0.004401}, {   0.003783,    4.262421,   -3.425018}, {  -0.589721,    0.680786,   -0.564207}, {   0.350219,   -0.008391,   -0.566187}, {   4.845946,   -0.502318,   -0.565294}, {  -0.018798,    0.000548,   -0.140885},
			{  -0.002101,   -0.532288,   -0.528596}, {   0.206787,    0.165955,   -1.246227}, {   0.222167,   -0.126433,   -0.436576}, {   0.009583,    2.992706,   -1.012928}, {   0.618651,   -0.929871,   -0.541306}, {   0.007102,    7.327149,    0.005723}, {   0.003574,   -0.004395,    0.002861}, {   0.002428,    0.002200,    0.002861},
			{   0.437817,    1.135344,   -1.062608}, {  -0.045168,   -0.934610,   -0.912791}, {   1.339287,   -0.693542,    0.003321}, { -15.216526,   -5.537785,    0.002858}, {  -4.002974,   -1.220535,    2.842050}, {   0.436107,   -1.453466,   -1.405910}, {   0.007617,    0.073253,   -0.332892}, {  -0.239258,    1.480407,   -0.625533},
			{   0.000121,    0.001555,    0.005762}, {   0.004424,    0.132018,   -0.439500}, {  -1.159301,    0.615203,   -1.529042}, {  -9.623626,    0.023987,    2.904467}, {   0.007102,    7.327149,    0.005723}, {   0.002428,    0.002200,    0.002861}, {  -0.241730,   -0.098632,    1.436332}, {   1.136291,   16.391250,    6.383494},
			{   0.004089,    0.000167,   -0.779835}, {   0.007263,    0.001189,    0.007526}, {   1.243271,   38.457550,   -0.641808}, {  26.408569,    5.878693,    8.011542}, {   0.436107,   -1.453466,   -1.405910}, {   2.761718,    3.014374,   -0.529202}, {   1.723837,    1.540145,   -0.525265}, {  -0.644774,    2.531799,   -1.138164},
			{  -1.664245,    2.000916,   -0.524942}, {  -0.185974,   -0.331542,   -0.706031}, {  -0.146239,    0.000487,    0.908472}, {  -0.107787,    0.635254,   -2.026196}, {  -0.527988,   -0.894057,   -0.504763}, { -12.567626,   42.885498,   -0.324728}, {   0.001904,    0.002624,    0.004976}, {   0.652078,   -0.876627,   -0.941749},
			{   0.165728,    0.153098,   -0.367834}, {   0.160521,    0.668213,   -0.516108}, {  16.361267,   -2.783263,   -4.132336}, {   0.005706,    0.003670,    0.007708}, {  -0.081037,    0.245470,   -0.955416}, { -21.299804,  -13.418273,   11.438823}, {   0.010619,    0.289570,   -0.713383}, {   0.010619,    0.011505,   -1.168346},
			{  -0.791260,    0.583434,    0.001052}, {  -0.368651,   -8.718414,   -1.463969}, {  -1.016602,    0.520142,   -0.500693}, {   0.085570,    0.681244,   -0.855765}, {   0.921509,   13.884643,   -0.854273}, {   0.398438,    0.006591,   -0.522930}, {   0.140991,    0.359192,   -0.564749}, { -11.623832,   -0.729982,   -0.786952},
			{ -12.783447,    9.654357,    0.406311}, {  -0.041351,    0.091430,   -0.276973}, {   0.005981,    0.005828,   -0.106150}, {   0.437817,    1.135344,   -1.062608}, {   0.009583,    2.992706,   -1.012928}, {   0.618651,   -0.929871,   -0.541306}, {   0.309204,    0.005297,   -0.772764}, {   0.022765,   -0.082336,    2.619318},
			{   0.204659,    0.031246,    2.835751}, {  -0.000138,    0.003610,    0.000437}, {   0.000945,   -0.001464,    3.507935}, {   0.005818,    0.007071,    0.004370}, {   0.000792,    0.003051,    0.005855}, {  -0.527988,   -0.894057,   -0.504763}, { -12.567626,   42.885498,   -0.324728}, {   0.001904,    0.002624,    0.004976},
			{  -0.248273,    0.713864,   -0.949073}, { -21.299804,  -13.418273,   11.438823}, {  11.114501,    0.001159,    0.007641}, {  -0.791260,    0.583434,    0.001052}, {  -0.081037,    0.245470,   -0.955416}, {   0.010619,    0.011505,   -1.168346}, {   0.010619,    0.289570,   -0.713383}, {   0.001891,  -28.353454,   -0.411164},
			{   0.008789,   -1.286134,    9.183541}, {   0.085570,    0.681244,   -0.855765}, {   0.006814,    0.747741,    0.003386}, {   0.003783,    4.262421,   -3.425018}, {   1.136291,   16.391250,    6.383494}, {  43.346923,   -0.912018,    8.059012}, {   0.398438,    0.006591,   -0.522930}, {   0.309204,    0.005297,   -0.772764},
			{   0.000426,    0.003386,    0.006035}, {   0.110863,    0.000304,    5.378707}, {  -0.008291,   -0.070808,   -0.751370}, {   0.921509,   13.884643,   -0.854273}, {  20.019367,    6.687042,   -7.488318}, {   0.137573,   -0.824554,   -0.550098}, {   0.160521,    0.668213,   -0.516108}, {  16.361267,   -2.783263,   -4.132336},
			{   0.006957,    0.000365,    0.006881}, {   0.004424,    0.132018,   -0.439500}, {   0.005249,    0.002440,    0.003777}, {   0.165728,    0.153098,   -0.367834}, {  -0.241730,   -0.098632,    1.436332}, {   0.000121,    0.001555,    0.005762}, {  -0.239258,    1.480407,   -0.625533}, {  -6.967772,   -3.779236,  -85.322799},
			{  -0.368651,   -8.718414,   -1.463969}, {   0.004089,    0.000167,   -0.779835}, {  -1.016602,    0.520142,   -0.500693}, { -28.222152,  -12.323623,    3.431071}, {   0.007263,    0.001189,    0.007526}, {  -0.146239,    0.000487,    0.908472}, {  -0.107787,    0.635254,   -2.026196}, {   0.023262,    0.916938,   -0.577417},
			{   0.005115,    0.003880,    0.004401}, {   0.003905,    0.005336,    0.006124}, {  -7.392028,  -23.970401,   14.818597}, {  -0.093872,    1.981201,   -5.784587}, {  -0.185974,   -0.331542,   -0.706031}, {   0.006531,    0.002013,    0.004910}, {  -0.006775,   -0.001098,    0.004120}, {  -0.093872,    1.981201,   -5.784587},
			{   0.006531,    0.000426,    4.973805}, {   0.192017,    0.003020,   -1.191226}, {   2.028563,   -1.129088,   -5.503211}, {   0.003417,   -1.447234,   -1.766304}, {  -1.665588,    0.006537,   -1.536450}, {   0.128662,    0.004883,   -0.967151}, {   0.000599,    0.696654,   -1.564841}, {   0.003112,    0.048705,   -1.486886},
			{   0.005127,    0.276793,   -1.234285}, {  -0.021057,    0.005919,   -5.485547}, { -45.287109,    0.001708,   -0.633414}, {   0.023192,   -2.810822,    0.000760}, {  -0.359252,    0.281616,   -0.780281}, {  -0.285400,    0.003631,   -0.482883}, {  -0.435425,   -0.199615,   -1.538450}, {   0.003051,    0.001077,    0.006393},
			{  -7.963031,   -0.034667,    2.282227}, {   0.001098,    0.164489,   -1.715630}, {  -0.504455,    0.643341,   -1.496198}, {   0.005553,   -0.433533,   -1.245517}, {  -0.504455,    0.643341,   -1.496198}, {  -7.963031,   -0.034667,    2.282227}, {   0.001098,    0.164489,   -1.715630}, {  -0.422852,    0.000731,   -2.482443},
			{   2.209472,   -0.169433,   -0.533591}, {   0.023192,   -2.810822,    0.000760}, {   2.028563,   -1.129088,   -5.503211}, {   0.001769,   -0.090240,   -1.536692}, {  -0.021057,    0.005919,   -5.485547}, {   0.000599,    0.696654,   -1.564841}, {   0.128662,    0.004883,   -0.967151}, {  -0.043823,    0.000030,   -0.726885},
			{   0.192017,    0.003020,   -1.191226}, {  -0.289306,    0.072967,   -0.684226}, {  -0.435425,   -0.199615,   -1.538450}, {  -0.359252,    0.281616,   -0.780281}, {   0.063293,   -0.834411,   -0.562115}, {   0.063293,   -0.834411,   -0.562115}, {   0.107879,    0.052002,   -5.019030}, {  -8.458274,    7.800048,    0.003270},
			{ -15.216526,   -5.537785,    0.002858}, {  -4.002974,   -1.220535,    2.842050}, {   1.339287,   -0.693542,    0.003321}, {  -0.045168,   -0.934610,   -0.912791}, {  -0.645420,    0.004027,    0.004288}, {   0.002685,    0.005127,    0.005514}, {  -0.242553,   -0.669098,   -1.913846}, {  -0.239013,   -0.186492,   -0.993709},
			{  -0.289306,    0.072967,   -0.684226}, {  -0.287719,   -0.007323,   -0.471563}, {  -0.296508,   -0.368164,   -0.689327}, {   2.209472,   -0.169433,   -0.533591}, {   0.001403,    0.673828,   -0.923460}, {  -0.585999,   -0.003234,   -2.351830}, {   0.038764,    1.269652,   -0.935333}, {   0.003783,    0.951507,   -0.736348},
			{   0.188659,    0.002624,   -1.130244}, {  -3.238707,    0.003447,   -0.754604}, {  -0.114990,    0.005675,   -1.130679}, {   0.017211,    0.146362,   -1.236917}, {   0.006835,    1.212829,   -2.455986}, {   0.001769,   -0.090240,   -1.536692}, {   0.145447,    0.000182,    0.005694}, {   0.002929,    0.003539,    0.004656},
			{  -0.301757,    0.003051,   -1.812922}, {   0.357178,    0.000823,   -1.569754}, {   0.006041,   -0.939117,   -1.569738}, {   0.898926,   -1.137848,   -1.536908}, {   0.004149,   -1.078734,   -1.537670}, {   0.003234,    0.005127,   -0.430436}, {   0.001891,   -0.344390,   -1.539258}, {   0.002135,   -0.346435,   -1.533826},
			{  -0.043823,    0.000030,   -0.726885}, {  -0.288818,    0.003631,   -0.191874}, {   0.936401,   -0.174163,   -1.112946}, {   0.001586,   -0.481049,   -1.537549}, {   2.212584,   -0.496055,   -0.458427}, {   0.002966,    0.850903,    0.006058}, {   0.107879,    0.052002,   -5.019030}, {  -0.299133,    0.005065,    0.005783},
			{  -0.299133,    0.005065,    0.005783}, {  -0.007102,    0.011332,   -2.153322}, { -52.256103,   57.762248,   20.927217}, { -36.383125,  -34.095161,    3.271559}, {   0.011870,    0.583719,    0.008891}, {   0.010243,    0.003610,    0.006448}, {  -0.008551,    0.003685,   -0.013286}, {   0.014856,   -1.623196,  -15.676383},
			{   0.002759,    0.080303,   -0.064787}, {   3.100573,   10.934098,   -2.832179}, {  -0.072933,    0.004273,    0.007749}, {   0.001891,  -28.353454,   -0.411164}, {   0.750940,   -0.253376,    5.609085}, {   0.210326,    0.896606,   -1.112545}, {   0.003574,   -0.004395,    0.002861}, {   0.072587,   -0.035358,   -0.351763},
			{  -0.019531,    0.003783,   -0.700729}, {   0.014856,   -1.623196,  -15.676383}, {   0.023262,    0.916938,   -0.577417}, {   0.137573,   -0.824554,   -0.550098}, {   0.058350,   -0.047667,   -1.296185}, {   0.069758,    0.005903,    0.006767}, {  20.956916,   20.203865,  -19.343849}, {  -0.008291,   -0.070808,   -0.751370},
			{  -0.422852,    0.000731,   -2.482443}, {   0.005553,   -0.433533,   -1.245517}, {  11.114501,    0.001159,    0.007641}, {   0.003234,    0.005127,   -0.430436}, {   0.002929,    0.003539,    0.004656}, {   0.004699,    0.004044,    0.007373}, {   0.003692,    0.006804,    0.001244}, {   0.000548,    0.005249,    0.005286},
			{ -10.235422,   -0.770065,    0.242974}, {   0.006850,    0.253883,    0.420033}, {   0.741661,    0.006845,    0.003795}, {   2.949265,  -20.986362,   -2.204356}, {   0.007338,    0.007346,    0.000638}, {   0.002440,    0.007644,    4.433609}, {   0.115129,   -0.003156,    0.000319}, {   0.001476,    0.001704,    0.005940},
			{   0.004583,   -0.004836,    0.003000}, {   0.371338,    0.002624,   -0.384171}, {   2.337891,    4.606995,    2.659360}, {   0.006411,   -0.887983,   -0.936097}, {   0.652078,   -0.876627,   -0.941749}, {  -0.836486,   -0.880626,   -0.940392}, {   0.006411,   -0.887983,   -0.936097}, {  -0.836486,   -0.880626,   -0.940392},
			{  -0.248273,    0.713864,   -0.949073}, {   0.230414,    0.033006,   -2.508816}, {   0.214954,    0.003316,   -1.470100}, {   0.801156,    0.001062,   -1.330950}, {  -0.291076,    0.004323,   -1.471510}, {   0.228616,    1.028977,   -1.473395}, {   0.003417,   -1.447234,   -1.766304}, {   0.898926,   -1.137848,   -1.536908},
			{   0.004149,   -1.078734,   -1.537670}, {   0.001891,   -0.344390,   -1.539258}, {   0.006835,    1.212829,   -2.455986}, {   0.005127,    0.276793,   -1.234285}, {  -0.114990,    0.005675,   -1.130679}, {   0.003112,    0.048705,   -1.486886}, {  -3.238707,    0.003447,   -0.754604}, {   0.017211,    0.146362,   -1.236917},
			{   0.001403,    0.673828,   -0.923460}, { -45.287109,    0.001708,   -0.633414}, {   0.188659,    0.002624,   -1.130244}, {   0.038764,    1.269652,   -0.935333}, {   0.003783,    0.951507,   -0.736348}, {  -0.585999,   -0.003234,   -2.351830}, {  -0.301757,    0.003051,   -1.812922}, {   0.357178,    0.000823,   -1.569754},
			{  -0.615050,    0.005005,   -1.500246}, {   0.002135,   -0.346435,   -1.533826}, {   0.001586,   -0.481049,   -1.537549}, {   0.936401,   -0.174163,   -1.112946}, {  -0.288818,    0.003631,   -0.191874}, {  -0.242553,   -0.669098,   -1.913846}, {  -0.285400,    0.003631,   -0.482883}, {  -0.239013,   -0.186492,   -0.993709},
			{  -0.287719,   -0.007323,   -0.471563}, {  -0.296508,   -0.368164,   -0.689327}, {   0.004255,   -1.148437,    0.000308}, {   0.006159,    0.011846,    0.002067}, {   0.005288,    0.005222,    0.005547}, {  -6.019217,    0.002825,   10.556768}, {   0.002966,    0.850903,    0.006058}, {   0.007718,    0.006043,    0.000875},
			{   0.145447,    0.000182,    0.005694}, {   0.005818,    0.007100,    0.000445}, {   0.003844,    0.000457,    0.006618}, {   0.070555,    0.005917,    0.003651}, {   0.761626,    0.002758,    0.000396}, {   0.230414,    0.033006,   -2.508816}, {   0.214954,    0.003316,   -1.470100}, {  -0.291076,    0.004323,   -1.471510},
			{   0.801156,    0.001062,   -1.330950}, {   0.228616,    1.028977,   -1.473395}, {   1.168830,    0.002518,   -1.330595}, {   1.168830,    0.002518,   -1.330595}, {  -0.353190,    0.002891,    0.005224}, {   1.166553,   -0.916180,   -0.298137}, {   0.000951,   -0.007592,    0.003325}, {   0.003844,    2.161102,   -1.190036},
			{   0.005615,    0.009491,   -0.036724}, {   0.003317,    0.000497,   -0.037840}, {   0.002913,    0.006409,    0.004240}, {  -5.459290,   -0.382111,   -0.142120}, {   0.004809,   -0.686094,    0.121059}, {   0.006041,   -0.939117,   -1.569738}, {   0.003844,    2.161102,   -1.190036}, {  44.067276,   -2.050842,   -3.901936},
			{  -6.967772,   -3.779236,  -85.322799}, {   0.222167,   -0.126433,   -0.436576}, {   0.011870,    0.583719,    0.008891}, {   0.000945,   -0.001464,    3.507935}, {   0.041845,    0.005127,    0.002984}, {   0.005822,    0.001311,    0.001890}, {   3.913620,    0.000446,    0.000918}, {   0.005750,    0.003681,    0.003191},
			{   0.007362,    0.002627,    0.003892}, {   0.005938,    0.000011,    0.003346}, {   0.003325,    0.002025,    0.002883}, {   0.006405,    0.004395,    0.003214}, {   0.003362,    0.000737,    0.002917}, {   0.000724,    0.003440,    0.000620}, {   0.007201,    0.003936,    0.004004}, {   0.005245,   -0.032382,    0.000292},
			{  20.019367,    6.687042,   -7.488318}, {  -0.001811,   16.542678,  -20.039695}, {   0.005706,    0.003670,    0.007708}, {  -0.615050,    0.005005,   -1.500246}, {   0.005065,   -0.305267,   -1.675323}, {   0.005065,   -0.305267,   -1.675323}, {   0.003187,    0.001248,    0.004015}, {   0.003187,    0.001248,    0.004015},
			{ -20.158081,   -9.167160,    6.338539}, {   0.025263,    0.415048,    0.020764}, {   0.007648,    0.002042,    0.006157}, {   0.025263,    0.415048,    0.020764}, {   0.003844,    0.002746,    0.000818}, {   0.007617,    0.073253,   -0.332892}, {  20.956916,   20.203865,  -19.343849}, {   0.003362,    0.000737,    0.002917},
			{   0.000724,    0.003440,    0.000620}, {   0.002318,    0.002715,    0.002665}, {  -3.029784,  -26.692077,   -2.347882}, {  -1.665588,    0.006537,   -1.536450}, {  -3.029784,  -26.692077,   -2.347882}, {  -0.698853,    0.011657,   -0.448825}, {   3.104064,    2.390441,   -5.503057}, {   0.228210,    0.000609,   -3.463999},
			{   0.004761,    0.006256,    0.003272}, {   0.004761,    0.006256,    0.003272}, {   0.228210,    0.000609,   -3.463999}, {   3.104064,    2.390441,   -5.503057}, {  10.668304,   -2.629379,    3.183360}, {   0.869948,    0.000487,    0.002204}, {   0.869948,    0.000487,    0.002204}, {  10.668304,   -2.629379,    3.183360},
			{   0.007660,   -0.835403,   -0.912322}, {   0.007660,   -0.835403,   -0.912322}, {  -0.521300,   -0.316527,   -0.536215}, {  -0.521300,   -0.316527,   -0.536215}, {   0.210326,    0.896606,   -1.112545}, {   1.005859,   -2.631795,    3.106698}, {  -3.342565,   -3.621800,   -1.885002}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  -0.033018,   -0.016602,   -0.051724}, {  -0.170838,    0.007546,   -0.429515}, {   0.006041,    0.003951,   -0.342767}, {   0.001465,    0.000399,    0.000500}, {  -7.785702,    1.673535,    8.513744},
			{   0.006713,    0.006469,   -1.012961}, {   0.006591,   -1.054810,   -1.098479}, {   0.005981,    0.002685,   -1.096187}, {   0.003295,    0.002990,   -1.550776}, {   0.004639,    0.006728,   -0.193138}, {   0.007323,    0.004639,   -1.097018}, {   0.208373,    0.001067,   -1.162420}, {  -0.317627,    0.315468,   -1.155140},
			{  -0.130737,    0.101837,   -0.521969}, {  -0.776854,    0.386963,  -43.548862}, {  -0.775023,    0.006484,  -32.930351}, {  -0.158325,   -0.016738,  -32.929870}, {  -0.157433,    0.006331,  -32.931144}, { -12.756141,   -1.478304,   -0.919890}, {  -2.961720,    1.587759,   -0.230353}, {  -5.397087,    0.001430,    2.752680},
			{  -5.082218,   -0.344078,   -0.462388}, {  -0.026946,   -0.009611,   -0.009398}, {  -6.548274,   -2.103760,   -0.007094}, {  -8.077651,    0.686842,   -0.396086}, {   8.802249,   -0.119018,   -0.609268}, { -13.246467,   -2.129543,   -0.156871}, {   4.263783,   -3.118472,   -0.176926}, { -18.594558,   12.218574,   -0.386839},
			{   2.814537,   -1.153208,   -0.657364}, {  -0.182589,    0.004337,   -0.999898}, {  -1.143985,   -9.917921,   -1.993919}, {  10.584007,    4.327384,    0.001089}, {  -5.081346,    3.401268,   -0.806811}, {   0.000851,    0.003984,   -0.092853}, {   0.000307,   29.024211,   -0.222816}, {  -0.155640,   -0.452208,  -33.457054},
			{  -0.151123,   -0.021209,  -32.927085}, {  -0.158325,   -0.016738,  -32.929870}, {  -0.157433,    0.006331,  -32.931144}, {   1.286986,    0.004317,   -0.543083}, {  12.537321,    8.794105,   -0.713428}, {   0.003539,    0.009429,    0.008797}, {   0.005716,    0.005003,    0.001971}, {   0.001708,    0.001037,   -3.140480},
			{   0.003295,    0.002990,   -1.550776}, {   0.004639,    0.006728,   -0.193138}, {   0.007323,    0.004639,   -1.097018}, {   0.208373,    0.001067,   -1.162420}, {  -0.317627,    0.315468,   -1.155140}, {  -0.130737,    0.101837,   -0.521969}, {   0.006103,    0.000548,    0.025434}, {   0.003539,    0.003386,    0.002391},
			{   0.006041,    0.003951,   -0.342767}, {   0.001774,   -0.045467,    0.006374}, {   0.000487,    0.000388,    0.001725}, {   0.001200,    0.000765,    0.000078}, {   0.003864,    0.003677,   -0.011227}, {   0.018645,    4.179110,    1.487859}, {   0.002634,    0.003466,    0.002895}, {   0.001465,    0.000399,    0.000500},
			{   0.000851,    0.003984,   -0.092853}, {   0.007333,    0.013073,    4.070396}, {  -0.000548,    0.008654,    3.788665}, {   0.000365,    0.012558,    0.572461}, {   0.006103,    0.246291,    0.417528}, {   2.476317,    0.003203,    0.004672}, {   0.003599,    0.001274,    0.000368}, {   0.128144,   -0.009921,    1.112468},
			{  -0.068865,    0.189055,   -0.937909}, {  -0.074097,   -1.214874,    0.003336}, {   9.469848,  -10.844387,   -0.510998}, {  -0.776854,    0.386963,  -43.548862}, {   0.586277,    0.002565,    0.000572}, {   0.001566,    0.000480,   -0.836508}, {   0.005419,    0.002693,    0.006849}, {   0.003333,    0.001185,    0.002955},
			{  -0.043290,    0.005313,    0.006341}, {   0.003861,    0.006126,    0.002017}, {   0.000000,    4.997581,    0.002343}, {   0.461156,    0.000967,   -1.151659}, {   0.002544,    0.007387,    0.006151}, {   0.003013,    0.002576,    0.006012}, {  -7.785702,    1.673535,    8.513744}, {   0.000533,   -1.096778,   -1.351104},
			{  -0.887206,   -0.454605,   -0.665813}, {  -3.953030,   -4.080815,    0.046425}, {   0.000396,    0.003653,    0.003092}, {   0.503296,    0.000640,   -1.517797}, {   0.001098,    0.000701,    0.003428}, {   0.002318,    0.002410,   -0.794602}, {   0.007323,    0.002552,    0.002413}, {   1.105347,    0.005454,   -1.759215},
			{   0.000853,   -0.442687,    0.000707}, {   0.006225,    0.006515,   -0.730408}, {  -0.825073,   -0.314803,   -1.235587}, {  -0.688476,    0.004410,   10.225555}, {  -7.867842,    8.355504,    0.006204}, {  -0.775023,    0.006484,  -32.930351}, {  -0.227871,    0.002343,   -0.084930}, {   0.007408,    0.005206,   -0.113360},
			{  -0.002948,    0.004344,   -0.044684}, {  -0.222007,    0.002842,   -0.111162}, {  -2.492919,   -2.497901,   -1.441629}, {  -0.000125,    0.006194,    0.004552}, {   0.004067,    0.002960,    0.001311}, {  -0.090563,   -0.321285,   -0.120682}, {  -0.224621,   -0.262928,    0.004660}, {   0.005462,    0.004867,    0.005247},
			{  13.005491,   -0.009487,   -0.997852}, {  -0.100050,    0.004242,    0.003581}, {   0.003905,    2.314673,    0.004716}, {  -0.033018,   -0.016602,   -0.051724}, {  -0.200382,  -10.930023,    0.319882}, {  -9.791105,   18.060541,   -0.009531}, {   0.006275,    0.004273,    0.005075}, {   0.005208,    0.003248,    0.005938},
			{  -0.170838,    0.007546,   -0.429515}, {   0.002277,    0.003409,   -1.213801}, {   0.000775,    9.296113,    0.001992}, {   0.000912,    0.000530,    0.003548}, {   0.511295,    0.177910,    0.001575}, {   0.000744,    0.002336,    0.002544}, {   0.030050,    0.002372,    0.001890}, {   0.006682,    0.007664,    0.004664},
			{  -2.953722,   -2.252371,   -0.006475}, {   0.004894,    0.006560,   -0.536562}, {   0.005348,    0.003875,   -0.334663}, {   0.002815,    0.000157,   -0.487814}, {   0.002953,    0.001800,    0.003650}, {   0.000335,    0.005249,    0.001714}, {  -0.100399,    0.002290,    0.002167}, {   0.005611,    0.003225,    0.005657},
			{   0.004738,   -4.370578,   -0.241323}, {   0.346246,   -0.017558,   -2.981214}, {   0.008914,   -0.183179,   -0.083791}, {   1.657116,   -9.703849,    2.947097}, {   0.908499,   -9.964515,    0.789533}, {   2.567017,    0.001418,    0.001942}, {   0.004027,   -9.994560,    0.007230}, {   5.056042,    5.685572,    0.203658},
			{ -20.827455,   17.361200,   -0.011002}, { -21.226467,  -18.380502,   -1.215644}, {   9.350681,   -2.197851,   -1.261847}, {  -0.954998,   -0.257854,   -2.463829}, { -12.756141,   -1.478304,   -0.919890}, {  -2.961720,    1.587759,   -0.230353}, {  -5.397087,    0.001430,    2.752680}, {  -9.047893,    1.361006,   -0.129730},
			{   0.173920,   -0.396420,   -5.112955}, {  -5.082218,   -0.344078,   -0.462388}, {  -0.026946,   -0.009611,   -0.009398}, {  -6.548274,   -2.103760,   -0.007094}, {  -8.077651,    0.686842,   -0.396086}, { -17.288753,   -0.895959,   -1.686390}, {  -0.973886,   -1.253746,   -0.127204}, { -11.047883,    1.691957,   -0.008847},
			{  -7.340150,    0.008336,   -0.309527}, {   0.443264,    0.133411,   -0.352521}, {   8.802249,   -0.119018,   -0.609268}, { -13.246467,   -2.129543,   -0.156871}, {   4.263783,   -3.118472,   -0.176926}, { -16.406084,    0.005559,    0.599057}, { -18.594558,   12.218574,   -0.386839}, {   2.814537,   -1.153208,   -0.657364},
			{  10.744986,    8.982263,    0.297026}, {  10.584007,    4.327384,    0.001089}, {  -0.182589,    0.004337,   -0.999898}, {  -2.336790,   -4.290505,   -1.466328}, {  -1.143985,   -9.917921,   -1.993919}, {  19.785785,   -4.675933,   -0.023816}, {  -5.081346,    3.401268,   -0.806811}, {   1.561817,   -5.168944,    0.851298},
			{   0.006591,   -1.054810,   -1.098479}, {   0.004639,   -0.054320,   -1.429901}, {   0.005981,    0.002685,   -1.096187}, {   0.003250,    0.003185,    0.007559}, {  -1.502182,    3.006278,    0.001464}, {   0.006713,    0.006469,   -1.012961}, {   0.000533,   -1.096778,   -1.351104}, {   0.006225,    0.006515,   -0.730408},
			{   0.003539,    0.009429,    0.008797}, {   0.007323,    0.002552,    0.002413}, {   0.000487,    0.000388,    0.001725}, {   0.001200,    0.000765,    0.000078}, {   0.003864,    0.003677,   -0.011227}, {   0.018645,    4.179110,    1.487859}, {  -0.887206,   -0.454605,   -0.665813}, {   0.002634,    0.003466,    0.002895},
			{   0.003599,    0.001274,    0.000368}, {   0.586277,    0.002565,    0.000572}, {   0.003861,    0.006126,    0.002017}, {  -0.043290,    0.005313,    0.006341}, {   0.003333,    0.001185,    0.002955}, {   0.005419,    0.002693,    0.006849}, {  13.349743,  -10.020451,    0.005117}, {   0.001774,   -0.045467,    0.006374},
			{   0.005462,    0.004867,    0.005247}, {  -0.200382,  -10.930023,    0.319882}, {   0.005208,    0.003248,    0.005938}, {   0.000775,    9.296113,    0.001992}, {  -9.791105,   18.060541,   -0.009531}, {   0.006275,    0.004273,    0.005075}, {   0.006682,    0.007664,    0.004664}, {   0.002277,    0.003409,   -1.213801},
			{  -0.100050,    0.004242,    0.003581}, {  -7.867842,    8.355504,    0.006204}, {   2.476317,    0.003203,    0.004672}, {   0.006103,    0.246291,    0.417528}, {   0.000365,    0.012558,    0.572461}, {   0.007333,    0.013073,    4.070396}, {   0.004894,    0.006560,   -0.536562}, {  13.005491,   -0.009487,   -0.997852},
			{ -20.827455,   17.361200,   -0.011002}, {   9.350681,   -2.197851,   -1.261847}, {  -0.954998,   -0.257854,   -2.463829}, {  -2.953722,   -2.252371,   -0.006475}, {   0.173920,   -0.396420,   -5.112955}, { -17.288753,   -0.895959,   -1.686390}, {   0.008914,   -0.183179,   -0.083791}, {   0.346246,   -0.017558,   -2.981214},
			{  -7.340150,    0.008336,   -0.309527}, {   5.056042,    5.685572,    0.203658}, {  10.744986,    8.982263,    0.297026}, { -11.047883,    1.691957,   -0.008847}, {   0.443264,    0.133411,   -0.352521}, { -16.406084,    0.005559,    0.599057}, {   0.003905,    2.314673,    0.004716}, {   0.003539,    0.003386,    0.002391},
			{  19.785785,   -4.675933,   -0.023816}, {  -2.336790,   -4.290505,   -1.466328}, {  -0.973886,   -1.253746,   -0.127204}, {  -0.000548,    0.008654,    3.788665}, {  -0.068865,    0.189055,   -0.937909}, {   0.908499,   -9.964515,    0.789533}, {  -0.100399,    0.002290,    0.002167}, { -21.226467,  -18.380502,   -1.215644},
			{   0.461156,    0.000967,   -1.151659}, {   0.000000,    4.997581,    0.002343}, {  -0.688476,    0.004410,   10.225555}, {   0.030050,    0.002372,    0.001890}, {   0.511295,    0.177910,    0.001575}, {   0.002815,    0.000157,   -0.487814}, {  -0.133977,    0.006407,    0.000692}, {  11.774581,   -1.983294,  -32.470825},
			{  12.299390,   -1.328026,    4.783063}, {   1.071288,    0.005965,    5.586793}, {   0.135010,   -0.453658,   -0.935365}, {   0.001351,    0.001050,   -0.174326}, {   0.001178,    0.005324,   -0.116155}, {   0.007236,    0.005590,   -0.155909}, {  -0.219266,    0.005421,   -0.084930}, {  -0.195546,    0.000607,   -0.163225},
			{   0.003517,    0.000608,    0.002569}, {   0.005280,    0.004189,    0.000174}, {   0.004676,    0.007718,   -0.042514}, {  -0.087610,    0.221319,   -0.120682}, {   0.007567,    0.001647,    0.004373}, {   0.002196,    0.005950,    0.007224}, {   0.007445,    0.002990,    0.005911}, {  -0.002119,   -0.005613,    0.001502},
			{   1.301558,   -0.600391,   -1.909374}, {   0.001098,    0.000701,    0.003428}, {  -0.224621,   -0.262928,    0.004660}, {  -0.090563,   -0.321285,   -0.120682}, {  -0.087610,    0.221319,   -0.120682}, {  -0.000125,    0.006194,    0.004552}, {   0.005280,    0.004189,    0.000174}, {   0.004676,    0.007718,   -0.042514},
			{   0.004067,    0.002960,    0.001311}, {  -0.195546,    0.000607,   -0.163225}, {  -0.222007,    0.002842,   -0.111162}, {   0.005716,    0.005003,    0.001971}, {   0.003517,    0.000608,    0.002569}, {  -0.219266,    0.005421,   -0.084930}, {  -0.227871,    0.002343,   -0.084930}, {   0.000307,   29.024211,   -0.222816},
			{   0.007236,    0.005590,   -0.155909}, {   0.001178,    0.005324,   -0.116155}, {   0.007408,    0.005206,   -0.113360}, {  -0.002948,    0.004344,   -0.044684}, {   0.001351,    0.001050,   -0.174326}, {  -9.047893,    1.361006,   -0.129730}, {   0.135010,   -0.453658,   -0.935365}, {   1.286986,    0.004317,   -0.543083},
			{   0.001566,    0.000480,   -0.836508}, {   3.586791,    2.920058,    0.000533}, {   0.004639,   -0.054320,   -1.429901}, {   0.007445,    0.002990,    0.005911}, {   0.000912,    0.000530,    0.003548}, {   0.005611,    0.003225,    0.005657}, {   0.012206,    0.006744,    0.003112}, {   0.012206,    0.006744,    0.003112},
			{   0.802062,    4.184003,    0.361243}, {   0.003694,    0.000475,    0.001239}, {  -0.004110,   -0.006990,    0.007734}, {  -0.006537,    0.023218,    0.004329}, {   0.006850,    0.002650,    0.001516}, {   0.516498,    2.037218,   -0.902841}, {   0.000884,    0.001159,   -0.936662}, {  -6.349606,  -37.648452,    0.003609},
			{   0.007294,    0.005307,    0.000808}, {   0.967545,    0.006554,    0.004683}, {   0.003745,   -0.001654,    0.003459}, {  -7.715583,   -3.675298,   -1.365517}, {  -7.715583,   -3.675298,   -1.365517}, {   0.001411,    0.003395,    4.463737}, {   0.002598,    0.002103,    0.000403}, {   0.003254,   -0.002461,    0.003287},
			{   0.003341,    0.002760,    0.003086}, {  -0.000304,    0.004428,    0.006748}, {   0.007277,    0.002735,    0.001066}, {   0.007168,    0.000797,    0.001252}, {   0.004821,    0.005493,    0.001122}, {   0.006533,    0.004648,    0.002604}, {   0.006785,    0.000090,    0.000598}, {   0.005574,    0.002368,    0.003093},
			{   0.005104,   -0.002487,    0.002927}, {   0.158690,    0.005896,    0.008448}, {   0.002432,    0.002752,    0.001916}, {   0.000774,    0.001094,    0.000722}, {   0.002624,    0.002335,    0.002462}, {   0.001601,   -0.452390,   -0.550657}, {  -0.145630,    0.010177,   -0.578408}, {   0.000331,    0.002581,    0.001969},
			{  -0.145630,    0.010177,   -0.578408}, {   0.000884,    0.001159,   -0.936662}, {   0.000331,    0.002581,    0.001969}, {   0.002598,    0.002103,    0.000403}, {   0.003254,   -0.002461,    0.003287}, {   0.004738,   -4.370578,   -0.241323}, {   0.002624,    0.002335,    0.002462}, {   0.967545,    0.006554,    0.004683},
			{   0.002780,    0.000190,   -0.993438}, {   0.002780,    0.000190,   -0.993438}, {   0.003751,    0.002891,    0.001532}, {   0.003751,    0.002891,    0.001532}, {   0.516498,    2.037218,   -0.902841}, {   0.001601,   -0.452390,   -0.550657}, {   0.000774,    0.001094,    0.000722}, {   0.003694,    0.000475,    0.001239},
			{   0.003745,   -0.001654,    0.003459}, {   0.802062,    4.184003,    0.361243}, {   0.004821,    0.005493,    0.001122}, {   0.005574,    0.002368,    0.003093}, {  -0.000304,    0.004428,    0.006748}, {   0.003341,    0.002760,    0.003086}, {  -0.006537,    0.023218,    0.004329}, {   0.006850,    0.002650,    0.001516},
			{   0.001411,    0.003395,    4.463737}, {  -0.004110,   -0.006990,    0.007734}, {   0.007277,    0.002735,    0.001066}, {   0.007168,    0.000797,    0.001252}, {   0.158690,    0.005896,    0.008448}, {   0.002432,    0.002752,    0.001916}, {   0.006785,    0.000090,    0.000598}, {   0.001952,    0.007652,    0.005814},
			{  -0.004377,   -0.003942,    0.005700}, {   0.006533,    0.004648,    0.002604}, {  -6.349606,  -37.648452,    0.003609}, {   0.011718,    0.016110,    0.007778}, {   0.006508,    0.000130,    0.005818}, {   1.561817,   -5.168944,    0.851298}, {   0.007294,    0.005307,    0.000808}, {  12.537321,    8.794105,   -0.713428},
			{  12.299390,   -1.328026,    4.783063}, {   1.066895,    0.941223,    4.811984}, {   0.005954,    0.002716,    0.001127}, {   0.001972,    0.008263,    0.005588}, {   0.007567,    0.001647,    0.004373}, {   0.002196,    0.005950,    0.007224}, {   0.006103,    0.000548,    0.025434}, {   0.002318,    0.002410,   -0.794602},
			{   1.105347,    0.005454,   -1.759215}, {   0.000853,   -0.442687,    0.000707}, {   0.503296,    0.000640,   -1.517797}, {  -0.825073,   -0.314803,   -1.235587}, {   0.001708,    0.001037,   -3.140480}, {   0.006508,    0.000130,    0.005818}, {   0.003409,    0.001891,    0.000586}, {   0.003509,    0.005843,    0.006887},
			{   0.002929,    0.007201,    0.003382}, {   0.003905,    0.001189,    0.005195}, {   0.002151,    0.004623,    0.004085}, {   0.000701,    0.005996,    0.004110}, {   0.001656,    0.006446,    0.000974}, {   0.002846,    0.000358,    0.006599}, {   0.006149,    0.006424,    0.006657}, {   0.003181,    0.002239,    0.002981},
			{   0.004127,    0.001693,    0.002853}, {   0.004532,    0.004809,    0.003694}, {   0.004852,    0.007751,    0.007687}, {   0.005882,    0.003905,    0.004021}, {   0.007164,    0.007491,    0.000315}, {   0.006072,    0.007453,    0.003526}, {   0.000884,    0.001861,    0.002941}, {   0.002562,    0.004561,    0.001351},
			{   0.000426,    0.002975,    0.000083}, {   4.424404,   11.117952,    0.000262}, {   4.424404,   11.117952,    0.000262}, {  -0.151123,   -0.021209,  -32.927085}, {   0.005981,    0.003951,  -19.640905}, {   0.416251,   -0.681580,   -0.427255}, {   0.416251,   -0.681580,   -0.427255}, {  -0.155640,   -0.452208,  -33.457054},
			{   0.128144,   -0.009921,    1.112468}, {  -0.074097,   -1.214874,    0.003336}, {  13.349743,  -10.020451,    0.005117}, {  -2.681744,    4.089508,    6.128656}, {  11.774581,   -1.983294,  -32.470825}, {   0.003250,    0.003185,    0.007559}, {   1.657116,   -9.703849,    2.947097}, {  -2.492919,   -2.497901,   -1.441629},
			{   0.003409,    0.001891,    0.000586}, {  -1.502182,    3.006278,    0.001464}, {   3.586791,    2.920058,    0.000533}, {   9.469848,  -10.844387,   -0.510998}, {   0.004027,   -9.994560,    0.007230}, {   2.567017,    0.001418,    0.001942}, {   0.000853,    0.004424,    0.004197}, {   0.001595,    0.002609,    0.002765},
			{   0.007416,    0.004195,    0.007722}, {   0.001549,    0.001784,    0.007809}, {   0.002914,    0.005020,    0.000333}, {   0.006783,    0.003234,    0.005293}, {   0.005249,    0.000762,    0.000793}, {   0.000625,    0.001784,    0.003895}, {   0.006744,    0.005851,    0.002284}, {   0.005408,    0.002670,    0.004139},
			{  -2.681744,    4.089508,    6.128656}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.001586,    0.000411,    0.002485}, {   0.000976,    0.001464,    0.003186},
			{   0.003417,    0.001479,    0.002674}, {   0.002562,    0.002785,   -0.001104}, {   0.002318,    0.001857,   -0.112767}, {   0.000976,    0.000930,   -0.747312}, {   0.001220,    0.003830,    0.001353}, {  -0.001021,    0.008065,    0.010401}, {  -0.420226,   -0.417236,   -1.210888}, {   0.001159,    0.001571,    0.002345},
			{   0.006775,    0.004410,    0.002915}, {   0.000365,    0.015358,    0.002918}, {   0.002624,    0.000121,    0.003420}, {  -4.140502,   -6.251877,    5.070267}, {   0.003875,    0.007247,    0.003613}, {   0.006041,    0.007766,    0.000049}, {  -0.152711,   34.769748,  -12.667177}, {   0.004149,    0.002250,    0.003345},
			{   0.003722,    0.005584,    0.003415}, {   0.000731,    0.002982,    0.006618}, {   0.012792,    0.003599,  -13.776549}, {   0.013865,    0.007930,   -0.439574}, {   0.005466,    0.001485,    0.012842}, {   0.060958,   -0.103327,    0.173081}, {   0.027928,    6.620145,    0.001205}, {   0.003600,    0.005919,   16.177875},
			{   0.004753,   -0.014093,    0.004550}, {   4.867850,   -0.880707,   -3.963264}, {   0.005249,    0.000197,    0.006260}, {   0.005919,    0.004302,    0.006157}, {   0.005919,    0.000640,    0.006157}, {   0.006103,    0.001130,    0.006157}, {   0.006134,    0.001281,    0.006157}, {   0.006287,    0.000794,    0.006157},
			{   0.006409,    0.004333,    0.006157}, {   0.006103,    0.006225,    0.006258}, {   0.000915,    0.005264,    0.007790}, {   0.021911,    5.141070,    0.001604}, { -24.913005,   17.255054,    0.006163}, {   0.006849,   -0.197120,    0.001949}, {   0.007538,    3.988019,    0.005855}, {   0.002231,    0.000607,   -0.137446},
			{   5.288746,    2.913058,   -2.397631}, {   0.004257,   -0.002084,   -0.406145}, {   0.008853,    1.236256,    0.001729}, {   0.005843,    0.001695,    0.292968}, {   0.003600,    0.005919,   16.177875}, {   0.004753,   -0.014093,    0.004550}, {   0.000976,    0.001464,    0.003186}, {   0.001586,    0.000411,    0.002485},
			{   0.441195,   -1.101387,    0.004120}, {   0.002231,    0.000607,   -0.137446}, {   0.003631,    0.002227,    0.000140}, {   0.001037,    0.001656,    0.000500}, {   0.001159,    0.001571,    0.002345}, {   0.001586,    0.003616,  -11.597945}, {  -6.013346,    7.995337,    0.001297}, {   2.929295,   -9.091936,    0.001296},
			{  -4.840079,    5.910224,    0.001296}, {  10.687858,  -12.710426,    0.001297}, {   0.276903,   -0.753273,    0.001560}, {  25.957902,   -5.331246,    2.151103}, {  25.957902,   -5.331246,    2.151103}, {   0.276903,   -0.753273,    0.001560}, {   2.419461,  -15.074493,    0.333676}, {   0.003529,    0.004089,    0.414689},
			{  -1.565132,  -11.805770,  -12.601563}, { -36.031860,    3.194683,    0.003414}, {   0.000876,    0.002463,    5.529141}, {   0.004486,   -0.333678,    0.003415}, {  -7.494232,   -0.114536,   12.428544}, {  -8.009452,   -0.037666,    7.555817}, {  18.282295,    0.104225,  -33.716613}, {  -4.771252,    0.117900,   31.360980},
			{  -0.754680,   -0.218527,   -4.266019}, {   0.002929,   39.516181,    0.001913}, {   0.006508,    0.000548,   -4.269924}, {   0.004004,    0.003971,   -1.664373}, {  -0.025092,    0.005493,   -4.421528}, {   1.120239,    0.001648,    1.838389}, {   0.002261,    0.003498,   -0.166841}, {   0.056297,   -0.057700,   -0.268976},
			{   0.000853,    0.004220,    0.007726}, {   0.002646,    0.002646,  -14.804126}, {   0.006537,    1.753829,  -14.804126}, {   0.007850,    0.011928,    0.007813}, {  10.197257,   -9.361129,    1.257197}, {   0.209966,    0.059684,    0.017779}, {   0.549589,    0.002503,   -6.189291}, {   0.006599,    0.002433,    0.003054},
			{  -1.374508,   -1.831437,   -0.995407}, {   0.024336,    0.006064,   -2.850517}, {   0.003059,    0.007792,    0.005892}, {  -1.409489,   -1.726709,   -0.791849}, {  -1.694146,    0.277500,    0.085051}, {  -2.654798,   -1.669980,   -0.025601}, {   0.004416,    0.003749,    0.002641}, {  -0.889235,    0.416597,   -0.061712},
			{   0.001281,    0.001143,    0.003452}, {   0.002565,    0.000472,    0.001877}, {   0.002013,   -0.066501,    0.001429}, {   0.002868,    0.007294,   -1.882483}, {   0.000060,    0.000216,   -0.315946}, {   0.002565,    0.000472,    0.001877}, {   0.002261,    0.003255,    0.000171}, {   0.002746,    0.000579,    0.003127},
			{   0.000426,    0.001621,    0.003094}, {   0.000915,    0.002768,   -4.217507}, {   0.001037,    0.001632,    0.002379}, {   0.001037,    0.001656,    0.000500}, {   0.001586,    0.003616,  -11.597945}, {  22.825439,    0.001525,   -2.180757}, {   0.381451,    0.005772,    0.006721}, {   0.006750,    0.006376,    0.004606},
			{   0.002624,    0.000762,    7.137763}, {   0.008209,   -0.000637,   -0.000782}, {   0.003173,    0.001963,   -0.004116}, {   0.001715,    0.003132,   -1.708415}, {   0.002624,    0.000762,    0.003799}, {   0.000548,    0.001815,    0.002943}, {   0.003898,    0.003799,    0.000176}, {   8.087833,   -7.528619,   -5.606391},
			{  17.892063,    8.639921,   41.467643}, {   0.006601,    0.005830,    0.000686}, {   7.332253,    7.335831,    1.363275}, {  -9.390331,   10.273855,    1.283452}, {   0.000876,    0.002463,    5.529141}, { -36.031860,    3.194683,    0.003414}, {  -1.565132,  -11.805770,  -12.601563}, {   0.004149,    0.002250,    0.003345},
			{  -0.152711,   34.769748,  -12.667177}, {   0.004486,   -0.333678,    0.003415}, {   0.003722,    0.005584,    0.003415}, {   0.000976,    0.000930,   -0.747312}, {  -4.140502,   -6.251877,    5.070267}, {   0.000579,    0.005946,    0.007184}, {   0.007850,    0.011928,    0.007813}, {   0.000579,    0.005946,    0.007184},
			{   0.002261,    0.003498,   -0.166841}, {   0.003799,    0.003222,    0.006171}, {   0.002711,    0.001822,    0.003607}, {   0.002074,    0.007763,   -0.135995}, {  -1.409489,   -1.726709,   -0.791849}, {  -0.025092,    0.005493,   -4.421528}, {   0.000731,    0.002982,    0.006618}, {   0.007586,   -1.749572,  -10.538946},
			{   0.002646,    0.002646,  -14.804126}, {   0.004004,    0.003971,   -1.664373}, {   0.006508,    0.000548,   -4.269924}, {   0.006537,    1.753829,  -14.804126}, {  -0.754680,   -0.218527,   -4.266019}, {   0.013865,    0.007930,   -0.439574}, {   8.087833,   -7.528619,   -5.606391}, {   0.005237,    0.002304,   -1.211603},
			{   0.005752,    0.010834,   -1.213631}, {   0.004517,    0.004013,    0.002565}, {   0.005752,    0.010834,   -1.213631}, {   0.005237,    0.002304,   -1.211603}, {   0.004517,    0.004013,    0.002565}, {   0.002868,    0.007294,   -1.882483}, {  -1.694146,    0.277500,    0.085051}, {  -2.654798,   -1.669980,   -0.025601},
			{  -1.374508,   -1.831437,   -0.995407}, {  -0.889235,    0.416597,   -0.061712}, {   0.056297,   -0.057700,   -0.268976}, {   0.004416,    0.003749,    0.002641}, {   0.002074,    0.007763,   -0.135995}, {   0.002335,    0.004984,    0.004292}, {   0.002335,    0.004984,    0.004292}, {   0.002013,   -0.066501,    0.001429},
			{   0.002318,    0.001857,   -0.112767}, { -18.227844,    0.001621,    3.047667}, {   0.006750,    0.006376,    0.004606}, {  -0.420226,   -0.417236,   -1.210888}, {   0.001220,    0.003830,    0.001353}, {   0.006171,    0.001585,   -0.142021}, {  -0.297973,    1.046504,   -1.880489}, {   0.003417,    0.003250,    0.002283},
			{   0.000121,    0.000869,    0.000224}, {  -0.790618,    0.003020,   -0.106269}, {   0.002562,    0.001357,    0.002512}, {   1.449584,    0.000808,   -4.058320}, {  -9.321166,    0.002646,    0.003866}, {   0.004639,    0.005491,    0.001446}, {   0.002318,    0.005034,   -0.929180}, {   0.000182,    0.000564,   -0.225159},
			{  -0.686905,    0.419140,   -0.738027}, {   0.001281,    0.003631,    0.001387}, {   0.001347,    0.002044,    0.007602}, {   0.007567,   71.259643,   -1.471485}, {   0.002807,    0.000548,    0.002561}, {   0.508575,    1.103271,    0.116821}, {   0.004577,    0.006072,    0.007164}, {   0.003295,    0.000274,   -1.458660},
			{   0.002440,    0.003769,    0.002345}, {   0.003665,    0.001286,    0.000609}, {   0.006653,    0.003203,    0.001925}, {  -5.499684,   -3.255748,   21.827554}, {   0.006347,    0.006728,   -0.025971}, {  -0.332031,   -1.753098,    6.000473}, {   0.006916,   -1.969262,   10.942085}, {   0.429957,   -0.698549,   25.476787},
			{   0.003928,    0.001782,   -0.619701}, {   0.238487,    0.000383,    4.117609}, {   0.008895,    0.006395,   -8.324042}, {   0.008895,    0.007412,   12.078542}, {   0.003722,    0.005154,    0.004112}, {   0.001983,    0.001601,    0.002069}, {   0.003417,    0.002562,   -0.943584}, {   0.000243,    0.002868,   -1.782781},
			{   0.006409,    0.001830,   -0.141471}, {  -0.093139,    0.003661,    0.001599}, {  37.466979,    0.030060,   20.564073}, {   0.000243,    0.002868,   -1.782781}, {  -0.093139,    0.003661,    0.001599}, {  -2.392565,    2.380935,   -0.781545}, {   1.150686,    1.154221,   -0.030726}, {  -0.001075,    0.006450,   -0.970466},
			{   0.001586,    0.003830,    0.002618}, {   0.311978,  -15.856182,   -0.068452}, {  -2.015289,    0.005264,   -0.153852}, {   0.007201,    0.004180,    0.005623}, {   0.007019,    0.015045,   -0.517838}, {   0.002728,    0.005189,   -0.314123}, {   0.002752,    0.005437,    0.004139}, {   0.007257,    0.000569,   -0.034072},
			{  -0.001479,   -0.002542,    0.000942}, {   0.058221,    0.006085,   -0.367215}, {   0.002812,    0.003261,   -5.318606}, {   0.072394,    0.004846,    0.003905}, {   0.273162,   -0.134647,    0.004104}, {   0.005975,    0.005371,    0.002017}, {   0.007672,    0.002840,    0.006343}, {  -0.084457,   31.499897,   -0.994077},
			{   0.013601,    0.006407,   -0.059330}, {   0.000638,    0.002087,    0.006161}, {   0.000690,    0.001808,    0.010844}, {  -1.254009,   -0.046197,    0.338898}, {   0.003986,    0.001768,   -0.262335}, {   0.007588,    0.002685,   -0.146810}, {   0.004085,    0.007472,   -0.813363}, {   0.002257,    0.004521,   -0.323312},
			{   4.768364,    6.366866,    0.006269}, {  -0.328341,    0.006248,    0.004980}, {   0.002625,    0.000808,    0.000400}, {   0.006120,    0.007524,    0.005247}, {  -0.147040,   -0.390244,    5.902956}, {   0.007530,    0.055187,    0.006341}, {   0.004449,    0.006122,    0.006709}, {   0.000614,    0.001475,    0.004513},
			{   0.002186,    0.003197,    0.000837}, {   0.001098,    0.004714,    0.007251}, {   0.021500,    0.017480,    0.001091}, {  -4.687218,   -3.227088,   -1.334997}, {   0.001715,   -4.196287,    0.002033}, {  -0.027039,    0.003702,   -0.828615}, {  -0.738770,   -0.516968,   -0.406828}, {   0.000604,    5.133862,   -0.351628},
			{   0.001463,    0.006186,    0.000134}, {   0.006351,    0.006171,    0.003304}, {   0.048443,    0.004579,    0.001086}, {   0.015980,   -0.569931,    0.004658}, {   0.001488,   -3.975311,    0.002650}, {  14.308167,   23.755737,   -7.437727}, {   9.999830,    0.739690,   -0.080692}, {   0.006928,    0.002725,    0.003025},
			{   0.003665,    0.001286,    0.000609}, {   0.006171,    0.001585,   -0.142021}, {   0.006916,   -1.969262,   10.942085}, {  -5.499684,   -3.255748,   21.827554}, {   0.429957,   -0.698549,   25.476787}, {   0.006347,    0.006728,   -0.025971}, {   0.238487,    0.000383,    4.117609}, {   0.003928,    0.001782,   -0.619701},
			{  -0.332031,   -1.753098,    6.000473}, {  -0.050870,    0.242211,   -2.883384}, {   0.007257,    0.000569,   -0.034072}, {   0.002812,    0.003261,   -5.318606}, {   0.058221,    0.006085,   -0.367215}, {   0.273162,   -0.134647,    0.004104}, {   0.007588,    0.002685,   -0.146810}, {   0.072394,    0.004846,    0.003905},
			{   0.002186,    0.003197,    0.000837}, {   0.001098,    0.004714,    0.007251}, {   0.003986,    0.001768,   -0.262335}, {   0.004085,    0.007472,   -0.813363}, {   0.002257,    0.004521,   -0.323312}, {  -0.147040,   -0.390244,    5.902956}, {   4.768364,    6.366866,    0.006269}, {   0.007672,    0.002840,    0.006343},
			{   0.001715,   -4.196287,    0.002033}, {   0.005975,    0.005371,    0.002017}, {   0.000614,    0.001475,    0.004513}, {   0.004449,    0.006122,    0.006709}, {   0.007530,    0.055187,    0.006341}, {   0.006120,    0.007524,    0.005247}, {  -0.328341,    0.006248,    0.004980}, {   0.002625,    0.000808,    0.000400},
			{   0.048443,    0.004579,    0.001086}, {   0.008895,    0.006395,   -8.324042}, {   1.150686,    1.154221,   -0.030726}, {  -2.392565,    2.380935,   -0.781545}, {   0.002907,    0.006682,    0.000816}, {   0.005127,    0.005115,    0.001400}, {   0.002562,    0.001357,    0.002512}, {  -0.790618,    0.003020,   -0.106269},
			{   0.006601,    0.006118,    0.001453}, {  -4.687218,   -3.227088,   -1.334997}, {  -0.709716,  -10.278629,    0.003138}, {  -0.972289,    0.008034,    0.001896}, {   0.002562,    0.002975,   -0.889360}, {   0.488036,   -0.002304,    0.000962}, {  -0.428039,    0.009506,    0.005253}, {   0.006835,    0.007240,    0.005758},
			{   0.007201,    0.004180,    0.005623}, {   0.000121,    0.000869,    0.000224}, {  -0.001075,    0.006450,   -0.970466}, {   0.001281,    0.003631,    0.001387}, {   0.002013,    0.003173,    0.002561}, {  -0.011292,    0.002410,    0.004614}, {   1.551933,   10.608978,   -2.138380}, {   0.000609,    0.002532,    0.000142},
			{   0.488036,   -0.002304,    0.000962}, {   0.003029,   -0.815473,    0.000148}, {   0.006601,    0.006118,    0.001453}, {  -0.428039,    0.009506,    0.005253}, {   0.001769,    0.006713,    0.000350}, {  -0.709716,  -10.278629,    0.003138}, {   1.551933,   10.608978,   -2.138380}, {  -0.972289,    0.008034,    0.001896},
			{   0.010498,    0.677895,    0.001888}, {   0.006614,    0.003481,    0.000224}, {   0.003539,    0.004639,    0.005080}, {  -0.818403,    0.000380,   -0.704939}, {   0.007567,    0.006027,   -0.158155}, {   0.000587,    0.006570,    0.007803}, {   0.000628,    0.006157,    0.004933}, { -21.225994,    5.857905,   -0.104076},
			{   2.541631,   -3.967499,   -0.097828}, {   0.007693,  -21.129594,    0.006206}, {   0.009983,   -0.006457,    0.006407}, {   0.005034,    0.002947,    0.005580}, {   0.017720,   -0.039156,    0.619450}, {   0.004222,   -4.466197,    0.009031}, {  -1.868790,   -0.038279,    2.861721}, {   0.005435,    0.002361,   -0.017813},
			{   3.711716,   -0.580844,   -0.810555}, {   0.227836,    0.007385,   -1.041208}, {   0.881103,    1.016769,    0.001888}, {   0.001603,    0.006076,    0.006178}, {   0.001403,    0.002121,    0.001283}, {  -3.625972,    5.579237,    0.001576}, {  -0.004149,   -0.007342,    0.001557}, {   0.000974,    0.003949,   -0.138018},
			{   4.304703,    9.441925,   21.293775}, {   0.004211,    0.001204,    0.003610}, {   0.000121,    0.006484,    0.006856}, {   0.005005,    0.002227,   -0.970067}, {   0.005005,    0.002227,   -0.970067}, {   0.004821,    0.000075,   -1.673627}, {   0.002562,    0.002975,   -0.889360}, {   0.002640,    0.003731,    0.000944},
			{   0.006835,    0.007240,    0.005758}, {  -0.005553,    0.001411,    0.006293}, {   0.002907,    0.006682,    0.000816}, {   0.003808,    0.003684,    0.001857}, {   0.005127,    0.005115,    0.001400}, {  -0.011292,    0.002410,    0.004614}, {   0.000243,    0.005493,   -0.507224}, {   0.002257,    0.003142,    0.000216},
			{   0.002990,    0.003142,    0.002561}, {   0.002013,    0.003173,    0.002561}, {   0.002501,   -0.004149,   -0.075430}, {   0.002807,    0.002166,    0.002561}, {   0.003783,    0.005104,    0.001216}, {   0.003631,    0.002227,    0.000140}, {   0.003120,    0.001244,    0.002158}, {   0.002868,    0.001571,    0.002065},
			{   0.000304,    0.003220,    0.002929}, {   0.002318,    0.003525,    0.000077}, {   0.002685,    0.001183,    0.000559}, {   0.441195,   -1.101387,    0.004120}, {   0.000426,    0.002487,    0.003167}, {   0.002219,    0.002162,    0.003418}, {   0.003844,    0.001311,    0.003563}, {   0.001037,    0.001769,   -1.089053},
			{   0.001159,    0.001525,    0.003305}, {   0.002990,    0.002685,   -0.609588}, {   0.005491,    0.006293,    0.002593}, {   0.006229,    0.003464,    0.002131}, {   0.007019,    0.015045,   -0.517838}, {   0.007629,  -66.416900,   -1.471485}, {   0.003295,    0.000274,   -1.458660}, {  -0.084457,   31.499897,   -0.994077},
			{   0.001347,    0.002044,    0.007602}, {   0.001586,    0.001033,   -1.288367}, {   0.003299,   -0.218981,    0.035787}, {   0.007571,    0.001155,    0.012343}, {   0.002235,    0.001119,    0.009517}, {   0.007466,   -0.984730,   -0.014244}, {   0.004668,    0.005514,   -0.298406}, {  -0.738770,   -0.516968,   -0.406828},
			{  -1.868790,   -0.038279,    2.861721}, {  -0.818403,    0.000380,   -0.704939}, {  14.308167,   23.755737,   -7.437727}, {   0.003539,    0.004639,    0.005080}, {  -0.001479,   -0.002542,    0.000942}, {   0.227836,    0.007385,   -1.041208}, {  -0.686905,    0.419140,   -0.738027}, {   0.381451,    0.005772,    0.006721},
			{   0.006229,    0.003464,    0.002131}, {  -0.027039,    0.003702,   -0.828615}, {   0.004222,   -4.466197,    0.009031}, {   0.017720,   -0.039156,    0.619450}, {   0.021500,    0.017480,    0.001091}, {  -0.297973,    1.046504,   -1.880489}, {   0.311978,  -15.856182,   -0.068452}, {   0.508575,    1.103271,    0.116821},
			{   0.004577,    0.006072,    0.007164}, {  22.825439,    0.001525,   -2.180757}, {   0.007567,    0.006027,   -0.158155}, {   0.003808,    0.003684,    0.001857}, {   0.003029,   -0.815473,    0.000148}, {   0.000609,    0.002532,    0.000142}, {  -2.015289,    0.005264,   -0.153852}, {   0.002640,    0.003731,    0.000944},
			{   0.001769,    0.006713,    0.000350}, {   0.881103,    1.016769,    0.001888}, {   0.010498,    0.677895,    0.001888}, {   0.001037,    0.001632,    0.002379}, {   0.002868,    0.001571,    0.002065}, {   0.000548,    0.001815,    0.002943}, {   0.002624,    0.000762,    0.003799}, {   0.001403,    0.002121,    0.001283},
			{   0.003173,    0.001963,   -0.004116}, {   0.001715,    0.003132,   -1.708415}, {   0.000060,    0.000216,   -0.315946}, {   0.002746,    0.000579,    0.003127}, {   0.002261,    0.003255,    0.000171}, {   0.003783,    0.005104,    0.001216}, {   0.001281,    0.001143,    0.003452}, {   0.002807,    0.000548,    0.002561},
			{   0.002807,    0.002166,    0.002561}, {   0.002501,   -0.004149,   -0.075430}, {   0.000243,    0.005493,   -0.507224}, {   0.002257,    0.003142,    0.000216}, {   0.002990,    0.003142,    0.002561}, {  -0.005553,    0.001411,    0.006293}, {   0.005491,    0.006293,    0.002593}, {   0.001586,    0.003830,    0.002618},
			{   0.001037,    0.001769,   -1.089053}, {   0.003417,    0.002562,   -0.943584}, {   0.001159,    0.001525,    0.003305}, {   0.002990,    0.002685,   -0.609588}, {   0.003898,    0.003799,    0.000176}, {   0.000915,    0.002768,   -4.217507}, {   0.002562,    0.002785,   -0.001104}, {   0.002685,    0.001183,    0.000559},
			{   0.000426,    0.002487,    0.003167}, {   0.007538,    3.988019,    0.005855}, {   0.002219,    0.002162,    0.003418}, {   3.711716,   -0.580844,   -0.810555}, {   0.003120,    0.001244,    0.002158}, {   0.004211,    0.001204,    0.003610}, {   0.006775,    0.004410,    0.002915}, {   0.000365,    0.015358,    0.002918},
			{   0.002013,    0.001311,    0.003747}, {  -9.321166,    0.002646,    0.003866}, {   5.288746,    2.913058,   -2.397631}, {   0.002318,    0.005034,   -0.929180}, {   0.000182,    0.000564,   -0.225159}, {   1.449584,    0.000808,   -4.058320}, { -15.993965,   -0.138398,    9.778699}, {   0.003372,    0.000805,    1.397459},
			{   0.003372,    0.000805,    0.003596}, {   0.001464,    0.003281,    0.002728}, {   0.003372,    0.000805,    0.003655}, {   0.005249,    0.000197,    0.006260}, {   0.003173,    0.001599,    0.002282}, {   0.002013,    0.001311,    0.003747}, {   0.002440,    0.001460,    0.005129}, {   0.006775,    0.002379,    0.000081},
			{   0.006775,    0.001148,    0.002282}, {  -9.576801,   10.227335,   -0.129038}, {   0.000989,    0.006467,    0.003773}, {   0.000986,    0.002166,    0.003773}, {  -4.280947,  -13.238436,   -0.029242}, {  -4.136938,    0.001246,    1.525354}, {   0.001699,    0.000239,    0.000017}, {   0.001691,    0.003203,    0.002104},
			{   0.000432,    0.002243,    0.002470}, {   0.001108,    0.003151,    0.000273}, {   0.003279,    0.001564,    0.003500}, {  10.768022,    0.001602,    0.484786}, {   0.229213,    0.006031,    0.005805}, {   0.035863,    0.010300,   -0.001693}, {  -0.094481,   -9.970870,   -0.396008}, {  -0.094420,   -9.994918,   -0.396064},
			{  -4.771252,    0.117900,   31.360980}, {  -7.494232,   -0.114536,   12.428544}, {  -8.009452,   -0.037666,    7.555817}, {  18.282295,    0.104225,  -33.716613}, {   0.005828,    0.003753,  -15.948005}, {   0.007819,    0.000831,   -0.647090}, {   0.000609,    0.006591,    0.001344}, {   0.005065,   -0.036469,  -17.558771},
			{   0.005981,    0.000274,   -5.361422}, {   0.001525,    0.004120,    0.005747}, {   0.215941,    0.324368,   -0.129564}, {   0.005218,    0.004883,    0.001288}, {   0.000304,    0.002318,    0.005919}, {   0.002013,    0.003159,    0.002380}, {   0.005065,   -0.036469,  -17.558771}, {   0.007819,    0.000831,   -0.647090},
			{   0.005981,    0.000274,   -5.361422}, {   0.215941,    0.324368,   -0.129564}, {   0.000304,    0.002318,    0.005919}, {   0.005828,    0.003753,  -15.948005}, {   0.000609,    0.006591,    0.001344}, {   0.229213,    0.006031,    0.005805}, {   0.001488,   -3.975311,    0.002650}, {   0.006614,    0.003481,    0.000224},
			{   0.001463,    0.006186,    0.000134}, {  -0.031072,    0.000003,   -1.508242}, {   0.006775,    0.001145,   -1.157595}, {  -0.013411,   -0.027070,   -1.349302}, {   0.002440,    0.001460,    0.005129}, {   0.003173,    0.001347,   -1.291012}, {   0.003844,    0.001311,    0.003563}, {   0.005133,    0.004488,   -0.218022},
			{  -0.020741,    0.032876,    0.006178}, {   0.006849,   -0.197120,    0.001949}, {   2.541631,   -3.967499,   -0.097828}, {   0.005741,    0.001021,    0.007718}, {   0.003392,    0.001891,    0.003496}, {   0.003392,    0.001891,    0.003496}, {   0.000915,    0.001889,    0.007356}, {   0.000915,    0.001889,    0.007356},
			{   0.007586,   -1.749572,  -10.538946}, {   0.003934,    0.081757,    0.006624}, {   3.698120,    0.001327,    0.006223}, {   3.698120,    0.001327,    0.006223}, {   0.009889,    0.317122,    0.061958}, {   0.009670,    0.000353,    0.001612}, {   0.009670,    0.000353,    0.001612}, {   0.002740,    0.002204,    0.001614},
			{   0.002740,    0.002204,    0.001614}, {   0.221863,    0.005874,   -1.041157}, {   0.003905,    0.005080,   -0.481005}, {   0.003905,    0.005080,   -0.481005}, {   0.221863,    0.005874,   -1.041157}, {   0.005439,    0.004153,    0.007416}, {   0.007617,   -0.043705,    0.000349}, {   0.001952,    0.003020,    0.005144},
			{   0.001952,    0.003020,    0.005144}, {   0.000030,    0.006004,    0.002001}, {   0.000487,    0.001307,    0.002263}, {   0.000853,    0.005061,    0.002655}, {   0.000853,    0.005061,    0.002655}, {   0.007617,   -0.043705,    0.000349}, {   0.000487,    0.001307,    0.002263}, {   0.000030,    0.006004,    0.002001},
			{  -0.056726,    0.006312,    0.001764}, {   0.002790,   -0.009619,    0.009070}, {   1.305588,   -0.595538,   -1.901805}, {  -0.002521,   -0.120250,   -0.004672}, {   0.002624,   -7.766150,    0.006570}, {   0.001256,    0.000257,    0.005601}, {   0.005944,    0.006411,   -0.515413}, {   0.001084,   -0.003052,    0.003711},
			{   0.005439,    0.004153,    0.007416}, {   0.001256,    0.000257,    0.005601}, {   0.005944,    0.006411,   -0.515413}, {   0.002624,   -7.766150,    0.006570}, {  -0.015441,    0.000622,   -0.018581}, {   0.008209,   -0.000637,   -0.000782}, {   9.454723,    2.785254,   -0.128246}, {  -0.005605,    0.001221,   -0.433815},
			{   9.454723,    2.785254,   -0.128246}, {   0.005843,    0.001695,    0.292968}, {   0.004257,   -0.002084,   -0.406145}, {   0.008853,    1.236256,    0.001729}, {   0.006897,    0.007071,    0.007003}, {   0.006897,    0.007071,    0.007003}, {  -0.000636,   -0.002630,    0.000448}, {   0.004821,    0.000075,   -1.673627},
			{   0.000121,    0.006484,    0.006856}, {   0.006347,    0.006850,    0.005725}, {  37.466979,    0.030060,   20.564073}, {   0.002518,    0.007639,    0.003911}, {   0.002518,    0.007639,    0.003911}, {   4.304703,    9.441925,   21.293775}, {   0.000670,    0.001433,    0.000524}, {   0.002929,    0.000670,    0.001328},
			{   0.000670,    0.001433,    0.000524}, {  -0.008301,    0.001342,    0.004058}, {  -0.008301,    0.001342,    0.004058}, {   0.000365,    0.004807,   -0.303339}, {   0.002318,    0.003525,    0.000077}, {   0.000304,    0.003220,    0.002929}, {   0.005435,    0.002361,   -0.017813}, { -15.993965,   -0.138398,    9.778699},
			{   2.187011,    0.005371,    0.001287}, {   0.005615,    0.006229,    0.005934}, {   0.005615,    0.006229,    0.005934}, {   0.003417,    0.001479,    0.002674}, {   0.003417,    0.003250,    0.002283}, {   0.002929,    0.000670,    0.001328}, {   0.006347,    0.006850,    0.005725}, {   0.002805,    0.069309,    0.000515},
			{  -0.056249,    0.004209,    0.000515}, {   0.005741,    0.001021,    0.007718}, {   0.006775,    0.005646,   -0.450498}, {   0.004943,    0.007050,    0.000434}, {   0.007629,  -66.416900,   -1.471485}, {   0.003722,    0.002074,    0.003343}, {   0.003722,    0.002074,    0.003343}, {   0.001113,   -0.006850,    8.040846},
			{   0.001113,   -0.006850,    8.040846}, { -24.913005,   17.255054,    0.006163}, {   0.007567,   71.259643,   -1.471485}, {   0.006928,    0.002725,    0.003025}, {   9.999830,    0.739690,   -0.080692}, {   0.003529,    0.004089,    0.414689}, {  -2.123016,   -2.597465,   -1.667690}, {   4.867850,   -0.880707,   -3.963264},
			{   0.015980,   -0.569931,    0.004658}, {   0.003722,    0.005154,    0.004112}, {   0.001983,    0.001601,    0.002069}, {   0.002223,   -0.001418,    0.004093}, {  -0.006740,    0.002460,    0.001362}, {  -0.006477,    0.002846,    0.002850}, {  -0.005375,   -0.001438,    0.002428}, {   2.487227,    0.125600,    0.000050},
			{  -4.399415,   -6.147925,    0.027125}, {   2.262691,   -2.008141,    0.000547}, {  -4.524024,   -0.985503,   -0.233085}, {   0.005133,    0.004488,   -0.218022}, {   0.003444,    0.000709,    0.002752}, {   0.000300,    0.000104,    0.000728}, {   0.003434,    0.003039,   -0.518500}, {   8.007118,    9.846208,    0.629911},
			{   0.007025,    0.003628,    0.005036}, {   0.139731,   -4.509621,    0.003501}, {   0.002800,    0.004807,    0.001968}, {   0.070704,    1.663120,   -1.529216}, {   0.007660,    0.007176,    0.003800}, {   0.008895,    0.007412,   12.078542}, {   0.004943,    0.007050,    0.000434}, {   0.006775,    0.005646,   -0.450498},
			{   0.004149,    0.008395,    0.560195}, {   0.002440,    0.007724,    0.559445}, {   0.002752,    0.005437,    0.004139}, {   0.006653,    0.003203,    0.001925}, {   0.012792,    0.003599,  -13.776549}, {   0.000426,    0.001621,    0.003094}, {   0.006591,    0.039648,    0.552872}, {   0.002624,    0.000762,    7.137763},
			{ -18.227844,    0.001621,    3.047667}, {   0.003661,    0.026243,    0.001506}, {  -0.039657,   24.877286,    4.782028}, {   9.344413,  -13.716575,  -46.872306}, { -42.694942,   10.047340,   22.604175}, {   0.003783,   -0.000121,    0.006759}, {   0.007201,    0.000121,    0.006759}, {   0.006409,    0.001830,   -0.141471},
			{  -0.006211,   -0.006910,    0.000515}, {  -0.015823,    0.002539,    1.935973}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.006694,    0.001275,    0.007695}, {   0.007323,    0.004149,    1.066244}, {   0.000081,   -0.004811,    0.904542}, {  -0.000192,   -0.002151,   -5.929637},
			{   5.041381,   -0.944823,   -8.774261}, {  -2.085675,    1.164011,   -0.114118}, {   0.007263,    0.003539,    1.714007}, {   3.334259,    0.008789,   -2.069725}, {   0.005280,    0.003112,    0.006903}, {   0.002349,    0.000304,    0.003728}, {   9.932312,   -1.808472,    0.005386}, {  -0.160159,    0.184865,    0.308546},
			{  -0.001571,    0.006560,    3.299998}, {   0.003539,    0.006531,    0.003366}, {   1.793308,   -2.950242,    1.109619}, {   0.108139,    0.001466,   -0.915606}, {  -1.211014,    1.425354,    2.066509}, {   6.646912,    1.701904,    1.749312}, {   0.006926,    0.002746,    0.443264}, {   0.510667,   10.121427,   11.760913},
			{  -0.281219,    4.571350,    3.399447}, {  -0.940948,   -1.301025,    1.198554}, {  -0.143859,    2.099976,    2.780639}, {  -0.298339,    0.712401,    1.443626}, {   0.009643,    0.033861,    1.809934}, {   0.305054,   -0.703369,    1.443626}, {   0.949005,    1.309509,    1.198554}, {   0.034233,   -0.001557,    1.808735},
			{   0.006835,    0.004211,    0.002803}, {   0.005431,    0.000121,    0.300787}, {   0.000243,    0.005125,    0.000536}, {   0.787598,    0.003661,    2.264972}, {  -0.019531,    0.008666,   -0.519765}, {   0.006725,    0.105527,   -0.981734}, {  -2.592590,    2.912964,    3.354582}, {   0.007468,    0.105031,   -0.803155},
			{   0.002135,    0.003783,    0.002876}, {   0.287079,   -4.566771,    3.395144}, {  -0.298949,    0.710693,    1.443420}, {  -0.003295,   -0.028477,    1.804715}, {   0.004333,    0.005981,    0.005030}, {   0.001708,    0.000000,   10.944641}, {   0.544341,   -1.960571,   -0.108287}, {   0.000442,    0.001708,    0.590125},
			{  -0.005524,    0.001555,    1.483621}, {  -0.732086,   -0.324523,    0.001422}, {  -0.896973,   -0.285950,   -5.188171}, {   0.013732,    0.010192,   -0.754109}, {  -0.005512,    0.002440,   -0.096160}, {   0.406998,    0.307007,    2.587899}, {   0.041625,    0.003741,   -0.858258}, {   0.004683,    0.005127,    0.002337},
			{  -1.498962,   -0.273620,    1.366057}, {  -1.498595,   -0.274120,    2.776206}, {   0.046721,    0.176941,   -0.001933}, {   0.006835,    0.005981,    0.001434}, {   0.006622,   -0.067870,    0.002828}, {  -0.089446,   -2.064331,   38.115119}, {   0.006134,    0.000792,    0.005553}, {  -4.241608,    8.419756,    1.783503},
			{  -0.050322,    0.000487,   -0.459646}, { -12.937286,   -9.395965,    0.005497}, {  -2.287200,   -1.645477,    0.005497}, {   0.016602,   -0.332435,    0.408654}, {   0.002314,  -12.448940,  -30.914920}, {   5.905739,   -9.681154,  -30.915111}, {   0.004410,  -12.442422,  -30.914707}, {  -6.073565,   -9.678720,  -30.915637},
			{   0.005524,   -0.000060,    0.259772}, {   0.003476,   -0.934269,    9.585424}, {   1.338268,   -1.315623,    5.692594}, {  -0.207595,    7.925963,    3.296499}, {   0.005859,    0.007019,    3.829134}, {   0.048873,    0.000890,    0.436486}, {  -0.062458,   -0.067002,    1.745692}, {  -0.000508,   -0.000921,   -0.144906},
			{   1.021247,    0.001736,   -2.599999}, {  -0.022857,    0.169486,    4.069677}, {  19.795450,   49.178062,   12.510708}, {   0.003300,    6.837049,    0.624957}, {   0.211063,   -0.086790,    4.145209}, {   0.166593,    0.023726,    2.813947}, {  -0.066996,   -0.044385,    3.779850}, {  -0.075011,   -0.067378,    1.821409},
			{  -0.047102,   -0.049626,    2.100579}, {  -0.110616,   -0.819276,   -1.059450}, {   0.005797,   19.622695,  -80.325263}, {  -1.694702,    7.473754,  -95.059135}, {   1.050529,    5.647827,  -80.044914}, {   0.002929,   -5.782104,   -2.199111}, {   0.000487,    0.004761,   -2.924240}, {   0.405539,    0.001952,    0.005563},
			{   0.001098,    0.004639,   -4.801640}, {   0.006775,    0.004517,    0.006564}, {   0.005309,   -0.172362,    0.005195}, {   0.001037,    0.001289,    0.001645}, {   0.003783,    0.000487,    0.002002}, {   0.004883,    0.002379,  -10.791475}, {   4.202880,    0.003295,   -5.444618}, {   0.004517,    0.002868,    0.391438},
			{   0.001952,    0.004577,    0.005549}, {   0.005462,    0.003600,    0.000895}, {   0.455078,    0.006835,   -2.341044}, {   0.000030,    0.003417,   -5.543513}, {   0.003967,    0.002562,    0.002911}, {   0.005493,    0.003356,    0.004772}, {  -0.119202,    0.006347,    2.037048}, {   0.001464,    0.000976,   -1.270076},
			{   0.000396,    0.000426,    3.348685}, {   0.004608,    0.189815,    0.002162}, {   7.206116,    0.002440,    0.003799}, {   0.005797,    0.000121,    3.372452}, {   0.006409,    0.352378,    0.004985}, {   0.005919,   -0.253632,   -2.044389}, {  -1.994408,    0.001098,    0.007278}, {   0.002166,    0.005249,    0.003755},
			{  -0.528698,    0.005981,    0.004046}, {  -0.001800,   -0.549682,   -2.036190}, {   0.002807,  -19.260253,    0.007809}, {  -7.255711,    4.597026,  -19.947746}, {   0.002907,    4.598529,  -19.947750}, {   0.003837,    0.002677,  -14.394886}, {   0.006347,    0.006835,   -0.523648}, {   0.002013,    0.001428,    0.004085},
			{  -0.024621,   -4.907333,    0.004459}, {  -0.000007,   -2.458519,    2.350255}, {   0.006297,   -0.003103,    2.743062}, {   0.001276,    0.003543,    0.005843}, {   0.006568,    0.001163,    0.007404}, {  -0.156154,   -6.612493,    3.665399}, {   0.002383,    0.003840,    0.000844}, {   0.004581,    0.000609,    0.005005},
			{   0.000000,    0.001037,    1.879876}, {   8.827271,    0.000121,    0.004120}, {   0.000153,    0.003173,    4.570938}, {   0.000548,    0.005615,    0.004162}, {  -4.348107,   19.434816,   -1.114964}, {  -2.199157,    0.676208,    0.830088}, {   0.002562,    0.004517,    0.004972}, {   0.000243,    0.003600,   -2.857146},
			{   0.001975,    0.002318,    0.007490}, {   7.193531,    5.001375,   -0.068709}, { -14.377059,    7.803927,    1.373623}, {   5.234230,    7.111800,    0.045915}, {   0.006438,    0.001891,    0.005090}, {  -2.960541,    0.004271,    0.085671}, {  -0.154924,    0.193856,    0.305550}, {   1.810758,   -3.877441,    2.991034},
			{  -4.816559,   -1.070186,    0.390332}, {   0.004683,    0.005127,    0.002337}, {   0.006835,    0.005981,    0.001434}, {  -1.827733,  -45.419158,    3.280985}, {   0.004141,    0.003984,    0.897270}, {   0.000396,    0.000426,    3.348685}, {   0.004608,    0.189815,    0.002162}, {   7.206116,    0.002440,    0.003799},
			{   0.002349,    0.000304,    0.003728}, {  -0.001800,   -0.549682,   -2.036190}, {   0.002807,  -19.260253,    0.007809}, {   0.003837,    0.002677,  -14.394886}, {  -7.255711,    4.597026,  -19.947746}, {   0.002907,    4.598529,  -19.947750}, {   0.001464,    0.000976,   -1.270076}, {   0.005797,    0.000121,    3.372452},
			{  -0.119202,    0.006347,    2.037048}, {   0.006775,    0.004517,    0.006564}, {   0.004883,    0.002379,  -10.791475}, {   4.202880,    0.003295,   -5.444618}, {   0.455078,    0.006835,   -2.341044}, {   0.002929,   -5.782104,   -2.199111}, {   0.003783,    0.000487,    0.002002}, {   0.004517,    0.002868,    0.391438},
			{   0.001952,    0.004577,    0.005549}, {   0.005462,    0.003600,    0.000895}, {   0.003967,    0.002562,    0.002911}, {   0.005493,    0.003356,    0.004772}, {   0.000000,    0.001037,    1.879876}, {   8.827271,    0.000121,    0.004120}, {   0.000243,    0.003600,   -2.857146}, {  -2.592590,    2.912964,    3.354582},
			{   0.005431,    0.000121,    0.300787}, {   0.787598,    0.003661,    2.264972}, {   0.004141,    0.003984,    0.897270}, {   0.000081,   -0.004811,    0.904542}, {  -0.156154,   -6.612493,    3.665399}, {   0.000442,    0.001708,    0.590125}, {   0.006835,    0.004211,    0.002803}, {   1.901152,    0.434089,    0.000804},
			{   0.003868,    0.000525,    0.005599}, {   0.005836,    0.004848,    0.002275}, {   0.006087,    0.000792,    0.007094}, {  -0.063124,    0.074470,   -0.981555}, {  -0.000007,   -2.458519,    2.350255}, {   0.006297,   -0.003103,    2.743062}, {   0.001276,    0.003543,    0.005843}, {  -0.022857,    0.169486,    4.069677},
			{   0.048873,    0.000890,    0.436486}, {  -0.062458,   -0.067002,    1.745692}, {   1.338268,   -1.315623,    5.692594}, {  -0.000508,   -0.000921,   -0.144906}, {  -0.732086,   -0.324523,    0.001422}, {  -0.896973,   -0.285950,   -5.188171}, {  -0.005524,    0.001555,    1.483621}, {  -1.553411,   12.795234,    0.216477},
			{   0.544341,   -1.960571,   -0.108287}, {   0.001098,    0.004639,    0.005518}, {   0.002715,    0.004395,    0.004302}, {   0.002257,    0.000365,    0.000913}, {   0.003722,   -1.472869,   -4.338202}, {  -0.453491,   35.139572,  -63.472999}, {   0.006694,    0.001275,    0.007695}, {   0.589321,    0.006736,    0.007042},
			{  -0.453491,   35.139572,  -63.472999}, {   0.005797,   19.622695,  -80.325263}, {  -1.694702,    7.473754,  -95.059135}, {   1.050529,    5.647827,  -80.044914}, {   0.001098,    0.004639,   -4.801640}, {   0.405539,    0.001952,    0.005563}, {   0.006409,    0.352378,    0.004985}, {   0.005919,   -0.253632,   -2.044389},
			{  19.795450,   49.178062,   12.510708}, {  -4.348107,   19.434816,   -1.114964}, {   0.001037,    0.001289,    0.001645}, {   0.000487,    0.004761,   -2.924240}, {   0.005309,   -0.172362,    0.005195}, {   0.000030,    0.003417,   -5.543513}, {   0.003722,   -1.472869,   -4.338202}, {   0.002135,    5.554199,  -78.586791},
			{   0.002135,    5.554199,  -78.586791}, {   0.002314,  -12.448940,  -30.914920}, {   5.905739,   -9.681154,  -30.915111}, {   0.004410,  -12.442422,  -30.914707}, {  -6.073565,   -9.678720,  -30.915637}, {  -2.199157,    0.676208,    0.830088}, {   0.005859,    0.007019,    3.829134}, {   0.000548,    0.005615,    0.004162},
			{   0.006347,    0.006835,   -0.523648}, {   0.001975,    0.002318,    0.007490}, {   0.000153,    0.003173,    4.570938}, {   0.002166,    0.005249,    0.003755}, {  -1.994408,    0.001098,    0.007278}, {  -0.528698,    0.005981,    0.004046}, {   9.932312,   -1.808472,    0.005386}, {  -0.013148,   -1.611065,    3.100567},
			{  -2.660180,    0.143682,    0.166867}, {   0.001046,    0.003683,    0.003856}, {   0.007418,   -0.016330,    0.006337}, {  -0.000192,   -0.002151,   -5.929637}, {  -2.085675,    1.164011,   -0.114118}, {  -1.211014,    1.425354,    2.066509}, {   3.334259,    0.008789,   -2.069725}, {   0.000243,    0.005125,    0.000536},
			{   0.002135,    0.003783,    0.002876}, {   0.002013,    0.001428,    0.004085}, {  -1.508172,   -1.743932,    3.528650}, {  -1.508172,   -1.743932,    3.528650}, {   2.935283,   -1.544788,    3.335982}, {  -0.008523,   -0.003256,    1.940760}, {   0.001142,    0.002902,    0.002292}, {   0.002399,    0.000838,    0.002424},
			{   0.005439,    0.006878,    0.006411}, {   5.138167,   32.508125,    2.177977}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.006653,    0.001204,   -0.004900}, {   0.007079,    0.004817,    0.002362}, {   3.578826,    0.470169,   -0.158637}, {   0.050719,    0.005828,    0.003938}, {   5.081467,  -21.858390,    1.271993}, {   0.132707,    0.119736,   -0.968657}, {   0.577876,   -0.062389,   -0.513970}, {   0.004269,    0.004211,    0.000751},
			{  -0.017797,   -0.053943,   -0.418610}, {  -0.776237,    4.872554,    1.589699}, {  -3.403899,   -1.605548,    5.003746}, {   0.006302,    0.007796,    0.002026}, {   0.006591,    0.003036,    0.005136}, {   0.010077,    0.001082,    0.000503}, {   0.003051,    0.005797,    0.006843}, {   0.006957,    0.007027,  -14.152260},
			{   0.000000,    0.005553,   -0.115152}, {  -0.022216,    0.004852,    0.002312}, {   0.004883,    3.025142,    0.007000}, {   0.002318,    0.004027,    0.006010}, {   0.007079,  -14.995162,    0.007205}, {  -2.536870,   -4.164186,    0.030316}, {  -0.478882,   -6.497963,   -0.760367}, {   0.007522,    0.004317,    0.000620},
			{ -12.926086,  -17.841384,  -15.136751}, {  14.530036,   33.092803,   -0.339724}, {   0.001342,    0.007613,    0.006661}, {  -4.752215,    3.518728,   -0.439664}, {   0.001464,    0.006134,    0.000334}, {   0.003173,    0.007050,    0.005615}, {   0.007141,    0.006668,    0.005245}, {  -0.095946,   -0.071762,    0.049042},
			{  -0.157654,    0.006835,    0.006806}, {   0.005919,    0.006591,    0.004277}, {   0.006469,    0.018813,    0.003850}, {   0.005005,    0.003159,    1.501989}, {   0.127075,    0.001968,    0.006496}, {   0.003661,    0.002891,    0.007741}, {  -3.294183,   -0.103515,    0.285905}, {   0.051290,    0.047113,   -0.040095},
			{   0.355713,    1.142523,   -2.151432}, {  -0.800463,    0.001966,    0.028163}, {  -0.005309,   -0.003645,    0.001468}, {  -2.492640,   -1.352009,    5.071416}, {   0.005962,    0.002896,    0.003723}, {  -0.023466,   -0.203957,    0.007418}, {  -0.003838,    0.009479,    0.001249}, {   3.402867,    6.243875,    4.329449},
			{   0.729065,    0.002029,    0.000661}, {   0.000203,    0.005315,    0.058864}, {  -6.858917,    1.854580,    5.654172}, {  12.395614,   25.362548,   -8.715681}, {   0.003112,    0.007416,    1.252910}, {  -5.354967,    0.004333,    1.135998}, {   0.007493,    0.864993,    0.007418}, {   0.003002,    0.003395,   -0.584324},
			{   0.002916,    0.003710,    0.003809}, {  -0.266690,   -0.244513,   -0.979251}, {   0.006339,    0.001320,    0.004199}, {  -1.996474,    7.002501,    4.002707}, { -19.393690,  -17.748943,    5.826666}, {  -3.999627,   14.002004,    6.004571}, {   0.002083,    0.005557,   -1.071967}, {   0.152137,    0.254395,    3.000176},
			{   0.007629,    0.006957,    0.002094}, {   3.840332,    0.553893,   -2.680423}, {   0.000000,    0.000751,   -0.023248}, {   0.001586,    0.000472,    0.000497}, {   0.005371,    0.000594,   -0.042050}, {   0.000000,    0.001891,    0.004741}, { -41.386474,    0.002158,   18.958332}, {   0.002685,    0.003982,    0.005867},
			{  -1.567780,    1.307800,   -2.029120}, {   2.204857,    7.059638,    2.805480}, { -32.069618,    2.303431,    0.264254}, { -18.447731,  -42.000782,    4.652180}, {   0.007079,    0.003426,    0.003622}, {   0.001830,    0.006957,    0.001766}, {   0.001464,    0.004486,    0.001269}, {   0.005371,    0.007079,    0.006146},
			{   0.004639,    0.005638,   -0.641430}, {   0.001342,    0.002876,    0.007683}, {   0.003539,    0.007263,    0.006463}, {   0.004883,   -0.867935,    0.002219}, {   0.001830,    0.006835,    0.000983}, {   0.000243,    0.003959,    0.000330}, {   0.002501,    0.002609,    0.002203}, {   0.007019,    0.007209,    0.000707},
			{   0.001586,    0.001030,    0.004226}, {   0.006713,    0.129188,    0.004236}, {  -0.004681,    0.000945,    0.001350}, {   3.772979,   -2.618346,    0.334968}, {   0.007201,    0.006072,    0.085042}, {   0.005280,    0.000487,    0.001261}, {   0.005859,    0.003020,    0.007185}, {  -1.021255,    0.004395,    1.585464},
			{  -0.209594,   -2.464946,    0.582418}, {  16.825988,    0.553146,    1.601454}, {   0.006165,    0.000153,    0.993219}, {   1.019104,    0.002624,   -0.006002}, {   0.004699,    0.006378,    0.004015}, {   0.007263,    0.001754,    0.002918}, {   0.005156,    0.003417,    0.002902}, {   0.003051,    0.006500,    0.002891},
			{   0.007019,    0.005584,    0.002255}, {   0.007019,    0.099266,    0.004468}, {   7.904061,    1.046633,   -0.003345}, {   1.947304,    7.586790,   -0.012598}, {   3.962341,   -3.483886,    6.938522}, { -26.843385,  -19.332685,   -0.054069}, {   0.168657,    4.864842,   -2.576806}, {  -0.276841,   -0.477842,   11.503585},
			{   0.008391,   -0.000069,    0.003586}, {   0.003457,    0.006585,   -0.123970}, {   0.002888,    0.001551,    0.007315}, {   0.009819,   -0.004042,    4.591865}, {  -7.424015,  -32.928565,  -19.190845}, {  -0.045001,   -3.258301,    1.507349}, {  -0.039438,   -3.256076,    1.507349}, {  -0.012151,    0.015242,    5.298993},
			{  -0.009569,    0.010111,    5.266393}, {   0.004505,    0.005669,    0.004292}, {  -0.001292,   -0.009633,    0.001951}, {   0.000184,    0.003740,    0.002794}, {   0.003051,   13.379463,    7.107298}, {   0.001477,    0.000798,    2.814857}, {  -0.055422,   -0.447263,    1.538552}, {   0.002940,    0.034120,   -0.110040},
			{  -0.094927,   -0.081114,    2.656147}, {   0.001481,    0.000799,    2.814857}, {  -0.281208,    5.490549,   -0.044868}, { -34.974388,   24.548618,   37.334964}, {   0.603507,    1.188169,    0.011590}, {   0.001237,    0.001137,    0.006682}, {  -2.689418,   15.088296,    0.018944}, {   0.003655,    0.004918,    0.001936},
			{   0.006767,    0.003181,    0.002624}, {  -3.905107,    0.085165,   -0.106059}, {   0.001258,   -1.025161,   -0.017371}, {   0.003112,    0.005797,    0.005855}, {   0.004860,   -1.025161,   -0.017371}, {   0.003110,    0.052820,    5.250244}, {   0.102211,    0.084151,    2.659859}, {   0.006167,    0.002236,    2.818569},
			{  -0.483355,    0.095868,    2.505688}, {  -1.008026,    0.006949,    5.000287}, {   0.107055,    0.002040,    3.006871}, {   0.073532,    0.424365,    3.971227}, {  -9.077672,  -11.103365,    4.746177}, {  -1.533067,    0.005698,    2.756870}, {  -0.046856,    1.807456,    1.147418}, {   0.811074,   -0.171643,    4.506856},
			{  -0.333617,    6.716670,    0.032779}, {   0.004867,    0.001624,    0.004007}, {   1.575840,   -4.417636,    0.571316}, {  -0.631178,   -7.889784,   -0.931378}, {  -0.000922,    0.005384,   -0.210677}, {   0.001325,    0.001778,   -0.042229}, {  -2.438513,   -1.364500,    0.882627}, {   3.756398,   -3.993649,    2.663589},
			{   2.190679,  -11.146245,    5.561728}, {   0.001566,    0.004013,    0.001064}, {   9.075567,  -20.751424,    4.509431}, {   1.578441,    0.001288,    0.002920}, { -11.976035,   -7.622044,    4.756865}, {   0.002746,    0.003051,    0.004389}, {  -0.005241,   -0.007075,    0.005499}, {   0.006378,    0.007774,    0.008661},
			{   0.541534,    3.078696,    0.006872}, {  -4.097579,    0.695724,   -2.002922}, {   0.003220,    0.006225,    0.002044}, {   0.003616,    0.001250,    0.007730}, {   0.006583,    0.002681,    0.003341}, {   0.230269,    0.040679,   -7.051375}, {   0.001098,    0.000457,    0.007486}, {   0.003681,    0.002640,    0.000258},
			{   7.894971,    7.975470,    6.280299}, {   0.001724,   -0.005381,    0.000358}, {   0.006287,    0.001852,    3.238559}, {  -3.325989,   -4.159667,    2.992541}, {  -0.097869,  -11.385620,    3.500359}, { -28.877059,   -0.383513,    5.089003}, {   0.003870,    0.007038,    0.002920}, {   2.644886,   -5.728465,    4.372929},
			{  -7.062212,   -3.073517,   -0.495748}, {   0.012064,    0.001967,   -0.158849}, {  -0.746055,   -0.309937,    0.004542}, {   0.005241,    0.005466,   -0.158984}, {   1.706804,   -1.094097,    6.000823}, {  -0.017241,   -0.029342,   -6.823987}, {   0.524821,    0.000929,   -0.729596}, {  -0.004730,    0.013678,    1.641636},
			{   0.007141,    0.003594,    0.005202}, {   0.003081,    0.005828,    0.004798}, {   0.003234,    0.005828,    0.003745}, {   0.006240,    0.005797,    0.000567}, {   0.003173,    0.005874,    0.003747}, {   0.003112,    0.005867,    0.003746}, {  -0.062804,    0.007050,    0.004269}, {   0.027161,   -0.055481,    0.003661},
			{   0.003020,    0.005615,  -14.191023}, {   0.028960,    0.005295,    0.002151}, {   0.003907,   -0.002898,    0.001841}, {   0.012942,    0.002611,    0.000518}, {  -0.947127,   -1.707056,   -0.512812}, {   0.004058,    0.004193,   -0.041710}, {   5.091598,    1.906640,    5.005020}, {   0.570428,    0.347478,    0.062217},
			{  -1.993090,    4.023902,    0.000818}, {   0.000161,    0.007980,    0.003949}, {  -4.122754,   18.588016,   -3.718442}, {  -0.057436,    2.020438,    1.388710}, {   6.266064,   -2.690874,    0.000562}, {   0.008434,   -0.001954,    0.000822}, {   1.089310,    4.425149,    0.005692}, {   4.458456,    1.402660,    0.311473},
			{  -0.005477,    0.004180,    0.000823}, {   0.342536,   -0.666046,   -4.553721}, {   0.002318,    0.003661,    0.006128}, {   0.230522,  -14.667449,    1.376664}, {   0.006484,    0.001006,    0.002014}, {   0.005173,    0.000701,    0.000312}, {   9.446365,    7.081552,    0.003382}, {   0.000835,    0.005859,    0.000509},
			{   0.004585,    0.006928,    0.006684}, {   0.101833,    0.064603,   -0.482091}, {   3.756398,   -3.993649,    2.663589}, {  -0.015986,    0.234132,   -0.007083}, {   0.002653,   -0.004133,   -0.005338}, {   0.002940,    0.034120,   -0.110040}, {   0.002440,    0.004974,   -2.275999}, {   0.002685,    0.003982,    0.005867},
			{   3.962341,   -3.483886,    6.938522}, {   0.001159,    0.006713,    0.007399}, {   0.004710,    0.005731,    0.002491}, {   0.002593,    6.395576,    0.002892}, {   0.001999,    0.002715,    0.005295}, {   0.007629,    0.006957,    0.002094}, {  21.815628,  -34.689594,   -0.717586}, {   0.001677,    0.000153,    0.004695},
			{  -4.987122,    0.000228,   -0.568089}, {   0.003860,    0.002182,    0.001800}, {   0.006041,    3.577033,    0.458710}, {   0.001143,    0.004807,    0.322277}, {   0.001220,    0.794968,   -2.265455}, {   0.003203,    0.002929,    0.001703}, {   0.001143,    0.004807,    0.322277}, {   0.003860,    0.002182,    0.001800},
			{ -34.974388,   24.548618,   37.334964}, {   0.661513,  -44.483825,   -0.001412}, {   5.142920,   29.298446,    0.629121}, { -37.797271,   14.600563,  -18.823360}, {   0.009819,   -0.004042,    4.591865}, {   0.008391,   -0.000069,    0.003586}, {  -0.276841,   -0.477842,   11.503585}, {  -0.009569,    0.010111,    5.266393},
			{  -0.012151,    0.015242,    5.298993}, {   0.007992,    0.001963,    0.000971}, { -11.633476,    3.359679,    0.031909}, {   0.041097,    0.000870,    0.006188}, {   0.757475,    0.072180,   -0.293794}, {   0.007366,    0.002309,    0.006380}, {   0.041097,    0.000870,    0.006188}, {   0.007366,    0.002309,    0.006380},
			{   0.757475,    0.072180,   -0.293794}, {   1.490561,   -4.894417,    6.008299}, {  -0.003135,    0.007253,   -0.023097}, {  -0.003135,    0.007253,   -0.023097}, {   1.490561,   -4.894417,    6.008299}, {   0.003110,    0.052820,    5.250244}, {  18.245452,   -9.087036,    8.906276}, {   0.438659,   48.241878,    6.540236},
			{  33.475311,   23.120803,  -18.649539}, {  -1.567780,    1.307800,   -2.029120}, {   3.840332,    0.553893,   -2.680423}, {  18.245452,   -9.087036,    8.906276}, {   0.438659,   48.241878,    6.540236}, {   0.003356,    0.001327,    0.000493}, {   0.508660,    0.002477,    0.014764}, {   0.003356,    0.001327,    0.000493},
			{   0.508660,    0.002477,    0.014764}, {  -0.001595,    0.005652,    0.002636}, {  -0.008376,   -0.001952,    0.006099}, {  10.072471,   -1.263129,    0.003112}, {  -0.558845,    0.500464,   -0.100318}, {  -0.008376,   -0.001952,    0.006099}, {  -0.001595,    0.005652,    0.002636}, {  10.072471,   -1.263129,    0.003112},
			{  -4.454158,   15.564580,   -0.004786}, {   1.947304,    7.586790,   -0.012598}, {  -4.454158,   15.564580,   -0.004786}, {   0.007019,    0.099266,    0.004468}, {  10.703004,    0.366492,   -0.018389}, {   7.904061,    1.046633,   -0.003345}, {  10.703004,    0.366492,   -0.018389}, {   6.986045,   -5.808146,   -1.031255},
			{   9.297500,   13.894760,   -0.688358}, {   0.005524,    0.007331,    0.000872}, { -38.303085,    4.627930,   -0.234914}, {   8.420516,  -14.927104,   -8.282344}, {  -4.556266,  -18.028022,   -4.187024}, {  -3.861313,   20.619110,  -11.912887}, {  -2.586975,  -13.603050,  -10.201602}, {   2.439537,  -17.185195,  -19.445236},
			{  -0.000415,   -0.001445,    0.000807}, {   0.008315,    0.000709,    0.004803}, {   8.080993,  -25.034667,   16.041130}, { -42.274536,    0.000770,   14.268866}, {  -0.003902,    0.077333,   -0.010416}, {  -0.003902,    0.077333,   -0.010416}, {   8.420516,  -14.927104,   -8.282344}, {  -4.556266,  -18.028022,   -4.187024},
			{  -3.861313,   20.619110,  -11.912887}, {   2.439537,  -17.185195,  -19.445236}, {  -0.000415,   -0.001445,    0.000807}, { -42.274536,    0.000770,   14.268866}, {   0.003539,    0.007263,    0.006463}, {   0.001342,    0.002876,    0.007683}, {   0.005286,    0.004631,    0.007377}, {   0.007079,    0.003684,    0.000658},
			{   0.002562,    0.003264,    0.000167}, {   0.000000,    0.000000,  -32.832092}, {  -7.310142,    0.003311,   -9.558471}, {   0.002685,    0.002501,    0.000006}, {   0.006347,    0.006988,    0.006453}, {  -8.127197,   -0.316803,   19.304040}, {   0.006225,    0.003067,    0.003722}, {   0.002166,    0.005295,    0.004054},
			{   0.001708,    0.012573,    0.006428}, {   0.002135,    0.053711,    0.004004}, {   0.006225,    0.003067,    0.003722}, {   5.979086,   10.922860,    4.357964}, {   2.000370,    0.007755,    0.000493}, {   2.000370,    0.007755,    0.000493}, {   0.004395,    0.003860,    0.001850}, { -53.735717,    0.957947,    0.002036},
			{   0.001220,   19.159637,    0.006049}, {   0.000083,    0.000472,   -1.053025}, {  -0.819482,    0.006384,    0.005599}, { -23.272155,    4.881804,   -1.116647}, {   0.001586,    0.003433,    0.000780}, {   0.002264,    0.007722,    0.000151}, {   0.005735,   -0.003702,    0.005836}, {   0.004089,    0.003998,    0.003798},
			{   0.001220,    0.001220,    0.005805}, {   0.005187,    0.003875,    0.003250}, {   0.088013,    0.003677,    0.004745}, {   4.066223,    0.006804,    0.006686}, {   0.000853,    0.003189,    0.004631}, {   0.003112,    0.006004,    0.005847}, {   0.003478,    0.000586,    0.001154}, {   0.003478,    0.000586,    0.001154},
			{   0.005371,    0.000594,   -0.042050}, {   0.052698,   -0.149338,    0.001774}, { -23.272155,    4.881804,   -1.116647}, {  16.825988,    0.553146,    1.601454}, {   0.000853,    0.006256,    0.005013}, {   0.003173,    0.003844,    0.000106}, {   0.007641,    0.004120,    0.005909}, {   0.000853,    0.006256,    0.005013},
			{   0.006165,    0.000153,    0.993219}, {   6.986045,   -5.808146,   -1.031255}, {   0.004639,    0.005638,   -0.641430}, {   0.007263,    0.106113,    0.006347}, {   0.007263,    0.106113,    0.006347}, {   0.005154,   -0.001803,    0.000948}, {   0.005154,   -0.001803,    0.000948}, {  -0.025875,    0.001647,    0.001560},
			{  -0.000121,    0.010467,    0.003626}, {  -0.901610,   -0.010540,    0.002315}, {   0.013183,    0.004836,    0.017759}, {   0.000884,    0.003905,    0.002156}, {   0.005249,    0.005423,    0.002103}, {  -0.000069,    0.002571,    0.024558}, {   0.002715,    0.002894,    0.000727}, {   0.001586,    0.000442,    0.001113},
			{   0.005584,    0.006118,    0.003505}, {   0.000243,    0.000339,   -0.019804}, {   0.007232,    0.003456,    0.001593}, {   0.001250,    0.001143,    0.000984}, {   0.003783,    0.002009,    0.007759}, {   0.004120,    0.002487,    0.004958}, {   0.005584,    0.006118,    0.003505}, {   0.000243,    0.000339,   -0.019804},
			{   0.001250,    0.001143,    0.000984}, {   0.004120,    0.002487,    0.004958}, {   0.003783,    0.002009,    0.007759}, {   0.005350,   -0.001961,    0.003590}, {   0.003291,    0.000020,    0.003586}, {   0.006167,    0.002236,    2.818569}, {  -0.026763,    0.004645,   -0.076866}, {   0.132707,    0.119736,   -0.968657},
			{ -19.393690,  -17.748943,    5.826666}, {  -1.996474,    7.002501,    4.002707}, {   0.002474,    0.005750,    0.002351}, {  -3.999627,   14.002004,    6.004571}, {   0.001477,    0.000798,    2.814857}, {   0.001481,    0.000799,    2.814857}, {   0.002474,    0.005750,    0.002351}, {  -0.055422,   -0.447263,    1.538552},
			{   0.000184,    0.003740,    0.002794}, {   0.003051,   13.379463,    7.107298}, {   5.979086,   10.922860,    4.357964}, {  -0.026763,    0.004645,   -0.076866}, {  -2.492640,   -1.352009,    5.071416}, {   0.003882,    0.006560,    0.002726}, {   0.862415,   -1.055001,    2.828655}, {   0.002929,    0.004013,    0.007075},
			{   0.000030,    0.001686,    0.002970}, {  -0.025208,    0.007369,   -0.068673}, {   0.004333,    0.003570,    0.001216}, {   0.003905,    0.007400,   -0.064156}, {   0.000000,    0.006804,    0.005913}, {   0.003783,    0.005508,    0.001159}, {   0.006682,    0.000487,    0.007615}, {   5.091598,    1.906640,    5.005020},
			{  -1.993090,    4.023902,    0.000818}, {   1.706804,   -1.094097,    6.000823}, {   6.266064,   -2.690874,    0.000562}, {   0.000203,    0.005315,    0.058864}, {   0.008434,   -0.001954,    0.000822}, {   2.644886,   -5.728465,    4.372929}, {  -7.062212,   -3.073517,   -0.495748}, {   9.446365,    7.081552,    0.003382},
			{   3.402867,    6.243875,    4.329449}, {   1.089310,    4.425149,    0.005692}, {   4.458456,    1.402660,    0.311473}, {  -6.858917,    1.854580,    5.654172}, {   0.000030,    0.001686,    0.002970}, {  -0.025208,    0.007369,   -0.068673}, {   0.002929,    0.004013,    0.007075}, {   0.006682,    0.000487,    0.007615},
			{   0.007201,    0.006072,    0.085042}, {   0.003112,    0.007416,    1.252910}, {  12.395614,   25.362548,   -8.715681}, {   0.005768,    0.003417,    0.006434}, {   0.003844,    0.003081,    0.004476}, {   0.004883,    0.000930,    0.006103}, {   0.005768,    0.003417,    0.006434}, {   0.003844,    0.003081,    0.004476},
			{   0.004883,    0.000930,    0.006103}, {   7.894971,    7.975470,    6.280299}, {   0.152137,    0.254395,    3.000176}, {  -3.325989,   -4.159667,    2.992541}, {   0.002083,    0.005557,   -1.071967}, {  -5.354967,    0.004333,    1.135998}, {   1.578441,    0.001288,    0.002920}, {   0.003870,    0.007038,    0.002920},
			{  -0.097869,  -11.385620,    3.500359}, { -28.877059,   -0.383513,    5.089003}, {   0.003002,    0.003395,   -0.584324}, { -11.976035,   -7.622044,    4.756865}, {   2.190679,  -11.146245,    5.561728}, {   9.075567,  -20.751424,    4.509431}, {  -0.333617,    6.716670,    0.032779}, {   0.004867,    0.001624,    0.004007},
			{  -0.478882,   -6.497963,   -0.760367}, {  -0.483355,    0.095868,    2.505688}, {  -1.008026,    0.006949,    5.000287}, {   0.107055,    0.002040,    3.006871}, {   0.073532,    0.424365,    3.971227}, {  -9.077672,  -11.103365,    4.746177}, {  -1.533067,    0.005698,    2.756870}, {   0.811074,   -0.171643,    4.506856},
			{  -0.000121,    0.010467,    0.003626}, {   0.002318,    0.004027,    0.006010}, {   0.013183,    0.004836,    0.017759}, {   0.007079,  -14.995162,    0.007205}, {   0.004883,    3.025142,    0.007000}, {   0.007079,    0.004817,    0.002362}, {   0.000000,    0.005553,   -0.115152}, {  -0.022216,    0.004852,    0.002312},
			{  -0.901610,   -0.010540,    0.002315}, {   0.001464,    0.006134,    0.000334}, {   0.007019,    0.007209,    0.000707}, {   0.003020,    0.005615,  -14.191023}, {   0.002166,    0.005295,    0.004054}, {   0.028960,    0.005295,    0.002151}, {   0.027161,   -0.055481,    0.003661}, {   0.001708,    0.012573,    0.006428},
			{   0.002135,    0.053711,    0.004004}, {  -0.062804,    0.007050,    0.004269}, {   0.006912,    0.001381,    0.002052}, {   0.006591,    0.003036,    0.005136}, {   0.003081,    0.005828,    0.004798}, {   0.003173,    0.005874,    0.003747}, {   0.003112,    0.005867,    0.003746}, {   0.050719,    0.005828,    0.003938},
			{   0.006240,    0.005797,    0.000567}, {  -0.000069,    0.002571,    0.024558}, {   0.003234,    0.005828,    0.003745}, {   0.007019,    0.005584,    0.002255}, {   0.004860,   -1.025161,   -0.017371}, {   0.001258,   -1.025161,   -0.017371}, {   0.003112,    0.005797,    0.005855}, {   2.314317,   -0.003189,    0.005034},
			{   0.003336,    0.009525,    0.010470}, {  -0.003769,   -0.007736,    0.016626}, {   2.314317,   -0.003189,    0.005034}, {   0.003336,    0.009525,    0.010470}, {   0.006484,    0.001006,    0.002014}, {   0.230269,    0.040679,   -7.051375}, {   0.006957,    0.007027,  -14.152260}, {   0.006302,    0.007796,    0.002026},
			{   0.005371,    0.007079,    0.006146}, {   0.001464,    0.004486,    0.001269}, {   0.001098,    0.000457,    0.007486}, {   0.001830,    0.006957,    0.001766}, {   0.007079,    0.003426,    0.003622}, {   0.007079,    0.003684,    0.000658}, {  -0.157654,    0.006835,    0.006806}, {   0.005919,    0.006591,    0.004277},
			{   0.006469,    0.018813,    0.003850}, {   0.005005,    0.003159,    1.501989}, {   0.127075,    0.001968,    0.006496}, {   0.003661,    0.002891,    0.007741}, {  -3.294183,   -0.103515,    0.285905}, {  -0.095946,   -0.071762,    0.049042}, {   0.003681,    0.002640,    0.000258}, {   3.578826,    0.470169,   -0.158637},
			{   3.772979,   -2.618346,    0.334968}, {   0.006957,    0.000274,    0.004174}, {   0.006957,    0.000274,    0.004174}, {   6.812057,    0.005005,    0.000604}, {   0.006912,    0.001381,    0.002052}, {   0.002196,    0.002579,    0.000523}, {   6.812057,    0.005005,    0.000604}, {   0.002196,    0.002579,    0.000523},
			{  -0.004681,    0.000945,    0.001350}, {  -0.005241,   -0.007075,    0.005499}, {   0.001586,    0.001030,    0.004226}, {   0.000243,    0.003959,    0.000330}, {  40.686767,  -43.170646,  -18.810209}, {  40.686767,  -43.170646,  -18.810209}, {   0.001830,    0.006835,    0.000983}, {  -4.752215,    3.518728,   -0.439664},
			{   0.000487,    0.059631,    0.003362}, {   0.004883,   -0.867935,    0.002219}, {   0.000487,    0.059631,    0.003362}, {   0.168657,    4.864842,   -2.576806}, {  -0.209594,   -2.464946,    0.582418}, {   0.002264,    0.007722,    0.000151}, {   0.002571,    0.001677,    0.005049}, {   0.002571,    0.001677,    0.005049},
			{   0.003220,    0.006225,    0.002044}, {   0.007445,    0.005257,    0.001175}, {   0.006713,    0.129188,    0.004236}, {  -0.001106,    0.005187,   -0.830865}, { -18.087402,   -8.489898,   -0.544324}, {   0.003112,    0.005615,    0.006519}, {   0.003173,    0.007050,    0.005615}, {   0.002501,    0.002609,    0.002203},
			{   0.001342,    0.007613,    0.006661}, {   0.007141,    0.006668,    0.005245}, { -18.087402,   -8.489898,   -0.544324}, {   0.007445,    0.005257,    0.001175}, {  -0.001106,    0.005187,   -0.830865}, {   0.003112,    0.005615,    0.006519}, {   0.005735,   -0.003702,    0.005836}, {   0.001586,    0.000472,    0.000497},
			{   0.000037,    0.004141,    0.002483}, {   0.008476,   -0.003907,   -0.618884}, {   0.008476,   -0.003907,   -0.618884}, {   5.981801,    2.295073,    2.869430}, {   0.002166,    0.008523,   -0.296097}, {   0.002166,    0.008523,   -0.296097}, {   5.981801,    2.295073,    2.869430}, {   0.007992,    0.001963,    0.000971},
			{   5.499542,    0.379909,   12.005395}, {  -0.015732,   -0.052094,   -0.411900}, {   0.004470,    0.003051,    0.003880}, {   0.006881,    0.006165,    0.005592}, {   0.005173,    0.000701,    0.000312}, {   0.006881,    0.006165,    0.005592}, {   0.006484,    1.139953,   -1.260148}, {   4.179946,    0.006469,   -1.040997},
			{ -18.447731,  -42.000782,    4.652180}, {  21.815628,  -34.689594,   -0.717586}, { -32.069618,    2.303431,    0.264254}, {  -3.403899,   -1.605548,    5.003746}, {   2.204857,    7.059638,    2.805480}, {  -1.021255,    0.004395,    1.585464}, {   0.541534,    3.078696,    0.006872}, {   0.006378,    0.007774,    0.008661},
			{   0.000884,    0.003905,    0.002156}, {   0.002593,    6.395576,    0.002892}, {   0.005249,    0.005423,    0.002103}, {  -0.266690,   -0.244513,   -0.979251}, {   0.003616,    0.001250,    0.007730}, {   0.006287,    0.001852,    3.238559}, { -11.633476,    3.359679,    0.031909}, {   0.010077,    0.001082,    0.000503},
			{   0.577876,   -0.062389,   -0.513970}, {   0.005156,    0.003417,    0.002902}, {  -0.819482,    0.006384,    0.005599}, {   0.007141,    0.003594,    0.005202}, {   0.005859,    0.003020,    0.007185}, {   0.005280,    0.000487,    0.001261}, {   0.003051,    0.005797,    0.006843}, {   0.004699,    0.006378,    0.004015},
			{   0.007263,    0.001754,    0.002918}, {   0.002746,    0.003051,    0.004389}, {   0.006653,    0.001204,   -0.004900}, {   1.019104,    0.002624,   -0.006002}, { -53.735717,    0.957947,    0.002036}, {   0.001220,   19.159637,    0.006049}, {   0.000000,    0.001891,    0.004741}, {  -0.025875,    0.001647,    0.001560},
			{   0.006347,    0.006988,    0.006453}, { -41.386474,    0.002158,   18.958332}, {  -7.310142,    0.003311,   -9.558471}, {  -8.127197,   -0.316803,   19.304040}, {  -2.586975,  -13.603050,  -10.201602}, {   0.661513,  -44.483825,   -0.001412}, {   5.142920,   29.298446,    0.629121}, { -37.797271,   14.600563,  -18.823360},
			{  -7.424015,  -32.928565,  -19.190845}, {  -0.776237,    4.872554,    1.589699}, {  -4.987122,    0.000228,   -0.568089}, {   0.001677,    0.000153,    0.004695}, {  -0.919341,   -3.772979,    0.004970}, {   0.003051,    0.006500,    0.002891}, {   0.003173,    0.001540,    0.000942}, {   0.003173,    0.001540,    0.000942},
			{   0.004395,    0.003860,    0.001850}, {   0.002685,    0.002501,    0.000006}, {   0.000000,    0.000000,  -32.832092}, {   0.002562,    0.003264,    0.000167}, {   8.080993,  -25.034667,   16.041130}, {   0.003173,    0.003844,    0.000106}, {   0.230522,  -14.667449,    1.376664}, {   0.005187,    0.003875,    0.003250},
			{   0.001220,    0.001220,    0.005805}, {   0.007522,    0.004317,    0.000620}, {   0.088013,    0.003677,    0.004745}, {   6.215541,    4.582686,   -2.038079}, {  -6.957221,  -17.111694,   -0.706194}, { -27.693901,   -3.044922,   -0.158542}, {  -0.000041,    0.003756,    0.004284}, {   0.002044,    0.004639,    0.001006},
			{   0.004600,    0.006157,   -1.434751}, {  -0.578711,    0.003799,   -1.222350}, {   0.006027,    0.000721,    0.003739}, {   0.005051,    0.007400,    0.004676}, {  -0.000030,    0.000976,    0.002190}, {   0.006804,    0.002487,    0.005772}, {   0.342536,   -0.666046,   -4.553721}, {   0.004013,    0.002640,    0.003542},
			{   0.001113,    0.001296,    0.000887}, {   0.007079,    0.006744,    0.002351}, {   0.006967,    0.006087,    0.007408}, {   0.004242,    0.001494,    0.001704}, {   0.002510,   -1.959064,   -1.331058}, {   0.002916,    0.003710,    0.003809}, {   0.006583,    0.002681,    0.003341}, {   5.081467,  -21.858390,    1.271993},
			{  14.530036,   33.092803,   -0.339724}, {   0.006041,    3.577033,    0.458710}, {  -4.097579,    0.695724,   -2.002922}, {   0.007641,    0.004120,    0.005909}, {  -0.003769,   -0.007736,    0.016626}, {   0.006713,    0.005173,    0.004654}, {  33.475311,   23.120803,  -18.649539}, { -12.926086,  -17.841384,  -15.136751},
			{   0.001220,    0.794968,   -2.265455}, {   0.002440,    0.004974,   -2.275999}, {   0.000853,    0.003189,    0.004631}, {   4.066223,    0.006804,    0.006686}, {   0.003783,    0.005508,    0.001159}, {   0.000000,    0.006804,    0.005913}, {   0.000000,    0.005553,   -0.114546}, {   0.004470,    0.003051,    0.003880},
			{   0.004333,    0.003570,    0.001216}, {   0.003905,    0.007400,   -0.064156}, {   0.000000,    0.000751,   -0.023248}, {  -0.558845,    0.500464,   -0.100318}, {   0.001999,    0.002715,    0.005295}, {   0.003457,    0.006585,   -0.123970}, {  -0.017241,   -0.029342,   -6.823987}, {   0.007232,    0.003456,    0.001593},
			{   0.001586,    0.000442,    0.001113}, {   0.008315,    0.000709,    0.004803}, {   0.003112,    0.006004,    0.005847}, {   0.524821,    0.000929,   -0.729596}, {   0.003456,    0.006453,    0.003308}, {  -5.113719,  -23.579200,   -0.870109}, {   0.002196,    0.006866,    0.006732}, {   0.002196,    0.006866,    0.006732},
			{   0.001361,    0.012296,   -0.116313}, {   0.001361,    0.012296,   -0.116313}, {  -0.919341,   -3.772979,    0.004970}, {   0.003051,    0.002257,    0.000345}, {   0.003051,    0.002257,    0.000345}, {   0.004780,    0.006579,    0.003673}, {  51.450523,  -26.003263,   -2.565009}, { -39.043640,   -4.265160,   -2.521481},
			{  20.585201,   -3.957142,    1.596372}, { -70.213996,   -3.636116,   11.590370}, {-100.709861,  -87.332962,   34.852584}, { -45.010185,   39.144615,   18.720943}, { -97.093200,  -47.097068,   17.754369}, {  -0.014023,   -0.001305,   -0.820546}, {  -5.206642,   -9.068740,    0.623529}, {   0.001183,    0.031826,    0.016836},
			{  -2.657321,   41.218399,  -21.274780}, {   0.004395,   -0.486030,    0.016814}, {   0.975624,    0.009921,   15.068180}, { -97.411697,  -59.819450,   30.056961}, {   1.190268,   -9.646120,   18.427154}, {  -0.005768,  -10.907665,    0.029053}, {  54.997741,  -22.448879,   -5.497682}, { -69.214965,   15.854904,   37.177448},
			{  16.303936,   88.739456,  -11.010666}, { -23.759113,  -12.978946,  -19.101594}, {   0.005386,   -4.621281,    1.828624}, { -10.552581,  -54.850723,    2.904093}, {  -1.129623,    4.442111,    0.729045}, { -14.977996,   -8.048828,   -0.784768}, {  10.697879,   49.668628,  -14.640692}, {  -1.125069,   99.884422,   -5.150464},
			{  19.506145,  -70.718826,   -0.799688}, {  -0.278533,   -0.536262,    0.012625}, { -12.935516,   22.097019,  -15.750032}, {  16.283233,   61.397567,  -20.463882}, {  -4.924617,   46.865936,   -2.889132}, {  89.421676,  -51.899414,   -8.376928}, { -32.170700,   16.366218,   -0.006037}, {-108.219039,  -62.243312,   -0.167839},
			{   8.705162,    2.104022,   -2.541146}, {  -5.142269,  -17.749042,    6.980807}, { -11.887481,   -9.245559,    1.398028}, {   4.562201,   -5.263629,   -2.468461}, {  10.402555,   -5.682926,   -6.863417}, {  16.014188,  -14.012489,   -3.282346}, {  98.913345,   56.845527,   -8.907205}, {   7.969406,   51.459037,    0.536255},
			{  -0.006446,   50.610725,    3.859375}, {  23.124435,  -60.005455,   11.236913}, { -21.417098,   49.524597,  -13.471784}, {  66.434577,  -22.980998,  -21.429111}, { -46.298950,   75.061164,  -18.918344}, { -10.972763,   -1.560271,   -3.174397}, {   0.002972,  -12.811401,   -2.264657}, {  17.897026,  -83.748397,    6.233584},
			{  18.866210,  -36.245761,  -12.799711}, {   0.009337,  -18.310058,   -0.816127}, {  -5.630828,   12.196020,   -2.297791}, { -14.635643,  -11.513268,    0.906233}, {  37.903427,   62.568454,    1.367799}, {-101.337745,  -79.239974,   -7.907265}, { -50.502880,   -0.831161,  -11.993591}, {  14.502288,   33.072479,   -0.337844},
			{   2.701705,   -4.329032,   -7.224669}, {   0.003287,   -0.021308,   -1.627758}, { -65.177474,  -87.748657,   -7.861021}, {  -8.349304,   24.340766,   -2.608762}, { -12.760284,   47.928840,    0.809442}, { -20.314361,    3.988480,   -2.009234}, { -14.491088,  -22.759498,   -2.980406}, {   0.881148,   35.369796,   -3.813755},
			{  21.815124,  -32.681930,  -13.895660}, {  -4.362675,   -0.287696,   -8.234868}, {   0.190973,   -0.371733,    2.810738}, {  16.321041,   -0.537979,   -6.552332}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  -3.925476,    6.886507,    0.196081}, {   0.000869,    0.010862,    0.006808},
			{   0.005938,    0.003109,    0.006262}, {   0.000487,    0.000155,    0.005855}, {   0.001708,    0.007271,    0.001051}, {   0.005898,    0.004420,    0.007094}, { -54.046211,    0.001830,    0.007929}, { -54.043281,    0.001830,    0.007929}, {   0.005898,    0.005886,   -3.059228}, { -86.927764,    4.586655,   11.325550},
			{ -54.046211,    0.003295,    0.007929}, { -54.043281,    0.003295,    0.007929}, {  50.470199,  -67.955947,    7.580985}, {   0.005005,    0.000968,    4.961887}, {  -1.677649,    5.563545,    0.011219}, {  31.579597,    0.001708,    0.007929}, { -86.923858,    3.792197,   40.720520}, {   0.002693,    0.006713,   -8.555800},
			{   0.002685,    0.006713,   -7.856022}, { -37.508560,   -0.041875,    4.792562}, {   0.012489,    0.007350,    0.002059}, {   0.007468,    0.004395,    8.297584}, {   0.004439,    0.002412,   -0.363407}, {   0.004811,    0.004046,    8.299122}, {  14.800027,   -3.249802,    5.764906}, {   0.002367,    0.007513,    8.298400},
			{   0.002217,    0.007278,    8.298875}, {  -4.073923,    6.672074,    5.483745}, {   0.007484,    0.006653,    8.764066}, {   0.003342,    0.003760,    8.761695}, {  11.070730,  -32.769134,    7.801692}, {   0.003076,    0.003059,    8.766622}, {   0.009766,    0.006717,   -3.344782}, {   0.002693,    0.006713,   -9.969338},
			{  -0.778877,   -1.205737,    1.297804}, {-109.733695,  -31.280250,   -0.459996}, { -62.506591,    0.007309,   -0.997126}, {  50.193069,  -71.444976,   -2.962611}, {   0.004027,    0.002304,   23.241140}, {  -0.001752,   -0.010804,    2.167648}, {  -0.011760,    0.004641,    2.167648}, {   0.004509,    0.006744,    0.012296},
			{-114.117721,    1.237746,    2.530905}, {  -2.832039,   -0.731857,   -1.461326}, {   0.001922,    0.005473,    3.610722}, {  -0.314610,   -0.486014,    0.003290}, {   0.010006,    0.011102,    0.000059}, {   0.003208,    0.004796,    0.003692}, {   0.007811,    0.001297,    0.004306}, {   0.003295,    0.002430,    0.000045},
			{   0.002180,    0.004648,    0.001665}, {   4.173727,    0.683593,    7.554734}, {  -0.049561,   -0.470490,   -0.758871}, {   0.000727,    0.006769,    0.005003}, {   0.006103,    0.005859,    0.006144}, {   0.003294,    0.000889,    0.004633}, {   0.003651,    0.001351,    0.005334}, {  -1.169052,    0.006347,    2.993217},
			{   0.000304,   -1.166306,    2.994987}, {   0.006641,    0.003976,    0.005334}, {   3.922915,   -1.175107,   -1.030936}, {  12.434020,  -35.643878,   10.302644}, {  -0.017872,    0.001018,    8.755398}, {   0.136368,   -0.292057,  -19.168367}, {   0.000645,    0.007023,    0.006550}, {  -2.831734,   -1.661926,   -1.003643},
			{   0.005127,    0.003417,   50.401344}, {  36.130535,   19.402776,   17.728879}, {  36.128646,   21.842481,   -0.186547}, {  61.243537,    0.007323,    2.637103}, {  61.243511,    0.007323,   -0.441334}, { -62.506618,    0.007309,    1.758923}, {  28.958255,  -12.911537,   -1.573596}, {  90.896400,  -13.146419,    6.015400},
			{  29.473014,  -13.021884,   -1.762979}, { -23.275951,  -13.021884,    8.331936}, {   0.004550,    0.003043,    0.010083}, {   0.008466,    0.157454,   -2.836117}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{  -0.850281,   -0.001159,    0.100836}, {  -0.010604,    0.005402,    0.006992}, {   0.006713,    0.005477,    0.005834}, {  -6.171677,    0.003234,  -30.172168}, {   0.001350,    0.002457,    0.001977}, {   0.001900,    0.002640,    0.000384}, {   0.446074,   -3.605285,   -1.441934}, {  -5.853287,   -5.712830,   -2.753529},
			{   0.005051,    0.007385,    0.001554}, {   0.008185,    0.000767,   -0.344168}, {   0.002178,    0.003944,   -0.115869}, {   0.007621,    0.006409,    0.002555}, {   0.004395,    0.001952,    0.006229}, {   0.000518,    0.000182,    0.006138}, {   0.001723,    0.001769,    0.000234}, {   0.007131,    0.001084,    0.004391},
			{  -0.927887,   -1.314208,   -0.031495}, {   0.005020,    0.007445,    0.007333}, {   0.003959,    0.000670,    0.006118}, {  -0.431984,    3.192814,  -10.662616}, {   0.002029,    0.003356,   -0.577587}, {   7.259799,   16.097415,    0.516314}, {   0.005636,    0.003539,    0.004902}, {   0.002976,   -0.001151,    0.002230},
			{  -0.009208,    0.012769,    0.005965}, {   0.004004,    0.000778,    0.001735}, {  32.450500,   11.637634,   -3.542232}, {  19.785873,    0.001577,    0.269365}, {   0.002440,    0.005065,    0.000915}, {   0.008019,   -0.001383,    0.002174}, {  -0.005404,    0.005615,   -5.148334}, {   0.002227,    0.002990,    0.005698},
			{   0.002715,    0.002074,    0.006554}, {  -1.017730,    0.003783,    0.007034}, {   0.004639,    0.005431,    0.002430}, {   0.002929,    0.007445,    0.020633}, {   0.001220,    0.004668,    0.005315}, {   0.003295,    0.007019,   -0.167016}, {   0.005249,    0.001220,   -0.032935}, {   0.018180,    0.002166,   -0.984616},
			{ -51.596504,    0.003325,   -0.503395}, {   0.045563,   -0.380980,   -0.316235}, {   2.327023,   -0.274293,    0.004364}, {   8.873657,    0.006316,   -0.303487}, {   0.014130,    0.012848,    3.432981}, {   0.000828,    0.003252,    0.004660}, {   0.004180,    0.000426,    0.000422}, {   0.003365,    0.002624,   -0.250025},
			{   0.004761,    0.000426,    0.004817}, {   0.101356,    0.005473,    0.006025}, {   0.002807,    0.250847,    0.001056}, {   0.013915,   -2.833281,   -1.806503}, {   1.918578,    0.001555,   -0.141350}, {   0.391045,    0.944054,   -4.953213}, {   8.263946,    2.332305,    0.000783}, {   0.001261,    0.003550,    0.199596},
			{   0.000855,    0.004370,    0.006087}, {   0.001879,    0.008267,    0.006587}, {   0.003020,    0.004455,    0.001319}, {   0.007445,    1.595703,   -4.101706}, {   0.001952,    0.005615,    0.005867}, {   0.000350,    0.004883,   -0.197257}, {   0.009018,    0.133301,    0.005100}, {   0.754104,   -0.008484,    0.041678},
			{   0.004112,    0.001658,    0.002465}, {   0.003783,    0.979499,    0.007304}, {   0.000007,   -0.506398,    0.007284}, {  -0.638466,    0.407810,   -0.471192}, {   2.823134,  -18.832519,   -1.132660}, {   0.533591,    6.658744,    0.007251}, {  -4.698677,    5.012837,    0.014698}, {   0.006699,    6.309230,    0.005338},
			{   1.383545,   -0.091490,    0.004230}, {  -0.431984,    3.192814,  -10.662616}, {  -0.421678,   -0.440129,   -0.868638}, {   0.005030,    0.001650,    0.004648}, {   0.003108,    0.003112,    0.003196}, {   0.003714,    0.005859,    0.501640}, {   2.823134,  -18.832519,   -1.132660}, {   0.005309,    0.001739,    0.001704},
			{   0.003286,    0.006105,    0.002649}, {  -1.551499,   -3.724142,   -3.931068}, {   0.013015,    0.009367,   -1.505738}, {   0.033666,   -5.382715,   -3.926983}, {   4.781066,    0.000335,    0.001322}, {   2.626395,   17.735507,    0.382032}, {  -4.577397,   -3.225188,    0.723224}, {   0.002807,    0.250847,    0.001056},
			{   0.001261,    0.003550,    0.199596}, {  -0.922210,    0.002114,    0.006984}, {  -0.922210,    0.002114,    0.006984}, {  32.450500,   11.637634,   -3.542232}, {  -4.698677,    5.012837,    0.014698}, {   0.533591,    6.658744,    0.007251}, {   0.002029,    0.003356,   -0.577587}, {   0.003783,    0.979499,    0.007304},
			{   0.009018,    0.133301,    0.005100}, {   0.001723,    0.001769,    0.000234}, {   0.001952,    0.005615,    0.005867}, {   0.000007,   -0.506398,    0.007284}, {  -0.638466,    0.407810,   -0.471192}, {   0.003959,    0.000670,    0.006118}, {   7.259799,   16.097415,    0.516314}, {   0.002440,    0.005065,    0.000915},
			{   0.004395,    0.001952,    0.006229}, {  -5.853287,   -5.712830,   -2.753529}, {   0.004112,    0.001658,    0.002465}, {   0.754104,   -0.008484,    0.041678}, {   0.000350,    0.004883,   -0.197257}, {   0.005309,    0.001739,    0.001704}, {   8.873657,    0.006316,   -0.303487}, {   1.918578,    0.001555,   -0.141350},
			{   0.003234,    0.002868,    0.002337}, {   0.000828,    0.003252,    0.004660}, {   8.263946,    2.332305,    0.000783}, {   0.003684,    0.004391,    0.004215}, {   0.004242,    0.002654,    0.004867}, {   0.003634,    0.000930,    0.002958}, {  -0.421678,   -0.440129,   -0.868638}, {   0.005030,    0.001650,    0.004648},
			{   0.004004,    0.000778,    0.001735}, {  -0.009208,    0.012769,    0.005965}, {   0.033666,   -5.382715,   -3.926983}, {   0.002562,    0.006103,   -0.037096}, {   0.002562,    0.006103,   -0.037096}, {   0.002976,   -0.001151,    0.002230}, {   0.005636,    0.003539,    0.004902}, {  -1.551499,   -3.724142,   -3.931068},
			{   0.007131,    0.001084,    0.004391}, {   2.992116,    6.831101,   -0.000325}, {  -3.285706,    3.858124,    4.143404}, {   0.008185,    0.000767,   -0.344168}, {   0.003821,   -0.005576,    0.006560}, {   2.134195,   -0.273337,    3.888283}, {  -0.309166,    0.260277,    0.068542}, {   2.134195,   -0.273337,    3.888283},
			{   0.003821,   -0.005576,    0.006560}, {   0.000609,    0.005096,    0.007408}, { -39.187866,   -0.133178,   38.948738}, {   0.000609,    0.005096,    0.007408}, { -39.187866,   -0.133178,   38.948738}, {   0.006653,    0.003562,    0.004031}, {   0.003684,    0.004391,    0.004215}, {   0.006653,    0.003562,    0.004031},
			{   1.205531,   -2.963861,    0.801459}, {   0.029191,    0.021475,   -0.160742}, {  -0.007003,    0.002624,    0.706017}, {   0.013915,   -2.833281,   -1.806503}, {   0.000670,    0.002624,    0.016505}, {   0.001952,    0.006209,   -0.830128}, {   0.000670,    0.002624,    0.016505}, {   0.001220,    0.007507,    0.001091},
			{   0.003844,    0.004639,    0.000057}, {   0.005309,    0.003447,    0.004801}, {   0.006531,    0.007354,    0.006949}, {   0.001220,    0.007507,    0.001091}, {   0.003844,    0.004639,    0.000057}, {   0.005309,    0.003447,    0.004801}, {   0.006531,    0.007354,    0.006949}, {   0.002828,   -3.778927,    0.448644},
			{  -0.850281,   -0.001159,    0.100836}, {   0.014130,    0.012848,    3.432981}, {   0.001220,    0.004668,    0.005315}, {   0.003295,    0.007019,   -0.167016}, {   0.003234,    0.002868,    0.002337}, {   0.004761,    0.000426,    0.004817}, {   0.004639,    0.005431,    0.002430}, {   0.002929,    0.007445,    0.020633},
			{   0.005249,    0.001220,   -0.032935}, {   0.003365,    0.002624,   -0.250025}, {   0.000869,    0.007538,    0.006713}, {   0.045563,   -0.380980,   -0.316235}, {   0.003020,    0.004455,    0.001319}, {   0.000915,    0.006500,    0.003087}, {   0.002715,    0.002074,    0.006554}, {   0.000915,    0.006500,    0.003087},
			{   0.006713,    0.005477,    0.005834}, {   0.001952,    0.006209,   -0.830128}, {  -0.010604,    0.005402,    0.006992}, {   0.003634,    0.000930,    0.002958}, {  -6.171677,    0.003234,  -30.172168}, {   0.446074,   -3.605285,   -1.441934}, {  -0.927887,   -1.314208,   -0.031495}, {   0.391045,    0.944054,   -4.953213},
			{   0.005020,    0.007445,    0.007333}, {   0.002227,    0.002990,    0.005698}, {   0.000518,    0.000182,    0.006138}, {   0.007621,    0.006409,    0.002555}, {   0.003714,    0.005859,    0.501640}, {   0.005989,    0.005032,    2.860239}, {   0.000953,    0.002117,    0.006864}, {   0.002707,    0.007232,    0.005413},
			{  -4.514960,    2.957938,    0.005435}, {   0.002642,    0.005247,    0.004499}, {   0.002642,    0.005247,    0.004499}, {   0.001900,    0.002640,    0.000384}, {   0.002178,    0.003944,   -0.115869}, {   0.005051,    0.007385,    0.001554}, {   0.001350,    0.002457,    0.001977}, {   0.001189,    0.002196,    0.005055},
			{   0.767700,    0.007170,   -1.748579}, {   0.001189,    0.002196,    0.005055}, {   0.101356,    0.005473,    0.006025}, {   0.008019,   -0.001383,    0.002174}, {   0.003286,    0.006105,    0.002649}, {   1.205531,   -2.963861,    0.801459}, {   0.003108,    0.003112,    0.003196}, {   4.781066,    0.000335,    0.001322},
			{   2.992116,    6.831101,   -0.000325}, {   2.626395,   17.735507,    0.382032}, {   0.000869,    0.007538,    0.006713}, {   0.018180,    0.002166,   -0.984616}, {   0.767700,    0.007170,   -1.748579}, {  -0.005404,    0.005615,   -5.148334}, {  -0.007003,    0.002624,    0.706017}, {   0.004242,    0.002654,    0.004867},
			{   0.004180,    0.000426,    0.000422}, {   0.001879,    0.008267,    0.006587}, {   0.006539,   -0.003659,    0.001774}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  -5.288814,    0.006883,    1.900300},
			{   0.006988,    1.705657,    0.003510}, {   0.001838,    0.000182,    0.199590}, {   0.011652,   -0.705267,    0.010711}, {   0.003174,    0.002623,    0.005661}, {   7.282288,  -11.169586,    3.322639}, {  21.509048,   29.971271,    0.019223}, {   0.003569,    0.007540,   -0.000084}, {  -0.398882,    3.527162,    0.433557},
			{   8.590819,    4.566883,    3.416163}, {   0.002441,    0.021305,    0.016541}, {   0.003155,    0.001348,    0.009339}, {   0.000842,    0.006806,    0.010546}, { -13.643944,   -0.334538,    0.765744}, {  -6.982224,   -0.333196,    0.761473}, {  -9.002135,   11.494492,   -0.239519}, {  -5.481633,   -0.325868,    1.451096},
			{   0.001049,    0.003436,    0.006347}, {  -5.278819,    6.063710,    0.002562}, {   0.002851,    0.000494,    0.005005}, {   0.236569,   -0.907163,   -1.286514}, {   0.661813,   -0.850027,    0.003091}, {  -0.011677,    5.343578,    0.006833}, {   0.002288,    0.000910,    0.005371}, {   0.014128,    2.013772,    0.008489},
			{  -5.241335,   -6.714509,   -6.472694}, {   0.008635,    1.790446,    0.009223}, {   0.008698,    0.010149,    0.009832}, {   0.058625,    0.010149,    0.016059}, {  -1.785079,    0.362203,   -7.521422}, {  -7.986571,   -6.741942,    0.008031}, {   0.010343,    0.005965,    0.016668}, {  -3.984936,   -0.123193,   -6.343121},
			{  -0.035124,    1.603773,    1.110538}, {  44.310394,   22.474966,    1.245579}, { -11.689329,   34.725078,   -0.997340}, {  14.959088,    4.028612,   -0.998910}, { -22.496316,    2.488337,   -1.002699}, {  -2.464222,  -12.418356,   -0.998842}, { -16.764232,  -14.469180,   -1.426079}, {  37.069927,  -19.375062,    1.624866},
			{  24.615646,   -3.566647,    0.376019}, {  27.265583,    8.433562,    5.926431}, {  34.696197,   20.110197,    4.926767}, {  19.879783,   20.431781,    4.926187}, {  34.632301,   -5.514976,    4.927012}, {  34.665409,    6.485232,    4.926902}, {  19.877481,   -5.018249,    4.926654}, {  19.876735,    7.431755,    4.926394},
			{   8.026589,   -6.715277,    0.045710}, {   0.013465,    0.000783,   -0.258354}, {   7.085326,   -6.179973,    0.030579}, {   8.021282,   -7.748413,   -1.196869}, { -12.037196,   -7.748413,   -1.200286}, {   0.009278,    8.156502,    0.004879}, {   0.007627,    0.007216,    0.011141}, {  -4.559719,    0.005433,    0.201080},
			{   3.637403,    0.004275,   -3.815423}, {   0.011377,    0.007079,    0.010251}, {   0.013325,    0.000239,    0.011153}, {  -1.661996,    0.007784,   -0.112011}, {  12.981803,    0.626815,    2.258234}, { -11.634643,   -6.741942,   -1.049340}, {   0.010541,    0.007391,    0.006153}, {  -3.002723,   -3.023082,   -2.080854},
			{   0.011040,    0.001613,    0.007933}, {   0.007284,    0.005235,   -0.135343}, {   0.000379,    0.002251,    0.003415}, {   0.000390,    0.005778,    0.003415}, {   0.003871,    0.001764,    0.002561}, {   0.000211,   -0.000959,    0.010627}, {  16.414535,  -12.075966,    3.049741}, {   2.171504,    0.007263,    0.051993},
			{   0.051729,    0.121968,    0.003490}, {   4.393342,    0.158499,    0.007511}, {   1.372140,   -4.438762,   -0.203174}, {  -0.167862,    0.000243,    0.000707}, {  21.705396,   17.634773,    1.836670}, {   1.833114,    1.179553,    0.286224}, { -12.938842,   11.275973,   -0.079070}, {   0.001399,    0.005297,    0.004356},
			{   3.063338,  -11.897233,   -0.035629}, {   7.054540,   24.193161,    3.182282}, {  -7.602735,    3.973762,    0.004989}, {  -0.294748,   -0.230763,    0.003865}, {   0.007102,    0.005797,    0.003173}, {   0.005003,    0.004246,    0.006347}, {   0.005665,    0.004540,    0.004149}, {  -0.001562,    0.001778,    0.010313},
			{   0.873076,    0.001693,   -0.005756}, {  23.007463,  -24.785392,   -3.919677}, {  -0.068282,   -0.176987,    0.005123}, {  -0.761961,   -2.709768,    0.005102}, {   1.199573,   -0.774626,    3.661241}, {  -6.665177,   -5.637866,   -0.683124}, {   0.001103,    0.003306,   -0.255748}, {   0.000712,    0.000865,    0.015011},
			{   0.005859,    0.007385,    0.013062}, {   0.007141,    0.004271,    0.007377}, {   0.000975,   -5.563152,   -0.029543}, { -19.484661,   10.300514,    1.202162}, {   8.909100,   33.055694,   -0.998229}, {  20.215835,   14.766923,    5.926311}, {  -2.549415,   -3.441498,   -0.468450}, {   0.012230,    0.007774,    0.009033},
			{  -0.069509,    0.009376,    1.189185}, {   3.981126,   -4.964241,    0.271331}, {  -6.066405,   -0.094102,   -1.880496}, {  -7.387670,   -0.261675,   -1.880511}, {  -0.381027,    0.251208,   -0.003194}, {  -1.557937,   -2.161087,   -1.818652}, {   0.002929,    0.005859,    0.004120}, {   0.000243,   -0.251953,    0.352376},
			{  -2.866619,   -0.001940,   -0.434116}, {   0.015407,    0.238794,    0.001597}, {   0.353044,   -9.275419,    3.251111}, {   0.001656,    0.004044,    0.005466}, { -20.443470,   -8.612944,    0.001027}, {   0.002925,    0.002450,    0.006674}, {  16.306842,  -12.685985,    0.023050}, {   0.034474,    0.000003,    0.004373},
			{  -1.926960,   -1.103078,    0.004373}, {  -5.130461,    7.690565,    0.004373}, {   0.353394,   -2.085783,    0.160850}, {   0.040778,   -0.017316,    0.004373}, {   0.015247,   -0.004674,    0.018187}, {  -0.024049,   -0.032278,    0.057936}, {  -0.001468,    0.002951,    0.004373}, {  -0.032262,    0.006461,    0.005280},
			{  21.518560,   -2.576508,    0.001210}, {   0.003806,    0.003285,    0.001468}, {   0.000243,    0.006252,    0.002758}, { -22.366897,  -13.550926,    0.004559}, {   0.001877,    0.004472,    0.004271}, {   0.003043,    0.004056,   -0.008813}, {   0.003574,   -0.177706,    0.002900}, {   0.004269,    0.006661,    0.000547},
			{   0.002797,    0.005210,    0.006393}, {  -0.132919,   -0.093376,    0.005326}, {   0.007643,   -2.522583,    0.004339}, {   0.042569,   -0.006056,    0.009100}, {  -0.028080,   -0.015746,    0.001597}, {  13.710021,    1.119550,    0.160986}, {   0.000304,    0.001983,    0.348024}, {   0.005379,    0.000807,    0.805974},
			{  -0.099609,    0.052002,   11.548893}, {   0.000000,    0.000000,    0.000000}, {   0.005175,    4.017478,    0.349103}, {  -1.658848,   -0.255919,   -1.654026}, {   0.004861,   -0.003240,    0.000965}, {   0.013113,   -0.012958,   -3.199804}, {   0.166810,    0.004222,    0.116511}, {   0.002182,    0.006312,    0.003285},
			{  -2.709949,    0.614080,  -11.302364}, {   0.005594,   -0.001924,    0.002625}, {  -0.001671,    0.003551,    0.002943}, {  -0.503911,    0.020564,    0.219316}, {  -3.449803,   10.093411,    2.197369}, {   0.012697,    0.008669,    0.010924}, {   0.000125,    0.003645,    0.006666}, {  -1.946738,   -2.252473,    0.000905},
			{   0.185672,    0.010832,    0.004821}, {  -0.157948,    3.588275,    3.026384}, {   0.013148,    0.608000,   -6.518836}, {  -2.956223,    1.022642,   -8.144577}, {   0.115230,    3.948674,   -2.126893}, {  -3.852646,    3.436266,   -1.268187}, {   0.003600,    2.780838,   -0.050884}, {   0.010436,   11.699822,   -2.693069},
			{   3.253437,  -15.880180,    4.008058}, {   0.005359,   15.457981,    3.530246}, {   1.510643,    0.876558,    2.716310}, {   0.000000,    0.000000,    0.000000}, {  -0.000047,    0.001160,    0.001483}, {   0.000000,    0.000000,    0.000000}, {  -0.521403,   -1.769826,   -0.143230}, {  -4.845687,    1.346568,   -7.030932},
			{   0.003173,    0.005547,    0.002482}, {   0.003187,    0.005557,   -2.895210}, {   0.003526,    0.001643,    0.011637}, { -18.309118,    0.003844,   -3.287780}, {   0.008547,   27.472629,    0.017444}, {  -0.037252,    0.052404,   -0.768589}, {   0.163705,   -0.145208,   -0.092573}, {   0.162561,   -0.156789,   -0.089390},
			{   0.175199,   -0.154551,   -0.104982}, {   0.000999,    0.004676,    0.011149}, { -10.813679,    8.427877,    1.844807}, {  -4.271070,   -2.967000,    1.531085}, {  -2.570535,    0.931082,    0.001613}, {  -3.020899,    0.006862,    0.005315}, {   0.351808,   -3.362102,   -0.108612}, {  -2.907414,    2.125099,   -1.394397},
			{   0.005371,    0.013225,   -0.083567}, {  31.725391,   -1.513499,   -3.931998}, {  -2.153654,    1.567080,   -0.227156}, {  11.957016,   12.917432,    2.693682}, {   0.003401,    0.003681,    0.001429}, {   0.004331,    0.003591,    0.005084}, {   0.000112,    0.003164,    0.397989}, {  -1.522336,    0.134661,    0.012450},
			{   0.001128,    0.004883,    0.004335}, {   8.539218,   -3.309478,    0.003907}, {   0.011630,   -3.248337,   -2.012655}, {   0.004333,   -5.459166,   -0.742788}, {   1.330332,   -0.048827,   -1.649945}, {   0.265821,   -0.033849,    0.772563}, {  -0.064525,   -0.028322,   -0.104813}, {   2.699579,   -0.218023,   -2.928059},
			{ -10.028086,   16.056446,    0.019381}, {   0.003583,    0.004046,    0.000487}, {  -3.285459,   -0.356281,    2.048223}, { -14.483629,    4.537740,   -1.899919}, {   0.005028,    0.004968,    0.007613}, {   0.002455,    0.006924,    0.004801}, {   0.839123,   12.402808,   -5.258600}, {  -2.366906,    6.450582,   -8.650838},
			{   0.000192,    0.004989,    0.395996}, {   3.546746,   -4.128997,   -2.348654}, {  -3.371112,    0.305642,   -2.576499}, {   0.005663,   -2.827145,    0.343418}, {   0.006990,    0.004488,    0.003029}, {  -9.838827,   -0.004573,   -2.280661}, {  38.424541,   40.874275,    0.032669}, {  30.155553,    0.003876,    1.012887},
			{   0.280375,   -0.356011,    0.062541}, {  13.037454,   12.935247,    7.183777}, {  44.931926,  -10.908074,   -2.561608}, {   0.002061,    0.005685,    0.002910}, {  -2.131683,   -3.358680,   -0.420349}, {   6.025447,   -1.145037,    1.540848}, { -18.309122,   18.002099,   -3.380400}, {   3.066104,    0.367776,   -1.290773},
			{  16.047616,   -0.055245,    0.001636}, {   0.001011,   -0.078290,    0.005022}, {   0.004428,    0.006130,    0.000598}, {   3.206999,   -1.191617,    0.003631}, {   2.968854,    1.026314,    0.003631}, {   6.110424,    1.545204,   -1.889387}, {   0.002214,    0.006355,    0.002063}, {   0.004151,   -0.117870,    0.000315},
			{  -5.281815,    1.083114,    0.001532}, {   1.688742,    0.068660,   -0.331687}, {   0.007162,    0.004664,   -0.343154}, {   0.006699,    0.000403,   -0.098082}, {   0.005425,   -0.613089,    0.003500}, {  -5.384677,   -7.789483,   -1.337088}, {   0.011471,   -0.305997,    0.008929}, {   0.002541,    0.003174,    0.002780},
			{ -11.015387,    5.746624,    0.025817}, { -10.530550,   -9.790800,    0.025805}, {   0.017580,    0.014848,    0.013365}, {   5.584030,   -0.633585,    0.002736}, {  -0.004127,    0.004294,    0.000169}, {   0.119611,    0.006531,    0.005611}, {   0.002984,    0.757664,    1.507033}, {   4.405715,  -11.314232,    1.494840},
			{  -4.278269,   -1.105173,    1.132648}, {   0.254891,    0.654045,   -0.541674}, {   0.005853,    0.001069,   -0.142539}, {  -1.499498,   -4.994919,    0.468964}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.009155,    0.009979,    0.006849}, {  -1.152832,   -0.061347,    0.006978}, {  -0.029624,    0.006568,    0.004323}, {   0.010375,    0.007170,    0.008627}, {   0.007447,    1.297574,    0.009375}, {   0.007203,    3.301321,    0.058596},
			{  -0.002032,   -2.345182,   -0.003932}, {   0.000000,    0.003905,    0.000493}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.184942,    1.068027,    0.018448}, {  -1.802181,    2.653883,   -0.099578}, {   0.699548,   -1.753257,   -0.451355}, {   0.012027,   -0.010119,    0.015197},
			{  -0.987969,    2.974251,    0.018275}, {  -0.687582,   -0.000532,    0.094029}, {   0.000762,    0.002962,    0.004129}, {   6.713802,   -4.735588,    0.266656}, {  -0.131017,   -0.887232,    1.963021}, {   6.900135,    0.774950,    2.154604}, {   8.637273,    3.389384,    0.016510}, {   8.585807,   -2.545945,    0.047111},
			{   0.006388,   -1.455183,    0.001245}, {  -6.076430,    2.400367,    0.114335}, {  -0.084105,    0.383545,    5.800942}, {  -2.217605,    0.012192,   -0.390011}, {  -1.802109,    2.653884,   -0.099578}, {   0.699620,   -1.753257,   -0.451355}, {   0.185011,    1.068027,    0.018448}, {  -0.001662,    0.010653,    0.000929},
			{  -1.836573,    2.553040,    1.506325}, {   0.012098,   -0.010119,    0.015197}, {  -0.987899,    2.974251,    0.018275}, {  -1.795603,    2.653886,   -0.099578}, {   0.706125,   -1.753255,   -0.451355}, {   0.191517,    1.068029,    0.018448}, {  -0.001662,    0.017159,    0.000929}, {  -1.830067,    2.553040,    1.506325},
			{   0.018603,   -0.010119,    0.015197}, {  -0.981392,    2.974252,    0.018275}, {   0.007734,    0.000445,    0.088669}, {   1.299183,   -5.281143,   -0.243495}, {   1.482040,   -4.426545,   -0.134553}, {  -0.001662,    0.010580,    0.000929}, {   0.149961,    0.054389,    0.004898}, {   5.332958,   -2.859862,   -0.253329},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  -1.836644,    2.553039,    1.506325}, {   0.005909,    0.002083,    0.087075}, {  -0.053029,    0.170055,    0.010257}, {   0.038205,   -1.383834,   -0.001240}, {   0.129210,   -1.812186,    0.000190},
			{   0.010456,    0.015968,    0.008111}, {   0.011078,    0.010863,    0.003035}, {   0.152162,   -0.265762,    0.167832}, {   1.507606,   -1.724184,   -0.923905}, {  -0.248181,    2.772098,    1.908033}, {   0.722534,    0.014874,    0.011718}, {   0.002544,   -0.030665,    0.280557}, {   1.817163,   -1.754832,    0.318020},
			{   1.144644,    1.524127,    0.161901}, {   3.003607,   -0.154655,    0.011598}, {   0.200546,    0.002304,    0.000441}, {   0.004542,    0.002083,    0.003362}, {   0.002216,    0.003348,    0.003362}, {   2.828376,    0.220319,   -0.067625}, {   5.027060,   -3.007067,    1.611960}, {   2.367090,   -1.148574,   -0.263796},
			{   1.999207,    0.004985,    1.154147}, {   0.007257,    0.001418,    0.002840}, {  -1.064746,    0.051084,    2.077344}, {  -0.911785,    1.249979,    0.761888}, {   0.047703,   -1.870535,    2.081156}, {   0.045368,   -1.869313,    2.081156}, {  -1.067080,    0.052305,    2.077344}, {  -0.914119,    1.251201,    0.761888},
			{   0.000265,    0.001217,    0.000103}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, { -15.169157,    0.640141,    0.004836},
			{ -21.123498,   -4.734213,    0.794373}, {   8.051570,    0.000771,    1.880640}, {   0.002944,   -1.046144,    0.007817}, {  -4.087728,    0.101962,    0.081427}, {   0.007766,   -3.992415,    0.002028}, {   4.006650,   -2.591211,    1.310716}, {   0.002684,    0.258148,   -0.164707}, {   8.320384,   -2.340594,    0.004927},
			{   0.218941,    2.133169,    0.004927}, {   0.777592,   -5.077715,    1.320111}, {   0.002161,    6.049824,    0.004927}, {  -0.004157,    0.004350,    0.007555}, {  -0.000866,    0.003767,    0.003470}, {   4.286417,   -0.654370,    0.002196}, {  -0.067561,   -4.666022,   -2.559765}, {  -7.573751,    4.730979,    1.385354},
			{   0.018977,    0.001519,    0.007555}, {  10.800251,   -8.705586,   -3.132190}, {  -0.013125,   -0.024864,    0.001431}, {   4.103116,   12.409864,    0.752380}, {   0.771036,   -1.048045,   -0.156174}, {  -9.896045,    7.932655,    2.618591}, {   4.931528,    9.785514,    2.147768}, {   2.149997,   -2.614644,   -2.559763},
			{  -4.120779,    3.285279,    1.957012}, {   0.011958,    0.000942,    0.003127}, {   0.000984,    0.005983,    0.007741}, {  -3.263417,    0.001864,    0.382391}, {   0.767395,    9.111497,    1.228476}, { -13.365544,   -0.402280,    0.585581}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.011397,    0.005104,    0.012329}, {   0.004720,    0.005268,    0.006552}, {   0.008384,    0.013636,    0.020202}, {   0.016237,    0.012710,    0.014465}, {  -0.007509,    0.002265,    0.007019}, {   0.001883,    0.015869,    0.014465},
			{  -0.001304,    0.198286,   -0.185440}, {   4.535531,   -0.146052,    2.888454}, {   0.158020,   -0.467162,   -0.261031}, {   0.106140,    1.900879,    0.187800}, {  -0.004577,   -0.000730,   -0.028859}, {   0.450866,    0.446898,   -0.010510}, {   0.003396,   -0.007261,    0.010619}, {   0.356563,   -0.090260,    0.014871},
			{   0.161417,    0.001739,    0.585590}, {   0.794939,    0.216654,    0.466030}, {   0.007040,    0.069296,    0.006696}, {   0.002517,    0.000574,    0.003913}, {   9.217519,    6.519755,    1.862112}, {  11.396490,   -6.874177,   -0.183246}, {   0.005789,    0.004674,    0.005233}, {   0.079828,   -0.316404,   -0.938853},
			{   0.001381,    0.004794,    0.002747}, {   0.006798,    0.004501,    0.005797}, {  -0.016550,    0.006105,    0.081422}, {   0.007553,    0.005200,    0.002889}, {   6.270366,    0.003494,   -1.717007}, {   0.005466,    0.004546,    0.004734}, {   0.358527,    0.004232,    0.001667}, {   0.003411,    0.007168,    0.005687},
			{   1.614205,   -0.646254,    0.527418}, {  -2.537108,    0.021626,    0.017648}, {   1.006114,   -0.267639,    0.001695}, {   0.152327,    0.007259,    0.005162}, {   0.002514,    0.003870,    0.000985}, {   0.016287,   -0.120650,    0.001444}, {  -0.187298,    0.006984,   -0.082065}, {   0.089704,   -0.226714,    0.000249},
			{  -0.213810,   -1.242115,    0.011427}, {   0.004052,    0.002918,   -1.043231}, {   0.001014,    0.004294,    0.000625}, {  -0.000006,   -0.835955,   -0.342579}, {   0.006593,    0.000658,    0.002257}, {   0.005005,   -4.884562,    0.638800}, {   0.007079,    0.003548,    0.067342}, {   0.001672,    0.005003,    0.010448},
			{   0.004681,    0.000730,    0.002624}, {  -0.778720,    0.003821,   -0.044507}, {  -0.191018,    0.013372,    0.000608}, {  -0.757192,   -0.132768,    0.116416}, {   0.006649,    0.003753,    0.001952}, {   0.001170,    0.003850,    0.002682}, {   0.005253,   -0.985234,    0.003802}, {   0.005253,   -0.986508,    0.454095},
			{   0.004643,   -0.986393,    0.503219}, {  -0.038208,    0.002723,   -0.000102}, {   0.007451,    0.003380,    0.006103}, {   0.006587,    0.002584,    0.002737}, {   0.293083,    0.499908,    0.007309}, {   5.409578,   -7.674129,    0.846460}, {   0.001708,   -1.761098,    0.639820}, {   2.120606,  -13.094457,   -0.444160},
			{   6.024225,    8.856653,   -0.876747}, { -10.518783,    0.412811,   -0.992681}, {   0.075985,    0.109607,    1.024116}, {   1.677996,   -3.565099,    0.580407}, {   3.662262,   -4.759920,   -1.073137}, {   9.503760,   -4.745995,   -0.943271}, {   0.010863,    3.861282,    0.326332}, {   0.006535,    0.002074,    0.053651},
			{   0.266442,   -2.396924,   -0.220118}, {  -0.004035,   -0.011866,    0.472075}, {   0.016414,   -0.007166,    0.019469}, {   0.253609,    0.026064,    0.011230}, {   0.020864,    0.019879,    0.013265}, {   0.002004,    0.003607,    0.007327}, {  -1.242681,   -0.005253,    0.064332}, {  -0.002264,    1.037907,    0.133240},
			{   0.002701,   -0.000130,    0.007629}, {   0.005663,    0.004009,    0.006196}, {   0.005845,    0.000036,    0.000438}, {  -0.000444,    0.001701,    0.008178}, {  -0.006622,   -0.017203,   -0.132264}, {   0.001686,    0.007373,   -0.002473}, { -11.866613,   -4.807648,   -0.129728}, {   0.004075,    0.009685,    0.003784},
			{  -0.256731,    0.005016,    0.003661}, {   0.000000,    0.000000,    0.000000}, { -34.448051,   -4.402087,   -2.571567}, {   0.005524,    0.009521,    0.001519}, {   0.209446,    1.843222,    0.552496}, {   0.004089,    0.013794,    0.006428}, {   0.001830,    0.007416,    0.004100}, {   0.003998,    0.013671,    0.004379},
			{   0.003967,    0.010559,    0.041294}, {   0.005828,    0.009308,    0.001520}, {   0.000487,    0.014618,    0.001628}, {   0.006591,    0.011505,    0.007199}, {  -3.913361,    0.042888,    0.000237}, {   0.002561,    0.008666,    0.007625}, {   0.395271,    1.971680,   -1.244210}, {   0.061388,    0.011993,    0.362134},
			{  -0.404810,    0.196695,    0.087021}, {   2.651874,   -0.637611,    0.106568}, {   1.106255,   -1.087811,    0.160199}, {   0.011164,   -0.000823,    0.007672}, {   0.004914,    0.005673,    0.007346}, {   0.004916,    0.004372,    0.007354}, {   0.002648,    0.001972,    0.003348}, {  -2.470724,    0.005028,    0.002562},
			{   0.004761,    0.007286,    0.003491}, {   0.001703,    0.002545,    0.000714}, {   0.002013,    0.002823,    0.003407}, {   0.001857,    0.007391,    0.001511}, {   0.000000,    0.000000,    0.000000}, {   0.002923,    0.000814,    0.000188}, {   0.006080,    0.327737,    0.007573}, { -15.123499,    0.238966,   -0.092148},
			{  -0.021975,    2.094072,    1.295299}, {   0.018400,    0.000613,   -0.006182}, {   0.009483,    0.003784,    0.006469}, {   1.172386,    0.416557,   -0.021477}, {  -0.006101,   -0.007172,    0.002612}, {  -0.745209,    0.000789,    0.002968}, {  -0.750092,    0.002125,   -0.000144}, {   0.006883,    0.007211,    0.005179},
			{   0.002033,    0.000048,   -0.273488}, {   0.002940,    0.000046,    0.000269}, {   0.001551,    0.005466,    0.004968}, {   0.000000,    0.000000,    0.000000}, {  -0.749711,    0.004375,    0.025805}, {  -0.749605,    0.006450,    0.008410}, {   8.848697,   14.858359,    1.928820}, {   0.000684,    0.006318,    0.001954},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.011722,   -0.006544,    0.011696}, {   0.001477,    0.004302,    0.011696}, {  -0.430173,   -5.617700,   -0.289400}, {  -0.129989,   -0.091913,    0.012653}, {   0.107403,   -0.097833,    0.048921}, {  -0.097746,    0.104864,    0.000706}, {   2.685473,   -1.784301,    1.502208},
			{   2.820935,   -0.482751,   -0.266481}, {   6.160120,   -1.878741,    2.605248}, {   0.007584,    0.004184,   -0.002529}, {   1.145395,   -0.383967,    2.600677}, {   0.007122,    0.000958,    0.003023}, {  -0.007100,   -0.173947,    0.303474}, {   0.007207,    0.003192,    0.000130}, {  -0.041723,   -0.003945,    1.101572},
			{  -1.784567,  -13.071876,    0.038446}, {  -0.020364,    0.012303,    0.000651}, {  -0.719726,    1.112059,    0.125244}, {   0.123985,    0.006787,    2.150547}, {   0.003922,    0.015095,    0.007400}, {   0.002333,   -0.002787,    0.007230}, {   4.055202,   12.328746,    0.786615}, {   0.010169,    0.008818,    0.008968},
			{  16.964149,    1.502540,   -0.392468}, {   0.006351,    0.007340,    0.000616}, {  -2.482230,   -5.917333,    1.708930}, {   2.685473,   -1.884295,    0.168040}, {  -0.711753,    3.179081,   -0.027520}, {  -1.728930,   -9.473901,    0.750678}, {   3.814585,    4.190732,   -0.505163}, {  -5.154213,    3.464843,    0.934958},
			{  -0.719810,    3.066744,   -1.478368}, {  -0.005373,   -0.001586,    0.001719}, {   0.003609,    0.006957,    0.006775}, {   5.197072,    1.502671,   -0.392468}, {   0.007346,    0.002135,    1.860595}, {  -0.004385,    0.002074,    0.011014}, {  -0.004385,   -0.013930,   -1.985370}, {   1.503257,    2.344481,    0.862671},
			{  -1.731094,   -1.912536,   -0.836426}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.003600,   -1.500092,    5.312334}, {   0.004592,   -0.018126,    1.516991}, {  -0.095711,    0.014526,    3.559164}, {  -0.120302,    0.009390,   -0.235419}, {  -0.041462,   -0.348839,    0.544421}, {  -6.487475,   -7.631560,    0.415960}, {  -5.229930,    0.086456,    8.624341}, {  -5.309799,    7.800008,    0.945899},
			{  -0.313032,    0.043914,   -5.339350}, {   1.459372,    4.400023,    5.844100}, {  -7.708771,   -1.632446,    2.687267}, {   1.408859,   -0.061767,    2.857995}, {   0.005005,   -3.820067,    1.791450}, { -17.991739,    8.585857,    0.366055}, { -10.203964,   -0.163085,   -0.647861}, {   0.055305,   -9.270141,   -0.080104},
			{   0.002522,    0.002685,    0.003035}, {   0.001338,    0.003539,    0.002123}, {   0.002742,    0.000976,    0.001514}, {   1.296890,   -2.377440,    0.000736}, {   0.003151,    0.000609,    0.000693}, {   1.402724,   -0.528015,    4.017827}, {  -0.433501,   29.061950,    0.250508}, {   0.004211,    0.000487,    0.006674},
			{   2.554047,   -2.334839,    1.015676}, {  -6.756401,   -2.256774,  -18.628608}, {  -0.534045,   -0.292236,    0.000792}, {   0.791369,   -0.653442,    0.006008}, {  -0.518585,    0.395386,    0.006484}, {   1.846084,    0.608336,    0.004672}, {  -1.490630,   -1.502990,    0.006581}, {   0.093933,   -0.116576,    0.002154},
			{  -0.082275,   -0.059691,    0.003146}, {   0.000762,   -0.396117,    0.003412}, {  -0.132415,    0.157592,    0.000719}, {  -1.388092,    0.184691,    0.001514}, {   0.582794,    0.827148,    0.030239}, {  -0.057831,    0.031210,  -18.379264}, {  -1.584534,    0.007323,  -46.973247}, {   0.004836,    0.001586,   -2.525363},
			{  -3.024611,   -9.641418,   -2.525738}, {  -3.022826,   -9.644409,   -2.996330}, {  17.155273,   26.936523,   -2.528639}, {  17.153305,   26.933959,   -2.530033}, {   0.004211,    0.002196,   -2.525481}, {   0.001464,    0.003173,   -2.528445}, {   0.001555,    0.001830,   -2.529289}, {   0.004242,    0.005431,   -2.527896},
			{   0.000092,    0.003661,   -2.526215}, {   0.007660,    0.006225,   -2.527396}, {   0.003264,    0.004211,   -2.524048}, {   5.655636,   -1.991094,    1.567989}, {   0.001129,   -0.006734,    0.098955}, {  -0.000413,   -0.005367,    0.007672}, {  -3.252990,    5.428878,    2.109338}, {   0.004486,    0.002715,    0.004807},
			{   6.399520,   -6.054749,    0.006091}, {   0.004195,   -6.817626,    0.004906}, {   1.268707,    0.005737,    0.004807}, {   0.002624,    0.001739,    4.579644}, {  -1.035416,   17.025024,    7.482435}, {   0.729187,    0.606688,    7.226296}, {   0.004066,    0.006591,    0.003347}, {  -0.366463,   -0.150269,   -1.205062},
			{   7.332026,   -5.866240,    0.692942}, {   6.237538,  -15.452709,    0.204374}, {   0.518257,   -9.131988,    2.199640}, {  -1.366050,   -1.660385,    3.834630}, { -10.167286,    2.021861,    1.544849}, {  -4.009407,   -0.107736,    2.384160}, {   4.935677,    2.844757,    1.912366}, {  -3.774013,    2.260132,    0.092679},
			{  -3.772506,    2.256050,   -1.932793}, {  -2.850460,    3.372101,   -0.181029}, {  -3.771754,    2.260253,   -1.054981}, {  -4.166477,   -1.234521,   -1.966526}, {   1.005180,    1.000877,    1.118008}, { -24.342620,  -40.105560,    1.310340}, {  -3.934794,    1.931977,    0.009312}, {  -4.067452,   -1.588444,   -1.987086},
			{ -54.470031,   -9.122863,   17.052909}, { -60.342636,  -10.518016,   18.977333}, {  -0.610696,    0.291025,   -0.954294}, {  -0.456517,   -0.016808,    0.005450}, {   1.090682,    2.924896,    4.181868}, {  -3.483979,    4.508601,    0.223253}, {  -8.817604,  -24.177368,   -1.788558}, { -17.370481,    0.406379,   -0.611172},
			{   0.002288,    0.002685,    3.829406}, {   0.006897,    0.002685,    3.829406}, {   0.003844,    0.002685,    3.829406}, {   0.005034,    0.002685,    3.829406}, {   0.003386,    0.002685,    3.829406}, {   0.081605,   -0.316390,   -0.450562}, {   0.328563,    0.246643,   -0.340063}, {  -0.352665,    0.001942,    1.925958},
			{  -0.007251,   -0.005615,    0.011803}, {   0.006744,   -0.120819,    0.004703}, {   0.149473,    0.003650,   -0.433984}, {   9.688293,    0.001647,    2.389863}, {  -7.117516,    0.578284,    0.111180}, {   0.024259,    0.005615,    5.468018}, {   0.005493,    0.002074,    0.006506}, { -19.863433,    0.207885,   -4.363413},
			{  16.587812,   23.313438,    4.096899}, {   0.734107,    0.030387,   -0.032430}, {   1.304196,   11.637392,   -0.068267}, {  -0.602846,   -2.249701,    1.993710}, {   0.000915,    0.000425,    0.008066}, {   0.000350,    0.000304,    0.003035}, {  -3.581140,   11.565811,    1.751207}, {  -5.634346,  -11.033140,    1.754418},
			{   9.568941,   -1.454848,    6.117205}, {   7.542127,   -0.245942,   10.814933}, {   3.437508,   -7.112840,   12.853281}, {   9.679113,   13.444558,    0.950379}, {   7.539547,   -0.252656,   12.525075}, { -11.934852,    3.831020,    2.129601}, {  -7.395365,    7.072030,   10.816422}, {  -2.794616,    0.315153,   17.963611},
			{   8.596437,   -3.184737,   10.816139}, {   8.644536,   -5.647317,   10.814190}, {   8.989750,   15.974025,   12.328653}, {   0.979036,  -19.765518,    4.307857}, {   0.457502,   11.595638,    1.756260}, {  15.044090,  -17.840026,    0.273847}, {   1.301810,   -4.707408,    4.489830}, { -11.583152,    0.869243,    1.753026},
			{  17.810977,  -17.440767,    1.758806}, {  -4.205256,    4.245251,    3.259092}, {  -1.096230,  -23.429763,   12.470894}, {  -9.304506,   13.001684,   16.936496}, {  -3.318578,   -3.398592,    3.229173}, {  -5.534319,    7.067961,   10.116448}, {  -4.845482,   -4.329095,    4.390351}, { -14.000817,    1.181238,    0.113659},
			{   0.928849,    2.784012,    0.445594}, {  -0.734494,  -13.495601,    2.450431}, {   5.883864,   -4.384301,    2.713606}, {  -4.375712,   -8.678245,    6.999190}, {  -4.900095,   -3.846748,    8.621866}, {  12.248910,    6.841669,   20.257564}, {   0.003408,    0.004279,    0.002492}, {  13.266794,    8.330112,   -0.555396},
			{   3.682444,   -2.259948,    0.468163}, {  -2.651793,  -16.645938,    3.401634}, {  -3.041364,   -0.002264,    0.002700}, {  -8.795745,    5.069152,    0.003643}, {   0.000564,    0.006591,    0.006173}, {   0.004058,   -0.000060,    0.003548}, {   0.552616,   -3.707273,    1.504184}, {  -0.513256,    0.267466,    0.743332},
			{  -0.001240,    1.168563,    0.902032}, {  -0.725723,   -3.019874,    2.835623}, {  -0.065962,   -3.306371,    0.983582}, {   0.380658,   -0.696057,   -0.341556}, {   3.842508,   -0.365568,    0.051288}, {   0.007660,    7.832413,  -81.142921}, {   0.007385,    3.718018,  -32.642555}, {   0.002044,    3.927654,  -35.785003},
			{   0.005187,    5.937271,  -38.723266}, {   0.370588,   25.630645,  -43.821201}, {   0.004730,  -16.963962,   -0.511844}, {   0.801757,    0.006347,    0.005989}, {   0.001433,    0.005005,    0.007362}, {   2.652863,    0.000121,    3.524333}, {   9.813789,   -2.598320,    1.183735}, {   0.005005,    0.004271,    0.000144},
			{   0.001265,    0.003417,    0.003053}, {   0.001403,    0.005737,    0.003340}, {   0.004836,    0.002318,    0.003253}, {   0.004974,   -2.269336,  -42.539474}, {   0.007019,    1.317016,  -52.991821}, {  -0.613361,    6.038695,  -65.021926}, {   0.770874,    0.436080,  -54.257759}, {   3.091197,    4.805646,  -25.062217},
			{   0.006438,    0.002929,    1.055457}, {  22.363681,    1.793246,    0.605132}, {   0.502991,    1.357543,   -3.865353}, {  -0.041615,    1.337769,    0.005061}, {   1.343719,    0.007567,    0.002341}, {  -1.983096,    0.000976,    0.004040}, {   0.007408,  -10.492188,    3.654575}, {  -1.171859,  -53.209838,    0.677645},
			{   0.205596,    0.780426,   -1.877519}, {   0.001220,    0.001342,    0.261249}, {   1.051574,    0.003783,   -0.071634}, {   0.000121,    0.005797,   -0.466877}, {   0.002288,    0.006957,    0.006360}, {   0.006957,    0.004577,    0.004348}, {   0.000762,    0.001708,    0.003592}, {   0.003661,  -14.088195,   -1.584445},
			{   0.001991,    0.004329,    0.001357}, {   0.007507,    0.006957,    0.000461}, {   0.128692,    0.003051,    0.001267}, {   0.005202,    0.002990,    0.005384}, {  -2.099509,    0.006287,    0.006167}, {   0.012946,    0.000365,    0.003216}, {   0.007499,    0.006713,    0.001455}, {   0.000640,    0.000121,    0.005574},
			{   0.000000,    0.004761,    0.005725}, {   0.000046,    0.004867,    0.004131}, {   0.005489,    0.004761,    0.006676}, {   0.006186,    0.097228,    0.338063}, {   0.007720,    0.005187,    0.000691}, {   0.002715,   -0.230590,   -1.294564}, {   0.001357,    0.000915,    0.004313}, {   0.003548,    0.000243,    0.002158},
			{   0.000251,    0.000915,    0.003824}, {   0.006035,    0.001891,    0.002644}, {   0.006469,    0.001952,    0.000615}, {   0.002105,    0.006041,    0.006240}, {   0.008590,   -0.444362,   -0.465359}, {  -0.006362,    0.006347,    0.409121}, {  -2.580138,    0.006653,    0.000625}, {  54.435836,    0.007263,    0.314653},
			{   6.049193,    0.578801,    1.146142}, {   0.000869,    0.004120,    0.006227}, {   0.000533,    0.002929,    0.001532}, {   0.006637,    0.004668,    0.004813}, {   0.005470,    0.003783,    0.422311}, {   0.004654,    0.007507,    0.128125}, {   0.004242,    0.006500,    0.378091}, {  -0.016459,    0.000792,   -0.621985},
			{   0.001082,    0.001586,    0.004714}, {   0.003135,    0.328552,    0.007495}, {   4.081898,    0.000884,    0.262822}, {  -1.252750,    0.001403,    0.004606}, {   0.007079,    0.007172,    0.777487}, {   0.006515,    0.000092,    3.990536}, {   0.000079,    0.003722,    0.007505}, {  -0.228565,    0.638889,    0.007042},
			{   1.046043,    0.004333,    0.000714}, {  -2.232063,    0.260924,   -5.989709}, {  -0.641815,    0.006713,    1.186187}, {   0.001430,    0.001464,    0.000486}, {   0.007232,    0.005859,    0.257907}, {   0.004546,    0.000548,    0.005388}, {   0.006804,    0.005249,    0.007666}, {   0.004821,    0.095275,    0.280909},
			{   0.005034,    0.004333,    0.433964}, {   0.006744,    0.004271,    0.003879}, {   0.006302,    0.000670,    0.246802}, {  -1.700438,    0.797981,    0.755307}, {   0.003417,   -2.587554,   -0.056187}, {   0.006614,    0.001830,    0.064733}, {   0.006393,   13.742095,   10.381881}, {   0.005675,    0.004424,    0.003413},
			{   0.014403,    0.001342,    0.007734}, {   0.000762,    0.005005,    0.005646}, {   0.000731,    0.001952,    0.007156}, {   0.000609,    0.004027,   -0.442360}, {   0.314240,    0.000853,    0.005962}, {   0.004852,    0.000243,    0.006167}, {   0.003844,    0.003295,    0.004964}, {   0.005615,    0.864745,  -41.484828},
			{   0.007263,    0.001586,    0.001786}, {   0.003325,  -51.689270,   -4.001726}, {   0.000136,    0.005005,    0.004488}, {   0.005462,    0.002685,    0.004445}, {  -0.126941,    0.002074,   -0.133100}, {   0.008297,    0.001403,    0.004598}, {   0.005324,    0.001571,    0.509200}, {   0.000411,    0.003783,    0.003482},
			{   0.003020,    0.004455,    0.006531}, {   6.309535,   -4.168247,  -32.399902}, {   0.948435,    1.791275,    1.032806}, {  -5.358283,    0.641565,   -1.155967}, {  -1.831848,    8.861755,   -0.037436}, {  -6.281906,  -11.198730,   -3.565519}, {  13.609343,   -5.344055,   -1.092499}, {   0.003245,    0.003973,    0.003103},
			{ -15.965033,   -2.227963,   -0.028351}, {  -0.244781,    2.099097,   13.808335}, {  -0.244781,    2.099097,   13.808335}, {  -0.244781,    2.099097,   13.808335}, {  -0.244781,    2.099097,   13.808335}, {  -0.244781,    2.099097,   13.808335}, {  -0.244781,    2.099097,   13.808335}, {  -0.244781,    2.099097,   13.808335},
			{  -1.499886,   -6.948404,    1.598417}, {   0.043581,   -0.046131,   -0.573450}, {  -3.686446,  -11.444580,   -0.581736}, {  -2.714057,    1.065796,   -0.049199}, { -12.656951,   -2.311461,    0.726073}, {  -0.418401,    0.980144,    2.893748}, { -16.019683,   -0.130614,   -0.205014}, {   0.003523,   -0.003480,    2.453798},
			{   3.060103,   -2.679749,    2.095637}, {   2.851669,   -4.452454,    1.339126}, {  -0.241530,   -1.236145,   -1.206871}, {   0.003142,    0.001647,    0.006597}, {   0.005034,    0.000670,    0.004149}, {  -0.023330,    1.635434,    0.490972}, {  -0.132614,    1.976865,    0.204444}, { -21.257431,   23.895599,    4.952285},
			{   0.001006,    0.004761,    0.000998}, {   0.001830,    0.002196,    0.001296}, {   0.000304,    0.004271,    0.004627}, {   0.002654,    0.002624,    0.001442}, {   0.002501,    0.000365,    0.002399}, {  -1.784561,   -0.047890,   -1.249076}, {   0.625898,    0.474123,   -0.461457}, {   1.798503,    1.651872,    4.190422},
			{   0.509985,    0.389604,   -1.302325}, {  -2.083321,    0.387773,   -2.746839}, {   0.002174,    0.000243,    0.005814}, {   0.005295,    0.004546,    0.000059}, {  -0.023366,    0.182697,    0.958670}, {  -3.367599,    0.019618,   -0.871595}, {   0.060297,   -2.714428,    2.348481}, {   4.641794,    0.017580,   -0.055344},
			{  -2.870816,   -0.774103,    0.880074}, {   5.928719,   -4.781260,    1.150414}, {   0.063568,    0.006821,    0.325717}, {  -6.129785,   -5.213631,    0.579640}, {  16.222879,    0.308535,    2.272984}, {  -0.203224,   -0.496123,    1.610816}, {  -4.634303,   -0.008015,    2.368164}, {   3.209943,   -0.377083,    0.977946},
			{  -5.639689,   -9.726581,   -2.643066}, {  11.510367,   11.056232,   -1.430052}, {   0.048424,   -0.018188,   -1.719045}, { -19.990264,  -60.004981,    2.832751}, {  -0.960843,    7.803372,    0.610019}, {   1.487380,   -1.796033,    2.993361}, {  -2.290461,    0.760033,    3.569350}, {   0.014386,   -0.011646,    6.228741},
			{   0.035027,    0.000293,   34.136871}, {  -0.351871,    0.006531,   29.382276}, {   0.010192,    0.005553,   36.348411}, {  14.624294,    0.024527,   60.018512}, {   0.016235,    0.044909,    0.019349}, {   0.008422,    0.013689,   -0.200849}, {  34.162685,  -40.995632,   -3.646234}, {   9.090299,   -2.906512,   54.884429},
			{   9.090299,   -2.906512,   54.884429}, {  -0.003230,    0.006835,    1.023053}, {   0.003685,   -0.115270,    0.003572}, {   0.998926,   -0.005069,    0.000000}, {   0.004627,    0.002737,    0.007017}, {   0.007443,    0.001399,   -0.001622}, {   0.004627,    0.004935,    0.007017}, {   0.007447,    0.001178,   -0.002659},
			{   0.005237,   -0.004910,    0.006713}, {   0.004627,    0.006887,    0.007017}, {   0.004627,    0.001273,    0.007017}, {   0.007451,    0.001178,   -0.000829}, {   0.001492,   -0.004887,    0.006713}, {   0.004627,    0.003225,    0.007017}, {   0.004860,   -0.003040,    0.000000}, {   0.007449,    0.001399,   -0.003696},
			{   0.007251,   -0.120454,    0.003572}, {   0.007453,    0.001399,   -0.001866}, {   0.003628,   -0.120452,    0.004015}, {   0.005859,    0.022734,    1.000617}, {   0.005859,    0.022733,    1.001593}, {   0.002067,   -0.006525,   -0.560781}, {  -1.829368,   -0.295408,   -0.492096}, {  -0.594237,   -0.011721,    2.479793},
			{  -0.008802,    0.000915,    2.929369}, {  -0.002120,    3.451941,    1.965070}, {  -0.003887,    0.000944,    0.005863}, {   0.005423,    0.000276,    0.001475}, {   2.485357,    6.521420,    1.964995}, {   0.001921,   -0.004395,    0.001143}, {   0.001925,   -0.004761,    0.001143}, {  -0.318677,   -0.101917,    0.003489},
			{   0.014100,   -1.911391,   -0.256455}, {  -0.035514,    6.582389,    0.344889}, {  -0.002511,   -3.656635,    0.274248}, {   0.447290,    0.140857,   -2.409622}, {  -0.143916,    0.598848,   -2.040564}, {   1.305382,    0.054510,   -1.836397}, { -85.431945,   20.347131,    0.243379}, { -22.200239,   11.283278,    0.044539},
			{   6.309535,   -4.168247,  -32.399902}, {   0.011377,    0.002754,    0.003342}, {   0.016104,   -0.239112,    0.112450}, {   0.004486,    0.002715,    0.004807}, {   1.268707,    0.005737,    0.004807}, {   0.002624,    0.001739,    4.579644}, {   0.004195,   -6.817626,    0.004906}, {   6.399520,   -6.054749,    0.006091},
			{  -3.242862,   -0.137808,   -5.319151}, {  -4.255897,   -0.295228,    4.001819}, {  -1.888070,    9.282629,    4.680062}, {   3.279685,   -1.881217,    2.110971}, {   6.078671,    0.368770,    3.044264}, {   0.003953,   -1.539116,    0.966150}, {  -0.222719,   -0.240508,    0.002946}, {  24.459070,   -7.963851,   -1.428825},
			{ -14.812110,  -10.666984,    2.297935}, { -14.735221,   10.624580,    0.007503}, {  29.318130,    8.201576,   -1.986178}, {  -4.658137,   -0.060095,    6.539949}, {   8.913574,    0.043457,    2.782736}, {   0.000853,    0.001021,    0.000831}, {   0.725887,    2.517003,    2.709431}, {  -6.003555,   -7.472630,    3.395023},
			{  -0.743601,   -0.363216,    2.479990}, {  -1.287922,    0.001220,    1.847365}, {  -0.002197,   -1.328665,   -0.774587}, { -19.645048,    5.918015,   -4.367418}, {   0.006819,   -0.480746,    0.108294}, {   0.004590,   -0.480264,    0.107005}, {   1.465505,   -0.015948,    1.472177}, {   0.674459,   -1.707584,    2.017107},
			{  -0.913739,    0.000804,    0.009022}, {  -0.916387,   -0.994553,    2.917105}, {  -0.215800,   -3.505649,    0.168936}, {   5.273612,   28.231357,    2.084853}, {  -5.229930,    0.086456,    8.624341}, {   4.935677,    2.844757,    1.912366}, {   0.000609,    0.004027,   -0.442360}, {   0.000853,    0.001021,    0.000831},
			{   0.006637,    0.004668,    0.004813}, {   0.001082,    0.001586,    0.004714}, {   0.003135,    0.328552,    0.007495}, {   0.005470,    0.003783,    0.422311}, {   0.907792,    0.166931,    0.124513}, {   4.896258,   12.415355,   -0.526385}, {  -3.245449,   14.691713,   -3.424015}, { -18.240152,    0.902671,   -0.874992},
			{   1.337399,  -15.627547,    1.407556}, {   6.049193,    0.578801,    1.146142}, {   1.337399,  -15.627547,    1.407556}, {   4.896258,   12.415355,   -0.526385}, {  -3.245449,   14.691713,   -3.424015}, { -18.240152,    0.902671,   -0.874992}, {  -0.001255,    0.004439,   -0.560781}, {   0.002067,   -0.006525,   -0.560781},
			{  -0.001255,    0.004439,   -0.560781}, {  -5.309799,    7.800008,    0.945899}, {  20.988683,   17.277366,   -0.377871}, {  -6.487475,   -7.631560,    0.415960}, {   0.002857,   -0.836009,    5.510684}, {  -0.008228,   -0.834442,    5.510685}, {   0.006225,   -0.828083,    5.512334}, {  -0.003682,   -0.835891,    5.512350},
			{  -4.009407,   -0.107736,    2.384160}, { -10.167286,    2.021861,    1.544849}, {   0.064451,   -0.005100,   -0.150048}, {   7.332026,   -5.866240,    0.692942}, {  -0.161118,   -0.264889,    0.083746}, {   0.006637,    0.003967,    0.000066}, {  -0.010271,   -0.005452,   -0.716821}, {   6.237538,  -15.452709,    0.204374},
			{  -0.026007,   -8.654603,    0.214817}, {   0.314240,    0.000853,    0.005962}, {   0.005005,    0.004271,    0.000144}, {   2.652863,    0.000121,    3.524333}, {   0.001265,    0.003417,    0.003053}, {   0.001991,    0.004329,    0.001357}, {   0.006438,    0.002929,    1.055457}, {   0.007408,  -10.492188,    3.654575},
			{   0.007507,    0.006957,    0.000461}, {   0.000136,    0.005005,    0.004488}, {  22.363681,    1.793246,    0.605132}, {  -1.171859,  -53.209838,    0.677645}, {   0.007263,    0.001586,    0.001786}, {   0.012946,    0.000365,    0.003216}, {   0.007499,    0.006713,    0.001455}, {   0.005615,    0.864745,  -41.484828},
			{   0.502991,    1.357543,   -3.865353}, {   0.205596,    0.780426,   -1.877519}, {   0.128692,    0.003051,    0.001267}, {  -0.126941,    0.002074,   -0.133100}, {  -0.041615,    1.337769,    0.005061}, {   1.343719,    0.007567,    0.002341}, {   0.001220,    0.001342,    0.261249}, {   1.051574,    0.003783,   -0.071634},
			{   0.000121,    0.005797,   -0.466877}, {   0.002288,    0.006957,    0.006360}, {   0.006957,    0.004577,    0.004348}, {   4.550961,   -5.091321,    5.131381}, {   4.550961,   -5.091321,    5.131381}, {   7.058378,   -0.991943,    2.779439}, {   7.058378,   -0.991943,    2.779439}, { -13.014875,   -0.992070,    2.663568},
			{  -0.178183,   -0.094489,   -0.825882}, {  -1.785794,   -0.049984,   -2.390525}, {  -0.178183,   -0.094489,   -0.825882}, {   0.000533,    0.002929,    0.001532}, {   0.006744,    0.004271,    0.003879}, {   0.004242,    0.006500,    0.378091}, {   0.004654,    0.007507,    0.128125}, {   0.000869,    0.004120,    0.006227},
			{   0.006614,    0.001830,    0.064733}, {   0.007079,    0.007172,    0.777487}, {  -1.252750,    0.001403,    0.004606}, {   4.081898,    0.000884,    0.262822}, {   0.006515,    0.000092,    3.990536}, {   0.006393,   13.742095,   10.381881}, {   0.005675,    0.004424,    0.003413}, {   0.014403,    0.001342,    0.007734},
			{   0.000762,    0.005005,    0.005646}, {  -1.983096,    0.000976,    0.004040}, {  -1.348618,   -0.912639,    0.007007}, {   0.004730,  -16.963962,   -0.511844}, {   0.003312,    0.000024,    0.005791}, {   0.006012,    0.003417,    0.003796}, {   0.006523,    0.007592,    0.000647}, { -11.010394,   -5.431042,  -12.736216},
			{   0.008590,   -0.444362,   -0.465359}, {  54.435836,    0.007263,    0.314653}, {   0.187122,    1.885851,    8.756789}, {   3.091197,    4.805646,  -25.062217}, {   0.770874,    0.436080,  -54.257759}, {  -0.613361,    6.038695,  -65.021926}, {   0.007019,    1.317016,  -52.991821}, {   0.004974,   -2.269336,  -42.539474},
			{   0.370588,   25.630645,  -43.821201}, {   0.005187,    5.937271,  -38.723266}, {   0.002044,    3.927654,  -35.785003}, {   0.007385,    3.718018,  -32.642555}, {   0.007660,    7.832413,  -81.142921}, {   2.554047,   -2.334839,    1.015676}, {  -1.388092,    0.184691,    0.001514}, {  -0.132415,    0.157592,    0.000719},
			{   0.000762,   -0.396117,    0.003412}, {  -0.082275,   -0.059691,    0.003146}, {   0.093933,   -0.116576,    0.002154}, {  -1.490630,   -1.502990,    0.006581}, {   1.846084,    0.608336,    0.004672}, {  -0.518585,    0.395386,    0.006484}, {   0.791369,   -0.653442,    0.006008}, {  -0.534045,   -0.292236,    0.000792},
			{  -6.756401,   -2.256774,  -18.628608}, {   3.842508,   -0.365568,    0.051288}, {   0.597236,   -3.868019,   -0.541279}, {  -5.577373,   -0.727518,   -1.476274}, {   7.894823,   -0.289813,   -1.779165}, { -16.192422,   -0.377124,   -1.867197}, {  -0.263137,   -6.625267,   -0.491631}, {  43.178024,   -4.483767,   -1.913956},
			{   0.000079,    0.003722,    0.007505}, {  -0.228565,    0.638889,    0.007042}, {   0.007232,    0.005859,    0.257907}, {   0.001430,    0.001464,    0.000486}, {   1.046043,    0.004333,    0.000714}, {   0.004546,    0.000548,    0.005388}, {   0.006804,    0.005249,    0.007666}, {   0.000731,    0.001952,    0.007156},
			{   0.006302,    0.000670,    0.246802}, {   0.000411,    0.003783,    0.003482}, {   0.005034,    0.004333,    0.433964}, {  -1.700438,    0.797981,    0.755307}, {   0.006256,    0.005371,    0.000261}, {   0.003417,   -2.587554,   -0.056187}, {   0.004821,    0.095275,    0.280909}, {   0.000762,    0.001708,    0.003592},
			{   0.003325,  -51.689270,   -4.001726}, { -19.863433,    0.207885,   -4.363413}, {   0.003661,  -14.088195,   -1.584445}, {  -2.232063,    0.260924,   -5.989709}, {  -0.641815,    0.006713,    1.186187}, {   0.007720,    0.005187,    0.000691}, {   0.002715,   -0.230590,   -1.294564}, {   0.006469,    0.001952,    0.000615},
			{   0.005493,    0.002074,    0.006506}, {   0.000640,    0.000121,    0.005574}, {   5.416394,   -1.888914,    1.139183}, {   3.077332,    1.640076,    5.668422}, {  -1.675040,   -3.114718,    3.692830}, {  -1.675040,   -3.114718,    3.692830}, {   3.077332,    1.640076,    5.668422}, {   6.150531,    0.793031,    1.531980},
			{   6.150531,    0.793031,    1.531980}, {  -2.580138,    0.006653,    0.000625}, {  -0.006362,    0.006347,    0.409121}, {   0.001891,    0.001089,   -0.154128}, {   0.004058,   -0.000060,    0.003548}, {  16.587812,   23.313438,    4.096899}, {   0.004836,    0.002318,    0.003253}, {   0.005202,    0.002990,    0.005384},
			{  -2.099509,    0.006287,    0.006167}, {   0.005462,    0.002685,    0.004445}, {   0.006744,   -0.120819,    0.004703}, {   0.000000,    0.004761,    0.005725}, {   0.001357,    0.000915,    0.004313}, {   0.000564,    0.006591,    0.006173}, {  -8.795745,    5.069152,    0.003643}, {   0.005324,    0.001571,    0.509200},
			{   0.000350,    0.000304,    0.003035}, {   0.000046,    0.004867,    0.004131}, {   0.005489,    0.004761,    0.006676}, {   0.008297,    0.001403,    0.004598}, {   0.003548,    0.000243,    0.002158}, {   0.000251,    0.000915,    0.003824}, {   0.006186,    0.097228,    0.338063}, {   0.006035,    0.001891,    0.002644},
			{   0.582794,    0.827148,    0.030239}, {   0.006256,    0.005371,    0.000261}, {   0.000915,    0.000425,    0.008066}, {  -2.290461,    0.760033,    3.569350}, {   0.014386,   -0.011646,    6.228741}, {  -0.916387,   -0.994553,    2.917105}, {   0.013821,    0.010800,    0.377903}, {   0.013821,    0.010800,    0.377903},
			{   0.009626,    0.006337,    0.377768}, {   0.009626,    0.006337,    0.377768}, {   0.149473,    0.003650,   -0.433984}, {  -1.366050,   -1.660385,    3.834630}, {  -1.368350,   -1.653295,    3.834630}, {  -1.368350,   -1.653295,    3.834630}, {   1.304196,   11.637392,   -0.068267}, {  -0.602846,   -2.249701,    1.993710},
			{   2.485357,    6.521420,    1.964995}, {   1.257544,   -0.255059,  -18.088172}, {   1.257544,   -0.255059,  -18.088172}, {  -0.057831,    0.031210,  -18.379264}, {  -7.708771,   -1.632446,    2.687267}, {   5.448394,    5.447362,   40.064666}, {   5.448394,    5.447362,   40.064666}, {  -0.734494,  -13.495601,    2.450431},
			{   5.883864,   -4.384301,    2.713606}, {  -4.255897,   -0.295228,    4.001819}, {  -1.888070,    9.282629,    4.680062}, { -19.990264,  -60.004981,    2.832751}, {   0.003245,    0.003973,    0.003103}, { -15.965033,   -2.227963,   -0.028351}, {   1.930997,   12.863316,   -0.037815}, {   4.232667,   -3.015278,    0.103623},
			{   0.003953,   -1.539116,    0.966150}, {   0.003020,    0.004455,    0.006531}, {   6.078671,    0.368770,    3.044264}, {  -0.006314,    0.000276,    0.001968}, {  -1.350147,    0.041423,   -0.146139}, {  -0.042984,    0.037969,    0.000807}, {  -0.113351,    0.020460,    0.000807}, {   0.063175,   -0.109279,    0.026962},
			{   1.345832,   -0.237268,    0.181167}, {   0.042146,   -0.012024,    0.022802}, {   0.024297,    0.017090,    0.007319}, {  -0.015603,    0.008073,   -0.003887}, {  -0.152603,   -0.080343,    0.008620}, {  -0.004234,   -0.005115,    0.006428}, {  -0.011491,    0.652736,    0.702777}, {   7.162332,   -2.916102,    1.746251},
			{   0.608542,   -0.026949,   -0.023816}, {   0.018014,    1.384495,   -0.025214}, {  -0.237966,   -4.950372,   -0.679005}, {  -1.314738,   -1.920840,   -0.849027}, {   1.194260,   -0.357910,   -0.026221}, {   4.199615,    0.412135,   -0.006938}, {   5.074578,   -3.076138,    1.145902}, {  -1.859249,   -0.570402,  -18.636266},
			{  -8.360624,    2.140331,    0.695416}, {  -0.958545,   -0.024057,    0.941488}, {   1.223570,    2.730245,   -0.972130}, {  -2.469043,    1.172132,    0.143190}, {  -2.054702,   -1.651064,   -1.004400}, {   1.649108,   -2.740942,    1.191956}, {  -3.923459,    0.736856,   -0.846786}, {  -2.451729,    1.995780,    0.018241},
			{  -0.833878,    0.780447,    0.639074}, {  -1.560328,    2.897337,    0.508638}, {  -4.355503,   -1.469154,    1.144227}, {  -9.783297,   -2.998595,   -1.693490}, {  10.871944,   10.623701,    0.335786}, {  -0.085184,   -1.402928,    3.479365}, {   1.399893,   -3.842344,    0.297084}, {  -1.955489,   -2.218684,   -0.091273},
			{  -0.000109,    1.369269,   -0.150405}, {  -3.633161,    0.000511,    2.682579}, {   3.339184,   -2.789135,    5.325562}, {   1.553024,   -1.483657,    1.278277}, {  29.553915,   20.718559,    1.404222}, {   4.550202,   -8.581256,    0.893768}, { -14.422150,   11.909948,    1.080253}, {  25.027612,  -29.656938,    0.569853},
			{   1.300760,   11.632034,   -0.063400}, {   1.300760,   11.632034,   -0.063400}, {  -0.002120,    3.451941,    1.965070}, {  -4.581707,  -15.546012,    5.047529}, {   4.622992,   -1.770334,    2.214551}, {  -5.656827,   -0.922383,    2.760226}, {   1.954048,   -6.372166,    0.306486}, {   0.001433,    0.005005,    0.007362},
			{   0.616181,    1.116528,    1.397549}, {   0.004036,    0.003860,   -0.481332}, {   0.616181,    1.116528,    1.397549}, {  -0.281327,   -0.293945,   -0.020515}, { -17.612071,   -2.833076,    0.017304}, { -20.804656,    1.250141,    0.142985}, { -20.804656,    1.250141,    0.142985}, { -17.612071,   -2.833076,    0.017304},
			{  -1.829368,   -0.295408,   -0.492096}, {   0.006068,   -0.004503,    0.002200}, {   1.004137,   -1.866500,    1.487216}, {   0.001403,    0.005737,    0.003340}, { -81.161575,  -36.750095,   43.935478}, {  -0.766318,    5.338080,  -26.653213}, {   9.909580,   -7.334061,  -34.741737}, {  -0.766318,    5.338080,  -26.653213},
			{   9.813789,   -2.598320,    1.183735}, {   9.909580,   -7.334061,  -34.741737}, {   1.553024,   -1.483657,    1.278277}, {   1.301810,   -4.707408,    4.489830}, {  -4.205256,    4.245251,    3.259092}, { -81.161575,  -36.750095,   43.935478}, {  -9.304506,   13.001684,   16.936496}, {  -1.096230,  -23.429763,   12.470894},
			{   0.979036,  -19.765518,    4.307857}, {  17.810977,  -17.440767,    1.758806}, {  15.044090,  -17.840026,    0.273847}, {  -4.581707,  -15.546012,    5.047529}, {   8.989750,   15.974025,   12.328653}, {   8.596437,   -3.184737,   10.816139}, { -11.583152,    0.869243,    1.753026}, {   0.457502,   11.595638,    1.756260},
			{  -2.794616,    0.315153,   17.963611}, {   8.644536,   -5.647317,   10.814190}, {  -5.634346,  -11.033140,    1.754418}, {  -5.534319,    7.067961,   10.116448}, {   9.679113,   13.444558,    0.950379}, {  -7.395365,    7.072030,   10.816422}, {   7.542127,   -0.245942,   10.814933}, { -11.934852,    3.831020,    2.129601},
			{   7.539547,   -0.252656,   12.525075}, {  -4.900095,   -3.846748,    8.621866}, {  -4.375712,   -8.678245,    6.999190}, {  -3.581140,   11.565811,    1.751207}, {   3.437508,   -7.112840,   12.853281}, {  12.248910,    6.841669,   20.257564}, {   0.003408,    0.004279,    0.002492}, {  -2.651793,  -16.645938,    3.401634},
			{ -11.010394,   -5.431042,  -12.736216}, {  -0.016459,    0.000792,   -0.621985}, {   0.002105,    0.006041,    0.006240}, {  -1.511173,   -0.425925,    0.851379}, {  -0.006016,    0.006914,    0.000319}, {   0.005243,    0.000679,    0.005958}, {   0.005065,   -2.828490,    0.001709}, {  50.882369,    8.035582,   -2.394474},
			{   3.173182,   -7.863372,    0.004937}, {   5.037889,    1.238157,    0.001076}, {  -2.159058,   -8.814889,   -1.899729}, {  -0.818848,  -10.108686,   -1.596601}, {   2.467766,    3.307053,   -3.153680}, {   0.000243,    0.006560,    0.004590}, {   0.004982,    0.001854,    0.002495}, {   0.004416,    0.000808,    0.004267},
			{   0.000411,    0.004135,    0.002615}, {   0.000899,    0.007445,    0.005872}, {   0.000762,    0.439406,   11.075440}, {  -4.486632,   32.452087,    2.344019}, {   0.801757,    0.006347,    0.005989}, {   0.004852,    0.000243,    0.006167}, {   0.003844,    0.003295,    0.004964}, {  13.266794,    8.330112,   -0.555396},
			{   5.416394,   -1.888914,    1.139183}, {   0.001800,    0.004753,    0.004867}, {   0.001115,    0.005512,    0.001069}, {   1.465505,   -0.015948,    1.472177}, {   0.006775,    0.000853,    0.004561}, {   0.004279,   -0.000121,    0.032464}, {   0.002910,    0.007093,    0.003029}, {   0.003992,   -0.000818,    0.006554},
			{   0.000617,    0.001098,    0.001340}, {  -6.003555,   -7.472630,    3.395023}, {  -0.743601,   -0.363216,    2.479990}, {   0.725887,    2.517003,    2.709431}, {   8.913574,    0.043457,    2.782736}, {   1.408859,   -0.061767,    2.857995}, { -13.115898,    0.004346,    0.062849}, {   9.754689,    1.600234,    0.323541},
			{   9.754689,    1.600234,    0.323541}, {   3.285270,   -1.882609,    2.115400}, {   3.780443,    1.235712,   -0.258293}, {   0.004689,    0.011257,    0.013047}, {   0.004689,    0.011257,    0.013047}, {   0.001134,    0.001255,    0.004600}, { -12.067779,    0.468304,    0.606711}, {  -0.006701,   -0.001248,    0.004600},
			{   0.142517,    1.365309,    8.272628}, {   0.001937,   -1.522058,    4.996586}, {  -0.247639,   -0.005559,    3.659003}, {   0.009201,    0.002327,   -0.397642}, {   0.004364,    0.007942,   -0.397641}, {   0.187122,    1.885851,    8.756789}, {  -0.206437,    0.000487,    0.006850}, {   0.002646,    0.007656,    0.000852},
			{   0.000942,    0.001616,    0.002706}, { -23.643297,  -15.804864,  -10.927840}, {   2.051915,   -7.253084,   -8.383505}, {   4.068321,   13.961153,  -12.505064}, {  58.391433,   -2.892669,  -10.893760}, {  12.590127,  -45.650554,   -7.466238}, { -69.634880,   10.267330,   -6.851337}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.013671,    0.007079,   12.958788}, {  -0.003616,   -0.000655,   17.551803}, {  -0.008526,    0.004627,   -0.078163}, {   0.001041,    0.001525,   33.659572}, {   1.606346,    9.514892,    7.104602}, {  -3.956779,    1.488023,    1.545987}, {  -0.133732,   -1.123188,   -1.277762}, {   0.001342,    0.006103,   12.954340},
			{  -3.096580,    1.171025,    1.133857}, {   0.869513,   -1.054499,    2.828289}, {   0.884181,   -1.042402,    2.828289}, {   0.875527,   -1.054226,    2.828289}, {   0.003132,    4.641925,    0.635616}, {   0.006591,    0.002440,    0.000534}, { -17.621948,   29.384643,    0.005524}, {   0.004883,    0.001464,    0.012660},
			{   0.002562,    0.003417,    0.003657}, {   0.000976,    0.000609,    0.004112}, { -26.282226,  -21.224121,    0.001821}, {   0.003462,   -0.000935,    0.001841}, {  -0.236356,   -0.006062,    0.004350}, {   0.005615,    0.002685,    0.000534}, {   0.004395,    0.002196,    0.014720}, {   0.005005,    0.002929,    0.006366},
			{   0.001952,    0.000121,    0.002083}, {   9.691772,    9.417927,    1.755162}, {   8.607976,   -3.283921,   10.815887}, {  11.399393,    7.797690,   -4.100440}, {   0.006521,    0.005615,    0.003412}, {   7.322872,    2.832694,    9.513863}, {   8.606573,   -3.279373,    9.136798}, {   6.628245,   -7.157312,    5.440715},
			{  -0.068760,    6.096747,    7.777402}, {   0.742251,    2.724351,    3.501868}, {   6.501973,    5.615025,   10.811157}, { -23.249608,   38.389080,   10.503444}, {  -0.065871,   -0.011667,    1.739053}, {   0.002036,    0.001582,   -0.891474}, {   0.736811,    2.520246,    2.707108}, {  -0.069160,   -0.043184,    4.415493},
			{   0.002348,   -4.286726,    4.001770}, {   0.010017,    0.009762,    1.778980}, {   0.007143,    0.425184,    4.888703}, {   0.007414,    0.000488,    8.178936}, {   0.016456,    0.005485,    1.778980}, {   0.003323,   -0.000590,    0.005543}, {   0.000052,    0.000092,    0.004761}, {   0.005249,   -0.494796,   -1.273100},
			{   0.004697,    0.004974,    0.000846}, {  -0.224103,    0.004563,   11.510574}, {  -0.223855,    0.016684,   11.510574}, {  -0.212079,    0.022834,   11.510574}, {   0.003202,    0.012764,    4.597960}, {   0.010874,    0.008495,    4.597315}, {   0.005919,    0.017209,    4.598872}, {  -0.002341,    0.015465,    0.024032},
			{   5.907608,   21.783676,    0.387614}, {  -0.054843,   -3.765912,    1.518386}, {   0.015612,    0.019917,    4.801754}, {  -0.007722,   -3.254009,    1.512362}, {   0.022771,    3.282046,    1.514474}, {  -0.013752,   -0.009513,    5.308407}, {   2.350943,   -1.566504,    0.001115}, {  -0.059852,   -0.032419,    3.780807},
			{  -0.057238,    2.165888,    2.040601}, {  -0.118647,   -0.816384,   -1.441308}, {   1.991139,    0.494011,    2.905281}, {  -3.417633,   -4.737389,    2.081772}, {   0.007000,   -0.002515,   -0.144906}, {   0.003609,    0.008275,    0.006740}, {  -0.000945,   -0.007019,    0.008937}, {   1.047646,   -1.885892,   -2.320604},
			{   8.508424,   -0.425972,    0.014963}, {  -3.838639,  -10.863807,   -0.017216}, {   0.866986,   -1.057461,    2.830151}, {  -8.206024,  -11.516025,    3.377289}, {  -9.086059,  -12.698689,    2.019915}, {   0.001067,    0.005553,    0.005526}, { -20.186340,   23.775146,   -4.359179}, {  23.273902,   -5.334624,    3.282506},
			{  23.420330,  -18.967884,    5.724750}, {  -2.874969,    6.286986,   -6.870772}, {  52.211795,  -64.108581,    2.578151}, {   0.006004,    0.005218,    0.004002}, {  16.914566,   -0.292542,    7.421456}, {   8.318855,   28.488288,   -5.139282}, { -18.743289,    5.646987,   12.943164}, {  -4.845019,  -20.593261,   15.725687},
			{  11.451904,   28.841781,   -7.514762}, {  48.204757,    9.822456,  -22.322444}, { -10.012100,  -45.311798,   13.964752}, {  14.613189,   19.475288,  -12.630729}, {  -3.078948,  -10.859558,   30.935623}, { -15.774169,   -8.574645,  -24.810382}, {   2.022247,  -15.823175,  -20.887535}, {  -1.603451,   19.237548,   -1.781563},
			{  12.076248,    5.772216,  -16.832038}, { -11.703468,    8.018081,   27.894081}, {   5.179199,   15.681762,    2.846085}, { -19.327819,  -14.741516,   22.468078}, {  21.300437,   -1.479176,  -19.574560}, {  20.633184,   14.295490,   -6.878192}, {  -0.339890,   14.429168,    8.878656}, {  16.671394,    3.293297,    5.427700},
			{   2.398330,    8.577271,    0.717319}, {  -4.583714,  -21.365966,    2.902620}, { -18.516685,   10.361419,   -5.889080}, { -21.256969,   21.366180,    8.621305}, {  81.298339,   36.793365,    8.915901}, { -35.833599,    6.737854,   12.654044}, {   0.071967,    2.391258,   -6.175734}, {   0.004860,    0.004848,    0.001903},
			{   1.403063,    1.561545,   -5.050198}, {  11.902420,  -12.756458,  -16.084091}, {  18.110954,    7.895245,  -19.777706}, {   6.123542,   18.957489,  -18.512607}, {  15.771392,   15.779785,    5.100799}, { -37.476425,   28.634075,  -24.150014}, {  -1.313163,  -17.300342,  -22.345331}, {  -9.936377,  -14.620777,   10.990779},
			{  -0.126045,    0.182347,    0.004637}, {  -2.962841,   19.731201,  -13.674409}, { -33.283386,   32.239562,   -8.952177}, {  27.141639,  -34.276588,    0.224895}, {   0.003722,    0.003051,    0.002871}, { -23.431793,   19.785705,    3.116713}, { -13.746552,   -0.830871,   -8.900283}, {   0.005867,    0.000365,    0.005431},
			{ -29.745380,    8.617881,    8.320407}, {  -0.164330,   29.778747,   -7.442251}, {  12.228935,  -13.358413,   -5.810448}, {  17.417533,   -3.208735,  -15.345703}, { -13.085914,   25.829734,   10.621322}, {   2.350964,    6.522602,   -9.266433}, { -28.119255,    5.032538,   -1.941970}, {  15.380676,    9.797393,   15.025905},
			{  29.425903,   24.687576,  -11.029804}, {  18.960990,   -0.478469,   -8.742855}, {   4.388251,  -40.571792,   18.195224}, {  20.521308,   31.863880,  -12.468273}, { -13.351646,   28.681064,  -11.648296}, {   5.694781,   -2.455559,   -4.228401}, {  -0.959044,    8.191398,   -0.634847}, {  -1.623795,  -14.727001,  -11.282514},
			{  33.013183,  -13.448501,    7.412701}, { -23.918006,   22.039981,  -15.109012}, {   4.373886,   -0.981113,   -0.243331}, {   4.373886,   -0.981113,   -0.243331}, {  -1.745357,   10.917490,   -2.316936}, {  -1.745357,   10.917490,   -2.316936}, {  27.690055,   -4.524670,    0.214806}, {  27.690055,   -4.524670,    0.214806},
			{ -26.073768,    8.100393,    7.066347}, { -26.073768,    8.100393,    7.066347}, { -18.477203,  -10.535247,    0.613938}, { -18.477203,  -10.535247,    0.613938}, {  -8.360355,   -0.439788,    0.245831}, {  -8.360355,   -0.439788,    0.245831}, {   7.082263,   11.191101,    0.595991}, {   7.082263,   11.191101,    0.595991},
			{   2.391566,  -20.302673,   -0.017046}, {   2.391566,  -20.302673,   -0.017046}, {  18.387523,   12.713680,   -0.540493}, {  18.387523,   12.713680,   -0.540493}, {  -7.834162,   -4.696175,   -3.977596}, {  -7.834162,   -4.696175,   -3.977596}, {  -2.263647,  -10.407394,    0.917576}, {  -2.263647,  -10.407394,    0.917576},
			{   1.478497,  -23.600864,    3.049299}, {   1.478497,  -23.600864,    3.049299}, {  11.194901,   15.618492,   -0.762629}, {  11.194901,   15.618492,   -0.762629}, {   5.188827,   16.189392,   -0.768997}, {   5.188827,   16.189392,   -0.768997}, { -11.880414,   -5.278998,   -0.537216}, { -11.880414,   -5.278998,   -0.537216},
			{   3.930877,  -36.021629,   -2.502037}, {   3.930877,  -36.021629,   -2.502037}, {  -4.686164,   -1.584648,    3.150945}, {  -4.686164,   -1.584648,    3.150945}, {   3.395761,  -13.628219,    0.604848}, {   3.395761,  -13.628219,    0.604848}, {   5.239821,   -1.563477,    4.219874}, {   5.239821,   -1.563477,    4.219874},
			{  -0.940918,   -0.440575,   -0.243183}, {  -0.940918,   -0.440575,   -0.243183}, {  -7.600018,   -3.826416,    0.108314}, {  -7.600018,   -3.826416,    0.108314}, {   1.911334,   -0.070992,    0.734925}, {   1.911334,   -0.070992,    0.734925}, { -11.572322,    4.274956,   -1.385153}, { -11.572322,    4.274956,   -1.385153},
			{  -3.868968,   -3.857414,   -0.238858}, {  -3.868968,   -3.857414,   -0.238858}, {  -0.608520,    2.495655,    0.711673}, {  -0.608520,    2.495655,    0.711673}, {  -1.034724,    2.843363,   -0.399645}, {  -1.034724,    2.843363,   -0.399645}, {  -7.445542,    9.713520,   -0.940285}, {  -7.445542,    9.713520,   -0.940285},
			{   9.911811,  -10.003406,    0.587249}, {   9.911811,  -10.003406,    0.587249}, {   0.227354,   33.224685,   -5.265031}, {   0.227354,   33.224685,   -5.265031}, {   1.050446,    6.804327,   -0.075165}, {   1.050446,    6.804327,   -0.075165}, {   0.001067,    0.005553,    0.005526}, {   0.000713,    0.003203,    0.001508},
			{   0.557346,    2.499634,    1.739547}, {   0.557346,    2.499634,    1.739547}, {   0.169774,    3.555382,    0.528146}, {   0.169774,    3.555382,    0.528146}, {   3.158505,   -1.163810,   -0.665702}, {   3.158505,   -1.163810,   -0.665702}, {   3.627583,   -3.599117,   -0.214021}, {   3.627583,   -3.599117,   -0.214021},
			{   0.937384,    0.064429,   -0.220528}, {   0.937384,    0.064429,   -0.220528}, {  -5.606391,   16.615180,    1.038344}, {  -5.606391,   16.615180,    1.038344}, {  -5.072589,    8.121337,    1.481644}, {  -5.072589,    8.121337,    1.481644}, {  -3.127958,   -8.975648,   -1.546134}, {  -3.127958,   -8.975648,   -1.546134},
			{   3.993840,    7.503726,   -0.081000}, {   3.993840,    7.503726,   -0.081000}, {   3.840820,  -13.656604,    0.091559}, {   3.840820,  -13.656604,    0.091559}, {  -0.788094,   -8.127216,    0.848716}, {  -0.788094,   -8.127216,    0.848716}, {  -1.359220,   -5.597869,   -0.612793}, {  -1.359220,   -5.597869,   -0.612793},
			{   7.684600,    3.602210,   -0.306854}, {   7.684600,    3.602210,   -0.306854}, {  -0.990052,    0.601915,    0.000239}, {  -0.990052,    0.601915,    0.000239}, {  -4.884527,    0.439689,    0.371071}, {  -4.884527,    0.439689,    0.371071}, {  16.846199,    9.721034,    1.276767}, {  16.846199,    9.721034,    1.276767},
			{   0.832881,   -3.663217,   -0.423774}, {   0.832881,   -3.663217,   -0.423774}, {  -5.846625,    3.885859,   -0.217491}, {  -5.846625,    3.885859,   -0.217491}, {  -4.921524,   11.898292,   -0.900786}, {  -4.921524,   11.898292,   -0.900786}, {   1.924208,  -21.093963,    1.794047}, {   1.924208,  -21.093963,    1.794047},
			{   7.979682,  -19.851333,    1.503021}, {   7.979682,  -19.851333,    1.503021}, {  -4.512374,    4.790259,    0.454596}, {  -4.512374,    4.790259,    0.454596}, {   9.521575,   -7.023125,    1.336223}, {   9.521575,   -7.023125,    1.336223}, {  -8.156115,  -11.449741,    1.442909}, {  -8.156115,  -11.449741,    1.442909},
			{  -5.349084,   -6.529724,    0.345279}, {  -5.349084,   -6.529724,    0.345279}, {  -0.400020,   -0.369460,    0.010235}, {  -0.400020,   -0.369460,    0.010235}, {   6.385552,    9.798938,    0.163277}, {   6.385552,    9.798938,    0.163277}, {   6.950769,    0.043747,    0.322948}, {   6.950769,    0.043747,    0.322948},
			{  -6.838037,   14.656661,    4.996963}, {  -4.562277,    5.728507,   -1.073585}, {   1.427505,    8.433509,   -0.696747}, { -22.902305,    2.644813,   -0.034549}, { -22.902305,    2.644813,   -0.034549}, {   0.221771,   13.340538,   -1.505319}, {   0.221771,   13.340538,   -1.505319}, {  -3.290961,   -1.518970,    0.110256},
			{  -3.290961,   -1.518970,    0.110256}, {   2.972770,   -3.206924,   -1.193532}, {   2.972770,   -3.206924,   -1.193532}, { -15.864562,  -20.386707,   -0.324995}, { -15.864562,  -20.386707,   -0.324995}, {   9.251071,   -5.200841,    0.491791}, {   9.251071,   -5.200841,    0.491791}, {  21.864570,  -22.191593,    0.960613},
			{  21.864570,  -22.191593,    0.960613}, {   1.803836,   35.304939,    1.924252}, {   1.803836,   35.304939,    1.924252}, {  26.879386,   -1.039582,    5.609535}, {   0.689072,   -0.803462,   -0.508660}, {  -5.036277,    5.661437,   -1.447062}, {  -3.026432,    3.452681,   -0.122955}, {   3.278433,    7.039482,    0.975486},
			{   4.429915,   -3.749938,   -0.773090}, {   2.719921,   -7.767311,    1.329342}, {  -5.151699,    3.910175,   -0.461836}, {  -1.730923,    4.300631,   -0.305236}, {   0.375777,    2.244976,   -1.215069}, {  -0.005369,   -0.004269,    0.001173}, {   0.001759,    0.004860,    0.006752}, {  -0.001884,    0.005237,    0.001201},
			{   0.007323,    0.004883,   -0.198914}, {   0.007019,    0.004883,    0.089624}, {   0.003514,   -0.005320,   -0.548350}, {   8.527718,    3.983273,   -0.200166}, {  -0.386936,   -0.451664,    0.005760}, {  18.687568,   -2.004683,   -7.531499}, { -34.392303,   -8.718139,   10.070377}, {   1.177971,   -0.922302,    5.445718},
			{   1.177971,   -0.922302,    5.445718}, { -35.260971,    8.151023,   -2.748101}, { -35.260971,    8.151023,   -2.748101}, {   0.002392,    0.007271,    0.002168}, {   0.000713,    0.003203,    0.001508}, {   0.048944,    0.059870,   -9.612421}, {   0.005270,    0.006630,   -1.491837}, {  26.879386,   -1.039582,    5.609535},
			{   0.007019,    0.004883,    0.089624}, {   0.007323,    0.004883,   -0.198914}, {   0.375777,    2.244976,   -1.215069}, {  -1.730923,    4.300631,   -0.305236}, {  -5.151699,    3.910175,   -0.461836}, {   2.719921,   -7.767311,    1.329342}, {   4.429915,   -3.749938,   -0.773090}, {   3.278433,    7.039482,    0.975486},
			{  -3.026432,    3.452681,   -0.122955}, {  -5.036277,    5.661437,   -1.447062}, {   0.689072,   -0.803462,   -0.508660}, {  -0.001918,   -6.505650,    0.014139}, {   0.003833,   -0.003591,    5.009088}, {   0.003833,   -0.003591,    5.009088}, {  -6.838037,   14.656661,    4.996963}, {   6.890864,   31.968002,    0.269279},
			{   6.890864,   31.968002,    0.269279}, {  -2.667156,  -26.554542,   -0.003413}, {  -2.667156,  -26.554542,   -0.003413}, {   4.136463,  -18.974628,   -0.193192}, {   4.136463,  -18.974628,   -0.193192}, {  -4.562277,    5.728507,   -1.073585}, {   1.427505,    8.433509,   -0.696747}, {   1.539664,    4.052605,    1.494248},
			{  -0.386936,   -0.451664,    0.005760}, {   0.001041,    0.001525,   33.659572}, {   2.350943,   -1.566504,    0.001115}, { -17.621948,   29.384643,    0.005524}, {   0.005615,    0.002685,    0.000534}, {  -0.003616,   -0.000655,   17.551803}, {   0.006591,    0.002440,    0.000534}, {   0.002562,    0.003417,    0.003657},
			{   0.000976,    0.000609,    0.004112}, {   0.001952,    0.000121,    0.002083}, {   0.005005,    0.002929,    0.006366}, {   0.004883,    0.001464,    0.012660}, {   0.004395,    0.002196,    0.014720}, {   0.003132,    4.641925,    0.635616}, {   8.508424,   -0.425972,    0.014963}, {   1.539664,    4.052605,    1.494248},
			{   0.003202,    0.012764,    4.597960}, {  -0.013752,   -0.009513,    5.308407}, {   0.010874,    0.008495,    4.597315}, {   0.005919,    0.017209,    4.598872}, {   0.015612,    0.019917,    4.801754}, {   1.606346,    9.514892,    7.104602}, { -20.186340,   23.775146,   -4.359179}, {  23.273902,   -5.334624,    3.282506},
			{  23.420330,  -18.967884,    5.724750}, {   0.006004,    0.005218,    0.004002}, {  52.211795,  -64.108581,    2.578151}, { -10.012100,  -45.311798,   13.964752}, {  14.613189,   19.475288,  -12.630729}, {  -3.078948,  -10.859558,   30.935623}, {  12.076248,    5.772216,  -16.832038}, {  -1.603451,   19.237548,   -1.781563},
			{ -15.774169,   -8.574645,  -24.810382}, { -11.703468,    8.018081,   27.894081}, {   2.022247,  -15.823175,  -20.887535}, {  21.300437,   -1.479176,  -19.574560}, { -19.327819,  -14.741516,   22.468078}, {  20.633184,   14.295490,   -6.878192}, {   6.123542,   18.957489,  -18.512607}, {  -0.339890,   14.429168,    8.878656},
			{   5.179199,   15.681762,    2.846085}, {   2.398330,    8.577271,    0.717319}, {  -4.583714,  -21.365966,    2.902620}, { -18.516685,   10.361419,   -5.889080}, {  81.298339,   36.793365,    8.915901}, {  48.204757,    9.822456,  -22.322444}, { -21.256969,   21.366180,    8.621305}, { -35.833599,    6.737854,   12.654044},
			{  11.902420,  -12.756458,  -16.084091}, { -18.743289,    5.646987,   12.943164}, {  -4.845019,  -20.593261,   15.725687}, {  16.914566,   -0.292542,    7.421456}, {   8.318855,   28.488288,   -5.139282}, {  -2.874969,    6.286986,   -6.870772}, {  27.141639,  -34.276588,    0.224895}, {   0.006072,    0.002074,    0.006498},
			{   0.003722,    0.003051,    0.002871}, {   0.005867,    0.000365,    0.005431}, {  29.425903,   24.687576,  -11.029804}, {  18.960990,   -0.478469,   -8.742855}, {  11.451904,   28.841781,   -7.514762}, {  18.110954,    7.895245,  -19.777706}, {  20.521308,   31.863880,  -12.468273}, {   4.388251,  -40.571792,   18.195224},
			{  33.013183,  -13.448501,    7.412701}, { -13.351646,   28.681064,  -11.648296}, {   2.350964,    6.522602,   -9.266433}, { -13.085914,   25.829734,   10.621322}, {   5.694781,   -2.455559,   -4.228401}, {  -0.959044,    8.191398,   -0.634847}, {  -1.623795,  -14.727001,  -11.282514}, {  -8.206024,  -11.516025,    3.377289},
			{ -29.745380,    8.617881,    8.320407}, { -28.119255,    5.032538,   -1.941970}, { -23.918006,   22.039981,  -15.109012}, {  17.417533,   -3.208735,  -15.345703}, {  12.228935,  -13.358413,   -5.810448}, { -23.431793,   19.785705,    3.116713}, {  15.380676,    9.797393,   15.025905}, { -13.746552,   -0.830871,   -8.900283},
			{   1.403063,    1.561545,   -5.050198}, {  -0.164330,   29.778747,   -7.442251}, {  -2.962841,   19.731201,  -13.674409}, { -33.283386,   32.239562,   -8.952177}, {  -1.313163,  -17.300342,  -22.345331}, {  18.687568,   -2.004683,   -7.531499}, { -37.476425,   28.634075,  -24.150014}, { -34.392303,   -8.718139,   10.070377},
			{  -9.936377,  -14.620777,   10.990779}, {  15.771392,   15.779785,    5.100799}, {   0.007732,    0.001754,    0.001068}, {   0.005493,    0.000060,    0.001698}, {  -0.860213,    0.081511,   -1.273273}, {   0.000492,    0.005836,    0.002229}, {   0.003067,    0.002419,    0.002256}, {   0.004554,    0.002593,    0.004373},
			{   0.002006,    0.006790,    0.001471}, {   0.006699,    0.000335,    0.005793}, {   0.000213,    0.002898,    0.004619}, {   0.071967,    2.391258,   -6.175734}, {   0.003570,    0.000000,    0.003439}, {   0.005156,    0.002121,    0.007495}, {   0.000838,    0.004226,    0.006841}, {   0.003922,    0.005309,    0.006885},
			{   0.001647,    0.007187,    0.003145}, {   0.003098,    0.001708,    0.004013}, {   0.006469,    0.005264,    0.006306}, {  27.725013,   10.142955,   37.204982}, {   0.004250,    0.003291,    0.006432}, {   0.016456,    0.005485,    1.778980}, {   0.010017,    0.009762,    1.778980}, {   0.003323,   -0.000590,    0.005543},
			{   0.002001,   -0.000052,    6.833907}, {   8.527718,    3.983273,   -0.200166}, {   0.000838,    0.005173,    0.004069}, {   0.006401,    0.000876,    0.006591}, {   7.355583,  -10.454513,    0.000308}, {  43.516967,   -3.082214,   -2.981964}, {  -0.006027,   -0.005797,    0.007110}, {  26.138496,  -18.621070,  -11.398393},
			{   0.007042,    0.002196,    0.000479}, {   0.007447,   -0.004151,   -0.690756}, {   0.006027,    0.005034,    0.020457}, {   0.001571,    0.009201,    0.008495}, {   0.005142,    0.003067,    0.002264}, {   0.004180,    0.006835,    0.013674}, {  -0.008255,   -0.005034,    0.010890}, {  -0.014632,   -0.012889,    0.000689},
			{  -0.019240,    0.005363,    0.008965}, { -48.485580,   -0.012633,   14.979963}, {   0.017379,   -0.012093,    0.027901}, {   0.005080,    0.004447,    0.000594}, {   0.002315,    0.004463,    0.006781}, {   0.005439,    0.003031,    0.000501}, {   0.006027,   -0.003226,    0.017867}, {   0.006072,    0.002074,    0.006498},
			{   0.004323,    0.004848,    0.004004}, {  16.671394,    3.293297,    5.427700}, {  75.626419,  -51.978214,    4.091643}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, { -51.014976,   -0.118043,   -0.976893}, {   0.003986,    0.005038,    2.088890}, {   0.003173,    0.007323,    0.006258}, {   0.004838,    0.004271,    0.003965},
			{  -1.347290,   -7.728332,    5.561426}, {   0.593140,   -1.641356,   -3.731224}, {   0.005005,   54.455718,   -0.123946}, {   0.002440,  -10.835315,   -0.320071}, {   0.007141,    0.000945,   -0.001905}, {   0.001342,    0.002460,    0.002812}, {   0.001464,  -15.280517,    0.006018}, {   0.004149,    0.007507,    0.007772},
			{   0.004149,    0.007507,    0.007772}, {   0.997192,   -0.058410,    0.018556}, {   0.001586,    0.004608,   -0.086658}, {   0.076537,    0.003051,    0.004912}, {   9.432983,    0.026977,    0.084002}, { -12.216674,    2.978516,   -0.857065}, { -16.145507,   -4.022521,    7.244476}, { -10.236015,    2.078826,   -0.696878},
			{ -10.237548,    4.948424,    0.007278}, {  -0.008361,   -5.160095,    0.002540}, {   0.141112,   -0.042114,    0.000492}, {   0.001769,    0.002013,   -0.067896}, {  -0.144409,    9.426239,    0.502709}, {  -0.096190,  -17.218688,   10.827649}, {   0.004333,    0.001464,    0.006907}, {  -4.844165,   13.593444,   -0.159721},
			{   7.398314,   13.965270,    4.347255}, {  -0.005127,   -0.005731,   -0.046902}, { -23.319692,   18.740032,   16.809053}, {   0.782866,    0.003060,    0.001043}, {   0.003067,    0.006163,    0.007069}, {  -0.030148,    0.322497,    0.003879}, {   0.005024,    0.978174,   -0.053792}, {   0.000415,    0.000536,    0.082433},
			{   0.000456,    0.000722,    0.006386}, {   0.004315,    0.003714,   -0.176246}, {   0.087255,    0.000092,    0.001826}, {   0.006837,    5.525989,    0.006492}, {  -0.005104,    5.528532,    0.007728}, {   0.851571,    0.671863,    0.197484}, {   0.004242,    0.002288,    0.003767}, {  -0.005005,   -0.012333,   -0.281563},
			{  -0.175326,    0.002792,   -0.034922}, {   0.007689,    0.002786,    0.000323}, {  -1.591855,   -0.216124,   -7.613693}, {   0.013787,    0.001510,   -2.073508}, {   0.001322,    0.002990,   -0.000251}, {   0.001627,   -0.055004,   -0.003285}, {   0.001101,    0.003309,   -0.027684}, {   0.002983,    0.003582,   -0.086424},
			{  -0.000067,   -0.024125,    0.003451}, {   0.006014,    0.000086,   -0.038121}, {   0.000442,    0.002414,    0.000774}, {   1.175001,    2.591433,   10.946484}, {   0.007600,    0.007294,    0.001974}, {  -0.020269,    0.000846,    1.987627}, {  -0.020287,    0.000841,    1.988157}, {  -0.029109,    4.904946,    1.881546},
			{   0.004883,    0.002925,   -0.024857}, {   0.450210,    0.021356,   -1.413265}, { -11.659803,   -7.380128,    1.504914}, {   0.010432,    0.007408,   13.903480}, {  -0.217285,    0.028258,   -0.002004}, {  -1.196045,    0.006304,   -0.047058}, {   0.003173,    0.004513,    0.004660}, {   0.005737,    0.098007,    0.002369},
			{  -0.000121,    0.004883,    0.506783}, {  -0.000121,    0.004883,    0.506783}, {   0.005005,   54.455718,   -0.123946}, { -51.014976,   -0.118043,   -0.976893}, {   0.005737,    0.098007,    0.002369}, {   2.602003,    1.618798,    1.352341}, {  -0.139160,    0.237000,    1.523422}, {   0.003568,   -0.040231,    0.007449},
			{  -8.906494,   -8.661861,   -0.060848}, {   0.006800,    0.006391,   -0.045910}, {   0.003104,    0.003176,   -1.443779}, {   0.018939,    0.003176,    0.006041}, {   0.004883,    0.002925,   -0.024857}, {  -0.008361,   -5.160095,    0.002540}, {  -0.016746,   -0.008155,    0.003046}, {  -0.024536,   -0.002440,    0.007598},
			{   0.006014,    0.000086,   -0.038121}, {  42.215686,    0.913276,   -4.770487}, { -21.335147,   20.442459,   -1.244963}, {   0.013787,    0.001510,   -2.073508}, {  24.996284,  -55.304019,   -3.964768}, {   0.003905,    0.003517,    0.006812}, {   0.003905,    0.003517,    0.006812}, {   0.585525,    1.939766,    2.276021},
			{   0.720825,   -2.032654,   -0.552618}, {  -0.000067,   -0.024125,    0.003451}, {   0.005737,    0.004271,    0.002097}, {   0.003905,    0.000243,    0.005717}, {   0.003173,    0.000426,    0.006142}, {   0.006957,    0.004395,    0.000346}, {   0.001464,   -0.867592,    0.006597}, {  -0.048461,   -0.051176,    0.004077},
			{   0.005615,    0.002196,    0.006277}, {   0.031128,    0.001281,    0.505321}, {   0.001342,    0.005675,    0.003764}, {   0.073242,   -0.063781,    0.107951}, {   0.081055,   -0.060242,    0.096386}, {   0.002929,   -0.067809,    0.006670}, {   0.007201,   -0.047320,   -0.058805}, {   0.037719,    0.013183,   -0.002278},
			{   0.004883,   -1.189453,   -0.021800}, {  -0.109252,    0.003905,    0.006986}, {   0.004271,    0.002196,    0.001526}, {   0.002074,   -0.006653,    0.001971}, {   0.036635,   -0.012694,    0.085398}, {   0.055298,   -0.067809,    0.081170}, {  -0.594604,   -0.017211,   -0.083030}, {  13.466430,   -0.001342,   -0.057714},
			{  -0.247528,    0.024779,    0.025304}, {   0.001220,   -0.005493,   -0.081494}, {   0.003783,    0.002196,    0.000984}, {   5.303223,   -2.749022,    0.220749}, {   0.003051,    0.001708,    0.184913}, {   0.103148,   -0.044372,    0.059395}, {   0.000853,    0.004699,    0.000784}, {   0.056396,   -0.047912,    0.023540},
			{  -0.062987,   -0.671630,    0.000959}, {   0.001464,    0.001342,    0.001974}, {  -0.000609,   -0.014647,    0.000097}, {  -0.084716,    0.007629,    0.000581}, {  -0.005615,    0.005005,    0.006926}, {   0.004517,    0.001403,    0.000671}, {  -0.003051,    0.002440,    0.001016}, {  -0.000976,    0.011353,   -0.119067},
			{   0.006957,    0.001342,   -0.067562}, {  -0.013860,    0.041747,   -0.014263}, {   0.002562,    0.003661,    0.006149}, {   0.004149,    0.002074,    0.002418}, {   0.003783,    0.005797,    0.005063}, {   0.000976,    0.002196,    0.003858}, {  -0.063965,    0.006469,    0.006812}, {   0.000731,    0.015258,    0.004867},
			{   0.000853,    0.003967,   -0.064273}, {   0.005859,    0.002685,    0.006603}, {   0.005859,    0.006775,    0.396490}, {   0.006347,    0.002318,    0.000816}, {   0.201171,   -0.962463,    0.003914}, {   0.164388,    0.006591,    0.680230}, {   0.026977,    0.059967,    0.106564}, {   0.002807,    0.000609,    0.005144},
			{   0.002440,    0.006591,    0.001337}, {   0.036267,   -0.039489,    0.071388}, {   0.081177,   -0.012145,    0.108479}, {   0.002929,    0.002746,    0.006517}, {   0.100341,   -0.054076,    0.068948}, {   0.004883,    0.007323,    0.004033}, {   0.001952,    0.920044,    0.004701}, {  -9.291748,    0.017211,   -0.741824},
			{  -0.000121,    0.009583,   -0.683556}, {  -0.001952,    0.046204,   -0.099243}, {   0.003051,    0.006469,    0.008851}, {   0.036621,   -0.021118,    0.077367}, {   0.000121,    0.004211,    0.005297}, {   0.003661,    0.026854,    0.006167}, {   0.020630,   -0.087218,    0.014640}, {   0.055420,   -0.064087,    0.055445},
			{   0.001952,    0.005431,    0.004131}, {   0.006469,    0.005859,    0.000041}, {   0.005005,    0.006287,    0.007122}, {   0.001586,    0.617736,    1.282299}, {   0.007445,    0.001952,   -0.448002}, {   0.003051,    0.004271,   -0.358992}, {   0.005371,    0.005431,   -1.097434}, {   0.002929,    0.002501,    0.004377},
			{   0.006225,    0.000609,    0.000668}, {   0.002685,    0.005797,   -0.020897}, {   0.006225,    0.000426,    0.001300}, {  -3.293212,    0.004517,   -2.036782}, {   1.226318,    0.000609,   -2.892658}, {   0.001952,    0.011353,    0.004513}, {   0.002318,    0.007201,    0.004230}, {   1.050171,   -0.134155,    0.003015},
			{   0.572510,   -0.086852,    0.057039}, {   0.000487,    0.007263,    0.003684}, {   0.006469,    0.005371,    0.001913}, {   0.033569,   -0.035461,    0.032242}, {   0.042847,   -0.009643,    3.575213}, {   0.002562,    0.006347,    0.000273}, {  39.131904,   25.575134,    0.006310}, {   0.007079,    0.006713,    0.000913},
			{   0.958802,    0.002685,    0.001334}, {  -0.087062,    0.000915,    0.002245}, {   0.967528,   -8.656311,    8.931592}, {   0.003783,    0.002929,    0.001333}, {   0.000121,    0.006775,    0.004230}, {  -0.028564,    0.003600,    4.241524}, {   0.002685,    0.005005,    0.001392}, {   8.915344,  -10.539279,   -0.448464},
			{  10.001342,    0.000000,   -4.070621}, {  -0.153476,    4.654030,    0.508383}, {   0.000190,    0.001098,    0.000226}, {  -0.191062,   -0.363027,    1.257153}, {  -0.793982,   -0.520779,   -0.126255}, {   0.081177,   -0.012145,    0.108479}, {   0.000731,    0.015258,    0.004867}, {  -0.028564,    0.003600,    4.241524},
			{   0.036621,   -0.021118,    0.077367}, {  -0.063965,    0.006469,    0.006812}, {  -9.291748,    0.017211,   -0.741824}, {   0.002318,    0.007201,    0.004230}, {   0.000853,    0.004699,    0.000784}, {   0.958802,    0.002685,    0.001334}, {  10.001342,    0.000000,   -4.070621}, {   0.001952,    0.920044,    0.004701},
			{   0.031128,    0.001281,    0.505321}, {   0.002074,   -0.006653,    0.001971}, {   0.004271,    0.002196,    0.001526}, {   0.003905,    0.000243,    0.005717}, {   0.036635,   -0.012694,    0.085398}, {   0.001464,   -0.867592,    0.006597}, {   0.007201,   -0.047320,   -0.058805}, {   0.002929,   -0.067809,    0.006670},
			{   0.033569,   -0.035461,    0.032242}, {   0.042847,   -0.009643,    3.575213}, {   0.003783,    0.005797,    0.005063}, {  -0.013860,    0.041747,   -0.014263}, {   0.007689,    0.002786,    0.000323}, {  -0.793982,   -0.520779,   -0.126255}, {  -0.009154,   -0.061767,   -4.154527}, {   1.226318,    0.000609,   -2.892658},
			{   0.164388,    0.006591,    0.680230}, {   1.050171,   -0.134155,    0.003015}, {  -0.144409,    9.426239,    0.502709}, {   0.001952,    0.005431,    0.004131}, {  -1.591855,   -0.216124,   -7.613693}, {   0.010432,    0.007408,   13.903480}, {   0.997192,   -0.058410,    0.018556}, {   0.004838,    0.004271,    0.003965},
			{   0.141112,   -0.042114,    0.000492}, {   0.007141,    0.000945,   -0.001905}, {   0.004315,    0.003714,   -0.176246}, {   0.002440,  -10.835315,   -0.320071}, {   1.175001,    2.591433,   10.946484}, {   0.003783,    0.002929,    0.001333}, {   0.002562,    0.006347,    0.000273}, {   0.000121,    0.004211,    0.005297},
			{   5.303223,   -2.749022,    0.220749}, {  -0.016746,   -0.008155,    0.003046}, {   0.013403,    0.032069,    1.856202}, {   0.000442,    0.002414,    0.000774}, {   0.450210,    0.021356,   -1.413265}, {  -0.029109,    4.904946,    1.881546}, {   0.851571,    0.671863,    0.197484}, {   0.002983,    0.003582,   -0.086424},
			{   0.001627,   -0.055004,   -0.003285}, {  13.466430,   -0.001342,   -0.057714}, {   0.005024,    0.978174,   -0.053792}, {   0.001322,    0.002990,   -0.000251}, { -10.237548,    4.948424,    0.007278}, { -10.236015,    2.078826,   -0.696878}, {   0.076537,    0.003051,    0.004912}, {   0.005737,    0.004271,    0.002097},
			{ -12.216674,    2.978516,   -0.857065}, {   0.006800,    0.006391,   -0.045910}, {  -8.906494,   -8.661861,   -0.060848}, {   0.000456,    0.000722,    0.006386}, {   0.003986,    0.005038,    2.088890}, {   0.001769,    0.002013,   -0.067896}, {  -0.005127,   -0.005731,   -0.046902}, {   0.782866,    0.003060,    0.001043},
			{  -0.153476,    4.654030,    0.508383}, {  -0.139160,    0.237000,    1.523422}, {  -0.191062,   -0.363027,    1.257153}, {   0.000190,    0.001098,    0.000226}, {   0.001101,    0.003309,   -0.027684}, {   0.593140,   -1.641356,   -3.731224}, {   0.006957,    0.001342,   -0.067562}, {  -0.000609,   -0.014647,    0.000097},
			{  -0.084716,    0.007629,    0.000581}, {   0.004517,    0.001403,    0.000671}, {  -0.003051,    0.002440,    0.001016}, {  -0.005615,    0.005005,    0.006926}, {   0.002807,    0.000609,    0.005144}, {   0.005859,    0.006775,    0.396490}, {   0.002562,    0.003661,    0.006149}, {   0.004149,    0.002074,    0.002418},
			{   0.000121,    0.006775,    0.004230}, {  -0.000976,    0.011353,   -0.119067}, {   0.005371,    0.005431,   -1.097434}, {   0.002685,    0.005797,   -0.020897}, {   0.002929,    0.002501,    0.004377}, {   0.006225,    0.000609,    0.000668}, {   0.006347,    0.002318,    0.000816}, {   0.002440,    0.006591,    0.001337},
			{   0.002929,    0.002746,    0.006517}, {   0.055420,   -0.064087,    0.055445}, {   0.026977,    0.059967,    0.106564}, {   0.100341,   -0.054076,    0.068948}, {   0.001586,    0.617736,    1.282299}, {   0.005005,    0.006287,    0.007122}, {   0.020630,   -0.087218,    0.014640}, {   0.003661,    0.026854,    0.006167},
			{   0.006225,    0.000426,    0.001300}, {   0.003051,    0.006469,    0.008851}, {   0.004883,   -1.189453,   -0.021800}, {  15.714548,  -31.778551,   -5.104856}, {  15.714548,  -31.778551,   -5.104856}, {   0.002512,    0.002738,    0.004327}, {   0.001708,    0.022151,    0.007100}, {   0.001708,    0.022151,    0.007100},
			{   0.000243,   -0.001807,    0.006240}, {   0.000243,   -0.001807,    0.006240}, {   0.037719,    0.013183,   -0.002278}, {  -3.293212,    0.004517,   -2.036782}, {  -0.004883,   10.822143,   -1.157775}, {   0.001342,    0.005675,    0.003764}, {   0.073242,   -0.063781,    0.107951}, {   0.081055,   -0.060242,    0.096386},
			{  -0.109252,    0.003905,    0.006986}, {   0.036267,   -0.039489,    0.071388}, {   0.201171,   -0.962463,    0.003914}, {   0.005859,    0.002685,    0.006603}, {   0.000976,    0.002196,    0.003858}, {   0.000853,    0.003967,   -0.064273}, {   0.007079,    0.006713,    0.000913}, {   0.006469,    0.005371,    0.001913},
			{  -0.091553,    0.001159,    0.000000}, {   0.001464,    0.001342,    0.001974}, {   0.056396,   -0.047912,    0.023540}, {  -0.062987,   -0.671630,    0.000959}, {   0.002440,    0.003783,    0.005466}, {   0.004883,    0.147277,    0.001649}, {   0.004883,    0.147277,    0.001649}, {   0.003417,    0.004699,    0.005851},
			{   0.005615,    0.002196,    0.006277}, {  -0.048461,   -0.051176,    0.004077}, {   0.003173,    0.000426,    0.006142}, {  -0.001952,    0.046204,   -0.099243}, {  -0.000121,    0.009583,   -0.683556}, {   0.006957,    0.004395,    0.000346}, {   0.103148,   -0.044372,    0.059395}, {  -0.007366,    0.144143,    0.007484},
			{   8.915344,  -10.539279,   -0.448464}, {  -0.007366,    0.144143,    0.007484}, {   0.003051,    0.001708,    0.184913}, {   0.149414,   -0.296875,   -1.417673}, {  -0.247528,    0.024779,    0.025304}, {   0.001220,   -0.005493,   -0.081494}, {   0.003783,    0.002196,    0.000984}, {  -0.087062,    0.000915,    0.002245},
			{  -6.681045,   -4.526443,   -0.961351}, {   0.004271,    0.006103,    0.022525}, {   0.004271,    0.006103,    0.022525}, {   2.316400,   10.189275,   -3.146370}, {   0.021100,    8.846410,   -0.090236}, {  -0.000048,    0.002273,   -0.438450}, {  -9.963212,    7.116912,   -4.252059}, {   0.021100,    8.846410,   -0.090236},
			{  -0.000048,    0.002273,   -0.438450}, {   0.003173,    0.007323,    0.006258}, {   0.055298,   -0.067809,    0.081170}, {  -0.484136,   -4.918447,    2.366908}, {  -6.894934,   -0.090130,    1.016252}, {  -0.484136,   -4.918447,    2.366908}, {  10.748868,   -6.643539,    4.076424}, {  33.760009,   -5.846312,   -2.049832},
			{   0.005421,    0.007675,    0.000338}, {   0.003898,    0.004887,    0.004286}, {   0.001952,    0.010436,    0.003433}, {   0.003417,    0.004699,    0.005851}, {  10.748868,   -6.643539,    4.076424}, {   0.003898,    0.004887,    0.004286}, {   0.005421,    0.007675,    0.000338}, {   0.001342,    0.002460,    0.002812},
			{   0.001952,    0.001464,    0.000602}, {   0.001952,    0.010436,    0.003433}, {  -0.969115,   -5.172545,    0.003141}, {   0.477782,    0.075255,    1.741137}, {  -5.877930,    0.005187,    0.005075}, {   0.001098,    0.000060,    0.059147}, {   0.007445,    0.005005,    0.004457}, {   3.264525,   -8.108521,   -4.026819},
			{   0.005371,    0.003661,    0.004949}, {   0.006103,    0.006591,    0.003232}, {   0.001098,    0.000060,    0.059147}, {   0.007445,    0.005005,    0.004457}, {   0.006469,    0.005859,    0.000041}, {   2.602003,    1.618798,    1.352341}, {  -2.617432,   -0.146605,   -0.453254}, {   0.255371,   -0.509643,    0.279401},
			{   0.013403,    0.032069,    1.856202}, {   0.002685,    0.005005,    0.001392}, {  -0.030148,    0.322497,    0.003879}, {   0.006835,   13.920227,    5.348260}, {  -0.009154,   -0.061767,   -4.154527}, {  -7.552343,    0.958953,   -2.370435}, { -18.746421,    0.480201,   -7.263226}, {  -7.552343,    0.958953,   -2.370435},
			{ -18.746421,    0.480201,   -7.263226}, {   0.762085,   13.583007,    1.026535}, {   0.004639,   -1.732727,    5.318521}, {   0.725952,   24.662109,   -3.640352}, {   0.967528,   -8.656311,    8.931592}, {  -0.338515,   16.759077,    2.117139}, {   0.005396,   -0.000561,    1.757923}, {  -0.338515,   16.759077,    2.117139},
			{   0.007633,    0.001847,    0.103122}, {   0.002440,   -0.102173,   -0.061283}, {   0.004761,    0.007019,    0.886395}, {   0.016723,   -0.013794,    0.007588}, {   0.001952,    0.011353,    0.004513}, { -11.659803,   -7.380128,    1.504914}, {   0.006084,    0.003417,  -14.530141}, {   0.056853,   -0.006165,    0.005520},
			{   0.047609,   -0.004133,    0.000456}, {   0.005981,    3.542830,   -0.035491}, {  39.131904,   25.575134,    0.006310}, {   0.001046,    0.006256,    0.002175}, {   0.001545,   -0.001832,    0.007428}, { -25.805839,    5.920621,    0.002138}, {   0.004292,   -0.002569,    0.000910}, {  -0.002579,    0.110157,   -0.575715},
			{   0.002440,    0.003783,    0.005466}, {  -0.091553,    0.001159,    0.000000}, {  -3.019953,   -2.176470,   -0.080170}, {  -3.019953,   -2.176470,   -0.080170}, {  -0.096190,  -17.218688,   10.827649}, {  -0.008802,    0.004255,    0.000132}, {   0.984206,    0.133520,    0.134957}, {  -0.004883,   10.822143,   -1.157775},
			{  -0.756173,   -0.000188,   -1.323547}, {   0.004883,    0.007323,    0.004033}, {   0.000487,    0.007263,    0.003684}, {   0.572510,   -0.086852,    0.057039}, {   0.087255,    0.000092,    0.001826}, {   0.004342,    0.000195,    0.014849}, {  -0.002548,   -0.002257,   -0.003688}, {  -0.002548,   -0.002257,   -0.003688},
			{   0.006457,    0.007081,    0.005539}, {   0.004395,    0.007141,    0.003531}, {  11.174926,  -16.772644,    3.719697}, {   0.312866,    1.976379,    2.731415}, {  -2.612494,    4.924641,   -0.108666}, {  -0.007079,    0.004271,    0.004280}, {  -0.028178,   -0.019176,    0.004443}, {   0.007679,    0.002440,    0.004013},
			{   0.004517,    0.196090,    0.002152}, {   0.004517,    0.196090,    0.002152}, {   0.000839,    0.005026,   -0.041827}, {  -0.914075,    1.265025,    0.001366}, {   0.003568,   -0.040231,    0.007449}, {  -1.196045,    0.006304,   -0.047058}, {   0.004495,    0.001658,    0.005743}, {  -0.000211,    0.004914,    0.005243},
			{   0.004495,    0.001658,    0.005743}, {   0.006084,    0.003417,  -14.530141}, {   0.004739,    3.089092,    0.000699}, {   0.003990,    0.003773,    0.001518}, {   0.004929,    0.003291,    0.000892}, {   0.002440,   -0.019089,    0.002934}, {   0.006591,    0.001220,    0.002216}, {   0.003051,    0.004271,   -0.358992},
			{   0.007445,    0.001952,   -0.448002}, {   0.004761,    0.007019,    0.886395}, {   0.005371,    0.003661,    0.004949}, {   0.006103,    0.006591,    0.003232}, {  -0.175326,    0.002792,   -0.034922}, {  -0.005005,   -0.012333,   -0.281563}, {   0.004242,    0.002288,    0.003767}, {   0.004333,    0.001464,    0.006907},
			{   0.002685,    0.003142,   -0.046975}, {   0.007507,    0.003262,    0.002563}, {   0.000415,    0.000536,    0.082433}, {  12.517700,   -3.347899,   -8.158157}, {  -2.012450,   20.698364,   -7.410867}, {  23.051757,  -24.079711,   -5.565268}, {   4.817749,   -3.247070,   -4.556239}, {   0.000000,    0.000000,    0.000000},
			{   8.242309,   10.248619,   -9.716285}, {   0.000000,    0.000000,    0.000000}, { -18.802246,  -15.166687,    1.760355}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{  -2.289841,   -0.521854,    1.316380}, {  -0.002375,    0.020453,    0.015258}, {   0.002506,   -0.064740,    0.016479}, {  -0.007137,    0.189536,    0.003301}, {  -0.003108,    0.005590,    0.018921}, {  -0.516759,   -0.037707,   -0.048048}, {  -0.033794,   -2.453315,    0.007079}, {   0.956879,   -2.658498,   -0.114703},
			{   1.161008,   -4.717370,   -0.232485}, {   0.011694,    0.011407,    0.019104}, {   5.384335,   -0.112412,    0.265747}, {   0.008872,    0.011824,    0.011047}, {   0.010497,    0.011598,    0.014070}, {   0.005723,    0.010173,    0.011047}, {   0.012261,    0.008980,    0.020632}, {   0.011935,    0.009841,    0.015561},
			{   0.012796,    0.013574,    0.014270}, {   0.011725,    0.013555,    0.016597}, {   2.985754,   -0.029860,    3.405049}, {   1.356009,    0.007331,    0.008845}, {  -0.724129,   -0.720574,    0.008541}, {   0.027899,   -0.754393,    0.015127}, {  -0.415237,   -1.588078,   -0.008590}, {   0.005539,   -1.732195,   -0.178292},
			{   0.014430,   -1.951673,    0.022265}, {   0.006413,   -1.311228,    0.006827}, {   1.812263,   -0.768945,    1.837023}, {  -0.143066,   -1.296257,    0.007420}, {   0.008713,    1.212124,    0.014414}, {   6.145109,    7.465850,    1.099828}, {  -2.647615,   -1.375579,    0.353942}, {   0.475100,   -2.383686,    0.015651},
			{  -0.027584,    0.002135,   -0.006250}, {   6.753186,   -0.392403,    0.007934}, {  -2.895977,   -5.951846,   -1.101894}, {  -0.398826,   -0.083181,    0.007329}, {  -1.936727,    0.151885,    0.024190}, {   0.000000,    0.000000,    0.000000}, {   4.077530,   -0.309794,    0.094029}, {   0.012013,    0.016015,    0.008361},
			{ -10.565381,   -8.043760,    0.012268}, {  -3.401336,   13.333529,    0.295608}, {   2.547302,    1.821115,    0.081592}, {   0.001448,    0.006672,    0.003041}, {   2.705023,    2.137331,    0.119897}, {   0.007751,   -1.048063,    0.054692}, {   0.013488,    0.007553,    0.013426}, {   2.064001,   -3.912986,   -0.064514},
			{   0.940993,   -1.555243,    1.549456}, {  -6.972702,   -1.090695,    0.003356}, {   0.003234,    0.000304,    0.002455}, {   6.390502,    0.003051,    0.006384}, {   0.019099,   -0.043878,    0.007782}, {   0.032007,    0.021908,   -0.042142}, {   0.003600,    0.002807,    0.006932}, {   1.943017,    7.483477,    2.474828},
			{   0.001891,    0.004769,    0.061926}, {   0.004271,    0.006630,    0.028292}, {   0.001220,    0.004691,    0.326200}, {   0.000367,    0.001747,    0.000184}, {   0.006225,   -0.011785,   -0.018377}, {   0.005973,    0.004747,    0.005003}, {   0.005748,    0.007720,    0.004699}, {  -0.013530,    0.148654,    0.003002},
			{   6.407546,    0.005665,    0.005166}, {  -3.036525,   -1.481583,    0.001637}, {   0.009643,    0.005249,    0.011134}, { -11.191070,    0.018469,    2.156279}, {   0.007749,    0.003440,    0.002238}, {   3.408934,    2.245302,    0.007249}, {   0.003062,    0.000205,    0.005303}, {   0.000452,    0.005729,    0.001204},
			{   0.004277,    0.001213,    0.002082}, {   0.002335,    1.333493,    0.001597}, {   0.008491,    0.003130,    0.002162}, {   0.003771,    0.000754,    0.001046}, {   1.762264,    0.012314,   -0.061870}, {   2.632270,    0.345100,   -0.114497}, {  -2.550954,    0.150707,    0.569126}, {   0.006976,    0.002570,    0.005249},
			{   0.000555,   -0.004637,    0.263920}, {  -0.784296,   -0.346545,    0.755550}, {   0.826251,   -1.368795,    0.131790}, {  -2.797036,    0.000296,    0.000591}, {   0.006544,   -0.897801,    0.320778}, {   0.211419,   -0.033057,   -2.207963}, {   0.006072,    0.006221,    0.001743}, {   0.000555,   -0.004637,   -0.028834},
			{  -1.795089,    0.098419,    0.006310}, {   0.006943,    0.001652,    0.972867}, {  -0.243925,    0.208522,    0.003897}, {   4.288979,    6.529552,    4.074485}, {  -2.966012,    6.523362,    2.880319}, {   0.000380,    0.001111,   -0.023701}, {  -0.389761,   -2.580116,    1.237691}, {  -3.725564,    0.226520,    0.009712},
			{  -3.727582,    1.249608,    0.002000}, {   0.014329,    0.666966,   -0.000014}, {   0.015475,    0.226024,    0.007697}, {  -4.624832,    2.527770,    0.006254}, {  -0.002602,   -0.003978,    0.000395}, {   0.227357,    0.006291,    0.007122}, {  -4.127812,    1.083927,   -5.262826}, {   0.000000,    0.000000,    0.000000},
			{   0.000037,    0.005127,    0.005725}, {  -0.138554,   -0.293945,   -0.849511}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {  -1.041411,    0.468789,   -2.302222}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{  -2.327999,   -0.073112,   -1.183120}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{  -0.005644,   -0.002445,    0.004486}, {   0.002657,   -0.004761,    0.002369}, {   0.491176,    3.063210,    1.278143}, {  -0.001984,    1.214089,    0.732174}, {  -8.445381,    3.455024,   -4.288386}, {  -3.249778,   -2.363403,   -4.762060}, {   1.467612,   -2.632399,   -4.466862}, {  -5.874113,   -0.660432,   -4.410203},
			{ -14.642832,   14.652950,   -3.593161}, {   0.726656,   -0.763432,   -4.017559}, {  -3.358776,    0.528869,   -3.694613}, {  -5.787086,    2.564754,   -3.934648}, {  -0.183941,    0.488124,    0.038065}, {  -0.314096,   -4.305568,   -3.797745}, {   1.401885,    5.521235,   -4.521557}, {   1.207059,  -15.385622,   -4.063092},
			{   0.001153,   -0.222283,    0.089400}, {  -7.864949,    0.745724,   -5.325564}, {   0.012044,    0.010637,    0.002479}, {   0.008949,    0.015364,    0.006502}, {   0.187518,    0.116455,    0.006723}, {   0.004577,    0.009434,    0.004164}, {   0.004463,    0.004029,    0.007435}, {   0.007338,    0.005518,    0.007178},
			{   0.012361,    0.002658,   -2.515306}, {  -0.838903,   -3.371098,    1.309489}, { -10.481323,   12.969653,    8.834280}, {  -7.413312,    6.614923,   -1.678858}, {  -0.969937,   -7.824999,    7.106259}, {  -2.445667,    5.060389,    3.679246}, {  -5.182011,    0.698029,    1.172096}, { -23.587890,   22.548339,   10.622863},
			{  -0.593289,   -2.228960,    1.990463}, {   0.245599,   -0.008985,    4.070121}, {  -0.733144,   -0.350450,    2.484299}, {   0.005907,   -0.696740,    6.168796}, {  -0.590045,    0.000320,    2.480267}, {  -2.458395,   -6.646903,    0.235034}, {  -0.001910,   -1.124668,    3.711601}, {  -0.446851,   -0.243146,    3.894968},
			{   0.001384,    2.325817,    5.073638}, {   0.038738,   -0.779012,    2.539817}, {  -1.660006,    1.367095,    3.836817}, {   1.556821,   -0.000029,    3.515820}, {   0.004195,    0.006291,    0.197685}, { -16.831005,   -6.059841,    0.607551}, {   0.001246,   -0.038800,    0.004637}, {  -6.231362,   23.040966,    0.004135},
			{   3.673949,    5.463806,    0.494338}, {   0.001516,    0.008042,    0.001307}, {   0.001005,   -0.000844,    0.001233}, {   2.684020,    0.003447,   -0.159467}, {  -0.100193,   -1.578024,    1.023805}, {   0.004271,    0.001616,    0.010115}, {   3.786436,   -0.000839,   -0.159467}, {  -0.187858,   -0.012345,    0.002747},
			{  -4.888117,    4.836420,  -11.338586}, {  -2.981880,    1.411671,    2.002465}, {   5.252566,   -0.393792,    1.175389}, {  -2.821403,   -3.480226,    1.830961}, {   0.896917,    0.220392,    0.426806}, {   5.987007,    2.290291,    2.865722}, {  -0.006169,    0.292878,   -0.352445}, {   2.299824,   -1.245674,   -2.289166},
			{   0.926496,    1.192504,    4.213984}, {  -1.003031,    0.914300,    3.019972}, {   0.001604,    0.005158,    0.001750}, {   2.045506,    1.548997,    1.936195}, {   0.001150,    0.003458,   -2.633949}, {   0.007546,    0.005371,    0.000745}, {   5.565845,   -8.783983,   -1.290406}, {   0.002017,    0.003975,   -2.329884},
			{   0.006479,    0.002952,   -2.783376}, {   0.003594,    0.006041,   -2.353385}, {  -0.591014,   -0.009576,    2.484977}, {   0.001434,    0.000697,    0.001830}, {   9.110605,  -27.761289,   -8.798816}, {  -0.241322,    4.810974,    0.250010}, {  -2.424552,   -1.899840,    0.294077}, {   1.445564,   -0.840331,    0.425449},
			{   9.856330,    7.665283,   -0.515781}, {   0.279549,   -2.680664,    1.751175}, {   0.003310,   -2.454068,    2.550870}, {   0.003365,    0.002819,    2.742880}, {   0.003128,    0.002112,    0.005661}, {   0.003331,    0.001084,    0.004244}, {   4.092407,    0.999083,    1.622091}, {   1.109619,    0.317313,    0.428157},
			{   0.565977,    0.961830,   -0.067129}, {   1.379394,    0.449687,    0.319743}, {   1.106132,    0.370254,    0.341414}, {   0.715820,   -1.573241,   -0.135400}, {   0.073133,    0.208984,   -0.567489}, {  33.455612,  -44.605072,  -45.156089}, {   8.035629,  -42.562866,    3.823920}, {  -5.121840,  -51.122253,    6.507706},
			{  14.625793,  -41.978790,   12.221603}, {   0.006850,    4.844696,    0.003616}, {   0.003670,   -2.426270,    5.720221}, { -14.068232,  -27.802551,    7.413986}, {   6.908690,   -5.281280,   12.218452}, {   0.308762,    0.003234,   -5.965958}, {   1.675583,    5.616759,    1.637076}, {  13.076171,    2.268218,   -9.939208},
			{  -3.367268,    0.932083,    0.001418}, { -37.373287,  -29.623840,    4.631797}, {   9.653869,   -2.776245,   12.222427}, {   0.001677,    0.004958,    0.005797}, {   0.004027,    0.001052,    0.005737}, {  -5.820236,    0.003600,   -3.595520}, {   0.000770,    1.074890,    0.005477}, {   0.007317,    0.459868,    0.000556},
			{   0.005863,    3.166671,    1.526306}, {  -3.947753,  -42.610198,    0.830569}, {  -4.878723,  -59.319763,  -11.948932}, {  10.788818,    0.006072,   12.219238}, {   0.003128,    0.004027,    0.002585}, {   0.004501,    0.006748,    0.001045}, {   0.003047,    1.880874,    0.004025}, {  10.654735,    0.001250,    1.971717},
			{   0.007648,    0.007102,   -1.669842}, {   0.001975,    2.086555,   -4.278645}, {   0.006194,    0.493748,   -5.133712}, {  -3.705933,    1.218937,   -7.311370}, {  28.111114,    9.196109,   12.223327}, {   0.004104,    0.001067,    0.004112}, {   0.006279,    0.002566,    0.001677}, {   0.001723,    0.002575,    0.002426},
			{   0.004536,   -1.807670,    0.004143}, {   0.001586,    0.002013,    0.000373}, {   0.007400,    0.007244,   -7.718318}, {   0.004807,    0.006190,  -14.466346}, {   0.006393,    0.005679,  -12.415306}, {   1.730103,    2.414513,  -25.939987}, {   3.912445,   -0.621177,  -30.904800}, {   0.006972,    0.003322,    0.004166},
			{   0.027801,    0.001906,   -0.105988}, {   0.007240,    0.001647,    0.006728}, {   0.006180,    0.005423,  -12.900058}, {   0.005249,    0.002182,  -24.954635}, {  -1.205047,    0.001372,   -6.726284}, {  -2.017914,   -4.307053,  -36.471786}, {   0.000472,   -0.545211,    0.004813}, {   0.007050,    0.003799,   -1.994639},
			{   0.007098,    0.005843,   -0.848824}, {   0.006523,    0.004395,    0.004718}, {   0.002891,   -0.373778,    0.005946}, {   0.007079,   -3.235198,    0.356494}, {   0.754577,    1.089539,  -34.943794}, {  -0.180144,   -6.160980,  -22.719032}, {   0.001220,    0.006225,    0.007449}, {   0.001098,    0.006012,    0.002823},
			{   0.000083,    0.007507,    0.004606}, {   0.006225,    0.001235,    0.003016}, {   0.000228,    0.000396,    0.000724}, {   0.004089,    0.000030,    0.000400}, {   0.003631,    0.003936,    0.004695}, {   0.007323,    0.006653,    0.000980}, {  22.882812,   67.381225,   24.841350}, {   0.258484,   67.384796,   24.920719},
			{   0.006240,   67.385589,   25.469062}, {   0.006508,    0.002379,    0.001231}, {  14.557250,   10.941497,   11.693335}, {  -1.930724,   12.919799,   12.217346}, {   0.386947,   -1.835029,    0.001289}, {  -3.655211,    3.694701,    0.005702}, { -19.917289,  -30.373268,  -26.619287}, {   0.007075,  -15.536558,    1.341765},
			{   1.451213,    0.645556,    4.461637}, {  -4.882748,    0.215065,    0.015216}, {  -6.734447,   -0.014523,   -0.103904}, {  -3.998389,    2.296299,    2.134438}, {  -0.084716,   -2.922343,    2.344810}, {  -0.483657,   10.130235,    1.227507}, {   6.281180,   -6.480723,   -0.443507}, {   1.970389,   10.143188,   -0.200288},
			{ -23.016696,   -9.858184,   -0.594814}, {   6.489445,  -44.830192,    1.114501}, {   9.533428,    5.727286,    2.704010}, {  -7.366664,    2.605449,   -2.869965}, {   9.218696,    6.828631,    3.599817}, {  -5.684761,   -1.764397,    2.405654}, {  29.594509,  -30.605365,    2.835172}, {  -5.353305,    6.133518,   -0.390529},
			{  24.747859,   -1.917297,    2.407744}, {  -0.005363,    0.003821,    0.006926}, {   0.005646,   -0.001975,    0.002701}, {  -0.006442,   -0.006980,    0.001769}, {  -0.002121,   -0.001170,    0.006512}, {  -1.959812,   -2.559516,    0.311942}, { -11.578609,  -13.344978,    1.329682}, {  -0.437992,   -5.104969,    0.847064},
			{   0.369497,    3.867230,   -1.282485}, {   0.002624,    0.001264,    0.003722}, {  -4.412625,    2.653687,    0.006134}, {  -0.084716,   -2.922343,    2.344810}, {  -3.998389,    2.296299,    2.134438}, {  -6.734447,   -0.014523,   -0.103904}, {  -4.882748,    0.215065,    0.015216}, {  -5.820236,    0.003600,   -3.595520},
			{   0.386947,   -1.835029,    0.001289}, {  -3.947753,  -42.610198,    0.830569}, {  -0.483657,   10.130235,    1.227507}, {   6.281180,   -6.480723,   -0.443507}, {   0.007400,    0.007244,   -7.718318}, {   1.970389,   10.143188,   -0.200288}, { -23.016696,   -9.858184,   -0.594814}, {   6.489445,  -44.830192,    1.114501},
			{   0.000472,   -0.545211,    0.004813}, {  -5.353305,    6.133518,   -0.390529}, {  29.594509,  -30.605365,    2.835172}, {   0.001220,    0.006225,    0.007449}, {   0.004089,    0.000030,    0.000400}, {   0.003631,    0.003936,    0.004695}, {   0.007323,    0.006653,    0.000980}, {  22.882812,   67.381225,   24.841350},
			{   0.258484,   67.384796,   24.920719}, {   0.006508,    0.002379,    0.001231}, {  14.557250,   10.941497,   11.693335}, { -23.587890,   22.548339,   10.622863}, {  24.747859,   -1.917297,    2.407744}, {  -0.005363,    0.003821,    0.006926}, {   0.005646,   -0.001975,    0.002701}, {  -0.006442,   -0.006980,    0.001769},
			{  -0.002121,   -0.001170,    0.006512}, {  -1.959812,   -2.559516,    0.311942}, { -11.578609,  -13.344978,    1.329682}, {  -0.437992,   -5.104969,    0.847064}, {   0.369497,    3.867230,   -1.282485}, {  -7.366664,    2.605449,   -2.869965}, {   9.218696,    6.828631,    3.599817}, {  -5.684761,   -1.764397,    2.405654},
			{   0.334856,    0.612680,    0.192736}, {   0.286633,    1.625265,    0.939418}, {   0.001736,    0.005597,    0.007766}, {  17.041330,   -0.728259,   -0.028160}, {   0.187000,   -0.033518,    0.018225}, {   0.013671,    0.011714,    0.003003}, {   0.049068,   -0.180801,   -0.003321}, {  -0.051998,    0.002113,    0.005795},
			{  -0.066160,    3.560322,    0.613104}, {   0.004958,    1.024685,   -0.000592}, {   0.457973,    0.644073,   -0.175903}, {   6.200843,   13.884390,   -1.076673}, {  -0.009119,   -0.003171,    0.002708}, {  -0.007143,   -0.004116,    0.000029}, {  -0.006889,    0.001837,    0.005005}, {   0.004271,    0.000968,    0.002754},
			{   0.007222,   -6.357711,   -5.223781}, {   4.837397,   -0.000048,   -0.561218}, {   0.004126,   -0.001532,   -0.561219}, {   0.269212,   -0.031776,    0.116685}, {  -0.004598,    0.004873,    0.216094}, {   9.091577,    0.164679,    2.893951}, { -15.831841,    4.213916,    0.504239}, {   1.658360,   -2.113795,   -2.555161},
			{ -10.528149,   -1.911514,   -0.834694}, {  -4.796332,   -1.338173,    0.416584}, {   2.175757,   -4.299496,    1.982200}, { -12.541976,    4.616036,   -0.395226}, {   4.328310,   -0.433566,   -0.041007}, {  -8.088291,    0.052958,   -0.479377}, {   4.349358,    1.909258,   -3.037846}, {   1.139935,  -11.727846,    0.755015},
			{   3.813868,    3.889956,   -2.186656}, {   1.008671,    0.202671,   -1.910004}, {  -1.658347,    0.421723,   -0.686884}, {  15.727952,    3.230103,    0.461472}, {  -7.445600,    2.285914,    1.218680}, {   0.004943,    0.006103,    0.000289}, {   0.004608,    0.000434,    0.003648}, {   0.001189,    0.002510,    0.004389},
			{   0.006924,    0.005561,    0.006147}, {   0.000457,    0.003875,    0.006194}, {  -7.774122,   -9.781997,   -3.828382}, {   0.002819,    0.003792,    0.007075}, {   0.006488,   -0.004554,    0.001228}, {   0.001999,    0.001597,    0.000762}, {   0.004466,   -0.004069,    0.007133}, {   0.003505,   -0.004207,    0.000762},
			{   0.004435,   -0.003470,    0.007133}, {   0.006924,   -0.000121,    0.000762}, {   0.008376,   -0.002090,    0.006943}, {   0.008081,   -0.001203,    0.002776}, {   0.005996,   -0.000999,   -5.120231}, {   0.001784,    0.007416,    0.004542}, {   0.000083,    0.007507,    0.004606}, {   0.000457,    0.003875,    0.006194},
			{   0.000228,    0.000396,    0.000724}, {   0.006523,    0.004395,    0.004718}, {   0.006225,    0.001235,    0.003016}, {   0.001784,    0.007416,    0.004542}, {   0.007098,    0.005843,   -0.848824}, {   0.002819,    0.003792,    0.007075}, {   0.007240,    0.001647,    0.006728}, {   0.002624,    0.001264,    0.003722},
			{   0.095673,   -0.010084,   -0.505227}, {  -0.001984,    1.214089,    0.732174}, {   0.001604,    0.005158,    0.001750}, { -16.831005,   -6.059841,    0.607551}, {  -1.205047,    0.001372,   -6.726284}, {   0.004807,    0.006190,  -14.466346}, {   0.005249,    0.002182,  -24.954635}, {  -3.705933,    1.218937,   -7.311370},
			{   1.730103,    2.414513,  -25.939987}, {   3.912445,   -0.621177,  -30.904800}, {   0.001975,    2.086555,   -4.278645}, {   0.006194,    0.493748,   -5.133712}, {   0.006393,    0.005679,  -12.415306}, {   0.006180,    0.005423,  -12.900058}, {  -2.017914,   -4.307053,  -36.471786}, {   0.002891,   -0.373778,    0.005946},
			{   0.007079,   -3.235198,    0.356494}, {   0.754577,    1.089539,  -34.943794}, {  -0.180144,   -6.160980,  -22.719032}, {  -4.878723,  -59.319763,  -11.948932}, {   9.533428,    5.727286,    2.704010}, {  -4.412625,    2.653687,    0.006134}, {  -0.006091,   -0.004579,    0.000476}, {  -0.006091,   -0.004579,    0.000476},
			{  -0.733144,   -0.350450,    2.484299}, {   0.005907,   -0.696740,    6.168796}, {  -0.590045,    0.000320,    2.480267}, {  -1.003031,    0.914300,    3.019972}, {   5.987007,    2.290291,    2.865722}, {  -7.774122,   -9.781997,   -3.828382}, {   0.095673,   -0.010084,   -0.505227}, {  -0.005644,   -0.002445,    0.004486},
			{   0.001384,    2.325817,    5.073638}, {  -0.001910,   -1.124668,    3.711601}, {  -2.458395,   -6.646903,    0.235034}, {   0.926496,    1.192504,    4.213984}, {  -0.446851,   -0.243146,    3.894968}, {   0.038738,   -0.779012,    2.539817}, {  -1.660006,    1.367095,    3.836817}, {  -3.655211,    3.694701,    0.005702},
			{   0.245599,   -0.008985,    4.070121}, {   4.837397,   -0.000048,   -0.561218}, {   0.004126,   -0.001532,   -0.561219}, {   0.001999,    0.001597,    0.000762}, {   0.004466,   -0.004069,    0.007133}, {   0.003505,   -0.004207,    0.000762}, {   0.006924,   -0.000121,    0.000762}, {   0.004435,   -0.003470,    0.007133},
			{   0.008081,   -0.001203,    0.002776}, {   0.008376,   -0.002090,    0.006943}, {   0.006488,   -0.004554,    0.001228}, {   0.005996,   -0.000999,   -5.120231}, {   0.003310,   -2.454068,    2.550870}, {   0.003365,    0.002819,    2.742880}, {   0.003128,    0.002112,    0.005661}, { -18.924224,  -29.828533,  -27.385431},
			{   3.278634,   -1.844678,    2.952702}, {  -0.001815,    0.002506,    0.007342}, {   3.278634,   -1.844678,    2.952702}, {   3.786436,   -0.000839,   -0.159467}, {   2.684020,    0.003447,   -0.159467}, {   0.001005,   -0.000844,    0.001233}, {  -4.888117,    4.836420,  -11.338586}, {  -2.445667,    5.060389,    3.679246},
			{  -6.231362,   23.040966,    0.004135}, {   0.002052,   -0.001450,   -0.009995}, {   0.002052,   -0.001450,   -0.009995}, {   0.001239,    0.002171,    0.009367}, {   0.001239,    0.002171,    0.009367}, {   0.028198,    0.529799,   -0.589340}, {   0.000747,   -0.007776,   -0.085208}, {  -0.189520,   -0.324202,   -0.458954},
			{   1.274621,    0.949312,   -0.441617}, {   0.025702,    0.539018,   -0.589340}, {   0.000770,    1.074890,    0.005477}, {   0.004501,    0.006748,    0.001045}, {   0.001723,    0.002575,    0.002426}, {   0.004536,   -1.807670,    0.004143}, {   0.003047,    1.880874,    0.004025}, {   0.007317,    0.459868,    0.000556},
			{  13.076171,    2.268218,   -9.939208}, {  -3.367268,    0.932083,    0.001418}, {   1.675583,    5.616759,    1.637076}, {   0.308762,    0.003234,   -5.965958}, {   0.001677,    0.004958,    0.005797}, {   0.003128,    0.004027,    0.002585}, {   0.004027,    0.001052,    0.005737}, {   0.004943,    0.006103,    0.000289},
			{   0.003670,   -2.426270,    5.720221}, {  10.654735,    0.001250,    1.971717}, { -37.373287,  -29.623840,    4.631797}, { -14.068232,  -27.802551,    7.413986}, {  -5.121840,  -51.122253,    6.507706}, {   8.035629,  -42.562866,    3.823920}, {   0.006850,    4.844696,    0.003616}, {  33.455612,  -44.605072,  -45.156089},
			{  14.625793,  -41.978790,   12.221603}, {   6.908690,   -5.281280,   12.218452}, {   9.653869,   -2.776245,   12.222427}, {  10.788818,    0.006072,   12.219238}, {   0.006279,    0.002566,    0.001677}, {   0.004104,    0.001067,    0.004112}, {   0.005863,    3.166671,    1.526306}, {   0.007648,    0.007102,   -1.669842},
			{   0.001586,    0.002013,    0.000373}, {   0.006972,    0.003322,    0.004166}, {  28.111114,    9.196109,   12.223327}, {   0.027801,    0.001906,   -0.105988}, {   0.001098,    0.006012,    0.002823}, {   0.006240,   67.385589,   25.469062}, {  -1.930724,   12.919799,   12.217346}, {   0.007050,    0.003799,   -1.994639},
			{   0.002679,    0.004011,    0.004308}, {   0.237710,    3.235795,   -0.512539}, {   0.000000,  -27.989227,   15.843351}, {  -5.658966,   -9.101684,    1.959174}, {  59.562805,  -91.102600,  -44.125236}, {  62.495788,   60.887115,  -45.221569}, {  -6.879302,    4.486022,  -23.459987}, {   0.009552,    0.302554,    9.465627},
			{ -37.639007,  -64.849945,   -9.716014}, { -13.550933,   15.596267,  -17.263641}, {  22.111763,  -30.499561,  -32.256145}, {-125.771949,  -50.718154,  -39.542407}, {  21.510410,   -0.448008,   -3.525389}, {  17.154426,   23.938919,   -3.262463}, {  46.102783,  -58.685485,   -6.010779}, {   7.375923,  -10.574737,   46.456596},
			{   4.246292,  -72.649444,    1.745810}, {  54.994400,   16.158988,  -34.473392}, { -22.940368,    5.458515,    5.463644}, { -69.548400,  -20.466934, -104.921447}, {  -4.897827,  -11.865051,  -13.398438}, {   7.885039,  -80.772064,    4.476645}, {  11.397308,  -55.462860,   31.656265}, {   0.000000,    0.000000,    0.003905},
			{   0.031250,    0.003905,   -0.585124}, {   0.000000,    0.089844,   -0.097655}, {   0.000000,    0.136719,   -0.070312}, {   0.046875,    0.031250,    0.132813}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,   -0.054551}, {   0.000000,    0.003905,    0.003905}, {   0.000000,    0.000000,    0.003905},
			{   0.000000,    0.000292,    0.054388}, {   0.003905,    0.003905,    0.039062}, {   0.000000,    0.000000,    0.000000}, {  10.016109,    0.000000,   -0.000302}, {  -0.002430,   -0.002350,   -0.126120}, {   0.000000,    0.003905,    0.000000}, {   0.000000,    0.000000,   -0.007813}, {   0.003905,    0.000000,    0.003905},
			{   0.003905,    0.000000,    0.003905}, {   0.003905,    0.000000,    0.003905}, {   0.003905,    0.000000,    0.003905}, {   0.003905,    0.000000,    0.003905}, {   0.003905,    0.000000,    0.003905}, {  -0.167969,    0.003905,    1.820312}, {  -0.167969,    0.003905,    1.820312}, {  -0.167969,    0.003905,    1.820312},
			{   0.011718,   30.492187,    0.796875}, {   0.011718,   30.492187,    0.796875}, {   0.011718,   30.492187,    0.796875}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000},
			{   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.000000,    0.000000,    0.000000}, {   0.0