//==============================================================================
//=======================|         Object Streamer        |=====================
//=======================|      Created by: White_116     |=====================
//=======================|           WEngine v2.1         |=====================
//==============================================================================
/*
native W_CreateObject(modelid, Float:x, Float:y, Float:z, Float:rx, Float:ry, Float:rz, Float:dist=400.0);
native W_IsValidObject(objectid);
native W_SetObjectPos(objectid, Float:x, Float:y, Float:z);
native W_GetObjectPos(objectid, &Float:x, &Float:y, &Float:z);
native W_SetObjectRot(objectid, Float:rx, Float:ry, Float:rz);
native W_GetObjectRot(objectid, &Float:rx, &Float:ry, &Float:rz);
native W_MoveObject(objectid, Float:x, Float:y, Float:z, Float:speed);

native W_StartOStreamer(time);
native W_StopOStreamer();
native W_OnPlayerConnect(playerid);
native W_SetPlayerPos();

native Analiz(Krug);
native GetKvPos(Region,Dlina,Float:x,Float:y);
native GetKvPosXY(Region,Dlina,KvPos,&Float:x,&Float:y);

native StreamKvForAll();
native StreamKvForPl(playerid,OldKvPos,NewKvPos);
native CreatePlayerKv(playerid,KvPos);
native DestroyPlayerKv(playerid,KvPos);
native DestroiAllObjForPl(playerid);
*/

#include <a_samp>

#define MAX_PL 200              //	 - 
#define MAX_OB 15000            //   - 
#define ObjectsToStream 390     //   -   
#define Region 3000             //	  
#define Krug 4                  //  -  
#define max_stream_kub 81      //	 -   
#define Dlina 100				//	    
#define MAX_KV 3601 //(((Region+Region)/Dlina) * ((Region+Region)/Dlina))+1;//       

enum OInfo
{
	ModelID,
	ObjectID[MAX_PL],
	Float:ox, Float:oy, Float:oz,
	Float:orx, Float:ory, Float:orz,
	Float:ovdist
}
new ObjectInfo[MAX_OB][OInfo];
new KolvoObjects;
new SetkaInfo[MAX_KV][ObjectsToStream];
new ASetkaInfo[MAX_KV][max_stream_kub];
new KolvoObjectsInKv[MAX_KV];
new PlKvPos[MAX_PL];
new bool:StopStreamForPl[MAX_PL];
new StTimer;

stock W_CreateObject(modelid, Float:x, Float:y, Float:z, Float:rx, Float:ry, Float:rz, Float:vdist=400.0)
{
	if(KolvoObjects+1>=MAX_OB)//	  
	{
		printf("  \t\t%d,%f,%f,%f,%f,%f,%f",modelid,x,y,z,rx,ry,rz);
		return -1;
	}
	if(!modelid)//	  
	{
		printf(" modelid\t\t%d,%f,%f,%f,%f,%f,%f",modelid,x,y,z,rx,ry,rz);
		return -1;
	}

	new kvpos=GetKvPos(Region,Dlina,x,y);//        
	if(KolvoObjectsInKv[kvpos]>=ObjectsToStream)//     1 
	{
		printf("    1 \n%d,%f,%f,%f,%f,%f,%f",modelid,x,y,z,rx,ry,rz);
		return -1;
	}

	++KolvoObjects;//     
	SetkaInfo[kvpos][KolvoObjectsInKv[kvpos]]=KolvoObjects;//    
	++KolvoObjectsInKv[kvpos];//      

	ObjectInfo[KolvoObjects][ModelID] = modelid;
	ObjectInfo[KolvoObjects][ox] = x; ObjectInfo[KolvoObjects][oy] = y; ObjectInfo[KolvoObjects][oz] = z;
	ObjectInfo[KolvoObjects][orx] = rx; ObjectInfo[KolvoObjects][ory] = ry; ObjectInfo[KolvoObjects][orz] = rz;
	ObjectInfo[KolvoObjects][ovdist] = vdist;

	return KolvoObjects;//    
}

stock GetKvPos(region,dlina,Float:x,Float:y)
{
	//        
	if(x<-region)x=-region+1;
	if(y<-region)y=-region+1;
	if(y>region)y=region-1;
	if(x>region)x=region-1;

	new px = floatround((x+region)/dlina,floatround_floor);	//   
	new py = floatround((y+region)/dlina,floatround_floor);	//   
	new pc = floatround((region+region)/dlina,floatround_floor);	//-   1 
	new kvpos =(px*pc)+py+1;//    +1,   0

	return kvpos;
}

stock GetKvPosXY(region,dlina,kvpos,&Float:x,&Float:y)	//   GetKvPos
{
    --kvpos;	//  1   0  
    new div	= (floatround((kvpos/((region*2)/dlina)),floatround_floor));
	new mod	= (kvpos-(floatround((kvpos/((region*2)/dlina)),floatround_floor))*((region*2)/dlina));

	x = ((dlina/2) +(dlina*div))-region;	//  
	y = ((dlina/2) +(dlina*mod))-region;    //  
}

stock sd(region,dlina,KvP,kolvo,id,&kolvoobg,&k,Float:x1,Float:y1,x2,y2)
{
	if(kolvo >= ObjectsToStream){kolvoobg=kolvo; k=id; return 1;}	//    
	//    
	x1=x1+(x2*dlina);
	y1=y1+(y2*dlina);
	if((x1<-region)||(x1>region)||(y1<-region)||(y1>region)){kolvoobg=kolvo; k=id; return 1;}	//       
	new sp = GetKvPos(region,dlina,x1,y1);	//   
	if(KolvoObjectsInKv[sp]<1  || ((kolvo+KolvoObjectsInKv[sp])>ObjectsToStream)){kolvoobg=kolvo; k=id; return 1;}  //  -    

	ASetkaInfo[KvP][id]=sp;	//   
	k = ++id;   //  
	kolvoobg = (kolvo+KolvoObjectsInKv[sp]);    //  

	return 1;
}

forward Analiz(krug);
public Analiz(krug)
{
	printf("\t\t%d    ...\n\t\t ...",KolvoObjects);
	
	for(new KvP=1;KvP<MAX_KV;++KvP)
	{
		new kolvoobg,k;
		new Float:x,Float:y;
        GetKvPosXY(Region,Dlina,KvP,x,y);//        , 

//==============================================================================
		if(krug>=0)
		{
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,0);
		}
		if(krug>=1)
		{
	//1**************
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,1);
		}
		if(krug>=2)
		{
	//2**************
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,2);
		}
		if(krug>=3)
		{
	//3**************
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,3);
		}
		if(krug>=4)
		{
	//4*************
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,4);
		}
		if(krug>=5)
		{
	//5**************
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,5);
		}
		if(krug>=6)
		{
	//6***********

			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,6);
		}
		if(krug>=7)
		{
	//7***********

			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,0,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,0);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,6,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,-6);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-6,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,5,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,-5);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-5,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,4,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,-4);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-4,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,3,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,-3);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-3,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,2,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,-2);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-2,7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,7,1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,1,-7);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-7,-1);
			sd(Region,Dlina,KvP,kolvoobg,k,kolvoobg,k,x,y,-1,7);
		}
	}
//==============================================================================
	print("\t\t !");
	return 1;
}

forward StreamKvForAll();
public StreamKvForAll()
{
    new Float:x,Float:y,Float:z;
	for (new playerid; playerid<MAX_PL; ++playerid)	//    
	{
		if(IsPlayerConnected(playerid) && !IsPlayerNPC(playerid) && !StopStreamForPl[playerid])   //      
		{
  			GetPlayerPos(playerid,x,y,z);   //  
		    new KvPos = GetKvPos(Region,Dlina,x,y); //      

		    if(PlKvPos[playerid] != KvPos)	//     
			{
                StreamKvForPl(playerid,PlKvPos[playerid],KvPos);	//  
                PlKvPos[playerid] = KvPos;	//   
			}
		}
	}
	return 1;
}

stock StreamKvForPl(playerid,OldKvPos,NewKvPos)
{
	//new speed=tickcount();//************************

	new bool:create[max_stream_kub];    //    
    for(new nk;nk<max_stream_kub;++nk)
	{
	    if(ASetkaInfo[OldKvPos][nk]!=0) //   0
	    {
	        new bool:ok;    //        
         	for(new kk;kk<max_stream_kub;++kk)
			{
				    if(ASetkaInfo[NewKvPos][kk]!=0)//   0
				    {
						if(ASetkaInfo[OldKvPos][nk]==ASetkaInfo[NewKvPos][kk])  //   
						{
				        	ok=true;    //  
				        	create[kk]=true;    //  
				        	break;
		 				}
			        }
				 	else break;
			}
			if(!ok)
			{
				DestroyPlayerKv(playerid,ASetkaInfo[OldKvPos][nk]); //  
			}
		}
		else break;
	}
//************
    for(new kk;kk<max_stream_kub;++kk)
	{
	    if(ASetkaInfo[NewKvPos][kk]!=0 && !create[kk])  //    
	    {
	        CreatePlayerKv(playerid,ASetkaInfo[NewKvPos][kk]);  //  
	    }
	}
//************
/*
	new str[32];
	format(str,32,"WOspeed = %d",tickcount()-speed);
	SendClientMessage(playerid,0xFFFFFFFF,str);
*/
	return 1;
}

stock CreatePlayerKv(playerid,setkapos)
{
	for (new i;i<ObjectsToStream;++i)
	{
        if(SetkaInfo[setkapos][i]!=0)
        {
			ObjectInfo[SetkaInfo[setkapos][i]][ObjectID][playerid]=CreatePlayerObject(playerid,
			ObjectInfo[SetkaInfo[setkapos][i]][ModelID],
			ObjectInfo[SetkaInfo[setkapos][i]][ox],
			ObjectInfo[SetkaInfo[setkapos][i]][oy],
			ObjectInfo[SetkaInfo[setkapos][i]][oz],
			ObjectInfo[SetkaInfo[setkapos][i]][orx],
			ObjectInfo[SetkaInfo[setkapos][i]][ory],
			ObjectInfo[SetkaInfo[setkapos][i]][orz],
			ObjectInfo[SetkaInfo[setkapos][i]][ovdist]);
		}
		else break;
	}
}

stock DestroyPlayerKv(playerid,setkapos)
{
	for (new i;i<ObjectsToStream;++i)
	{
        if(SetkaInfo[setkapos][i]!=0)
        {
       		DestroyPlayerObject(playerid,ObjectInfo[SetkaInfo[setkapos][i]][ObjectID][playerid]);
			ObjectInfo[SetkaInfo[setkapos][i]][ObjectID][playerid]=0;
		}
		else break;
	}
}

stock DestroiAllObjForPl(playerid)
{
	new OldKvPos=PlKvPos[playerid]; //   
    PlKvPos[playerid]=0;    //    

	for(new nk;nk<max_stream_kub;++nk)
	{
		if(ASetkaInfo[OldKvPos][nk]!=0) //  
        DestroyPlayerKv(playerid,ASetkaInfo[OldKvPos][nk]); //  
        else break;
	}
}

stock W_IsValidObject(objectid)
{
	if(ObjectInfo[objectid][ModelID] == 0 || objectid <1 || objectid>MAX_OB)
 	return 0;
 	else
	return 1;
}

stock W_GetObjectPos(objectid, &Float:x, &Float:y, &Float:z)
{
	if(W_IsValidObject(objectid))
	{
		x = ObjectInfo[objectid][ox]; y = ObjectInfo[objectid][oy]; z = ObjectInfo[objectid][oz];
		return 1;
	}
	return 0;
}

stock W_GetObjectRot(objectid, &Float:rx, &Float:ry, &Float:rz)
{
	if(W_IsValidObject(objectid))
	{
		rx = ObjectInfo[objectid][orx]; ry = ObjectInfo[objectid][ory]; rz = ObjectInfo[objectid][orz];
		return 1;
	}
	return 0;
}

stock W_SetObjectPos(objectid, Float:x, Float:y, Float:z)
{
	if(W_IsValidObject(objectid))
	{
		ObjectInfo[objectid][ox] = x;
		ObjectInfo[objectid][oy] = y;
		ObjectInfo[objectid][oz] = z;

		for(new playerid; playerid<MAX_PL; ++playerid)
		if(IsPlayerConnected(playerid) && !IsPlayerNPC(playerid) && ObjectInfo[objectid][ObjectID][playerid]!=0)
		{
			SetPlayerObjectPos(playerid, ObjectInfo[objectid][ObjectID][playerid], x, y, z);
		}
		return 1;
	}
	return 0;
}

stock W_SetObjectRot(objectid, Float:x, Float:y, Float:z)
{
	if(W_IsValidObject(objectid))
	{
		ObjectInfo[objectid][orx] = x;
		ObjectInfo[objectid][ory] = y;
		ObjectInfo[objectid][orz] = z;

		for(new playerid; playerid<MAX_PL; ++playerid)
		if(IsPlayerConnected(playerid) && !IsPlayerNPC(playerid) && ObjectInfo[objectid][ObjectID][playerid]!=0)
		{
			SetPlayerObjectRot(playerid, ObjectInfo[objectid][ObjectID][playerid], x, y, z);
		}
		return 1;
	}
	return 0;
}

stock W_MoveObject(objectid, Float:x, Float:y, Float:z, Float:speed)
{
	if(W_IsValidObject(objectid))
	{
		new time;
		for(new playerid; playerid<MAX_PL; ++playerid)
		if(IsPlayerConnected(playerid) && !IsPlayerNPC(playerid) && ObjectInfo[objectid][ObjectID][playerid]!=0)
		{
			time = MovePlayerObject(playerid, ObjectInfo[objectid][ObjectID][playerid], x, y, z, speed);
		}
		ObjectInfo[objectid][ox] = x;
		ObjectInfo[objectid][oy] = y;
		ObjectInfo[objectid][oz] = z;
		return time;
	}
	return 0;
}

stock W_StartOStreamer(time)
{
	Analiz(Krug);
	StTimer=SetTimer("StreamKvForAll",time,1);
	printf("\t\t     %d ms!\n",time);
	return 1;
}

stock W_StopOStreamer()
{
    KillTimer(StTimer);
   	for (new playerid; playerid<MAX_PL; playerid++)
	{
		if(IsPlayerConnected(playerid) && !IsPlayerNPC(playerid))
		{
		    DestroiAllObjForPl(playerid);
		    StopStreamForPl[playerid]=false;
		}
	}
	return 1;
}

stock W_OnPlayerConnect(playerid)
{
	PlKvPos[playerid]=0;
    StopStreamForPl[playerid]=false;
    return 1;
}

stock W_SetPlayerPos(playerid, Float:x, Float:y, Float:z)
{
	StopStreamForPl[playerid] = true;
	new NewKvPos=GetKvPos(Region,Dlina,x,y);
 	if(PlKvPos[playerid] != NewKvPos)
	{
        StreamKvForPl(playerid,PlKvPos[playerid],NewKvPos);
        PlKvPos[playerid]= NewKvPos;
	}
	SetPlayerPos(playerid, x, y, z);
	StopStreamForPl[playerid] = false;
}
#define SetPlayerPos W_SetPlayerPos


