#include <a_samp>
// Tank Light System by O.K.Style
#define TANK_LIGHTS_SYNC_DELAY 30 * 1000
new TankTimer[MAX_PLAYERS char], tank[3], tlight[6];
public OnFilterScriptInit()
{
	tank[0] = CreateVehicle(432, 277.0, 1998.2, 17.65, 270.0, 43, 0, -1);
	tank[1] = CreateVehicle(432, 277.0, 1989.2, 17.65, 269.0, 43, 0, -1);
	tank[2] = CreateVehicle(432, 277.0, 1980.2, 17.65, 270.0, 43, 0, -1);
	return 1;
}
public OnFilterScriptExit()
{
	for(new i = 0; i < sizeof(tank); i++) DestroyVehicle(tank[i]);
	for(new i = 0; i < sizeof(tlight); i++) if(IsValidObject(tlight[i])) DestroyObject(tlight[i]);
	for(new i = GetMaxPlayers() - 1; i != -1; i--) KillTimer(TankTimer{i});
	return 1;
}
public OnPlayerConnect(playerid) return TogglePlayerClock(playerid, 1);
public OnPlayerDisconnect(playerid, reason) return KillTimer(TankTimer{playerid});
public OnPlayerStateChange(playerid, newstate, oldstate)
{
    if(GetPVarInt(playerid, "TLOff") == 1) return 1;
	if(newstate == PLAYER_STATE_DRIVER)
	{
	    for(new i = 0; i < sizeof(tank); i++)
		{
			if(!IsPlayerInVehicle(playerid, tank[i])) continue;
			new hour, minute;
			GetPlayerTime(playerid, hour, minute);
			#pragma unused minute
			if(hour < 6 || hour > 21)
			{
				switch(i)
				{
					case 0:
					{
					    for(new k = 0; k < 2; k++) tlight[k] = CreateObject(19280, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
						AttachObjectToVehicle(tlight[0], tank[0], 1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
						AttachObjectToVehicle(tlight[1], tank[0], -1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
					}
					case 1:
					{
					    for(new k = 2; k < 4; k++) tlight[k] = CreateObject(19280, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
						AttachObjectToVehicle(tlight[2], tank[1], 1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
						AttachObjectToVehicle(tlight[3], tank[1], -1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
					}
					case 2:
					{
					    for(new k = 4; k < 6; k++) tlight[k] = CreateObject(19280, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
						AttachObjectToVehicle(tlight[4], tank[2], 1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
						AttachObjectToVehicle(tlight[5], tank[2], -1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
					}
					default: return 1;
				}
				TankTimer{playerid} = SetTimerEx("CheckTank", TANK_LIGHTS_SYNC_DELAY, 1, "ii", playerid, tank[i]);
			}
			break;
		}
	}
	if(oldstate == PLAYER_STATE_DRIVER && newstate != PLAYER_STATE_DRIVER)
	{
		for(new i = 0; i < sizeof(tank); i++)
		{
			if(!IsPlayerInVehicle(playerid, tank[i])) continue;
			switch(i)
			{
				case 0: for(new k = 0; k < 2; k++) if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
				case 1: for(new k = 2; k < 4; k++) if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
				case 2: for(new k = 4; k < 6; k++) if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
				default: return 1;
			}
			KillTimer(TankTimer{playerid});
			break;
		}
	}
	return 1;
}
public OnPlayerCommandText(playerid, cmdtext[])
{
	new cmd[256], idx;
	cmd = strtok(cmdtext, idx);
	if(strcmp(cmd, "/time", true) == 0)
	{
		if(!IsPlayerAdmin(playerid)) return 1;
		for(new i = GetMaxPlayers() - 1; i != -1; i--)
		{
			if(!IsPlayerConnected(i)) continue;
			SetPlayerTime(i, strval(strtok(cmdtext, idx)), 0);
		}
		return 1;
	}
	if(strcmp(cmdtext, "/tloff", true) == 0)
	{
		for(new i = 0; i < sizeof(tank); i++)
		{
			if(!IsPlayerInVehicle(playerid, tank[i])) continue;
			switch(i)
			{
				case 0: for(new k = 0; k < 2; k++) if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
				case 1: for(new k = 2; k < 4; k++) if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
				case 2: for(new k = 4; k < 6; k++) if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
				default: return 1;
			}
			KillTimer(TankTimer{playerid});
			SetPVarInt(playerid, "TLOff", 1);
			break;
		}
	    return 1;
	}
	if(strcmp(cmdtext, "/tlon", true) == 0)
	{
		for(new i = 0; i < sizeof(tank); i++)
		{
			if(!IsPlayerInVehicle(playerid, tank[i])) continue;
			switch(i)
			{
				case 0:
				{
				    for(new k = 0; k < 2; k++)
					{
						if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
						tlight[k] = CreateObject(19280, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
					}
					AttachObjectToVehicle(tlight[0], tank[0], 1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
					AttachObjectToVehicle(tlight[1], tank[0], -1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
				}
				case 1:
				{
				    for(new k = 2; k < 4; k++)
					{
						if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
						tlight[k] = CreateObject(19280, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
					}
					AttachObjectToVehicle(tlight[2], tank[1], 1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
					AttachObjectToVehicle(tlight[3], tank[1], -1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
				}
				case 2:
				{
				    for(new k = 4; k < 6; k++)
					{
						if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
						tlight[k] = CreateObject(19280, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
					}
					AttachObjectToVehicle(tlight[4], tank[2], 1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
					AttachObjectToVehicle(tlight[5], tank[2], -1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
				}
				default: return 1;
			}
			DeletePVar(playerid, "TLOff");
			break;
		}
	    return 1;
	}
	return 0;
}
forward CheckTank(playerid, vehicleid);
public CheckTank(playerid, vehicleid)
{
    if(GetPVarInt(playerid, "TLOff") == 1) return 1;
    for(new i = 0; i < sizeof(tank); i++)
	{
		if(!IsPlayerInVehicle(playerid, tank[i])) continue;
		new hour, minute;
		GetPlayerTime(playerid, hour, minute);
		#pragma unused minute
		if(hour > 5 && hour < 22)
		{
			switch(i)
			{
				case 0: for(new k = 0; k < 2; k++) if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
				case 1: for(new k = 2; k < 4; k++) if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
				case 2: for(new k = 4; k < 6; k++) if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
				default: return 1;
			}
		}
		else
		{
			switch(i)
			{
				case 0:
				{
				    for(new k = 0; k < 2; k++)
					{
						if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
						tlight[k] = CreateObject(19280, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
					}
					AttachObjectToVehicle(tlight[0], tank[0], 1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
					AttachObjectToVehicle(tlight[1], tank[0], -1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
				}
				case 1:
				{
				    for(new k = 2; k < 4; k++)
					{
						if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
						tlight[k] = CreateObject(19280, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
					}
					AttachObjectToVehicle(tlight[2], tank[1], 1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
					AttachObjectToVehicle(tlight[3], tank[1], -1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
				}
				case 2:
				{
				    for(new k = 4; k < 6; k++)
					{
						if(IsValidObject(tlight[k])) DestroyObject(tlight[k]);
						tlight[k] = CreateObject(19280, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
					}
					AttachObjectToVehicle(tlight[4], tank[2], 1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
					AttachObjectToVehicle(tlight[5], tank[2], -1.6, 3.83, 0.675, 15.075, 0.0, 0.0);
				}
				default: return 1;
			}
		}
	}
	return 1;
}
stock strtok(const string[], &index)
{
	new length = strlen(string);
	while ((index < length) && (string[index] <= ' ')) index++;
	new offset = index, result[20];
	while ((index < length) && (string[index] > ' ') && ((index - offset) < (sizeof(result) - 1))) result[index - offset] = string[index], index++;
	result[index - offset] = EOS;
	return result;
}
